// Revision: 97 1.13 source/ui/basectl/ivport.hpp, canvas, ioc.v400, 980918 
#ifndef _IVPORT_
  #define _IVPORT_
/*******************************************************************************
* FILE NAME: ivport.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IViewPort                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <inotify.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IColor;
class IScrollBar;
class IViewPortData;
class IViewRectangle;
class IWindowHandle;

#pragma enum(4)
#pragma pack(push,4)

class IViewPort : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  IViewPort ( unsigned long     windowIdentifier,
              IWindow*          parent,
              IWindow*          owner,
              const IRectangle& initialSize = IRectangle(),
              const Style&      style = defaultStyle() );

virtual
 ~IViewPort ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IViewPort, IWindow, ICanvas);
static const Style
  IC_IMPORTU alwaysHorizontalScrollBar,
  IC_IMPORTU asNeededHorizontalScrollBar,
  IC_IMPORTU noHorizontalScrollBar,
  IC_IMPORTU alwaysVerticalScrollBar,
  IC_IMPORTU asNeededVerticalScrollBar,
  IC_IMPORTU noVerticalScrollBar,
  IC_IMPORTU noViewWindowFill,
  IC_IMPORTU expandableViewWindow,
  IC_IMPORTU classDefaultStyle;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;

/*----------------------------- Child Scroll Bars ----------------------------*/
IScrollBar
 *horizontalScrollBar ( ) const,
 *verticalScrollBar   ( ) const;

/*------------------------------- View Window --------------------------------*/
virtual IWindowHandle
  viewWindow               ( );
virtual IViewPort
  &setViewWindow           ( const IWindowHandle& viewWindow );
virtual IRectangle
  viewWindowDrawRectangle  ( ) const;
virtual IViewPort
 &scrollViewVerticallyTo   ( unsigned long topOffset ),
 &scrollViewHorizontallyTo ( unsigned long leftOffset );
virtual IViewPort
 &setViewWindowSize        ( const ISize& size );
virtual ISize
  viewWindowSize           ( ) const;

/*------------------------------ Layout Support ------------------------------*/
virtual bool
  hasChildrenToLayout ( ) const;
virtual IViewPort
 &setLayoutDistorted  ( unsigned long layoutAttributeOn,
                        unsigned long layoutAttributeOff );

/*--------------------------- Notification Members ---------------------------*/
static INotificationId const
  IC_IMPORTU viewWindowSizeId;

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;
virtual IViewPort
 &layout          ( );

/*-------------------------------- View Window -------------------------------*/
virtual IViewPort
 &setupScrollBars     ( ),
 &positionViewWindow  ( const IWindowHandle& viewWindow,
                        const IRectangle& viewRectangle ),
 &setTopLeftViewPoint ( const IPoint& topLeft );

IPoint
  topLeftViewPoint    ( ) const;

/*-------------------------------- Attributes --------------------------------*/
virtual IWindowHandle
 handleForChildCreation ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IViewPort ( const IViewPort& viewPort );
IViewPort
 &operator= ( const IViewPort& viewPort );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;
IPoint
  ptClTopLeftView;
IScrollBar
 *psbClVert,
 *psbClHorz;
IViewRectangle
 *pcvClViewRect;
ISize
  sizClViewWindow;
IWindowHandle
  viewPortHwnd;

enum Flag { initialized=1, resizeHandlerAdded=2, scrollHandlerAdded=4,
            keyboardHandlerAdded=8, paintHandlerAdded=16,
            rectanglePaintHandlerAdded=32, useMinimumSizeView=64 };
unsigned long
  ulClFlag;

IViewPortData
 *fViewPortData;
}; // IViewPort

INESTEDBITFLAGCLASSFUNCS(Style, IViewPort)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ivport.inl>

#endif /* _IVPORT_ */
