// ----------------------------------------------------------------------------
// FILE NAME: iversion.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IVersion
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 02 1.4 source/core/base/iversion.hpp, appsupport, ioc.v400, 980918 
// ----------------------------------------------------------------------------
#ifndef _IVERSION_
#define _IVERSION_

#include <istream.hpp>
#include <ibase.hpp>
#include <idatstrm.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IVersion
{
public:
    // -------------------------- Constructors --------------------------------
    IVersion();
    IVersion(unsigned short aMajor, unsigned short aMinor);
    IVersion(const IVersion& aVersion);

    // ------------------------- Library Version ------------------------------
    static IVersion libraryVersion();

    // -------------------------- Diagnostics ---------------------------------
    IString         asString() const;

    // -------------------------- Version Query -------------------------------
    void            setMajor(unsigned short aMajor);
    void            setMinor(unsigned short aMinor);
    unsigned short  major();
    unsigned short  minor();

    // -------------------------- Comparisons ---------------------------------
    bool            operator==(const IVersion& aVersion) const;
    bool            operator!=(const IVersion& aVersion) const;
    bool            operator<(const IVersion& aVersion) const;
    bool            operator<=(const IVersion& aVersion) const;
    bool            operator>(const IVersion& aVersion) const;
    bool            operator>=(const IVersion& aVersion) const;

    // ------------------------- Streaming ------------------------------------
    void            operator>>=(IDataStream &toWhere);
    void            operator<<=(IDataStream &fromWhere);

protected:
    // ------------------------- Streaming ------------------------------------
    void            writeToStream(IDataStream &toWhere) const;
    void            readFromStream(IDataStream &fromWhere);

private:
    // -------------------------------- Private -------------------------------
    unsigned short  Major;
    unsigned short  Minor;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iversion.inl>

#endif // _IVERSION_
