// ----------------------------------------------------------------------------
// FILE NAME: ivbase.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IVBase
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
//  Revision: 09  1.5.1.4  source/core/base/ivbase.hpp, appsupport, ioc.v400, 980918  
// ----------------------------------------------------------------------------

#ifndef _IVBASE_
#define _IVBASE_

#include <iostream.h>
#include <ibase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class   IString;

class IC_EXPORTB IVBase : public IBase
{
public:
    // --------------------------- Constructors -------------------------------
    virtual ~IVBase();

    // --------------------------- Diagnostics --------------------------------
    friend ostream& IC_EXPORTB
    operator <<(ostream& aStream, const IVBase& anObject);

    virtual IString asString() const;
    virtual IString asDebugInfo() const;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

inline ostream& operator<<(ostream& aStream, const IVBase& anObject)
{
    return aStream << "IVBase object";
}

#endif // ( IC_OBSOLETE <= IC_OBSOLETE_3 )

#endif
