// Revision: 90 1.15.1.6 source/core/text/unicode/iusyms.hpp, text, ioc.v400, 980918 
// iusyms.hpp
/**
 * This file contains the classes UArror, UAPLFunctionalMap,
 * UControlCodePicture, UOCR, UCurrency, ULetterLikeSymbol,
 * UMathematicalOperators, UMiscellaneousTechnical,
 * UGeometricshapes, UDingbats, UZapfDingbats, UHarpoon,
 * UCJKSymbols, UStandardPhonetic which provide information
 * about the special symbols.
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */


#ifndef _IUSYMS_
#define _IUSYMS_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#include <ibase.hpp>

class UArrow;
class UAPLFunctionalSymbol;
class UControlCodePicture;
class UOCR;
class UCurrency;
class ULetterLikeSymbol;
class UMathematicalOperators;
class UMiscellaneousTechnical;
class UGeometricShapes;
class UDingbats;
class UZapfDingbats;
class UHarpoon;
class UCJKSymbols;
class UStandardPhonetic;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class UArrow
//=================================================================================

class UArrow {

public:

        enum EArrowNames {

                kModifierLetterLeftHead                                  = 0x02C2,
                kModifierLetterRightHead                                 = 0x02C3,
                kModifierLetterUpHead                                    = 0x02C4,
                kModifierLetterDownHead                                  = 0x02C5,
                kCombiningAnticlockwiseAbove                     = 0x20D4,
                kCombiningClockwiseAbove                                 = 0x20D5,
                kCombiningLeftAbove                                              = 0x20D6,
                kCombiningRightAbove                                     = 0x20D7,
                kCombiningLeftRightAbove                                 = 0x20E1,
                kLeftwards                                                               = 0x2190,
                kUpwards                                                                 = 0x2191,
                kRightwards                                                              = 0x2192,
                kDownwards                                                               = 0x2193,
                kLeftRight                                                               = 0x2194,
                kUpDown                                                                  = 0x2195,
                kNorthWest                                                               = 0x2196,
                kNorthEast                                                               = 0x2197,
                kSouthEast                                                               = 0x2198,
                kSouthWest                                                               = 0x2199,
                kLeftwardsWithStroke                                     = 0x219A,
                kRightwardsWithStroke                                    = 0x219B,
                kLeftwardsWave                                                   = 0x219C,
                kRightwardsWave                                                  = 0x219D,
                kLeftwardsTwoHeaded                                              = 0x219E,
                kUpwardsTwoHeaded                                                = 0x219F,
                kRightwardsTwoHeaded                                     = 0x21A0,
                kDownwardsTwoHeaded                                              = 0x21A1,
                kLeftwardsWithTail                                               = 0x21A2,
                kRightwardsWithTail                                              = 0x21A3,
                kLeftwardsFromBar                                                = 0x21A4,
                kUpwardsFromBar                                                  = 0x21A5,
                kRightwardsFromBar                                               = 0x21A6,
                kDownwardsFromBar                                                = 0x21A7,
                kUpDownWithBase                                                  = 0x21A8,
                kLeftwardsWithHook                                               = 0x21A9,
                kRightwardsWithHook                                              = 0x21AA,
                kLeftwardsWithLoop                                               = 0x21AB,
                kRightwardsWithLoop                                              = 0x21AC,
                kLeftRightWave                                                   = 0x21AD,
                kLeftRightWithStroke                                     = 0x21AE,
                kDownwardsZigzag                                                 = 0x21AF,
                kUpwardsWithTipLeftwards                                 = 0x21B0,
                kUpwardsWithTipRightwards                                = 0x21B1,
                kDownwardsWithTipLeftwards                               = 0x21B2,
                kDownwardsWithTipRightwards                              = 0x21B3,
                kRightwardsWithCornerDownwards                   = 0x21B4,
                kDownwardsWithCornerLeftwards                    = 0x21B5,
                kAnticlockwiseTopSemicircle                              = 0x21B6,
                kClockwiseTopSemicircle                                  = 0x21B7,
                kNorthWestToLongBar                                              = 0x21B8,
                kLeftwardsToBarOverRightwardsToBar               = 0x21B9,
                kAnticlockwiseOpenCircle                                 = 0x21BA,
                kClockwiseOpenCircle                                     = 0x21BB,
                kRightwardsOverLeftwards                                 = 0x21C4,
                kUpwardsLeftwardsOfDownwards                     = 0x21C5,
                kLeftwardsOverRightwards                                 = 0x21C6,
                kLeftwardsPairedS                                                = 0x21C7,
                kUpwardsPairedS                                                  = 0x21C8,
                kRightwardsPairedS                                               = 0x21C9,
                kDownwardsPairedS                                                = 0x21CA,
                kLeftwardsDoubleWithStroke                               = 0x21CD,
                kLeftRightDoubleWithStroke                               = 0x21CE,
                kRightwardsDoubleWithStroke                              = 0x21CF,
                kLeftwardsDouble                                                 = 0x21D0,
                kUpwardsDouble                                                   = 0x21D1,
                kRightwardsDouble                                                = 0x21D2,
                kDownwardsDouble                                                 = 0x21D3,
                kLeftRightDouble                                                 = 0x21D4,
                kUpDownDouble                                                    = 0x21D5,
                kNorthWestDouble                                                 = 0x21D6,
                kNorthEastDouble                                                 = 0x21D7,
                kSouthEastDouble                                                 = 0x21D8,
                kSouthWestDouble                                                 = 0x21D9,
                kLeftwardsTriple                                                 = 0x21DA,
                kRightwardsTriple                                                = 0x21DB,
                kLeftwardsSquiggle                                               = 0x21DC,
                kRightwardsSquiggle                                              = 0x21DD,
                kUpwardsWithDoubleStroke                                 = 0x21DE,
                kDownwardsWithDoubleStroke                               = 0x21DF,
                kLeftwardsDashed                                                 = 0x21E0,
                kUpwardsDashed                                                   = 0x21E1,
                kRightwardsDashed                                                = 0x21E2,
                kDownwardsDashed                                                 = 0x21E3,
                kLeftwardsToBar                                                  = 0x21E4,
                kRightwardsToBar                                                 = 0x21E5,
                kLeftwardsWhite                                                  = 0x21E6,
                kUpwardsWhite                                                    = 0x21E7,
                kRightwardsWhite                                                 = 0x21E8,
                kDownwardsWhite                                                  = 0x21E9,
                kUpwardsWhiteFromBar                                     = 0x21EA,
                kUpHead                                                                  = 0x2303,
                kDownHead                                                                = 0x2304,
                kUpHeadBetweenTwoHorizontalBars                  = 0x2324,
                kAplFunctionalSymbolQuadLeftwards                = 0x2347,
                kAplFunctionalSymbolQuadRightwards               = 0x2348,
                kAplFunctionalSymbolQuadUpwards                  = 0x2350,
                kAplFunctionalSymbolQuadDownwards                = 0x2357,
                kHeavyWideHeadedRightwards                               = 0x2794,
                kHeavySouthEast                                                  = 0x2798,
                kHeavyRightwards                                                 = 0x2799,
                kHeavyNorthEast                                                  = 0x279A,
                kDraftingPointRightwards                                 = 0x279B,
                kHeavyRoundTippedRightwards                              = 0x279C,
                kTriangleHeadedRightwards                                = 0x279D,
                kHeavyTriangleHeadedRightwards                   = 0x279E,
                kDashedTriangleHeadedRightwards                  = 0x279F,
                kHeavyDashedTriangleHeadedRightwards     = 0x27A0,
                kBlackRightwards                                                 = 0x27A1,
                kThreeDTopLightedRightwardsHead                  = 0x27A2,
                kThreeDBottomLightedRightwardsHead               = 0x27A3,
                kBlackRightwardsHead                                     = 0x27A4,
                kHeavyBlackCurvedDownwardsAndRightwards  = 0x27A5,
                kHeavyBlackCurvedUpwardsAndRightwards    = 0x27A6,
                kSquatBlackRightwards                                    = 0x27A7,
                kHeavyConcavePointedBlackRightwards              = 0x27A8,
                kRightShadedWhiteRightwards                              = 0x27A9,
                kLeftShadedWhiteRightwards                               = 0x27AA,
                kBackTiltedShadowedWhiteRightwards               = 0x27AB,
                kFrontTiltedShadowedWhiteRightwards              = 0x27AC,
                kHeavyLowerRightShadowedWhiteRightwards  = 0x27AD,
                kHeavyUpperRightShadowedWhiteRightwards  = 0x27AE,
                kNotchedLowerRightShadowedWhiteRightwards = 0x27AF,
                kNotchedUpperRightShadowedWhiteRightwards = 0x27B1,
                kCircledHeavyWhiteRightwards                     = 0x27B2,
                kWhiteFeatheredRightwards                                = 0x27B3,
                kBlackFeatheredSouthEast                                 = 0x27B4,
                kBlackFeatheredRightwards                                = 0x27B5,
                kBlackFeatheredNorthEast                                 = 0x27B6,
                kHeavyBlackFeatheredSouthEast                    = 0x27B7,
                kHeavyBlackFeatheredRightwards                   = 0x27B8,
                kHeavyBlackFeatheredNorthEast                    = 0x27B9,
                kTeardropBarbedRightwards                                = 0x27BA,
                kHeavyTeardropShankedRightwards                  = 0x27BB,
                kWedgeTailedRightwards                                   = 0x27BC,
                kHeavyWedgeTailedRightwards                              = 0x27BD,
                kOpenOutlinedRightwards                                  = 0x27BE
        };

private:

};







//=================================================================================
// class UAPLFunctionalSymbol
//=================================================================================

class UAPLFunctionalSymbol {

public:

        enum EAPLFunctionalSymbolNames {

                kIBeam                                                                   = 0x2336,
                kSquishQuad                                                              = 0x2337,
                kQuadEqual                                                               = 0x2338,
                kQuadDivide                                                              = 0x2339,
                kQuadDiamond                                                     = 0x233A,
                kQuadJot                                                                 = 0x233B,
                kQuadCircle                                                              = 0x233C,
                kCircleStile                                                     = 0x233D,
                kCircleJot                                                               = 0x233E,
                kSlashBar                                                                = 0x233F,
                kBackslashBar                                                    = 0x2340,
                kQuadSlash                                                               = 0x2341,
                kQuadBackslash                                                   = 0x2342,
                kQuadLessThan                                                    = 0x2343,
                kQuadGreaterThan                                                 = 0x2344,
                kLeftwardsVane                                                   = 0x2345,
                kRightwardsVane                                                  = 0x2346,
                kQuadLeftwardsArrow                                              = 0x2347,
                kQuadRightwardsArrow                                     = 0x2348,
                kCircleBackslash                                                 = 0x2349,
                kDownTackUnderbar                                                = 0x234A,
                kDeltaStile                                                              = 0x234B,
                kQuadDownCaret                                                   = 0x234C,
                kQuadDelta                                                               = 0x234D,
                kDownTackJot                                                     = 0x234E,
                kUpwardsVane                                                     = 0x234F,
                kQuadUpwardsArrow                                                = 0x2350,
                kUpTackOverbar                                                   = 0x2351,
                kDelStile                                                                = 0x2352,
                kQuadUpCaret                                                     = 0x2353,
                kQuadDel                                                                 = 0x2354,
                kUpTackJot                                                               = 0x2355,
                kDownwardsVane                                                   = 0x2356,
                kQuadDownwardsArrow                                              = 0x2357,
                kQuoteUnderbar                                                   = 0x2358,
                kDeltaUnderbar                                                   = 0x2359,
                kDiamondUnderbar                                                 = 0x235A,
                kJotUnderbar                                                     = 0x235B,
                kCircleUnderbar                                                  = 0x235C,
                kUpShoeJot                                                               = 0x235D,
                kQuoteQuad                                                               = 0x235E,
                kCircleStar                                                              = 0x235F,
                kQuadColon                                                               = 0x2360,
                kUpTackDiaeresis                                                 = 0x2361,
                kDelDiaeresis                                                    = 0x2362,
                kStarDiaeresis                                                   = 0x2363,
                kJotDiaeresis                                                    = 0x2364,
                kCircleDiaeresis                                                 = 0x2365,
                kDownShoeStile                                                   = 0x2366,
                kLeftShoeStile                                                   = 0x2367,
                kTildeDiaeresis                                                  = 0x2368,
                kGreaterThanDiaeresis                                    = 0x2369,
                kCommaBar                                                                = 0x236A,
                kDelTilde                                                                = 0x236B,
                kZilde                                                                   = 0x236C,
                kStileTilde                                                              = 0x236D,
                kSemicolonUnderbar                                               = 0x236E,
                kQuadNotEqual                                                    = 0x236F,
                kQuadQuestion                                                    = 0x2370,
                kDownCaretTilde                                                  = 0x2371,
                kUpCaretTilde                                                    = 0x2372,
                kIota                                                                    = 0x2373,
                kRho                                                                     = 0x2374,
                kOmega                                                                   = 0x2375,
                kAlphaUnderbar                                                   = 0x2376,
                kEpsilonUnderbar                                                 = 0x2377,
                kIotaUnderbar                                                    = 0x2378,
                kOmegaUnderbar                                                   = 0x2379,
                kAlpha                                                                   = 0x237A
        };

private:

};







//=================================================================================
// class UControlCodePicture
//=================================================================================

class UControlCodePicture {

public:

        enum EControlCodePictureNames {

                kNull                                                                    = 0x2400,
                kStartOfHeading                                                  = 0x2401,
                kStartOfText                                                     = 0x2402,
                kEndOfText                                                               = 0x2403,
                kEndOfTransmission                                               = 0x2404,
                kEnquiry                                                                 = 0x2405,
                kAcknowledge                                                     = 0x2406,
                kBell                                                                    = 0x2407,
                kBackspace                                                               = 0x2408,
                kHorizontalTabulation                                    = 0x2409,
                kLineFeed                                                                = 0x240A,
                kVerticalTabulation                                              = 0x240B,
                kFormFeed                                                                = 0x240C,
                kCarriageReturn                                                  = 0x240D,
                kShiftOut                                                                = 0x240E,
                kShiftIn                                                                 = 0x240F,
                kDataLinkEscape                                                  = 0x2410,
                kDeviceControlOne                                                = 0x2411,
                kDeviceControlTwo                                                = 0x2412,
                kDeviceControlThree                                              = 0x2413,
                kDeviceControlFour                                               = 0x2414,
                kNegativeAcknowledge                                     = 0x2415,
                kSynchronousIdle                                                 = 0x2416,
                kEndOfTransmissionBlock                                  = 0x2417,
                kCancel                                                                  = 0x2418,
                kEndOfMedium                                                     = 0x2419,
                kSubstitute                                                              = 0x241A,
                kEscape                                                                  = 0x241B,
                kFileSeparator                                                   = 0x241C,
                kGroupSeparator                                                  = 0x241D,
                kRecordSeparator                                                 = 0x241E,
                kUnitSeparator                                                   = 0x241F,
                kSpace                                                                   = 0x2420,
                kDelete                                                                  = 0x2421,
                kBlankSymbol                                                     = 0x2422,
                kOpenBox                                                                 = 0x2423,
                kNewline                                                                 = 0x2424
        };

private:

};







//=================================================================================
// class UOCR
//=================================================================================

class UOCR {

public:

        enum EOCRNames {

                kHook                                                                    = 0x2440,
                kChair                                                                   = 0x2441,
                kFork                                                                    = 0x2442,
                kInvertedFork                                                    = 0x2443,
                kBeltBuckle                                                              = 0x2444,
                kBowTie                                                                  = 0x2445,
                kBranchBankIdentification                                = 0x2446,
                kAmountOfCheck                                                   = 0x2447,
                kDash                                                                    = 0x2448,
                kCustomerAccountNumber                                   = 0x2449,
                kDoubleBackslash                                                 = 0x244A
        };

private:

};






//=================================================================================
// class UCurrency
//=================================================================================

class UCurrency {

public:

        enum ECurrencyNames {

                kDollarSign                                                              = 0x0024,
                kCentSign                                                                = 0x00A2,
                kPoundSign                                                               = 0x00A3,
                kYenSign                                                                 = 0x00A5,
                #if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
                kEuroCurrencySign                                                = 0x20A0,
                #endif
                kColonSign                                                               = 0x20A1,
                kCruzeiroSign                                                    = 0x20A2,
                kFrenchFrancSign                                                 = 0x20A3,
                kLiraSign                                                                = 0x20A4,
                kMillSign                                                                = 0x20A5,
                kNairaSign                                                               = 0x20A6,
                kPesetaSign                                                              = 0x20A7,
                kRupeeSign                                                               = 0x20A8,
                kWonSign                                                                 = 0x20A9,
                kNewSheqelSign                                                   = 0x20AA,
                kDongSign                                = 0x20AB,
                kEuroSign                                                = 0x20AC,
                kHistoricEuroSign                                                = 0x20A0
        };

private:

};







//=================================================================================
// class ULetterLikeSymbol
//=================================================================================

class ULetterLikeSymbol {

public:

        enum ELetterLikeSymbolNames {

                kAccountOf                                                               = 0x2100,
                kAddressedToTheSubject                                   = 0x2101,
                kDoubleStruckCapitalC                                    = 0x2102,
                kDegreeCelsius                                                   = 0x2103,
                kCentreLineSymbol                                                = 0x2104,
                kCareOf                                                                  = 0x2105,
                kCadaUna                                                                 = 0x2106,
                kEulerConstant                                                   = 0x2107,
                kScruple                                                                 = 0x2108,
                kDegreeFahrenheit                                                = 0x2109,
                kScriptSmallG                                                    = 0x210A,
                kScriptCapitalH                                                  = 0x210B,
                kBlackLetterCapitalH                                     = 0x210C,
                kDoubleStruckCapitalH                                    = 0x210D,
                kPlanckConstant                                                  = 0x210E,
                kPlanckConstantOverTwoPi                                 = 0x210F,
                kScriptCapitalI                                                  = 0x2110,
                kBlackLetterCapitalI                                     = 0x2111,
                kScriptCapitalL                                                  = 0x2112,
                kScriptSmallL                                                    = 0x2113,
                kLBBarSymbol                                                     = 0x2114,
                kDoubleStruckCapitalN                                    = 0x2115,
                kNumeroSign                                                              = 0x2116,
                kSoundRecordingCopyright                                 = 0x2117,
                kScriptCapitalP                                                  = 0x2118,
                kDoubleStruckCapitalP                                    = 0x2119,
                kDoubleStruckCapitalQ                                    = 0x211A,
                kScriptCapitalR                                                  = 0x211B,
                kBlackLetterCapitalR                                     = 0x211C,
                kDoubleStruckCapitalR                                    = 0x211D,
                kPrescriptionTake                                                = 0x211E,
                kResponse                                                                = 0x211F,
                kServiceMark                                                     = 0x2120,
                kTelephoneSign                                                   = 0x2121,
                kTradeMarkSign                                                   = 0x2122,
                kVersicle                                                                = 0x2123,
                kDoubleStruckCapitalZ                                    = 0x2124,
                kOunceSign                                                               = 0x2125,
                kOhmSign                                                                 = 0x2126,
                kInvertedOhmSign                                                 = 0x2127,
                kBlackLetterCapitalZ                                     = 0x2128,
                kTurnedGreekSmallLetterIota                              = 0x2129,
                kKelvinSign                                                              = 0x212A,
                kAngstromSign                                                    = 0x212B,
                kScriptCapitalB                                                  = 0x212C,
                kBlackLetterCapitalC                                     = 0x212D,
                kEstimatedSymbol                                                 = 0x212E,
                kScriptSmallE                                                    = 0x212F,
                kScriptCapitalE                                                  = 0x2130,
                kScriptCapitalF                                                  = 0x2131,
                kTurnedCapitalF                                                  = 0x2132,
                kScriptCapitalM                                                  = 0x2133,
                kScriptSmallO                                                    = 0x2134,
                kAlefSymbol                                                              = 0x2135,
                kBetSymbol                                                               = 0x2136,
                kGimelSymbol                                                     = 0x2137,
                kDaletSymbol                                                     = 0x2138,

                //      Values derived from Unicode 1.0 names

                kFirstTransfiniteCardinal                                = kAlefSymbol,
                kSecondTransfiniteCardinal                               = kBetSymbol,
                kThirdTransfiniteCardinal                                = kGimelSymbol,
                kFourthTransfiniteCardinal                               = kDaletSymbol
        };

private:

};







//=================================================================================
// class UMathematicalOperators
//=================================================================================

class UMathematicalOperators {

public:

        enum EMathematicalOperatorsNames {

                kForAll                                                                  = 0x2200,
                kComplement                                                              = 0x2201,
                kPartialDifferential                                     = 0x2202,
                kThereExists                                                     = 0x2203,
                kThereDoesNotExist                                               = 0x2204,
                kEmptySet                                                                = 0x2205,
                kIncrement                                                               = 0x2206,
                kNabla                                                                   = 0x2207,
                kElementOf                                                               = 0x2208,
                kNotAnElementOf                                                  = 0x2209,
                kSmallElementOf                                                  = 0x220A,
                kContainsAsMember                                                = 0x220B,
                kDoesNotContainAsMember                                  = 0x220C,
                kSmallContainsAsMember                                   = 0x220D,
                kEndOfProof                                                              = 0x220E,
                kNAryProduct                                                     = 0x220F,
                kNAryCoproduct                                                   = 0x2210,
                kNArySummation                                                   = 0x2211,
                kMinusSign                                                               = 0x2212,
                kMinusOrPlusSign                                                 = 0x2213,
                kDotPlus                                                                 = 0x2214,
                kDivisionSlash                                                   = 0x2215,
                kSetMinus                                                                = 0x2216,
                kAsteriskOperator                                                = 0x2217,
                kRingOperator                                                    = 0x2218,
                kBulletOperator                                                  = 0x2219,
                kSquareRoot                                                              = 0x221A,
                kCubeRoot                                                                = 0x221B,
                kFourthRoot                                                              = 0x221C,
                kProportionalTo                                                  = 0x221D,
                kInfinity                                                                = 0x221E,
                kRightAngle                                                              = 0x221F,
                kAngle                                                                   = 0x2220,
                kMeasuredAngle                                                   = 0x2221,
                kSphericalAngle                                                  = 0x2222,
                kDivides                                                                 = 0x2223,
                kDoesNotDivide                                                   = 0x2224,
                kParallelTo                                                              = 0x2225,
                kNotParallelTo                                                   = 0x2226,
                kLogicalAnd                                                              = 0x2227,
                kLogicalOr                                                               = 0x2228,
                kIntersection                                                    = 0x2229,
                kUnion                                                                   = 0x222A,
                kIntegral                                                                = 0x222B,
                kDoubleIntegral                                                  = 0x222C,
                kTripleIntegral                                                  = 0x222D,
                kContourIntegral                                                 = 0x222E,
                kSurfaceIntegral                                                 = 0x222F,
                kVolumeIntegral                                                  = 0x2230,
                kClockwiseIntegral                                               = 0x2231,
                kClockwiseContourIntegral                                = 0x2232,
                kAnticlockwiseContourIntegral                    = 0x2233,
                kTherefore                                                               = 0x2234,
                kBecause                                                                 = 0x2235,
                kRatio                                                                   = 0x2236,
                kProportion                                                              = 0x2237,
                kDotMinus                                                                = 0x2238,
                kExcess                                                                  = 0x2239,
                kGeometricProportion                                     = 0x223A,
                kHomothetic                                                              = 0x223B,
                kTildeOperator                                                   = 0x223C,
                kReversedTilde                                                   = 0x223D,
                kInvertedLazyS                                                   = 0x223E,
                kSineWave                                                                = 0x223F,
                kWreathProduct                                                   = 0x2240,
                kNotTilde                                                                = 0x2241,
                kMinusTilde                                                              = 0x2242,
                kAsymptoticallyEqualTo                                   = 0x2243,
                kNotAsymptoticallyEqualTo                                = 0x2244,
                kApproximatelyEqualTo                                    = 0x2245,
                kApproximatelyButNotActuallyEqualTo              = 0x2246,
                kNeitherApproximatelyNorActuallyEqualTo  = 0x2247,
                kAlmostEqualTo                                                   = 0x2248,
                kNotAlmostEqualTo                                                = 0x2249,
                kAlmostEqualOrEqualTo                                    = 0x224A,
                kTripleTilde                                                     = 0x224B,
                kAllEqualTo                                                              = 0x224C,
                kEquivalentTo                                                    = 0x224D,
                kGeometricallyEquivalentTo                               = 0x224E,
                kDifferenceBetween                                               = 0x224F,
                kApproachesTheLimit                                              = 0x2250,
                kGeometricallyEqualTo                                    = 0x2251,
                kApproximatelyEqualToOrTheImageOf                = 0x2252,
                kImageOfOrApproximatelyEqualTo                   = 0x2253,
                kColonEquals                                                     = 0x2254,
                kEqualsColon                                                     = 0x2255,
                kRingInEqualTo                                                   = 0x2256,
                kRingEqualTo                                                     = 0x2257,
                kCorrespondsTo                                                   = 0x2258,
                kEstimates                                                               = 0x2259,
                kEquiangularTo                                                   = 0x225A,
                kStarEquals                                                              = 0x225B,
                kDeltaEqualTo                                                    = 0x225C,
                kEqualToByDefinition                                     = 0x225D,
                kMeasuredBy                                                              = 0x225E,
                kQuestionedEqualTo                                               = 0x225F,
                kNotEqualTo                                                              = 0x2260,
                kIdenticalTo                                                     = 0x2261,
                kNotIdenticalTo                                                  = 0x2262,
                kStrictlyEquivalentTo                                    = 0x2263,
                kLessThanOrEqualTo                                               = 0x2264,
                kGreaterThanOrEqualTo                                    = 0x2265,
                kLessThanOverEqualTo                                     = 0x2266,
                kGreaterThanOverEqualTo                                  = 0x2267,
                kLessThanButNotEqualTo                                   = 0x2268,
                kGreaterThanButNotEqualTo                                = 0x2269,
                kMuchLessThan                                                    = 0x226A,
                kMuchGreaterThan                                                 = 0x226B,
                kBetween                                                                 = 0x226C,
                kNotEquivalentTo                                                 = 0x226D,
                kNotLessThan                                                     = 0x226E,
                kNotGreaterThan                                                  = 0x226F,
                kNeitherLessThanNorEqualTo                               = 0x2270,
                kNeitherGreaterThanNorEqualTo                    = 0x2271,
                kLessThanOrEquivalentTo                                  = 0x2272,
                kGreaterThanOrEquivalentTo                               = 0x2273,
                kNeitherLessThanNorEquivalentTo                  = 0x2274,
                kNeitherGreaterThanNorEquivalentTo               = 0x2275,
                kLessThanOrGreaterThan                                   = 0x2276,
                kGreaterThanOrLessThan                                   = 0x2277,
                kNeitherLessThanNorGreaterThan                   = 0x2278,
                kNeitherGreaterThanNorLessThan                   = 0x2279,
                kPrecedes                                                                = 0x227A,
                kSucceeds                                                                = 0x227B,
                kPrecedesOrEqualTo                                               = 0x227C,
                kSucceedsOrEqualTo                                               = 0x227D,
                kPrecedesOrEquivalentTo                                  = 0x227E,
                kSucceedsOrEquivalentTo                                  = 0x227F,
                kDoesNotPrecede                                                  = 0x2280,
                kDoesNotSucceed                                                  = 0x2281,
                kSubsetOf                                                                = 0x2282,
                kSupersetOf                                                              = 0x2283,
                kNotASubsetOf                                                    = 0x2284,
                kNotASupersetOf                                                  = 0x2285,
                kSubsetOfOrEqualTo                                               = 0x2286,
                kSupersetOfOrEqualTo                                     = 0x2287,
                kNeitherASubsetOfNorEqualTo                              = 0x2288,
                kNeitherASupersetOfNorEqualTo                    = 0x2289,
                kSubsetOfWithNotEqualTo                                  = 0x228A,
                kSupersetOfWithNotEqualTo                                = 0x228B,
                kMultiset                                                                = 0x228C,
                kMultisetMultiplication                                  = 0x228D,
                kMultisetUnion                                                   = 0x228E,
                kSquareImageOf                                                   = 0x228F,
                kSquareOriginalOf                                                = 0x2290,
                kSquareImageOfOrEqualTo                                  = 0x2291,
                kSquareOriginalOfOrEqualTo                               = 0x2292,
                kSquareCap                                                               = 0x2293,
                kSquareCup                                                               = 0x2294,
                kCircledPlus                                                     = 0x2295,
                kCircledMinus                                                    = 0x2296,
                kCircledTimes                                                    = 0x2297,
                kCircledDivisionSlash                                    = 0x2298,
                kCircledDotOperator                                              = 0x2299,
                kCircledRingOperator                                     = 0x229A,
                kCircledAsteriskOperator                                 = 0x229B,
                kCircledEquals                                                   = 0x229C,
                kCircledDash                                                     = 0x229D,
                kSquaredPlus                                                     = 0x229E,
                kSquaredMinus                                                    = 0x229F,
                kSquaredTimes                                                    = 0x22A0,
                kSquaredDotOperator                                              = 0x22A1,
                kRightTack                                                               = 0x22A2,
                kLeftTack                                                                = 0x22A3,
                kDownTack                                                                = 0x22A4,
                kUpTack                                                                  = 0x22A5,
                kAssertion                                                               = 0x22A6,
                kModels                                                                  = 0x22A7,
                kTrue                                                                    = 0x22A8,
                kForces                                                                  = 0x22A9,
                kTripleVerticalBarRightTurnstile                 = 0x22AA,
                kDoubleVerticalBarDoubleRightTurnstile   = 0x22AB,
                kDoesNotProve                                                    = 0x22AC,
                kNotTrue                                                                 = 0x22AD,
                kDoesNotForce                                                    = 0x22AE,
                kNegatedDoubleVerticalBarDoubleRightTurnstile = 0x22AF,
                kPrecedesUnderRelation                                   = 0x22B0,
                kSucceedsUnderRelation                                   = 0x22B1,
                kNormalSubgroupOf                                                = 0x22B2,
                kContainsAsNormalSubgroup                                = 0x22B3,
                kNormalSubgroupOfOrEqualTo                               = 0x22B4,
                kContainsAsNormalSubgroupOrEqualTo               = 0x22B5,
                kOriginalOf                                                              = 0x22B6,
                kImageOf                                                                 = 0x22B7,
                kMultimap                                                                = 0x22B8,
                kHermitianConjugateMatrix                                = 0x22B9,
                kIntercalate                                                     = 0x22BA,
                kXor                                                                     = 0x22BB,
                kNand                                                                    = 0x22BC,
                kNor                                                                     = 0x22BD,
                kRightAngleWithArc                                               = 0x22BE,
                kRightTriangle                                                   = 0x22BF,
                kNAryLogicalAnd                                                  = 0x22C0,
                kNAryLogicalOr                                                   = 0x22C1,
                kNAryIntersection                                                = 0x22C2,
                kNAryUnion                                                               = 0x22C3,
                kDiamondOperator                                                 = 0x22C4,
                kDotOperator                                                     = 0x22C5,
                kStarOperator                                                    = 0x22C6,
                kDivisionTimes                                                   = 0x22C7,
                kBowtie                                                                  = 0x22C8,
                kLeftNormalFactorSemidirectProduct               = 0x22C9,
                kRightNormalFactorSemidirectProduct              = 0x22CA,
                kLeftSemidirectProduct                                   = 0x22CB,
                kRightSemidirectProduct                                  = 0x22CC,
                kReversedTildeEquals                                     = 0x22CD,
                kCurlyLogicalOr                                                  = 0x22CE,
                kCurlyLogicalAnd                                                 = 0x22CF,
                kDoubleSubset                                                    = 0x22D0,
                kDoubleSuperset                                                  = 0x22D1,
                kDoubleIntersection                                              = 0x22D2,
                kDoubleUnion                                                     = 0x22D3,
                kPitchfork                                                               = 0x22D4,
                kEqualAndParallelTo                                              = 0x22D5,
                kLessThanWithDot                                                 = 0x22D6,
                kGreaterThanWithDot                                              = 0x22D7,
                kVeryMuchLessThan                                                = 0x22D8,
                kVeryMuchGreaterThan                                     = 0x22D9,
                kLessThanEqualToOrGreaterThan                    = 0x22DA,
                kGreaterThanEqualToOrLessThan                    = 0x22DB,
                kEqualToOrLessThan                                               = 0x22DC,
                kEqualToOrGreaterThan                                    = 0x22DD,
                kEqualToOrPrecedes                                               = 0x22DE,
                kEqualToOrSucceeds                                               = 0x22DF,
                kDoesNotPrecedeOrEqual                                   = 0x22E0,
                kDoesNotSucceedOrEqual                                   = 0x22E1,
                kNotSquareImageOfOrEqualTo                               = 0x22E2,
                kNotSquareOriginalOfOrEqualTo                    = 0x22E3,
                kSquareImageOfOrNotEqualTo                               = 0x22E4,
                kSquareOriginalOfOrNotEqualTo                    = 0x22E5,
                kLessThanButNotEquivalentTo                              = 0x22E6,
                kGreaterThanButNotEquivalentTo                   = 0x22E7,
                kPrecedesButNotEquivalentTo                              = 0x22E8,
                kSucceedsButNotEquivalentTo                              = 0x22E9,
                kNotNormalSubgroupOf                                     = 0x22EA,
                kDoesNotContainAsNormalSubgroup                  = 0x22EB,
                kNotNormalSubgroupOfOrEqualTo                    = 0x22EC,
                kDoesNotContainAsNormalSubgroupOrEqual   = 0x22ED,
                kVerticalEllipsis                                                = 0x22EE,
                kMidlineHorizontalEllipsis                               = 0x22EF,
                kUpRightDiagonalEllipsis                                 = 0x22F0,
                kDownRightDiagonalEllipsis                               = 0x22F1,

                //      Values derived from Unicode 1.0 names

                kColonEqual                                                      = kColonEquals,
                kEqualColon                                                      = kEqualsColon,
                kSubsetOfOrNotEqualTo                                    = kSubsetOfWithNotEqualTo,
                kSupersetOfOrNotEqualTo                                  = kSupersetOfWithNotEqualTo
        };

private:

};






//=================================================================================
// class UMiscellaneousTechnical
//=================================================================================

class UMiscellaneousTechnical {

public:

        enum EMiscellaneousTechnicalNames {

                kDiameterSign                                                    = 0x2300,
                kHouse                                                                   = 0x2302,
                kUpArrowhead                                                     = 0x2303,
                kDownArrowhead                                                   = 0x2304,
                kProjective                                                              = 0x2305,
                kPerspective                                                     = 0x2306,
                kWavyLine                                                                = 0x2307,
                kLeftCeiling                                                     = 0x2308,
                kRightCeiling                                                    = 0x2309,
                kLeftFloor                                                               = 0x230A,
                kRightFloor                                                              = 0x230B,
                kBottomRightCrop                                                 = 0x230C,
                kBottomLeftCrop                                                  = 0x230D,
                kTopRightCrop                                                    = 0x230E,
                kTopLeftCrop                                                     = 0x230F,
                kReversedNotSign                                                 = 0x2310,
                kSquareLozenge                                                   = 0x2311,
                kArc                                                                     = 0x2312,
                kSegment                                                                 = 0x2313,
                kSector                                                                  = 0x2314,
                kTelephoneRecorder                                               = 0x2315,
                kPositionIndicator                                               = 0x2316,
                kViewdataSquare                                                  = 0x2317,
                kPlaceOfInterestSign                                     = 0x2318,
                kTurnedNotSign                                                   = 0x2319,
                kWatch                                                                   = 0x231A,
                kHourglass                                                               = 0x231B,
                kTopLeftCorner                                                   = 0x231C,
                kTopRightCorner                                                  = 0x231D,
                kBottomLeftCorner                                                = 0x231E,
                kBottomRightCorner                                               = 0x231F,
                kTopHalfIntegral                                                 = 0x2320,
                kBottomHalfIntegral                                              = 0x2321,
                kFrown                                                                   = 0x2322,
                kSmile                                                                   = 0x2323,
                kUpArrowheadBetweenTwoHorizontalBars     = 0x2324,
                kOptionKey                                                               = 0x2325,
                kEraseToTheRight                                                 = 0x2326,
                kXInARectangleBox                                                = 0x2327,
                kKeyboard                                                                = 0x2328,
                kLeftPointingAngleBracket                                = 0x2329,
                kRightPointingAngleBracket                               = 0x232A,
                kEraseToTheLeft                                                  = 0x232B,
                kBenzeneRing                                                     = 0x232C,
                kCylindricity                                                    = 0x232D,
                kAllAroundProfile                                                = 0x232E,
                kSymmetry                                                                = 0x232F,
                kTotalRunout                                                     = 0x2330,
                kDimensionOrigin                                                 = 0x2331,
                kConicalTaper                                                    = 0x2332,
                kSlope                                                                   = 0x2333,
                kCounterbore                                                     = 0x2334,
                kCountersink                                                     = 0x2335,

                //      Values derived from Unicode 1.0 names

                kCommandKey                                                      = kPlaceOfInterestSign,
                kDeleteToTheRightKey                                     = kEraseToTheRight,
                kClearKey                                                                = kXInARectangleBox,
                kBra                                                                     = kLeftPointingAngleBracket,
                kKet                                                                     = kRightPointingAngleBracket,
                kDeleteToTheLeftKey                                      = kEraseToTheLeft
        };

private:

};









//=================================================================================
// class UGeometricShapes
//=================================================================================
class UGeometricShapes {

public:

        enum EGeometricShapesNames {

                kBlackSquare                                                     = 0x25A0,
                kWhiteSquare                                                     = 0x25A1,
                kWhiteSquareWithRoundedCorners                   = 0x25A2,
                kWhiteSquareContainingBlackSmallSquare   = 0x25A3,
                kSquareWithHorizontalFill                                = 0x25A4,
                kSquareWithVerticalFill                                  = 0x25A5,
                kSquareWithOrthogonalCrosshatchFill              = 0x25A6,
                kSquareWithUpperLeftToLowerRightFill     = 0x25A7,
                kSquareWithUpperRightToLowerLeftFill     = 0x25A8,
                kSquareWithDiagonalCrosshatchFill                = 0x25A9,
                kBlackSmallSquare                                                = 0x25AA,
                kWhiteSmallSquare                                                = 0x25AB,
                kBlackRectangle                                                  = 0x25AC,
                kWhiteRectangle                                                  = 0x25AD,
                kBlackVerticalRectangle                                  = 0x25AE,
                kWhiteVerticalRectangle                                  = 0x25AF,
                kBlackParallelogram                                              = 0x25B0,
                kWhiteParallelogram                                              = 0x25B1,
                kBlackUpPointingTriangle                                 = 0x25B2,
                kWhiteUpPointingTriangle                                 = 0x25B3,
                kBlackUpPointingSmallTriangle                    = 0x25B4,
                kWhiteUpPointingSmallTriangle                    = 0x25B5,
                kBlackRightPointingTriangle                              = 0x25B6,
                kWhiteRightPointingTriangle                              = 0x25B7,
                kBlackRightPointingSmallTriangle                 = 0x25B8,
                kWhiteRightPointingSmallTriangle                 = 0x25B9,
                kBlackRightPointingPointer                               = 0x25BA,
                kWhiteRightPointingPointer                               = 0x25BB,
                kBlackDownPointingTriangle                               = 0x25BC,
                kWhiteDownPointingTriangle                               = 0x25BD,
                kBlackDownPointingSmallTriangle                  = 0x25BE,
                kWhiteDownPointingSmallTriangle                  = 0x25BF,
                kBlackLeftPointingTriangle                               = 0x25C0,
                kWhiteLeftPointingTriangle                               = 0x25C1,
                kBlackLeftPointingSmallTriangle                  = 0x25C2,
                kWhiteLeftPointingSmallTriangle                  = 0x25C3,
                kBlackLeftPointingPointer                                = 0x25C4,
                kWhiteLeftPointingPointer                                = 0x25C5,
                kBlackDiamond                                                    = 0x25C6,
                kWhiteDiamond                                                    = 0x25C7,
                kWhiteDiamondContainingBlackSmallDiamond = 0x25C8,
                kFisheye                                                                 = 0x25C9,
                kLozenge                                                                 = 0x25CA,
                kWhiteCircle                                                     = 0x25CB,
                kDottedCircle                                                    = 0x25CC,
                kCircleWithVerticalFill                                  = 0x25CD,
                kBullseye                                                                = 0x25CE,
                kBlackCircle                                                     = 0x25CF,
                kCircleWithLeftHalfBlack                                 = 0x25D0,
                kCircleWithRightHalfBlack                                = 0x25D1,
                kCircleWithLowerHalfBlack                                = 0x25D2,
                kCircleWithUpperHalfBlack                                = 0x25D3,
                kCircleWithUpperRightQuadrantBlack               = 0x25D4,
                kCircleWithAllButUpperLeftQuadrantBlack  = 0x25D5,
                kLeftHalfBlackCircle                                     = 0x25D6,
                kRightHalfBlackCircle                                    = 0x25D7,
                kInverseBullet                                                   = 0x25D8,
                kInverseWhiteCircle                                              = 0x25D9,
                kUpperHalfInverseWhiteCircle                     = 0x25DA,
                kLowerHalfInverseWhiteCircle                     = 0x25DB,
                kUpperLeftQuadrantCircularArc                    = 0x25DC,
                kUpperRightQuadrantCircularArc                   = 0x25DD,
                kLowerRightQuadrantCircularArc                   = 0x25DE,
                kLowerLeftQuadrantCircularArc                    = 0x25DF,
                kUpperHalfCircle                                                 = 0x25E0,
                kLowerHalfCircle                                                 = 0x25E1,
                kBlackLowerRightTriangle                                 = 0x25E2,
                kBlackLowerLeftTriangle                                  = 0x25E3,
                kBlackUpperLeftTriangle                                  = 0x25E4,
                kBlackUpperRightTriangle                                 = 0x25E5,
                kWhiteBullet                                                     = 0x25E6,
                kSquareWithLeftHalfBlack                                 = 0x25E7,
                kSquareWithRightHalfBlack                                = 0x25E8,
                kSquareWithUpperLeftDiagonalHalfBlack    = 0x25E9,
                kSquareWithLowerRightDiagonalHalfBlack   = 0x25EA,
                kWhiteSquareWithVerticalBisectingLine    = 0x25EB,
                kWhiteUpPointingTriangleWithDot                  = 0x25EC,
                kUpPointingTriangleWithLeftHalfBlack     = 0x25ED,
                kUpPointingTriangleWithRightHalfBlack    = 0x25EE,
                kLargeCircle                                                     = 0x25EF
        };

private:

};







//=================================================================================
// class UDingbats
//=================================================================================

class UDingbats {

public:

        enum EDingbatsNames {

                kBlackSunWithRays                                                = 0x2600,
                kCloud                                                                   = 0x2601,
                kUmbrella                                                                = 0x2602,
                kSnowman                                                                 = 0x2603,
                kComet                                                                   = 0x2604,
                kBlackStar                                                               = 0x2605,
                kWhiteStar                                                               = 0x2606,
                kLightning                                                               = 0x2607,
                kThunderstorm                                                    = 0x2608,
                kSun                                                                     = 0x2609,
                kAscendingNode                                                   = 0x260A,
                kDescendingNode                                                  = 0x260B,
                kConjunction                                                     = 0x260C,
                kOpposition                                                              = 0x260D,
                kBlackTelephone                                                  = 0x260E,
                kWhiteTelephone                                                  = 0x260F,
                kBallotBox                                                               = 0x2610,
                kBallotBoxWithCheck                                              = 0x2611,
                kBallotBoxWithX                                                  = 0x2612,
                kSaltire                                                                 = 0x2613,
                kBlackLeftPointingIndex                                  = 0x261A,
                kBlackRightPointingIndex                                 = 0x261B,
                kWhiteLeftPointingIndex                                  = 0x261C,
                kWhiteUpPointingIndex                                    = 0x261D,
                kWhiteRightPointingIndex                                 = 0x261E,
                kWhiteDownPointingIndex                                  = 0x261F,
                kSkullAndCrossbones                                              = 0x2620,
                kCautionSign                                                     = 0x2621,
                kRadioactiveSign                                                 = 0x2622,
                kBiohazardSign                                                   = 0x2623,
                kCaduceus                                                                = 0x2624,
                kAnkh                                                                    = 0x2625,
                kOrthodoxCross                                                   = 0x2626,
                kChiRho                                                                  = 0x2627,
                kCrossOfLorraine                                                 = 0x2628,
                kCrossOfJerusalem                                                = 0x2629,
                kStarAndCrescent                                                 = 0x262A,
                kFarsiSymbol                                                     = 0x262B,
                kAdiShakti                                                               = 0x262C,
                kHammerAndSickle                                                 = 0x262D,
                kPeaceSymbol                                                     = 0x262E,
                kYinYang                                                                 = 0x262F,
                kTrigramForHeaven                                                = 0x2630,
                kTrigramForLake                                                  = 0x2631,
                kTrigramForFire                                                  = 0x2632,
                kTrigramForThunder                                               = 0x2633,
                kTrigramForWind                                                  = 0x2634,
                kTrigramForWater                                                 = 0x2635,
                kTrigramForMountain                                              = 0x2636,
                kTrigramForEarth                                                 = 0x2637,
                kWheelOfDharma                                                   = 0x2638,
                kWhiteFrowningFace                                               = 0x2639,
                kWhiteSmilingFace                                                = 0x263A,
                kBlackSmilingFace                                                = 0x263B,
                kWhiteSunWithRays                                                = 0x263C,
                kFirstQuarterMoon                                                = 0x263D,
                kLastQuarterMoon                                                 = 0x263E,
                kMercury                                                                 = 0x263F,
                kFemaleSign                                                              = 0x2640,
                kEarth                                                                   = 0x2641,
                kMaleSign                                                                = 0x2642,
                kJupiter                                                                 = 0x2643,
                kSaturn                                                                  = 0x2644,
                kUranus                                                                  = 0x2645,
                kNeptune                                                                 = 0x2646,
                kPluto                                                                   = 0x2647,
                kAries                                                                   = 0x2648,
                kTaurus                                                                  = 0x2649,
                kGemini                                                                  = 0x264A,
                kCancer                                                                  = 0x264B,
                kLeo                                                                     = 0x264C,
                kVirgo                                                                   = 0x264D,
                kLibra                                                                   = 0x264E,
                kScorpius                                                                = 0x264F,
                kSagittarius                                                     = 0x2650,
                kCapricorn                                                               = 0x2651,
                kAquarius                                                                = 0x2652,
                kPisces                                                                  = 0x2653,
                kWhiteChessKing                                                  = 0x2654,
                kWhiteChessQueen                                                 = 0x2655,
                kWhiteChessRook                                                  = 0x2656,
                kWhiteChessBishop                                                = 0x2657,
                kWhiteChessKnight                                                = 0x2658,
                kWhiteChessPawn                                                  = 0x2659,
                kBlackChessKing                                                  = 0x265A,
                kBlackChessQueen                                                 = 0x265B,
                kBlackChessRook                                                  = 0x265C,
                kBlackChessBishop                                                = 0x265D,
                kBlackChessKnight                                                = 0x265E,
                kBlackChessPawn                                                  = 0x265F,
                kBlackSpadeSuit                                                  = 0x2660,
                kWhiteHeartSuit                                                  = 0x2661,
                kWhiteDiamondSuit                                                = 0x2662,
                kBlackClubSuit                                                   = 0x2663,
                kWhiteSpadeSuit                                                  = 0x2664,
                kBlackHeartSuit                                                  = 0x2665,
                kBlackDiamondSuit                                                = 0x2666,
                kWhiteClubSuit                                                   = 0x2667,
                kHotSprings                                                              = 0x2668,
                kQuarterNote                                                     = 0x2669,
                kEighthNote                                                              = 0x266A,
                kBeamedEighthNotes                                               = 0x266B,
                kBeamedSixteenthNotes                                    = 0x266C,
                kMusicFlatSign                                                   = 0x266D,
                kMusicNaturalSign                                                = 0x266E,
                kMusicSharpSign                                                  = 0x266F,

                //      Values derived from Unicode 1.0 names

                kSymbolOfIran                                                    = kFarsiSymbol,
                kBarredEighthNotes                                               = kBeamedEighthNotes,
                kBarredSixteenthNotes                                    = kBeamedSixteenthNotes
        };

private:

};







//=================================================================================
// class UZapfDingbats
//=================================================================================

class UZapfDingbats {

public:

        enum EZapfDingbatsNames {

                kUpperBladeScissors                                              = 0x2701,
                kBlackScissors                                                   = 0x2702,
                kLowerBladeScissors                                              = 0x2703,
                kWhiteScissors                                                   = 0x2704,
                kTelephoneLocationSign                                   = 0x2706,
                kTapeDrive                                                               = 0x2707,
                kAirplane                                                                = 0x2708,
                kEnvelope                                                                = 0x2709,
                kVictoryHand                                                     = 0x270C,
                kWritingHand                                                     = 0x270D,
                kLowerRightPencil                                                = 0x270E,
                kPencil                                                                  = 0x270F,
                kUpperRightPencil                                                = 0x2710,
                kWhiteNib                                                                = 0x2711,
                kBlackNib                                                                = 0x2712,
                kCheckMark                                                               = 0x2713,
                kHeavyCheckMark                                                  = 0x2714,
                kMultiplicationX                                                 = 0x2715,
                kHeavyMultiplicationX                                    = 0x2716,
                kBallotX                                                                 = 0x2717,
                kHeavyBallotX                                                    = 0x2718,
                kOutlinedGreekCross                                              = 0x2719,
                kHeavyGreekCross                                                 = 0x271A,
                kOpenCentreCross                                                 = 0x271B,
                kHeavyOpenCentreCross                                    = 0x271C,
                kLatinCross                                                              = 0x271D,
                kShadowedWhiteLatinCross                                 = 0x271E,
                kOutlinedLatinCross                                              = 0x271F,
                kMalteseCross                                                    = 0x2720,
                kStarOfDavid                                                     = 0x2721,
                kFourTeardropSpokedAsterisk                              = 0x2722,
                kFourBalloonSpokedAsterisk                               = 0x2723,
                kHeavyFourBalloonSpokedAsterisk                  = 0x2724,
                kFourClubSpokedAsterisk                                  = 0x2725,
                kBlackFourPointedStar                                    = 0x2726,
                kWhiteFourPointedStar                                    = 0x2727,
                kStressOutlinedWhiteStar                                 = 0x2729,
                kCircledWhiteStar                                                = 0x272A,
                kOpenCentreBlackStar                                     = 0x272B,
                kBlackCentreWhiteStar                                    = 0x272C,
                kOutlinedBlackStar                                               = 0x272D,
                kHeavyOutlinedBlackStar                                  = 0x272E,
                kPinwheelStar                                                    = 0x272F,
                kShadowedWhiteStar                                               = 0x2730,
                kHeavyAsterisk                                                   = 0x2731,
                kOpenCentreAsterisk                                              = 0x2732,
                kEightSpokedAsterisk                                     = 0x2733,
                kEightPointedBlackStar                                   = 0x2734,
                kEightPointedPinwheelStar                                = 0x2735,
                kSixPointedBlackStar                                     = 0x2736,
                kEightPointedRectilinearBlackStar                = 0x2737,
                kHeavyEightPointedRectilinearBlackStar   = 0x2738,
                kTwelvePointedBlackStar                                  = 0x2739,
                kSixteenPointedAsterisk                                  = 0x273A,
                kTeardropSpokedAsterisk                                  = 0x273B,
                kOpenCentreTeardropSpokedAsterisk                = 0x273C,
                kHeavyTeardropSpokedAsterisk                     = 0x273D,
                kSixPetalledBlackAndWhiteFlorette                = 0x273E,
                kBlackFlorette                                                   = 0x273F,
                kWhiteFlorette                                                   = 0x2740,
                kEightPetalledOutlinedBlackFlorette              = 0x2741,
                kCircledOpenCentreEightPointedStar               = 0x2742,
                kHeavyTeardropSpokedPinwheelAsterisk     = 0x2743,
                kSnowflake                                                               = 0x2744,
                kTightTrifoliateSnowflake                                = 0x2745,
                kHeavyChevronSnowflake                                   = 0x2746,
                kSparkle                                                                 = 0x2747,
                kHeavySparkle                                                    = 0x2748,
                kBalloonSpokedAsterisk                                   = 0x2749,
                kEightTeardropSpokedPropellerAsterisk    = 0x274A,
                kHeavyEightTeardropSpokedPropellerAsterisk = 0x274B,
                kShadowedWhiteCircle                                     = 0x274D,
                kLowerRightDropShadowedWhiteSquare               = 0x274F,
                kUpperRightDropShadowedWhiteSquare               = 0x2750,
                kLowerRightShadowedWhiteSquare                   = 0x2751,
                kUpperRightShadowedWhiteSquare                   = 0x2752,
                kBlackDiamondMinusWhiteX                                 = 0x2756,
                kLightVerticalBar                                                = 0x2758,
                kMediumVerticalBar                                               = 0x2759,
                kHeavyVerticalBar                                                = 0x275A,
                kHeavySingleTurnedCommaQuotationMarkOrnament = 0x275B,
                kHeavySingleCommaQuotationMarkOrnament   = 0x275C,
                kHeavyDoubleTurnedCommaQuotationMarkOrnament = 0x275D,
                kHeavyDoubleCommaQuotationMarkOrnament   = 0x275E,
                kCurvedStemParagraphSignOrnament                 = 0x2761,
                kHeavyExclamationMarkOrnament                    = 0x2762,
                kHeavyHeartExclamationMarkOrnament               = 0x2763,
                kHeavyBlackHeart                                                 = 0x2764,
                kRotatedHeavyBlackHeartBullet                    = 0x2765,
                kFloralHeart                                                     = 0x2766,
                kRotatedFloralHeartBullet                                = 0x2767,
                kDingbatNegativeCircledDigitOne                  = 0x2776,
                kDingbatNegativeCircledDigitTwo                  = 0x2777,
                kDingbatNegativeCircledDigitThree                = 0x2778,
                kDingbatNegativeCircledDigitFour                 = 0x2779,
                kDingbatNegativeCircledDigitFive                 = 0x277A,
                kDingbatNegativeCircledDigitSix                  = 0x277B,
                kDingbatNegativeCircledDigitSeven                = 0x277C,
                kDingbatNegativeCircledDigitEight                = 0x277D,
                kDingbatNegativeCircledDigitNine                 = 0x277E,
                kDingbatNegativeCircledNumberTen                 = 0x277F,
                kDingbatCircledSansSerifDigitOne                 = 0x2780,
                kDingbatCircledSansSerifDigitTwo                 = 0x2781,
                kDingbatCircledSansSerifDigitThree               = 0x2782,
                kDingbatCircledSansSerifDigitFour                = 0x2783,
                kDingbatCircledSansSerifDigitFive                = 0x2784,
                kDingbatCircledSansSerifDigitSix                 = 0x2785,
                kDingbatCircledSansSerifDigitSeven               = 0x2786,
                kDingbatCircledSansSerifDigitEight               = 0x2787,
                kDingbatCircledSansSerifDigitNine                = 0x2788,
                kDingbatCircledSansSerifNumberTen                = 0x2789,
                kDingbatNegativeCircledSansSerifDigitOne = 0x278A,
                kDingbatNegativeCircledSansSerifDigitTwo = 0x278B,
                kDingbatNegativeCircledSansSerifDigitThree = 0x278C,
                kDingbatNegativeCircledSansSerifDigitFour = 0x278D,
                kDingbatNegativeCircledSansSerifDigitFive = 0x278E,
                kDingbatNegativeCircledSansSerifDigitSix = 0x278F,
                kDingbatNegativeCircledSansSerifDigitSeven = 0x2790,
                kDingbatNegativeCircledSansSerifDigitEight = 0x2791,
                kDingbatNegativeCircledSansSerifDigitNine = 0x2792,
                kDingbatNegativeCircledSansSerifNumberTen = 0x2793,
                kHeavyWideHeadedRightwardsArrow                  = 0x2794,
                kHeavySouthEastArrow                                     = 0x2798,
                kHeavyRightwardsArrow                                    = 0x2799,
                kHeavyNorthEastArrow                                     = 0x279A,
                kDraftingPointRightwardsArrow                    = 0x279B,
                kHeavyRoundTippedRightwardsArrow                 = 0x279C,
                kTriangleHeadedRightwardsArrow                   = 0x279D,
                kHeavyTriangleHeadedRightwardsArrow              = 0x279E,
                kDashedTriangleHeadedRightwardsArrow     = 0x279F,
                kHeavyDashedTriangleHeadedRightwardsArrow = 0x27A0,
                kBlackRightwardsArrow                                    = 0x27A1,
                kThreeDTopLightedRightwardsArrowhead     = 0x27A2,
                kThreeDBottomLightedRightwardsArrowhead  = 0x27A3,
                kBlackRightwardsArrowhead                                = 0x27A4,
                kHeavyBlackCurvedDownwardsAndRightwardsArrow = 0x27A5,
                kHeavyBlackCurvedUpwardsAndRightwardsArrow = 0x27A6,
                kSquatBlackRightwardsArrow                               = 0x27A7,
                kHeavyConcavePointedBlackRightwardsArrow = 0x27A8,
                kRightShadedWhiteRightwardsArrow                 = 0x27A9,
                kLeftShadedWhiteRightwardsArrow                  = 0x27AA,
                kBackTiltedShadowedWhiteRightwardsArrow  = 0x27AB,
                kFrontTiltedShadowedWhiteRightwardsArrow = 0x27AC,
                kHeavyLowerRightShadowedWhiteRightwardsArrow = 0x27AD,
                kHeavyUpperRightShadowedWhiteRightwardsArrow = 0x27AE,
                kNotchedLowerRightShadowedWhiteRightwardsArrow = 0x27AF,
                kNotchedUpperRightShadowedWhiteRightwardsArrow = 0x27B1,
                kCircledHeavyWhiteRightwardsArrow                = 0x27B2,
                kWhiteFeatheredRightwardsArrow                   = 0x27B3,
                kBlackFeatheredSouthEastArrow                    = 0x27B4,
                kBlackFeatheredRightwardsArrow                   = 0x27B5,
                kBlackFeatheredNorthEastArrow                    = 0x27B6,
                kHeavyBlackFeatheredSouthEastArrow               = 0x27B7,
                kHeavyBlackFeatheredRightwardsArrow              = 0x27B8,
                kHeavyBlackFeatheredNorthEastArrow               = 0x27B9,
                kTeardropBarbedRightwardsArrow                   = 0x27BA,
                kHeavyTeardropShankedRightwardsArrow     = 0x27BB,
                kWedgeTailedRightwardsArrow                              = 0x27BC,
                kHeavyWedgeTailedRightwardsArrow                 = 0x27BD,
                kOpenOutlinedRightwardsArrow                     = 0x27BE
        };

private:

};







//=================================================================================
// class UHarpoon
//=================================================================================

class UHarpoon {

public:

        enum EHarpoonNames {

                kCombiningLeftAbove                                              = 0x20D0,
                kCombiningRightAbove                                     = 0x20D1,
                kLeftwardsWithBarbUpwards                                = 0x21BC,
                kLeftwardsWithBarbDownwards                              = 0x21BD,
                kUpwardsWithBarbRightwards                               = 0x21BE,
                kUpwardsWithBarbLeftwards                                = 0x21BF,
                kRightwardsWithBarbUpwards                               = 0x21C0,
                kRightwardsWithBarbDownwards                     = 0x21C1,
                kDownwardsWithBarbRightwards                     = 0x21C2,
                kDownwardsWithBarbLeftwards                              = 0x21C3,
                kLeftwardsOverRightwards                                 = 0x21CB,
                kRightwardsOverLeftwards                                 = 0x21CC
        };

private:

};







//=================================================================================
// class UCJKSymbols
//=================================================================================

class UCJKSymbols {

public:

        enum ECJKSymbolsNames {

                kIdeographicSpace                                                = 0x3000,
                kIdeographicComma                                                = 0x3001,
                kIdeographicFullStop                                     = 0x3002,
                kDittoMark                                                               = 0x3003,
                kJapaneseIndustrialStandardSymbol                = 0x3004,
                kIdeographicIterationMark                                = 0x3005,
                kIdeographicClosingMark                                  = 0x3006,
                kIdeographicNumberZero                                   = 0x3007,
                kLeftAngleBracket                                                = 0x3008,
                kRightAngleBracket                                               = 0x3009,
                kLeftDoubleAngleBracket                                  = 0x300A,
                kRightDoubleAngleBracket                                 = 0x300B,
                kLeftCornerBracket                                               = 0x300C,
                kRightCornerBracket                                              = 0x300D,
                kLeftWhiteCornerBracket                                  = 0x300E,
                kRightWhiteCornerBracket                                 = 0x300F,
                kLeftBlackLenticularBracket                              = 0x3010,
                kRightBlackLenticularBracket                     = 0x3011,
                kPostalMark                                                              = 0x3012,
                kGetaMark                                                                = 0x3013,
                kLeftTortoiseShellBracket                                = 0x3014,
                kRightTortoiseShellBracket                               = 0x3015,
                kLeftWhiteLenticularBracket                              = 0x3016,
                kRightWhiteLenticularBracket                     = 0x3017,
                kLeftWhiteTortoiseShellBracket                   = 0x3018,
                kRightWhiteTortoiseShellBracket                  = 0x3019,
                kLeftWhiteSquareBracket                                  = 0x301A,
                kRightWhiteSquareBracket                                 = 0x301B,
                kWaveDash                                                                = 0x301C,
                kReversedDoublePrimeQuotationMark                = 0x301D,
                kDoublePrimeQuotationMark                                = 0x301E,
                kLowDoublePrimeQuotationMark                     = 0x301F,
                kPostalMarkFace                                                  = 0x3020,
                kHangzhouNumeralOne                                              = 0x3021,
                kHangzhouNumeralTwo                                              = 0x3022,
                kHangzhouNumeralThree                                    = 0x3023,
                kHangzhouNumeralFour                                     = 0x3024,
                kHangzhouNumeralFive                                     = 0x3025,
                kHangzhouNumeralSix                                              = 0x3026,
                kHangzhouNumeralSeven                                    = 0x3027,
                kHangzhouNumeralEight                                    = 0x3028,
                kHangzhouNumeralNine                                     = 0x3029,
                kIdeographicLevelToneMark                                = 0x302A,
                kIdeographicRisingToneMark                               = 0x302B,
                kIdeographicDepartingToneMark                    = 0x302C,
                kIdeographicEnteringToneMark                     = 0x302D,
                kHangulSingleDotToneMark                                 = 0x302E,
                kHangulDoubleDotToneMark                                 = 0x302F,
                kWavyDash                                                                = 0x3030,
                kVerticalKanaRepeatMark                                  = 0x3031,
                kVerticalKanaRepeatWithVoicedSoundMark   = 0x3032,
                kVerticalKanaRepeatMarkUpperHalf                 = 0x3033,
                kVerticalKanaRepeatWithVoicedSoundMarkUpperHalf = 0x3034,
                kVerticalKanaRepeatMarkLowerHalf                 = 0x3035,
                kCircledPostalMark                                               = 0x3036,
                kIdeographicTelegraphLineFeedSeparatorSymbol = 0x3037,
                kIdeographicHalfFillSpace                                = 0x303F,

                //      Values derived from Unicode 1.0 names

                kIdeographicPeriod                                               = kIdeographicFullStop,
                kOpeningAngleBracket                                     = kLeftAngleBracket,
                kClosingAngleBracket                                     = kRightAngleBracket,
                kOpeningDoubleAngleBracket                               = kLeftDoubleAngleBracket,
                kClosingDoubleAngleBracket                               = kRightDoubleAngleBracket,
                kOpeningCornerBracket                                    = kLeftCornerBracket,
                kClosingCornerBracket                                    = kRightCornerBracket,
                kOpeningWhiteCornerBracket                               = kLeftWhiteCornerBracket,
                kClosingWhiteCornerBracket                               = kRightWhiteCornerBracket,
                kOpeningBlackLenticularBracket                   = kLeftBlackLenticularBracket,
                kClosingBlackLenticularBracket                   = kRightBlackLenticularBracket,
                kOpeningTortoiseShellBracket                     = kLeftTortoiseShellBracket,
                kClosingTortoiseShellBracket                     = kRightTortoiseShellBracket,
                kOpeningWhiteLenticularBracket                   = kLeftWhiteLenticularBracket,
                kClosingWhiteLenticularBracket                   = kRightWhiteLenticularBracket,
                kOpeningWhiteTortoiseShellBracket                = kLeftWhiteTortoiseShellBracket,
                kClosingWhiteTortoiseShellBracket                = kRightWhiteTortoiseShellBracket
        };

private:

};







//=================================================================================
// class UStandardPhonetic
//=================================================================================
class UStandardPhonetic {

public:

        enum EStandardPhoneticNames {

                kLatinSmallLetterTurnedA                                 = 0x0250,
                kLatinSmallLetterAlpha                                   = 0x0251,
                kLatinSmallLetterTurnedAlpha                     = 0x0252,
                kLatinSmallLetterBWithHook                               = 0x0253,
                kLatinSmallLetterOpenO                                   = 0x0254,
                kLatinSmallLetterCWithCurl                               = 0x0255,
                kLatinSmallLetterDWithTail                               = 0x0256,
                kLatinSmallLetterDWithHook                               = 0x0257,
                kLatinSmallLetterReversedE                               = 0x0258,
                kLatinSmallLetterSchwa                                   = 0x0259,
                kLatinSmallLetterSchwaWithHook                   = 0x025A,
                kLatinSmallLetterOpenE                                   = 0x025B,
                kLatinSmallLetterReversedOpenE                   = 0x025C,
                kLatinSmallLetterReversedOpenEWithHook   = 0x025D,
                kLatinSmallLetterClosedReversedOpenE     = 0x025E,
                kLatinSmallLetterDotlessJWithStroke              = 0x025F,
                kLatinSmallLetterGWithHook                               = 0x0260,
                kLatinSmallLetterScriptG                                 = 0x0261,
                kLatinLetterSmallCapitalG                                = 0x0262,
                kLatinSmallLetterGamma                                   = 0x0263,
                kLatinSmallLetterRamsHorn                                = 0x0264,
                kLatinSmallLetterTurnedH                                 = 0x0265,
                kLatinSmallLetterHWithHook                               = 0x0266,
                kLatinSmallLetterHengWithHook                    = 0x0267,
                kLatinSmallLetterIWithStroke                     = 0x0268,
                kLatinSmallLetterIota                                    = 0x0269,
                kLatinLetterSmallCapitalI                                = 0x026A,
                kLatinSmallLetterLWithMiddleTilde                = 0x026B,
                kLatinSmallLetterLWithBelt                               = 0x026C,
                kLatinSmallLetterLWithRetroflexHook              = 0x026D,
                kLatinSmallLetterLezh                                    = 0x026E,
                kLatinSmallLetterTurnedM                                 = 0x026F,
                kLatinSmallLetterTurnedMWithLongLeg              = 0x0270,
                kLatinSmallLetterMWithHook                               = 0x0271,
                kLatinSmallLetterNWithLeftHook                   = 0x0272,
                kLatinSmallLetterNWithRetroflexHook              = 0x0273,
                kLatinLetterSmallCapitalN                                = 0x0274,
                kLatinSmallLetterBarredO                                 = 0x0275,
                kLatinLetterSmallCapitalOe                               = 0x0276,
                kLatinSmallLetterClosedOmega                     = 0x0277,
                kLatinSmallLetterPhi                                     = 0x0278,
                kLatinSmallLetterTurnedR                                 = 0x0279,
                kLatinSmallLetterTurnedRWithLongLeg              = 0x027A,
                kLatinSmallLetterTurnedRWithHook                 = 0x027B,
                kLatinSmallLetterRWithLongLeg                    = 0x027C,
                kLatinSmallLetterRWithTail                               = 0x027D,
                kLatinSmallLetterRWithFishhook                   = 0x027E,
                kLatinSmallLetterReversedRWithFishhook   = 0x027F,
                kLatinLetterSmallCapitalR                                = 0x0280,
                kLatinLetterSmallCapitalInvertedR                = 0x0281,
                kLatinSmallLetterSWithHook                               = 0x0282,
                kLatinSmallLetterEsh                                     = 0x0283,
                kLatinSmallLetterDotlessJWithStrokeAndHook = 0x0284,
                kLatinSmallLetterSquatReversedEsh                = 0x0285,
                kLatinSmallLetterEshWithCurl                     = 0x0286,
                kLatinSmallLetterTurnedT                                 = 0x0287,
                kLatinSmallLetterTWithRetroflexHook              = 0x0288,
                kLatinSmallLetterUBar                                    = 0x0289,
                kLatinSmallLetterUpsilon                                 = 0x028A,
                kLatinSmallLetterVWithHook                               = 0x028B,
                kLatinSmallLetterTurnedV                                 = 0x028C,
                kLatinSmallLetterTurnedW                                 = 0x028D,
                kLatinSmallLetterTurnedY                                 = 0x028E,
                kLatinLetterSmallCapitalY                                = 0x028F,
                kLatinSmallLetterZWithRetroflexHook              = 0x0290,
                kLatinSmallLetterZWithCurl                               = 0x0291,
                kLatinSmallLetterEzh                                     = 0x0292,
                kLatinSmallLetterEzhWithCurl                     = 0x0293,
                kLatinLetterGlottalStop                                  = 0x0294,
                kLatinLetterPharyngealVoicedFricative    = 0x0295,
                kLatinLetterInvertedGlottalStop                  = 0x0296,
                kLatinLetterStretchedC                                   = 0x0297,
                kLatinLetterBilabialClick                                = 0x0298,
                kLatinLetterSmallCapitalB                                = 0x0299,
                kLatinSmallLetterClosedOpenE                     = 0x029A,
                kLatinLetterSmallCapitalGWithHook                = 0x029B,
                kLatinLetterSmallCapitalH                                = 0x029C,
                kLatinSmallLetterJWithCrossedTail                = 0x029D,
                kLatinSmallLetterTurnedK                                 = 0x029E,
                kLatinLetterSmallCapitalL                                = 0x029F,
                kLatinSmallLetterQWithHook                               = 0x02A0,
                kLatinLetterGlottalStopWithStroke                = 0x02A1,
                kLatinLetterReversedGlottalStopWithStroke = 0x02A2,
                kLatinSmallLetterDzDigraph                               = 0x02A3,
                kLatinSmallLetterDezhDigraph                     = 0x02A4,
                kLatinSmallLetterDzDigraphWithCurl               = 0x02A5,
                kLatinSmallLetterTsDigraph                               = 0x02A6,
                kLatinSmallLetterTeshDigraph                     = 0x02A7,
                kLatinSmallLetterTcDigraphWithCurl               = 0x02A8
        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUSYMS_
