// Revision: 91 1.13.1.4 source/core/text/unicode/iusasia.hpp, text, ioc.v400, 980918 
// iusasia.hpp
/**
 * This file contains the classes UDevanagari, UBengali, UGurmukhi,
 * UGujarati, UOriya, UTamil, UTelugu, UKannada, UMalayalam,
 * UThai, ULao which provide information South and Southeast
 * Asia scripts.
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */


#ifndef _IUSASIA_
#define _IUSASIA_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class UDevanagari;
class UBengali;
class UGurmukhi;
class UGujarati;
class UOriya;
class UTamil;
class UTelugu;
class UKannada;
class UMalayalam;
class UThai;
class ULao;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class UDevanagari
//=================================================================================
class UDevanagari {

public:

        enum EDevanagariNames {

                kSignCandrabindu                                                 = 0x0901,
                kSignAnusvara                                                    = 0x0902,
                kSignVisarga                                                     = 0x0903,
                kLetterA                                                                 = 0x0905,
                kLetterAa                                                                = 0x0906,
                kLetterI                                                                 = 0x0907,
                kLetterIi                                                                = 0x0908,
                kLetterU                                                                 = 0x0909,
                kLetterUu                                                                = 0x090A,
                kLetterVocalicR                                                  = 0x090B,
                kLetterVocalicL                                                  = 0x090C,
                kLetterCandraE                                                   = 0x090D,
                kLetterShortE                                                    = 0x090E,
                kLetterE                                                                 = 0x090F,
                kLetterAi                                                                = 0x0910,
                kLetterCandraO                                                   = 0x0911,
                kLetterShortO                                                    = 0x0912,
                kLetterO                                                                 = 0x0913,
                kLetterAu                                                                = 0x0914,
                kLetterKa                                                                = 0x0915,
                kLetterKha                                                               = 0x0916,
                kLetterGa                                                                = 0x0917,
                kLetterGha                                                               = 0x0918,
                kLetterNga                                                               = 0x0919,
                kLetterCa                                                                = 0x091A,
                kLetterCha                                                               = 0x091B,
                kLetterJa                                                                = 0x091C,
                kLetterJha                                                               = 0x091D,
                kLetterNya                                                               = 0x091E,
                kLetterTta                                                               = 0x091F,
                kLetterTtha                                                              = 0x0920,
                kLetterDda                                                               = 0x0921,
                kLetterDdha                                                              = 0x0922,
                kLetterNna                                                               = 0x0923,
                kLetterTa                                                                = 0x0924,
                kLetterTha                                                               = 0x0925,
                kLetterDa                                                                = 0x0926,
                kLetterDha                                                               = 0x0927,
                kLetterNa                                                                = 0x0928,
                kLetterNnna                                                              = 0x0929,
                kLetterPa                                                                = 0x092A,
                kLetterPha                                                               = 0x092B,
                kLetterBa                                                                = 0x092C,
                kLetterBha                                                               = 0x092D,
                kLetterMa                                                                = 0x092E,
                kLetterYa                                                                = 0x092F,
                kLetterRa                                                                = 0x0930,
                kLetterRra                                                               = 0x0931,
                kLetterLa                                                                = 0x0932,
                kLetterLla                                                               = 0x0933,
                kLetterLlla                                                              = 0x0934,
                kLetterVa                                                                = 0x0935,
                kLetterSha                                                               = 0x0936,
                kLetterSsa                                                               = 0x0937,
                kLetterSa                                                                = 0x0938,
                kLetterHa                                                                = 0x0939,
                kSignNukta                                                               = 0x093C,
                kSignAvagraha                                                    = 0x093D,
                kVowelSignAa                                                     = 0x093E,
                kVowelSignI                                                              = 0x093F,
                kVowelSignIi                                                     = 0x0940,
                kVowelSignU                                                              = 0x0941,
                kVowelSignUu                                                     = 0x0942,
                kVowelSignVocalicR                                               = 0x0943,
                kVowelSignVocalicRr                                              = 0x0944,
                kVowelSignCandraE                                                = 0x0945,
                kVowelSignShortE                                                 = 0x0946,
                kVowelSignE                                                              = 0x0947,
                kVowelSignAi                                                     = 0x0948,
                kVowelSignCandraO                                                = 0x0949,
                kVowelSignShortO                                                 = 0x094A,
                kVowelSignO                                                              = 0x094B,
                kVowelSignAu                                                     = 0x094C,
                kSignVirama                                                              = 0x094D,
                kOm                                                                              = 0x0950,
                kStressSignUdatta                                                = 0x0951,
                kStressSignAnudatta                                              = 0x0952,
                kGraveAccent                                                     = 0x0953,
                kAcuteAccent                                                     = 0x0954,
                kLetterQa                                                                = 0x0958,
                kLetterKhha                                                              = 0x0959,
                kLetterGhha                                                              = 0x095A,
                kLetterZa                                                                = 0x095B,
                kLetterDddha                                                     = 0x095C,
                kLetterRha                                                               = 0x095D,
                kLetterFa                                                                = 0x095E,
                kLetterYya                                                               = 0x095F,
                kLetterVocalicRr                                                 = 0x0960,
                kLetterVocalicLl                                                 = 0x0961,
                kVowelSignVocalicL                                               = 0x0962,
                kVowelSignVocalicLl                                              = 0x0963,
                kDanda                                                                   = 0x0964,
                kDoubleDanda                                                     = 0x0965,
                kDigitZero                                                               = 0x0966,
                kDigitOne                                                                = 0x0967,
                kDigitTwo                                                                = 0x0968,
                kDigitThree                                                              = 0x0969,
                kDigitFour                                                               = 0x096A,
                kDigitFive                                                               = 0x096B,
                kDigitSix                                                                = 0x096C,
                kDigitSeven                                                              = 0x096D,
                kDigitEight                                                              = 0x096E,
                kDigitNine                                                               = 0x096F,
                kAbbreviationSign                                                = 0x0970
        };

private:

};







//=================================================================================
// class UBengali
//=================================================================================

class UBengali {

public:

        enum EBengaliNames {

                kSignCandrabindu                                                 = 0x0981,
                kSignAnusvara                                                    = 0x0982,
                kSignVisarga                                                     = 0x0983,
                kLetterA                                                                 = 0x0985,
                kLetterAa                                                                = 0x0986,
                kLetterI                                                                 = 0x0987,
                kLetterIi                                                                = 0x0988,
                kLetterU                                                                 = 0x0989,
                kLetterUu                                                                = 0x098A,
                kLetterVocalicR                                                  = 0x098B,
                kLetterVocalicL                                                  = 0x098C,
                kLetterE                                                                 = 0x098F,
                kLetterAi                                                                = 0x0990,
                kLetterO                                                                 = 0x0993,
                kLetterAu                                                                = 0x0994,
                kLetterKa                                                                = 0x0995,
                kLetterKha                                                               = 0x0996,
                kLetterGa                                                                = 0x0997,
                kLetterGha                                                               = 0x0998,
                kLetterNga                                                               = 0x0999,
                kLetterCa                                                                = 0x099A,
                kLetterCha                                                               = 0x099B,
                kLetterJa                                                                = 0x099C,
                kLetterJha                                                               = 0x099D,
                kLetterNya                                                               = 0x099E,
                kLetterTta                                                               = 0x099F,
                kLetterTtha                                                              = 0x09A0,
                kLetterDda                                                               = 0x09A1,
                kLetterDdha                                                              = 0x09A2,
                kLetterNna                                                               = 0x09A3,
                kLetterTa                                                                = 0x09A4,
                kLetterTha                                                               = 0x09A5,
                kLetterDa                                                                = 0x09A6,
                kLetterDha                                                               = 0x09A7,
                kLetterNa                                                                = 0x09A8,
                kLetterPa                                                                = 0x09AA,
                kLetterPha                                                               = 0x09AB,
                kLetterBa                                                                = 0x09AC,
                kLetterBha                                                               = 0x09AD,
                kLetterMa                                                                = 0x09AE,
                kLetterYa                                                                = 0x09AF,
                kLetterRa                                                                = 0x09B0,
                kLetterLa                                                                = 0x09B2,
                kLetterSha                                                               = 0x09B6,
                kLetterSsa                                                               = 0x09B7,
                kLetterSa                                                                = 0x09B8,
                kLetterHa                                                                = 0x09B9,
                kSignNukta                                                               = 0x09BC,
                kVowelSignAa                                                     = 0x09BE,
                kVowelSignI                                                              = 0x09BF,
                kVowelSignIi                                                     = 0x09C0,
                kVowelSignU                                                              = 0x09C1,
                kVowelSignUu                                                     = 0x09C2,
                kVowelSignVocalicR                                               = 0x09C3,
                kVowelSignVocalicRr                                              = 0x09C4,
                kVowelSignE                                                              = 0x09C7,
                kVowelSignAi                                                     = 0x09C8,
                kVowelSignO                                                              = 0x09CB,
                kVowelSignAu                                                     = 0x09CC,
                kSignVirama                                                              = 0x09CD,
                kAuLengthMark                                                    = 0x09D7,
                kLetterRra                                                               = 0x09DC,
                kLetterRha                                                               = 0x09DD,
                kLetterYya                                                               = 0x09DF,
                kLetterVocalicRr                                                 = 0x09E0,
                kLetterVocalicLl                                                 = 0x09E1,
                kVowelSignVocalicL                                               = 0x09E2,
                kVowelSignVocalicLl                                              = 0x09E3,
                kDigitZero                                                               = 0x09E6,
                kDigitOne                                                                = 0x09E7,
                kDigitTwo                                                                = 0x09E8,
                kDigitThree                                                              = 0x09E9,
                kDigitFour                                                               = 0x09EA,
                kDigitFive                                                               = 0x09EB,
                kDigitSix                                                                = 0x09EC,
                kDigitSeven                                                              = 0x09ED,
                kDigitEight                                                              = 0x09EE,
                kDigitNine                                                               = 0x09EF,
                kLetterRaWithMiddleDiagonal                      = 0x09F0,
                kLetterRaWithLowerDiagonal                               = 0x09F1,
                kRupeeMark                                                               = 0x09F2,
                kRupeeSign                                                               = 0x09F3,
                kCurrencyNumeratorOne                                    = 0x09F4,
                kCurrencyNumeratorTwo                                    = 0x09F5,
                kCurrencyNumeratorThree                                  = 0x09F6,
                kCurrencyNumeratorFour                                   = 0x09F7,
                kCurrencyNumeratorOneLessThanTheDenominator = 0x09F8,
                kCurrencyDenominatorSixteen                              = 0x09F9,
                kIsshar                                                                  = 0x09FA
        };

private:

};







//=================================================================================
// class UGurmukhi
//=================================================================================

class UGurmukhi {

public:

        enum EGurmukhiNames {

                kSignBindi                                                               = 0x0A02,
                kLetterA                                                                 = 0x0A05,
                kLetterAa                                                                = 0x0A06,
                kLetterI                                                                 = 0x0A07,
                kLetterIi                                                                = 0x0A08,
                kLetterU                                                                 = 0x0A09,
                kLetterUu                                                                = 0x0A0A,
                kLetterEe                                                                = 0x0A0F,
                kLetterAi                                                                = 0x0A10,
                kLetterOo                                                                = 0x0A13,
                kLetterAu                                                                = 0x0A14,
                kLetterKa                                                                = 0x0A15,
                kLetterKha                                                               = 0x0A16,
                kLetterGa                                                                = 0x0A17,
                kLetterGha                                                               = 0x0A18,
                kLetterNga                                                               = 0x0A19,
                kLetterCa                                                                = 0x0A1A,
                kLetterCha                                                               = 0x0A1B,
                kLetterJa                                                                = 0x0A1C,
                kLetterJha                                                               = 0x0A1D,
                kLetterNya                                                               = 0x0A1E,
                kLetterTta                                                               = 0x0A1F,
                kLetterTtha                                                              = 0x0A20,
                kLetterDda                                                               = 0x0A21,
                kLetterDdha                                                              = 0x0A22,
                kLetterNna                                                               = 0x0A23,
                kLetterTa                                                                = 0x0A24,
                kLetterTha                                                               = 0x0A25,
                kLetterDa                                                                = 0x0A26,
                kLetterDha                                                               = 0x0A27,
                kLetterNa                                                                = 0x0A28,
                kLetterPa                                                                = 0x0A2A,
                kLetterPha                                                               = 0x0A2B,
                kLetterBa                                                                = 0x0A2C,
                kLetterBha                                                               = 0x0A2D,
                kLetterMa                                                                = 0x0A2E,
                kLetterYa                                                                = 0x0A2F,
                kLetterRa                                                                = 0x0A30,
                kLetterLa                                                                = 0x0A32,
                kLetterLla                                                               = 0x0A33,
                kLetterVa                                                                = 0x0A35,
                kLetterSha                                                               = 0x0A36,
                kLetterSa                                                                = 0x0A38,
                kLetterHa                                                                = 0x0A39,
                kSignNukta                                                               = 0x0A3C,
                kVowelSignAa                                                     = 0x0A3E,
                kVowelSignI                                                              = 0x0A3F,
                kVowelSignIi                                                     = 0x0A40,
                kVowelSignU                                                              = 0x0A41,
                kVowelSignUu                                                     = 0x0A42,
                kVowelSignEe                                                     = 0x0A47,
                kVowelSignAi                                                     = 0x0A48,
                kVowelSignOo                                                     = 0x0A4B,
                kVowelSignAu                                                     = 0x0A4C,
                kSignVirama                                                              = 0x0A4D,
                kLetterKhha                                                              = 0x0A59,
                kLetterGhha                                                              = 0x0A5A,
                kLetterZa                                                                = 0x0A5B,
                kLetterRra                                                               = 0x0A5C,
                kLetterFa                                                                = 0x0A5E,
                kDigitZero                                                               = 0x0A66,
                kDigitOne                                                                = 0x0A67,
                kDigitTwo                                                                = 0x0A68,
                kDigitThree                                                              = 0x0A69,
                kDigitFour                                                               = 0x0A6A,
                kDigitFive                                                               = 0x0A6B,
                kDigitSix                                                                = 0x0A6C,
                kDigitSeven                                                              = 0x0A6D,
                kDigitEight                                                              = 0x0A6E,
                kDigitNine                                                               = 0x0A6F,
                kTippi                                                                   = 0x0A70,
                kAddak                                                                   = 0x0A71,
                kIri                                                                     = 0x0A72,
                kUra                                                                     = 0x0A73,
                kEkOnkar                                                                 = 0x0A74
        };

private:

};







//=================================================================================
// class UGujarati
//=================================================================================

class UGujarati {

public:

        enum EGujaratiNames {

                kSignCandrabindu                                                 = 0x0A81,
                kSignAnusvara                                                    = 0x0A82,
                kSignVisarga                                                     = 0x0A83,
                kLetterA                                                                 = 0x0A85,
                kLetterAa                                                                = 0x0A86,
                kLetterI                                                                 = 0x0A87,
                kLetterIi                                                                = 0x0A88,
                kLetterU                                                                 = 0x0A89,
                kLetterUu                                                                = 0x0A8A,
                kLetterVocalicR                                                  = 0x0A8B,
                kVowelCandraE                                                    = 0x0A8D,
                kLetterE                                                                 = 0x0A8F,
                kLetterAi                                                                = 0x0A90,
                kVowelCandraO                                                    = 0x0A91,
                kLetterO                                                                 = 0x0A93,
                kLetterAu                                                                = 0x0A94,
                kLetterKa                                                                = 0x0A95,
                kLetterKha                                                               = 0x0A96,
                kLetterGa                                                                = 0x0A97,
                kLetterGha                                                               = 0x0A98,
                kLetterNga                                                               = 0x0A99,
                kLetterCa                                                                = 0x0A9A,
                kLetterCha                                                               = 0x0A9B,
                kLetterJa                                                                = 0x0A9C,
                kLetterJha                                                               = 0x0A9D,
                kLetterNya                                                               = 0x0A9E,
                kLetterTta                                                               = 0x0A9F,
                kLetterTtha                                                              = 0x0AA0,
                kLetterDda                                                               = 0x0AA1,
                kLetterDdha                                                              = 0x0AA2,
                kLetterNna                                                               = 0x0AA3,
                kLetterTa                                                                = 0x0AA4,
                kLetterTha                                                               = 0x0AA5,
                kLetterDa                                                                = 0x0AA6,
                kLetterDha                                                               = 0x0AA7,
                kLetterNa                                                                = 0x0AA8,
                kLetterPa                                                                = 0x0AAA,
                kLetterPha                                                               = 0x0AAB,
                kLetterBa                                                                = 0x0AAC,
                kLetterBha                                                               = 0x0AAD,
                kLetterMa                                                                = 0x0AAE,
                kLetterYa                                                                = 0x0AAF,
                kLetterRa                                                                = 0x0AB0,
                kLetterLa                                                                = 0x0AB2,
                kLetterLla                                                               = 0x0AB3,
                kLetterVa                                                                = 0x0AB5,
                kLetterSha                                                               = 0x0AB6,
                kLetterSsa                                                               = 0x0AB7,
                kLetterSa                                                                = 0x0AB8,
                kLetterHa                                                                = 0x0AB9,
                kSignNukta                                                               = 0x0ABC,
                kSignAvagraha                                                    = 0x0ABD,
                kVowelSignAa                                                     = 0x0ABE,
                kVowelSignI                                                              = 0x0ABF,
                kVowelSignIi                                                     = 0x0AC0,
                kVowelSignU                                                              = 0x0AC1,
                kVowelSignUu                                                     = 0x0AC2,
                kVowelSignVocalicR                                               = 0x0AC3,
                kVowelSignVocalicRr                                              = 0x0AC4,
                kVowelSignCandraE                                                = 0x0AC5,
                kVowelSignE                                                              = 0x0AC7,
                kVowelSignAi                                                     = 0x0AC8,
                kVowelSignCandraO                                                = 0x0AC9,
                kVowelSignO                                                              = 0x0ACB,
                kVowelSignAu                                                     = 0x0ACC,
                kSignVirama                                                              = 0x0ACD,
                kOm                                                                              = 0x0AD0,
                kLetterVocalicRr                                                 = 0x0AE0,
                kDigitZero                                                               = 0x0AE6,
                kDigitOne                                                                = 0x0AE7,
                kDigitTwo                                                                = 0x0AE8,
                kDigitThree                                                              = 0x0AE9,
                kDigitFour                                                               = 0x0AEA,
                kDigitFive                                                               = 0x0AEB,
                kDigitSix                                                                = 0x0AEC,
                kDigitSeven                                                              = 0x0AED,
                kDigitEight                                                              = 0x0AEE,
                kDigitNine                                                               = 0x0AEF
        };

private:

};







//=================================================================================
// class UOriya
//=================================================================================

class UOriya {

public:

        enum EOriyaNames {

                kSignCandrabindu                                                 = 0x0B01,
                kSignAnusvara                                                    = 0x0B02,
                kSignVisarga                                                     = 0x0B03,
                kLetterA                                                                 = 0x0B05,
                kLetterAa                                                                = 0x0B06,
                kLetterI                                                                 = 0x0B07,
                kLetterIi                                                                = 0x0B08,
                kLetterU                                                                 = 0x0B09,
                kLetterUu                                                                = 0x0B0A,
                kLetterVocalicR                                                  = 0x0B0B,
                kLetterVocalicL                                                  = 0x0B0C,
                kLetterE                                                                 = 0x0B0F,
                kLetterAi                                                                = 0x0B10,
                kLetterO                                                                 = 0x0B13,
                kLetterAu                                                                = 0x0B14,
                kLetterKa                                                                = 0x0B15,
                kLetterKha                                                               = 0x0B16,
                kLetterGa                                                                = 0x0B17,
                kLetterGha                                                               = 0x0B18,
                kLetterNga                                                               = 0x0B19,
                kLetterCa                                                                = 0x0B1A,
                kLetterCha                                                               = 0x0B1B,
                kLetterJa                                                                = 0x0B1C,
                kLetterJha                                                               = 0x0B1D,
                kLetterNya                                                               = 0x0B1E,
                kLetterTta                                                               = 0x0B1F,
                kLetterTtha                                                              = 0x0B20,
                kLetterDda                                                               = 0x0B21,
                kLetterDdha                                                              = 0x0B22,
                kLetterNna                                                               = 0x0B23,
                kLetterTa                                                                = 0x0B24,
                kLetterTha                                                               = 0x0B25,
                kLetterDa                                                                = 0x0B26,
                kLetterDha                                                               = 0x0B27,
                kLetterNa                                                                = 0x0B28,
                kLetterPa                                                                = 0x0B2A,
                kLetterPha                                                               = 0x0B2B,
                kLetterBa                                                                = 0x0B2C,
                kLetterBha                                                               = 0x0B2D,
                kLetterMa                                                                = 0x0B2E,
                kLetterYa                                                                = 0x0B2F,
                kLetterRa                                                                = 0x0B30,
                kLetterLa                                                                = 0x0B32,
                kLetterLla                                                               = 0x0B33,
                kLetterSha                                                               = 0x0B36,
                kLetterSsa                                                               = 0x0B37,
                kLetterSa                                                                = 0x0B38,
                kLetterHa                                                                = 0x0B39,
                kSignNukta                                                               = 0x0B3C,
                kSignAvagraha                                                    = 0x0B3D,
                kVowelSignAa                                                     = 0x0B3E,
                kVowelSignI                                                              = 0x0B3F,
                kVowelSignIi                                                     = 0x0B40,
                kVowelSignU                                                              = 0x0B41,
                kVowelSignUu                                                     = 0x0B42,
                kVowelSignVocalicR                                               = 0x0B43,
                kVowelSignE                                                              = 0x0B47,
                kVowelSignAi                                                     = 0x0B48,
                kVowelSignO                                                              = 0x0B4B,
                kVowelSignAu                                                     = 0x0B4C,
                kSignVirama                                                              = 0x0B4D,
                kAiLengthMark                                                    = 0x0B56,
                kAuLengthMark                                                    = 0x0B57,
                kLetterRra                                                               = 0x0B5C,
                kLetterRha                                                               = 0x0B5D,
                kLetterYya                                                               = 0x0B5F,
                kLetterVocalicRr                                                 = 0x0B60,
                kLetterVocalicLl                                                 = 0x0B61,
                kDigitZero                                                               = 0x0B66,
                kDigitOne                                                                = 0x0B67,
                kDigitTwo                                                                = 0x0B68,
                kDigitThree                                                              = 0x0B69,
                kDigitFour                                                               = 0x0B6A,
                kDigitFive                                                               = 0x0B6B,
                kDigitSix                                                                = 0x0B6C,
                kDigitSeven                                                              = 0x0B6D,
                kDigitEight                                                              = 0x0B6E,
                kDigitNine                                                               = 0x0B6F,
                kIsshar                                                                  = 0x0B70
        };

private:

};







//=================================================================================
// class UTamil
//=================================================================================

class UTamil {

public:

        enum ETamilNames {

                kSignAnusvara                                                    = 0x0B82,
                kSignVisarga                                                     = 0x0B83,
                kLetterA                                                                 = 0x0B85,
                kLetterAa                                                                = 0x0B86,
                kLetterI                                                                 = 0x0B87,
                kLetterIi                                                                = 0x0B88,
                kLetterU                                                                 = 0x0B89,
                kLetterUu                                                                = 0x0B8A,
                kLetterE                                                                 = 0x0B8E,
                kLetterEe                                                                = 0x0B8F,
                kLetterAi                                                                = 0x0B90,
                kLetterO                                                                 = 0x0B92,
                kLetterOo                                                                = 0x0B93,
                kLetterAu                                                                = 0x0B94,
                kLetterKa                                                                = 0x0B95,
                kLetterNga                                                               = 0x0B99,
                kLetterCa                                                                = 0x0B9A,
                kLetterJa                                                                = 0x0B9C,
                kLetterNya                                                               = 0x0B9E,
                kLetterTta                                                               = 0x0B9F,
                kLetterNna                                                               = 0x0BA3,
                kLetterTa                                                                = 0x0BA4,
                kLetterNa                                                                = 0x0BA8,
                kLetterNnna                                                              = 0x0BA9,
                kLetterPa                                                                = 0x0BAA,
                kLetterMa                                                                = 0x0BAE,
                kLetterYa                                                                = 0x0BAF,
                kLetterRa                                                                = 0x0BB0,
                kLetterRra                                                               = 0x0BB1,
                kLetterLa                                                                = 0x0BB2,
                kLetterLla                                                               = 0x0BB3,
                kLetterLlla                                                              = 0x0BB4,
                kLetterVa                                                                = 0x0BB5,
                kLetterSsa                                                               = 0x0BB7,
                kLetterSa                                                                = 0x0BB8,
                kLetterHa                                                                = 0x0BB9,
                kVowelSignAa                                                     = 0x0BBE,
                kVowelSignI                                                              = 0x0BBF,
                kVowelSignIi                                                     = 0x0BC0,
                kVowelSignU                                                              = 0x0BC1,
                kVowelSignUu                                                     = 0x0BC2,
                kVowelSignE                                                              = 0x0BC6,
                kVowelSignEe                                                     = 0x0BC7,
                kVowelSignAi                                                     = 0x0BC8,
                kVowelSignO                                                              = 0x0BCA,
                kVowelSignOo                                                     = 0x0BCB,
                kVowelSignAu                                                     = 0x0BCC,
                kSignVirama                                                              = 0x0BCD,
                kAuLengthMark                                                    = 0x0BD7,
                kDigitOne                                                                = 0x0BE7,
                kDigitTwo                                                                = 0x0BE8,
                kDigitThree                                                              = 0x0BE9,
                kDigitFour                                                               = 0x0BEA,
                kDigitFive                                                               = 0x0BEB,
                kDigitSix                                                                = 0x0BEC,
                kDigitSeven                                                              = 0x0BED,
                kDigitEight                                                              = 0x0BEE,
                kDigitNine                                                               = 0x0BEF,
                kNumberTen                                                               = 0x0BF0,
                kNumberOneHundred                                                = 0x0BF1,
                kNumberOneThousand                                               = 0x0BF2
        };

private:

};







//=================================================================================
// class UTelugu
//=================================================================================

class UTelugu {

public:

        enum ETeluguNames {

                kSignCandrabindu                                                 = 0x0C01,
                kSignAnusvara                                                    = 0x0C02,
                kSignVisarga                                                     = 0x0C03,
                kLetterA                                                                 = 0x0C05,
                kLetterAa                                                                = 0x0C06,
                kLetterI                                                                 = 0x0C07,
                kLetterIi                                                                = 0x0C08,
                kLetterU                                                                 = 0x0C09,
                kLetterUu                                                                = 0x0C0A,
                kLetterVocalicR                                                  = 0x0C0B,
                kLetterVocalicL                                                  = 0x0C0C,
                kLetterE                                                                 = 0x0C0E,
                kLetterEe                                                                = 0x0C0F,
                kLetterAi                                                                = 0x0C10,
                kLetterO                                                                 = 0x0C12,
                kLetterOo                                                                = 0x0C13,
                kLetterAu                                                                = 0x0C14,
                kLetterKa                                                                = 0x0C15,
                kLetterKha                                                               = 0x0C16,
                kLetterGa                                                                = 0x0C17,
                kLetterGha                                                               = 0x0C18,
                kLetterNga                                                               = 0x0C19,
                kLetterCa                                                                = 0x0C1A,
                kLetterCha                                                               = 0x0C1B,
                kLetterJa                                                                = 0x0C1C,
                kLetterJha                                                               = 0x0C1D,
                kLetterNya                                                               = 0x0C1E,
                kLetterTta                                                               = 0x0C1F,
                kLetterTtha                                                              = 0x0C20,
                kLetterDda                                                               = 0x0C21,
                kLetterDdha                                                              = 0x0C22,
                kLetterNna                                                               = 0x0C23,
                kLetterTa                                                                = 0x0C24,
                kLetterTha                                                               = 0x0C25,
                kLetterDa                                                                = 0x0C26,
                kLetterDha                                                               = 0x0C27,
                kLetterNa                                                                = 0x0C28,
                kLetterPa                                                                = 0x0C2A,
                kLetterPha                                                               = 0x0C2B,
                kLetterBa                                                                = 0x0C2C,
                kLetterBha                                                               = 0x0C2D,
                kLetterMa                                                                = 0x0C2E,
                kLetterYa                                                                = 0x0C2F,
                kLetterRa                                                                = 0x0C30,
                kLetterRra                                                               = 0x0C31,
                kLetterLa                                                                = 0x0C32,
                kLetterLla                                                               = 0x0C33,
                kLetterVa                                                                = 0x0C35,
                kLetterSha                                                               = 0x0C36,
                kLetterSsa                                                               = 0x0C37,
                kLetterSa                                                                = 0x0C38,
                kLetterHa                                                                = 0x0C39,
                kVowelSignAa                                                     = 0x0C3E,
                kVowelSignI                                                              = 0x0C3F,
                kVowelSignIi                                                     = 0x0C40,
                kVowelSignU                                                              = 0x0C41,
                kVowelSignUu                                                     = 0x0C42,
                kVowelSignVocalicR                                               = 0x0C43,
                kVowelSignVocalicRr                                              = 0x0C44,
                kVowelSignE                                                              = 0x0C46,
                kVowelSignEe                                                     = 0x0C47,
                kVowelSignAi                                                     = 0x0C48,
                kVowelSignO                                                              = 0x0C4A,
                kVowelSignOo                                                     = 0x0C4B,
                kVowelSignAu                                                     = 0x0C4C,
                kSignVirama                                                              = 0x0C4D,
                kLengthMark                                                              = 0x0C55,
                kAiLengthMark                                                    = 0x0C56,
                kLetterVocalicRr                                                 = 0x0C60,
                kLetterVocalicLl                                                 = 0x0C61,
                kDigitZero                                                               = 0x0C66,
                kDigitOne                                                                = 0x0C67,
                kDigitTwo                                                                = 0x0C68,
                kDigitThree                                                              = 0x0C69,
                kDigitFour                                                               = 0x0C6A,
                kDigitFive                                                               = 0x0C6B,
                kDigitSix                                                                = 0x0C6C,
                kDigitSeven                                                              = 0x0C6D,
                kDigitEight                                                              = 0x0C6E,
                kDigitNine                                                               = 0x0C6F
        };

private:

};







//=================================================================================
// class UKannada
//=================================================================================

class UKannada {

public:

        enum EKannadaNames {

                kSignAnusvara                                                    = 0x0C82,
                kSignVisarga                                                     = 0x0C83,
                kLetterA                                                                 = 0x0C85,
                kLetterAa                                                                = 0x0C86,
                kLetterI                                                                 = 0x0C87,
                kLetterIi                                                                = 0x0C88,
                kLetterU                                                                 = 0x0C89,
                kLetterUu                                                                = 0x0C8A,
                kLetterVocalicR                                                  = 0x0C8B,
                kLetterVocalicL                                                  = 0x0C8C,
                kLetterE                                                                 = 0x0C8E,
                kLetterEe                                                                = 0x0C8F,
                kLetterAi                                                                = 0x0C90,
                kLetterO                                                                 = 0x0C92,
                kLetterOo                                                                = 0x0C93,
                kLetterAu                                                                = 0x0C94,
                kLetterKa                                                                = 0x0C95,
                kLetterKha                                                               = 0x0C96,
                kLetterGa                                                                = 0x0C97,
                kLetterGha                                                               = 0x0C98,
                kLetterNga                                                               = 0x0C99,
                kLetterCa                                                                = 0x0C9A,
                kLetterCha                                                               = 0x0C9B,
                kLetterJa                                                                = 0x0C9C,
                kLetterJha                                                               = 0x0C9D,
                kLetterNya                                                               = 0x0C9E,
                kLetterTta                                                               = 0x0C9F,
                kLetterTtha                                                              = 0x0CA0,
                kLetterDda                                                               = 0x0CA1,
                kLetterDdha                                                              = 0x0CA2,
                kLetterNna                                                               = 0x0CA3,
                kLetterTa                                                                = 0x0CA4,
                kLetterTha                                                               = 0x0CA5,
                kLetterDa                                                                = 0x0CA6,
                kLetterDha                                                               = 0x0CA7,
                kLetterNa                                                                = 0x0CA8,
                kLetterPa                                                                = 0x0CAA,
                kLetterPha                                                               = 0x0CAB,
                kLetterBa                                                                = 0x0CAC,
                kLetterBha                                                               = 0x0CAD,
                kLetterMa                                                                = 0x0CAE,
                kLetterYa                                                                = 0x0CAF,
                kLetterRa                                                                = 0x0CB0,
                kLetterRra                                                               = 0x0CB1,
                kLetterLa                                                                = 0x0CB2,
                kLetterLla                                                               = 0x0CB3,
                kLetterVa                                                                = 0x0CB5,
                kLetterSha                                                               = 0x0CB6,
                kLetterSsa                                                               = 0x0CB7,
                kLetterSa                                                                = 0x0CB8,
                kLetterHa                                                                = 0x0CB9,
                kVowelSignAa                                                     = 0x0CBE,
                kVowelSignI                                                              = 0x0CBF,
                kVowelSignIi                                                     = 0x0CC0,
                kVowelSignU                                                              = 0x0CC1,
                kVowelSignUu                                                     = 0x0CC2,
                kVowelSignVocalicR                                               = 0x0CC3,
                kVowelSignVocalicRr                                              = 0x0CC4,
                kVowelSignE                                                              = 0x0CC6,
                kVowelSignEe                                                     = 0x0CC7,
                kVowelSignAi                                                     = 0x0CC8,
                kVowelSignO                                                              = 0x0CCA,
                kVowelSignOo                                                     = 0x0CCB,
                kVowelSignAu                                                     = 0x0CCC,
                kSignVirama                                                              = 0x0CCD,
                kLengthMark                                                              = 0x0CD5,
                kAiLengthMark                                                    = 0x0CD6,
                kLetterFa                                                                = 0x0CDE,
                kLetterVocalicRr                                                 = 0x0CE0,
                kLetterVocalicLl                                                 = 0x0CE1,
                kDigitZero                                                               = 0x0CE6,
                kDigitOne                                                                = 0x0CE7,
                kDigitTwo                                                                = 0x0CE8,
                kDigitThree                                                              = 0x0CE9,
                kDigitFour                                                               = 0x0CEA,
                kDigitFive                                                               = 0x0CEB,
                kDigitSix                                                                = 0x0CEC,
                kDigitSeven                                                              = 0x0CED,
                kDigitEight                                                              = 0x0CEE,
                kDigitNine                                                               = 0x0CEF
        };

private:

};







//=================================================================================
// class UMalayalam
//=================================================================================

class UMalayalam {

public:

        enum EMalayalamNames {

                kSignAnusvara                                                    = 0x0D02,
                kSignVisarga                                                     = 0x0D03,
                kLetterA                                                                 = 0x0D05,
                kLetterAa                                                                = 0x0D06,
                kLetterI                                                                 = 0x0D07,
                kLetterIi                                                                = 0x0D08,
                kLetterU                                                                 = 0x0D09,
                kLetterUu                                                                = 0x0D0A,
                kLetterVocalicR                                                  = 0x0D0B,
                kLetterVocalicL                                                  = 0x0D0C,
                kLetterE                                                                 = 0x0D0E,
                kLetterEe                                                                = 0x0D0F,
                kLetterAi                                                                = 0x0D10,
                kLetterO                                                                 = 0x0D12,
                kLetterOo                                                                = 0x0D13,
                kLetterAu                                                                = 0x0D14,
                kLetterKa                                                                = 0x0D15,
                kLetterKha                                                               = 0x0D16,
                kLetterGa                                                                = 0x0D17,
                kLetterGha                                                               = 0x0D18,
                kLetterNga                                                               = 0x0D19,
                kLetterCa                                                                = 0x0D1A,
                kLetterCha                                                               = 0x0D1B,
                kLetterJa                                                                = 0x0D1C,
                kLetterJha                                                               = 0x0D1D,
                kLetterNya                                                               = 0x0D1E,
                kLetterTta                                                               = 0x0D1F,
                kLetterTtha                                                              = 0x0D20,
                kLetterDda                                                               = 0x0D21,
                kLetterDdha                                                              = 0x0D22,
                kLetterNna                                                               = 0x0D23,
                kLetterTa                                                                = 0x0D24,
                kLetterTha                                                               = 0x0D25,
                kLetterDa                                                                = 0x0D26,
                kLetterDha                                                               = 0x0D27,
                kLetterNa                                                                = 0x0D28,
                kLetterPa                                                                = 0x0D2A,
                kLetterPha                                                               = 0x0D2B,
                kLetterBa                                                                = 0x0D2C,
                kLetterBha                                                               = 0x0D2D,
                kLetterMa                                                                = 0x0D2E,
                kLetterYa                                                                = 0x0D2F,
                kLetterRa                                                                = 0x0D30,
                kLetterRra                                                               = 0x0D31,
                kLetterLa                                                                = 0x0D32,
                kLetterLla                                                               = 0x0D33,
                kLetterLlla                                                              = 0x0D34,
                kLetterVa                                                                = 0x0D35,
                kLetterSha                                                               = 0x0D36,
                kLetterSsa                                                               = 0x0D37,
                kLetterSa                                                                = 0x0D38,
                kLetterHa                                                                = 0x0D39,
                kVowelSignAa                                                     = 0x0D3E,
                kVowelSignI                                                              = 0x0D3F,
                kVowelSignIi                                                     = 0x0D40,
                kVowelSignU                                                              = 0x0D41,
                kVowelSignUu                                                     = 0x0D42,
                kVowelSignVocalicR                                               = 0x0D43,
                kVowelSignE                                                              = 0x0D46,
                kVowelSignEe                                                     = 0x0D47,
                kVowelSignAi                                                     = 0x0D48,
                kVowelSignO                                                              = 0x0D4A,
                kVowelSignOo                                                     = 0x0D4B,
                kVowelSignAu                                                     = 0x0D4C,
                kSignVirama                                                              = 0x0D4D,
                kAuLengthMark                                                    = 0x0D57,
                kLetterVocalicRr                                                 = 0x0D60,
                kLetterVocalicLl                                                 = 0x0D61,
                kDigitZero                                                               = 0x0D66,
                kDigitOne                                                                = 0x0D67,
                kDigitTwo                                                                = 0x0D68,
                kDigitThree                                                              = 0x0D69,
                kDigitFour                                                               = 0x0D6A,
                kDigitFive                                                               = 0x0D6B,
                kDigitSix                                                                = 0x0D6C,
                kDigitSeven                                                              = 0x0D6D,
                kDigitEight                                                              = 0x0D6E,
                kDigitNine                                                               = 0x0D6F
        };

private:

};







//=================================================================================
// class UThai
//=================================================================================

class UThai {

public:

        enum EThaiNames {

                kCharacterKoKai                                                  = 0x0E01,
                kCharacterKhoKhai                                                = 0x0E02,
                kCharacterKhoKhuat                                               = 0x0E03,
                kCharacterKhoKhwai                                               = 0x0E04,
                kCharacterKhoKhon                                                = 0x0E05,
                kCharacterKhoRakhang                                     = 0x0E06,
                kCharacterNgoNgu                                                 = 0x0E07,
                kCharacterChoChan                                                = 0x0E08,
                kCharacterChoChing                                               = 0x0E09,
                kCharacterChoChang                                               = 0x0E0A,
                kCharacterSoSo                                                   = 0x0E0B,
                kCharacterChoChoe                                                = 0x0E0C,
                kCharacterYoYing                                                 = 0x0E0D,
                kCharacterDoChada                                                = 0x0E0E,
                kCharacterToPatak                                                = 0x0E0F,
                kCharacterThoThan                                                = 0x0E10,
                kCharacterThoNangmontho                                  = 0x0E11,
                kCharacterThoPhuthao                                     = 0x0E12,
                kCharacterNoNen                                                  = 0x0E13,
                kCharacterDoDek                                                  = 0x0E14,
                kCharacterToTao                                                  = 0x0E15,
                kCharacterThoThung                                               = 0x0E16,
                kCharacterThoThahan                                              = 0x0E17,
                kCharacterThoThong                                               = 0x0E18,
                kCharacterNoNu                                                   = 0x0E19,
                kCharacterBoBaimai                                               = 0x0E1A,
                kCharacterPoPla                                                  = 0x0E1B,
                kCharacterPhoPhung                                               = 0x0E1C,
                kCharacterFoFa                                                   = 0x0E1D,
                kCharacterPhoPhan                                                = 0x0E1E,
                kCharacterFoFan                                                  = 0x0E1F,
                kCharacterPhoSamphao                                     = 0x0E20,
                kCharacterMoMa                                                   = 0x0E21,
                kCharacterYoYak                                                  = 0x0E22,
                kCharacterRoRua                                                  = 0x0E23,
                kCharacterRu                                                     = 0x0E24,
                kCharacterLoLing                                                 = 0x0E25,
                kCharacterLu                                                     = 0x0E26,
                kCharacterWoWaen                                                 = 0x0E27,
                kCharacterSoSala                                                 = 0x0E28,
                kCharacterSoRusi                                                 = 0x0E29,
                kCharacterSoSua                                                  = 0x0E2A,
                kCharacterHoHip                                                  = 0x0E2B,
                kCharacterLoChula                                                = 0x0E2C,
                kCharacterOAng                                                   = 0x0E2D,
                kCharacterHoNokhuk                                               = 0x0E2E,
                kCharacterPaiyannoi                                              = 0x0E2F,
                kCharacterSaraA                                                  = 0x0E30,
                kCharacterMaiHanAkat                                     = 0x0E31,
                kCharacterSaraAa                                                 = 0x0E32,
                kCharacterSaraAm                                                 = 0x0E33,
                kCharacterSaraI                                                  = 0x0E34,
                kCharacterSaraIi                                                 = 0x0E35,
                kCharacterSaraUe                                                 = 0x0E36,
                kCharacterSaraUee                                                = 0x0E37,
                kCharacterSaraU                                                  = 0x0E38,
                kCharacterSaraUu                                                 = 0x0E39,
                kCharacterPhinthu                                                = 0x0E3A,
                kCurrencySymbolBaht                                              = 0x0E3F,
                kCharacterSaraE                                                  = 0x0E40,
                kCharacterSaraAe                                                 = 0x0E41,
                kCharacterSaraO                                                  = 0x0E42,
                kCharacterSaraAiMaimuan                                  = 0x0E43,
                kCharacterSaraAiMaimalai                                 = 0x0E44,
                kCharacterLakkhangyao                                    = 0x0E45,
                kCharacterMaiyamok                                               = 0x0E46,
                kCharacterMaitaikhu                                              = 0x0E47,
                kCharacterMaiEk                                                  = 0x0E48,
                kCharacterMaiTho                                                 = 0x0E49,
                kCharacterMaiTri                                                 = 0x0E4A,
                kCharacterMaiChattawa                                    = 0x0E4B,
                kCharacterThanthakhat                                    = 0x0E4C,
                kCharacterNikhahit                                               = 0x0E4D,
                kCharacterYamakkan                                               = 0x0E4E,
                kCharacterFongman                                                = 0x0E4F,
                kDigitZero                                                               = 0x0E50,
                kDigitOne                                                                = 0x0E51,
                kDigitTwo                                                                = 0x0E52,
                kDigitThree                                                              = 0x0E53,
                kDigitFour                                                               = 0x0E54,
                kDigitFive                                                               = 0x0E55,
                kDigitSix                                                                = 0x0E56,
                kDigitSeven                                                              = 0x0E57,
                kDigitEight                                                              = 0x0E58,
                kDigitNine                                                               = 0x0E59,
                kCharacterAngkhankhu                                     = 0x0E5A,
                kCharacterKhomut                                                 = 0x0E5B
        };

private:

};







//=================================================================================
// class ULao
//=================================================================================

class ULao {

public:

        enum ELaoNames {

                kLetterKo                                                                = 0x0E81,
                kLetterKhoSung                                                   = 0x0E82,
                kLetterKhoTam                                                    = 0x0E84,
                kLetterNgo                                                               = 0x0E87,
                kLetterCo                                                                = 0x0E88,
                kLetterSoTam                                                     = 0x0E8A,
                kLetterNyo                                                               = 0x0E8D,
                kLetterDo                                                                = 0x0E94,
                kLetterTo                                                                = 0x0E95,
                kLetterThoSung                                                   = 0x0E96,
                kLetterThoTam                                                    = 0x0E97,
                kLetterNo                                                                = 0x0E99,
                kLetterBo                                                                = 0x0E9A,
                kLetterPo                                                                = 0x0E9B,
                kLetterPhoSung                                                   = 0x0E9C,
                kLetterFoTam                                                     = 0x0E9D,
                kLetterPhoTam                                                    = 0x0E9E,
                kLetterFoSung                                                    = 0x0E9F,
                kLetterMo                                                                = 0x0EA1,
                kLetterYo                                                                = 0x0EA2,
                kLetterLoLing                                                    = 0x0EA3,
                kLetterLoLoot                                                    = 0x0EA5,
                kLetterWo                                                                = 0x0EA7,
                kLetterSoSung                                                    = 0x0EAA,
                kLetterHoSung                                                    = 0x0EAB,
                kLetterO                                                                 = 0x0EAD,
                kLetterHoTam                                                     = 0x0EAE,
                kEllipsis                                                                = 0x0EAF,
                kVowelSignA                                                              = 0x0EB0,
                kVowelSignMaiKan                                                 = 0x0EB1,
                kVowelSignAa                                                     = 0x0EB2,
                kVowelSignAm                                                     = 0x0EB3,
                kVowelSignI                                                              = 0x0EB4,
                kVowelSignIi                                                     = 0x0EB5,
                kVowelSignY                                                              = 0x0EB6,
                kVowelSignYy                                                     = 0x0EB7,
                kVowelSignU                                                              = 0x0EB8,
                kVowelSignUu                                                     = 0x0EB9,
                kVowelSignMaiKon                                                 = 0x0EBB,
                kSemivowelSignLo                                                 = 0x0EBC,
                kSemivowelSignNyo                                                = 0x0EBD,
                kVowelSignE                                                              = 0x0EC0,
                kVowelSignEi                                                     = 0x0EC1,
                kVowelSignO                                                              = 0x0EC2,
                kVowelSignAy                                                     = 0x0EC3,
                kVowelSignAi                                                     = 0x0EC4,
                kKoLa                                                                    = 0x0EC6,
                kToneMaiEk                                                               = 0x0EC8,
                kToneMaiTho                                                              = 0x0EC9,
                kToneMaiTi                                                               = 0x0ECA,
                kToneMaiCatawa                                                   = 0x0ECB,
                kCancellationMark                                                = 0x0ECC,
                kNiggahita                                                               = 0x0ECD,
                kDigitZero                                                               = 0x0ED0,
                kDigitOne                                                                = 0x0ED1,
                kDigitTwo                                                                = 0x0ED2,
                kDigitThree                                                              = 0x0ED3,
                kDigitFour                                                               = 0x0ED4,
                kDigitFive                                                               = 0x0ED5,
                kDigitSix                                                                = 0x0ED6,
                kDigitSeven                                                              = 0x0ED7,
                kDigitEight                                                              = 0x0ED8,
                kDigitNine                                                               = 0x0ED9,
                kHoNo                                                                    = 0x0EDC,
                kHoMo                                                                    = 0x0EDD
        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUSASIA_
