// Revision: 95 1.9 source/core/text/unicode/iumeast.hpp, text, ocdev
// iumeast.hpp
/**
 * This file contains the classes UHebrew, UArabicl, UArmenian,
 * which provide information about the mideastern scripts.
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */


#ifndef _IUMEAST_
#define _IUMEAST_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class UHebrew;
class UArabic;
class UArmenian;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class UHebrew
//=================================================================================

class UHebrew {

public:

        enum EHebrewNames {

                kPointSheva                                                              = 0x05B0,
                kPointHatafSegol                                                 = 0x05B1,
                kPointHatafPatah                                                 = 0x05B2,
                kPointHatafQamats                                                = 0x05B3,
                kPointHiriq                                                              = 0x05B4,
                kPointTsere                                                              = 0x05B5,
                kPointSegol                                                              = 0x05B6,
                kPointPatah                                                              = 0x05B7,
                kPointQamats                                                     = 0x05B8,
                kPointHolam                                                              = 0x05B9,
                kPointQubuts                                                     = 0x05BB,
                kPointDageshOrMapiq                                              = 0x05BC,
                kPointMeteg                                                              = 0x05BD,
                kPunctuationMaqaf                                                = 0x05BE,
                kPointRafe                                                               = 0x05BF,
                kPunctuationPaseq                                                = 0x05C0,
                kPointShinDot                                                    = 0x05C1,
                kPointSinDot                                                     = 0x05C2,
                kPunctuationSofPasuq                                     = 0x05C3,
                kUpperDotMark                            = 0x05C4,
                kLetterAlef                                                              = 0x05D0,
                kLetterBet                                                               = 0x05D1,
                kLetterGimel                                                     = 0x05D2,
                kLetterDalet                                                     = 0x05D3,
                kLetterHe                                                                = 0x05D4,
                kLetterVav                                                               = 0x05D5,
                kLetterZayin                                                     = 0x05D6,
                kLetterHet                                                               = 0x05D7,
                kLetterTet                                                               = 0x05D8,
                kLetterYod                                                               = 0x05D9,
                kLetterFinalKaf                                                  = 0x05DA,
                kLetterKaf                                                               = 0x05DB,
                kLetterLamed                                                     = 0x05DC,
                kLetterFinalMem                                                  = 0x05DD,
                kLetterMem                                                               = 0x05DE,
                kLetterFinalNun                                                  = 0x05DF,
                kLetterNun                                                               = 0x05E0,
                kLetterSamekh                                                    = 0x05E1,
                kLetterAyin                                                              = 0x05E2,
                kLetterFinalPe                                                   = 0x05E3,
                kLetterPe                                                                = 0x05E4,
                kLetterFinalTsadi                                                = 0x05E5,
                kLetterTsadi                                                     = 0x05E6,
                kLetterQof                                                               = 0x05E7,
                kLetterResh                                                              = 0x05E8,
                kLetterShin                                                              = 0x05E9,
                kLetterTav                                                               = 0x05EA,
                kLigatureYiddishDoubleVav                                = 0x05F0,
                kLigatureYiddishVavYod                                   = 0x05F1,
                kLigatureYiddishDoubleYod                                = 0x05F2,
                kPunctuationGeresh                                               = 0x05F3,
                kPunctuationGershayim                                    = 0x05F4,
                kPointJudeoSpanishVarika                                 = 0xFB1E,
                kLigatureYiddishYodYodPatah                              = 0xFB1F,
                kLetterAlternativeAyin                                   = 0xFB20,
                kLetterWideAlef                                                  = 0xFB21,
                kLetterWideDalet                                                 = 0xFB22,
                kLetterWideHe                                                    = 0xFB23,
                kLetterWideKaf                                                   = 0xFB24,
                kLetterWideLamed                                                 = 0xFB25,
                kLetterWideFinalMem                                              = 0xFB26,
                kLetterWideResh                                                  = 0xFB27,
                kLetterWideTav                                                   = 0xFB28,
                kLetterAlternativePlusSign                               = 0xFB29,
                kLetterShinWithShinDot                                   = 0xFB2A,
                kLetterShinWithSinDot                                    = 0xFB2B,
                kLetterShinWithDageshAndShinDot                  = 0xFB2C,
                kLetterShinWithDageshAndSinDot                   = 0xFB2D,
                kLetterAlefWithPatah                                     = 0xFB2E,
                kLetterAlefWithQamats                                    = 0xFB2F,
                kLetterAlefWithMapiq                                     = 0xFB30,
                kLetterBetWithDagesh                                     = 0xFB31,
                kLetterGimelWithDagesh                                   = 0xFB32,
                kLetterDaletWithDagesh                                   = 0xFB33,
                kLetterHeWithMapiq                                               = 0xFB34,
                kLetterVavWithDagesh                                     = 0xFB35,
                kLetterZayinWithDagesh                                   = 0xFB36,
                kLetterTetWithDagesh                                     = 0xFB38,
                kLetterYodWithDagesh                                     = 0xFB39,
                kLetterFinalKafWithDagesh                                = 0xFB3A,
                kLetterKafWithDagesh                                     = 0xFB3B,
                kLetterLamedWithDagesh                                   = 0xFB3C,
                kLetterMemWithDagesh                                     = 0xFB3E,
                kLetterNunWithDagesh                                     = 0xFB40,
                kLetterSamekhWithDagesh                                  = 0xFB41,
                kLetterFinalPeWithDagesh                                 = 0xFB43,
                kLetterPeWithDagesh                                              = 0xFB44,
                kLetterTsadiWithDagesh                                   = 0xFB46,
                kLetterQofWithDagesh                                     = 0xFB47,
                kLetterReshWithDagesh                                    = 0xFB48,
                kLetterShinWithDagesh                                    = 0xFB49,
                kLetterTavWithDagesh                                     = 0xFB4A,
                kLetterVavWithHolam                                              = 0xFB4B,
                kLetterBetWithRafe                                               = 0xFB4C,
                kLetterKafWithRafe                                               = 0xFB4D,
                kLetterPeWithRafe                                                = 0xFB4E,
                kLigatureAlefLamed                                               = 0xFB4F,

                //      Values derived from Unicode 1.0 names

                kPointVarika                                             = kPointJudeoSpanishVarika
        };

private:

};







//=================================================================================
// class UArabic
//=================================================================================

class UArabic {

public:

        enum EArabicNames {

                kComma                                                                   = 0x060C,
                kSemicolon                                                               = 0x061B,
                kQuestionMark                                                    = 0x061F,
                kLetterHamza                                                     = 0x0621,
                kLetterAlefWithMaddaAbove                                = 0x0622,
                kLetterAlefWithHamzaAbove                                = 0x0623,
                kLetterWawWithHamzaAbove                                 = 0x0624,
                kLetterAlefWithHamzaBelow                                = 0x0625,
                kLetterYehWithHamzaAbove                                 = 0x0626,
                kLetterAlef                                                              = 0x0627,
                kLetterBeh                                                               = 0x0628,
                kLetterTehMarbuta                                                = 0x0629,
                kLetterTeh                                                               = 0x062A,
                kLetterTheh                                                              = 0x062B,
                kLetterJeem                                                              = 0x062C,
                kLetterHah                                                               = 0x062D,
                kLetterKhah                                                              = 0x062E,
                kLetterDal                                                               = 0x062F,
                kLetterThal                                                              = 0x0630,
                kLetterReh                                                               = 0x0631,
                kLetterZain                                                              = 0x0632,
                kLetterSeen                                                              = 0x0633,
                kLetterSheen                                                     = 0x0634,
                kLetterSad                                                               = 0x0635,
                kLetterDad                                                               = 0x0636,
                kLetterTah                                                               = 0x0637,
                kLetterZah                                                               = 0x0638,
                kLetterAin                                                               = 0x0639,
                kLetterGhain                                                     = 0x063A,
                kTatweel                                                                 = 0x0640,
                kLetterFeh                                                               = 0x0641,
                kLetterQaf                                                               = 0x0642,
                kLetterKaf                                                               = 0x0643,
                kLetterLam                                                               = 0x0644,
                kLetterMeem                                                              = 0x0645,
                kLetterNoon                                                              = 0x0646,
                kLetterHeh                                                               = 0x0647,
                kLetterWaw                                                               = 0x0648,
                kLetterAlefMaksura                                               = 0x0649,
                kLetterYeh                                                               = 0x064A,
                kFathatan                                                                = 0x064B,
                kDammatan                                                                = 0x064C,
                kKasratan                                                                = 0x064D,
                kFatha                                                                   = 0x064E,
                kDamma                                                                   = 0x064F,
                kKasra                                                                   = 0x0650,
                kShadda                                                                  = 0x0651,
                kSukun                                                                   = 0x0652,
                kIndicDigitZero                                                  = 0x0660,
                kIndicDigitOne                                                   = 0x0661,
                kIndicDigitTwo                                                   = 0x0662,
                kIndicDigitThree                                                 = 0x0663,
                kIndicDigitFour                                                  = 0x0664,
                kIndicDigitFive                                                  = 0x0665,
                kIndicDigitSix                                                   = 0x0666,
                kIndicDigitSeven                                                 = 0x0667,
                kIndicDigitEight                                                 = 0x0668,
                kIndicDigitNine                                                  = 0x0669,
                kPercentSign                                                     = 0x066A,
                kDecimalSeparator                                                = 0x066B,
                kThousandsSeparator                                              = 0x066C,
                kFivePointedStar                                                 = 0x066D,
                kLetterSuperscriptAlef                                   = 0x0670,
                kLetterAlefWasla                                                 = 0x0671,
                kLetterAlefWithWavyHamzaAbove                    = 0x0672,
                kLetterAlefWithWavyHamzaBelow                    = 0x0673,
                kLetterHighHamza                                                 = 0x0674,
                kLetterHighHamzaAlef                                     = 0x0675,
                kLetterHighHamzaWaw                                              = 0x0676,
                kLetterUWithHamzaAbove                                   = 0x0677,
                kLetterHighHamzaYeh                                              = 0x0678,
                kLetterTteh                                                              = 0x0679,
                kLetterTteheh                                                    = 0x067A,
                kLetterBeeh                                                              = 0x067B,
                kLetterTehWithRing                                               = 0x067C,
                kLetterTehWithThreeDotsAboveDownwards    = 0x067D,
                kLetterPeh                                                               = 0x067E,
                kLetterTeheh                                                     = 0x067F,
                kLetterBeheh                                                     = 0x0680,
                kLetterHahWithHamzaAbove                                 = 0x0681,
                kLetterHahWithTwoDotsVerticalAbove               = 0x0682,
                kLetterNyeh                                                              = 0x0683,
                kLetterDyeh                                                              = 0x0684,
                kLetterHahWithThreeDotsAbove                     = 0x0685,
                kLetterTcheh                                                     = 0x0686,
                kLetterTcheheh                                                   = 0x0687,
                kLetterDdal                                                              = 0x0688,
                kLetterDalWithRing                                               = 0x0689,
                kLetterDalWithDotBelow                                   = 0x068A,
                kLetterDalWithDotBelowAndSmallTah                = 0x068B,
                kLetterDahal                                                     = 0x068C,
                kLetterDdahal                                                    = 0x068D,
                kLetterDul                                                               = 0x068E,
                kLetterDalWithThreeDotsAboveDownwards    = 0x068F,
                kLetterDalWithFourDotsAbove                              = 0x0690,
                kLetterRreh                                                              = 0x0691,
                kLetterRehWithSmallV                                     = 0x0692,
                kLetterRehWithRing                                               = 0x0693,
                kLetterRehWithDotBelow                                   = 0x0694,
                kLetterRehWithSmallVBelow                                = 0x0695,
                kLetterRehWithDotBelowAndDotAbove                = 0x0696,
                kLetterRehWithTwoDotsAbove                               = 0x0697,
                kLetterJeh                                                               = 0x0698,
                kLetterRehWithFourDotsAbove                              = 0x0699,
                kLetterSeenWithDotBelowAndDotAbove               = 0x069A,
                kLetterSeenWithThreeDotsBelow                    = 0x069B,
                kLetterSeenWithThreeDotsBelowAndThreeDotsAbove = 0x069C,
                kLetterSadWithTwoDotsBelow                               = 0x069D,
                kLetterSadWithThreeDotsAbove                     = 0x069E,
                kLetterTahWithThreeDotsAbove                     = 0x069F,
                kLetterAinWithThreeDotsAbove                     = 0x06A0,
                kLetterDotlessFeh                                                = 0x06A1,
                kLetterFehWithDotMovedBelow                              = 0x06A2,
                kLetterFehWithDotBelow                                   = 0x06A3,
                kLetterVeh                                                               = 0x06A4,
                kLetterFehWithThreeDotsBelow                     = 0x06A5,
                kLetterPeheh                                                     = 0x06A6,
                kLetterQafWithDotAbove                                   = 0x06A7,
                kLetterQafWithThreeDotsAbove                     = 0x06A8,
                kLetterKeheh                                                     = 0x06A9,
                kLetterSwashKaf                                                  = 0x06AA,
                kLetterKafWithRing                                               = 0x06AB,
                kLetterKafWithDotAbove                                   = 0x06AC,
                kLetterNg                                                                = 0x06AD,
                kLetterKafWithThreeDotsBelow                     = 0x06AE,
                kLetterGaf                                                               = 0x06AF,
                kLetterGafWithRing                                               = 0x06B0,
                kLetterNgoeh                                                     = 0x06B1,
                kLetterGafWithTwoDotsBelow                               = 0x06B2,
                kLetterGueh                                                              = 0x06B3,
                kLetterGafWithThreeDotsAbove                     = 0x06B4,
                kLetterLamWithSmallV                                     = 0x06B5,
                kLetterLamWithDotAbove                                   = 0x06B6,
                kLetterLamWithThreeDotsAbove                     = 0x06B7,
                kLetterNoonGhunna                                                = 0x06BA,
                kLetterRnoon                                                     = 0x06BB,
                kLetterNoonWithRing                                              = 0x06BC,
                kLetterNoonWithThreeDotsAbove                    = 0x06BD,
                kLetterHehDoachashmee                                    = 0x06BE,
                kLetterHehWithYehAbove                                   = 0x06C0,
                kLetterHehGoal                                                   = 0x06C1,
                kLetterHehGoalWithHamzaAbove                     = 0x06C2,
                kLetterTehMarbutaGoal                                    = 0x06C3,
                kLetterWawWithRing                                               = 0x06C4,
                kLetterKirghizOe                                                 = 0x06C5,
                kLetterOe                                                                = 0x06C6,
                kLetterU                                                                 = 0x06C7,
                kLetterYu                                                                = 0x06C8,
                kLetterKirghizYu                                                 = 0x06C9,
                kLetterWawWithTwoDotsAbove                               = 0x06CA,
                kLetterVe                                                                = 0x06CB,
                kLetterFarsiYeh                                                  = 0x06CC,
                kLetterYehWithTail                                               = 0x06CD,
                kLetterYehWithSmallV                                     = 0x06CE,
                kLetterE                                                                 = 0x06D0,
                kLetterYehWithThreeDotsBelow                     = 0x06D1,
                kLetterYehBarree                                                 = 0x06D2,
                kLetterYehBarreeWithHamzaAbove                   = 0x06D3,
                kFullStop                                                                = 0x06D4,
                kLetterAe                                                                = 0x06D5,
                kSmallHighLigatureSadWithLamWithAlefMaksura = 0x06D6,
                kSmallHighLigatureQafWithLamWithAlefMaksura = 0x06D7,
                kSmallHighMeemInitialForm                                = 0x06D8,
                kSmallHighLamAlef                                                = 0x06D9,
                kSmallHighJeem                                                   = 0x06DA,
                kSmallHighThreeDots                                              = 0x06DB,
                kSmallHighSeen                                                   = 0x06DC,
                kEndOfAyah                                                               = 0x06DD,
                kStartOfRubElHizb                                                = 0x06DE,
                kSmallHighRoundedZero                                    = 0x06DF,
                kSmallHighUprightRectangularZero                 = 0x06E0,
                kSmallHighDotlessHeadOfKhah                              = 0x06E1,
                kSmallHighMeemIsolatedForm                               = 0x06E2,
                kSmallLowSeen                                                    = 0x06E3,
                kSmallHighMadda                                                  = 0x06E4,
                kSmallWaw                                                                = 0x06E5,
                kSmallYeh                                                                = 0x06E6,
                kSmallHighYeh                                                    = 0x06E7,
                kSmallHighNoon                                                   = 0x06E8,
                kPlaceOfSajdah                                                   = 0x06E9,
                kEmptyCentreLowStop                                              = 0x06EA,
                kEmptyCentreHighStop                                     = 0x06EB,
                kRoundedHighStopWithFilledCentre                 = 0x06EC,
                kSmallLowMeem                                                    = 0x06ED,
                kExtendedIndicDigitZero                                  = 0x06F0,
                kExtendedIndicDigitOne                                   = 0x06F1,
                kExtendedIndicDigitTwo                                   = 0x06F2,
                kExtendedIndicDigitThree                                 = 0x06F3,
                kExtendedIndicDigitFour                                  = 0x06F4,
                kExtendedIndicDigitFive                                  = 0x06F5,
                kExtendedIndicDigitSix                                   = 0x06F6,
                kExtendedIndicDigitSeven                                 = 0x06F7,
                kExtendedIndicDigitEight                                 = 0x06F8,
                kExtendedIndicDigitNine                                  = 0x06F9,
                kInhibitFormShaping                                              = 0x206C,
                kActivateFormShaping                                     = 0x206D
        };

private:

};







//=================================================================================
// class UArmenian
//=================================================================================

class UArmenian {

public:

        enum EArmenianNames {

                kCapitalLetterAyb                                                = 0x0531,
                kCapitalLetterBen                                                = 0x0532,
                kCapitalLetterGim                                                = 0x0533,
                kCapitalLetterDa                                                 = 0x0534,
                kCapitalLetterEch                                                = 0x0535,
                kCapitalLetterZa                                                 = 0x0536,
                kCapitalLetterEh                                                 = 0x0537,
                kCapitalLetterEt                                                 = 0x0538,
                kCapitalLetterTo                                                 = 0x0539,
                kCapitalLetterZhe                                                = 0x053A,
                kCapitalLetterIni                                                = 0x053B,
                kCapitalLetterLiwn                                               = 0x053C,
                kCapitalLetterXeh                                                = 0x053D,
                kCapitalLetterCa                                                 = 0x053E,
                kCapitalLetterKen                                                = 0x053F,
                kCapitalLetterHo                                                 = 0x0540,
                kCapitalLetterJa                                                 = 0x0541,
                kCapitalLetterGhad                                               = 0x0542,
                kCapitalLetterCheh                                               = 0x0543,
                kCapitalLetterMen                                                = 0x0544,
                kCapitalLetterYi                                                 = 0x0545,
                kCapitalLetterNow                                                = 0x0546,
                kCapitalLetterSha                                                = 0x0547,
                kCapitalLetterVo                                                 = 0x0548,
                kCapitalLetterCha                                                = 0x0549,
                kCapitalLetterPeh                                                = 0x054A,
                kCapitalLetterJheh                                               = 0x054B,
                kCapitalLetterRa                                                 = 0x054C,
                kCapitalLetterSeh                                                = 0x054D,
                kCapitalLetterVew                                                = 0x054E,
                kCapitalLetterTiwn                                               = 0x054F,
                kCapitalLetterReh                                                = 0x0550,
                kCapitalLetterCo                                                 = 0x0551,
                kCapitalLetterYiwn                                               = 0x0552,
                kCapitalLetterPiwr                                               = 0x0553,
                kCapitalLetterKeh                                                = 0x0554,
                kCapitalLetterOh                                                 = 0x0555,
                kCapitalLetterFeh                                                = 0x0556,
                kModifierLetterLeftHalfRing                              = 0x0559,
                kApostrophe                                                              = 0x055A,
                kEmphasisMark                                                    = 0x055B,
                kExclamationMark                                                 = 0x055C,
                kComma                                                                   = 0x055D,
                kQuestionMark                                                    = 0x055E,
                kAbbreviationMark                                                = 0x055F,
                kSmallLetterAyb                                                  = 0x0561,
                kSmallLetterBen                                                  = 0x0562,
                kSmallLetterGim                                                  = 0x0563,
                kSmallLetterDa                                                   = 0x0564,
                kSmallLetterEch                                                  = 0x0565,
                kSmallLetterZa                                                   = 0x0566,
                kSmallLetterEh                                                   = 0x0567,
                kSmallLetterEt                                                   = 0x0568,
                kSmallLetterTo                                                   = 0x0569,
                kSmallLetterZhe                                                  = 0x056A,
                kSmallLetterIni                                                  = 0x056B,
                kSmallLetterLiwn                                                 = 0x056C,
                kSmallLetterXeh                                                  = 0x056D,
                kSmallLetterCa                                                   = 0x056E,
                kSmallLetterKen                                                  = 0x056F,
                kSmallLetterHo                                                   = 0x0570,
                kSmallLetterJa                                                   = 0x0571,
                kSmallLetterGhad                                                 = 0x0572,
                kSmallLetterCheh                                                 = 0x0573,
                kSmallLetterMen                                                  = 0x0574,
                kSmallLetterYi                                                   = 0x0575,
                kSmallLetterNow                                                  = 0x0576,
                kSmallLetterSha                                                  = 0x0577,
                kSmallLetterVo                                                   = 0x0578,
                kSmallLetterCha                                                  = 0x0579,
                kSmallLetterPeh                                                  = 0x057A,
                kSmallLetterJheh                                                 = 0x057B,
                kSmallLetterRa                                                   = 0x057C,
                kSmallLetterSeh                                                  = 0x057D,
                kSmallLetterVew                                                  = 0x057E,
                kSmallLetterTiwn                                                 = 0x057F,
                kSmallLetterReh                                                  = 0x0580,
                kSmallLetterCo                                                   = 0x0581,
                kSmallLetterYiwn                                                 = 0x0582,
                kSmallLetterPiwr                                                 = 0x0583,
                kSmallLetterKeh                                                  = 0x0584,
                kSmallLetterOh                                                   = 0x0585,
                kSmallLetterFeh                                                  = 0x0586,
                kSmallLigatureEchYiwn                                    = 0x0587,
                kFullStop                                                                = 0x0589,

                //      Values derived from Unicode 1.0 names

                kPeriod                                                                  = kFullStop
        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUMEAST_
