// Revision: 40 1.8 source/ui/iuipl.hpp, basewin, ocdev, ocdevtest 

/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright Taligent, Inc.,  1996                                                 *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// iuipl.hpp - Pragma Library definitions for base

#ifndef _IUIPL_
#define _IUIPL_

#ifndef IC_IMPORTU
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTU  _Import
  #else
    #define IC_IMPORTU
  #endif
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef _IPRAGLIB_H
#include <ipraglib.h>
#endif

#if !defined(__NO_DEFAULT_LIBS__)
    #if !defined(__NO_UI_LIB__)
      	#if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
    		    #pragma comment(lib, OPENCLASS_LIBRARY_NAME_2(ui,ou))
            #else                   // VAC
    		    #pragma library(OPENCLASS_LIBRARY_NAME_2(ui,ou))
            #endif
            #if !defined(__IMPORTLIB__)
                #if defined(_MSC_VER)   // MSVC
                    #pragma comment(lib, "kernel32.lib")
                    #pragma comment(lib, "gdi32.lib")
                    #pragma comment(lib, "user32.lib")
                    #pragma comment(lib, "shell32.lib")
                    #pragma comment(lib, "advapi32.lib")
                    #pragma comment(lib, "comctl32.lib")
                    #pragma comment(lib, "comdlg32.lib")
                    #pragma comment(lib, "ole32.lib")
                #else                   // VAC
                    #pragma library("kernel32.lib")
                    #pragma library("gdi32.lib")
                    #pragma library("user32.lib")
                    #pragma library("shell32.lib")
                    #pragma library("advapi32.lib")
                    #pragma library("comctl32.lib")
                    #pragma library("comdlg32.lib")
                    #pragma library("ole32.lib")
                #endif
                #ifndef _IBASEPL_
                    #include <ibasepl.hpp>      // need base library
                #endif
                #ifndef _IGRAPHPL_
                    #include <igraphpl.hpp>     // need graph2d library
                #endif
            #endif
    	#elif defined(__OS2__)
        	#pragma library(OPENCLASS_LIBRARY_NAME_2(ui,ou))
            #if !defined(__IMPORTLIB__)
                #pragma library("os2386.lib")
                #ifndef _IBASEPL_
                    #include <ibasepl.hpp>      // need base library
                #endif
                #ifndef _IGRAPHPL_
                    #include <igraphpl.hpp>     // need graph2d library
                #endif
            #endif
      	#elif defined(_AIX)
      	    #if defined(__PRAGMA_LIBRARIES_VISIBLE__)
        		#pragma library(OPENCLASS_LIBRARY_NAME_2(ui,ou))
                // If we are building static, AIX cmake needs to see these in order to
                // put library references in the makefile.
                #if !defined(__IMPORTLIB__)
                    #pragma library("libpthreads.a")
                    #pragma library("libc_r.a")
                    #pragma library("libc.a")
                    #pragma library("libC_r.a")
                    #pragma library("libC.a")
                    #pragma library("libXmu.a")
                    #pragma library("libXm.a")
                    #pragma library("libXt.a")
                    #pragma library("libX11.a")
                    #pragma library("libipfx.a")
                    #ifndef _IBASEPL_
                        #include <ibasepl.hpp>      // need base library
                    #endif
                    #ifndef _IGRAPHPL_
                        #include <igraphpl.hpp>     // need graph2d library
                    #endif
                #endif // __IMPORTLIB__
            #endif // __PRAGMA_LIBRARIES_VISIBLE__
    	#endif // platform
    #else
        // This will be seen in the context of building the library only.
        #if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
                #pragma comment(lib, "kernel32.lib")
                #pragma comment(lib, "gdi32.lib")
                #pragma comment(lib, "user32.lib")
                #pragma comment(lib, "shell32.lib")
                #pragma comment(lib, "advapi32.lib")
                #pragma comment(lib, "comctl32.lib")
                #pragma comment(lib, "comdlg32.lib")
                #pragma comment(lib, "ole32.lib")
            #else                   // VAC
                #pragma library("kernel32.lib")
                #pragma library("gdi32.lib")
                #pragma library("user32.lib")
                #pragma library("shell32.lib")
                #pragma library("advapi32.lib")
                #pragma library("comctl32.lib")
                #pragma library("comdlg32.lib")
                #pragma library("ole32.lib")
            #endif
        #elif defined(__OS2__)
            #pragma library("os2386.lib")
        #elif defined(_AIX)
            #if defined(__PRAGMA_LIBRARIES_VISIBLE__)
                // AIX doesn't support pragma library statments, but
                // include system libraries needed so cmake can find them.
                #pragma library("libpthreads.a")
                #pragma library("libc_r.a")
                #pragma library("libc.a")
                #pragma library("libC_r.a")
                #pragma library("libC.a")
                #pragma library("libXmu.a")
                #pragma library("libXm.a")
                #pragma library("libXt.a")
                #pragma library("libX11.a")
                #pragma library("libipfx.a")
            #endif // __PRAGMA_LIBRARIES_VISIBLE__
        #endif // _AIX
    #endif // __NO_UI_LIB__
#endif  // __NO_DEFAULT_LIBS__

#endif // _IUIPL_
