// Revision: 96 1.12.1.4 source/core/text/unicode/iugnrl.hpp, text, ioc.v400, 980918 
// iueasia.hpp
/**
 * This file contains the classes ULatin, UModifierLetter, UCombining
 * UUnicodeDigit, UASCII, ULatin1, UGeneralPunctuation, UWhiteSpace,
 * UControlCode and UUnicodeSpecial which provide information about
 * the general utility characters
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */



#ifndef _IUGNRL_
#define _IUGNRL_

#include <iunicode.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ULatin;
class UModifierLetter;
class UCombining;
class UUnicodeDigit;
class UASCII;
class ULatin1;
class UGeneralPunctuation;
class UUnicodeSpecial;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class ULatin
//=================================================================================

class ULatin {

public:

        enum ELatinNames {

                kCapitalLetterA                                                  = 0x0041,
                kCapitalLetterB                                                  = 0x0042,
                kCapitalLetterC                                                  = 0x0043,
                kCapitalLetterD                                                  = 0x0044,
                kCapitalLetterE                                                  = 0x0045,
                kCapitalLetterF                                                  = 0x0046,
                kCapitalLetterG                                                  = 0x0047,
                kCapitalLetterH                                                  = 0x0048,
                kCapitalLetterI                                                  = 0x0049,
                kCapitalLetterJ                                                  = 0x004A,
                kCapitalLetterK                                                  = 0x004B,
                kCapitalLetterL                                                  = 0x004C,
                kCapitalLetterM                                                  = 0x004D,
                kCapitalLetterN                                                  = 0x004E,
                kCapitalLetterO                                                  = 0x004F,
                kCapitalLetterP                                                  = 0x0050,
                kCapitalLetterQ                                                  = 0x0051,
                kCapitalLetterR                                                  = 0x0052,
                kCapitalLetterS                                                  = 0x0053,
                kCapitalLetterT                                                  = 0x0054,
                kCapitalLetterU                                                  = 0x0055,
                kCapitalLetterV                                                  = 0x0056,
                kCapitalLetterW                                                  = 0x0057,
                kCapitalLetterX                                                  = 0x0058,
                kCapitalLetterY                                                  = 0x0059,
                kCapitalLetterZ                                                  = 0x005A,
                kSmallLetterA                                                    = 0x0061,
                kSmallLetterB                                                    = 0x0062,
                kSmallLetterC                                                    = 0x0063,
                kSmallLetterD                                                    = 0x0064,
                kSmallLetterE                                                    = 0x0065,
                kSmallLetterF                                                    = 0x0066,
                kSmallLetterG                                                    = 0x0067,
                kSmallLetterH                                                    = 0x0068,
                kSmallLetterI                                                    = 0x0069,
                kSmallLetterJ                                                    = 0x006A,
                kSmallLetterK                                                    = 0x006B,
                kSmallLetterL                                                    = 0x006C,
                kSmallLetterM                                                    = 0x006D,
                kSmallLetterN                                                    = 0x006E,
                kSmallLetterO                                                    = 0x006F,
                kSmallLetterP                                                    = 0x0070,
                kSmallLetterQ                                                    = 0x0071,
                kSmallLetterR                                                    = 0x0072,
                kSmallLetterS                                                    = 0x0073,
                kSmallLetterT                                                    = 0x0074,
                kSmallLetterU                                                    = 0x0075,
                kSmallLetterV                                                    = 0x0076,
                kSmallLetterW                                                    = 0x0077,
                kSmallLetterX                                                    = 0x0078,
                kSmallLetterY                                                    = 0x0079,
                kSmallLetterZ                                                    = 0x007A,
                kCapitalLetterAWithGrave                                 = 0x00C0,
                kCapitalLetterAWithAcute                                 = 0x00C1,
                kCapitalLetterAWithCircumflex                    = 0x00C2,
                kCapitalLetterAWithTilde                                 = 0x00C3,
                kCapitalLetterAWithDiaeresis                     = 0x00C4,
                kCapitalLetterAWithRingAbove                     = 0x00C5,
                kCapitalLigatureAe                                               = 0x00C6,
                kCapitalLetterCWithCedilla                               = 0x00C7,
                kCapitalLetterEWithGrave                                 = 0x00C8,
                kCapitalLetterEWithAcute                                 = 0x00C9,
                kCapitalLetterEWithCircumflex                    = 0x00CA,
                kCapitalLetterEWithDiaeresis                     = 0x00CB,
                kCapitalLetterIWithGrave                                 = 0x00CC,
                kCapitalLetterIWithAcute                                 = 0x00CD,
                kCapitalLetterIWithCircumflex                    = 0x00CE,
                kCapitalLetterIWithDiaeresis                     = 0x00CF,
                kCapitalLetterEth                                                = 0x00D0,
                kCapitalLetterNWithTilde                                 = 0x00D1,
                kCapitalLetterOWithGrave                                 = 0x00D2,
                kCapitalLetterOWithAcute                                 = 0x00D3,
                kCapitalLetterOWithCircumflex                    = 0x00D4,
                kCapitalLetterOWithTilde                                 = 0x00D5,
                kCapitalLetterOWithDiaeresis                     = 0x00D6,
                kCapitalLetterOWithStroke                                = 0x00D8,
                kCapitalLetterUWithGrave                                 = 0x00D9,
                kCapitalLetterUWithAcute                                 = 0x00DA,
                kCapitalLetterUWithCircumflex                    = 0x00DB,
                kCapitalLetterUWithDiaeresis                     = 0x00DC,
                kCapitalLetterYWithAcute                                 = 0x00DD,
                kCapitalLetterThorn                                              = 0x00DE,
                kSmallLetterSharpS                                               = 0x00DF,
                kSmallLetterAWithGrave                                   = 0x00E0,
                kSmallLetterAWithAcute                                   = 0x00E1,
                kSmallLetterAWithCircumflex                              = 0x00E2,
                kSmallLetterAWithTilde                                   = 0x00E3,
                kSmallLetterAWithDiaeresis                               = 0x00E4,
                kSmallLetterAWithRingAbove                               = 0x00E5,
                kSmallLigatureAe                                                 = 0x00E6,
                kSmallLetterCWithCedilla                                 = 0x00E7,
                kSmallLetterEWithGrave                                   = 0x00E8,
                kSmallLetterEWithAcute                                   = 0x00E9,
                kSmallLetterEWithCircumflex                              = 0x00EA,
                kSmallLetterEWithDiaeresis                               = 0x00EB,
                kSmallLetterIWithGrave                                   = 0x00EC,
                kSmallLetterIWithAcute                                   = 0x00ED,
                kSmallLetterIWithCircumflex                              = 0x00EE,
                kSmallLetterIWithDiaeresis                               = 0x00EF,
                kSmallLetterEth                                                  = 0x00F0,
                kSmallLetterNWithTilde                                   = 0x00F1,
                kSmallLetterOWithGrave                                   = 0x00F2,
                kSmallLetterOWithAcute                                   = 0x00F3,
                kSmallLetterOWithCircumflex                              = 0x00F4,
                kSmallLetterOWithTilde                                   = 0x00F5,
                kSmallLetterOWithDiaeresis                               = 0x00F6,
                kSmallLetterOWithStroke                                  = 0x00F8,
                kSmallLetterUWithGrave                                   = 0x00F9,
                kSmallLetterUWithAcute                                   = 0x00FA,
                kSmallLetterUWithCircumflex                              = 0x00FB,
                kSmallLetterUWithDiaeresis                               = 0x00FC,
                kSmallLetterYWithAcute                                   = 0x00FD,
                kSmallLetterThorn                                                = 0x00FE,
                kSmallLetterYWithDiaeresis                               = 0x00FF,
                kCapitalLetterAWithMacron                                = 0x0100,
                kSmallLetterAWithMacron                                  = 0x0101,
                kCapitalLetterAWithBreve                                 = 0x0102,
                kSmallLetterAWithBreve                                   = 0x0103,
                kCapitalLetterAWithOgonek                                = 0x0104,
                kSmallLetterAWithOgonek                                  = 0x0105,
                kCapitalLetterCWithAcute                                 = 0x0106,
                kSmallLetterCWithAcute                                   = 0x0107,
                kCapitalLetterCWithCircumflex                    = 0x0108,
                kSmallLetterCWithCircumflex                              = 0x0109,
                kCapitalLetterCWithDotAbove                              = 0x010A,
                kSmallLetterCWithDotAbove                                = 0x010B,
                kCapitalLetterCWithCaron                                 = 0x010C,
                kSmallLetterCWithCaron                                   = 0x010D,
                kCapitalLetterDWithCaron                                 = 0x010E,
                kSmallLetterDWithCaron                                   = 0x010F,
                kCapitalLetterDWithStroke                                = 0x0110,
                kSmallLetterDWithStroke                                  = 0x0111,
                kCapitalLetterEWithMacron                                = 0x0112,
                kSmallLetterEWithMacron                                  = 0x0113,
                kCapitalLetterEWithBreve                                 = 0x0114,
                kSmallLetterEWithBreve                                   = 0x0115,
                kCapitalLetterEWithDotAbove                              = 0x0116,
                kSmallLetterEWithDotAbove                                = 0x0117,
                kCapitalLetterEWithOgonek                                = 0x0118,
                kSmallLetterEWithOgonek                                  = 0x0119,
                kCapitalLetterEWithCaron                                 = 0x011A,
                kSmallLetterEWithCaron                                   = 0x011B,
                kCapitalLetterGWithCircumflex                    = 0x011C,
                kSmallLetterGWithCircumflex                              = 0x011D,
                kCapitalLetterGWithBreve                                 = 0x011E,
                kSmallLetterGWithBreve                                   = 0x011F,
                kCapitalLetterGWithDotAbove                              = 0x0120,
                kSmallLetterGWithDotAbove                                = 0x0121,
                kCapitalLetterGWithCedilla                               = 0x0122,
                kSmallLetterGWithCedilla                                 = 0x0123,
                kCapitalLetterHWithCircumflex                    = 0x0124,
                kSmallLetterHWithCircumflex                              = 0x0125,
                kCapitalLetterHWithStroke                                = 0x0126,
                kSmallLetterHWithStroke                                  = 0x0127,
                kCapitalLetterIWithTilde                                 = 0x0128,
                kSmallLetterIWithTilde                                   = 0x0129,
                kCapitalLetterIWithMacron                                = 0x012A,
                kSmallLetterIWithMacron                                  = 0x012B,
                kCapitalLetterIWithBreve                                 = 0x012C,
                kSmallLetterIWithBreve                                   = 0x012D,
                kCapitalLetterIWithOgonek                                = 0x012E,
                kSmallLetterIWithOgonek                                  = 0x012F,
                kCapitalLetterIWithDotAbove                              = 0x0130,
                kSmallLetterDotlessI                                     = 0x0131,
                kCapitalLigatureIj                                               = 0x0132,
                kSmallLigatureIj                                                 = 0x0133,
                kCapitalLetterJWithCircumflex                    = 0x0134,
                kSmallLetterJWithCircumflex                              = 0x0135,
                kCapitalLetterKWithCedilla                               = 0x0136,
                kSmallLetterKWithCedilla                                 = 0x0137,
                kSmallLetterKra                                          = 0x0138,
                kCapitalLetterLWithAcute                                 = 0x0139,
                kSmallLetterLWithAcute                                   = 0x013A,
                kCapitalLetterLWithCedilla                               = 0x013B,
                kSmallLetterLWithCedilla                                 = 0x013C,
                kCapitalLetterLWithCaron                                 = 0x013D,
                kSmallLetterLWithCaron                                   = 0x013E,
                kCapitalLetterLWithMiddleDot                     = 0x013F,
                kSmallLetterLWithMiddleDot                               = 0x0140,
                kCapitalLetterLWithStroke                                = 0x0141,
                kSmallLetterLWithStroke                                  = 0x0142,
                kCapitalLetterNWithAcute                                 = 0x0143,
                kSmallLetterNWithAcute                                   = 0x0144,
                kCapitalLetterNWithCedilla                               = 0x0145,
                kSmallLetterNWithCedilla                                 = 0x0146,
                kCapitalLetterNWithCaron                                 = 0x0147,
                kSmallLetterNWithCaron                                   = 0x0148,
                kSmallLetterNPrecededByApostrophe                = 0x0149,
                kCapitalLetterEng                                                = 0x014A,
                kSmallLetterEng                                          = 0x014B,
                kCapitalLetterOWithMacron                                = 0x014C,
                kSmallLetterOWithMacron                                  = 0x014D,
                kCapitalLetterOWithBreve                                 = 0x014E,
                kSmallLetterOWithBreve                                   = 0x014F,
                kCapitalLetterOWithDoubleAcute                   = 0x0150,
                kSmallLetterOWithDoubleAcute                     = 0x0151,
                kCapitalLigatureOe                                               = 0x0152,
                kSmallLigatureOe                                                 = 0x0153,
                kCapitalLetterRWithAcute                                 = 0x0154,
                kSmallLetterRWithAcute                                   = 0x0155,
                kCapitalLetterRWithCedilla                               = 0x0156,
                kSmallLetterRWithCedilla                                 = 0x0157,
                kCapitalLetterRWithCaron                                 = 0x0158,
                kSmallLetterRWithCaron                                   = 0x0159,
                kCapitalLetterSWithAcute                                 = 0x015A,
                kSmallLetterSWithAcute                                   = 0x015B,
                kCapitalLetterSWithCircumflex                    = 0x015C,
                kSmallLetterSWithCircumflex                              = 0x015D,
                kCapitalLetterSWithCedilla                               = 0x015E,
                kSmallLetterSWithCedilla                                 = 0x015F,
                kCapitalLetterSWithCaron                                 = 0x0160,
                kSmallLetterSWithCaron                                   = 0x0161,
                kCapitalLetterTWithCedilla                               = 0x0162,
                kSmallLetterTWithCedilla                                 = 0x0163,
                kCapitalLetterTWithCaron                                 = 0x0164,
                kSmallLetterTWithCaron                                   = 0x0165,
                kCapitalLetterTWithStroke                                = 0x0166,
                kSmallLetterTWithStroke                                  = 0x0167,
                kCapitalLetterUWithTilde                                 = 0x0168,
                kSmallLetterUWithTilde                                   = 0x0169,
                kCapitalLetterUWithMacron                                = 0x016A,
                kSmallLetterUWithMacron                                  = 0x016B,
                kCapitalLetterUWithBreve                                 = 0x016C,
                kSmallLetterUWithBreve                                   = 0x016D,
                kCapitalLetterUWithRingAbove                     = 0x016E,
                kSmallLetterUWithRingAbove                               = 0x016F,
                kCapitalLetterUWithDoubleAcute                   = 0x0170,
                kSmallLetterUWithDoubleAcute                     = 0x0171,
                kCapitalLetterUWithOgonek                                = 0x0172,
                kSmallLetterUWithOgonek                                  = 0x0173,
                kCapitalLetterWWithCircumflex                    = 0x0174,
                kSmallLetterWWithCircumflex                              = 0x0175,
                kCapitalLetterYWithCircumflex                    = 0x0176,
                kSmallLetterYWithCircumflex                              = 0x0177,
                kCapitalLetterYWithDiaeresis                     = 0x0178,
                kCapitalLetterZWithAcute                                 = 0x0179,
                kSmallLetterZWithAcute                                   = 0x017A,
                kCapitalLetterZWithDotAbove                              = 0x017B,
                kSmallLetterZWithDotAbove                                = 0x017C,
                kCapitalLetterZWithCaron                                 = 0x017D,
                kSmallLetterZWithCaron                                   = 0x017E,
                kSmallLetterLongS                                                = 0x017F,
                kSmallLetterBWithStroke                                  = 0x0180,
                kCapitalLetterBWithHook                                  = 0x0181,
                kCapitalLetterBWithTopbar                                = 0x0182,
                kSmallLetterBWithTopbar                                  = 0x0183,
                kCapitalLetterToneSix                                    = 0x0184,
                kSmallLetterToneSix                                              = 0x0185,
                kCapitalLetterOpenO                                              = 0x0186,
                kCapitalLetterCWithHook                                  = 0x0187,
                kSmallLetterCWithHook                                    = 0x0188,
                kCapitalLetterAfricanD                                   = 0x0189,
                kCapitalLetterDWithHook                                  = 0x018A,
                kCapitalLetterDWithTopbar                                = 0x018B,
                kSmallLetterDWithTopbar                                  = 0x018C,
                kSmallLetterTurnedDelta                                  = 0x018D,
                kCapitalLetterReversedE                                  = 0x018E,
                kCapitalLetterSchwa                                              = 0x018F,
                kCapitalLetterOpenE                                              = 0x0190,
                kCapitalLetterFWithHook                                  = 0x0191,
                kSmallLetterFWithHook                                    = 0x0192,
                kCapitalLetterGWithHook                                  = 0x0193,
                kCapitalLetterGamma                                              = 0x0194,
                kSmallLetterHv                                                   = 0x0195,
                kCapitalLetterIota                                               = 0x0196,
                kCapitalLetterIWithStroke                                = 0x0197,
                kCapitalLetterKWithHook                                  = 0x0198,
                kSmallLetterKWithHook                                    = 0x0199,
                kSmallLetterLWithBar                                     = 0x019A,
                kSmallLetterLambdaWithStroke                     = 0x019B,
                kCapitalLetterTurnedM                                    = 0x019C,
                kCapitalLetterNWithLeftHook                              = 0x019D,
                kSmallLetterNWithLongRightLeg                    = 0x019E,
                kCapitalLetterOWithMiddleTilde                   = 0x019F,
                kCapitalLetterOWithHorn                                  = 0x01A0,
                kSmallLetterOWithHorn                                    = 0x01A1,
                kCapitalLetterOi                                                 = 0x01A2,
                kSmallLetterOi                                                   = 0x01A3,
                kCapitalLetterPWithHook                                  = 0x01A4,
                kSmallLetterPWithHook                                    = 0x01A5,
                kLetterYr                                                                = 0x01A6,
                kCapitalLetterToneTwo                                    = 0x01A7,
                kSmallLetterToneTwo                                              = 0x01A8,
                kCapitalLetterEsh                                                = 0x01A9,
                kLetterReversedEshLoop                                   = 0x01AA,
                kSmallLetterTWithPalatalHook                     = 0x01AB,
                kCapitalLetterTWithHook                                  = 0x01AC,
                kSmallLetterTWithHook                                    = 0x01AD,
                kCapitalLetterTWithRetroflexHook                 = 0x01AE,
                kCapitalLetterUWithHorn                                  = 0x01AF,
                kSmallLetterUWithHorn                                    = 0x01B0,
                kCapitalLetterUpsilon                                    = 0x01B1,
                kCapitalLetterVWithHook                                  = 0x01B2,
                kCapitalLetterYWithHook                                  = 0x01B3,
                kSmallLetterYWithHook                                    = 0x01B4,
                kCapitalLetterZWithStroke                                = 0x01B5,
                kSmallLetterZWithStroke                                  = 0x01B6,
                kCapitalLetterEzh                                                = 0x01B7,
                kCapitalLetterEzhReversed                                = 0x01B8,
                kSmallLetterEzhReversed                                  = 0x01B9,
                kSmallLetterEzhWithTail                                  = 0x01BA,
                kLetterTwoWithStroke                                     = 0x01BB,
                kCapitalLetterToneFive                                   = 0x01BC,
                kSmallLetterToneFive                                     = 0x01BD,
                kLetterInvertedGlottalStopWithStroke     = 0x01BE,
                kLetterWynn                                                              = 0x01BF,
                kLetterDentalClick                                               = 0x01C0,
                kLetterLateralClick                                              = 0x01C1,
                kLetterAlveolarClick                                     = 0x01C2,
                kLetterRetroflexClick                                    = 0x01C3,
                kCapitalLetterDzWithCaron                                = 0x01C4,
                kCapitalLetterDWithSmallLetterZWithCaron = 0x01C5,
                kSmallLetterDzWithCaron                                  = 0x01C6,
                kCapitalLetterLj                                                 = 0x01C7,
                kCapitalLetterLWithSmallLetterJ                  = 0x01C8,
                kSmallLetterLj                                                   = 0x01C9,
                kCapitalLetterNj                                                 = 0x01CA,
                kCapitalLetterNWithSmallLetterJ                  = 0x01CB,
                kSmallLetterNj                                                   = 0x01CC,
                kCapitalLetterAWithCaron                                 = 0x01CD,
                kSmallLetterAWithCaron                                   = 0x01CE,
                kCapitalLetterIWithCaron                                 = 0x01CF,
                kSmallLetterIWithCaron                                   = 0x01D0,
                kCapitalLetterOWithCaron                                 = 0x01D1,
                kSmallLetterOWithCaron                                   = 0x01D2,
                kCapitalLetterUWithCaron                                 = 0x01D3,
                kSmallLetterUWithCaron                                   = 0x01D4,
                kCapitalLetterUWithDiaeresisAndMacron    = 0x01D5,
                kSmallLetterUWithDiaeresisAndMacron              = 0x01D6,
                kCapitalLetterUWithDiaeresisAndAcute     = 0x01D7,
                kSmallLetterUWithDiaeresisAndAcute               = 0x01D8,
                kCapitalLetterUWithDiaeresisAndCaron     = 0x01D9,
                kSmallLetterUWithDiaeresisAndCaron               = 0x01DA,
                kCapitalLetterUWithDiaeresisAndGrave     = 0x01DB,
                kSmallLetterUWithDiaeresisAndGrave               = 0x01DC,
                kSmallLetterTurnedE                                              = 0x01DD,
                kCapitalLetterAWithDiaeresisAndMacron    = 0x01DE,
                kSmallLetterAWithDiaeresisAndMacron              = 0x01DF,
                kCapitalLetterAWithDotAboveAndMacron     = 0x01E0,
                kSmallLetterAWithDotAboveAndMacron               = 0x01E1,
                kCapitalLigatureAeWithMacron                     = 0x01E2,
                kSmallLigatureAeWithMacron                               = 0x01E3,
                kCapitalLetterGWithStroke                                = 0x01E4,
                kSmallLetterGWithStroke                                  = 0x01E5,
                kCapitalLetterGWithCaron                                 = 0x01E6,
                kSmallLetterGWithCaron                                   = 0x01E7,
                kCapitalLetterKWithCaron                                 = 0x01E8,
                kSmallLetterKWithCaron                                   = 0x01E9,
                kCapitalLetterOWithOgonek                                = 0x01EA,
                kSmallLetterOWithOgonek                                  = 0x01EB,
                kCapitalLetterOWithOgonekAndMacron               = 0x01EC,
                kSmallLetterOWithOgonekAndMacron                 = 0x01ED,
                kCapitalLetterEzhWithCaron                               = 0x01EE,
                kSmallLetterEzhWithCaron                                 = 0x01EF,
                kSmallLetterJWithCaron                                   = 0x01F0,
                kCapitalLetterDz                                                 = 0x01F1,
                kCapitalLetterDWithSmallLetterZ                  = 0x01F2,
                kSmallLetterDz                                                   = 0x01F3,
                kCapitalLetterGWithAcute                                 = 0x01F4,
                kSmallLetterGWithAcute                                   = 0x01F5,
                kCapitalLetterAWithRingAboveAndAcute     = 0x01FA,
                kSmallLetterAWithRingAboveAndAcute               = 0x01FB,
                kCapitalLigatureAeWithAcute                              = 0x01FC,
                kSmallLigatureAeWithAcute                                = 0x01FD,
                kCapitalLetterOWithStrokeAndAcute                = 0x01FE,
                kSmallLetterOWithStrokeAndAcute                  = 0x01FF,
                kCapitalLetterAWithDoubleGrave                   = 0x0200,
                kSmallLetterAWithDoubleGrave                     = 0x0201,
                kCapitalLetterAWithInvertedBreve                 = 0x0202,
                kSmallLetterAWithInvertedBreve                   = 0x0203,
                kCapitalLetterEWithDoubleGrave                   = 0x0204,
                kSmallLetterEWithDoubleGrave                     = 0x0205,
                kCapitalLetterEWithInvertedBreve                 = 0x0206,
                kSmallLetterEWithInvertedBreve                   = 0x0207,
                kCapitalLetterIWithDoubleGrave                   = 0x0208,
                kSmallLetterIWithDoubleGrave                     = 0x0209,
                kCapitalLetterIWithInvertedBreve                 = 0x020A,
                kSmallLetterIWithInvertedBreve                   = 0x020B,
                kCapitalLetterOWithDoubleGrave                   = 0x020C,
                kSmallLetterOWithDoubleGrave                     = 0x020D,
                kCapitalLetterOWithInvertedBreve                 = 0x020E,
                kSmallLetterOWithInvertedBreve                   = 0x020F,
                kCapitalLetterRWithDoubleGrave                   = 0x0210,
                kSmallLetterRWithDoubleGrave                     = 0x0211,
                kCapitalLetterRWithInvertedBreve                 = 0x0212,
                kSmallLetterRWithInvertedBreve                   = 0x0213,
                kCapitalLetterUWithDoubleGrave                   = 0x0214,
                kSmallLetterUWithDoubleGrave                     = 0x0215,
                kCapitalLetterUWithInvertedBreve                 = 0x0216,
                kSmallLetterUWithInvertedBreve                   = 0x0217,
                kSmallLetterTurnedA                                              = 0x0250,
                kSmallLetterAlpha                                                = 0x0251,
                kSmallLetterTurnedAlpha                                  = 0x0252,
                kSmallLetterBWithHook                                    = 0x0253,
                kSmallLetterOpenO                                                = 0x0254,
                kSmallLetterCWithCurl                                    = 0x0255,
                kSmallLetterDWithTail                                    = 0x0256,
                kSmallLetterDWithHook                                    = 0x0257,
                kSmallLetterReversedE                                    = 0x0258,
                kSmallLetterSchwa                                                = 0x0259,
                kSmallLetterSchwaWithHook                                = 0x025A,
                kSmallLetterOpenE                                                = 0x025B,
                kSmallLetterReversedOpenE                                = 0x025C,
                kSmallLetterReversedOpenEWithHook                = 0x025D,
                kSmallLetterClosedReversedOpenE                  = 0x025E,
                kSmallLetterDotlessJWithStroke                   = 0x025F,
                kSmallLetterGWithHook                                    = 0x0260,
                kSmallLetterScriptG                                              = 0x0261,
                kLetterSmallCapitalG                                     = 0x0262,
                kSmallLetterGamma                                                = 0x0263,
                kSmallLetterRamsHorn                                     = 0x0264,
                kSmallLetterTurnedH                                              = 0x0265,
                kSmallLetterHWithHook                                    = 0x0266,
                kSmallLetterHengWithHook                                 = 0x0267,
                kSmallLetterIWithStroke                                  = 0x0268,
                kSmallLetterIota                                                 = 0x0269,
                kLetterSmallCapitalI                                     = 0x026A,
                kSmallLetterLWithMiddleTilde                     = 0x026B,
                kSmallLetterLWithBelt                                    = 0x026C,
                kSmallLetterLWithRetroflexHook                   = 0x026D,
                kSmallLetterLezh                                                 = 0x026E,
                kSmallLetterTurnedM                                              = 0x026F,
                kSmallLetterTurnedMWithLongLeg                   = 0x0270,
                kSmallLetterMWithHook                                    = 0x0271,
                kSmallLetterNWithLeftHook                                = 0x0272,
                kSmallLetterNWithRetroflexHook                   = 0x0273,
                kLetterSmallCapitalN                                     = 0x0274,
                kSmallLetterBarredO                                              = 0x0275,
                kLetterSmallCapitalOe                                    = 0x0276,
                kSmallLetterClosedOmega                                  = 0x0277,
                kSmallLetterPhi                                                  = 0x0278,
                kSmallLetterTurnedR                                              = 0x0279,
                kSmallLetterTurnedRWithLongLeg                   = 0x027A,
                kSmallLetterTurnedRWithHook                              = 0x027B,
                kSmallLetterRWithLongLeg                                 = 0x027C,
                kSmallLetterRWithTail                                    = 0x027D,
                kSmallLetterRWithFishhook                                = 0x027E,
                kSmallLetterReversedRWithFishhook                = 0x027F,
                kLetterSmallCapitalR                                     = 0x0280,
                kLetterSmallCapitalInvertedR                     = 0x0281,
                kSmallLetterSWithHook                                    = 0x0282,
                kSmallLetterEsh                                                  = 0x0283,
                kSmallLetterDotlessJWithStrokeAndHook    = 0x0284,
                kSmallLetterSquatReversedEsh                     = 0x0285,
                kSmallLetterEshWithCurl                                  = 0x0286,
                kSmallLetterTurnedT                                              = 0x0287,
                kSmallLetterTWithRetroflexHook                   = 0x0288,
                kSmallLetterUBar                                                 = 0x0289,
                kSmallLetterUpsilon                                              = 0x028A,
                kSmallLetterVWithHook                                    = 0x028B,
                kSmallLetterTurnedV                                              = 0x028C,
                kSmallLetterTurnedW                                              = 0x028D,
                kSmallLetterTurnedY                                              = 0x028E,
                kLetterSmallCapitalY                                     = 0x028F,
                kSmallLetterZWithRetroflexHook                   = 0x0290,
                kSmallLetterZWithCurl                                    = 0x0291,
                kSmallLetterEzh                                                  = 0x0292,
                kSmallLetterEzhWithCurl                                  = 0x0293,
                kLetterGlottalStop                                               = 0x0294,
                kLetterPharyngealVoicedFricative                 = 0x0295,
                kLetterInvertedGlottalStop                               = 0x0296,
                kLetterStretchedC                                                = 0x0297,
                kLetterBilabialClick                                     = 0x0298,
                kLetterSmallCapitalB                                     = 0x0299,
                kSmallLetterClosedOpenE                                  = 0x029A,
                kLetterSmallCapitalGWithHook                     = 0x029B,
                kLetterSmallCapitalH                                     = 0x029C,
                kSmallLetterJWithCrossedTail                     = 0x029D,
                kSmallLetterTurnedK                                              = 0x029E,
                kLetterSmallCapitalL                                     = 0x029F,
                kSmallLetterQWithHook                                    = 0x02A0,
                kLetterGlottalStopWithStroke                     = 0x02A1,
                kLetterReversedGlottalStopWithStroke     = 0x02A2,
                kSmallLetterDzDigraph                                    = 0x02A3,
                kSmallLetterDezhDigraph                                  = 0x02A4,
                kSmallLetterDzDigraphWithCurl                    = 0x02A5,
                kSmallLetterTsDigraph                                    = 0x02A6,
                kSmallLetterTeshDigraph                                  = 0x02A7,
                kSmallLetterTcDigraphWithCurl                    = 0x02A8,
                kCapitalLetterAWithRingBelow                     = 0x1E00,
                kSmallLetterAWithRingBelow                               = 0x1E01,
                kCapitalLetterBWithDotAbove                              = 0x1E02,
                kSmallLetterBWithDotAbove                                = 0x1E03,
                kCapitalLetterBWithDotBelow                              = 0x1E04,
                kSmallLetterBWithDotBelow                                = 0x1E05,
                kCapitalLetterBWithLineBelow                     = 0x1E06,
                kSmallLetterBWithLineBelow                               = 0x1E07,
                kCapitalLetterCWithCedillaAndAcute               = 0x1E08,
                kSmallLetterCWithCedillaAndAcute                 = 0x1E09,
                kCapitalLetterDWithDotAbove                              = 0x1E0A,
                kSmallLetterDWithDotAbove                                = 0x1E0B,
                kCapitalLetterDWithDotBelow                              = 0x1E0C,
                kSmallLetterDWithDotBelow                                = 0x1E0D,
                kCapitalLetterDWithLineBelow                     = 0x1E0E,
                kSmallLetterDWithLineBelow                               = 0x1E0F,
                kCapitalLetterDWithCedilla                               = 0x1E10,
                kSmallLetterDWithCedilla                                 = 0x1E11,
                kCapitalLetterDWithCircumflexBelow               = 0x1E12,
                kSmallLetterDWithCircumflexBelow                 = 0x1E13,
                kCapitalLetterEWithMacronAndGrave                = 0x1E14,
                kSmallLetterEWithMacronAndGrave                  = 0x1E15,
                kCapitalLetterEWithMacronAndAcute                = 0x1E16,
                kSmallLetterEWithMacronAndAcute                  = 0x1E17,
                kCapitalLetterEWithCircumflexBelow               = 0x1E18,
                kSmallLetterEWithCircumflexBelow                 = 0x1E19,
                kCapitalLetterEWithTildeBelow                    = 0x1E1A,
                kSmallLetterEWithTildeBelow                              = 0x1E1B,
                kCapitalLetterEWithCedillaAndBreve               = 0x1E1C,
                kSmallLetterEWithCedillaAndBreve                 = 0x1E1D,
                kCapitalLetterFWithDotAbove                              = 0x1E1E,
                kSmallLetterFWithDotAbove                                = 0x1E1F,
                kCapitalLetterGWithMacron                                = 0x1E20,
                kSmallLetterGWithMacron                                  = 0x1E21,
                kCapitalLetterHWithDotAbove                              = 0x1E22,
                kSmallLetterHWithDotAbove                                = 0x1E23,
                kCapitalLetterHWithDotBelow                              = 0x1E24,
                kSmallLetterHWithDotBelow                                = 0x1E25,
                kCapitalLetterHWithDiaeresis                     = 0x1E26,
                kSmallLetterHWithDiaeresis                               = 0x1E27,
                kCapitalLetterHWithCedilla                               = 0x1E28,
                kSmallLetterHWithCedilla                                 = 0x1E29,
                kCapitalLetterHWithBreveBelow                    = 0x1E2A,
                kSmallLetterHWithBreveBelow                              = 0x1E2B,
                kCapitalLetterIWithTildeBelow                    = 0x1E2C,
                kSmallLetterIWithTildeBelow                              = 0x1E2D,
                kCapitalLetterIWithDiaeresisAndAcute     = 0x1E2E,
                kSmallLetterIWithDiaeresisAndAcute               = 0x1E2F,
                kCapitalLetterKWithAcute                                 = 0x1E30,
                kSmallLetterKWithAcute                                   = 0x1E31,
                kCapitalLetterKWithDotBelow                              = 0x1E32,
                kSmallLetterKWithDotBelow                                = 0x1E33,
                kCapitalLetterKWithLineBelow                     = 0x1E34,
                kSmallLetterKWithLineBelow                               = 0x1E35,
                kCapitalLetterLWithDotBelow                              = 0x1E36,
                kSmallLetterLWithDotBelow                                = 0x1E37,
                kCapitalLetterLWithDotBelowAndMacron     = 0x1E38,
                kSmallLetterLWithDotBelowAndMacron               = 0x1E39,
                kCapitalLetterLWithLineBelow                     = 0x1E3A,
                kSmallLetterLWithLineBelow                               = 0x1E3B,
                kCapitalLetterLWithCircumflexBelow               = 0x1E3C,
                kSmallLetterLWithCircumflexBelow                 = 0x1E3D,
                kCapitalLetterMWithAcute                                 = 0x1E3E,
                kSmallLetterMWithAcute                                   = 0x1E3F,
                kCapitalLetterMWithDotAbove                              = 0x1E40,
                kSmallLetterMWithDotAbove                                = 0x1E41,
                kCapitalLetterMWithDotBelow                              = 0x1E42,
                kSmallLetterMWithDotBelow                                = 0x1E43,
                kCapitalLetterNWithDotAbove                              = 0x1E44,
                kSmallLetterNWithDotAbove                                = 0x1E45,
                kCapitalLetterNWithDotBelow                              = 0x1E46,
                kSmallLetterNWithDotBelow                                = 0x1E47,
                kCapitalLetterNWithLineBelow                     = 0x1E48,
                kSmallLetterNWithLineBelow                               = 0x1E49,
                kCapitalLetterNWithCircumflexBelow               = 0x1E4A,
                kSmallLetterNWithCircumflexBelow                 = 0x1E4B,
                kCapitalLetterOWithTildeAndAcute                 = 0x1E4C,
                kSmallLetterOWithTildeAndAcute                   = 0x1E4D,
                kCapitalLetterOWithTildeAndDiaeresis     = 0x1E4E,
                kSmallLetterOWithTildeAndDiaeresis               = 0x1E4F,
                kCapitalLetterOWithMacronAndGrave                = 0x1E50,
                kSmallLetterOWithMacronAndGrave                  = 0x1E51,
                kCapitalLetterOWithMacronAndAcute                = 0x1E52,
                kSmallLetterOWithMacronAndAcute                  = 0x1E53,
                kCapitalLetterPWithAcute                                 = 0x1E54,
                kSmallLetterPWithAcute                                   = 0x1E55,
                kCapitalLetterPWithDotAbove                              = 0x1E56,
                kSmallLetterPWithDotAbove                                = 0x1E57,
                kCapitalLetterRWithDotAbove                              = 0x1E58,
                kSmallLetterRWithDotAbove                                = 0x1E59,
                kCapitalLetterRWithDotBelow                              = 0x1E5A,
                kSmallLetterRWithDotBelow                                = 0x1E5B,
                kCapitalLetterRWithDotBelowAndMacron     = 0x1E5C,
                kSmallLetterRWithDotBelowAndMacron               = 0x1E5D,
                kCapitalLetterRWithLineBelow                     = 0x1E5E,
                kSmallLetterRWithLineBelow                               = 0x1E5F,
                kCapitalLetterSWithDotAbove                              = 0x1E60,
                kSmallLetterSWithDotAbove                                = 0x1E61,
                kCapitalLetterSWithDotBelow                              = 0x1E62,
                kSmallLetterSWithDotBelow                                = 0x1E63,
                kCapitalLetterSWithAcuteAndDotAbove              = 0x1E64,
                kSmallLetterSWithAcuteAndDotAbove                = 0x1E65,
                kCapitalLetterSWithCaronAndDotAbove              = 0x1E66,
                kSmallLetterSWithCaronAndDotAbove                = 0x1E67,
                kCapitalLetterSWithDotBelowAndDotAbove   = 0x1E68,
                kSmallLetterSWithDotBelowAndDotAbove     = 0x1E69,
                kCapitalLetterTWithDotAbove                              = 0x1E6A,
                kSmallLetterTWithDotAbove                                = 0x1E6B,
                kCapitalLetterTWithDotBelow                              = 0x1E6C,
                kSmallLetterTWithDotBelow                                = 0x1E6D,
                kCapitalLetterTWithLineBelow                     = 0x1E6E,
                kSmallLetterTWithLineBelow                               = 0x1E6F,
                kCapitalLetterTWithCircumflexBelow               = 0x1E70,
                kSmallLetterTWithCircumflexBelow                 = 0x1E71,
                kCapitalLetterUWithDiaeresisBelow                = 0x1E72,
                kSmallLetterUWithDiaeresisBelow                  = 0x1E73,
                kCapitalLetterUWithTildeBelow                    = 0x1E74,
                kSmallLetterUWithTildeBelow                              = 0x1E75,
                kCapitalLetterUWithCircumflexBelow               = 0x1E76,
                kSmallLetterUWithCircumflexBelow                 = 0x1E77,
                kCapitalLetterUWithTildeAndAcute                 = 0x1E78,
                kSmallLetterUWithTildeAndAcute                   = 0x1E79,
                kCapitalLetterUWithMacronAndDiaeresis    = 0x1E7A,
                kSmallLetterUWithMacronAndDiaeresis              = 0x1E7B,
                kCapitalLetterVWithTilde                                 = 0x1E7C,
                kSmallLetterVWithTilde                                   = 0x1E7D,
                kCapitalLetterVWithDotBelow                              = 0x1E7E,
                kSmallLetterVWithDotBelow                                = 0x1E7F,
                kCapitalLetterWWithGrave                                 = 0x1E80,
                kSmallLetterWWithGrave                                   = 0x1E81,
                kCapitalLetterWWithAcute                                 = 0x1E82,
                kSmallLetterWWithAcute                                   = 0x1E83,
                kCapitalLetterWWithDiaeresis                     = 0x1E84,
                kSmallLetterWWithDiaeresis                               = 0x1E85,
                kCapitalLetterWWithDotAbove                              = 0x1E86,
                kSmallLetterWWithDotAbove                                = 0x1E87,
                kCapitalLetterWWithDotBelow                              = 0x1E88,
                kSmallLetterWWithDotBelow                                = 0x1E89,
                kCapitalLetterXWithDotAbove                              = 0x1E8A,
                kSmallLetterXWithDotAbove                                = 0x1E8B,
                kCapitalLetterXWithDiaeresis                     = 0x1E8C,
                kSmallLetterXWithDiaeresis                               = 0x1E8D,
                kCapitalLetterYWithDotAbove                              = 0x1E8E,
                kSmallLetterYWithDotAbove                                = 0x1E8F,
                kCapitalLetterZWithCircumflex                    = 0x1E90,
                kSmallLetterZWithCircumflex                              = 0x1E91,
                kCapitalLetterZWithDotBelow                              = 0x1E92,
                kSmallLetterZWithDotBelow                                = 0x1E93,
                kCapitalLetterZWithLineBelow                     = 0x1E94,
                kSmallLetterZWithLineBelow                               = 0x1E95,
                kSmallLetterHWithLineBelow                               = 0x1E96,
                kSmallLetterTWithDiaeresis                               = 0x1E97,
                kSmallLetterWWithRingAbove                               = 0x1E98,
                kSmallLetterYWithRingAbove                               = 0x1E99,
                kSmallLetterAWithRightHalfRing                   = 0x1E9A,
                kCapitalLetterAWithDotBelow                              = 0x1EA0,
                kSmallLetterAWithDotBelow                                = 0x1EA1,
                kCapitalLetterAWithHookAbove                     = 0x1EA2,
                kSmallLetterAWithHookAbove                               = 0x1EA3,
                kCapitalLetterAWithCircumflexAndAcute    = 0x1EA4,
                kSmallLetterAWithCircumflexAndAcute              = 0x1EA5,
                kCapitalLetterAWithCircumflexAndGrave    = 0x1EA6,
                kSmallLetterAWithCircumflexAndGrave              = 0x1EA7,
                kCapitalLetterAWithCircumflexAndHookAbove = 0x1EA8,
                kSmallLetterAWithCircumflexAndHookAbove  = 0x1EA9,
                kCapitalLetterAWithCircumflexAndTilde    = 0x1EAA,
                kSmallLetterAWithCircumflexAndTilde              = 0x1EAB,
                kCapitalLetterAWithCircumflexAndDotBelow = 0x1EAC,
                kSmallLetterAWithCircumflexAndDotBelow   = 0x1EAD,
                kCapitalLetterAWithBreveAndAcute                 = 0x1EAE,
                kSmallLetterAWithBreveAndAcute                   = 0x1EAF,
                kCapitalLetterAWithBreveAndGrave                 = 0x1EB0,
                kSmallLetterAWithBreveAndGrave                   = 0x1EB1,
                kCapitalLetterAWithBreveAndHookAbove     = 0x1EB2,
                kSmallLetterAWithBreveAndHookAbove               = 0x1EB3,
                kCapitalLetterAWithBreveAndTilde                 = 0x1EB4,
                kSmallLetterAWithBreveAndTilde                   = 0x1EB5,
                kCapitalLetterAWithBreveAndDotBelow              = 0x1EB6,
                kSmallLetterAWithBreveAndDotBelow                = 0x1EB7,
                kCapitalLetterEWithDotBelow                              = 0x1EB8,
                kSmallLetterEWithDotBelow                                = 0x1EB9,
                kCapitalLetterEWithHookAbove                     = 0x1EBA,
                kSmallLetterEWithHookAbove                               = 0x1EBB,
                kCapitalLetterEWithTilde                                 = 0x1EBC,
                kSmallLetterEWithTilde                                   = 0x1EBD,
                kCapitalLetterEWithCircumflexAndAcute    = 0x1EBE,
                kSmallLetterEWithCircumflexAndAcute              = 0x1EBF,
                kCapitalLetterEWithCircumflexAndGrave    = 0x1EC0,
                kSmallLetterEWithCircumflexAndGrave              = 0x1EC1,
                kCapitalLetterEWithCircumflexAndHookAbove = 0x1EC2,
                kSmallLetterEWithCircumflexAndHookAbove  = 0x1EC3,
                kCapitalLetterEWithCircumflexAndTilde    = 0x1EC4,
                kSmallLetterEWithCircumflexAndTilde              = 0x1EC5,
                kCapitalLetterEWithCircumflexAndDotBelow = 0x1EC6,
                kSmallLetterEWithCircumflexAndDotBelow   = 0x1EC7,
                kCapitalLetterIWithHookAbove                     = 0x1EC8,
                kSmallLetterIWithHookAbove                               = 0x1EC9,
                kCapitalLetterIWithDotBelow                              = 0x1ECA,
                kSmallLetterIWithDotBelow                                = 0x1ECB,
                kCapitalLetterOWithDotBelow                              = 0x1ECC,
                kSmallLetterOWithDotBelow                                = 0x1ECD,
                kCapitalLetterOWithHookAbove                     = 0x1ECE,
                kSmallLetterOWithHookAbove                               = 0x1ECF,
                kCapitalLetterOWithCircumflexAndAcute    = 0x1ED0,
                kSmallLetterOWithCircumflexAndAcute              = 0x1ED1,
                kCapitalLetterOWithCircumflexAndGrave    = 0x1ED2,
                kSmallLetterOWithCircumflexAndGrave              = 0x1ED3,
                kCapitalLetterOWithCircumflexAndHookAbove = 0x1ED4,
                kSmallLetterOWithCircumflexAndHookAbove  = 0x1ED5,
                kCapitalLetterOWithCircumflexAndTilde    = 0x1ED6,
                kSmallLetterOWithCircumflexAndTilde              = 0x1ED7,
                kCapitalLetterOWithCircumflexAndDotBelow = 0x1ED8,
                kSmallLetterOWithCircumflexAndDotBelow   = 0x1ED9,
                kCapitalLetterOWithHornAndAcute                  = 0x1EDA,
                kSmallLetterOWithHornAndAcute                    = 0x1EDB,
                kCapitalLetterOWithHornAndGrave                  = 0x1EDC,
                kSmallLetterOWithHornAndGrave                    = 0x1EDD,
                kCapitalLetterOWithHornAndHookAbove              = 0x1EDE,
                kSmallLetterOWithHornAndHookAbove                = 0x1EDF,
                kCapitalLetterOWithHornAndTilde                  = 0x1EE0,
                kSmallLetterOWithHornAndTilde                    = 0x1EE1,
                kCapitalLetterOWithHornAndDotBelow               = 0x1EE2,
                kSmallLetterOWithHornAndDotBelow                 = 0x1EE3,
                kCapitalLetterUWithDotBelow                              = 0x1EE4,
                kSmallLetterUWithDotBelow                                = 0x1EE5,
                kCapitalLetterUWithHookAbove                     = 0x1EE6,
                kSmallLetterUWithHookAbove                               = 0x1EE7,
                kCapitalLetterUWithHornAndAcute                  = 0x1EE8,
                kSmallLetterUWithHornAndAcute                    = 0x1EE9,
                kCapitalLetterUWithHornAndGrave                  = 0x1EEA,
                kSmallLetterUWithHornAndGrave                    = 0x1EEB,
                kCapitalLetterUWithHornAndHookAbove              = 0x1EEC,
                kSmallLetterUWithHornAndHookAbove                = 0x1EED,
                kCapitalLetterUWithHornAndTilde                  = 0x1EEE,
                kSmallLetterUWithHornAndTilde                    = 0x1EEF,
                kCapitalLetterUWithHornAndDotBelow               = 0x1EF0,
                kSmallLetterUWithHornAndDotBelow                 = 0x1EF1,
                kCapitalLetterYWithGrave                                 = 0x1EF2,
                kSmallLetterYWithGrave                                   = 0x1EF3,
                kCapitalLetterYWithDotBelow                              = 0x1EF4,
                kSmallLetterYWithDotBelow                                = 0x1EF5,
                kCapitalLetterYWithHookAbove                     = 0x1EF6,
                kSmallLetterYWithHookAbove                               = 0x1EF7,
                kCapitalLetterYWithTilde                                 = 0x1EF8,
                kSmallLetterYWithTilde                                   = 0x1EF9
        };

private:

};







//=================================================================================
// class UModifierLetter
//=================================================================================

class UModifierLetter {

public:

        enum EModifierLetterNames {

                kSmallH                                                                  = 0x02B0,
                kSmallHWithHook                                                  = 0x02B1,
                kSmallJ                                                                  = 0x02B2,
                kSmallR                                                                  = 0x02B3,
                kSmallTurnedR                                                    = 0x02B4,
                kSmallTurnedRWithHook                                    = 0x02B5,
                kSmallCapitalInvertedR                                   = 0x02B6,
                kSmallW                                                                  = 0x02B7,
                kSmallY                                                                  = 0x02B8,
                kPrime                                                                   = 0x02B9,
                kDoublePrime                                                     = 0x02BA,
                kTurnedComma                                                     = 0x02BB,
                kApostrophe                                                              = 0x02BC,
                kReversedComma                                                   = 0x02BD,
                kRightHalfRing                                                   = 0x02BE,
                kLeftHalfRing                                                    = 0x02BF,
                kGlottalStop                                                     = 0x02C0,
                kReversedGlottalStop                                     = 0x02C1,
                kLeftArrowhead                                                   = 0x02C2,
                kRightArrowhead                                                  = 0x02C3,
                kUpArrowhead                                                     = 0x02C4,
                kDownArrowhead                                                   = 0x02C5,
                kCircumflexAccent                                                = 0x02C6,
                kCaron                                                                   = 0x02C7,
                kVerticalLine                                                    = 0x02C8,
                kMacron                                                          = 0x02C9,
                kAcuteAccent                                                     = 0x02CA,
                kGraveAccent                                                     = 0x02CB,
                kLowVerticalLine                                                 = 0x02CC,
                kLowMacron                                                               = 0x02CD,
                kLowGraveAccent                                                  = 0x02CE,
                kLowAcuteAccent                                                  = 0x02CF,
                kTriangularColon                                                 = 0x02D0,
                kHalfTriangularColon                                     = 0x02D1,
                kCentredRightHalfRing                                    = 0x02D2,
                kCentredLeftHalfRing                                     = 0x02D3,
                kUpTack                                                                  = 0x02D4,
                kDownTack                                                                = 0x02D5,
                kPlusSign                                                                = 0x02D6,
                kMinusSign                                                               = 0x02D7,
                kBreve                                                                   = 0x02D8,
                kDotAbove                                                                = 0x02D9,
                kRingAbove                                                               = 0x02DA,
                kOgonek                                                                  = 0x02DB,
                kSmallTilde                                                              = 0x02DC,
                kDoubleAcuteAccent                                               = 0x02DD,
                kRhoticHook                                                              = 0x02DE,
                kSmallGamma                                                              = 0x02E0,
                kSmallL                                                                  = 0x02E1,
                kSmallS                                                                  = 0x02E2,
                kSmallX                                                                  = 0x02E3,
                kSmallReversedGlottalStop                                = 0x02E4,
                kExtraHighToneBar                                                = 0x02E5,
                kHighToneBar                                                     = 0x02E6,
                kMidToneBar                                                              = 0x02E7,
                kLowToneBar                                                              = 0x02E8,
                kExtraLowToneBar                                                 = 0x02E9,
                kArmenianLeftHalfRing                                    = 0x0559,
                kArmenianApostrophe                      = 0x055A,
        kArmenianEmphasisMark                    = 0x055B,
                kArmenianExclamationMark                 = 0x055C,
                kArmenianComma                           = 0x055D,
                kArmenianQuestionMark                    = 0x055E,
                kArmenianAbbreviationMark                = 0x055F
        };

private:

};







//=================================================================================
// class UCombining
//=================================================================================

class UCombining {

public:

        enum ECombiningNames {

                kGraveAccent                                                     = 0x0300,
                kAcuteAccent                                                     = 0x0301,
                kCircumflexAccent                                                = 0x0302,
                kTilde                                                                   = 0x0303,
                kMacron                                                                  = 0x0304,
                kOverline                                                                = 0x0305,
                kBreve                                                                   = 0x0306,
                kDotAbove                                                                = 0x0307,
                kDiaeresis                                                               = 0x0308,
                kHookAbove                                                               = 0x0309,
                kRingAbove                                                               = 0x030A,
                kDoubleAcuteAccent                                               = 0x030B,
                kCaron                                                                   = 0x030C,
                kVerticalLineAbove                                               = 0x030D,
                kDoubleVerticalLineAbove                                 = 0x030E,
                kDoubleGraveAccent                                               = 0x030F,
                kCandrabindu                                                     = 0x0310,
                kInvertedBreve                                                   = 0x0311,
                kTurnedCommaAbove                                                = 0x0312,
                kCommaAbove                                                              = 0x0313,
                kReversedCommaAbove                                              = 0x0314,
                kCommaAboveRight                                                 = 0x0315,
                kGraveAccentBelow                                                = 0x0316,
                kAcuteAccentBelow                                                = 0x0317,
                kLeftTackBelow                                                   = 0x0318,
                kRightTackBelow                                                  = 0x0319,
                kLeftAngleAbove                                                  = 0x031A,
                kHorn                                                                    = 0x031B,
                kLeftHalfRingBelow                                               = 0x031C,
                kUpTackBelow                                                     = 0x031D,
                kDownTackBelow                                                   = 0x031E,
                kPlusSignBelow                                                   = 0x031F,
                kMinusSignBelow                                                  = 0x0320,
                kPalatalizedHookBelow                                    = 0x0321,
                kRetroflexHookBelow                                              = 0x0322,
                kDotBelow                                                                = 0x0323,
                kDiaeresisBelow                                                  = 0x0324,
                kRingBelow                                                               = 0x0325,
                kCommaBelow                                                              = 0x0326,
                kCedilla                                                                 = 0x0327,
                kOgonek                                                                  = 0x0328,
                kVerticalLineBelow                                               = 0x0329,
                kBridgeBelow                                                     = 0x032A,
                kInvertedDoubleArchBelow                                 = 0x032B,
                kCaronBelow                                                              = 0x032C,
                kCircumflexAccentBelow                                   = 0x032D,
                kBreveBelow                                                              = 0x032E,
                kInvertedBreveBelow                                              = 0x032F,
                kTildeBelow                                                              = 0x0330,
                kMacronBelow                                                     = 0x0331,
                kLowLine                                                                 = 0x0332,
                kDoubleLowLine                                                   = 0x0333,
                kTildeOverlay                                                    = 0x0334,
                kShortStrokeOverlay                                              = 0x0335,
                kLongStrokeOverlay                                               = 0x0336,
                kShortSolidusOverlay                                     = 0x0337,
                kLongSolidusOverlay                                              = 0x0338,
                kRightHalfRingBelow                                              = 0x0339,
                kInvertedBridgeBelow                                     = 0x033A,
                kSquareBelow                                                     = 0x033B,
                kSeagullBelow                                                    = 0x033C,
                kXAbove                                                                  = 0x033D,
                kVerticalTilde                                                   = 0x033E,
                kDoubleOverline                                                  = 0x033F,
                kGraveToneMark                                                   = 0x0340,
                kAcuteToneMark                                                   = 0x0341,
                kGreekPerispomeni                                                = 0x0342,
                kGreekKoronis                                                    = 0x0343,
                kGreekDialytikaTonos                                     = 0x0344,
                kGreekYpogegrammeni                                              = 0x0345,
                kDoubleTilde                                                     = 0x0360,
                kDoubleInvertedBreve                                     = 0x0361,

                kCyrillicTitlo                                                   = 0x0483,
                kCyrillicPalatalization                                  = 0x0484,
                kCyrillicDasiaPneumata                                   = 0x0485,
                kCyrillicPsiliPneumata                                   = 0x0486,

                kHebrewPointSheva                                                = 0x05B0,
                kHebrewPointHatafSegol                                   = 0x05B1,
                kHebrewPointHatafPatah                                   = 0x05B2,
                kHebrewPointHatafQamats                                  = 0x05B3,
                kHebrewPointHiriq                                                = 0x05B4,
                kHebrewPointTsere                                                = 0x05B5,
                kHebrewPointSegol                                                = 0x05B6,
                kHebrewPointPatah                                                = 0x05B7,
                kHebrewPointQamats                                               = 0x05B8,
                kHebrewPointHolam                                                = 0x05B9,
                kHebrewPointQubuts                                               = 0x05BB,
                kHebrewPointDageshOrMapiq                                = 0x05BC,
                kHebrewPointMeteg                                                = 0x05BD,
                kHebrewPointRafe                                                 = 0x05BF,
                kHebrewPointShinDot                                              = 0x05C1,
                kHebrewPointSinDot                                               = 0x05C2,

                kArabicFathatan                                                  = 0x064B,
                kArabicDammatan                                                  = 0x064C,
                kArabicKasratan                                                  = 0x064D,
                kArabicFatha                                                     = 0x064E,
                kArabicDamma                                                     = 0x064F,
                kArabicKasra                                                     = 0x0650,
                kArabicShadda                                                    = 0x0651,
                kArabicSukun                                                     = 0x0652,
                kArabicLetterSuperscriptAlef                     = 0x0670,

                kDevanagariSignCandrabindu                               = 0x0901,
                kDevanagariSignAnusvara                                  = 0x0902,
                kDevanagariSignNukta                                     = 0x093C,
                kDevanagariSignAvagraha                                  = 0x093D,
                kDevanagariVowelSignU                                    = 0x0941,
                kDevanagariVowelSignUu                                   = 0x0942,
                kDevanagariVowelSignVocalicR                     = 0x0943,
                kDevanagariVowelSignVocalicRr                    = 0x0944,
                kDevanagariVowelSignCandraE                              = 0x0945,
                kDevanagariVowelSignShortE                               = 0x0946,
                kDevanagariVowelSignE                                    = 0x0947,
                kDevanagariVowelSignAi                                   = 0x0948,
                kDevanagariSignVirama                                    = 0x094D,
                kDevanagariStressSignUdatta                              = 0x0951,
                kDevanagariStressSignAnudatta                    = 0x0952,
                kDevanagariVowelSignVocalicL                     = 0x0962,
                kDevanagariVowelSignVocalicLl                    = 0x0963,

                kBengaliSignCandrabindu                                  = 0x0981,
                kBengaliSignNukta                                                = 0x09BC,
                kBengaliVowelSignU                                               = 0x09C1,
                kBengaliVowelSignUu                                              = 0x09C2,
                kBengaliVowelSignVocalicR                                = 0x09C3,
                kBengaliVowelSignVocalicRr                               = 0x09C4,
                kBengaliSignVirama                                               = 0x09CD,
                kBengaliVowelSignVocalicL                                = 0x09E2,
                kBengaliVowelSignVocalicLl                               = 0x09E3,

                kGurmukhiSignBindi                                               = 0x0A02,
                kGurmukhiSignNukta                                               = 0x0A3C,
                kGurmukhiVowelSignU                                              = 0x0A41,
                kGurmukhiVowelSignUu                                     = 0x0A42,
                kGurmukhiVowelSignEe                                     = 0x0A47,
                kGurmukhiVowelSignAi                                     = 0x0A48,
                kGurmukhiVowelSignOo                                     = 0x0A4B,
                kGurmukhiVowelSignAu                                     = 0x0A4C,
                kGurmukhiSignVirama                                              = 0x0A4D,
                kGurmukhiTippi                                                   = 0x0A70,
                kGurmukhiAddak                                                   = 0x0A71,

                kGujaratiSignCandrabindu                                 = 0x0A81,
                kGujaratiSignAnusvara                                    = 0x0A82,
                kGujaratiSignNukta                                               = 0x0ABC,
                kGujaratiVowelSignU                                              = 0x0AC1,
                kGujaratiVowelSignUu                                     = 0x0AC2,
                kGujaratiVowelSignVocalicR                               = 0x0AC3,
                kGujaratiVowelSignVocalicRr                              = 0x0AC4,
                kGujaratiVowelSignCandraE                                = 0x0AC5,
                kGujaratiVowelSignE                                              = 0x0AC7,
                kGujaratiVowelSignAi                                     = 0x0AC8,
                kGujaratiVowelSignCandraO                                = 0x0AC9,
                kGujaratiSignVirama                                              = 0x0ACD,

                kOriyaSignCandrabindu                                    = 0x0B01,
                kOriyaSignNukta                                                  = 0x0B3C,
                kOriyaVowelSignI                                                 = 0x0B3F,
                kOriyaVowelSignU                                                 = 0x0B41,
                kOriyaVowelSignUu                                                = 0x0B42,
                kOriyaVowelSignVocalicR                                  = 0x0B43,
                kOriyaSignVirama                                                 = 0x0B4D,
                kOriyaAiLengthMark                                               = 0x0B56,

                kTamilVowelSignIi                                                = 0x0BC0,
                kTamilSignVirama                                                 = 0x0BCD,

                kTeluguVowelSignAa                                               = 0x0C3E,
                kTeluguVowelSignI                                                = 0x0C3F,
                kTeluguVowelSignIi                                               = 0x0C40,
                kTeluguVowelSignE                                                = 0x0C46,
                kTeluguVowelSignEe                                               = 0x0C47,
                kTeluguVowelSignAi                                               = 0x0C48,
                kTeluguVowelSignO                                                = 0x0C4A,
                kTeluguVowelSignOo                                               = 0x0C4B,
                kTeluguVowelSignAu                                               = 0x0C4C,
                kTeluguSignVirama                                                = 0x0C4D,
                kTeluguLengthMark                                                = 0x0C55,
                kTeluguAiLengthMark                                              = 0x0C56,

                kKannadaVowelSignI                                               = 0x0CBF,
                kKannadaVowelSignE                                               = 0x0CC6,
                kKannadaVowelSignAu                                              = 0x0CCC,
                kKannadaSignVirama                                               = 0x0CCD,

                kMalayalamVowelSignU                                     = 0x0D41,
                kMalayalamVowelSignUu                                    = 0x0D42,
                kMalayalamVowelSignVocalicR                              = 0x0D43,
                kMalayalamSignVirama                                     = 0x0D4D,

                kThaiCharacterMaiHanAkat                                 = 0x0E31,
                kThaiCharacterSaraI                                              = 0x0E34,
                kThaiCharacterSaraIi                                     = 0x0E35,
                kThaiCharacterSaraUe                                     = 0x0E36,
                kThaiCharacterSaraUee                                    = 0x0E37,
                kThaiCharacterSaraU                                              = 0x0E38,
                kThaiCharacterSaraUu                                     = 0x0E39,
                kThaiCharacterPhinthu                                    = 0x0E3A,
                kThaiCharacterMaitaikhu                                  = 0x0E47,
                kThaiCharacterMaiEk                                              = 0x0E48,
                kThaiCharacterMaiTho                                     = 0x0E49,
                kThaiCharacterMaiTri                                     = 0x0E4A,
                kThaiCharacterMaiChattawa                                = 0x0E4B,
                kThaiCharacterThanthakhat                                = 0x0E4C,
                kThaiCharacterNikhahit                                   = 0x0E4D,

                kLaoVowelSignMaiKan                                              = 0x0EB1,
                kLaoVowelSignI                                                   = 0x0EB4,
                kLaoVowelSignIi                                                  = 0x0EB5,
                kLaoVowelSignY                                                   = 0x0EB6,
                kLaoVowelSignYy                                                  = 0x0EB7,
                kLaoVowelSignU                                                   = 0x0EB8,
                kLaoVowelSignUu                                                  = 0x0EB9,
                kLaoVowelSignMaiKon                                              = 0x0EBB,
                kLaoSemivowelSignLo                                              = 0x0EBC,
                kLaoToneMaiEk                                                    = 0x0EC8,
                kLaoToneMaiTho                                                   = 0x0EC9,
                kLaoToneMaiTi                                                    = 0x0ECA,
                kLaoToneMaiCatawa                                                = 0x0ECB,
                kLaoCancellationMark                                     = 0x0ECC,
                kLaoNiggahita                                                    = 0x0ECD,

                kLeftHarpoonAbove                                                = 0x20D0,
                kRightHarpoonAbove                                               = 0x20D1,
                kLongVerticalLineOverlay                                 = 0x20D2,
                kShortVerticalLineOverlay                                = 0x20D3,
                kAnticlockwiseArrowAbove                                 = 0x20D4,
                kClockwiseArrowAbove                                     = 0x20D5,
                kLeftArrowAbove                                                  = 0x20D6,
                kRightArrowAbove                                                 = 0x20D7,
                kRingOverlay                                                     = 0x20D8,
                kClockwiseRingOverlay                                    = 0x20D9,
                kAnticlockwiseRingOverlay                                = 0x20DA,
                kThreeDotsAbove                                                  = 0x20DB,
                kFourDotsAbove                                                   = 0x20DC,
                kEnclosingCircle                                                 = 0x20DD,
                kEnclosingSquare                                                 = 0x20DE,
                kEnclosingDiamond                                                = 0x20DF,
                kEnclosingCircleBackslash                                = 0x20E0,
                kLeftRightArrowAbove                                     = 0x20E1,

                kIdeographicLevelToneMark                                = 0x302A,
                kIdeographicRisingToneMark                               = 0x302B,
                kIdeographicDepartingToneMark                    = 0x302C,
                kIdeographicEnteringToneMark                     = 0x302D,

                kHangulSingleDotToneMark                                 = 0x302E,
                kHangulDoubleDotToneMark                                 = 0x302F,

                kKatakanaHiraganaVoicedSoundMark                 = 0x3099,
                kKatakanaHiraganaSemiVoicedSoundMark     = 0x309A,

                kLigatureLeftHalf                                                = 0xFE20,
                kLigatureRightHalf                                               = 0xFE21,
                kDoubleTildeLeftHalf                                     = 0xFE22,
                kDoubleTildeRightHalf                                    = 0xFE23

        };

private:

};







//=================================================================================
// class UUnicodeDigit
//=================================================================================
class UUnicodeDigit {

public:

        enum EUnicodeDigitNames {

                kZero                                                                    = 0x0030,
                kOne                                                                     = 0x0031,
                kTwo                                                                     = 0x0032,
                kThree                                                                   = 0x0033,
                kFour                                                                    = 0x0034,
                kFive                                                                    = 0x0035,
                kSix                                                                     = 0x0036,
                kSeven                                                                   = 0x0037,
                kEight                                                                   = 0x0038,
                kNine                                                                    = 0x0039,
                kSuperscriptTwo                          = 0x00B2,
                kSuperscriptThree                        = 0x00B3,
                kSuperscriptOne                          = 0x00B9,
                kArabicIndicZero                                                 = 0x0660,
                kArabicIndicOne                                                  = 0x0661,
                kArabicIndicTwo                                                  = 0x0662,
                kArabicIndicThree                                                = 0x0663,
                kArabicIndicFour                                                 = 0x0664,
                kArabicIndicFive                                                 = 0x0665,
                kArabicIndicSix                                                  = 0x0666,
                kArabicIndicSeven                                                = 0x0667,
                kArabicIndicEight                                                = 0x0668,
                kArabicIndicNine                                                 = 0x0669,
                kExtendedArabicIndicZero                                 = 0x06F0,
                kExtendedArabicIndicOne                                  = 0x06F1,
                kExtendedArabicIndicTwo                                  = 0x06F2,
                kExtendedArabicIndicThree                                = 0x06F3,
                kExtendedArabicIndicFour                                 = 0x06F4,
                kExtendedArabicIndicFive                                 = 0x06F5,
                kExtendedArabicIndicSix                                  = 0x06F6,
                kExtendedArabicIndicSeven                                = 0x06F7,
                kExtendedArabicIndicEight                                = 0x06F8,
                kExtendedArabicIndicNine                                 = 0x06F9,
                kDevanagariZero                                                  = 0x0966,
                kDevanagariOne                                                   = 0x0967,
                kDevanagariTwo                                                   = 0x0968,
                kDevanagariThree                                                 = 0x0969,
                kDevanagariFour                                                  = 0x096A,
                kDevanagariFive                                                  = 0x096B,
                kDevanagariSix                                                   = 0x096C,
                kDevanagariSeven                                                 = 0x096D,
                kDevanagariEight                                                 = 0x096E,
                kDevanagariNine                                                  = 0x096F,
                kBengaliZero                                                     = 0x09E6,
                kBengaliOne                                                              = 0x09E7,
                kBengaliTwo                                                              = 0x09E8,
                kBengaliThree                                                    = 0x09E9,
                kBengaliFour                                                     = 0x09EA,
                kBengaliFive                                                     = 0x09EB,
                kBengaliSix                                                              = 0x09EC,
                kBengaliSeven                                                    = 0x09ED,
                kBengaliEight                                                    = 0x09EE,
                kBengaliNine                                                     = 0x09EF,
                kGurmukhiZero                                                    = 0x0A66,
                kGurmukhiOne                                                     = 0x0A67,
                kGurmukhiTwo                                                     = 0x0A68,
                kGurmukhiThree                                                   = 0x0A69,
                kGurmukhiFour                                                    = 0x0A6A,
                kGurmukhiFive                                                    = 0x0A6B,
                kGurmukhiSix                                                     = 0x0A6C,
                kGurmukhiSeven                                                   = 0x0A6D,
                kGurmukhiEight                                                   = 0x0A6E,
                kGurmukhiNine                                                    = 0x0A6F,
                kGujaratiZero                                                    = 0x0AE6,
                kGujaratiOne                                                     = 0x0AE7,
                kGujaratiTwo                                                     = 0x0AE8,
                kGujaratiThree                                                   = 0x0AE9,
                kGujaratiFour                                                    = 0x0AEA,
                kGujaratiFive                                                    = 0x0AEB,
                kGujaratiSix                                                     = 0x0AEC,
                kGujaratiSeven                                                   = 0x0AED,
                kGujaratiEight                                                   = 0x0AEE,
                kGujaratiNine                                                    = 0x0AEF,
                kOriyaZero                                                               = 0x0B66,
                kOriyaOne                                                                = 0x0B67,
                kOriyaTwo                                                                = 0x0B68,
                kOriyaThree                                                              = 0x0B69,
                kOriyaFour                                                               = 0x0B6A,
                kOriyaFive                                                               = 0x0B6B,
                kOriyaSix                                                                = 0x0B6C,
                kOriyaSeven                                                              = 0x0B6D,
                kOriyaEight                                                              = 0x0B6E,
                kOriyaNine                                                               = 0x0B6F,
                kTamilOne                                                                = 0x0BE7,
                kTamilTwo                                                                = 0x0BE8,
                kTamilThree                                                              = 0x0BE9,
                kTamilFour                                                               = 0x0BEA,
                kTamilFive                                                               = 0x0BEB,
                kTamilSix                                                                = 0x0BEC,
                kTamilSeven                                                              = 0x0BED,
                kTamilEight                                                              = 0x0BEE,
                kTamilNine                                                               = 0x0BEF,
                kTeluguZero                                                              = 0x0C66,
                kTeluguOne                                                               = 0x0C67,
                kTeluguTwo                                                               = 0x0C68,
                kTeluguThree                                                     = 0x0C69,
                kTeluguFour                                                              = 0x0C6A,
                kTeluguFive                                                              = 0x0C6B,
                kTeluguSix                                                               = 0x0C6C,
                kTeluguSeven                                                     = 0x0C6D,
                kTeluguEight                                                     = 0x0C6E,
                kTeluguNine                                                              = 0x0C6F,
                kKannadaZero                                                     = 0x0CE6,
                kKannadaOne                                                              = 0x0CE7,
                kKannadaTwo                                                              = 0x0CE8,
                kKannadaThree                                                    = 0x0CE9,
                kKannadaFour                                                     = 0x0CEA,
                kKannadaFive                                                     = 0x0CEB,
                kKannadaSix                                                              = 0x0CEC,
                kKannadaSeven                                                    = 0x0CED,
                kKannadaEight                                                    = 0x0CEE,
                kKannadaNine                                                     = 0x0CEF,
                kMalayalamZero                                                   = 0x0D66,
                kMalayalamOne                                                    = 0x0D67,
                kMalayalamTwo                                                    = 0x0D68,
                kMalayalamThree                                                  = 0x0D69,
                kMalayalamFour                                                   = 0x0D6A,
                kMalayalamFive                                                   = 0x0D6B,
                kMalayalamSix                                                    = 0x0D6C,
                kMalayalamSeven                                                  = 0x0D6D,
                kMalayalamEight                                                  = 0x0D6E,
                kMalayalamNine                                                   = 0x0D6F,
                kThaiZero                                                                = 0x0E50,
                kThaiOne                                                                 = 0x0E51,
                kThaiTwo                                                                 = 0x0E52,
                kThaiThree                                                               = 0x0E53,
                kThaiFour                                                                = 0x0E54,
                kThaiFive                                                                = 0x0E55,
                kThaiSix                                                                 = 0x0E56,
                kThaiSeven                                                               = 0x0E57,
                kThaiEight                                                               = 0x0E58,
                kThaiNine                                                                = 0x0E59,
                kLaoZero                                                                 = 0x0ED0,
                kLaoOne                                                                  = 0x0ED1,
                kLaoTwo                                                                  = 0x0ED2,
                kLaoThree                                                                = 0x0ED3,
                kLaoFour                                                                 = 0x0ED4,
                kLaoFive                                                                 = 0x0ED5,
                kLaoSix                                                                  = 0x0ED6,
                kLaoSeven                                                                = 0x0ED7,
                kLaoEight                                                                = 0x0ED8,
                kLaoNine                                                                 = 0x0ED9,
                kHangzhouOne                                                     = 0x3021,
                kHangzhouTwo                                                     = 0x3022,
                kHangzhouThree                                                   = 0x3023,
                kHangzhouFour                                                    = 0x3024,
                kHangzhouFive                                                    = 0x3025,
                kHangzhouSix                                                     = 0x3026,
                kHangzhouSeven                                                   = 0x3027,
                kHangzhouEight                                                   = 0x3028,
                kHangzhouNine                                                    = 0x3029,
                kHanZero                                                                 = 0x3007,
                kHanOne                                                                  = 0x4E00,
                kHanTwo                                                                  = 0x4E8C,
                kHanThree                                                                = 0x4E09,
                kHanFour                                                                 = 0x56DB,
                kHanFive                                                                 = 0x4E94,
                kHanSix                                                                  = 0x516D,
                kHanSeven                                                                = 0x4E03,
                kHanEight                                                                = 0x516B,
                kHanNine                                                                 = 0x4E5D
        };

private:

};





//=================================================================================
// class UASCII
//=================================================================================

class UASCII {

public:

        enum EASCIINames {

                kNull                                                                    = 0x0000,
                kStartOfHeading                                                  = 0x0001,
                kStartOfText                                                     = 0x0002,
                kEndOfText                                                               = 0x0003,
                kEndOfTransmission                                               = 0x0004,
                kEnquiry                                                                 = 0x0005,
                kAcknowledge                                                     = 0x0006,
                kBell                                                                    = 0x0007,
                kBackspace                                                               = 0x0008,

                kHorizontalTabulation                                    = 0x0009,
                kLineFeed                                                                = 0x000A,
                kVerticalTabulation                                              = 0x000B,
                kFormFeed                                                                = 0x000C,
                kCarriageReturn                                                  = 0x000D,
                kShiftOut                                                                = 0x000E,
                kShiftIn                                                                 = 0x000F,
                kDataLinkEscape                                                  = 0x0010,
                kDeviceControlOne                                                = 0x0011,
                kDeviceControlTwo                                                = 0x0012,
                kDeviceControlThree                                              = 0x0013,
                kDeviceControlFour                                               = 0x0014,
                kNegativeAcknowledge                                     = 0x0015,
                kSynchronousIdle                                                 = 0x0016,
                kEndOfTransmissionBlock                                  = 0x0017,
                kCancel                                                                  = 0x0018,
                kEndOfMedium                                                     = 0x0019,
                kSubstitute                                                              = 0x001A,
                kEscape                                                                  = 0x001B,
                kFileSeparator                                                   = 0x001C,
                kGroupSeparator                                                  = 0x001D,
                kRecordSeparator                                                 = 0x001E,
                kUnitSeparator                                                   = 0x001F,

                kSpace                                                                   = 0x0020,
                kExclamationMark                                                 = 0x0021,
                kQuotationMark                                                   = 0x0022,
                kNumberSign                                                              = 0x0023,
                kDollarSign                                                              = 0x0024,
                kPercentSign                                                     = 0x0025,
                kAmpersand                                                               = 0x0026,
                kApostrophe                                                              = 0x0027,
                kLeftParenthesis                                                 = 0x0028,
                kRightParenthesis                                                = 0x0029,
                kAsterisk                                                                = 0x002A,
                kPlusSign                                                                = 0x002B,
                kComma                                                                   = 0x002C,
                kHyphenMinus                                                     = 0x002D,
                kFullStop                                                                = 0x002E,
                kSolidus                                                                 = 0x002F,
                kDigitZero                                                               = 0x0030,
                kDigitOne                                                                = 0x0031,
                kDigitTwo                                                                = 0x0032,
                kDigitThree                                                              = 0x0033,
                kDigitFour                                                               = 0x0034,
                kDigitFive                                                               = 0x0035,
                kDigitSix                                                                = 0x0036,
                kDigitSeven                                                              = 0x0037,
                kDigitEight                                                              = 0x0038,
                kDigitNine                                                               = 0x0039,
                kColon                                                                   = 0x003A,
                kSemicolon                                                               = 0x003B,
                kLessThanSign                                                    = 0x003C,
                kEqualsSign                                                              = 0x003D,
                kGreaterThanSign                                                 = 0x003E,
                kQuestionMark                                                    = 0x003F,
                kCommercialAt                                                    = 0x0040,
                kCapitalLetterA                                                  = 0x0041,
                kCapitalLetterB                                                  = 0x0042,
                kCapitalLetterC                                                  = 0x0043,
                kCapitalLetterD                                                  = 0x0044,
                kCapitalLetterE                                                  = 0x0045,
                kCapitalLetterF                                                  = 0x0046,
                kCapitalLetterG                                                  = 0x0047,
                kCapitalLetterH                                                  = 0x0048,
                kCapitalLetterI                                                  = 0x0049,
                kCapitalLetterJ                                                  = 0x004A,
                kCapitalLetterK                                                  = 0x004B,
                kCapitalLetterL                                                  = 0x004C,
                kCapitalLetterM                                                  = 0x004D,
                kCapitalLetterN                                                  = 0x004E,
                kCapitalLetterO                                                  = 0x004F,
                kCapitalLetterP                                                  = 0x0050,
                kCapitalLetterQ                                                  = 0x0051,
                kCapitalLetterR                                                  = 0x0052,
                kCapitalLetterS                                                  = 0x0053,
                kCapitalLetterT                                                  = 0x0054,
                kCapitalLetterU                                                  = 0x0055,
                kCapitalLetterV                                                  = 0x0056,
                kCapitalLetterW                                                  = 0x0057,
                kCapitalLetterX                                                  = 0x0058,
                kCapitalLetterY                                                  = 0x0059,
                kCapitalLetterZ                                                  = 0x005A,
                kLeftSquareBracket                                               = 0x005B,
                kReverseSolidus                                                  = 0x005C,
                kRightSquareBracket                                              = 0x005D,
                kCircumflexAccent                                                = 0x005E,
                kLowLine                                                                 = 0x005F,
                kGraveAccent                                                     = 0x0060,
                kSmallLetterA                                                    = 0x0061,
                kSmallLetterB                                                    = 0x0062,
                kSmallLetterC                                                    = 0x0063,
                kSmallLetterD                                                    = 0x0064,
                kSmallLetterE                                                    = 0x0065,
                kSmallLetterF                                                    = 0x0066,
                kSmallLetterG                                                    = 0x0067,
                kSmallLetterH                                                    = 0x0068,
                kSmallLetterI                                                    = 0x0069,
                kSmallLetterJ                                                    = 0x006A,
                kSmallLetterK                                                    = 0x006B,
                kSmallLetterL                                                    = 0x006C,
                kSmallLetterM                                                    = 0x006D,
                kSmallLetterN                                                    = 0x006E,
                kSmallLetterO                                                    = 0x006F,
                kSmallLetterP                                                    = 0x0070,
                kSmallLetterQ                                                    = 0x0071,
                kSmallLetterR                                                    = 0x0072,
                kSmallLetterS                                                    = 0x0073,
                kSmallLetterT                                                    = 0x0074,
                kSmallLetterU                                                    = 0x0075,
                kSmallLetterV                                                    = 0x0076,
                kSmallLetterW                                                    = 0x0077,
                kSmallLetterX                                                    = 0x0078,
                kSmallLetterY                                                    = 0x0079,
                kSmallLetterZ                                                    = 0x007A,
                kLeftCurlyBracket                                                = 0x007B,
                kVerticalLine                                                    = 0x007C,
                kRightCurlyBracket                                               = 0x007D,
                kTilde                                                                   = 0x007E,
                kDelete                                                                  = 0x007F,

                //      Values derived from Unicode 1.0 names

                kApostropheQuote                                                 = kApostrophe,
                kOpeningParenthesis                                      = kLeftParenthesis,
                kClosingParenthesis                                      = kRightParenthesis,
                kPeriod                                                                  = kFullStop,
                kSlash                                                                   = kSolidus,
                kBackslash                                                               = kReverseSolidus,
                kSpacingUnderscore                                               = kLowLine,
                kOpeningCurlyBracket                                     = kLeftCurlyBracket,
                kVerticalBar                                                     = kVerticalLine,
                kClosingCurlyBracket                                     = kRightCurlyBracket
        };

private:

};






//=================================================================================
// class ULatin1
//=================================================================================
class ULatin1 {

public:

        enum ELatin1Names {

                kNull                                                                    = 0x0000,
                kStartOfHeading                                                  = 0x0001,
                kStartOfText                                                     = 0x0002,
                kEndOfText                                                               = 0x0003,
                kEndOfTransmission                                               = 0x0004,
                kEnquiry                                                                 = 0x0005,
                kAcknowledge                                                     = 0x0006,
                kBell                                                                    = 0x0007,
                kBackspace                                                               = 0x0008,

                kHorizontalTabulation                                    = 0x0009,
                kLineFeed                                                                = 0x000A,
                kVerticalTabulation                                              = 0x000B,
                kFormFeed                                                                = 0x000C,
                kCarriageReturn                                                  = 0x000D,
                kShiftOut                                                                = 0x000E,
                kShiftIn                                                                 = 0x000F,
                kDataLinkEscape                                                  = 0x0010,
                kDeviceControlOne                                                = 0x0011,
                kDeviceControlTwo                                                = 0x0012,
                kDeviceControlThree                                              = 0x0013,
                kDeviceControlFour                                               = 0x0014,
                kNegativeAcknowledge                                     = 0x0015,
                kSynchronousIdle                                                 = 0x0016,
                kEndOfTransmissionBlock                                  = 0x0017,
                kCancel                                                                  = 0x0018,
                kEndOfMedium                                                     = 0x0019,
                kSubstitute                                                              = 0x001A,
                kEscape                                                                  = 0x001B,
                kFileSeparator                                                   = 0x001C,
                kGroupSeparator                                                  = 0x001D,
                kRecordSeparator                                                 = 0x001E,
                kUnitSeparator                                                   = 0x001F,

                kSpace                                                                   = 0x0020,
                kExclamationMark                                                 = 0x0021,
                kQuotationMark                                                   = 0x0022,
                kNumberSign                                                              = 0x0023,
                kDollarSign                                                              = 0x0024,
                kPercentSign                                                     = 0x0025,
                kAmpersand                                                               = 0x0026,
                kApostrophe                                                              = 0x0027,
                kLeftParenthesis                                                 = 0x0028,
                kRightParenthesis                                                = 0x0029,
                kAsterisk                                                                = 0x002A,
                kPlusSign                                                                = 0x002B,
                kComma                                                                   = 0x002C,
                kHyphenMinus                                                     = 0x002D,
                kFullStop                                                                = 0x002E,
                kSolidus                                                                 = 0x002F,
                kDigitZero                                                               = 0x0030,
                kDigitOne                                                                = 0x0031,
                kDigitTwo                                                                = 0x0032,
                kDigitThree                                                              = 0x0033,
                kDigitFour                                                               = 0x0034,
                kDigitFive                                                               = 0x0035,
                kDigitSix                                                                = 0x0036,
                kDigitSeven                                                              = 0x0037,
                kDigitEight                                                              = 0x0038,
                kDigitNine                                                               = 0x0039,
                kColon                                                                   = 0x003A,
                kSemicolon                                                               = 0x003B,
                kLessThanSign                                                    = 0x003C,
                kEqualsSign                                                              = 0x003D,
                kGreaterThanSign                                                 = 0x003E,
                kQuestionMark                                                    = 0x003F,
                kCommercialAt                                                    = 0x0040,
                kCapitalLetterA                                                  = 0x0041,
                kCapitalLetterB                                                  = 0x0042,
                kCapitalLetterC                                                  = 0x0043,
                kCapitalLetterD                                                  = 0x0044,
                kCapitalLetterE                                                  = 0x0045,
                kCapitalLetterF                                                  = 0x0046,
                kCapitalLetterG                                                  = 0x0047,
                kCapitalLetterH                                                  = 0x0048,
                kCapitalLetterI                                                  = 0x0049,
                kCapitalLetterJ                                                  = 0x004A,
                kCapitalLetterK                                                  = 0x004B,
                kCapitalLetterL                                                  = 0x004C,
                kCapitalLetterM                                                  = 0x004D,
                kCapitalLetterN                                                  = 0x004E,
                kCapitalLetterO                                                  = 0x004F,
                kCapitalLetterP                                                  = 0x0050,
                kCapitalLetterQ                                                  = 0x0051,
                kCapitalLetterR                                                  = 0x0052,
                kCapitalLetterS                                                  = 0x0053,
                kCapitalLetterT                                                  = 0x0054,
                kCapitalLetterU                                                  = 0x0055,
                kCapitalLetterV                                                  = 0x0056,
                kCapitalLetterW                                                  = 0x0057,
                kCapitalLetterX                                                  = 0x0058,
                kCapitalLetterY                                                  = 0x0059,
                kCapitalLetterZ                                                  = 0x005A,
                kLeftSquareBracket                                               = 0x005B,
                kReverseSolidus                                                  = 0x005C,
                kRightSquareBracket                                              = 0x005D,
                kCircumflexAccent                                                = 0x005E,
                kLowLine                                                                 = 0x005F,
                kGraveAccent                                                     = 0x0060,
                kSmallLetterA                                                    = 0x0061,
                kSmallLetterB                                                    = 0x0062,
                kSmallLetterC                                                    = 0x0063,
                kSmallLetterD                                                    = 0x0064,
                kSmallLetterE                                                    = 0x0065,
                kSmallLetterF                                                    = 0x0066,
                kSmallLetterG                                                    = 0x0067,
                kSmallLetterH                                                    = 0x0068,
                kSmallLetterI                                                    = 0x0069,
                kSmallLetterJ                                                    = 0x006A,
                kSmallLetterK                                                    = 0x006B,
                kSmallLetterL                                                    = 0x006C,
                kSmallLetterM                                                    = 0x006D,
                kSmallLetterN                                                    = 0x006E,
                kSmallLetterO                                                    = 0x006F,
                kSmallLetterP                                                    = 0x0070,
                kSmallLetterQ                                                    = 0x0071,
                kSmallLetterR                                                    = 0x0072,
                kSmallLetterS                                                    = 0x0073,
                kSmallLetterT                                                    = 0x0074,
                kSmallLetterU                                                    = 0x0075,
                kSmallLetterV                                                    = 0x0076,
                kSmallLetterW                                                    = 0x0077,
                kSmallLetterX                                                    = 0x0078,
                kSmallLetterY                                                    = 0x0079,
                kSmallLetterZ                                                    = 0x007A,
                kLeftCurlyBracket                                                = 0x007B,
                kVerticalLine                                                    = 0x007C,
                kRightCurlyBracket                                               = 0x007D,
                kTilde                                                                   = 0x007E,
                kDelete                                                                  = 0x007F,

                kNoBreakSpace                                                    = 0x00A0,
                kInvertedExclamationMark                                 = 0x00A1,
                kCentSign                                                                = 0x00A2,
                kPoundSign                                                               = 0x00A3,
                kCurrencySign                                                    = 0x00A4,
                kYenSign                                                                 = 0x00A5,
                kBrokenBar                                                               = 0x00A6,
                kSectionSign                                                     = 0x00A7,
                kDiaeresis                                                               = 0x00A8,
                kCopyrightSign                                                   = 0x00A9,
                kFeminineOrdinalIndicator                                = 0x00AA,
                kLeftPointingDoubleAngleQuotationMark    = 0x00AB,
                kNotSign                                                                 = 0x00AC,
                kSoftHyphen                                                              = 0x00AD,
                kRegisteredSign                                                  = 0x00AE,
                kMacron                                                                  = 0x00AF,
                kDegreeSign                                                              = 0x00B0,
                kPlusMinusSign                                                   = 0x00B1,
                kAcuteAccent                                                     = 0x00B4,
                kMicroSign                                                               = 0x00B5,
                kPilcrowSign                                                     = 0x00B6,
                kMiddleDot                                                               = 0x00B7,
                kCedilla                                                                 = 0x00B8,
                kMasculineOrdinalIndicator                               = 0x00BA,
                kRightPointingDoubleAngleQuotationMark   = 0x00BB,
                kVulgarFractionOneQuarter                                = 0x00BC,
                kVulgarFractionOneHalf                                   = 0x00BD,
                kVulgarFractionThreeQuarters                     = 0x00BE,
                kInvertedQuestionMark                                    = 0x00BF,
                kCapitalLetterAWithGrave                         = 0x00C0,
                kCapitalLetterAWithAcute                         = 0x00C1,
                kCapitalLetterAWithCircumflex            = 0x00C2,
                kCapitalLetterAWithTilde                         = 0x00C3,
                kCapitalLetterAWithDiaeresis             = 0x00C4,
                kCapitalLetterAWithRingAbove             = 0x00C5,
                kCapitalLigatureAe                                       = 0x00C6,
                kCapitalLetterCWithCedilla                       = 0x00C7,
                kCapitalLetterEWithGrave                         = 0x00C8,
                kCapitalLetterEWithAcute                         = 0x00C9,
                kCapitalLetterEWithCircumflex            = 0x00CA,
                kCapitalLetterEWithDiaeresis             = 0x00CB,
                kCapitalLetterIWithGrave                         = 0x00CC,
                kCapitalLetterIWithAcute                         = 0x00CD,
                kCapitalLetterIWithCircumflex            = 0x00CE,
                kCapitalLetterIWithDiaeresis             = 0x00CF,
                kCapitalLetterEth                                        = 0x00D0,
                kCapitalLetterNWithTilde                         = 0x00D1,
                kCapitalLetterOWithGrave                         = 0x00D2,
                kCapitalLetterOWithAcute                         = 0x00D3,
                kCapitalLetterOWithCircumflex            = 0x00D4,
                kCapitalLetterOWithTilde                         = 0x00D5,
                kCapitalLetterOWithDiaeresis             = 0x00D6,
                kMultiplicationSign                                      = 0x00D7,
                kCapitalLetterOWithStroke                        = 0x00D8,
                kCapitalLetterUWithGrave                         = 0x00D9,
                kCapitalLetterUWithAcute                         = 0x00DA,
                kCapitalLetterUWithCircumflex            = 0x00DB,
                kCapitalLetterUWithDiaeresis             = 0x00DC,
                kCapitalLetterYWithAcute                         = 0x00DD,
                kCapitalLetterThorn                                      = 0x00DE,
                kSmallLetterSharpS                                       = 0x00DF,
                kSmallLetterAWithGrave                           = 0x00E0,
                kSmallLetterAWithAcute                           = 0x00E1,
                kSmallLetterAWithCircumflex                      = 0x00E2,
                kSmallLetterAWithTilde                           = 0x00E3,
                kSmallLetterAWithDiaeresis                       = 0x00E4,
                kSmallLetterAWithRingAbove                       = 0x00E5,
                kSmallLigatureAe                                         = 0x00E6,
                kSmallLetterCWithCedilla                         = 0x00E7,
                kSmallLetterEWithGrave                           = 0x00E8,
                kSmallLetterEWithAcute                           = 0x00E9,
                kSmallLetterEWithCircumflex                      = 0x00EA,
                kSmallLetterEWithDiaeresis                       = 0x00EB,
                kSmallLetterIWithGrave                           = 0x00EC,
                kSmallLetterIWithAcute                           = 0x00ED,
                kSmallLetterIWithCircumflex                      = 0x00EE,
                kSmallLetterIWithDiaeresis                       = 0x00EF,
                kSmallLetterEth                                          = 0x00F0,
                kSmallLetterNWithTilde                           = 0x00F1,
                kSmallLetterOWithGrave                           = 0x00F2,
                kSmallLetterOWithAcute                           = 0x00F3,
                kSmallLetterOWithCircumflex                      = 0x00F4,
                kSmallLetterOWithTilde                           = 0x00F5,
                kSmallLetterOWithDiaeresis                       = 0x00F6,
                kDivisionSign                                            = 0x00F7,
                kSmallLetterOWithStroke                          = 0x00F8,
                kSmallLetterUWithGrave                           = 0x00F9,
                kSmallLetterUWithAcute                           = 0x00FA,
                kSmallLetterUWithCircumflex                      = 0x00FB,
                kSmallLetterUWithDiaeresis                       = 0x00FC,
                kSmallLetterYWithAcute                           = 0x00FD,
                kSmallLetterThorn                                        = 0x00FE,
                kSmallLetterYWithDiaeresis                       = 0x00FF,

                //      Values derived from Unicode 1.0 names

                kApostropheQuote                                         = kApostrophe,
                kOpeningParenthesis                              = kLeftParenthesis,
                kClosingParenthesis                              = kRightParenthesis,
                kPeriod                                                          = kFullStop,
                kSlash                                                           = kSolidus,
                kBackslash                                                       = kReverseSolidus,
                kSpacingUnderscore                                       = kLowLine,
                kOpeningCurlyBracket                             = kLeftCurlyBracket,
                kVerticalBar                                             = kVerticalLine,
                kClosingCurlyBracket                             = kRightCurlyBracket,
                kNonBreakingSpace                                        = kNoBreakSpace,
                kBrokenVerticalBar                                       = kBrokenBar,
                kSpacingDiaeresis                                        = kDiaeresis,
                kLeftPointingGuillemet                           = kLeftPointingDoubleAngleQuotationMark,
                kRegisteredTradeMarkSign                         = kRegisteredSign,
                kPlusOrMinusSign                                         = kPlusMinusSign,
                kParagraphSign                                           = kPilcrowSign,
                kRightPointingGuillemet                          = kRightPointingDoubleAngleQuotationMark
        };

private:

};








//=================================================================================
// class UGeneralPunctuation
//=================================================================================
class UGeneralPunctuation {

public:

        enum EGeneralPunctuationNames {

                kNull                                                                    = 0x0000,
                kSpace                                                                   = 0x0020,
                kExclamationMark                                                 = 0x0021,
                kQuotationMark                                                   = 0x0022,
                kApostrophe                                                              = 0x0027,
                kLeftParenthesis                                                 = 0x0028,
                kRightParenthesis                                                = 0x0029,
                kComma                                                                   = 0x002C,
                kHyphenMinus                                                     = 0x002D,
                kFullStop                                                                = 0x002E,
                kColon                                                                   = 0x003A,
                kSemicolon                                                               = 0x003B,
                kQuestionMark                                                    = 0x003F,
                kLeftSquareBracket                                               = 0x005B,
                kRightSquareBracket                                              = 0x005D,
                kLowLine                                                                 = 0x005F,
                kLeftCurlyBracket                                                = 0x007B,
                kRightCurlyBracket                                               = 0x007D,
                kNoBreakSpace                                                    = 0x00A0,
                kEnQuad                                                                  = 0x2000,
                kEmQuad                                                                  = 0x2001,
                kEnSpace                                                                 = 0x2002,
                kEmSpace                                                                 = 0x2003,
                kThreePerEmSpace                                                 = 0x2004,
                kFourPerEmSpace                                                  = 0x2005,
                kSixPerEmSpace                                                   = 0x2006,
                kFigureSpace                                                     = 0x2007,
                kPunctuationSpace                                                = 0x2008,
                kThinSpace                                                               = 0x2009,
                kHairSpace                                                               = 0x200A,
                kZeroWidthSpace                                                  = 0x200B,
                kZeroWidthNonJoiner                                              = 0x200C,
                kZeroWidthJoiner                                                 = 0x200D,
                kLeftToRightMark                                                 = 0x200E,
                kRightToLeftMark                                                 = 0x200F,
                kHyphen                                                                  = 0x2010,
                kNonBreakingHyphen                                               = 0x2011,
                kFigureDash                                                              = 0x2012,
                kEnDash                                                                  = 0x2013,
                kEmDash                                                                  = 0x2014,
                kHorizontalBar                                                   = 0x2015,
                kDoubleVerticalLine                                              = 0x2016,
                kDoubleLowLine                                                   = 0x2017,
                kLeftSingleQuotationMark                                 = 0x2018,
                kRightSingleQuotationMark                                = 0x2019,
                kSingleLowQuotationMark                                  = 0x201A,
                kSingleHighReversedQuotationMark                 = 0x201B,
                kLeftDoubleQuotationMark                                 = 0x201C,
                kRightDoubleQuotationMark                                = 0x201D,
                kDoubleLowQuotationMark                                  = 0x201E,
                kDoubleHighReversedQuotationMark                 = 0x201F,
                kDagger                                                                  = 0x2020,
                kDoubleDagger                                                    = 0x2021,
                kBullet                                                                  = 0x2022,
                kTriangularBullet                                                = 0x2023,
                kOneDotLeader                                                    = 0x2024,
                kTwoDotLeader                                                    = 0x2025,
                kHorizontalEllipsis                                              = 0x2026,
                kHyphenationPoint                                                = 0x2027,
                kLineSeparator                                                   = 0x2028,
                kParagraphSeparator                                              = 0x2029,
                kLeftToRightEmbedding                                    = 0x202A,
                kRightToLeftEmbedding                                    = 0x202B,
                kPopDirectionalFormatting                                = 0x202C,
                kLeftToRightOverride                                     = 0x202D,
                kRightToLeftOverride                                     = 0x202E,
                kPerMilleSign                                                    = 0x2030,
                kPerTenThousandSign                                              = 0x2031,
                kPrime                                                                   = 0x2032,
                kDoublePrime                                                     = 0x2033,
                kTriplePrime                                                     = 0x2034,
                kReversedPrime                                                   = 0x2035,
                kReversedDoublePrime                                     = 0x2036,
                kReversedTriplePrime                                     = 0x2037,
                kCaret                                                                   = 0x2038,
                kSingleLeftPointingAngleQuotationMark    = 0x2039,
                kSingleRightPointingAngleQuotationMark   = 0x203A,
                kReferenceMark                                                   = 0x203B,
                kDoubleExclamationMark                                   = 0x203C,
                kInterrobang                                                     = 0x203D,
                kOverline                                                                = 0x203E,
                kUndertie                                                                = 0x203F,
                kCharacterTie                                                    = 0x2040,
                kCaretInsertionPoint                                     = 0x2041,
                kAsterism                                                                = 0x2042,
                kHyphenBullet                                                    = 0x2043,
                kFractionSlash                                                   = 0x2044,
                kLeftSquareBracketWithQuill                              = 0x2045,
                kRightSquareBracketWithQuill                     = 0x2046,
                kInhibitSymmetricSwapping                                = 0x206A,
                kActivateSymmetricSwapping                               = 0x206B,

                kIdeographicSpace                                                = 0x3000,
                kIdeographicComma                                                = 0x3001,
                kIdeographicFullStop                                     = 0x3002,

                kLeftAngleBracket                                                = 0x3008,
                kRightAngleBracket                                               = 0x3009,
                kLeftDoubleAngleBracket                                  = 0x300A,
                kRightDoubleAngleBracket                                 = 0x300B,
                kLeftCornerBracket                                               = 0x300C,
                kRightCornerBracket                                              = 0x300D,
                kLeftWhiteCornerBracket                                  = 0x300E,
                kRightWhiteCornerBracket                                 = 0x300F,
                kLeftBlackLenticularBracket                              = 0x3010,
                kRightBlackLenticularBracket                     = 0x3011,
                kLeftTortoiseShellBracket                                = 0x3014,
                kRightTortoiseShellBracket                               = 0x3015,
                kLeftWhiteLenticularBracket                              = 0x3016,
                kRightWhiteLenticularBracket                     = 0x3017,
                kLeftWhiteTortoiseShellBracket                   = 0x3018,
                kRightWhiteTortoiseShellBracket                  = 0x3019,
                kLeftWhiteSquareBracket                                  = 0x301A,
                kRightWhiteSquareBracket                                 = 0x301B,
                kWaveDash                                                                = 0x301C,
                kReversedDoublePrimeQuotationMark                = 0x301D,
                kDoublePrimeQuotationMark                                = 0x301E,
                kLowDoublePrimeQuotationMark                     = 0x301F,

                kZeroWidthNoBreakSpace                                   = 0xFEFF,
                kByteOrderMark                                                   = 0xFEFF,
                kReplacementCharacter                                    = 0xFFFD,
                kNotAUnicode                                                     = IUnicode::kHighBoundUnicode,
                kMissingChar                                                     = kNotAUnicode,

                //      Values derived from Unicode 1.0 names

                kApostropheQuote                                                 = kApostrophe,
                kOpeningParenthesis                                      = kLeftParenthesis,
                kClosingParenthesis                                      = kRightParenthesis,
                kPeriod                                                                  = kFullStop,
                kSpacingUnderscore                                               = kLowLine,
                kOpeningCurlyBracket                                     = kLeftCurlyBracket,
                kClosingCurlyBracket                                     = kRightCurlyBracket,
                kNonBreakingSpace                                                = kNoBreakSpace,
                kQuotationDash                                                   = kHorizontalBar,
                kDoubleVerticalBar                                               = kDoubleVerticalLine,
                kSpacingDoubleUnderscore                                 = kDoubleLowLine,
                kSingleTurnedCommaQuotationMark                  = kLeftSingleQuotationMark,
                kSingleCommaQuotationMark                                = kRightSingleQuotationMark,
                kLowSingleCommaQuotationMark                     = kSingleLowQuotationMark,
                kSingleReversedCommaQuotationMark                = kSingleHighReversedQuotationMark,
                kDoubleTurnedCommaQuotationMark                  = kLeftDoubleQuotationMark,
                kDoubleCommaQuotationMark                                = kRightDoubleQuotationMark,
                kLowDoubleCommaQuotationMark                     = kDoubleLowQuotationMark,
                kDoubleReversedCommaQuotationMark                = kDoubleHighReversedQuotationMark,
                kLeftPointingSingleGuillemet                     = kSingleLeftPointingAngleQuotationMark,
                kRightPointingSingleGuillemet                    = kSingleRightPointingAngleQuotationMark,
                kSpacingOverscore                                                = kOverline,
                kIdeographicPeriod                                               = kIdeographicFullStop,
                kOpeningAngleBracket                                     = kLeftAngleBracket,
                kClosingAngleBracket                                     = kRightAngleBracket,
                kOpeningDoubleAngleBracket                               = kLeftDoubleAngleBracket,
                kClosingDoubleAngleBracket                               = kRightDoubleAngleBracket,
                kOpeningCornerBracket                                    = kLeftCornerBracket,
                kClosingCornerBracket                                    = kRightCornerBracket,
                kOpeningWhiteCornerBracket                               = kLeftWhiteCornerBracket,
                kClosingWhiteCornerBracket                               = kRightWhiteCornerBracket,
                kOpeningBlackLenticularBracket                   = kLeftBlackLenticularBracket,
                kClosingBlackLenticularBracket                   = kRightBlackLenticularBracket,
                kOpeningTortoiseShellBracket                     = kLeftTortoiseShellBracket,
                kClosingTortoiseShellBracket                     = kRightTortoiseShellBracket,
                kOpeningWhiteLenticularBracket                   = kLeftWhiteLenticularBracket,
                kClosingWhiteLenticularBracket                   = kRightWhiteLenticularBracket,
                kOpeningWhiteTortoiseShellBracket                = kLeftWhiteTortoiseShellBracket,
                kClosingWhiteTortoiseShellBracket                = kRightWhiteTortoiseShellBracket
        };

private:

};







//=================================================================================
// class UWhiteSpace
//=================================================================================
class UWhiteSpace {

public:

        enum EWhiteSpaceNames {

                kHorizontalTabulation                                    = 0x0009,
                kLineFeed                                                                = 0x000A,
                kCarriageReturn                                                  = 0x000D,

                kSpace                                                                   = 0x0020,
                kNoBreakSpace                                                    = 0x00A0,
                kEnQuad                                                                  = 0x2000,
                kEmQuad                                                                  = 0x2001,
                kEnSpace                                                                 = 0x2002,
                kEmSpace                                                                 = 0x2003,
                kThreePerEmSpace                                                 = 0x2004,
                kFourPerEmSpace                                                  = 0x2005,
                kSixPerEmSpace                                                   = 0x2006,
                kFigureSpace                                                     = 0x2007,
                kPunctuationSpace                                                = 0x2008,
                kThinSpace                                                               = 0x2009,
                kHairSpace                                                               = 0x200A,
                kZeroWidthSpace                                                  = 0x200B,

                kLineSeparator                                                   = 0x2028,
                kParagraphSeparator                                              = 0x2029,

                kIdeographicSpace                                                = 0x3000,

                kZeroWidthNoBreakSpace                                   = 0xFEFF,

                //      Values derived from Unicode 1.0 names

                kNonBreakingSpace                                                = kNoBreakSpace,
                kByteOrderMark                                                   = kZeroWidthNoBreakSpace
        };

private:
};







//=================================================================================
// class UUnicodeSpecial
//=================================================================================

class UUnicodeSpecial {

public:

        enum EUnicodeSpecialNames {

                kNull                                                                    = 0x0000,
                kZeroWidthNoBreakSpace                                   = 0xFEFF,
                kByteOrderMark                                                   = 0xFEFF,
                kReplacementCharacter                                    = 0xFFFD,
                kCorruptByteOrderMark                                    = 0xFFFE,
                kNotAUnicode                                                     = 0xFFFF,
                kMissingChar                                                     = kNotAUnicode

        };

private:

};



//=================================================================================
// class UControlCode
//=================================================================================

class UControlCode {

public:

        enum EControlCodeNames {

                kNull                                                                    = 0x0000,
                kStartOfHeading                                                  = 0x0001,
                kStartOfText                                                     = 0x0002,
                kEndOfText                                                               = 0x0003,
                kEndOfTransmission                                               = 0x0004,
                kEnquiry                                                                 = 0x0005,
                kAcknowledge                                                     = 0x0006,
                kBell                                                                    = 0x0007,
                kBackspace                                                               = 0x0008,

                kHorizontalTabulation                                    = 0x0009,
                kLineFeed                                                                = 0x000A,
                kVerticalTabulation                                              = 0x000B,
                kFormFeed                                                                = 0x000C,
                kCarriageReturn                                                  = 0x000D,
                kShiftOut                                                                = 0x000E,
                kShiftIn                                                                 = 0x000F,
                kDataLinkEscape                                                  = 0x0010,
                kDeviceControlOne                                                = 0x0011,
                kDeviceControlTwo                                                = 0x0012,
                kDeviceControlThree                                              = 0x0013,
                kDeviceControlFour                                               = 0x0014,
                kNegativeAcknowledge                                     = 0x0015,
                kSynchronousIdle                                                 = 0x0016,
                kEndOfTransmissionBlock                                  = 0x0017,
                kCancel                                                                  = 0x0018,
                kEndOfMedium                                                     = 0x0019,
                kSubstitute                                                              = 0x001A,
                kEscape                                                                  = 0x001B,
                kFileSeparator                                                   = 0x001C,
                kGroupSeparator                                                  = 0x001D,
                kRecordSeparator                                                 = 0x001E,
                kUnitSeparator                                                   = 0x001F,
                kDelete                                                                  = 0x007F,

                k0080                                                                    = 0x0080,
                k0081                                                                    = 0x0081,
                k0082                                                                    = 0x0082,
                k0083                                                                    = 0x0083,
                k0084                                                                    = 0x0084,
                k0085                                                                    = 0x0085,
                k0086                                                                    = 0x0086,
                k0087                                                                    = 0x0087,
                k0088                                                                    = 0x0088,
                k0089                                                                    = 0x0089,
                k008A                                                                    = 0x008A,
                k008B                                                                    = 0x008B,
                k008C                                                                    = 0x008C,
                k008D                                                                    = 0x008D,
                k008E                                                                    = 0x008E,
                k008F                                                                    = 0x008F,
                k0090                                                                    = 0x0090,
                k0091                                                                    = 0x0091,
                k0092                                                                    = 0x0092,
                k0093                                                                    = 0x0093,
                k0094                                                                    = 0x0094,
                k0095                                                                    = 0x0095,
                k0096                                                                    = 0x0096,
                k0097                                                                    = 0x0097,
                k0098                                                                    = 0x0098,
                k0099                                                                    = 0x0099,
                k009A                                                                    = 0x009A,
                k009B                                                                    = 0x009B,
                k009C                                                                    = 0x009C,
                k009D                                                                    = 0x009D,
                k009E                                                                    = 0x009E,
                k009F                                                                    = 0x009F,

                kNominalDigitShapes                                      = 0x206F,
                kNationalDigitShapes                                     = 0x206E
        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUGNRL_
