// Revision: 97 1.10 source/core/text/unicode/iueeuro.hpp, text, ocdev
// iueeuro.hpp
/**
 * This file contains the classes UGreek, UCyrillic, UGeorgian,
 * UCoptic which provide information about the Eastern European
 * scripts.
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */



#ifndef _IUEEURO_
#define _IUEEURO_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class UGreek;
class UCyrillic;
class UGeorgian;
class UCoptic;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class UGreek
//=================================================================================

class UGreek {

public:

        enum EGreekNames {

                kCombiningPerispomeni                                    = 0x0342,
                kCombiningKoronis                                                = 0x0343,
                kCombiningDialytikaTonos                                 = 0x0344,
                kCombiningYpogegrammeni                                  = 0x0345,
                kNumeralSign                                                     = 0x0374,
                kLowerNumeralSign                                                = 0x0375,
                kYpogegrammeni                                                   = 0x037A,
                kQuestionMark                                                    = 0x037E,
                kTonos                                                                   = 0x0384,
                kDialytikaTonos                                                  = 0x0385,
                kCapitalLetterAlphaWithTonos                     = 0x0386,
                kAnoTeleia                                                               = 0x0387,
                kCapitalLetterEpsilonWithTonos                   = 0x0388,
                kCapitalLetterEtaWithTonos                               = 0x0389,
                kCapitalLetterIotaWithTonos                              = 0x038A,
                kCapitalLetterOmicronWithTonos                   = 0x038C,
                kCapitalLetterUpsilonWithTonos                   = 0x038E,
                kCapitalLetterOmegaWithTonos                     = 0x038F,
                kSmallLetterIotaWithDialytikaAndTonos    = 0x0390,
                kCapitalLetterAlpha                                              = 0x0391,
                kCapitalLetterBeta                                               = 0x0392,
                kCapitalLetterGamma                                              = 0x0393,
                kCapitalLetterDelta                                              = 0x0394,
                kCapitalLetterEpsilon                                    = 0x0395,
                kCapitalLetterZeta                                               = 0x0396,
                kCapitalLetterEta                                                = 0x0397,
                kCapitalLetterTheta                                              = 0x0398,
                kCapitalLetterIota                                               = 0x0399,
                kCapitalLetterKappa                                              = 0x039A,
                kCapitalLetterLamda                                              = 0x039B,
                kCapitalLetterMu                                                 = 0x039C,
                kCapitalLetterNu                                                 = 0x039D,
                kCapitalLetterXi                                                 = 0x039E,
                kCapitalLetterOmicron                                    = 0x039F,
                kCapitalLetterPi                                                 = 0x03A0,
                kCapitalLetterRho                                                = 0x03A1,
                kCapitalLetterSigma                                              = 0x03A3,
                kCapitalLetterTau                                                = 0x03A4,
                kCapitalLetterUpsilon                                    = 0x03A5,
                kCapitalLetterPhi                                                = 0x03A6,
                kCapitalLetterChi                                                = 0x03A7,
                kCapitalLetterPsi                                                = 0x03A8,
                kCapitalLetterOmega                                              = 0x03A9,
                kCapitalLetterIotaWithDialytika                  = 0x03AA,
                kCapitalLetterUpsilonWithDialytika               = 0x03AB,
                kSmallLetterAlphaWithTonos                               = 0x03AC,
                kSmallLetterEpsilonWithTonos                     = 0x03AD,
                kSmallLetterEtaWithTonos                                 = 0x03AE,
                kSmallLetterIotaWithTonos                                = 0x03AF,
                kSmallLetterUpsilonWithDialytikaAndTonos = 0x03B0,
                kSmallLetterAlpha                                                = 0x03B1,
                kSmallLetterBeta                                                 = 0x03B2,
                kSmallLetterGamma                                                = 0x03B3,
                kSmallLetterDelta                                                = 0x03B4,
                kSmallLetterEpsilon                                              = 0x03B5,
                kSmallLetterZeta                                                 = 0x03B6,
                kSmallLetterEta                                                  = 0x03B7,
                kSmallLetterTheta                                                = 0x03B8,
                kSmallLetterIota                                                 = 0x03B9,
                kSmallLetterKappa                                                = 0x03BA,
                kSmallLetterLamda                                                = 0x03BB,
                kSmallLetterMu                                                   = 0x03BC,
                kSmallLetterNu                                                   = 0x03BD,
                kSmallLetterXi                                                   = 0x03BE,
                kSmallLetterOmicron                                              = 0x03BF,
                kSmallLetterPi                                                   = 0x03C0,
                kSmallLetterRho                                                  = 0x03C1,
                kSmallLetterFinalSigma                                   = 0x03C2,
                kSmallLetterSigma                                                = 0x03C3,
                kSmallLetterTau                                                  = 0x03C4,
                kSmallLetterUpsilon                                              = 0x03C5,
                kSmallLetterPhi                                                  = 0x03C6,
                kSmallLetterChi                                                  = 0x03C7,
                kSmallLetterPsi                                                  = 0x03C8,
                kSmallLetterOmega                                                = 0x03C9,
                kSmallLetterIotaWithDialytika                    = 0x03CA,
                kSmallLetterUpsilonWithDialytika                 = 0x03CB,
                kSmallLetterOmicronWithTonos                     = 0x03CC,
                kSmallLetterUpsilonWithTonos                     = 0x03CD,
                kSmallLetterOmegaWithTonos                               = 0x03CE,
                kBetaSymbol                                                              = 0x03D0,
                kThetaSymbol                                                     = 0x03D1,
                kUpsilonWithHookSymbol                                   = 0x03D2,
                kUpsilonWithAcuteAndHookSymbol                   = 0x03D3,
                kUpsilonWithDiaeresisAndHookSymbol               = 0x03D4,
                kPhiSymbol                                                               = 0x03D5,
                kPiSymbol                                                                = 0x03D6,
                kLetterStigma                                                    = 0x03DA,
                kLetterDigamma                                                   = 0x03DC,
                kLetterKoppa                                                     = 0x03DE,
                kLetterSampi                                                     = 0x03E0,
                kKappaSymbol                                                     = 0x03F0,
                kRhoSymbol                                                               = 0x03F1,
                kLunateSigmaSymbol                                               = 0x03F2,
                kLetterYot                                                               = 0x03F3,
                kSmallLetterAlphaWithPsili                               = 0x1F00,
                kSmallLetterAlphaWithDasia                               = 0x1F01,
                kSmallLetterAlphaWithPsiliAndVaria               = 0x1F02,
                kSmallLetterAlphaWithDasiaAndVaria               = 0x1F03,
                kSmallLetterAlphaWithPsiliAndOxia                = 0x1F04,
                kSmallLetterAlphaWithDasiaAndOxia                = 0x1F05,
                kSmallLetterAlphaWithPsiliAndPerispomeni = 0x1F06,
                kSmallLetterAlphaWithDasiaAndPerispomeni = 0x1F07,
                kCapitalLetterAlphaWithPsili                     = 0x1F08,
                kCapitalLetterAlphaWithDasia                     = 0x1F09,
                kCapitalLetterAlphaWithPsiliAndVaria     = 0x1F0A,
                kCapitalLetterAlphaWithDasiaAndVaria     = 0x1F0B,
                kCapitalLetterAlphaWithPsiliAndOxia              = 0x1F0C,
                kCapitalLetterAlphaWithDasiaAndOxia              = 0x1F0D,
                kCapitalLetterAlphaWithPsiliAndPerispomeni = 0x1F0E,
                kCapitalLetterAlphaWithDasiaAndPerispomeni = 0x1F0F,
                kSmallLetterEpsilonWithPsili                     = 0x1F10,
                kSmallLetterEpsilonWithDasia                     = 0x1F11,
                kSmallLetterEpsilonWithPsiliAndVaria     = 0x1F12,
                kSmallLetterEpsilonWithDasiaAndVaria     = 0x1F13,
                kSmallLetterEpsilonWithPsiliAndOxia              = 0x1F14,
                kSmallLetterEpsilonWithDasiaAndOxia              = 0x1F15,
                kCapitalLetterEpsilonWithPsili                   = 0x1F18,
                kCapitalLetterEpsilonWithDasia                   = 0x1F19,
                kCapitalLetterEpsilonWithPsiliAndVaria   = 0x1F1A,
                kCapitalLetterEpsilonWithDasiaAndVaria   = 0x1F1B,
                kCapitalLetterEpsilonWithPsiliAndOxia    = 0x1F1C,
                kCapitalLetterEpsilonWithDasiaAndOxia    = 0x1F1D,
                kSmallLetterEtaWithPsili                                 = 0x1F20,
                kSmallLetterEtaWithDasia                                 = 0x1F21,
                kSmallLetterEtaWithPsiliAndVaria                 = 0x1F22,
                kSmallLetterEtaWithDasiaAndVaria                 = 0x1F23,
                kSmallLetterEtaWithPsiliAndOxia                  = 0x1F24,
                kSmallLetterEtaWithDasiaAndOxia                  = 0x1F25,
                kSmallLetterEtaWithPsiliAndPerispomeni   = 0x1F26,
                kSmallLetterEtaWithDasiaAndPerispomeni   = 0x1F27,
                kCapitalLetterEtaWithPsili                               = 0x1F28,
                kCapitalLetterEtaWithDasia                               = 0x1F29,
                kCapitalLetterEtaWithPsiliAndVaria               = 0x1F2A,
                kCapitalLetterEtaWithDasiaAndVaria               = 0x1F2B,
                kCapitalLetterEtaWithPsiliAndOxia                = 0x1F2C,
                kCapitalLetterEtaWithDasiaAndOxia                = 0x1F2D,
                kCapitalLetterEtaWithPsiliAndPerispomeni = 0x1F2E,
                kCapitalLetterEtaWithDasiaAndPerispomeni = 0x1F2F,
                kSmallLetterIotaWithPsili                                = 0x1F30,
                kSmallLetterIotaWithDasia                                = 0x1F31,
                kSmallLetterIotaWithPsiliAndVaria                = 0x1F32,
                kSmallLetterIotaWithDasiaAndVaria                = 0x1F33,
                kSmallLetterIotaWithPsiliAndOxia                 = 0x1F34,
                kSmallLetterIotaWithDasiaAndOxia                 = 0x1F35,
                kSmallLetterIotaWithPsiliAndPerispomeni  = 0x1F36,
                kSmallLetterIotaWithDasiaAndPerispomeni  = 0x1F37,
                kCapitalLetterIotaWithPsili                              = 0x1F38,
                kCapitalLetterIotaWithDasia                              = 0x1F39,
                kCapitalLetterIotaWithPsiliAndVaria              = 0x1F3A,
                kCapitalLetterIotaWithDasiaAndVaria              = 0x1F3B,
                kCapitalLetterIotaWithPsiliAndOxia               = 0x1F3C,
                kCapitalLetterIotaWithDasiaAndOxia               = 0x1F3D,
                kCapitalLetterIotaWithPsiliAndPerispomeni = 0x1F3E,
                kCapitalLetterIotaWithDasiaAndPerispomeni = 0x1F3F,
                kSmallLetterOmicronWithPsili                     = 0x1F40,
                kSmallLetterOmicronWithDasia                     = 0x1F41,
                kSmallLetterOmicronWithPsiliAndVaria     = 0x1F42,
                kSmallLetterOmicronWithDasiaAndVaria     = 0x1F43,
                kSmallLetterOmicronWithPsiliAndOxia              = 0x1F44,
                kSmallLetterOmicronWithDasiaAndOxia              = 0x1F45,
                kCapitalLetterOmicronWithPsili                   = 0x1F48,
                kCapitalLetterOmicronWithDasia                   = 0x1F49,
                kCapitalLetterOmicronWithPsiliAndVaria   = 0x1F4A,
                kCapitalLetterOmicronWithDasiaAndVaria   = 0x1F4B,
                kCapitalLetterOmicronWithPsiliAndOxia    = 0x1F4C,
                kCapitalLetterOmicronWithDasiaAndOxia    = 0x1F4D,
                kSmallLetterUpsilonWithPsili                     = 0x1F50,
                kSmallLetterUpsilonWithDasia                     = 0x1F51,
                kSmallLetterUpsilonWithPsiliAndVaria     = 0x1F52,
                kSmallLetterUpsilonWithDasiaAndVaria     = 0x1F53,
                kSmallLetterUpsilonWithPsiliAndOxia              = 0x1F54,
                kSmallLetterUpsilonWithDasiaAndOxia              = 0x1F55,
                kSmallLetterUpsilonWithPsiliAndPerispomeni = 0x1F56,
                kSmallLetterUpsilonWithDasiaAndPerispomeni = 0x1F57,
                kCapitalLetterUpsilonWithDasia                   = 0x1F59,
                kCapitalLetterUpsilonWithDasiaAndVaria   = 0x1F5B,
                kCapitalLetterUpsilonWithDasiaAndOxia    = 0x1F5D,
                kCapitalLetterUpsilonWithDasiaAndPerispomeni = 0x1F5F,
                kSmallLetterOmegaWithPsili                               = 0x1F60,
                kSmallLetterOmegaWithDasia                               = 0x1F61,
                kSmallLetterOmegaWithPsiliAndVaria               = 0x1F62,
                kSmallLetterOmegaWithDasiaAndVaria               = 0x1F63,
                kSmallLetterOmegaWithPsiliAndOxia                = 0x1F64,
                kSmallLetterOmegaWithDasiaAndOxia                = 0x1F65,
                kSmallLetterOmegaWithPsiliAndPerispomeni = 0x1F66,
                kSmallLetterOmegaWithDasiaAndPerispomeni = 0x1F67,
                kCapitalLetterOmegaWithPsili                     = 0x1F68,
                kCapitalLetterOmegaWithDasia                     = 0x1F69,
                kCapitalLetterOmegaWithPsiliAndVaria     = 0x1F6A,
                kCapitalLetterOmegaWithDasiaAndVaria     = 0x1F6B,
                kCapitalLetterOmegaWithPsiliAndOxia              = 0x1F6C,
                kCapitalLetterOmegaWithDasiaAndOxia              = 0x1F6D,
                kCapitalLetterOmegaWithPsiliAndPerispomeni = 0x1F6E,
                kCapitalLetterOmegaWithDasiaAndPerispomeni = 0x1F6F,
                kSmallLetterAlphaWithVaria                               = 0x1F70,
                kSmallLetterAlphaWithOxia                                = 0x1F71,
                kSmallLetterEpsilonWithVaria                     = 0x1F72,
                kSmallLetterEpsilonWithOxia                              = 0x1F73,
                kSmallLetterEtaWithVaria                                 = 0x1F74,
                kSmallLetterEtaWithOxia                                  = 0x1F75,
                kSmallLetterIotaWithVaria                                = 0x1F76,
                kSmallLetterIotaWithOxia                                 = 0x1F77,
                kSmallLetterOmicronWithVaria                     = 0x1F78,
                kSmallLetterOmicronWithOxia                              = 0x1F79,
                kSmallLetterUpsilonWithVaria                     = 0x1F7A,
                kSmallLetterUpsilonWithOxia                              = 0x1F7B,
                kSmallLetterOmegaWithVaria                               = 0x1F7C,
                kSmallLetterOmegaWithOxia                                = 0x1F7D,
                kSmallLetterAlphaWithPsiliAndYpogegrammeni = 0x1F80,
                kSmallLetterAlphaWithDasiaAndYpogegrammeni = 0x1F81,
                kSmallLetterAlphaWithPsiliAndVariaAndYpogegrammeni = 0x1F82,
                kSmallLetterAlphaWithDasiaAndVariaAndYpogegrammeni = 0x1F83,
                kSmallLetterAlphaWithPsiliAndOxiaAndYpogegrammeni = 0x1F84,
                kSmallLetterAlphaWithDasiaAndOxiaAndYpogegrammeni = 0x1F85,
                kSmallLetterAlphaWithPsiliAndPerispomeniAndYpogegrammeni = 0x1F86,
                kSmallLetterAlphaWithDasiaAndPerispomeniAndYpogegrammeni = 0x1F87,
                kCapitalLetterAlphaWithPsiliAndProsgegrammeni = 0x1F88,
                kCapitalLetterAlphaWithDasiaAndProsgegrammeni = 0x1F89,
                kCapitalLetterAlphaWithPsiliAndVariaAndProsgegrammeni = 0x1F8A,
                kCapitalLetterAlphaWithDasiaAndVariaAndProsgegrammeni = 0x1F8B,
                kCapitalLetterAlphaWithPsiliAndOxiaAndProsgegrammeni = 0x1F8C,
                kCapitalLetterAlphaWithDasiaAndOxiaAndProsgegrammeni = 0x1F8D,
                kCapitalLetterAlphaWithPsiliAndPerispomeniAndProsgegrammeni = 0x1F8E,
                kCapitalLetterAlphaWithDasiaAndPerispomeniAndProsgegrammeni = 0x1F8F,
                kSmallLetterEtaWithPsiliAndYpogegrammeni = 0x1F90,
                kSmallLetterEtaWithDasiaAndYpogegrammeni = 0x1F91,
                kSmallLetterEtaWithPsiliAndVariaAndYpogegrammeni = 0x1F92,
                kSmallLetterEtaWithDasiaAndVariaAndYpogegrammeni = 0x1F93,
                kSmallLetterEtaWithPsiliAndOxiaAndYpogegrammeni = 0x1F94,
                kSmallLetterEtaWithDasiaAndOxiaAndYpogegrammeni = 0x1F95,
                kSmallLetterEtaWithPsiliAndPerispomeniAndYpogegrammeni = 0x1F96,
                kSmallLetterEtaWithDasiaAndPerispomeniAndYpogegrammeni = 0x1F97,
                kCapitalLetterEtaWithPsiliAndProsgegrammeni = 0x1F98,
                kCapitalLetterEtaWithDasiaAndProsgegrammeni = 0x1F99,
                kCapitalLetterEtaWithPsiliAndVariaAndProsgegrammeni = 0x1F9A,
                kCapitalLetterEtaWithDasiaAndVariaAndProsgegrammeni = 0x1F9B,
                kCapitalLetterEtaWithPsiliAndOxiaAndProsgegrammeni = 0x1F9C,
                kCapitalLetterEtaWithDasiaAndOxiaAndProsgegrammeni = 0x1F9D,
                kCapitalLetterEtaWithPsiliAndPerispomeniAndProsgegrammeni = 0x1F9E,
                kCapitalLetterEtaWithDasiaAndPerispomeniAndProsgegrammeni = 0x1F9F,
                kSmallLetterOmegaWithPsiliAndYpogegrammeni = 0x1FA0,
                kSmallLetterOmegaWithDasiaAndYpogegrammeni = 0x1FA1,
                kSmallLetterOmegaWithPsiliAndVariaAndYpogegrammeni = 0x1FA2,
                kSmallLetterOmegaWithDasiaAndVariaAndYpogegrammeni = 0x1FA3,
                kSmallLetterOmegaWithPsiliAndOxiaAndYpogegrammeni = 0x1FA4,
                kSmallLetterOmegaWithDasiaAndOxiaAndYpogegrammeni = 0x1FA5,
                kSmallLetterOmegaWithPsiliAndPerispomeniAndYpogegrammeni = 0x1FA6,
                kSmallLetterOmegaWithDasiaAndPerispomeniAndYpogegrammeni = 0x1FA7,
                kCapitalLetterOmegaWithPsiliAndProsgegrammeni = 0x1FA8,
                kCapitalLetterOmegaWithDasiaAndProsgegrammeni = 0x1FA9,
                kCapitalLetterOmegaWithPsiliAndVariaAndProsgegrammeni = 0x1FAA,
                kCapitalLetterOmegaWithDasiaAndVariaAndProsgegrammeni = 0x1FAB,
                kCapitalLetterOmegaWithPsiliAndOxiaAndProsgegrammeni = 0x1FAC,
                kCapitalLetterOmegaWithDasiaAndOxiaAndProsgegrammeni = 0x1FAD,
                kCapitalLetterOmegaWithPsiliAndPerispomeniAndProsgegrammeni = 0x1FAE,
                kCapitalLetterOmegaWithDasiaAndPerispomeniAndProsgegrammeni = 0x1FAF,
                kSmallLetterAlphaWithVrachy                              = 0x1FB0,
                kSmallLetterAlphaWithMacron                              = 0x1FB1,
                kSmallLetterAlphaWithVariaAndYpogegrammeni = 0x1FB2,
                kSmallLetterAlphaWithYpogegrammeni               = 0x1FB3,
                kSmallLetterAlphaWithOxiaAndYpogegrammeni = 0x1FB4,
                kSmallLetterAlphaWithPerispomeni                 = 0x1FB6,
                kSmallLetterAlphaWithPerispomeniAndYpogegrammeni = 0x1FB7,
                kCapitalLetterAlphaWithVrachy                    = 0x1FB8,
                kCapitalLetterAlphaWithMacron                    = 0x1FB9,
                kCapitalLetterAlphaWithVaria                     = 0x1FBA,
                kCapitalLetterAlphaWithOxia                              = 0x1FBB,
                kCapitalLetterAlphaWithProsgegrammeni    = 0x1FBC,
                kKoronis                                                                 = 0x1FBD,
                kProsgegrammeni                                                  = 0x1FBE,
                kPsili                                                                   = 0x1FBF,
                kPerispomeni                                                     = 0x1FC0,
                kDialytikaAndPerispomeni                                 = 0x1FC1,
                kSmallLetterEtaWithVariaAndYpogegrammeni = 0x1FC2,
                kSmallLetterEtaWithYpogegrammeni                 = 0x1FC3,
                kSmallLetterEtaWithOxiaAndYpogegrammeni  = 0x1FC4,
                kSmallLetterEtaWithPerispomeni                   = 0x1FC6,
                kSmallLetterEtaWithPerispomeniAndYpogegrammeni = 0x1FC7,
                kCapitalLetterEpsilonWithVaria                   = 0x1FC8,
                kCapitalLetterEpsilonWithOxia                    = 0x1FC9,
                kCapitalLetterEtaWithVaria                               = 0x1FCA,
                kCapitalLetterEtaWithOxia                                = 0x1FCB,
                kCapitalLetterEtaWithProsgegrammeni              = 0x1FCC,
                kPsiliAndVaria                                                   = 0x1FCD,
                kPsiliAndOxia                                                    = 0x1FCE,
                kPsiliAndPerispomeni                                     = 0x1FCF,
                kSmallLetterIotaWithVrachy                               = 0x1FD0,
                kSmallLetterIotaWithMacron                               = 0x1FD1,
                kSmallLetterIotaWithDialytikaAndVaria    = 0x1FD2,
                kSmallLetterIotaWithDialytikaAndOxia     = 0x1FD3,
                kSmallLetterIotaWithPerispomeni                  = 0x1FD6,
                kSmallLetterIotaWithDialytikaAndPerispomeni = 0x1FD7,
                kCapitalLetterIotaWithVrachy                     = 0x1FD8,
                kCapitalLetterIotaWithMacron                     = 0x1FD9,
                kCapitalLetterIotaWithVaria                              = 0x1FDA,
                kCapitalLetterIotaWithOxia                               = 0x1FDB,
                kDasiaAndVaria                                                   = 0x1FDD,
                kDasiaAndOxia                                                    = 0x1FDE,
                kDasiaAndPerispomeni                                     = 0x1FDF,
                kSmallLetterUpsilonWithVrachy                    = 0x1FE0,
                kSmallLetterUpsilonWithMacron                    = 0x1FE1,
                kSmallLetterUpsilonWithDialytikaAndVaria = 0x1FE2,
                kSmallLetterUpsilonWithDialytikaAndOxia  = 0x1FE3,
                kSmallLetterRhoWithPsili                                 = 0x1FE4,
                kSmallLetterRhoWithDasia                                 = 0x1FE5,
                kSmallLetterUpsilonWithPerispomeni               = 0x1FE6,
                kSmallLetterUpsilonWithDialytikaAndPerispomeni = 0x1FE7,
                kCapitalLetterUpsilonWithVrachy                  = 0x1FE8,
                kCapitalLetterUpsilonWithMacron                  = 0x1FE9,
                kCapitalLetterUpsilonWithVaria                   = 0x1FEA,
                kCapitalLetterUpsilonWithOxia                    = 0x1FEB,
                kCapitalLetterRhoWithDasia                               = 0x1FEC,
                kDialytikaAndVaria                                               = 0x1FED,
                kDialytikaAndOxia                                                = 0x1FEE,
                kVaria                                                                   = 0x1FEF,
                kSmallLetterOmegaWithVariaAndYpogegrammeni = 0x1FF2,
                kSmallLetterOmegaWithYpogegrammeni               = 0x1FF3,
                kSmallLetterOmegaWithOxiaAndYpogegrammeni = 0x1FF4,
                kSmallLetterOmegaWithPerispomeni                 = 0x1FF6,
                kSmallLetterOmegaWithPerispomeniAndYpogegrammeni = 0x1FF7,
                kCapitalLetterOmicronWithVaria                   = 0x1FF8,
                kCapitalLetterOmicronWithOxia                    = 0x1FF9,
                kCapitalLetterOmegaWithVaria                     = 0x1FFA,
                kCapitalLetterOmegaWithOxia                              = 0x1FFB,
                kCapitalLetterOmegaWithProsgegrammeni    = 0x1FFC,
                kOxia                                                                    = 0x1FFD,
                kDasia                                                                   = 0x1FFE,
                kTurnedSmallLetterIota                                   = 0x2129,

                //      Values derived from Unicode 1.0 names

                kGreekSpacingIotaBelow                                   = kYpogegrammeni,
                kGreekSpacingDiaeresisTonos                      = kDialytikaTonos
        };

private:

};







//=================================================================================
// class UCyrillic
//=================================================================================
class UCyrillic {

public:

        enum ECyrillicNames {

                kCapitalLetterIo                                                 = 0x0401,
                kCapitalLetterDje                                                = 0x0402,
                kCapitalLetterGje                                                = 0x0403,
                kCapitalLetterUkrainianIe                                = 0x0404,
                kCapitalLetterDze                                                = 0x0405,
                kCapitalLetterByelorussianUkrainianI     = 0x0406,
                kCapitalLetterYi                                                 = 0x0407,
                kCapitalLetterJe                                                 = 0x0408,
                kCapitalLetterLje                                                = 0x0409,
                kCapitalLetterNje                                                = 0x040A,
                kCapitalLetterTshe                                               = 0x040B,
                kCapitalLetterKje                                                = 0x040C,
                kCapitalLetterShortU                                     = 0x040E,
                kCapitalLetterDzhe                                               = 0x040F,
                kCapitalLetterA                                                  = 0x0410,
                kCapitalLetterBe                                                 = 0x0411,
                kCapitalLetterVe                                                 = 0x0412,
                kCapitalLetterGhe                                                = 0x0413,
                kCapitalLetterDe                                                 = 0x0414,
                kCapitalLetterIe                                                 = 0x0415,
                kCapitalLetterZhe                                                = 0x0416,
                kCapitalLetterZe                                                 = 0x0417,
                kCapitalLetterI                                                  = 0x0418,
                kCapitalLetterShortI                                     = 0x0419,
                kCapitalLetterKa                                                 = 0x041A,
                kCapitalLetterEl                                                 = 0x041B,
                kCapitalLetterEm                                                 = 0x041C,
                kCapitalLetterEn                                                 = 0x041D,
                kCapitalLetterO                                                  = 0x041E,
                kCapitalLetterPe                                                 = 0x041F,
                kCapitalLetterEr                                                 = 0x0420,
                kCapitalLetterEs                                                 = 0x0421,
                kCapitalLetterTe                                                 = 0x0422,
                kCapitalLetterU                                                  = 0x0423,
                kCapitalLetterEf                                                 = 0x0424,
                kCapitalLetterHa                                                 = 0x0425,
                kCapitalLetterTse                                                = 0x0426,
                kCapitalLetterChe                                                = 0x0427,
                kCapitalLetterSha                                                = 0x0428,
                kCapitalLetterShcha                                              = 0x0429,
                kCapitalLetterHardSign                                   = 0x042A,
                kCapitalLetterYeru                                               = 0x042B,
                kCapitalLetterSoftSign                                   = 0x042C,
                kCapitalLetterE                                                  = 0x042D,
                kCapitalLetterYu                                                 = 0x042E,
                kCapitalLetterYa                                                 = 0x042F,
                kSmallLetterA                                                    = 0x0430,
                kSmallLetterBe                                                   = 0x0431,
                kSmallLetterVe                                                   = 0x0432,
                kSmallLetterGhe                                                  = 0x0433,
                kSmallLetterDe                                                   = 0x0434,
                kSmallLetterIe                                                   = 0x0435,
                kSmallLetterZhe                                                  = 0x0436,
                kSmallLetterZe                                                   = 0x0437,
                kSmallLetterI                                                    = 0x0438,
                kSmallLetterShortI                                               = 0x0439,
                kSmallLetterKa                                                   = 0x043A,
                kSmallLetterEl                                                   = 0x043B,
                kSmallLetterEm                                                   = 0x043C,
                kSmallLetterEn                                                   = 0x043D,
                kSmallLetterO                                                    = 0x043E,
                kSmallLetterPe                                                   = 0x043F,
                kSmallLetterEr                                                   = 0x0440,
                kSmallLetterEs                                                   = 0x0441,
                kSmallLetterTe                                                   = 0x0442,
                kSmallLetterU                                                    = 0x0443,
                kSmallLetterEf                                                   = 0x0444,
                kSmallLetterHa                                                   = 0x0445,
                kSmallLetterTse                                                  = 0x0446,
                kSmallLetterChe                                                  = 0x0447,
                kSmallLetterSha                                                  = 0x0448,
                kSmallLetterShcha                                                = 0x0449,
                kSmallLetterHardSign                                     = 0x044A,
                kSmallLetterYeru                                                 = 0x044B,
                kSmallLetterSoftSign                                     = 0x044C,
                kSmallLetterE                                                    = 0x044D,
                kSmallLetterYu                                                   = 0x044E,
                kSmallLetterYa                                                   = 0x044F,
                kSmallLetterIo                                                   = 0x0451,
                kSmallLetterDje                                          = 0x0452,
                kSmallLetterGje                                                  = 0x0453,
                kSmallLetterUkrainianIe                                  = 0x0454,
                kSmallLetterDze                                                  = 0x0455,
                kSmallLetterByelorussianUkrainianI               = 0x0456,
                kSmallLetterYi                                                   = 0x0457,
                kSmallLetterJe                                                   = 0x0458,
                kSmallLetterLje                                                  = 0x0459,
                kSmallLetterNje                                                  = 0x045A,
                kSmallLetterTshe                                                 = 0x045B,
                kSmallLetterKje                                                  = 0x045C,
                kSmallLetterShortU                                               = 0x045E,
                kSmallLetterDzhe                                                 = 0x045F,
                kCapitalLetterOmega                                              = 0x0460,
                kSmallLetterOmega                                                = 0x0461,
                kCapitalLetterYat                                                = 0x0462,
                kSmallLetterYat                                                  = 0x0463,
                kCapitalLetterIotifiedE                                  = 0x0464,
                kSmallLetterIotifiedE                                    = 0x0465,
                kCapitalLetterLittleYus                                  = 0x0466,
                kSmallLetterLittleYus                                    = 0x0467,
                kCapitalLetterIotifiedLittleYus                  = 0x0468,
                kSmallLetterIotifiedLittleYus                    = 0x0469,
                kCapitalLetterBigYus                                     = 0x046A,
                kSmallLetterBigYus                                               = 0x046B,
                kCapitalLetterIotifiedBigYus                     = 0x046C,
                kSmallLetterIotifiedBigYus                               = 0x046D,
                kCapitalLetterKsi                                                = 0x046E,
                kSmallLetterKsi                                                  = 0x046F,
                kCapitalLetterPsi                                                = 0x0470,
                kSmallLetterPsi                                                  = 0x0471,
                kCapitalLetterFita                                               = 0x0472,
                kSmallLetterFita                                                 = 0x0473,
                kCapitalLetterIzhitsa                                    = 0x0474,
                kSmallLetterIzhitsa                                              = 0x0475,
                kCapitalLetterIzhitsaWithDoubleGraveAccent = 0x0476,
                kSmallLetterIzhitsaWithDoubleGraveAccent = 0x0477,
                kCapitalLetterUk                                                 = 0x0478,
                kSmallLetterUk                                                   = 0x0479,
                kCapitalLetterRoundOmega                                 = 0x047A,
                kSmallLetterRoundOmega                                   = 0x047B,
                kCapitalLetterOmegaWithTitlo                     = 0x047C,
                kSmallLetterOmegaWithTitlo                               = 0x047D,
                kCapitalLetterOt                                                 = 0x047E,
                kSmallLetterOt                                                   = 0x047F,
                kCapitalLetterKoppa                                              = 0x0480,
                kSmallLetterKoppa                                                = 0x0481,
                kThousandsSign                                                   = 0x0482,
                kCombiningTitlo                                                  = 0x0483,
                kCombiningPalatalization                                 = 0x0484,
                kCombiningDasiaPneumata                                  = 0x0485,
                kCombiningPsiliPneumata                                  = 0x0486,
                kCapitalLetterGheWithUpturn                              = 0x0490,
                kSmallLetterGheWithUpturn                                = 0x0491,
                kCapitalLetterGheWithStroke                              = 0x0492,
                kSmallLetterGheWithStroke                                = 0x0493,
                kCapitalLetterGheWithMiddleHook                  = 0x0494,
                kSmallLetterGheWithMiddleHook                    = 0x0495,
                kCapitalLetterZheWithDescender                   = 0x0496,
                kSmallLetterZheWithDescender                     = 0x0497,
                kCapitalLetterZeWithDescender                    = 0x0498,
                kSmallLetterZeWithDescender                              = 0x0499,
                kCapitalLetterKaWithDescender                    = 0x049A,
                kSmallLetterKaWithDescender                              = 0x049B,
                kCapitalLetterKaWithVerticalStroke               = 0x049C,
                kSmallLetterKaWithVerticalStroke                 = 0x049D,
                kCapitalLetterKaWithStroke                               = 0x049E,
                kSmallLetterKaWithStroke                                 = 0x049F,
                kCapitalLetterBashkirKa                                  = 0x04A0,
                kSmallLetterBashkirKa                                    = 0x04A1,
                kCapitalLetterEnWithDescender                    = 0x04A2,
                kSmallLetterEnWithDescender                              = 0x04A3,
                kCapitalLigatureEnGhe                                    = 0x04A4,
                kSmallLigatureEnGhe                                              = 0x04A5,
                kCapitalLetterPeWithMiddleHook                   = 0x04A6,
                kSmallLetterPeWithMiddleHook                     = 0x04A7,
                kCapitalLetterAbkhasianHa                                = 0x04A8,
                kSmallLetterAbkhasianHa                                  = 0x04A9,
                kCapitalLetterEsWithDescender                    = 0x04AA,
                kSmallLetterEsWithDescender                              = 0x04AB,
                kCapitalLetterTeWithDescender                    = 0x04AC,
                kSmallLetterTeWithDescender                              = 0x04AD,
                kCapitalLetterStraightU                                  = 0x04AE,
                kSmallLetterStraightU                                    = 0x04AF,
                kCapitalLetterStraightUWithStroke                = 0x04B0,
                kSmallLetterStraightUWithStroke                  = 0x04B1,
                kCapitalLetterHaWithDescender                    = 0x04B2,
                kSmallLetterHaWithDescender                              = 0x04B3,
                kCapitalLigatureTeTse                                    = 0x04B4,
                kSmallLigatureTeTse                                      = 0x04B5,
                kCapitalLetterCheWithDescender                   = 0x04B6,
                kSmallLetterCheWithDescender                     = 0x04B7,
                kCapitalLetterCheWithVerticalStroke              = 0x04B8,
                kSmallLetterCheWithVerticalStroke                = 0x04B9,
                kCapitalLetterShha                                               = 0x04BA,
                kSmallLetterShha                                                 = 0x04BB,
                kCapitalLetterAbkhasianChe                               = 0x04BC,
                kSmallLetterAbkhasianChe                                 = 0x04BD,
                kCapitalLetterAbkhasianCheWithDescender  = 0x04BE,
                kSmallLetterAbkhasianCheWithDescender    = 0x04BF,
                kLetterPalochka                                                  = 0x04C0,
                kCapitalLetterZheWithBreve                               = 0x04C1,
                kSmallLetterZheWithBreve                                 = 0x04C2,
                kCapitalLetterKaWithHook                                 = 0x04C3,
                kSmallLetterKaWithHook                                   = 0x04C4,
                kCapitalLetterEnWithHook                                 = 0x04C7,
                kSmallLetterEnWithHook                                   = 0x04C8,
                kCapitalLetterKhakassianChe                              = 0x04CB,
                kSmallLetterKhakassianChe                                = 0x04CC,
                kCapitalLetterAWithBreve                                 = 0x04D0,
                kSmallLetterAWithBreve                                   = 0x04D1,
                kCapitalLetterAWithDiaeresis                     = 0x04D2,
                kSmallLetterAWithDiaeresis                               = 0x04D3,
                kCapitalLigatureAIe                                              = 0x04D4,
                kSmallLigatureAIe                                                = 0x04D5,
                kCapitalLetterIeWithBreve                                = 0x04D6,
                kSmallLetterIeWithBreve                                  = 0x04D7,
                kCapitalLetterSchwa                                              = 0x04D8,
                kSmallLetterSchwa                                                = 0x04D9,
                kCapitalLetterSchwaWithDiaeresis                 = 0x04DA,
                kSmallLetterSchwaWithDiaeresis                   = 0x04DB,
                kCapitalLetterZheWithDiaeresis                   = 0x04DC,
                kSmallLetterZheWithDiaeresis                     = 0x04DD,
                kCapitalLetterZeWithDiaeresis                    = 0x04DE,
                kSmallLetterZeWithDiaeresis                              = 0x04DF,
                kCapitalLetterAbkhasianDze                               = 0x04E0,
                kSmallLetterAbkhasianDze                                 = 0x04E1,
                kCapitalLetterIWithMacron                                = 0x04E2,
                kSmallLetterIWithMacron                                  = 0x04E3,
                kCapitalLetterIWithDiaeresis                     = 0x04E4,
                kSmallLetterIWithDiaeresis                               = 0x04E5,
                kCapitalLetterOWithDiaeresis                     = 0x04E6,
                kSmallLetterOWithDiaeresis                               = 0x04E7,
                kCapitalLetterBarredO                                    = 0x04E8,
                kSmallLetterBarredO                                              = 0x04E9,
                kCapitalLetterBarredOWithDiaeresis               = 0x04EA,
                kSmallLetterBarredOWithDiaeresis                 = 0x04EB,
                kCapitalLetterUWithMacron                                = 0x04EE,
                kSmallLetterUWithMacron                                  = 0x04EF,
                kCapitalLetterUWithDiaeresis                     = 0x04F0,
                kSmallLetterUWithDiaeresis                               = 0x04F1,
                kCapitalLetterUWithDoubleAcute                   = 0x04F2,
                kSmallLetterUWithDoubleAcute                     = 0x04F3,
                kCapitalLetterCheWithDiaeresis                   = 0x04F4,
                kSmallLetterCheWithDiaeresis                     = 0x04F5,
                kCapitalLetterYeruWithDiaeresis                  = 0x04F8,
                kSmallLetterYeruWithDiaeresis                    = 0x04F9
        };

private:

};







//=================================================================================
// class UGeorgian
//=================================================================================

class UGeorgian {

public:

        enum EGeorgianNames {

                kCapitalLetterAn                                                 = 0x10A0,
                kCapitalLetterBan                                                = 0x10A1,
                kCapitalLetterGan                                                = 0x10A2,
                kCapitalLetterDon                                                = 0x10A3,
                kCapitalLetterEn                                                 = 0x10A4,
                kCapitalLetterVin                                                = 0x10A5,
                kCapitalLetterZen                                                = 0x10A6,
                kCapitalLetterTan                                                = 0x10A7,
                kCapitalLetterIn                                                 = 0x10A8,
                kCapitalLetterKan                                                = 0x10A9,
                kCapitalLetterLas                                                = 0x10AA,
                kCapitalLetterMan                                                = 0x10AB,
                kCapitalLetterNar                                                = 0x10AC,
                kCapitalLetterOn                                                 = 0x10AD,
                kCapitalLetterPar                                                = 0x10AE,
                kCapitalLetterZhar                                               = 0x10AF,
                kCapitalLetterRae                                                = 0x10B0,
                kCapitalLetterSan                                                = 0x10B1,
                kCapitalLetterTar                                                = 0x10B2,
                kCapitalLetterUn                                                 = 0x10B3,
                kCapitalLetterPhar                                               = 0x10B4,
                kCapitalLetterKhar                                               = 0x10B5,
                kCapitalLetterGhan                                               = 0x10B6,
                kCapitalLetterQar                                                = 0x10B7,
                kCapitalLetterShin                                               = 0x10B8,
                kCapitalLetterChin                                               = 0x10B9,
                kCapitalLetterCan                                                = 0x10BA,
                kCapitalLetterJil                                                = 0x10BB,
                kCapitalLetterCil                                                = 0x10BC,
                kCapitalLetterChar                                               = 0x10BD,
                kCapitalLetterXan                                                = 0x10BE,
                kCapitalLetterJhan                                               = 0x10BF,
                kCapitalLetterHae                                                = 0x10C0,
                kCapitalLetterHe                                                 = 0x10C1,
                kCapitalLetterHie                                                = 0x10C2,
                kCapitalLetterWe                                                 = 0x10C3,
                kCapitalLetterHar                                                = 0x10C4,
                kCapitalLetterHoe                                                = 0x10C5,
                kLetterAn                                                                = 0x10D0,
                kLetterBan                                                               = 0x10D1,
                kLetterGan                                                               = 0x10D2,
                kLetterDon                                                               = 0x10D3,
                kLetterEn                                                                = 0x10D4,
                kLetterVin                                                               = 0x10D5,
                kLetterZen                                                               = 0x10D6,
                kLetterTan                                                               = 0x10D7,
                kLetterIn                                                                = 0x10D8,
                kLetterKan                                                               = 0x10D9,
                kLetterLas                                                               = 0x10DA,
                kLetterMan                                                               = 0x10DB,
                kLetterNar                                                               = 0x10DC,
                kLetterOn                                                                = 0x10DD,
                kLetterPar                                                               = 0x10DE,
                kLetterZhar                                                              = 0x10DF,
                kLetterRae                                                               = 0x10E0,
                kLetterSan                                                               = 0x10E1,
                kLetterTar                                                               = 0x10E2,
                kLetterUn                                                                = 0x10E3,
                kLetterPhar                                                              = 0x10E4,
                kLetterKhar                                                              = 0x10E5,
                kLetterGhan                                                              = 0x10E6,
                kLetterQar                                                               = 0x10E7,
                kLetterShin                                                              = 0x10E8,
                kLetterChin                                                              = 0x10E9,
                kLetterCan                                                               = 0x10EA,
                kLetterJil                                                               = 0x10EB,
                kLetterCil                                                               = 0x10EC,
                kLetterChar                                                              = 0x10ED,
                kLetterXan                                                               = 0x10EE,
                kLetterJhan                                                              = 0x10EF,
                kLetterHae                                                               = 0x10F0,
                kLetterHe                                                                = 0x10F1,
                kLetterHie                                                               = 0x10F2,
                kLetterWe                                                                = 0x10F3,
                kLetterHar                                                               = 0x10F4,
                kLetterHoe                                                               = 0x10F5,
                kLetterFi                                                                = 0x10F6,
                kParagraphSeparator                                              = 0x10FB
        };

private:

};







//=================================================================================
// class UCoptic
//=================================================================================

class UCoptic {

public:

        enum ECopticNames {

                kCapitalLetterShei                                               = 0x03E2,
                kSmallLetterShei                                                 = 0x03E3,
                kCapitalLetterFei                                                = 0x03E4,
                kSmallLetterFei                                                  = 0x03E5,
                kCapitalLetterKhei                                               = 0x03E6,
                kSmallLetterKhei                                                 = 0x03E7,
                kCapitalLetterHori                                               = 0x03E8,
                kSmallLetterHori                                                 = 0x03E9,
                kCapitalLetterGangia                                     = 0x03EA,
                kSmallLetterGangia                                               = 0x03EB,
                kCapitalLetterShima                                              = 0x03EC,
                kSmallLetterShima                                                = 0x03ED,
                kCapitalLetterDei                                                = 0x03EE,
                kSmallLetterDei                                                  = 0x03EF
        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUEEURO_

