// Revision: 98 1.13.1.4 source/core/text/unicode/iueasia.hpp, text, ioc.v400, 980918 
// iueasia.hpp
/**
 * This file contains the classes UKangXiRadical, UHanNumeral, UHiragana,
 * UKatakana, UKatakanaHiragana, UHangulChoseong, UHungulJungseong,
 * UBopomofo, UHangulLetter, UHangulJongseong, UHangzhouNumeral,
 * UIdeographicAnnotation which provide information about the east Asian
 * scripts.
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */


#ifndef _IUEASIA_
#define _IUEASIA_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class UKangXiRadical;
class UHanNumeral;
class UHiragana;
class UKatakana;
class UKatakanaHiragana;
class UHangulChoseong;
class UHangulJungseong;
class UBopomofo;
class UHangulLetter;
class UHangulJongseong;
class UHangzhouNumeral;
class UIdeographicAnnotation;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class UKangXiRadical
//=================================================================================
class UKangXiRadical {

public:

        enum EKangXiRadicalNames {

                kOne                            =       0x4E00,
                kLine                           =       0x4E28,
                kDot                            =       0x4E36,
                kSlash                          =       0x4E3F,
                kSecond                         =       0x4E59,
                kHook                           =       0x4E85,
                kTwo                            =       0x4E8C,
                kLid                            =       0x4EA0,
                kMan                            =       0x4EBA,
                kLegs                           =       0x513F,
                kEnter                          =       0x5165,
                kEight                          =       0x516B,
                kDownBox                        =       0x5182,
                kCover                          =       0x5196,
                kIce                            =       0x51AB,
                kTable                          =       0x51E0,
                kOpenBox                        =       0x51F5,
                kKnife                          =       0x5200,
                kPower                          =       0x529B,
                kWrap                           =       0x52F9,
                kSpoon                          =       0x5315,
                kRightOpenBox           =       0x531A,
                kHidingEnclosure        =       0x5338,
                kTen                            =       0x5341,
                kDivination                     =       0x535C,
                kSeal                           =       0x5369,
                kCliff                          =       0x5382,
                kPrivate                        =       0x53B6,
                kAgain                          =       0x53C8,
                kMouth                          =       0x53E3,
                kEnclosure                      =       0x56D7,
                kEarth                          =       0x571F,
                kScholar                        =       0x58EB,
                kGo                                     =       0x5902,
                kGoSlowly                       =       0x590A,
                kEvening                        =       0x5915,
                kBig                            =       0x5927,
                kWoman                          =       0x5973,
                kChild                          =       0x5B50,
                kRoof                           =       0x5B80,
                kInch                           =       0x5BF8,
                kSmall                          =       0x5C0F,
                kLame                           =       0x5C22,
                kCorpse                         =       0x5C38,
                kSprout                         =       0x5C6E,
                kMountain                       =       0x5C71,
                kRiver                          =       0x5DDB,
                kWork                           =       0x5DE5,
                kOneself                        =       0x5DF1,
                kTurban                         =       0x5DFE,
                kDry                            =       0x5E72,
                kThread                         =       0x5E7A,
                kDottedCliff            =       0x5E7F,
                kLongstride                     =       0x5EF4,
                kTwoHands                       =       0x5EFE,
                kShoot                          =       0x5F0B,
                kBow                            =       0x5F13,
                kSnout                          =       0x5F50,
                kBristle                        =       0x5F61,
                kStep                           =       0x5F73,
                kHeart                          =       0x5FC3,
                kHalberd                        =       0x6208,
                kDoor                           =       0x6236,
                kHand                           =       0x624B,
                kBranch                         =       0x652F,
                kRap                            =       0x6534,
                kScript                         =       0x6587,
                kDipper                         =       0x6597,
                kAxe                            =       0x65A4,
                kSquare                         =       0x65B9,
                kNot                            =       0x65E0,
                kSun                            =       0x65E5,
                kSay                            =       0x66F0,
                kMoon                           =       0x6708,
                kTree                           =       0x6728,
                kLack                           =       0x6B20,
                kStop                           =       0x6B62,
                kDeath                          =       0x6B79,
                kWeapon                         =       0x6BB3,
                kDont                           =       0x6BCB,
                kCompare                        =       0x6BD4,
                kFur                            =       0x6BDB,
                kClan                           =       0x6C0F,
                kSteam                          =       0x6C14,
                kWater                          =       0x6C34,
                kFire                           =       0x706B,
                kClaw                           =       0x722A,
                kFather                         =       0x7236,
                kDoubleX                        =       0x723B,
                kHalfTreeTrunk          =       0x723F,
                kSlice                          =       0x7247,
                kFang                           =       0x7259,
                kCow                            =       0x725B,
                kDog                            =       0x72AC,
                kProfound                       =       0x7384,
                kJade                           =       0x7389,
                kMelon                          =       0x74DC,
                kTile                           =       0x74E6,
                kSweet                          =       0x7518,
                kLife                           =       0x751F,
                kUse                            =       0x7528,
                kField                          =       0x7530,
                kBoltOfCloth            =       0x758B,
                kSickness                       =       0x7592,
                kDottedTent                     =       0x7676,
                kWhite                          =       0x767D,
                kSkin                           =       0x76AE,
                kDish                           =       0x76BF,
                kEye                            =       0x76EE,
                kSpear                          =       0x77DB,
                kArrow                          =       0x77E2,
                kStone                          =       0x77F3,
                kSpirit                         =       0x793A,
                kTrack                          =       0x79B8,
                kGrain                          =       0x79BE,
                kCave                           =       0x7A74,
                kStand                          =       0x7ACB,
                kBamboo                         =       0x7AF9,
                kRice                           =       0x7C73,
                kSilk                           =       0x7E9F,
                kJar                            =       0x7F36,
                kNet                            =       0x7F51,
                kSheep                          =       0x7F8A,
                kFeather                        =       0x7FBD,
                kOld                            =       0x8001,
                kAnd                            =       0x800C,
                kPlow                           =       0x8012,
                kEar                            =       0x8033,
                kBrush                          =       0x807F,
                kMeat                           =       0x8089,
                kMinister                       =       0x81E3,
                kSelf                           =       0x81EA,
                kArrive                         =       0x81F3,
                kMortar                         =       0x81FC,
                kTongue                         =       0x820C,
                kOppose                         =       0x821B,
                kBoat                           =       0x821F,
                kStopping                       =       0x826E,
                kColor                          =       0x8272,
                kGrass                          =       0x8278,
                kTiger                          =       0x864D,
                kInsect                         =       0x866B,
                kBlood                          =       0x8840,
                kWalkEnclosure          =       0x884C,
                kClothes                        =       0x8863,
                kWest                           =       0x897E,
                kSee                            =       0x898B,
                kHorn                           =       0x89D2,
                kSpeech                         =       0x8A00,
                kValley                         =       0x8C37,
                kBean                           =       0x8C46,
                kPig                            =       0x8C55,
                kBadger                         =       0x8C78,
                kShell                          =       0x8C9D,
                kRed                            =       0x8D64,
                kRun                            =       0x8D70,
                kFoot                           =       0x8DB3,
                kBody                           =       0x8EAB,
                kCart                           =       0x8ECA,
                kBitter                         =       0x8F9B,
                kMorning                        =       0x8FB0,
                kWalk                           =       0x8FB5,
                kCity                           =       0x9091,
                kBirdSign                       =       0x9149,
                kDistinguish            =       0x91C6,
                kVillage                        =       0x91CC,
                kGold                           =       0x91D1,
                kLong                           =       0x9577,
                kGate                           =       0x9580,
                kMound                          =       0x961C,
                kSlave                          =       0x96B6,
                kShortTailedBird        =       0x96B9,
                kRain                           =       0x96E8,
                kBlue                           =       0x9751,
                kWrong                          =       0x975E,
                kFace                           =       0x9762,
                kLeather                        =       0x9769,
                kTannedLeather          =       0x97CB,
                kLeek                           =       0x97ED,
                kSound                          =       0x97F3,
                kLeaf                           =       0x9801,
                kWind                           =       0x98A8,
                kFly                            =       0x98DB,
                kEat                            =       0x98DF,
                kHead                           =       0x9996,
                kFragrant                       =       0x9999,
                kHorse                          =       0x99AC,
                kBone                           =       0x9AA8,
                kTall                           =       0x9AD8,
                kHair                           =       0x9ADF,
                kFight                          =       0x9B25,
                kSacrificialWine        =       0x9B2F,
                kCaldron                        =       0x9B32,
                kGhost                          =       0x9B3C,
                kFish                           =       0x9B5A,
                kBird                           =       0x9CE5,
                kSalt                           =       0x9E75,
                kDeer                           =       0x9E7F,
                kWheat                          =       0x9EA5,
                kHemp                           =       0x9EBB,
                kYellow                         =       0x9EC3,
                kMillet                         =       0x9ECD,
                kBlack                          =       0x9ED1,
                kEmbroidery                     =       0x9EF9,
                kFrog                           =       0x9EFD,
                kTripod                         =       0x9F0E,
                kDrum                           =       0x9F13,
                kRat                            =       0x9F20,
                kNose                           =       0x9F3B,
                kEven                           =       0x9F4A,
                kTooth                          =       0x9F52,
                kDragon                         =       0x9F8D,
                kTurtle                         =       0x9F9C,
                kFlute                          =       0x9FA0
        };

private:

};







//=================================================================================
// class UHanNumeral
//=================================================================================

class UHanNumeral {

public:

        enum EHanNumeralNames {

                        kZero                                                   =       0x96F6,
                        kOne                                                    =       0x4E00,
                        kTwo                                                    =       0x4E8C,
                        kThree                                                  =       0x4E09,
                        kFour                                                   =       0x56DB,
                        kFive                                                   =       0x4E94,
                        kSix                                                    =       0x516D,
                        kSeven                                                  =       0x4E03,
                        kEight                                                  =       0x516B,
                        kNine                                                   =       0x4E5D,
                        kTen                                                    =       0x5341,
                        kTwenty                                                 =       0x5344,
                        kThirty                                                 =       0x5345,
                        kHundred                                                =       0x767E,
                        kThousand                                               =       0x5343,
                        kTenThousand                                    =       0x842C,
                        kYi                                                             =       0x5104,
                        kZhao                                                   =       0x5146,
                        kJing                                                   =       0x4EAC,
                        kGai                                                    =       0x5793,
                        kBu                                                             =       0x88DC,
                        kRang                                                   =       0x58E4,
                        kGou                                                    =       0x5193,
                        kJian                                                   =       0x6F97,
                        kZheng                                                  =       0x6B63,
                        kZai                                                    =       0x8F09,
                        kZi                                                             =       0x79ED,
                        kSimplifiedTenThousand                  =       0x4E07,
                        kSimplifiedYi                                   =       0x4EBF,
                        kSimplifiedBu                                   =       0x8865,
                        kSimplifiedJian                                 =       0x6DA7,
                        kSimplifiedZai                                  =       0x8F7D
        };


private:

};






//=================================================================================
// class UHiragana
//=================================================================================

class UHiragana {

public:

        enum EHiraganaNames {

                kLetterSmallA                                                    = 0x3041,
                kLetterA                                                                 = 0x3042,
                kLetterSmallI                                                    = 0x3043,
                kLetterI                                                                 = 0x3044,
                kLetterSmallU                                                    = 0x3045,
                kLetterU                                                                 = 0x3046,
                kLetterSmallE                                                    = 0x3047,
                kLetterE                                                                 = 0x3048,
                kLetterSmallO                                                    = 0x3049,
                kLetterO                                                                 = 0x304A,
                kLetterKa                                                                = 0x304B,
                kLetterGa                                                                = 0x304C,
                kLetterKi                                                                = 0x304D,
                kLetterGi                                                                = 0x304E,
                kLetterKu                                                                = 0x304F,
                kLetterGu                                                                = 0x3050,
                kLetterKe                                                                = 0x3051,
                kLetterGe                                                                = 0x3052,
                kLetterKo                                                                = 0x3053,
                kLetterGo                                                                = 0x3054,
                kLetterSa                                                                = 0x3055,
                kLetterZa                                                                = 0x3056,
                kLetterSi                                                                = 0x3057,
                kLetterZi                                                                = 0x3058,
                kLetterSu                                                                = 0x3059,
                kLetterZu                                                                = 0x305A,
                kLetterSe                                                                = 0x305B,
                kLetterZe                                                                = 0x305C,
                kLetterSo                                                                = 0x305D,
                kLetterZo                                                                = 0x305E,
                kLetterTa                                                                = 0x305F,
                kLetterDa                                                                = 0x3060,
                kLetterTi                                                                = 0x3061,
                kLetterDi                                                                = 0x3062,
                kLetterSmallTu                                                   = 0x3063,
                kLetterTu                                                                = 0x3064,
                kLetterDu                                                                = 0x3065,
                kLetterTe                                                                = 0x3066,
                kLetterDe                                                                = 0x3067,
                kLetterTo                                                                = 0x3068,
                kLetterDo                                                                = 0x3069,
                kLetterNa                                                                = 0x306A,
                kLetterNi                                                                = 0x306B,
                kLetterNu                                                                = 0x306C,
                kLetterNe                                                                = 0x306D,
                kLetterNo                                                                = 0x306E,
                kLetterHa                                                                = 0x306F,
                kLetterBa                                                                = 0x3070,
                kLetterPa                                                                = 0x3071,
                kLetterHi                                                                = 0x3072,
                kLetterBi                                                                = 0x3073,
                kLetterPi                                                                = 0x3074,
                kLetterHu                                                                = 0x3075,
                kLetterBu                                                                = 0x3076,
                kLetterPu                                                                = 0x3077,
                kLetterHe                                                                = 0x3078,
                kLetterBe                                                                = 0x3079,
                kLetterPe                                                                = 0x307A,
                kLetterHo                                                                = 0x307B,
                kLetterBo                                                                = 0x307C,
                kLetterPo                                                                = 0x307D,
                kLetterMa                                                                = 0x307E,
                kLetterMi                                                                = 0x307F,
                kLetterMu                                                                = 0x3080,
                kLetterMe                                                                = 0x3081,
                kLetterMo                                                                = 0x3082,
                kLetterSmallYa                                                   = 0x3083,
                kLetterYa                                                                = 0x3084,
                kLetterSmallYu                                                   = 0x3085,
                kLetterYu                                                                = 0x3086,
                kLetterSmallYo                                                   = 0x3087,
                kLetterYo                                                                = 0x3088,
                kLetterRa                                                                = 0x3089,
                kLetterRi                                                                = 0x308A,
                kLetterRu                                                                = 0x308B,
                kLetterRe                                                                = 0x308C,
                kLetterRo                                                                = 0x308D,
                kLetterSmallWa                                                   = 0x308E,
                kLetterWa                                                                = 0x308F,
                kLetterWi                                                                = 0x3090,
                kLetterWe                                                                = 0x3091,
                kLetterWo                                                                = 0x3092,
                kLetterN                                                                 = 0x3093,
                kLetterVu                                                                = 0x3094,
                kCombiningVoicedSoundMark                                = 0x3099,
                kCombiningSemiVoicedSoundMark                    = 0x309A,
                kVoicedSoundMark                                                 = 0x309B,
                kSemiVoicedSoundMark                                     = 0x309C,
                kIterationMark                                                   = 0x309D,
                kVoicedIterationMark                                     = 0x309E,
                kProlongedSoundMark                                              = 0x30FC
        };

private:

};







//=================================================================================
// class UKatakana
//=================================================================================

class UKatakana {

public:

        enum EKatakanaNames {

                kCombiningVoicedSoundMark                                = 0x3099,
                kCombiningSemiVoicedSoundMark                    = 0x309A,
                kVoicedSoundMark                                                 = 0x309B,
                kSemiVoicedSoundMark                                     = 0x309C,
                kLetterSmallA                                                    = 0x30A1,
                kLetterA                                                                 = 0x30A2,
                kLetterSmallI                                                    = 0x30A3,
                kLetterI                                                                 = 0x30A4,
                kLetterSmallU                                                    = 0x30A5,
                kLetterU                                                                 = 0x30A6,
                kLetterSmallE                                                    = 0x30A7,
                kLetterE                                                                 = 0x30A8,
                kLetterSmallO                                                    = 0x30A9,
                kLetterO                                                                 = 0x30AA,
                kLetterKa                                                                = 0x30AB,
                kLetterGa                                                                = 0x30AC,
                kLetterKi                                                                = 0x30AD,
                kLetterGi                                                                = 0x30AE,
                kLetterKu                                                                = 0x30AF,
                kLetterGu                                                                = 0x30B0,
                kLetterKe                                                                = 0x30B1,
                kLetterGe                                                                = 0x30B2,
                kLetterKo                                                                = 0x30B3,
                kLetterGo                                                                = 0x30B4,
                kLetterSa                                                                = 0x30B5,
                kLetterZa                                                                = 0x30B6,
                kLetterSi                                                                = 0x30B7,
                kLetterZi                                                                = 0x30B8,
                kLetterSu                                                                = 0x30B9,
                kLetterZu                                                                = 0x30BA,
                kLetterSe                                                                = 0x30BB,
                kLetterZe                                                                = 0x30BC,
                kLetterSo                                                                = 0x30BD,
                kLetterZo                                                                = 0x30BE,
                kLetterTa                                                                = 0x30BF,
                kLetterDa                                                                = 0x30C0,
                kLetterTi                                                                = 0x30C1,
                kLetterDi                                                                = 0x30C2,
                kLetterSmallTu                                                   = 0x30C3,
                kLetterTu                                                                = 0x30C4,
                kLetterDu                                                                = 0x30C5,
                kLetterTe                                                                = 0x30C6,
                kLetterDe                                                                = 0x30C7,
                kLetterTo                                                                = 0x30C8,
                kLetterDo                                                                = 0x30C9,
                kLetterNa                                                                = 0x30CA,
                kLetterNi                                                                = 0x30CB,
                kLetterNu                                                                = 0x30CC,
                kLetterNe                                                                = 0x30CD,
                kLetterNo                                                                = 0x30CE,
                kLetterHa                                                                = 0x30CF,
                kLetterBa                                                                = 0x30D0,
                kLetterPa                                                                = 0x30D1,
                kLetterHi                                                                = 0x30D2,
                kLetterBi                                                                = 0x30D3,
                kLetterPi                                                                = 0x30D4,
                kLetterHu                                                                = 0x30D5,
                kLetterBu                                                                = 0x30D6,
                kLetterPu                                                                = 0x30D7,
                kLetterHe                                                                = 0x30D8,
                kLetterBe                                                                = 0x30D9,
                kLetterPe                                                                = 0x30DA,
                kLetterHo                                                                = 0x30DB,
                kLetterBo                                                                = 0x30DC,
                kLetterPo                                                                = 0x30DD,
                kLetterMa                                                                = 0x30DE,
                kLetterMi                                                                = 0x30DF,
                kLetterMu                                                                = 0x30E0,
                kLetterMe                                                                = 0x30E1,
                kLetterMo                                                                = 0x30E2,
                kLetterSmallYa                                                   = 0x30E3,
                kLetterYa                                                                = 0x30E4,
                kLetterSmallYu                                                   = 0x30E5,
                kLetterYu                                                                = 0x30E6,
                kLetterSmallYo                                                   = 0x30E7,
                kLetterYo                                                                = 0x30E8,
                kLetterRa                                                                = 0x30E9,
                kLetterRi                                                                = 0x30EA,
                kLetterRu                                                                = 0x30EB,
                kLetterRe                                                                = 0x30EC,
                kLetterRo                                                                = 0x30ED,
                kLetterSmallWa                                                   = 0x30EE,
                kLetterWa                                                                = 0x30EF,
                kLetterWi                                                                = 0x30F0,
                kLetterWe                                                                = 0x30F1,
                kLetterWo                                                                = 0x30F2,
                kLetterN                                                                 = 0x30F3,
                kLetterVu                                                                = 0x30F4,
                kLetterSmallKa                                                   = 0x30F5,
                kLetterSmallKe                                                   = 0x30F6,
                kLetterVa                                                                = 0x30F7,
                kLetterVi                                                                = 0x30F8,
                kLetterVe                                                                = 0x30F9,
                kLetterVo                                                                = 0x30FA,
                kMiddleDot                                                               = 0x30FB,
                kProlongedSoundMark                                              = 0x30FC,
                kIterationMark                                                   = 0x30FD,
                kVoicedIterationMark                                     = 0x30FE,
                kCircledA                                                                = 0x32D0,
                kCircledI                                                                = 0x32D1,
                kCircledU                                                                = 0x32D2,
                kCircledE                                                                = 0x32D3,
                kCircledO                                                                = 0x32D4,
                kCircledKa                                                               = 0x32D5,
                kCircledKi                                                               = 0x32D6,
                kCircledKu                                                               = 0x32D7,
                kCircledKe                                                               = 0x32D8,
                kCircledKo                                                               = 0x32D9,
                kCircledSa                                                               = 0x32DA,
                kCircledSi                                                               = 0x32DB,
                kCircledSu                                                               = 0x32DC,
                kCircledSe                                                               = 0x32DD,
                kCircledSo                                                               = 0x32DE,
                kCircledTa                                                               = 0x32DF,
                kCircledTi                                                               = 0x32E0,
                kCircledTu                                                               = 0x32E1,
                kCircledTe                                                               = 0x32E2,
                kCircledTo                                                               = 0x32E3,
                kCircledNa                                                               = 0x32E4,
                kCircledNi                                                               = 0x32E5,
                kCircledNu                                                               = 0x32E6,
                kCircledNe                                                               = 0x32E7,
                kCircledNo                                                               = 0x32E8,
                kCircledHa                                                               = 0x32E9,
                kCircledHi                                                               = 0x32EA,
                kCircledHu                                                               = 0x32EB,
                kCircledHe                                                               = 0x32EC,
                kCircledHo                                                               = 0x32ED,
                kCircledMa                                                               = 0x32EE,
                kCircledMi                                                               = 0x32EF,
                kCircledMu                                                               = 0x32F0,
                kCircledMe                                                               = 0x32F1,
                kCircledMo                                                               = 0x32F2,
                kCircledYa                                                               = 0x32F3,
                kCircledYu                                                               = 0x32F4,
                kCircledYo                                                               = 0x32F5,
                kCircledRa                                                               = 0x32F6,
                kCircledRi                                                               = 0x32F7,
                kCircledRu                                                               = 0x32F8,
                kCircledRe                                                               = 0x32F9,
                kCircledRo                                                               = 0x32FA,
                kCircledWa                                                               = 0x32FB,
                kCircledWi                                                               = 0x32FC,
                kCircledWe                                                               = 0x32FD,
                kCircledWo                                                               = 0x32FE
        };

private:

};






//=================================================================================
// class UKatakanaHiragana
//=================================================================================

class UKatakanaHiragana {

public:

        enum EKatakanaHiraganaNames {

                kCombiningVoicedSoundMark                                = 0x3099,
                kCombiningSemiVoicedSoundMark                    = 0x309A,
                kVoicedSoundMark                                                 = 0x309B,
                kSemiVoicedSoundMark                                     = 0x309C,
                kProlongedSoundMark                                              = 0x30FC
        };

private:

};






//=================================================================================
// class UHangulChoseong
//=================================================================================
class UHangulChoseong {

public:

        enum EHangulChoseongNames {

                kKiyeok                                                          = 0x1100,
                kSsangkiyeok                                             = 0x1101,
                kNieun                                                           = 0x1102,
                kTikeut                                                          = 0x1103,
                kSsangtikeut                                             = 0x1104,
                kRieul                                                           = 0x1105,
                kMieum                                                           = 0x1106,
                kPieup                                                           = 0x1107,
                kSsangpieup                                                      = 0x1108,
                kSios                                                            = 0x1109,
                kSsangsios                                                       = 0x110A,
                kIeung                                                           = 0x110B,
                kCieuc                                                           = 0x110C,
                kSsangcieuc                                                      = 0x110D,
                kChieuch                                                         = 0x110E,
                kKhieukh                                                         = 0x110F,
                kThieuth                                                         = 0x1110,
                kPhieuph                                                         = 0x1111,
                kHieuh                                                           = 0x1112,
                kNieunKiyeok                                             = 0x1113,
                kSsangnieun                                                      = 0x1114,
                kNieunTikeut                                             = 0x1115,
                kNieunPieup                                                      = 0x1116,
                kTikeutKiyeok                                            = 0x1117,
                kRieulNieun                                                      = 0x1118,
                kSsangrieul                                                      = 0x1119,
                kRieulHieuh                                                      = 0x111A,
                kKapyeounrieul                                           = 0x111B,
                kMieumPieup                                                      = 0x111C,
                kKapyeounmieum                                           = 0x111D,
                kPieupKiyeok                                             = 0x111E,
                kPieupNieun                                                      = 0x111F,
                kPieupTikeut                                             = 0x1120,
                kPieupSios                                                       = 0x1121,
                kPieupSiosKiyeok                                         = 0x1122,
                kPieupSiosTikeut                                         = 0x1123,
                kPieupSiosPieup                                          = 0x1124,
                kPieupSsangsios                                          = 0x1125,
                kPieupSiosCieuc                                          = 0x1126,
                kPieupCieuc                                                      = 0x1127,
                kPieupChieuch                                            = 0x1128,
                kPieupThieuth                                            = 0x1129,
                kPieupPhieuph                                            = 0x112A,
                kKapyeounpieup                                           = 0x112B,
                kKapyeounssangpieup                                      = 0x112C,
                kSiosKiyeok                                                      = 0x112D,
                kSiosNieun                                                       = 0x112E,
                kSiosTikeut                                                      = 0x112F,
                kSiosRieul                                                       = 0x1130,
                kSiosMieum                                                       = 0x1131,
                kSiosPieup                                                       = 0x1132,
                kSiosPieupKiyeok                                         = 0x1133,
                kSiosSsangsios                                           = 0x1134,
                kSiosIeung                                                       = 0x1135,
                kSiosCieuc                                                       = 0x1136,
                kSiosChieuch                                             = 0x1137,
                kSiosKhieukh                                             = 0x1138,
                kSiosThieuth                                             = 0x1139,
                kSiosPhieuph                                             = 0x113A,
                kSiosHieuh                                                       = 0x113B,
                kChitueumsios                                            = 0x113C,
                kChitueumssangsios                                       = 0x113D,
                kCeongchieumsios                                         = 0x113E,
                kCeongchieumssangsios                            = 0x113F,
                kPansios                                                         = 0x1140,
                kIeungKiyeok                                             = 0x1141,
                kIeungTikeut                                             = 0x1142,
                kIeungMieum                                                      = 0x1143,
                kIeungPieup                                                      = 0x1144,
                kIeungSios                                                       = 0x1145,
                kIeungPansios                                            = 0x1146,
                kSsangieung                                                      = 0x1147,
                kIeungCieuc                                                      = 0x1148,
                kIeungChieuch                                            = 0x1149,
                kIeungThieuth                                            = 0x114A,
                kIeungPhieuph                                            = 0x114B,
                kYesieung                                                        = 0x114C,
                kCieucIeung                                                      = 0x114D,
                kChitueumcieuc                                           = 0x114E,
                kChitueumssangcieuc                                      = 0x114F,
                kCeongchieumcieuc                                        = 0x1150,
                kCeongchieumssangcieuc                           = 0x1151,
                kChieuchKhieukh                                          = 0x1152,
                kChieuchHieuh                                            = 0x1153,
                kChitueumchieuch                                         = 0x1154,
                kCeongchieumchieuch                                      = 0x1155,
                kPhieuphPieup                                            = 0x1156,
                kKapyeounphieuph                                         = 0x1157,
                kSsanghieuh                                                      = 0x1158,
                kYeorinhieuh                                             = 0x1159,
                kFiller                                                          = 0x115F
        };

private:

};







//=================================================================================
// class UHangulJungseong
//=================================================================================

class UHangulJungseong {

public:

        enum EHangulJungseongNames {

                kFiller                                                  = 0x1160,
                kA                                                               = 0x1161,
                kAe                                                              = 0x1162,
                kYa                                                              = 0x1163,
                kYae                                                             = 0x1164,
                kEo                                                              = 0x1165,
                kE                                                               = 0x1166,
                kYeo                                                             = 0x1167,
                kYe                                                              = 0x1168,
                kO                                                               = 0x1169,
                kWa                                                              = 0x116A,
                kWae                                                             = 0x116B,
                kOe                                                              = 0x116C,
                kYo                                                              = 0x116D,
                kU                                                               = 0x116E,
                kWeo                                                             = 0x116F,
                kWe                                                              = 0x1170,
                kWi                                                              = 0x1171,
                kYu                                                              = 0x1172,
                kEu                                                              = 0x1173,
                kYi                                                              = 0x1174,
                kI                                                               = 0x1175,
                kAO                                                              = 0x1176,
                kAU                                                              = 0x1177,
                kYaO                                                             = 0x1178,
                kYaYo                                                            = 0x1179,
                kEoO                                                             = 0x117A,
                kEoU                                                             = 0x117B,
                kEoEu                                                            = 0x117C,
                kYeoO                                                            = 0x117D,
                kYeoU                                                            = 0x117E,
                kOEo                                                             = 0x117F,
                kOE                                                              = 0x1180,
                kOYe                                                             = 0x1181,
                kOO                                                              = 0x1182,
                kOU                                                              = 0x1183,
                kYoYa                                                            = 0x1184,
                kYoYae                                                   = 0x1185,
                kYoYeo                                                   = 0x1186,
                kYoO                                                             = 0x1187,
                kYoI                                                             = 0x1188,
                kUA                                                              = 0x1189,
                kUAe                                                             = 0x118A,
                kUEoEu                                                   = 0x118B,
                kUYe                                                             = 0x118C,
                kUU                                                              = 0x118D,
                kYuA                                                             = 0x118E,
                kYuEo                                                            = 0x118F,
                kYuE                                                             = 0x1190,
                kYuYeo                                                   = 0x1191,
                kYuYe                                                            = 0x1192,
                kYuU                                                             = 0x1193,
                kYuI                                                             = 0x1194,
                kEuU                                                             = 0x1195,
                kEuEu                                                            = 0x1196,
                kYiU                                                             = 0x1197,
                kIA                                                              = 0x1198,
                kIYa                                                             = 0x1199,
                kIO                                                              = 0x119A,
                kIU                                                              = 0x119B,
                kIEu                                                             = 0x119C,
                kIAraea                                                  = 0x119D,
                kAraea                                                   = 0x119E,
                kAraeaEo                                                         = 0x119F,
                kAraeaU                                                  = 0x11A0,
                kAraeaI                                                  = 0x11A1,
                kSsangaraea                                              = 0x11A2
        };

private:

};







//=================================================================================
// class UBopomofo
//=================================================================================

class UBopomofo {

public:

        enum EBopomofoNames {

                kLetterB                                                                 = 0x3105,
                kLetterP                                                                 = 0x3106,
                kLetterM                                                                 = 0x3107,
                kLetterF                                                                 = 0x3108,
                kLetterD                                                                 = 0x3109,
                kLetterT                                                                 = 0x310A,
                kLetterN                                                                 = 0x310B,
                kLetterL                                                                 = 0x310C,
                kLetterG                                                                 = 0x310D,
                kLetterK                                                                 = 0x310E,
                kLetterH                                                                 = 0x310F,
                kLetterJ                                                                 = 0x3110,
                kLetterQ                                                                 = 0x3111,
                kLetterX                                                                 = 0x3112,
                kLetterZh                                                                = 0x3113,
                kLetterCh                                                                = 0x3114,
                kLetterSh                                                                = 0x3115,
                kLetterR                                                                 = 0x3116,
                kLetterZ                                                                 = 0x3117,
                kLetterC                                                                 = 0x3118,
                kLetterS                                                                 = 0x3119,
                kLetterA                                                                 = 0x311A,
                kLetterO                                                                 = 0x311B,
                kLetterE                                                                 = 0x311C,
                kLetterEh                                                                = 0x311D,
                kLetterAi                                                                = 0x311E,
                kLetterEi                                                                = 0x311F,
                kLetterAu                                                                = 0x3120,
                kLetterOu                                                                = 0x3121,
                kLetterAn                                                                = 0x3122,
                kLetterEn                                                                = 0x3123,
                kLetterAng                                                               = 0x3124,
                kLetterEng                                                               = 0x3125,
                kLetterEr                                                                = 0x3126,
                kLetterI                                                                 = 0x3127,
                kLetterU                                                                 = 0x3128,
                kLetterIu                                                                = 0x3129,
                kLetterV                                                                 = 0x312A,
                kLetterNg                                                                = 0x312B,
                kLetterGn                                                                = 0x312C
        };

private:

};







//=================================================================================
// class UHangulLetter
//=================================================================================

class UHangulLetter {

public:

        enum EHangulLetterNames {

                kKiyeok                                                                  = 0x3131,
                kSsangkiyeok                                                     = 0x3132,
                kKiyeokSios                                                              = 0x3133,
                kNieun                                                                   = 0x3134,
                kNieunCieuc                                                              = 0x3135,
                kNieunHieuh                                                              = 0x3136,
                kTikeut                                                                  = 0x3137,
                kSsangtikeut                                                     = 0x3138,
                kRieul                                                                   = 0x3139,
                kRieulKiyeok                                                     = 0x313A,
                kRieulMieum                                                              = 0x313B,
                kRieulPieup                                                              = 0x313C,
                kRieulSios                                                               = 0x313D,
                kRieulThieuth                                                    = 0x313E,
                kRieulPhieuph                                                    = 0x313F,
                kRieulHieuh                                                              = 0x3140,
                kMieum                                                                   = 0x3141,
                kPieup                                                                   = 0x3142,
                kSsangpieup                                                              = 0x3143,
                kPieupSios                                                               = 0x3144,
                kSios                                                                    = 0x3145,
                kSsangsios                                                               = 0x3146,
                kIeung                                                                   = 0x3147,
                kCieuc                                                                   = 0x3148,
                kSsangcieuc                                                              = 0x3149,
                kChieuch                                                                 = 0x314A,
                kKhieukh                                                                 = 0x314B,
                kThieuth                                                                 = 0x314C,
                kPhieuph                                                                 = 0x314D,
                kHieuh                                                                   = 0x314E,
                kA                                                                               = 0x314F,
                kAe                                                                              = 0x3150,
                kYa                                                                              = 0x3151,
                kYae                                                                     = 0x3152,
                kEo                                                                              = 0x3153,
                kE                                                                               = 0x3154,
                kYeo                                                                     = 0x3155,
                kYe                                                                              = 0x3156,
                kO                                                                               = 0x3157,
                kWa                                                                              = 0x3158,
                kWae                                                                     = 0x3159,
                kOe                                                                              = 0x315A,
                kYo                                                                              = 0x315B,
                kU                                                                               = 0x315C,
                kWeo                                                                     = 0x315D,
                kWe                                                                              = 0x315E,
                kWi                                                                              = 0x315F,
                kYu                                                                              = 0x3160,
                kEu                                                                              = 0x3161,
                kYi                                                                              = 0x3162,
                kI                                                                               = 0x3163,
                kHangulFiller                                                    = 0x3164,
                kSsangnieun                                                              = 0x3165,
                kNieunTikeut                                                     = 0x3166,
                kNieunSios                                                               = 0x3167,
                kNieunPansios                                                    = 0x3168,
                kRieulKiyeokSios                                                 = 0x3169,
                kRieulTikeut                                                     = 0x316A,
                kRieulPieupSios                                                  = 0x316B,
                kRieulPansios                                                    = 0x316C,
                kRieulYeorinhieuh                                                = 0x316D,
                kMieumPieup                                                              = 0x316E,
                kMieumSios                                                               = 0x316F,
                kMieumPansios                                                    = 0x3170,
                kKapyeounmieum                                                   = 0x3171,
                kPieupKiyeok                                                     = 0x3172,
                kPieupTikeut                                                     = 0x3173,
                kPieupSiosKiyeok                                                 = 0x3174,
                kPieupSiosTikeut                                                 = 0x3175,
                kPieupCieuc                                                              = 0x3176,
                kPieupThieuth                                                    = 0x3177,
                kKapyeounpieup                                                   = 0x3178,
                kKapyeounssangpieup                                              = 0x3179,
                kSiosKiyeok                                                              = 0x317A,
                kSiosNieun                                                               = 0x317B,
                kSiosTikeut                                                              = 0x317C,
                kSiosPieup                                                               = 0x317D,
                kSiosCieuc                                                               = 0x317E,
                kPansios                                                                 = 0x317F,
                kSsangieung                                                              = 0x3180,
                kYesieung                                                                = 0x3181,
                kYesieungSios                                                    = 0x3182,
                kYesieungPansios                                                 = 0x3183,
                kKapyeounphieuph                                                 = 0x3184,
                kSsanghieuh                                                              = 0x3185,
                kYeorinhieuh                                                     = 0x3186,
                kYoYa                                                                    = 0x3187,
                kYoYae                                                                   = 0x3188,
                kYoI                                                                     = 0x3189,
                kYuYeo                                                                   = 0x318A,
                kYuYe                                                                    = 0x318B,
                kYuI                                                                     = 0x318C,
                kAraea                                                                   = 0x318D,
                kAraeae                                                                  = 0x318E
        };

private:

};







//=================================================================================
// class UHangulJongseong
//=================================================================================
class UHangulJongseong {

public:

        enum EHangulJongseongNames {

                kKiyeok                                                                  = 0x11A8,
                kSsangkiyeok                                                     = 0x11A9,
                kKiyeokSios                                                              = 0x11AA,
                kNieun                                                                   = 0x11AB,
                kNieunCieuc                                                              = 0x11AC,
                kNieunHieuh                                                              = 0x11AD,
                kTikeut                                                                  = 0x11AE,
                kRieul                                                                   = 0x11AF,
                kRieulKiyeok                                                     = 0x11B0,
                kRieulMieum                                                              = 0x11B1,
                kRieulPieup                                                              = 0x11B2,
                kRieulSios                                                               = 0x11B3,
                kRieulThieuth                                                    = 0x11B4,
                kRieulPhieuph                                                    = 0x11B5,
                kRieulHieuh                                                              = 0x11B6,
                kMieum                                                                   = 0x11B7,
                kPieup                                                                   = 0x11B8,
                kPieupSios                                                               = 0x11B9,
                kSios                                                                    = 0x11BA,
                kSsangsios                                                               = 0x11BB,
                kIeung                                                                   = 0x11BC,
                kCieuc                                                                   = 0x11BD,
                kChieuch                                                                 = 0x11BE,
                kKhieukh                                                                 = 0x11BF,
                kThieuth                                                                 = 0x11C0,
                kPhieuph                                                                 = 0x11C1,
                kHieuh                                                                   = 0x11C2,
                kKiyeokRieul                                                     = 0x11C3,
                kKiyeokSiosKiyeok                                                = 0x11C4,
                kNieunKiyeok                                                     = 0x11C5,
                kNieunTikeut                                                     = 0x11C6,
                kNieunSios                                                               = 0x11C7,
                kNieunPansios                                                    = 0x11C8,
                kNieunThieuth                                                    = 0x11C9,
                kTikeutKiyeok                                                    = 0x11CA,
                kTikeutRieul                                                     = 0x11CB,
                kRieulKiyeokSios                                                 = 0x11CC,
                kRieulNieun                                                              = 0x11CD,
                kRieulTikeut                                                     = 0x11CE,
                kRieulTikeutHieuh                                                = 0x11CF,
                kSsangrieul                                                              = 0x11D0,
                kRieulMieumKiyeok                                                = 0x11D1,
                kRieulMieumSios                                                  = 0x11D2,
                kRieulPieupSios                                                  = 0x11D3,
                kRieulPieupHieuh                                                 = 0x11D4,
                kRieulKapyeounpieup                                              = 0x11D5,
                kRieulSsangsios                                                  = 0x11D6,
                kRieulPansios                                                    = 0x11D7,
                kRieulKhieukh                                                    = 0x11D8,
                kRieulYeorinhieuh                                                = 0x11D9,
                kMieumKiyeok                                                     = 0x11DA,
                kMieumRieul                                                              = 0x11DB,
                kMieumPieup                                                              = 0x11DC,
                kMieumSios                                                               = 0x11DD,
                kMieumSsangsios                                                  = 0x11DE,
                kMieumPansios                                                    = 0x11DF,
                kMieumChieuch                                                    = 0x11E0,
                kMieumHieuh                                                              = 0x11E1,
                kKapyeounmieum                                                   = 0x11E2,
                kPieupRieul                                                              = 0x11E3,
                kPieupPhieuph                                                    = 0x11E4,
                kPieupHieuh                                                              = 0x11E5,
                kKapyeounpieup                                                   = 0x11E6,
                kSiosKiyeok                                                              = 0x11E7,
                kSiosTikeut                                                              = 0x11E8,
                kSiosRieul                                                               = 0x11E9,
                kSiosPieup                                                               = 0x11EA,
                kPansios                                                                 = 0x11EB,
                kIeungKiyeok                                                     = 0x11EC,
                kIeungSsangkiyeok                                                = 0x11ED,
                kSsangieung                                                              = 0x11EE,
                kIeungKhieukh                                                    = 0x11EF,
                kYesieung                                                                = 0x11F0,
                kYesieungSios                                                    = 0x11F1,
                kYesieungPansios                                                 = 0x11F2,
                kPhieuphPieup                                                    = 0x11F3,
                kKapyeounphieuph                                                 = 0x11F4,
                kHieuhNieun                                                              = 0x11F5,
                kHieuhRieul                                                              = 0x11F6,
                kHieuhMieum                                                              = 0x11F7,
                kHieuhPieup                                                              = 0x11F8,
                kYeorinhieuh                                                     = 0x11F9
        };

private:

};







//=================================================================================
// class UHangzhouNumeral
//=================================================================================

class UHangzhouNumeral {

public:

        enum EHangzhouNumeralNames {

                kOne                                                                     = 0x3021,
                kTwo                                                                     = 0x3022,
                kThree                                                                   = 0x3023,
                kFour                                                                    = 0x3024,
                kFive                                                                    = 0x3025,
                kSix                                                                     = 0x3026,
                kSeven                                                                   = 0x3027,
                kEight                                                                   = 0x3028,
                kNine                                                                    = 0x3029
        };

private:

};







//=================================================================================
// class UIdeographicAnnotation
//=================================================================================

class UIdeographicAnnotation {

public:

        enum EIdeographicAnnotationNames {

                kLinkingMark                                                     = 0x3190,
                kReverseMark                                                     = 0x3191,
                kOneMark                                                                 = 0x3192,
                kTwoMark                                                                 = 0x3193,
                kThreeMark                                                               = 0x3194,
                kFourMark                                                                = 0x3195,
                kTopMark                                                                 = 0x3196,
                kMiddleMark                                                              = 0x3197,
                kBottomMark                                                              = 0x3198,
                kFirstMark                                                               = 0x3199,
                kSecondMark                                                              = 0x319A,
                kThirdMark                                                               = 0x319B,
                kFourthMark                                                              = 0x319C,
                kHeavenMark                                                              = 0x319D,
                kEarthMark                                                               = 0x319E,
                kManMark                                                                 = 0x319F,

                //      Values derived from Unicode 1.0 names

                kKanbunTateten                                                   = kLinkingMark,
                kKaeritenRe                                                      = kReverseMark,
                kKaeritenIti                                                     = kOneMark,
                kKaeritenNi                                                      = kTwoMark,
                kKaeritenSan                                                     = kThreeMark,
                kKaeritenSi                                                      = kFourMark,
                kKaeritenZyou                                                    = kTopMark,
                kKaeritenTyuu                                                    = kMiddleMark,
                kKaeritenGe                                                      = kBottomMark,
                kKaeritenKou                                                     = kFirstMark,
                kKaeritenOtu                                                     = kSecondMark,
                kKaeritenHei                                                     = kThirdMark,
                kKaeritenTei                                                     = kFourthMark,
                kKaeritenTen                                                     = kHeavenMark,
                kKaeritenTi                                                      = kEarthMark,
                kKaeritenZin                                                     = kManMark
        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUEASIA_

