// Revision: 99 1.12.1.4 source/core/text/unicode/iucmpbty.hpp, text, ioc.v400, 980918 
// iucmpbty.hpp
/**
 * This file contains the classes UHangulSyllable, UHalfwidthHangulLetter,
 * UArabicLigature, USuperscript, USubscript, UVulgarFraction, URomanNumeral,
 * UIdeographicTelegrpah, UCircledDigit, UCircledNumber, UParenthesizedDigit,
 * UParenthesizedNumber, UFullStopDigit, UFullStopNumber, UParnthesizedLatin,
 * UCircledLatin, UBoxDrawings, UParenthesizedHangul, UParenthesizedIdeograph,
 * UCircledHangul, UCircledIdeograph, UcircledKatakana, UCJKSquredWords,
 * UCJKsquaredAbbreviations, ULatinSmallLigature, UArmenianSmallLigature,
 * UFullwidth, UHalfwidth, UPresentationFormForVertical, USmallVariants,
 * UCJKCompatibility, UCNSCompatibility, UBlocks which provide information
 * about the compatibility characters.  The characters are provided for
 * compatibility with other standards.
 *
 * @package     Text and International
 * @category    International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */



#ifndef _IUCMPBTY_
#define _IUCMPBTY_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class UHangulSyllable;
class UHalfwidthHangulLetter;
class UArabicLigature;
class USuperscript;
class USubscript;
class UVulgarFraction;
class URomanNumeral;
class UIdeographicTelegraph;
class UCircledDigit;
class UCircledNumber;
class UParenthesizedDigit;
class UParenthesizedNumber;
class UFullStopDigit;
class UFullStopNumber;
class UParenthesizedLatin;
class UCircledLatin;
class UBoxDrawings;
class UParenthesizedHangul;
class UParenthesizedIdeograph;
class UCircledHangul;
class UCircledIdeograph;
class UCircledKatakana;
class UCJKSquaredWords;
class UCJKSquaredAbbreviations;
class ULatinSmallLigature;
class UArmenianSmallLigature;
class UFullwidth;
class UHalfwidth;
class UPresentationFormForVertical;
class USmallVariants;
class UCJKCompatibility;
class UCNSCompatibility;
class UBlocks;

#pragma enum(4)
#pragma pack(push,4)

//=================================================================================
// class UHangulSyllable
//=================================================================================
class UHangulSyllable {

public:

        enum EHangulSyllableNames {

        kKiyeokA                                                        = 0xac00,
        kKiyeokAKiyeok                                          = 0xac01,
        kKiyeokASsangkiyeok                                     = 0xac02,
        kKiyeokAKiyeoksios                                      = 0xac03,
        kKiyeokANieun                                           = 0xac04,
        kKiyeokANieuncieuc                                      = 0xac05,
        kKiyeokANieunhieuh                                      = 0xac06,
        kKiyeokATikeut                                          = 0xac07,
        kKiyeokARieul                                           = 0xac08,
        kKiyeokARieulkiyeok                                     = 0xac09,
        kKiyeokARieulmieum                                      = 0xac0a,
        kKiyeokARieulpieup                                      = 0xac0b,
        kKiyeokARieulsios                                       = 0xac0c,
        kKiyeokARieulthieuth                            = 0xac0d,
        kKiyeokARieulphieuph                            = 0xac0e,
        kKiyeokARieulhieuh                                      = 0xac0f,
        kKiyeokAMieum                                           = 0xac10,
        kKiyeokAPieup                                           = 0xac11,
        kKiyeokAPieupsios                                       = 0xac12,
        kKiyeokASios                        = 0xac13,
        kKiyeokASsangsios                   = 0xac14,
        kKiyeokAIeung                       = 0xac15,
        kKiyeokACieuc                       = 0xac16,
        kKiyeokAChieuch                     = 0xac17,
        kKiyeokAKhieukh                     = 0xac18,
        kKiyeokAThieuth                     = 0xac19,
        kKiyeokAPhieuph                     = 0xac1a,
        kKiyeokAHieuh                       = 0xac1b,
        kKiyeokAe                           = 0xac1c,
        kKiyeokAeKiyeok                     = 0xac1d,
        kKiyeokAeSsangkiyeok                = 0xac1e,
        kKiyeokAeKiyeoksios                 = 0xac1f,
        kKiyeokAeNieun                      = 0xac20,
        kKiyeokAeNieuncieuc                 = 0xac21,
        kKiyeokAeNieunhieuh                 = 0xac22,
        kKiyeokAeTikeut                     = 0xac23,
        kKiyeokAeRieul                      = 0xac24,
        kKiyeokAeRieulkiyeok                = 0xac25,
        kKiyeokAeRieulmieum                 = 0xac26,
        kKiyeokAeRieulpieup                 = 0xac27,
        kKiyeokAeRieulsios                  = 0xac28,
        kKiyeokAeRieulthieuth               = 0xac29,
        kKiyeokAeRieulphieuph               = 0xac2a,
        kKiyeokAeRieulhieuh                 = 0xac2b,
        kKiyeokAeMieum                      = 0xac2c,
        kKiyeokAePieup                      = 0xac2d,
        kKiyeokAePieupsios                  = 0xac2e,
        kKiyeokAeSios                       = 0xac2f,
        kKiyeokAeSsangsios                  = 0xac30,
        kKiyeokAeIeung                      = 0xac31,
        kKiyeokAeCieuc                      = 0xac32,
        kKiyeokAeChieuch                    = 0xac33,
        kKiyeokAeKhieukh                    = 0xac34,
        kKiyeokAeThieuth                    = 0xac35,
        kKiyeokAePhieuph                    = 0xac36,
        kKiyeokAeHieuh                      = 0xac37,
        kKiyeokYa                           = 0xac38,
        kKiyeokYaKiyeok                     = 0xac39,
        kKiyeokYaSsangkiyeok                = 0xac3a,
        kKiyeokYaKiyeoksios                 = 0xac3b,
        kKiyeokYaNieun                      = 0xac3c,
        kKiyeokYaNieuncieuc                 = 0xac3d,
        kKiyeokYaNieunhieuh                 = 0xac3e,
        kKiyeokYaTikeut                     = 0xac3f,
        kKiyeokYaRieul                      = 0xac40,
        kKiyeokYaRieulkiyeok                = 0xac41,
        kKiyeokYaRieulmieum                 = 0xac42,
        kKiyeokYaRieulpieup                 = 0xac43,
        kKiyeokYaRieulsios                  = 0xac44,
        kKiyeokYaRieulthieuth               = 0xac45,
        kKiyeokYaRieulphieuph               = 0xac46,
        kKiyeokYaRieulhieuh                 = 0xac47,
        kKiyeokYaMieum                      = 0xac48,
        kKiyeokYaPieup                      = 0xac49,
        kKiyeokYaPieupsios                  = 0xac4a,
        kKiyeokYaSios                       = 0xac4b,
        kKiyeokYaSsangsios                  = 0xac4c,
        kKiyeokYaIeung                      = 0xac4d,
        kKiyeokYaCieuc                      = 0xac4e,
        kKiyeokYaChieuch                    = 0xac4f,
        kKiyeokYaKhieukh                    = 0xac50,
        kKiyeokYaThieuth                    = 0xac51,
        kKiyeokYaPhieuph                    = 0xac52,
        kKiyeokYaHieuh                      = 0xac53,
        kKiyeokYae                          = 0xac54,
        kKiyeokYaeKiyeok                    = 0xac55,
        kKiyeokYaeSsangkiyeok               = 0xac56,
        kKiyeokYaeKiyeoksios                = 0xac57,
        kKiyeokYaeNieun                     = 0xac58,
        kKiyeokYaeNieuncieuc                = 0xac59,
        kKiyeokYaeNieunhieuh                = 0xac5a,
        kKiyeokYaeTikeut                    = 0xac5b,
        kKiyeokYaeRieul                     = 0xac5c,
        kKiyeokYaeRieulkiyeok               = 0xac5d,
        kKiyeokYaeRieulmieum                = 0xac5e,
        kKiyeokYaeRieulpieup                = 0xac5f,
        kKiyeokYaeRieulsios                 = 0xac60,
        kKiyeokYaeRieulthieuth              = 0xac61,
        kKiyeokYaeRieulphieuph              = 0xac62,
        kKiyeokYaeRieulhieuh                = 0xac63,
        kKiyeokYaeMieum                     = 0xac64,
        kKiyeokYaePieup                     = 0xac65,
        kKiyeokYaePieupsios                 = 0xac66,
        kKiyeokYaeSios                      = 0xac67,
        kKiyeokYaeSsangsios                 = 0xac68,
        kKiyeokYaeIeung                     = 0xac69,
        kKiyeokYaeCieuc                     = 0xac6a,
        kKiyeokYaeChieuch                   = 0xac6b,
        kKiyeokYaeKhieukh                   = 0xac6c,
        kKiyeokYaeThieuth                   = 0xac6d,
        kKiyeokYaePhieuph                   = 0xac6e,
        kKiyeokYaeHieuh                     = 0xac6f,
        kKiyeokEo                           = 0xac70,
        kKiyeokEoKiyeok                     = 0xac71,
        kKiyeokEoSsangkiyeok                = 0xac72,
        kKiyeokEoKiyeoksios                 = 0xac73,
        kKiyeokEoNieun                      = 0xac74,
        kKiyeokEoNieuncieuc                 = 0xac75,
        kKiyeokEoNieunhieuh                 = 0xac76,
        kKiyeokEoTikeut                     = 0xac77,
        kKiyeokEoRieul                      = 0xac78,
        kKiyeokEoRieulkiyeok                = 0xac79,
        kKiyeokEoRieulmieum                 = 0xac7a,
        kKiyeokEoRieulpieup                 = 0xac7b,
        kKiyeokEoRieulsios                  = 0xac7c,
        kKiyeokEoRieulthieuth               = 0xac7d,
        kKiyeokEoRieulphieuph               = 0xac7e,
        kKiyeokEoRieulhieuh                 = 0xac7f,
        kKiyeokEoMieum                      = 0xac80,
        kKiyeokEoPieup                      = 0xac81,
        kKiyeokEoPieupsios                  = 0xac82,
        kKiyeokEoSios                       = 0xac83,
        kKiyeokEoSsangsios                  = 0xac84,
        kKiyeokEoIeung                      = 0xac85,
        kKiyeokEoCieuc                      = 0xac86,
        kKiyeokEoChieuch                    = 0xac87,
        kKiyeokEoKhieukh                    = 0xac88,
        kKiyeokEoThieuth                    = 0xac89,
        kKiyeokEoPhieuph                    = 0xac8a,
        kKiyeokEoHieuh                      = 0xac8b,
        kKiyeokE                            = 0xac8c,
        kKiyeokEKiyeok                      = 0xac8d,
        kKiyeokESsangkiyeok                 = 0xac8e,
        kKiyeokEKiyeoksios                  = 0xac8f,
        kKiyeokENieun                       = 0xac90,
        kKiyeokENieuncieuc                  = 0xac91,
        kKiyeokENieunhieuh                  = 0xac92,
        kKiyeokETikeut                      = 0xac93,
        kKiyeokERieul                       = 0xac94,
        kKiyeokERieulkiyeok                 = 0xac95,
        kKiyeokERieulmieum                  = 0xac96,
        kKiyeokERieulpieup                  = 0xac97,
        kKiyeokERieulsios                   = 0xac98,
        kKiyeokERieulthieuth                = 0xac99,
        kKiyeokERieulphieuph                = 0xac9a,
        kKiyeokERieulhieuh                  = 0xac9b,
        kKiyeokEMieum                       = 0xac9c,
        kKiyeokEPieup                       = 0xac9d,
        kKiyeokEPieupsios                   = 0xac9e,
        kKiyeokESios                        = 0xac9f,
        kKiyeokESsangsios                   = 0xaca0,
        kKiyeokEIeung                       = 0xaca1,
        kKiyeokECieuc                       = 0xaca2,
        kKiyeokEChieuch                     = 0xaca3,
        kKiyeokEKhieukh                     = 0xaca4,
        kKiyeokEThieuth                     = 0xaca5,
        kKiyeokEPhieuph                     = 0xaca6,
        kKiyeokEHieuh                       = 0xaca7,
        kKiyeokYeo                          = 0xaca8,
        kKiyeokYeoKiyeok                    = 0xaca9,
        kKiyeokYeoSsangkiyeok               = 0xacaa,
        kKiyeokYeoKiyeoksios                = 0xacab,
        kKiyeokYeoNieun                     = 0xacac,
        kKiyeokYeoNieuncieuc                = 0xacad,
        kKiyeokYeoNieunhieuh                = 0xacae,
        kKiyeokYeoTikeut                    = 0xacaf,
        kKiyeokYeoRieul                     = 0xacb0,
        kKiyeokYeoRieulkiyeok               = 0xacb1,
        kKiyeokYeoRieulmieum                = 0xacb2,
        kKiyeokYeoRieulpieup                = 0xacb3,
        kKiyeokYeoRieulsios                 = 0xacb4,
        kKiyeokYeoRieulthieuth              = 0xacb5,
        kKiyeokYeoRieulphieuph              = 0xacb6,
        kKiyeokYeoRieulhieuh                = 0xacb7,
        kKiyeokYeoMieum                     = 0xacb8,
        kKiyeokYeoPieup                     = 0xacb9,
        kKiyeokYeoPieupsios                 = 0xacba,
        kKiyeokYeoSios                      = 0xacbb,
        kKiyeokYeoSsangsios                 = 0xacbc,
        kKiyeokYeoIeung                     = 0xacbd,
        kKiyeokYeoCieuc                     = 0xacbe,
        kKiyeokYeoChieuch                   = 0xacbf,
        kKiyeokYeoKhieukh                   = 0xacc0,
        kKiyeokYeoThieuth                   = 0xacc1,
        kKiyeokYeoPhieuph                   = 0xacc2,
        kKiyeokYeoHieuh                     = 0xacc3,
        kKiyeokYe                           = 0xacc4,
        kKiyeokYeKiyeok                     = 0xacc5,
        kKiyeokYeSsangkiyeok                = 0xacc6,
        kKiyeokYeKiyeoksios                 = 0xacc7,
        kKiyeokYeNieun                      = 0xacc8,
        kKiyeokYeNieuncieuc                 = 0xacc9,
        kKiyeokYeNieunhieuh                 = 0xacca,
        kKiyeokYeTikeut                     = 0xaccb,
        kKiyeokYeRieul                      = 0xaccc,
        kKiyeokYeRieulkiyeok                = 0xaccd,
        kKiyeokYeRieulmieum                 = 0xacce,
        kKiyeokYeRieulpieup                 = 0xaccf,
        kKiyeokYeRieulsios                  = 0xacd0,
        kKiyeokYeRieulthieuth               = 0xacd1,
        kKiyeokYeRieulphieuph               = 0xacd2,
        kKiyeokYeRieulhieuh                 = 0xacd3,
        kKiyeokYeMieum                      = 0xacd4,
        kKiyeokYePieup                      = 0xacd5,
        kKiyeokYePieupsios                  = 0xacd6,
        kKiyeokYeSios                       = 0xacd7,
        kKiyeokYeSsangsios                  = 0xacd8,
        kKiyeokYeIeung                      = 0xacd9,
        kKiyeokYeCieuc                      = 0xacda,
        kKiyeokYeChieuch                    = 0xacdb,
        kKiyeokYeKhieukh                    = 0xacdc,
        kKiyeokYeThieuth                    = 0xacdd,
        kKiyeokYePhieuph                    = 0xacde,
        kKiyeokYeHieuh                      = 0xacdf,
        kKiyeokO                            = 0xace0,
        kKiyeokOKiyeok                      = 0xace1,
        kKiyeokOSsangkiyeok                 = 0xace2,
        kKiyeokOKiyeoksios                  = 0xace3,
        kKiyeokONieun                       = 0xace4,
        kKiyeokONieuncieuc                  = 0xace5,
        kKiyeokONieunhieuh                  = 0xace6,
        kKiyeokOTikeut                      = 0xace7,
        kKiyeokORieul                       = 0xace8,
        kKiyeokORieulkiyeok                 = 0xace9,
        kKiyeokORieulmieum                  = 0xacea,
        kKiyeokORieulpieup                  = 0xaceb,
        kKiyeokORieulsios                   = 0xacec,
        kKiyeokORieulthieuth                = 0xaced,
        kKiyeokORieulphieuph                = 0xacee,
        kKiyeokORieulhieuh                  = 0xacef,
        kKiyeokOMieum                       = 0xacf0,
        kKiyeokOPieup                       = 0xacf1,
        kKiyeokOPieupsios                   = 0xacf2,
        kKiyeokOSios                        = 0xacf3,
        kKiyeokOSsangsios                   = 0xacf4,
        kKiyeokOIeung                       = 0xacf5,
        kKiyeokOCieuc                       = 0xacf6,
        kKiyeokOChieuch                     = 0xacf7,
        kKiyeokOKhieukh                     = 0xacf8,
        kKiyeokOThieuth                     = 0xacf9,
        kKiyeokOPhieuph                     = 0xacfa,
        kKiyeokOHieuh                       = 0xacfb,
        kKiyeokWa                           = 0xacfc,
        kKiyeokWaKiyeok                     = 0xacfd,
        kKiyeokWaSsangkiyeok                = 0xacfe,
        kKiyeokWaKiyeoksios                 = 0xacff,
        kKiyeokWaNieun                      = 0xad00,
        kKiyeokWaNieuncieuc                 = 0xad01,
        kKiyeokWaNieunhieuh                 = 0xad02,
        kKiyeokWaTikeut                     = 0xad03,
        kKiyeokWaRieul                      = 0xad04,
        kKiyeokWaRieulkiyeok                = 0xad05,
        kKiyeokWaRieulmieum                 = 0xad06,
        kKiyeokWaRieulpieup                 = 0xad07,
        kKiyeokWaRieulsios                  = 0xad08,
        kKiyeokWaRieulthieuth               = 0xad09,
        kKiyeokWaRieulphieuph               = 0xad0a,
        kKiyeokWaRieulhieuh                 = 0xad0b,
        kKiyeokWaMieum                      = 0xad0c,
        kKiyeokWaPieup                      = 0xad0d,
        kKiyeokWaPieupsios                  = 0xad0e,
        kKiyeokWaSios                       = 0xad0f,
        kKiyeokWaSsangsios                  = 0xad10,
        kKiyeokWaIeung                      = 0xad11,
        kKiyeokWaCieuc                      = 0xad12,
        kKiyeokWaChieuch                    = 0xad13,
        kKiyeokWaKhieukh                    = 0xad14,
        kKiyeokWaThieuth                    = 0xad15,
        kKiyeokWaPhieuph                    = 0xad16,
        kKiyeokWaHieuh                      = 0xad17,
        kKiyeokWae                          = 0xad18,
        kKiyeokWaeKiyeok                    = 0xad19,
        kKiyeokWaeSsangkiyeok               = 0xad1a,
        kKiyeokWaeKiyeoksios                = 0xad1b,
        kKiyeokWaeNieun                     = 0xad1c,
        kKiyeokWaeNieuncieuc                = 0xad1d,
        kKiyeokWaeNieunhieuh                = 0xad1e,
        kKiyeokWaeTikeut                    = 0xad1f,
        kKiyeokWaeRieul                     = 0xad20,
        kKiyeokWaeRieulkiyeok               = 0xad21,
        kKiyeokWaeRieulmieum                = 0xad22,
        kKiyeokWaeRieulpieup                = 0xad23,
        kKiyeokWaeRieulsios                 = 0xad24,
        kKiyeokWaeRieulthieuth              = 0xad25,
        kKiyeokWaeRieulphieuph              = 0xad26,
        kKiyeokWaeRieulhieuh                = 0xad27,
        kKiyeokWaeMieum                     = 0xad28,
        kKiyeokWaePieup                     = 0xad29,
        kKiyeokWaePieupsios                 = 0xad2a,
        kKiyeokWaeSios                      = 0xad2b,
        kKiyeokWaeSsangsios                 = 0xad2c,
        kKiyeokWaeIeung                     = 0xad2d,
        kKiyeokWaeCieuc                     = 0xad2e,
        kKiyeokWaeChieuch                   = 0xad2f,
        kKiyeokWaeKhieukh                   = 0xad30,
        kKiyeokWaeThieuth                   = 0xad31,
        kKiyeokWaePhieuph                   = 0xad32,
        kKiyeokWaeHieuh                     = 0xad33,
        kKiyeokOe                           = 0xad34,
        kKiyeokOeKiyeok                     = 0xad35,
        kKiyeokOeSsangkiyeok                = 0xad36,
        kKiyeokOeKiyeoksios                 = 0xad37,
        kKiyeokOeNieun                      = 0xad38,
        kKiyeokOeNieuncieuc                 = 0xad39,
        kKiyeokOeNieunhieuh                 = 0xad3a,
        kKiyeokOeTikeut                     = 0xad3b,
        kKiyeokOeRieul                      = 0xad3c,
        kKiyeokOeRieulkiyeok                = 0xad3d,
        kKiyeokOeRieulmieum                 = 0xad3e,
        kKiyeokOeRieulpieup                 = 0xad3f,
        kKiyeokOeRieulsios                  = 0xad40,
        kKiyeokOeRieulthieuth               = 0xad41,
        kKiyeokOeRieulphieuph               = 0xad42,
        kKiyeokOeRieulhieuh                 = 0xad43,
        kKiyeokOeMieum                      = 0xad44,
        kKiyeokOePieup                      = 0xad45,
        kKiyeokOePieupsios                  = 0xad46,
        kKiyeokOeSios                       = 0xad47,
        kKiyeokOeSsangsios                  = 0xad48,
        kKiyeokOeIeung                      = 0xad49,
        kKiyeokOeCieuc                      = 0xad4a,
        kKiyeokOeChieuch                    = 0xad4b,
        kKiyeokOeKhieukh                    = 0xad4c,
        kKiyeokOeThieuth                    = 0xad4d,
        kKiyeokOePhieuph                    = 0xad4e,
        kKiyeokOeHieuh                      = 0xad4f,
        kKiyeokYo                           = 0xad50,
        kKiyeokYoKiyeok                     = 0xad51,
        kKiyeokYoSsangkiyeok                = 0xad52,
        kKiyeokYoKiyeoksios                 = 0xad53,
        kKiyeokYoNieun                      = 0xad54,
        kKiyeokYoNieuncieuc                 = 0xad55,
        kKiyeokYoNieunhieuh                 = 0xad56,
        kKiyeokYoTikeut                     = 0xad57,
        kKiyeokYoRieul                      = 0xad58,
        kKiyeokYoRieulkiyeok                = 0xad59,
        kKiyeokYoRieulmieum                 = 0xad5a,
        kKiyeokYoRieulpieup                 = 0xad5b,
        kKiyeokYoRieulsios                  = 0xad5c,
        kKiyeokYoRieulthieuth               = 0xad5d,
        kKiyeokYoRieulphieuph               = 0xad5e,
        kKiyeokYoRieulhieuh                 = 0xad5f,
        kKiyeokYoMieum                      = 0xad60,
        kKiyeokYoPieup                      = 0xad61,
        kKiyeokYoPieupsios                  = 0xad62,
        kKiyeokYoSios                       = 0xad63,
        kKiyeokYoSsangsios                  = 0xad64,
        kKiyeokYoIeung                      = 0xad65,
        kKiyeokYoCieuc                      = 0xad66,
        kKiyeokYoChieuch                    = 0xad67,
        kKiyeokYoKhieukh                    = 0xad68,
        kKiyeokYoThieuth                    = 0xad69,
        kKiyeokYoPhieuph                    = 0xad6a,
        kKiyeokYoHieuh                      = 0xad6b,
        kKiyeokU                            = 0xad6c,
        kKiyeokUKiyeok                      = 0xad6d,
        kKiyeokUSsangkiyeok                 = 0xad6e,
        kKiyeokUKiyeoksios                  = 0xad6f,
        kKiyeokUNieun                       = 0xad70,
        kKiyeokUNieuncieuc                  = 0xad71,
        kKiyeokUNieunhieuh                  = 0xad72,
        kKiyeokUTikeut                      = 0xad73,
        kKiyeokURieul                       = 0xad74,
        kKiyeokURieulkiyeok                 = 0xad75,
        kKiyeokURieulmieum                  = 0xad76,
        kKiyeokURieulpieup                  = 0xad77,
        kKiyeokURieulsios                   = 0xad78,
        kKiyeokURieulthieuth                = 0xad79,
        kKiyeokURieulphieuph                = 0xad7a,
        kKiyeokURieulhieuh                  = 0xad7b,
        kKiyeokUMieum                       = 0xad7c,
        kKiyeokUPieup                       = 0xad7d,
        kKiyeokUPieupsios                   = 0xad7e,
        kKiyeokUSios                        = 0xad7f,
        kKiyeokUSsangsios                   = 0xad80,
        kKiyeokUIeung                       = 0xad81,
        kKiyeokUCieuc                       = 0xad82,
        kKiyeokUChieuch                     = 0xad83,
        kKiyeokUKhieukh                     = 0xad84,
        kKiyeokUThieuth                     = 0xad85,
        kKiyeokUPhieuph                     = 0xad86,
        kKiyeokUHieuh                       = 0xad87,
        kKiyeokWeo                          = 0xad88,
        kKiyeokWeoKiyeok                    = 0xad89,
        kKiyeokWeoSsangkiyeok               = 0xad8a,
        kKiyeokWeoKiyeoksios                = 0xad8b,
        kKiyeokWeoNieun                     = 0xad8c,
        kKiyeokWeoNieuncieuc                = 0xad8d,
        kKiyeokWeoNieunhieuh                = 0xad8e,
        kKiyeokWeoTikeut                    = 0xad8f,
        kKiyeokWeoRieul                     = 0xad90,
        kKiyeokWeoRieulkiyeok               = 0xad91,
        kKiyeokWeoRieulmieum                = 0xad92,
        kKiyeokWeoRieulpieup                = 0xad93,
        kKiyeokWeoRieulsios                 = 0xad94,
        kKiyeokWeoRieulthieuth              = 0xad95,
        kKiyeokWeoRieulphieuph              = 0xad96,
        kKiyeokWeoRieulhieuh                = 0xad97,
        kKiyeokWeoMieum                     = 0xad98,
        kKiyeokWeoPieup                     = 0xad99,
        kKiyeokWeoPieupsios                 = 0xad9a,
        kKiyeokWeoSios                      = 0xad9b,
        kKiyeokWeoSsangsios                 = 0xad9c,
        kKiyeokWeoIeung                     = 0xad9d,
        kKiyeokWeoCieuc                     = 0xad9e,
        kKiyeokWeoChieuch                   = 0xad9f,
        kKiyeokWeoKhieukh                   = 0xada0,
        kKiyeokWeoThieuth                   = 0xada1,
        kKiyeokWeoPhieuph                   = 0xada2,
        kKiyeokWeoHieuh                     = 0xada3,
        kKiyeokWe                           = 0xada4,
        kKiyeokWeKiyeok                     = 0xada5,
        kKiyeokWeSsangkiyeok                = 0xada6,
        kKiyeokWeKiyeoksios                 = 0xada7,
        kKiyeokWeNieun                      = 0xada8,
        kKiyeokWeNieuncieuc                 = 0xada9,
        kKiyeokWeNieunhieuh                 = 0xadaa,
        kKiyeokWeTikeut                     = 0xadab,
        kKiyeokWeRieul                      = 0xadac,
        kKiyeokWeRieulkiyeok                = 0xadad,
        kKiyeokWeRieulmieum                 = 0xadae,
        kKiyeokWeRieulpieup                 = 0xadaf,
        kKiyeokWeRieulsios                  = 0xadb0,
        kKiyeokWeRieulthieuth               = 0xadb1,
        kKiyeokWeRieulphieuph               = 0xadb2,
        kKiyeokWeRieulhieuh                 = 0xadb3,
        kKiyeokWeMieum                      = 0xadb4,
        kKiyeokWePieup                      = 0xadb5,
        kKiyeokWePieupsios                  = 0xadb6,
        kKiyeokWeSios                       = 0xadb7,
        kKiyeokWeSsangsios                  = 0xadb8,
        kKiyeokWeIeung                      = 0xadb9,
        kKiyeokWeCieuc                      = 0xadba,
        kKiyeokWeChieuch                    = 0xadbb,
        kKiyeokWeKhieukh                    = 0xadbc,
        kKiyeokWeThieuth                    = 0xadbd,
        kKiyeokWePhieuph                    = 0xadbe,
        kKiyeokWeHieuh                      = 0xadbf,
        kKiyeokWi                           = 0xadc0,
        kKiyeokWiKiyeok                     = 0xadc1,
        kKiyeokWiSsangkiyeok                = 0xadc2,
        kKiyeokWiKiyeoksios                 = 0xadc3,
        kKiyeokWiNieun                      = 0xadc4,
        kKiyeokWiNieuncieuc                 = 0xadc5,
        kKiyeokWiNieunhieuh                 = 0xadc6,
        kKiyeokWiTikeut                     = 0xadc7,
        kKiyeokWiRieul                      = 0xadc8,
        kKiyeokWiRieulkiyeok                = 0xadc9,
        kKiyeokWiRieulmieum                 = 0xadca,
        kKiyeokWiRieulpieup                 = 0xadcb,
        kKiyeokWiRieulsios                  = 0xadcc,
        kKiyeokWiRieulthieuth               = 0xadcd,
        kKiyeokWiRieulphieuph               = 0xadce,
        kKiyeokWiRieulhieuh                 = 0xadcf,
        kKiyeokWiMieum                      = 0xadd0,
        kKiyeokWiPieup                      = 0xadd1,
        kKiyeokWiPieupsios                  = 0xadd2,
        kKiyeokWiSios                       = 0xadd3,
        kKiyeokWiSsangsios                  = 0xadd4,
        kKiyeokWiIeung                      = 0xadd5,
        kKiyeokWiCieuc                      = 0xadd6,
        kKiyeokWiChieuch                    = 0xadd7,
        kKiyeokWiKhieukh                    = 0xadd8,
        kKiyeokWiThieuth                    = 0xadd9,
        kKiyeokWiPhieuph                    = 0xadda,
        kKiyeokWiHieuh                      = 0xaddb,
        kKiyeokYu                           = 0xaddc,
        kKiyeokYuKiyeok                     = 0xaddd,
        kKiyeokYuSsangkiyeok                = 0xadde,
        kKiyeokYuKiyeoksios                 = 0xaddf,
        kKiyeokYuNieun                      = 0xade0,
        kKiyeokYuNieuncieuc                 = 0xade1,
        kKiyeokYuNieunhieuh                 = 0xade2,
        kKiyeokYuTikeut                     = 0xade3,
        kKiyeokYuRieul                      = 0xade4,
        kKiyeokYuRieulkiyeok                = 0xade5,
        kKiyeokYuRieulmieum                 = 0xade6,
        kKiyeokYuRieulpieup                 = 0xade7,
        kKiyeokYuRieulsios                  = 0xade8,
        kKiyeokYuRieulthieuth               = 0xade9,
        kKiyeokYuRieulphieuph               = 0xadea,
        kKiyeokYuRieulhieuh                 = 0xadeb,
        kKiyeokYuMieum                      = 0xadec,
        kKiyeokYuPieup                      = 0xaded,
        kKiyeokYuPieupsios                  = 0xadee,
        kKiyeokYuSios                       = 0xadef,
        kKiyeokYuSsangsios                  = 0xadf0,
        kKiyeokYuIeung                      = 0xadf1,
        kKiyeokYuCieuc                      = 0xadf2,
        kKiyeokYuChieuch                    = 0xadf3,
        kKiyeokYuKhieukh                    = 0xadf4,
        kKiyeokYuThieuth                    = 0xadf5,
        kKiyeokYuPhieuph                    = 0xadf6,
        kKiyeokYuHieuh                      = 0xadf7,
        kKiyeokEu                           = 0xadf8,
        kKiyeokEuKiyeok                     = 0xadf9,
        kKiyeokEuSsangkiyeok                = 0xadfa,
        kKiyeokEuKiyeoksios                 = 0xadfb,
        kKiyeokEuNieun                      = 0xadfc,
        kKiyeokEuNieuncieuc                 = 0xadfd,
        kKiyeokEuNieunhieuh                 = 0xadfe,
        kKiyeokEuTikeut                     = 0xadff,
        kKiyeokEuRieul                      = 0xae00,
        kKiyeokEuRieulkiyeok                = 0xae01,
        kKiyeokEuRieulmieum                 = 0xae02,
        kKiyeokEuRieulpieup                 = 0xae03,
        kKiyeokEuRieulsios                  = 0xae04,
        kKiyeokEuRieulthieuth               = 0xae05,
        kKiyeokEuRieulphieuph               = 0xae06,
        kKiyeokEuRieulhieuh                 = 0xae07,
        kKiyeokEuMieum                      = 0xae08,
        kKiyeokEuPieup                      = 0xae09,
        kKiyeokEuPieupsios                  = 0xae0a,
        kKiyeokEuSios                       = 0xae0b,
        kKiyeokEuSsangsios                  = 0xae0c,
        kKiyeokEuIeung                      = 0xae0d,
        kKiyeokEuCieuc                      = 0xae0e,
        kKiyeokEuChieuch                    = 0xae0f,
        kKiyeokEuKhieukh                    = 0xae10,
        kKiyeokEuThieuth                    = 0xae11,
        kKiyeokEuPhieuph                    = 0xae12,
        kKiyeokEuHieuh                      = 0xae13,
        kKiyeokYi                           = 0xae14,
        kKiyeokYiKiyeok                     = 0xae15,
        kKiyeokYiSsangkiyeok                = 0xae16,
        kKiyeokYiKiyeoksios                 = 0xae17,
        kKiyeokYiNieun                      = 0xae18,
        kKiyeokYiNieuncieuc                 = 0xae19,
        kKiyeokYiNieunhieuh                 = 0xae1a,
        kKiyeokYiTikeut                     = 0xae1b,
        kKiyeokYiRieul                      = 0xae1c,
        kKiyeokYiRieulkiyeok                = 0xae1d,
        kKiyeokYiRieulmieum                 = 0xae1e,
        kKiyeokYiRieulpieup                 = 0xae1f,
        kKiyeokYiRieulsios                  = 0xae20,
        kKiyeokYiRieulthieuth               = 0xae21,
        kKiyeokYiRieulphieuph               = 0xae22,
        kKiyeokYiRieulhieuh                 = 0xae23,
        kKiyeokYiMieum                      = 0xae24,
        kKiyeokYiPieup                      = 0xae25,
        kKiyeokYiPieupsios                  = 0xae26,
        kKiyeokYiSios                       = 0xae27,
        kKiyeokYiSsangsios                  = 0xae28,
        kKiyeokYiIeung                      = 0xae29,
        kKiyeokYiCieuc                      = 0xae2a,
        kKiyeokYiChieuch                    = 0xae2b,
        kKiyeokYiKhieukh                    = 0xae2c,
        kKiyeokYiThieuth                    = 0xae2d,
        kKiyeokYiPhieuph                    = 0xae2e,
        kKiyeokYiHieuh                      = 0xae2f,
        kKiyeokI                            = 0xae30,
        kKiyeokIKiyeok                      = 0xae31,
        kKiyeokISsangkiyeok                 = 0xae32,
        kKiyeokIKiyeoksios                  = 0xae33,
        kKiyeokINieun                       = 0xae34,
        kKiyeokINieuncieuc                  = 0xae35,
        kKiyeokINieunhieuh                  = 0xae36,
        kKiyeokITikeut                      = 0xae37,
        kKiyeokIRieul                       = 0xae38,
        kKiyeokIRieulkiyeok                 = 0xae39,
        kKiyeokIRieulmieum                  = 0xae3a,
        kKiyeokIRieulpieup                  = 0xae3b,
        kKiyeokIRieulsios                   = 0xae3c,
        kKiyeokIRieulthieuth                = 0xae3d,
        kKiyeokIRieulphieuph                = 0xae3e,
        kKiyeokIRieulhieuh                  = 0xae3f,
        kKiyeokIMieum                       = 0xae40,
        kKiyeokIPieup                       = 0xae41,
        kKiyeokIPieupsios                   = 0xae42,
        kKiyeokISios                        = 0xae43,
        kKiyeokISsangsios                   = 0xae44,
        kKiyeokIIeung                       = 0xae45,
        kKiyeokICieuc                       = 0xae46,
        kKiyeokIChieuch                     = 0xae47,
        kKiyeokIKhieukh                     = 0xae48,
        kKiyeokIThieuth                     = 0xae49,
        kKiyeokIPhieuph                     = 0xae4a,
        kKiyeokIHieuh                       = 0xae4b,
        kSsangkiyeokA                       = 0xae4c,
        kSsangkiyeokAKiyeok                 = 0xae4d,
        kSsangkiyeokASsangkiyeok            = 0xae4e,
        kSsangkiyeokAKiyeoksios             = 0xae4f,
        kSsangkiyeokANieun                  = 0xae50,
        kSsangkiyeokANieuncieuc             = 0xae51,
        kSsangkiyeokANieunhieuh             = 0xae52,
        kSsangkiyeokATikeut                 = 0xae53,
        kSsangkiyeokARieul                  = 0xae54,
        kSsangkiyeokARieulkiyeok            = 0xae55,
        kSsangkiyeokARieulmieum             = 0xae56,
        kSsangkiyeokARieulpieup             = 0xae57,
        kSsangkiyeokARieulsios              = 0xae58,
        kSsangkiyeokARieulthieuth           = 0xae59,
        kSsangkiyeokARieulphieuph           = 0xae5a,
        kSsangkiyeokARieulhieuh             = 0xae5b,
        kSsangkiyeokAMieum                  = 0xae5c,
        kSsangkiyeokAPieup                  = 0xae5d,
        kSsangkiyeokAPieupsios              = 0xae5e,
        kSsangkiyeokASios                   = 0xae5f,
        kSsangkiyeokASsangsios              = 0xae60,
        kSsangkiyeokAIeung                  = 0xae61,
        kSsangkiyeokACieuc                  = 0xae62,
        kSsangkiyeokAChieuch                = 0xae63,
        kSsangkiyeokAKhieukh                = 0xae64,
        kSsangkiyeokAThieuth                = 0xae65,
        kSsangkiyeokAPhieuph                = 0xae66,
        kSsangkiyeokAHieuh                  = 0xae67,
        kSsangkiyeokAe                      = 0xae68,
        kSsangkiyeokAeKiyeok                = 0xae69,
        kSsangkiyeokAeSsangkiyeok           = 0xae6a,
        kSsangkiyeokAeKiyeoksios            = 0xae6b,
        kSsangkiyeokAeNieun                 = 0xae6c,
        kSsangkiyeokAeNieuncieuc            = 0xae6d,
        kSsangkiyeokAeNieunhieuh            = 0xae6e,
        kSsangkiyeokAeTikeut                = 0xae6f,
        kSsangkiyeokAeRieul                 = 0xae70,
        kSsangkiyeokAeRieulkiyeok           = 0xae71,
        kSsangkiyeokAeRieulmieum            = 0xae72,
        kSsangkiyeokAeRieulpieup            = 0xae73,
        kSsangkiyeokAeRieulsios             = 0xae74,
        kSsangkiyeokAeRieulthieuth          = 0xae75,
        kSsangkiyeokAeRieulphieuph          = 0xae76,
        kSsangkiyeokAeRieulhieuh            = 0xae77,
        kSsangkiyeokAeMieum                 = 0xae78,
        kSsangkiyeokAePieup                 = 0xae79,
        kSsangkiyeokAePieupsios             = 0xae7a,
        kSsangkiyeokAeSios                  = 0xae7b,
        kSsangkiyeokAeSsangsios             = 0xae7c,
        kSsangkiyeokAeIeung                 = 0xae7d,
        kSsangkiyeokAeCieuc                 = 0xae7e,
        kSsangkiyeokAeChieuch               = 0xae7f,
        kSsangkiyeokAeKhieukh               = 0xae80,
        kSsangkiyeokAeThieuth               = 0xae81,
        kSsangkiyeokAePhieuph               = 0xae82,
        kSsangkiyeokAeHieuh                 = 0xae83,
        kSsangkiyeokYa                      = 0xae84,
        kSsangkiyeokYaKiyeok                = 0xae85,
        kSsangkiyeokYaSsangkiyeok           = 0xae86,
        kSsangkiyeokYaKiyeoksios            = 0xae87,
        kSsangkiyeokYaNieun                 = 0xae88,
        kSsangkiyeokYaNieuncieuc            = 0xae89,
        kSsangkiyeokYaNieunhieuh            = 0xae8a,
        kSsangkiyeokYaTikeut                = 0xae8b,
        kSsangkiyeokYaRieul                 = 0xae8c,
        kSsangkiyeokYaRieulkiyeok           = 0xae8d,
        kSsangkiyeokYaRieulmieum            = 0xae8e,
        kSsangkiyeokYaRieulpieup            = 0xae8f,
        kSsangkiyeokYaRieulsios             = 0xae90,
        kSsangkiyeokYaRieulthieuth          = 0xae91,
        kSsangkiyeokYaRieulphieuph          = 0xae92,
        kSsangkiyeokYaRieulhieuh            = 0xae93,
        kSsangkiyeokYaMieum                 = 0xae94,
        kSsangkiyeokYaPieup                 = 0xae95,
        kSsangkiyeokYaPieupsios             = 0xae96,
        kSsangkiyeokYaSios                  = 0xae97,
        kSsangkiyeokYaSsangsios             = 0xae98,
        kSsangkiyeokYaIeung                 = 0xae99,
        kSsangkiyeokYaCieuc                 = 0xae9a,
        kSsangkiyeokYaChieuch               = 0xae9b,
        kSsangkiyeokYaKhieukh               = 0xae9c,
        kSsangkiyeokYaThieuth               = 0xae9d,
        kSsangkiyeokYaPhieuph               = 0xae9e,
        kSsangkiyeokYaHieuh                 = 0xae9f,
        kSsangkiyeokYae                     = 0xaea0,
        kSsangkiyeokYaeKiyeok               = 0xaea1,
        kSsangkiyeokYaeSsangkiyeok          = 0xaea2,
        kSsangkiyeokYaeKiyeoksios           = 0xaea3,
        kSsangkiyeokYaeNieun                = 0xaea4,
        kSsangkiyeokYaeNieuncieuc           = 0xaea5,
        kSsangkiyeokYaeNieunhieuh           = 0xaea6,
        kSsangkiyeokYaeTikeut               = 0xaea7,
        kSsangkiyeokYaeRieul                = 0xaea8,
        kSsangkiyeokYaeRieulkiyeok          = 0xaea9,
        kSsangkiyeokYaeRieulmieum           = 0xaeaa,
        kSsangkiyeokYaeRieulpieup           = 0xaeab,
        kSsangkiyeokYaeRieulsios            = 0xaeac,
        kSsangkiyeokYaeRieulthieuth         = 0xaead,
        kSsangkiyeokYaeRieulphieuph         = 0xaeae,
        kSsangkiyeokYaeRieulhieuh           = 0xaeaf,
        kSsangkiyeokYaeMieum                = 0xaeb0,
        kSsangkiyeokYaePieup                = 0xaeb1,
        kSsangkiyeokYaePieupsios            = 0xaeb2,
        kSsangkiyeokYaeSios                 = 0xaeb3,
        kSsangkiyeokYaeSsangsios            = 0xaeb4,
        kSsangkiyeokYaeIeung                = 0xaeb5,
        kSsangkiyeokYaeCieuc                = 0xaeb6,
        kSsangkiyeokYaeChieuch              = 0xaeb7,
        kSsangkiyeokYaeKhieukh              = 0xaeb8,
        kSsangkiyeokYaeThieuth              = 0xaeb9,
        kSsangkiyeokYaePhieuph              = 0xaeba,
        kSsangkiyeokYaeHieuh                = 0xaebb,
        kSsangkiyeokEo                      = 0xaebc,
        kSsangkiyeokEoKiyeok                = 0xaebd,
        kSsangkiyeokEoSsangkiyeok           = 0xaebe,
        kSsangkiyeokEoKiyeoksios            = 0xaebf,
        kSsangkiyeokEoNieun                 = 0xaec0,
        kSsangkiyeokEoNieuncieuc            = 0xaec1,
        kSsangkiyeokEoNieunhieuh            = 0xaec2,
        kSsangkiyeokEoTikeut                = 0xaec3,
        kSsangkiyeokEoRieul                 = 0xaec4,
        kSsangkiyeokEoRieulkiyeok           = 0xaec5,
        kSsangkiyeokEoRieulmieum            = 0xaec6,
        kSsangkiyeokEoRieulpieup            = 0xaec7,
        kSsangkiyeokEoRieulsios             = 0xaec8,
        kSsangkiyeokEoRieulthieuth          = 0xaec9,
        kSsangkiyeokEoRieulphieuph          = 0xaeca,
        kSsangkiyeokEoRieulhieuh            = 0xaecb,
        kSsangkiyeokEoMieum                 = 0xaecc,
        kSsangkiyeokEoPieup                 = 0xaecd,
        kSsangkiyeokEoPieupsios             = 0xaece,
        kSsangkiyeokEoSios                  = 0xaecf,
        kSsangkiyeokEoSsangsios             = 0xaed0,
        kSsangkiyeokEoIeung                 = 0xaed1,
        kSsangkiyeokEoCieuc                 = 0xaed2,
        kSsangkiyeokEoChieuch               = 0xaed3,
        kSsangkiyeokEoKhieukh               = 0xaed4,
        kSsangkiyeokEoThieuth               = 0xaed5,
        kSsangkiyeokEoPhieuph               = 0xaed6,
        kSsangkiyeokEoHieuh                 = 0xaed7,
        kSsangkiyeokE                       = 0xaed8,
        kSsangkiyeokEKiyeok                 = 0xaed9,
        kSsangkiyeokESsangkiyeok            = 0xaeda,
        kSsangkiyeokEKiyeoksios             = 0xaedb,
        kSsangkiyeokENieun                  = 0xaedc,
        kSsangkiyeokENieuncieuc             = 0xaedd,
        kSsangkiyeokENieunhieuh             = 0xaede,
        kSsangkiyeokETikeut                 = 0xaedf,
        kSsangkiyeokERieul                  = 0xaee0,
        kSsangkiyeokERieulkiyeok            = 0xaee1,
        kSsangkiyeokERieulmieum             = 0xaee2,
        kSsangkiyeokERieulpieup             = 0xaee3,
        kSsangkiyeokERieulsios              = 0xaee4,
        kSsangkiyeokERieulthieuth           = 0xaee5,
        kSsangkiyeokERieulphieuph           = 0xaee6,
        kSsangkiyeokERieulhieuh             = 0xaee7,
        kSsangkiyeokEMieum                  = 0xaee8,
        kSsangkiyeokEPieup                  = 0xaee9,
        kSsangkiyeokEPieupsios              = 0xaeea,
        kSsangkiyeokESios                   = 0xaeeb,
        kSsangkiyeokESsangsios              = 0xaeec,
        kSsangkiyeokEIeung                  = 0xaeed,
        kSsangkiyeokECieuc                  = 0xaeee,
        kSsangkiyeokEChieuch                = 0xaeef,
        kSsangkiyeokEKhieukh                = 0xaef0,
        kSsangkiyeokEThieuth                = 0xaef1,
        kSsangkiyeokEPhieuph                = 0xaef2,
        kSsangkiyeokEHieuh                  = 0xaef3,
        kSsangkiyeokYeo                     = 0xaef4,
        kSsangkiyeokYeoKiyeok               = 0xaef5,
        kSsangkiyeokYeoSsangkiyeok          = 0xaef6,
        kSsangkiyeokYeoKiyeoksios           = 0xaef7,
        kSsangkiyeokYeoNieun                = 0xaef8,
        kSsangkiyeokYeoNieuncieuc           = 0xaef9,
        kSsangkiyeokYeoNieunhieuh           = 0xaefa,
        kSsangkiyeokYeoTikeut               = 0xaefb,
        kSsangkiyeokYeoRieul                = 0xaefc,
        kSsangkiyeokYeoRieulkiyeok          = 0xaefd,
        kSsangkiyeokYeoRieulmieum           = 0xaefe,
        kSsangkiyeokYeoRieulpieup           = 0xaeff,
        kSsangkiyeokYeoRieulsios            = 0xaf00,
        kSsangkiyeokYeoRieulthieuth         = 0xaf01,
        kSsangkiyeokYeoRieulphieuph         = 0xaf02,
        kSsangkiyeokYeoRieulhieuh           = 0xaf03,
        kSsangkiyeokYeoMieum                = 0xaf04,
        kSsangkiyeokYeoPieup                = 0xaf05,
        kSsangkiyeokYeoPieupsios            = 0xaf06,
        kSsangkiyeokYeoSios                 = 0xaf07,
        kSsangkiyeokYeoSsangsios            = 0xaf08,
        kSsangkiyeokYeoIeung                = 0xaf09,
        kSsangkiyeokYeoCieuc                = 0xaf0a,
        kSsangkiyeokYeoChieuch              = 0xaf0b,
        kSsangkiyeokYeoKhieukh              = 0xaf0c,
        kSsangkiyeokYeoThieuth              = 0xaf0d,
        kSsangkiyeokYeoPhieuph              = 0xaf0e,
        kSsangkiyeokYeoHieuh                = 0xaf0f,
        kSsangkiyeokYe                      = 0xaf10,
        kSsangkiyeokYeKiyeok                = 0xaf11,
        kSsangkiyeokYeSsangkiyeok           = 0xaf12,
        kSsangkiyeokYeKiyeoksios            = 0xaf13,
        kSsangkiyeokYeNieun                 = 0xaf14,
        kSsangkiyeokYeNieuncieuc            = 0xaf15,
        kSsangkiyeokYeNieunhieuh            = 0xaf16,
        kSsangkiyeokYeTikeut                = 0xaf17,
        kSsangkiyeokYeRieul                 = 0xaf18,
        kSsangkiyeokYeRieulkiyeok           = 0xaf19,
        kSsangkiyeokYeRieulmieum            = 0xaf1a,
        kSsangkiyeokYeRieulpieup            = 0xaf1b,
        kSsangkiyeokYeRieulsios             = 0xaf1c,
        kSsangkiyeokYeRieulthieuth          = 0xaf1d,
        kSsangkiyeokYeRieulphieuph          = 0xaf1e,
        kSsangkiyeokYeRieulhieuh            = 0xaf1f,
        kSsangkiyeokYeMieum                 = 0xaf20,
        kSsangkiyeokYePieup                 = 0xaf21,
        kSsangkiyeokYePieupsios             = 0xaf22,
        kSsangkiyeokYeSios                  = 0xaf23,
        kSsangkiyeokYeSsangsios             = 0xaf24,
        kSsangkiyeokYeIeung                 = 0xaf25,
        kSsangkiyeokYeCieuc                 = 0xaf26,
        kSsangkiyeokYeChieuch               = 0xaf27,
        kSsangkiyeokYeKhieukh               = 0xaf28,
        kSsangkiyeokYeThieuth               = 0xaf29,
        kSsangkiyeokYePhieuph               = 0xaf2a,
        kSsangkiyeokYeHieuh                 = 0xaf2b,
        kSsangkiyeokO                       = 0xaf2c,
        kSsangkiyeokOKiyeok                 = 0xaf2d,
        kSsangkiyeokOSsangkiyeok            = 0xaf2e,
        kSsangkiyeokOKiyeoksios             = 0xaf2f,
        kSsangkiyeokONieun                  = 0xaf30,
        kSsangkiyeokONieuncieuc             = 0xaf31,
        kSsangkiyeokONieunhieuh             = 0xaf32,
        kSsangkiyeokOTikeut                 = 0xaf33,
        kSsangkiyeokORieul                  = 0xaf34,
        kSsangkiyeokORieulkiyeok            = 0xaf35,
        kSsangkiyeokORieulmieum             = 0xaf36,
        kSsangkiyeokORieulpieup             = 0xaf37,
        kSsangkiyeokORieulsios              = 0xaf38,
        kSsangkiyeokORieulthieuth           = 0xaf39,
        kSsangkiyeokORieulphieuph           = 0xaf3a,
        kSsangkiyeokORieulhieuh             = 0xaf3b,
        kSsangkiyeokOMieum                  = 0xaf3c,
        kSsangkiyeokOPieup                  = 0xaf3d,
        kSsangkiyeokOPieupsios              = 0xaf3e,
        kSsangkiyeokOSios                   = 0xaf3f,
        kSsangkiyeokOSsangsios              = 0xaf40,
        kSsangkiyeokOIeung                  = 0xaf41,
        kSsangkiyeokOCieuc                  = 0xaf42,
        kSsangkiyeokOChieuch                = 0xaf43,
        kSsangkiyeokOKhieukh                = 0xaf44,
        kSsangkiyeokOThieuth                = 0xaf45,
        kSsangkiyeokOPhieuph                = 0xaf46,
        kSsangkiyeokOHieuh                  = 0xaf47,
        kSsangkiyeokWa                      = 0xaf48,
        kSsangkiyeokWaKiyeok                = 0xaf49,
        kSsangkiyeokWaSsangkiyeok           = 0xaf4a,
        kSsangkiyeokWaKiyeoksios            = 0xaf4b,
        kSsangkiyeokWaNieun                 = 0xaf4c,
        kSsangkiyeokWaNieuncieuc            = 0xaf4d,
        kSsangkiyeokWaNieunhieuh            = 0xaf4e,
        kSsangkiyeokWaTikeut                = 0xaf4f,
        kSsangkiyeokWaRieul                 = 0xaf50,
        kSsangkiyeokWaRieulkiyeok           = 0xaf51,
        kSsangkiyeokWaRieulmieum            = 0xaf52,
        kSsangkiyeokWaRieulpieup            = 0xaf53,
        kSsangkiyeokWaRieulsios             = 0xaf54,
        kSsangkiyeokWaRieulthieuth          = 0xaf55,
        kSsangkiyeokWaRieulphieuph          = 0xaf56,
        kSsangkiyeokWaRieulhieuh            = 0xaf57,
        kSsangkiyeokWaMieum                 = 0xaf58,
        kSsangkiyeokWaPieup                 = 0xaf59,
        kSsangkiyeokWaPieupsios             = 0xaf5a,
        kSsangkiyeokWaSios                  = 0xaf5b,
        kSsangkiyeokWaSsangsios             = 0xaf5c,
        kSsangkiyeokWaIeung                 = 0xaf5d,
        kSsangkiyeokWaCieuc                 = 0xaf5e,
        kSsangkiyeokWaChieuch               = 0xaf5f,
        kSsangkiyeokWaKhieukh               = 0xaf60,
        kSsangkiyeokWaThieuth               = 0xaf61,
        kSsangkiyeokWaPhieuph               = 0xaf62,
        kSsangkiyeokWaHieuh                 = 0xaf63,
        kSsangkiyeokWae                     = 0xaf64,
        kSsangkiyeokWaeKiyeok               = 0xaf65,
        kSsangkiyeokWaeSsangkiyeok          = 0xaf66,
        kSsangkiyeokWaeKiyeoksios           = 0xaf67,
        kSsangkiyeokWaeNieun                = 0xaf68,
        kSsangkiyeokWaeNieuncieuc           = 0xaf69,
        kSsangkiyeokWaeNieunhieuh           = 0xaf6a,
        kSsangkiyeokWaeTikeut               = 0xaf6b,
        kSsangkiyeokWaeRieul                = 0xaf6c,
        kSsangkiyeokWaeRieulkiyeok          = 0xaf6d,
        kSsangkiyeokWaeRieulmieum           = 0xaf6e,
        kSsangkiyeokWaeRieulpieup           = 0xaf6f,
        kSsangkiyeokWaeRieulsios            = 0xaf70,
        kSsangkiyeokWaeRieulthieuth         = 0xaf71,
        kSsangkiyeokWaeRieulphieuph         = 0xaf72,
        kSsangkiyeokWaeRieulhieuh           = 0xaf73,
        kSsangkiyeokWaeMieum                = 0xaf74,
        kSsangkiyeokWaePieup                = 0xaf75,
        kSsangkiyeokWaePieupsios            = 0xaf76,
        kSsangkiyeokWaeSios                 = 0xaf77,
        kSsangkiyeokWaeSsangsios            = 0xaf78,
        kSsangkiyeokWaeIeung                = 0xaf79,
        kSsangkiyeokWaeCieuc                = 0xaf7a,
        kSsangkiyeokWaeChieuch              = 0xaf7b,
        kSsangkiyeokWaeKhieukh              = 0xaf7c,
        kSsangkiyeokWaeThieuth              = 0xaf7d,
        kSsangkiyeokWaePhieuph              = 0xaf7e,
        kSsangkiyeokWaeHieuh                = 0xaf7f,
        kSsangkiyeokOe                      = 0xaf80,
        kSsangkiyeokOeKiyeok                = 0xaf81,
        kSsangkiyeokOeSsangkiyeok           = 0xaf82,
        kSsangkiyeokOeKiyeoksios            = 0xaf83,
        kSsangkiyeokOeNieun                 = 0xaf84,
        kSsangkiyeokOeNieuncieuc            = 0xaf85,
        kSsangkiyeokOeNieunhieuh            = 0xaf86,
        kSsangkiyeokOeTikeut                = 0xaf87,
        kSsangkiyeokOeRieul                 = 0xaf88,
        kSsangkiyeokOeRieulkiyeok           = 0xaf89,
        kSsangkiyeokOeRieulmieum            = 0xaf8a,
        kSsangkiyeokOeRieulpieup            = 0xaf8b,
        kSsangkiyeokOeRieulsios             = 0xaf8c,
        kSsangkiyeokOeRieulthieuth          = 0xaf8d,
        kSsangkiyeokOeRieulphieuph          = 0xaf8e,
        kSsangkiyeokOeRieulhieuh            = 0xaf8f,
        kSsangkiyeokOeMieum                 = 0xaf90,
        kSsangkiyeokOePieup                 = 0xaf91,
        kSsangkiyeokOePieupsios             = 0xaf92,
        kSsangkiyeokOeSios                  = 0xaf93,
        kSsangkiyeokOeSsangsios             = 0xaf94,
        kSsangkiyeokOeIeung                 = 0xaf95,
        kSsangkiyeokOeCieuc                 = 0xaf96,
        kSsangkiyeokOeChieuch               = 0xaf97,
        kSsangkiyeokOeKhieukh               = 0xaf98,
        kSsangkiyeokOeThieuth               = 0xaf99,
        kSsangkiyeokOePhieuph               = 0xaf9a,
        kSsangkiyeokOeHieuh                 = 0xaf9b,
        kSsangkiyeokYo                      = 0xaf9c,
        kSsangkiyeokYoKiyeok                = 0xaf9d,
        kSsangkiyeokYoSsangkiyeok           = 0xaf9e,
        kSsangkiyeokYoKiyeoksios            = 0xaf9f,
        kSsangkiyeokYoNieun                 = 0xafa0,
        kSsangkiyeokYoNieuncieuc            = 0xafa1,
        kSsangkiyeokYoNieunhieuh            = 0xafa2,
        kSsangkiyeokYoTikeut                = 0xafa3,
        kSsangkiyeokYoRieul                 = 0xafa4,
        kSsangkiyeokYoRieulkiyeok           = 0xafa5,
        kSsangkiyeokYoRieulmieum            = 0xafa6,
        kSsangkiyeokYoRieulpieup            = 0xafa7,
        kSsangkiyeokYoRieulsios             = 0xafa8,
        kSsangkiyeokYoRieulthieuth          = 0xafa9,
        kSsangkiyeokYoRieulphieuph          = 0xafaa,
        kSsangkiyeokYoRieulhieuh            = 0xafab,
        kSsangkiyeokYoMieum                 = 0xafac,
        kSsangkiyeokYoPieup                 = 0xafad,
        kSsangkiyeokYoPieupsios             = 0xafae,
        kSsangkiyeokYoSios                  = 0xafaf,
        kSsangkiyeokYoSsangsios             = 0xafb0,
        kSsangkiyeokYoIeung                 = 0xafb1,
        kSsangkiyeokYoCieuc                 = 0xafb2,
        kSsangkiyeokYoChieuch               = 0xafb3,
        kSsangkiyeokYoKhieukh               = 0xafb4,
        kSsangkiyeokYoThieuth               = 0xafb5,
        kSsangkiyeokYoPhieuph               = 0xafb6,
        kSsangkiyeokYoHieuh                 = 0xafb7,
        kSsangkiyeokU                       = 0xafb8,
        kSsangkiyeokUKiyeok                 = 0xafb9,
        kSsangkiyeokUSsangkiyeok            = 0xafba,
        kSsangkiyeokUKiyeoksios             = 0xafbb,
        kSsangkiyeokUNieun                  = 0xafbc,
        kSsangkiyeokUNieuncieuc             = 0xafbd,
        kSsangkiyeokUNieunhieuh             = 0xafbe,
        kSsangkiyeokUTikeut                 = 0xafbf,
        kSsangkiyeokURieul                  = 0xafc0,
        kSsangkiyeokURieulkiyeok            = 0xafc1,
        kSsangkiyeokURieulmieum             = 0xafc2,
        kSsangkiyeokURieulpieup             = 0xafc3,
        kSsangkiyeokURieulsios              = 0xafc4,
        kSsangkiyeokURieulthieuth           = 0xafc5,
        kSsangkiyeokURieulphieuph           = 0xafc6,
        kSsangkiyeokURieulhieuh             = 0xafc7,
        kSsangkiyeokUMieum                  = 0xafc8,
        kSsangkiyeokUPieup                  = 0xafc9,
        kSsangkiyeokUPieupsios              = 0xafca,
        kSsangkiyeokUSios                   = 0xafcb,
        kSsangkiyeokUSsangsios              = 0xafcc,
        kSsangkiyeokUIeung                  = 0xafcd,
        kSsangkiyeokUCieuc                  = 0xafce,
        kSsangkiyeokUChieuch                = 0xafcf,
        kSsangkiyeokUKhieukh                = 0xafd0,
        kSsangkiyeokUThieuth                = 0xafd1,
        kSsangkiyeokUPhieuph                = 0xafd2,
        kSsangkiyeokUHieuh                  = 0xafd3,
        kSsangkiyeokWeo                     = 0xafd4,
        kSsangkiyeokWeoKiyeok               = 0xafd5,
        kSsangkiyeokWeoSsangkiyeok          = 0xafd6,
        kSsangkiyeokWeoKiyeoksios           = 0xafd7,
        kSsangkiyeokWeoNieun                = 0xafd8,
        kSsangkiyeokWeoNieuncieuc           = 0xafd9,
        kSsangkiyeokWeoNieunhieuh           = 0xafda,
        kSsangkiyeokWeoTikeut               = 0xafdb,
        kSsangkiyeokWeoRieul                = 0xafdc,
        kSsangkiyeokWeoRieulkiyeok          = 0xafdd,
        kSsangkiyeokWeoRieulmieum           = 0xafde,
        kSsangkiyeokWeoRieulpieup           = 0xafdf,
        kSsangkiyeokWeoRieulsios            = 0xafe0,
        kSsangkiyeokWeoRieulthieuth         = 0xafe1,
        kSsangkiyeokWeoRieulphieuph         = 0xafe2,
        kSsangkiyeokWeoRieulhieuh           = 0xafe3,
        kSsangkiyeokWeoMieum                = 0xafe4,
        kSsangkiyeokWeoPieup                = 0xafe5,
        kSsangkiyeokWeoPieupsios            = 0xafe6,
        kSsangkiyeokWeoSios                 = 0xafe7,
        kSsangkiyeokWeoSsangsios            = 0xafe8,
        kSsangkiyeokWeoIeung                = 0xafe9,
        kSsangkiyeokWeoCieuc                = 0xafea,
        kSsangkiyeokWeoChieuch              = 0xafeb,
        kSsangkiyeokWeoKhieukh              = 0xafec,
        kSsangkiyeokWeoThieuth              = 0xafed,
        kSsangkiyeokWeoPhieuph              = 0xafee,
        kSsangkiyeokWeoHieuh                = 0xafef,
        kSsangkiyeokWe                      = 0xaff0,
        kSsangkiyeokWeKiyeok                = 0xaff1,
        kSsangkiyeokWeSsangkiyeok           = 0xaff2,
        kSsangkiyeokWeKiyeoksios            = 0xaff3,
        kSsangkiyeokWeNieun                 = 0xaff4,
        kSsangkiyeokWeNieuncieuc            = 0xaff5,
        kSsangkiyeokWeNieunhieuh            = 0xaff6,
        kSsangkiyeokWeTikeut                = 0xaff7,
        kSsangkiyeokWeRieul                 = 0xaff8,
        kSsangkiyeokWeRieulkiyeok           = 0xaff9,
        kSsangkiyeokWeRieulmieum            = 0xaffa,
        kSsangkiyeokWeRieulpieup            = 0xaffb,
        kSsangkiyeokWeRieulsios             = 0xaffc,
        kSsangkiyeokWeRieulthieuth          = 0xaffd,
        kSsangkiyeokWeRieulphieuph          = 0xaffe,
        kSsangkiyeokWeRieulhieuh            = 0xafff,
        kSsangkiyeokWeMieum                 = 0xb000,
        kSsangkiyeokWePieup                 = 0xb001,
        kSsangkiyeokWePieupsios             = 0xb002,
        kSsangkiyeokWeSios                  = 0xb003,
        kSsangkiyeokWeSsangsios             = 0xb004,
        kSsangkiyeokWeIeung                 = 0xb005,
        kSsangkiyeokWeCieuc                 = 0xb006,
        kSsangkiyeokWeChieuch               = 0xb007,
        kSsangkiyeokWeKhieukh               = 0xb008,
        kSsangkiyeokWeThieuth               = 0xb009,
        kSsangkiyeokWePhieuph               = 0xb00a,
        kSsangkiyeokWeHieuh                 = 0xb00b,
        kSsangkiyeokWi                      = 0xb00c,
        kSsangkiyeokWiKiyeok                = 0xb00d,
        kSsangkiyeokWiSsangkiyeok           = 0xb00e,
        kSsangkiyeokWiKiyeoksios            = 0xb00f,
        kSsangkiyeokWiNieun                 = 0xb010,
        kSsangkiyeokWiNieuncieuc            = 0xb011,
        kSsangkiyeokWiNieunhieuh            = 0xb012,
        kSsangkiyeokWiTikeut                = 0xb013,
        kSsangkiyeokWiRieul                 = 0xb014,
        kSsangkiyeokWiRieulkiyeok           = 0xb015,
        kSsangkiyeokWiRieulmieum            = 0xb016,
        kSsangkiyeokWiRieulpieup            = 0xb017,
        kSsangkiyeokWiRieulsios             = 0xb018,
        kSsangkiyeokWiRieulthieuth          = 0xb019,
        kSsangkiyeokWiRieulphieuph          = 0xb01a,
        kSsangkiyeokWiRieulhieuh            = 0xb01b,
        kSsangkiyeokWiMieum                 = 0xb01c,
        kSsangkiyeokWiPieup                 = 0xb01d,
        kSsangkiyeokWiPieupsios             = 0xb01e,
        kSsangkiyeokWiSios                  = 0xb01f,
        kSsangkiyeokWiSsangsios             = 0xb020,
        kSsangkiyeokWiIeung                 = 0xb021,
        kSsangkiyeokWiCieuc                 = 0xb022,
        kSsangkiyeokWiChieuch               = 0xb023,
        kSsangkiyeokWiKhieukh               = 0xb024,
        kSsangkiyeokWiThieuth               = 0xb025,
        kSsangkiyeokWiPhieuph               = 0xb026,
        kSsangkiyeokWiHieuh                 = 0xb027,
        kSsangkiyeokYu                      = 0xb028,
        kSsangkiyeokYuKiyeok                = 0xb029,
        kSsangkiyeokYuSsangkiyeok           = 0xb02a,
        kSsangkiyeokYuKiyeoksios            = 0xb02b,
        kSsangkiyeokYuNieun                 = 0xb02c,
        kSsangkiyeokYuNieuncieuc            = 0xb02d,
        kSsangkiyeokYuNieunhieuh            = 0xb02e,
        kSsangkiyeokYuTikeut                = 0xb02f,
        kSsangkiyeokYuRieul                 = 0xb030,
        kSsangkiyeokYuRieulkiyeok           = 0xb031,
        kSsangkiyeokYuRieulmieum            = 0xb032,
        kSsangkiyeokYuRieulpieup            = 0xb033,
        kSsangkiyeokYuRieulsios             = 0xb034,
        kSsangkiyeokYuRieulthieuth          = 0xb035,
        kSsangkiyeokYuRieulphieuph          = 0xb036,
        kSsangkiyeokYuRieulhieuh            = 0xb037,
        kSsangkiyeokYuMieum                 = 0xb038,
        kSsangkiyeokYuPieup                 = 0xb039,
        kSsangkiyeokYuPieupsios             = 0xb03a,
        kSsangkiyeokYuSios                  = 0xb03b,
        kSsangkiyeokYuSsangsios             = 0xb03c,
        kSsangkiyeokYuIeung                 = 0xb03d,
        kSsangkiyeokYuCieuc                 = 0xb03e,
        kSsangkiyeokYuChieuch               = 0xb03f,
        kSsangkiyeokYuKhieukh               = 0xb040,
        kSsangkiyeokYuThieuth               = 0xb041,
        kSsangkiyeokYuPhieuph               = 0xb042,
        kSsangkiyeokYuHieuh                 = 0xb043,
        kSsangkiyeokEu                      = 0xb044,
        kSsangkiyeokEuKiyeok                = 0xb045,
        kSsangkiyeokEuSsangkiyeok           = 0xb046,
        kSsangkiyeokEuKiyeoksios            = 0xb047,
        kSsangkiyeokEuNieun                 = 0xb048,
        kSsangkiyeokEuNieuncieuc            = 0xb049,
        kSsangkiyeokEuNieunhieuh            = 0xb04a,
        kSsangkiyeokEuTikeut                = 0xb04b,
        kSsangkiyeokEuRieul                 = 0xb04c,
        kSsangkiyeokEuRieulkiyeok           = 0xb04d,
        kSsangkiyeokEuRieulmieum            = 0xb04e,
        kSsangkiyeokEuRieulpieup            = 0xb04f,
        kSsangkiyeokEuRieulsios             = 0xb050,
        kSsangkiyeokEuRieulthieuth          = 0xb051,
        kSsangkiyeokEuRieulphieuph          = 0xb052,
        kSsangkiyeokEuRieulhieuh            = 0xb053,
        kSsangkiyeokEuMieum                 = 0xb054,
        kSsangkiyeokEuPieup                 = 0xb055,
        kSsangkiyeokEuPieupsios             = 0xb056,
        kSsangkiyeokEuSios                  = 0xb057,
        kSsangkiyeokEuSsangsios             = 0xb058,
        kSsangkiyeokEuIeung                 = 0xb059,
        kSsangkiyeokEuCieuc                 = 0xb05a,
        kSsangkiyeokEuChieuch               = 0xb05b,
        kSsangkiyeokEuKhieukh               = 0xb05c,
        kSsangkiyeokEuThieuth               = 0xb05d,
        kSsangkiyeokEuPhieuph               = 0xb05e,
        kSsangkiyeokEuHieuh                 = 0xb05f,
        kSsangkiyeokYi                      = 0xb060,
        kSsangkiyeokYiKiyeok                = 0xb061,
        kSsangkiyeokYiSsangkiyeok           = 0xb062,
        kSsangkiyeokYiKiyeoksios            = 0xb063,
        kSsangkiyeokYiNieun                 = 0xb064,
        kSsangkiyeokYiNieuncieuc            = 0xb065,
        kSsangkiyeokYiNieunhieuh            = 0xb066,
        kSsangkiyeokYiTikeut                = 0xb067,
        kSsangkiyeokYiRieul                 = 0xb068,
        kSsangkiyeokYiRieulkiyeok           = 0xb069,
        kSsangkiyeokYiRieulmieum            = 0xb06a,
        kSsangkiyeokYiRieulpieup            = 0xb06b,
        kSsangkiyeokYiRieulsios             = 0xb06c,
        kSsangkiyeokYiRieulthieuth          = 0xb06d,
        kSsangkiyeokYiRieulphieuph          = 0xb06e,
        kSsangkiyeokYiRieulhieuh            = 0xb06f,
        kSsangkiyeokYiMieum                 = 0xb070,
        kSsangkiyeokYiPieup                 = 0xb071,
        kSsangkiyeokYiPieupsios             = 0xb072,
        kSsangkiyeokYiSios                  = 0xb073,
        kSsangkiyeokYiSsangsios             = 0xb074,
        kSsangkiyeokYiIeung                 = 0xb075,
        kSsangkiyeokYiCieuc                 = 0xb076,
        kSsangkiyeokYiChieuch               = 0xb077,
        kSsangkiyeokYiKhieukh               = 0xb078,
        kSsangkiyeokYiThieuth               = 0xb079,
        kSsangkiyeokYiPhieuph               = 0xb07a,
        kSsangkiyeokYiHieuh                 = 0xb07b,
        kSsangkiyeokI                       = 0xb07c,
        kSsangkiyeokIKiyeok                 = 0xb07d,
        kSsangkiyeokISsangkiyeok            = 0xb07e,
        kSsangkiyeokIKiyeoksios             = 0xb07f,
        kSsangkiyeokINieun                  = 0xb080,
        kSsangkiyeokINieuncieuc             = 0xb081,
        kSsangkiyeokINieunhieuh             = 0xb082,
        kSsangkiyeokITikeut                 = 0xb083,
        kSsangkiyeokIRieul                  = 0xb084,
        kSsangkiyeokIRieulkiyeok            = 0xb085,
        kSsangkiyeokIRieulmieum             = 0xb086,
        kSsangkiyeokIRieulpieup             = 0xb087,
        kSsangkiyeokIRieulsios              = 0xb088,
        kSsangkiyeokIRieulthieuth           = 0xb089,
        kSsangkiyeokIRieulphieuph           = 0xb08a,
        kSsangkiyeokIRieulhieuh             = 0xb08b,
        kSsangkiyeokIMieum                  = 0xb08c,
        kSsangkiyeokIPieup                  = 0xb08d,
        kSsangkiyeokIPieupsios              = 0xb08e,
        kSsangkiyeokISios                   = 0xb08f,
        kSsangkiyeokISsangsios              = 0xb090,
        kSsangkiyeokIIeung                  = 0xb091,
        kSsangkiyeokICieuc                  = 0xb092,
        kSsangkiyeokIChieuch                = 0xb093,
        kSsangkiyeokIKhieukh                = 0xb094,
        kSsangkiyeokIThieuth                = 0xb095,
        kSsangkiyeokIPhieuph                = 0xb096,
        kSsangkiyeokIHieuh                  = 0xb097,
        kNieunA                             = 0xb098,
        kNieunAKiyeok                       = 0xb099,
        kNieunASsangkiyeok                  = 0xb09a,
        kNieunAKiyeoksios                   = 0xb09b,
        kNieunANieun                        = 0xb09c,
        kNieunANieuncieuc                   = 0xb09d,
        kNieunANieunhieuh                   = 0xb09e,
        kNieunATikeut                       = 0xb09f,
        kNieunARieul                        = 0xb0a0,
        kNieunARieulkiyeok                  = 0xb0a1,
        kNieunARieulmieum                   = 0xb0a2,
        kNieunARieulpieup                   = 0xb0a3,
        kNieunARieulsios                    = 0xb0a4,
        kNieunARieulthieuth                 = 0xb0a5,
        kNieunARieulphieuph                 = 0xb0a6,
        kNieunARieulhieuh                   = 0xb0a7,
        kNieunAMieum                        = 0xb0a8,
        kNieunAPieup                        = 0xb0a9,
        kNieunAPieupsios                    = 0xb0aa,
        kNieunASios                         = 0xb0ab,
        kNieunASsangsios                    = 0xb0ac,
        kNieunAIeung                        = 0xb0ad,
        kNieunACieuc                        = 0xb0ae,
        kNieunAChieuch                      = 0xb0af,
        kNieunAKhieukh                      = 0xb0b0,
        kNieunAThieuth                      = 0xb0b1,
        kNieunAPhieuph                      = 0xb0b2,
        kNieunAHieuh                        = 0xb0b3,
        kNieunAe                            = 0xb0b4,
        kNieunAeKiyeok                      = 0xb0b5,
        kNieunAeSsangkiyeok                 = 0xb0b6,
        kNieunAeKiyeoksios                  = 0xb0b7,
        kNieunAeNieun                       = 0xb0b8,
        kNieunAeNieuncieuc                  = 0xb0b9,
        kNieunAeNieunhieuh                  = 0xb0ba,
        kNieunAeTikeut                      = 0xb0bb,
        kNieunAeRieul                       = 0xb0bc,
        kNieunAeRieulkiyeok                 = 0xb0bd,
        kNieunAeRieulmieum                  = 0xb0be,
        kNieunAeRieulpieup                  = 0xb0bf,
        kNieunAeRieulsios                   = 0xb0c0,
        kNieunAeRieulthieuth                = 0xb0c1,
        kNieunAeRieulphieuph                = 0xb0c2,
        kNieunAeRieulhieuh                  = 0xb0c3,
        kNieunAeMieum                       = 0xb0c4,
        kNieunAePieup                       = 0xb0c5,
        kNieunAePieupsios                   = 0xb0c6,
        kNieunAeSios                        = 0xb0c7,
        kNieunAeSsangsios                   = 0xb0c8,
        kNieunAeIeung                       = 0xb0c9,
        kNieunAeCieuc                       = 0xb0ca,
        kNieunAeChieuch                     = 0xb0cb,
        kNieunAeKhieukh                     = 0xb0cc,
        kNieunAeThieuth                     = 0xb0cd,
        kNieunAePhieuph                     = 0xb0ce,
        kNieunAeHieuh                       = 0xb0cf,
        kNieunYa                            = 0xb0d0,
        kNieunYaKiyeok                      = 0xb0d1,
        kNieunYaSsangkiyeok                 = 0xb0d2,
        kNieunYaKiyeoksios                  = 0xb0d3,
        kNieunYaNieun                       = 0xb0d4,
        kNieunYaNieuncieuc                  = 0xb0d5,
        kNieunYaNieunhieuh                  = 0xb0d6,
        kNieunYaTikeut                      = 0xb0d7,
        kNieunYaRieul                       = 0xb0d8,
        kNieunYaRieulkiyeok                 = 0xb0d9,
        kNieunYaRieulmieum                  = 0xb0da,
        kNieunYaRieulpieup                  = 0xb0db,
        kNieunYaRieulsios                   = 0xb0dc,
        kNieunYaRieulthieuth                = 0xb0dd,
        kNieunYaRieulphieuph                = 0xb0de,
        kNieunYaRieulhieuh                  = 0xb0df,
        kNieunYaMieum                       = 0xb0e0,
        kNieunYaPieup                       = 0xb0e1,
        kNieunYaPieupsios                   = 0xb0e2,
        kNieunYaSios                        = 0xb0e3,
        kNieunYaSsangsios                   = 0xb0e4,
        kNieunYaIeung                       = 0xb0e5,
        kNieunYaCieuc                       = 0xb0e6,
        kNieunYaChieuch                     = 0xb0e7,
        kNieunYaKhieukh                     = 0xb0e8,
        kNieunYaThieuth                     = 0xb0e9,
        kNieunYaPhieuph                     = 0xb0ea,
        kNieunYaHieuh                       = 0xb0eb,
        kNieunYae                           = 0xb0ec,
        kNieunYaeKiyeok                     = 0xb0ed,
        kNieunYaeSsangkiyeok                = 0xb0ee,
        kNieunYaeKiyeoksios                 = 0xb0ef,
        kNieunYaeNieun                      = 0xb0f0,
        kNieunYaeNieuncieuc                 = 0xb0f1,
        kNieunYaeNieunhieuh                 = 0xb0f2,
        kNieunYaeTikeut                     = 0xb0f3,
        kNieunYaeRieul                      = 0xb0f4,
        kNieunYaeRieulkiyeok                = 0xb0f5,
        kNieunYaeRieulmieum                 = 0xb0f6,
        kNieunYaeRieulpieup                 = 0xb0f7,
        kNieunYaeRieulsios                  = 0xb0f8,
        kNieunYaeRieulthieuth               = 0xb0f9,
        kNieunYaeRieulphieuph               = 0xb0fa,
        kNieunYaeRieulhieuh                 = 0xb0fb,
        kNieunYaeMieum                      = 0xb0fc,
        kNieunYaePieup                      = 0xb0fd,
        kNieunYaePieupsios                  = 0xb0fe,
        kNieunYaeSios                       = 0xb0ff,
        kNieunYaeSsangsios                  = 0xb100,
        kNieunYaeIeung                      = 0xb101,
        kNieunYaeCieuc                      = 0xb102,
        kNieunYaeChieuch                    = 0xb103,
        kNieunYaeKhieukh                    = 0xb104,
        kNieunYaeThieuth                    = 0xb105,
        kNieunYaePhieuph                    = 0xb106,
        kNieunYaeHieuh                      = 0xb107,
        kNieunEo                            = 0xb108,
        kNieunEoKiyeok                      = 0xb109,
        kNieunEoSsangkiyeok                 = 0xb10a,
        kNieunEoKiyeoksios                  = 0xb10b,
        kNieunEoNieun                       = 0xb10c,
        kNieunEoNieuncieuc                  = 0xb10d,
        kNieunEoNieunhieuh                  = 0xb10e,
        kNieunEoTikeut                      = 0xb10f,
        kNieunEoRieul                       = 0xb110,
        kNieunEoRieulkiyeok                 = 0xb111,
        kNieunEoRieulmieum                  = 0xb112,
        kNieunEoRieulpieup                  = 0xb113,
        kNieunEoRieulsios                   = 0xb114,
        kNieunEoRieulthieuth                = 0xb115,
        kNieunEoRieulphieuph                = 0xb116,
        kNieunEoRieulhieuh                  = 0xb117,
        kNieunEoMieum                       = 0xb118,
        kNieunEoPieup                       = 0xb119,
        kNieunEoPieupsios                   = 0xb11a,
        kNieunEoSios                        = 0xb11b,
        kNieunEoSsangsios                   = 0xb11c,
        kNieunEoIeung                       = 0xb11d,
        kNieunEoCieuc                       = 0xb11e,
        kNieunEoChieuch                     = 0xb11f,
        kNieunEoKhieukh                     = 0xb120,
        kNieunEoThieuth                     = 0xb121,
        kNieunEoPhieuph                     = 0xb122,
        kNieunEoHieuh                       = 0xb123,
        kNieunE                             = 0xb124,
        kNieunEKiyeok                       = 0xb125,
        kNieunESsangkiyeok                  = 0xb126,
        kNieunEKiyeoksios                   = 0xb127,
        kNieunENieun                        = 0xb128,
        kNieunENieuncieuc                   = 0xb129,
        kNieunENieunhieuh                   = 0xb12a,
        kNieunETikeut                       = 0xb12b,
        kNieunERieul                        = 0xb12c,
        kNieunERieulkiyeok                  = 0xb12d,
        kNieunERieulmieum                   = 0xb12e,
        kNieunERieulpieup                   = 0xb12f,
        kNieunERieulsios                    = 0xb130,
        kNieunERieulthieuth                 = 0xb131,
        kNieunERieulphieuph                 = 0xb132,
        kNieunERieulhieuh                   = 0xb133,
        kNieunEMieum                        = 0xb134,
        kNieunEPieup                        = 0xb135,
        kNieunEPieupsios                    = 0xb136,
        kNieunESios                         = 0xb137,
        kNieunESsangsios                    = 0xb138,
        kNieunEIeung                        = 0xb139,
        kNieunECieuc                        = 0xb13a,
        kNieunEChieuch                      = 0xb13b,
        kNieunEKhieukh                      = 0xb13c,
        kNieunEThieuth                      = 0xb13d,
        kNieunEPhieuph                      = 0xb13e,
        kNieunEHieuh                        = 0xb13f,
        kNieunYeo                           = 0xb140,
        kNieunYeoKiyeok                     = 0xb141,
        kNieunYeoSsangkiyeok                = 0xb142,
        kNieunYeoKiyeoksios                 = 0xb143,
        kNieunYeoNieun                      = 0xb144,
        kNieunYeoNieuncieuc                 = 0xb145,
        kNieunYeoNieunhieuh                 = 0xb146,
        kNieunYeoTikeut                     = 0xb147,
        kNieunYeoRieul                      = 0xb148,
        kNieunYeoRieulkiyeok                = 0xb149,
        kNieunYeoRieulmieum                 = 0xb14a,
        kNieunYeoRieulpieup                 = 0xb14b,
        kNieunYeoRieulsios                  = 0xb14c,
        kNieunYeoRieulthieuth               = 0xb14d,
        kNieunYeoRieulphieuph               = 0xb14e,
        kNieunYeoRieulhieuh                 = 0xb14f,
        kNieunYeoMieum                      = 0xb150,
        kNieunYeoPieup                      = 0xb151,
        kNieunYeoPieupsios                  = 0xb152,
        kNieunYeoSios                       = 0xb153,
        kNieunYeoSsangsios                  = 0xb154,
        kNieunYeoIeung                      = 0xb155,
        kNieunYeoCieuc                      = 0xb156,
        kNieunYeoChieuch                    = 0xb157,
        kNieunYeoKhieukh                    = 0xb158,
        kNieunYeoThieuth                    = 0xb159,
        kNieunYeoPhieuph                    = 0xb15a,
        kNieunYeoHieuh                      = 0xb15b,
        kNieunYe                            = 0xb15c,
        kNieunYeKiyeok                      = 0xb15d,
        kNieunYeSsangkiyeok                 = 0xb15e,
        kNieunYeKiyeoksios                  = 0xb15f,
        kNieunYeNieun                       = 0xb160,
        kNieunYeNieuncieuc                  = 0xb161,
        kNieunYeNieunhieuh                  = 0xb162,
        kNieunYeTikeut                      = 0xb163,
        kNieunYeRieul                       = 0xb164,
        kNieunYeRieulkiyeok                 = 0xb165,
        kNieunYeRieulmieum                  = 0xb166,
        kNieunYeRieulpieup                  = 0xb167,
        kNieunYeRieulsios                   = 0xb168,
        kNieunYeRieulthieuth                = 0xb169,
        kNieunYeRieulphieuph                = 0xb16a,
        kNieunYeRieulhieuh                  = 0xb16b,
        kNieunYeMieum                       = 0xb16c,
        kNieunYePieup                       = 0xb16d,
        kNieunYePieupsios                   = 0xb16e,
        kNieunYeSios                        = 0xb16f,
        kNieunYeSsangsios                   = 0xb170,
        kNieunYeIeung                       = 0xb171,
        kNieunYeCieuc                       = 0xb172,
        kNieunYeChieuch                     = 0xb173,
        kNieunYeKhieukh                     = 0xb174,
        kNieunYeThieuth                     = 0xb175,
        kNieunYePhieuph                     = 0xb176,
        kNieunYeHieuh                       = 0xb177,
        kNieunO                             = 0xb178,
        kNieunOKiyeok                       = 0xb179,
        kNieunOSsangkiyeok                  = 0xb17a,
        kNieunOKiyeoksios                   = 0xb17b,
        kNieunONieun                        = 0xb17c,
        kNieunONieuncieuc                   = 0xb17d,
        kNieunONieunhieuh                   = 0xb17e,
        kNieunOTikeut                       = 0xb17f,
        kNieunORieul                        = 0xb180,
        kNieunORieulkiyeok                  = 0xb181,
        kNieunORieulmieum                   = 0xb182,
        kNieunORieulpieup                   = 0xb183,
        kNieunORieulsios                    = 0xb184,
        kNieunORieulthieuth                 = 0xb185,
        kNieunORieulphieuph                 = 0xb186,
        kNieunORieulhieuh                   = 0xb187,
        kNieunOMieum                        = 0xb188,
        kNieunOPieup                        = 0xb189,
        kNieunOPieupsios                    = 0xb18a,
        kNieunOSios                         = 0xb18b,
        kNieunOSsangsios                    = 0xb18c,
        kNieunOIeung                        = 0xb18d,
        kNieunOCieuc                        = 0xb18e,
        kNieunOChieuch                      = 0xb18f,
        kNieunOKhieukh                      = 0xb190,
        kNieunOThieuth                      = 0xb191,
        kNieunOPhieuph                      = 0xb192,
        kNieunOHieuh                        = 0xb193,
        kNieunWa                            = 0xb194,
        kNieunWaKiyeok                      = 0xb195,
        kNieunWaSsangkiyeok                 = 0xb196,
        kNieunWaKiyeoksios                  = 0xb197,
        kNieunWaNieun                       = 0xb198,
        kNieunWaNieuncieuc                  = 0xb199,
        kNieunWaNieunhieuh                  = 0xb19a,
        kNieunWaTikeut                      = 0xb19b,
        kNieunWaRieul                       = 0xb19c,
        kNieunWaRieulkiyeok                 = 0xb19d,
        kNieunWaRieulmieum                  = 0xb19e,
        kNieunWaRieulpieup                  = 0xb19f,
        kNieunWaRieulsios                   = 0xb1a0,
        kNieunWaRieulthieuth                = 0xb1a1,
        kNieunWaRieulphieuph                = 0xb1a2,
        kNieunWaRieulhieuh                  = 0xb1a3,
        kNieunWaMieum                       = 0xb1a4,
        kNieunWaPieup                       = 0xb1a5,
        kNieunWaPieupsios                   = 0xb1a6,
        kNieunWaSios                        = 0xb1a7,
        kNieunWaSsangsios                   = 0xb1a8,
        kNieunWaIeung                       = 0xb1a9,
        kNieunWaCieuc                       = 0xb1aa,
        kNieunWaChieuch                     = 0xb1ab,
        kNieunWaKhieukh                     = 0xb1ac,
        kNieunWaThieuth                     = 0xb1ad,
        kNieunWaPhieuph                     = 0xb1ae,
        kNieunWaHieuh                       = 0xb1af,
        kNieunWae                           = 0xb1b0,
        kNieunWaeKiyeok                     = 0xb1b1,
        kNieunWaeSsangkiyeok                = 0xb1b2,
        kNieunWaeKiyeoksios                 = 0xb1b3,
        kNieunWaeNieun                      = 0xb1b4,
        kNieunWaeNieuncieuc                 = 0xb1b5,
        kNieunWaeNieunhieuh                 = 0xb1b6,
        kNieunWaeTikeut                     = 0xb1b7,
        kNieunWaeRieul                      = 0xb1b8,
        kNieunWaeRieulkiyeok                = 0xb1b9,
        kNieunWaeRieulmieum                 = 0xb1ba,
        kNieunWaeRieulpieup                 = 0xb1bb,
        kNieunWaeRieulsios                  = 0xb1bc,
        kNieunWaeRieulthieuth               = 0xb1bd,
        kNieunWaeRieulphieuph               = 0xb1be,
        kNieunWaeRieulhieuh                 = 0xb1bf,
        kNieunWaeMieum                      = 0xb1c0,
        kNieunWaePieup                      = 0xb1c1,
        kNieunWaePieupsios                  = 0xb1c2,
        kNieunWaeSios                       = 0xb1c3,
        kNieunWaeSsangsios                  = 0xb1c4,
        kNieunWaeIeung                      = 0xb1c5,
        kNieunWaeCieuc                      = 0xb1c6,
        kNieunWaeChieuch                    = 0xb1c7,
        kNieunWaeKhieukh                    = 0xb1c8,
        kNieunWaeThieuth                    = 0xb1c9,
        kNieunWaePhieuph                    = 0xb1ca,
        kNieunWaeHieuh                      = 0xb1cb,
        kNieunOe                            = 0xb1cc,
        kNieunOeKiyeok                      = 0xb1cd,
        kNieunOeSsangkiyeok                 = 0xb1ce,
        kNieunOeKiyeoksios                  = 0xb1cf,
        kNieunOeNieun                       = 0xb1d0,
        kNieunOeNieuncieuc                  = 0xb1d1,
        kNieunOeNieunhieuh                  = 0xb1d2,
        kNieunOeTikeut                      = 0xb1d3,
        kNieunOeRieul                       = 0xb1d4,
        kNieunOeRieulkiyeok                 = 0xb1d5,
        kNieunOeRieulmieum                  = 0xb1d6,
        kNieunOeRieulpieup                  = 0xb1d7,
        kNieunOeRieulsios                   = 0xb1d8,
        kNieunOeRieulthieuth                = 0xb1d9,
        kNieunOeRieulphieuph                = 0xb1da,
        kNieunOeRieulhieuh                  = 0xb1db,
        kNieunOeMieum                       = 0xb1dc,
        kNieunOePieup                       = 0xb1dd,
        kNieunOePieupsios                   = 0xb1de,
        kNieunOeSios                        = 0xb1df,
        kNieunOeSsangsios                   = 0xb1e0,
        kNieunOeIeung                       = 0xb1e1,
        kNieunOeCieuc                       = 0xb1e2,
        kNieunOeChieuch                     = 0xb1e3,
        kNieunOeKhieukh                     = 0xb1e4,
        kNieunOeThieuth                     = 0xb1e5,
        kNieunOePhieuph                     = 0xb1e6,
        kNieunOeHieuh                       = 0xb1e7,
        kNieunYo                            = 0xb1e8,
        kNieunYoKiyeok                      = 0xb1e9,
        kNieunYoSsangkiyeok                 = 0xb1ea,
        kNieunYoKiyeoksios                  = 0xb1eb,
        kNieunYoNieun                       = 0xb1ec,
        kNieunYoNieuncieuc                  = 0xb1ed,
        kNieunYoNieunhieuh                  = 0xb1ee,
        kNieunYoTikeut                      = 0xb1ef,
        kNieunYoRieul                       = 0xb1f0,
        kNieunYoRieulkiyeok                 = 0xb1f1,
        kNieunYoRieulmieum                  = 0xb1f2,
        kNieunYoRieulpieup                  = 0xb1f3,
        kNieunYoRieulsios                   = 0xb1f4,
        kNieunYoRieulthieuth                = 0xb1f5,
        kNieunYoRieulphieuph                = 0xb1f6,
        kNieunYoRieulhieuh                  = 0xb1f7,
        kNieunYoMieum                       = 0xb1f8,
        kNieunYoPieup                       = 0xb1f9,
        kNieunYoPieupsios                   = 0xb1fa,
        kNieunYoSios                        = 0xb1fb,
        kNieunYoSsangsios                   = 0xb1fc,
        kNieunYoIeung                       = 0xb1fd,
        kNieunYoCieuc                       = 0xb1fe,
        kNieunYoChieuch                     = 0xb1ff,
        kNieunYoKhieukh                     = 0xb200,
        kNieunYoThieuth                     = 0xb201,
        kNieunYoPhieuph                     = 0xb202,
        kNieunYoHieuh                       = 0xb203,
        kNieunU                             = 0xb204,
        kNieunUKiyeok                       = 0xb205,
        kNieunUSsangkiyeok                  = 0xb206,
        kNieunUKiyeoksios                   = 0xb207,
        kNieunUNieun                        = 0xb208,
        kNieunUNieuncieuc                   = 0xb209,
        kNieunUNieunhieuh                   = 0xb20a,
        kNieunUTikeut                       = 0xb20b,
        kNieunURieul                        = 0xb20c,
        kNieunURieulkiyeok                  = 0xb20d,
        kNieunURieulmieum                   = 0xb20e,
        kNieunURieulpieup                   = 0xb20f,
        kNieunURieulsios                    = 0xb210,
        kNieunURieulthieuth                 = 0xb211,
        kNieunURieulphieuph                 = 0xb212,
        kNieunURieulhieuh                   = 0xb213,
        kNieunUMieum                        = 0xb214,
        kNieunUPieup                        = 0xb215,
        kNieunUPieupsios                    = 0xb216,
        kNieunUSios                         = 0xb217,
        kNieunUSsangsios                    = 0xb218,
        kNieunUIeung                        = 0xb219,
        kNieunUCieuc                        = 0xb21a,
        kNieunUChieuch                      = 0xb21b,
        kNieunUKhieukh                      = 0xb21c,
        kNieunUThieuth                      = 0xb21d,
        kNieunUPhieuph                      = 0xb21e,
        kNieunUHieuh                        = 0xb21f,
        kNieunWeo                           = 0xb220,
        kNieunWeoKiyeok                     = 0xb221,
        kNieunWeoSsangkiyeok                = 0xb222,
        kNieunWeoKiyeoksios                 = 0xb223,
        kNieunWeoNieun                      = 0xb224,
        kNieunWeoNieuncieuc                 = 0xb225,
        kNieunWeoNieunhieuh                 = 0xb226,
        kNieunWeoTikeut                     = 0xb227,
        kNieunWeoRieul                      = 0xb228,
        kNieunWeoRieulkiyeok                = 0xb229,
        kNieunWeoRieulmieum                 = 0xb22a,
        kNieunWeoRieulpieup                 = 0xb22b,
        kNieunWeoRieulsios                  = 0xb22c,
        kNieunWeoRieulthieuth               = 0xb22d,
        kNieunWeoRieulphieuph               = 0xb22e,
        kNieunWeoRieulhieuh                 = 0xb22f,
        kNieunWeoMieum                      = 0xb230,
        kNieunWeoPieup                      = 0xb231,
        kNieunWeoPieupsios                  = 0xb232,
        kNieunWeoSios                       = 0xb233,
        kNieunWeoSsangsios                  = 0xb234,
        kNieunWeoIeung                      = 0xb235,
        kNieunWeoCieuc                      = 0xb236,
        kNieunWeoChieuch                    = 0xb237,
        kNieunWeoKhieukh                    = 0xb238,
        kNieunWeoThieuth                    = 0xb239,
        kNieunWeoPhieuph                    = 0xb23a,
        kNieunWeoHieuh                      = 0xb23b,
        kNieunWe                            = 0xb23c,
        kNieunWeKiyeok                      = 0xb23d,
        kNieunWeSsangkiyeok                 = 0xb23e,
        kNieunWeKiyeoksios                  = 0xb23f,
        kNieunWeNieun                       = 0xb240,
        kNieunWeNieuncieuc                  = 0xb241,
        kNieunWeNieunhieuh                  = 0xb242,
        kNieunWeTikeut                      = 0xb243,
        kNieunWeRieul                       = 0xb244,
        kNieunWeRieulkiyeok                 = 0xb245,
        kNieunWeRieulmieum                  = 0xb246,
        kNieunWeRieulpieup                  = 0xb247,
        kNieunWeRieulsios                   = 0xb248,
        kNieunWeRieulthieuth                = 0xb249,
        kNieunWeRieulphieuph                = 0xb24a,
        kNieunWeRieulhieuh                  = 0xb24b,
        kNieunWeMieum                       = 0xb24c,
        kNieunWePieup                       = 0xb24d,
        kNieunWePieupsios                   = 0xb24e,
        kNieunWeSios                        = 0xb24f,
        kNieunWeSsangsios                   = 0xb250,
        kNieunWeIeung                       = 0xb251,
        kNieunWeCieuc                       = 0xb252,
        kNieunWeChieuch                     = 0xb253,
        kNieunWeKhieukh                     = 0xb254,
        kNieunWeThieuth                     = 0xb255,
        kNieunWePhieuph                     = 0xb256,
        kNieunWeHieuh                       = 0xb257,
        kNieunWi                            = 0xb258,
        kNieunWiKiyeok                      = 0xb259,
        kNieunWiSsangkiyeok                 = 0xb25a,
        kNieunWiKiyeoksios                  = 0xb25b,
        kNieunWiNieun                       = 0xb25c,
        kNieunWiNieuncieuc                  = 0xb25d,
        kNieunWiNieunhieuh                  = 0xb25e,
        kNieunWiTikeut                      = 0xb25f,
        kNieunWiRieul                       = 0xb260,
        kNieunWiRieulkiyeok                 = 0xb261,
        kNieunWiRieulmieum                  = 0xb262,
        kNieunWiRieulpieup                  = 0xb263,
        kNieunWiRieulsios                   = 0xb264,
        kNieunWiRieulthieuth                = 0xb265,
        kNieunWiRieulphieuph                = 0xb266,
        kNieunWiRieulhieuh                  = 0xb267,
        kNieunWiMieum                       = 0xb268,
        kNieunWiPieup                       = 0xb269,
        kNieunWiPieupsios                   = 0xb26a,
        kNieunWiSios                        = 0xb26b,
        kNieunWiSsangsios                   = 0xb26c,
        kNieunWiIeung                       = 0xb26d,
        kNieunWiCieuc                       = 0xb26e,
        kNieunWiChieuch                     = 0xb26f,
        kNieunWiKhieukh                     = 0xb270,
        kNieunWiThieuth                     = 0xb271,
        kNieunWiPhieuph                     = 0xb272,
        kNieunWiHieuh                       = 0xb273,
        kNieunYu                            = 0xb274,
        kNieunYuKiyeok                      = 0xb275,
        kNieunYuSsangkiyeok                 = 0xb276,
        kNieunYuKiyeoksios                  = 0xb277,
        kNieunYuNieun                       = 0xb278,
        kNieunYuNieuncieuc                  = 0xb279,
        kNieunYuNieunhieuh                  = 0xb27a,
        kNieunYuTikeut                      = 0xb27b,
        kNieunYuRieul                       = 0xb27c,
        kNieunYuRieulkiyeok                 = 0xb27d,
        kNieunYuRieulmieum                  = 0xb27e,
        kNieunYuRieulpieup                  = 0xb27f,
        kNieunYuRieulsios                   = 0xb280,
        kNieunYuRieulthieuth                = 0xb281,
        kNieunYuRieulphieuph                = 0xb282,
        kNieunYuRieulhieuh                  = 0xb283,
        kNieunYuMieum                       = 0xb284,
        kNieunYuPieup                       = 0xb285,
        kNieunYuPieupsios                   = 0xb286,
        kNieunYuSios                        = 0xb287,
        kNieunYuSsangsios                   = 0xb288,
        kNieunYuIeung                       = 0xb289,
        kNieunYuCieuc                       = 0xb28a,
        kNieunYuChieuch                     = 0xb28b,
        kNieunYuKhieukh                     = 0xb28c,
        kNieunYuThieuth                     = 0xb28d,
        kNieunYuPhieuph                     = 0xb28e,
        kNieunYuHieuh                       = 0xb28f,
        kNieunEu                            = 0xb290,
        kNieunEuKiyeok                      = 0xb291,
        kNieunEuSsangkiyeok                 = 0xb292,
        kNieunEuKiyeoksios                  = 0xb293,
        kNieunEuNieun                       = 0xb294,
        kNieunEuNieuncieuc                  = 0xb295,
        kNieunEuNieunhieuh                  = 0xb296,
        kNieunEuTikeut                      = 0xb297,
        kNieunEuRieul                       = 0xb298,
        kNieunEuRieulkiyeok                 = 0xb299,
        kNieunEuRieulmieum                  = 0xb29a,
        kNieunEuRieulpieup                  = 0xb29b,
        kNieunEuRieulsios                   = 0xb29c,
        kNieunEuRieulthieuth                = 0xb29d,
        kNieunEuRieulphieuph                = 0xb29e,
        kNieunEuRieulhieuh                  = 0xb29f,
        kNieunEuMieum                       = 0xb2a0,
        kNieunEuPieup                       = 0xb2a1,
        kNieunEuPieupsios                   = 0xb2a2,
        kNieunEuSios                        = 0xb2a3,
        kNieunEuSsangsios                   = 0xb2a4,
        kNieunEuIeung                       = 0xb2a5,
        kNieunEuCieuc                       = 0xb2a6,
        kNieunEuChieuch                     = 0xb2a7,
        kNieunEuKhieukh                     = 0xb2a8,
        kNieunEuThieuth                     = 0xb2a9,
        kNieunEuPhieuph                     = 0xb2aa,
        kNieunEuHieuh                       = 0xb2ab,
        kNieunYi                            = 0xb2ac,
        kNieunYiKiyeok                      = 0xb2ad,
        kNieunYiSsangkiyeok                 = 0xb2ae,
        kNieunYiKiyeoksios                  = 0xb2af,
        kNieunYiNieun                       = 0xb2b0,
        kNieunYiNieuncieuc                  = 0xb2b1,
        kNieunYiNieunhieuh                  = 0xb2b2,
        kNieunYiTikeut                      = 0xb2b3,
        kNieunYiRieul                       = 0xb2b4,
        kNieunYiRieulkiyeok                 = 0xb2b5,
        kNieunYiRieulmieum                  = 0xb2b6,
        kNieunYiRieulpieup                  = 0xb2b7,
        kNieunYiRieulsios                   = 0xb2b8,
        kNieunYiRieulthieuth                = 0xb2b9,
        kNieunYiRieulphieuph                = 0xb2ba,
        kNieunYiRieulhieuh                  = 0xb2bb,
        kNieunYiMieum                       = 0xb2bc,
        kNieunYiPieup                       = 0xb2bd,
        kNieunYiPieupsios                   = 0xb2be,
        kNieunYiSios                        = 0xb2bf,
        kNieunYiSsangsios                   = 0xb2c0,
        kNieunYiIeung                       = 0xb2c1,
        kNieunYiCieuc                       = 0xb2c2,
        kNieunYiChieuch                     = 0xb2c3,
        kNieunYiKhieukh                     = 0xb2c4,
        kNieunYiThieuth                     = 0xb2c5,
        kNieunYiPhieuph                     = 0xb2c6,
        kNieunYiHieuh                       = 0xb2c7,
        kNieunI                             = 0xb2c8,
        kNieunIKiyeok                       = 0xb2c9,
        kNieunISsangkiyeok                  = 0xb2ca,
        kNieunIKiyeoksios                   = 0xb2cb,
        kNieunINieun                        = 0xb2cc,
        kNieunINieuncieuc                   = 0xb2cd,
        kNieunINieunhieuh                   = 0xb2ce,
        kNieunITikeut                       = 0xb2cf,
        kNieunIRieul                        = 0xb2d0,
        kNieunIRieulkiyeok                  = 0xb2d1,
        kNieunIRieulmieum                   = 0xb2d2,
        kNieunIRieulpieup                   = 0xb2d3,
        kNieunIRieulsios                    = 0xb2d4,
        kNieunIRieulthieuth                 = 0xb2d5,
        kNieunIRieulphieuph                 = 0xb2d6,
        kNieunIRieulhieuh                   = 0xb2d7,
        kNieunIMieum                        = 0xb2d8,
        kNieunIPieup                        = 0xb2d9,
        kNieunIPieupsios                    = 0xb2da,
        kNieunISios                         = 0xb2db,
        kNieunISsangsios                    = 0xb2dc,
        kNieunIIeung                        = 0xb2dd,
        kNieunICieuc                        = 0xb2de,
        kNieunIChieuch                      = 0xb2df,
        kNieunIKhieukh                      = 0xb2e0,
        kNieunIThieuth                      = 0xb2e1,
        kNieunIPhieuph                      = 0xb2e2,
        kNieunIHieuh                        = 0xb2e3,
        kTikeutA                            = 0xb2e4,
        kTikeutAKiyeok                      = 0xb2e5,
        kTikeutASsangkiyeok                 = 0xb2e6,
        kTikeutAKiyeoksios                  = 0xb2e7,
        kTikeutANieun                       = 0xb2e8,
        kTikeutANieuncieuc                  = 0xb2e9,
        kTikeutANieunhieuh                  = 0xb2ea,
        kTikeutATikeut                      = 0xb2eb,
        kTikeutARieul                       = 0xb2ec,
        kTikeutARieulkiyeok                 = 0xb2ed,
        kTikeutARieulmieum                  = 0xb2ee,
        kTikeutARieulpieup                  = 0xb2ef,
        kTikeutARieulsios                   = 0xb2f0,
        kTikeutARieulthieuth                = 0xb2f1,
        kTikeutARieulphieuph                = 0xb2f2,
        kTikeutARieulhieuh                  = 0xb2f3,
        kTikeutAMieum                       = 0xb2f4,
        kTikeutAPieup                       = 0xb2f5,
        kTikeutAPieupsios                   = 0xb2f6,
        kTikeutASios                        = 0xb2f7,
        kTikeutASsangsios                   = 0xb2f8,
        kTikeutAIeung                       = 0xb2f9,
        kTikeutACieuc                       = 0xb2fa,
        kTikeutAChieuch                     = 0xb2fb,
        kTikeutAKhieukh                     = 0xb2fc,
        kTikeutAThieuth                     = 0xb2fd,
        kTikeutAPhieuph                     = 0xb2fe,
        kTikeutAHieuh                       = 0xb2ff,
        kTikeutAe                           = 0xb300,
        kTikeutAeKiyeok                     = 0xb301,
        kTikeutAeSsangkiyeok                = 0xb302,
        kTikeutAeKiyeoksios                 = 0xb303,
        kTikeutAeNieun                      = 0xb304,
        kTikeutAeNieuncieuc                 = 0xb305,
        kTikeutAeNieunhieuh                 = 0xb306,
        kTikeutAeTikeut                     = 0xb307,
        kTikeutAeRieul                      = 0xb308,
        kTikeutAeRieulkiyeok                = 0xb309,
        kTikeutAeRieulmieum                 = 0xb30a,
        kTikeutAeRieulpieup                 = 0xb30b,
        kTikeutAeRieulsios                  = 0xb30c,
        kTikeutAeRieulthieuth               = 0xb30d,
        kTikeutAeRieulphieuph               = 0xb30e,
        kTikeutAeRieulhieuh                 = 0xb30f,
        kTikeutAeMieum                      = 0xb310,
        kTikeutAePieup                      = 0xb311,
        kTikeutAePieupsios                  = 0xb312,
        kTikeutAeSios                       = 0xb313,
        kTikeutAeSsangsios                  = 0xb314,
        kTikeutAeIeung                      = 0xb315,
        kTikeutAeCieuc                      = 0xb316,
        kTikeutAeChieuch                    = 0xb317,
        kTikeutAeKhieukh                    = 0xb318,
        kTikeutAeThieuth                    = 0xb319,
        kTikeutAePhieuph                    = 0xb31a,
        kTikeutAeHieuh                      = 0xb31b,
        kTikeutYa                           = 0xb31c,
        kTikeutYaKiyeok                     = 0xb31d,
        kTikeutYaSsangkiyeok                = 0xb31e,
        kTikeutYaKiyeoksios                 = 0xb31f,
        kTikeutYaNieun                      = 0xb320,
        kTikeutYaNieuncieuc                 = 0xb321,
        kTikeutYaNieunhieuh                 = 0xb322,
        kTikeutYaTikeut                     = 0xb323,
        kTikeutYaRieul                      = 0xb324,
        kTikeutYaRieulkiyeok                = 0xb325,
        kTikeutYaRieulmieum                 = 0xb326,
        kTikeutYaRieulpieup                 = 0xb327,
        kTikeutYaRieulsios                  = 0xb328,
        kTikeutYaRieulthieuth               = 0xb329,
        kTikeutYaRieulphieuph               = 0xb32a,
        kTikeutYaRieulhieuh                 = 0xb32b,
        kTikeutYaMieum                      = 0xb32c,
        kTikeutYaPieup                      = 0xb32d,
        kTikeutYaPieupsios                  = 0xb32e,
        kTikeutYaSios                       = 0xb32f,
        kTikeutYaSsangsios                  = 0xb330,
        kTikeutYaIeung                      = 0xb331,
        kTikeutYaCieuc                      = 0xb332,
        kTikeutYaChieuch                    = 0xb333,
        kTikeutYaKhieukh                    = 0xb334,
        kTikeutYaThieuth                    = 0xb335,
        kTikeutYaPhieuph                    = 0xb336,
        kTikeutYaHieuh                      = 0xb337,
        kTikeutYae                          = 0xb338,
        kTikeutYaeKiyeok                    = 0xb339,
        kTikeutYaeSsangkiyeok               = 0xb33a,
        kTikeutYaeKiyeoksios                = 0xb33b,
        kTikeutYaeNieun                     = 0xb33c,
        kTikeutYaeNieuncieuc                = 0xb33d,
        kTikeutYaeNieunhieuh                = 0xb33e,
        kTikeutYaeTikeut                    = 0xb33f,
        kTikeutYaeRieul                     = 0xb340,
        kTikeutYaeRieulkiyeok               = 0xb341,
        kTikeutYaeRieulmieum                = 0xb342,
        kTikeutYaeRieulpieup                = 0xb343,
        kTikeutYaeRieulsios                 = 0xb344,
        kTikeutYaeRieulthieuth              = 0xb345,
        kTikeutYaeRieulphieuph              = 0xb346,
        kTikeutYaeRieulhieuh                = 0xb347,
        kTikeutYaeMieum                     = 0xb348,
        kTikeutYaePieup                     = 0xb349,
        kTikeutYaePieupsios                 = 0xb34a,
        kTikeutYaeSios                      = 0xb34b,
        kTikeutYaeSsangsios                 = 0xb34c,
        kTikeutYaeIeung                     = 0xb34d,
        kTikeutYaeCieuc                     = 0xb34e,
        kTikeutYaeChieuch                   = 0xb34f,
        kTikeutYaeKhieukh                   = 0xb350,
        kTikeutYaeThieuth                   = 0xb351,
        kTikeutYaePhieuph                   = 0xb352,
        kTikeutYaeHieuh                     = 0xb353,
        kTikeutEo                           = 0xb354,
        kTikeutEoKiyeok                     = 0xb355,
        kTikeutEoSsangkiyeok                = 0xb356,
        kTikeutEoKiyeoksios                 = 0xb357,
        kTikeutEoNieun                      = 0xb358,
        kTikeutEoNieuncieuc                 = 0xb359,
        kTikeutEoNieunhieuh                 = 0xb35a,
        kTikeutEoTikeut                     = 0xb35b,
        kTikeutEoRieul                      = 0xb35c,
        kTikeutEoRieulkiyeok                = 0xb35d,
        kTikeutEoRieulmieum                 = 0xb35e,
        kTikeutEoRieulpieup                 = 0xb35f,
        kTikeutEoRieulsios                  = 0xb360,
        kTikeutEoRieulthieuth               = 0xb361,
        kTikeutEoRieulphieuph               = 0xb362,
        kTikeutEoRieulhieuh                 = 0xb363,
        kTikeutEoMieum                      = 0xb364,
        kTikeutEoPieup                      = 0xb365,
        kTikeutEoPieupsios                  = 0xb366,
        kTikeutEoSios                       = 0xb367,
        kTikeutEoSsangsios                  = 0xb368,
        kTikeutEoIeung                      = 0xb369,
        kTikeutEoCieuc                      = 0xb36a,
        kTikeutEoChieuch                    = 0xb36b,
        kTikeutEoKhieukh                    = 0xb36c,
        kTikeutEoThieuth                    = 0xb36d,
        kTikeutEoPhieuph                    = 0xb36e,
        kTikeutEoHieuh                      = 0xb36f,
        kTikeutE                            = 0xb370,
        kTikeutEKiyeok                      = 0xb371,
        kTikeutESsangkiyeok                 = 0xb372,
        kTikeutEKiyeoksios                  = 0xb373,
        kTikeutENieun                       = 0xb374,
        kTikeutENieuncieuc                  = 0xb375,
        kTikeutENieunhieuh                  = 0xb376,
        kTikeutETikeut                      = 0xb377,
        kTikeutERieul                       = 0xb378,
        kTikeutERieulkiyeok                 = 0xb379,
        kTikeutERieulmieum                  = 0xb37a,
        kTikeutERieulpieup                  = 0xb37b,
        kTikeutERieulsios                   = 0xb37c,
        kTikeutERieulthieuth                = 0xb37d,
        kTikeutERieulphieuph                = 0xb37e,
        kTikeutERieulhieuh                  = 0xb37f,
        kTikeutEMieum                       = 0xb380,
        kTikeutEPieup                       = 0xb381,
        kTikeutEPieupsios                   = 0xb382,
        kTikeutESios                        = 0xb383,
        kTikeutESsangsios                   = 0xb384,
        kTikeutEIeung                       = 0xb385,
        kTikeutECieuc                       = 0xb386,
        kTikeutEChieuch                     = 0xb387,
        kTikeutEKhieukh                     = 0xb388,
        kTikeutEThieuth                     = 0xb389,
        kTikeutEPhieuph                     = 0xb38a,
        kTikeutEHieuh                       = 0xb38b,
        kTikeutYeo                          = 0xb38c,
        kTikeutYeoKiyeok                    = 0xb38d,
        kTikeutYeoSsangkiyeo                = 0xb38e,
        kTikeutYeoKiyeoksios                = 0xb38f,
        kTikeutYeoNieun                     = 0xb390,
        kTikeutYeoNieuncieuc                = 0xb391,
        kTikeutYeoNieunhieuh                = 0xb392,
        kTikeutYeoTikeut                    = 0xb393,
        kTikeutYeoRieul                     = 0xb394,
        kTikeutYeoRieulkiyeok               = 0xb395,
        kTikeutYeoRieulmieum                = 0xb396,
        kTikeutYeoRieulpieup                = 0xb397,
        kTikeutYeoRieulsios                 = 0xb398,
        kTikeutYeoRieulthieuth              = 0xb399,
        kTikeutYeoRieulphieuph              = 0xb39a,
        kTikeutYeoRieulhieuh                = 0xb39b,
        kTikeutYeoMieum                     = 0xb39c,
        kTikeutYeoPieup                     = 0xb39d,
        kTikeutYeoPieupsios                 = 0xb39e,
        kTikeutYeoSios                      = 0xb39f,
        kTikeutYeoSsangsios                 = 0xb3a0,
        kTikeutYeoIeung                     = 0xb3a1,
        kTikeutYeoCieuc                     = 0xb3a2,
        kTikeutYeoChieuch                   = 0xb3a3,
        kTikeutYeoKhieukh                   = 0xb3a4,
        kTikeutYeoThieuth                   = 0xb3a5,
        kTikeutYeoPhieuph                   = 0xb3a6,
        kTikeutYeoHieuh                     = 0xb3a7,
        kTikeutYe                           = 0xb3a8,
        kTikeutYeKiyeok                     = 0xb3a9,
        kTikeutYeSsangkiyeok                = 0xb3aa,
        kTikeutYeKiyeoksios                 = 0xb3ab,
        kTikeutYeNieun                      = 0xb3ac,
        kTikeutYeNieuncieuc                 = 0xb3ad,
        kTikeutYeNieunhieuh                 = 0xb3ae,
        kTikeutYeTikeut                     = 0xb3af,
        kTikeutYeRieul                      = 0xb3b0,
        kTikeutYeRieulkiyeok                = 0xb3b1,
        kTikeutYeRieulmieum                 = 0xb3b2,
        kTikeutYeRieulpieup                 = 0xb3b3,
        kTikeutYeRieulsios                  = 0xb3b4,
        kTikeutYeRieulthieuth               = 0xb3b5,
        kTikeutYeRieulphieuph               = 0xb3b6,
        kTikeutYeRieulhieuh                 = 0xb3b7,
        kTikeutYeMieum                      = 0xb3b8,
        kTikeutYePieup                      = 0xb3b9,
        kTikeutYePieupsios                  = 0xb3ba,
        kTikeutYeSios                       = 0xb3bb,
        kTikeutYeSsangsios                  = 0xb3bc,
        kTikeutYeIeung                      = 0xb3bd,
        kTikeutYeCieuc                      = 0xb3be,
        kTikeutYeChieuch                    = 0xb3bf,
        kTikeutYeKhieukh                    = 0xb3c0,
        kTikeutYeThieuth                    = 0xb3c1,
        kTikeutYePhieuph                    = 0xb3c2,
        kTikeutYeHieuh                      = 0xb3c3,
        kTikeutO                            = 0xb3c4,
        kTikeutOKiyeok                      = 0xb3c5,
        kTikeutOSsangkiyeok                 = 0xb3c6,
        kTikeutOKiyeoksios                  = 0xb3c7,
        kTikeutONieun                       = 0xb3c8,
        kTikeutONieuncieuc                  = 0xb3c9,
        kTikeutONieunhieuh                  = 0xb3ca,
        kTikeutOTikeut                      = 0xb3cb,
        kTikeutORieul                       = 0xb3cc,
        kTikeutORieulkiyeok                 = 0xb3cd,
        kTikeutORieulmieum                  = 0xb3ce,
        kTikeutORieulpieup                  = 0xb3cf,
        kTikeutORieulsios                   = 0xb3d0,
        kTikeutORieulthieuth                = 0xb3d1,
        kTikeutORieulphieuph                = 0xb3d2,
        kTikeutORieulhieuh                  = 0xb3d3,
        kTikeutOMieum                       = 0xb3d4,
        kTikeutOPieup                       = 0xb3d5,
        kTikeutOPieupsios                   = 0xb3d6,
        kTikeutOSios                        = 0xb3d7,
        kTikeutOSsangsios                   = 0xb3d8,
        kTikeutOIeung                       = 0xb3d9,
        kTikeutOCieuc                       = 0xb3da,
        kTikeutOChieuch                     = 0xb3db,
        kTikeutOKhieukh                     = 0xb3dc,
        kTikeutOThieuth                     = 0xb3dd,
        kTikeutOPhieuph                     = 0xb3de,
        kTikeutOHieuh                       = 0xb3df,
        kTikeutWa                           = 0xb3e0,
        kTikeutWaKiyeok                     = 0xb3e1,
        kTikeutWaSsangkiyeok                = 0xb3e2,
        kTikeutWaKiyeoksios                 = 0xb3e3,
        kTikeutWaNieun                      = 0xb3e4,
        kTikeutWaNieuncieuc                 = 0xb3e5,
        kTikeutWaNieunhieuh                 = 0xb3e6,
        kTikeutWaTikeut                     = 0xb3e7,
        kTikeutWaRieul                      = 0xb3e8,
        kTikeutWaRieulkiyeok                = 0xb3e9,
        kTikeutWaRieulmieum                 = 0xb3ea,
        kTikeutWaRieulpieup                 = 0xb3eb,
        kTikeutWaRieulsios                  = 0xb3ec,
        kTikeutWaRieulthieuth               = 0xb3ed,
        kTikeutWaRieulphieuph               = 0xb3ee,
        kTikeutWaRieulhieuh                 = 0xb3ef,
        kTikeutWaMieum                      = 0xb3f0,
        kTikeutWaPieup                      = 0xb3f1,
        kTikeutWaPieupsios                  = 0xb3f2,
        kTikeutWaSios                       = 0xb3f3,
        kTikeutWaSsangsios                  = 0xb3f4,
        kTikeutWaIeung                      = 0xb3f5,
        kTikeutWaCieuc                      = 0xb3f6,
        kTikeutWaChieuch                    = 0xb3f7,
        kTikeutWaKhieukh                    = 0xb3f8,
        kTikeutWaThieuth                    = 0xb3f9,
        kTikeutWaPhieuph                    = 0xb3fa,
        kTikeutWaHieuh                      = 0xb3fb,
        kTikeutWae                          = 0xb3fc,
        kTikeutWaeKiyeok                    = 0xb3fd,
        kTikeutWaeSsangkiyeok               = 0xb3fe,
        kTikeutWaeKiyeoksios                = 0xb3ff,
        kTikeutWaeNieun                     = 0xb400,
        kTikeutWaeNieuncieuc                = 0xb401,
        kTikeutWaeNieunhieuh                = 0xb402,
        kTikeutWaeTikeut                    = 0xb403,
        kTikeutWaeRieul                     = 0xb404,
        kTikeutWaeRieulkiyeok               = 0xb405,
        kTikeutWaeRieulmieum                = 0xb406,
        kTikeutWaeRieulpieup                = 0xb407,
        kTikeutWaeRieulsios                 = 0xb408,
        kTikeutWaeRieulthieuth              = 0xb409,
        kTikeutWaeRieulphieuph              = 0xb40a,
        kTikeutWaeRieulhieuh                = 0xb40b,
        kTikeutWaeMieum                     = 0xb40c,
        kTikeutWaePieup                     = 0xb40d,
        kTikeutWaePieupsios                 = 0xb40e,
        kTikeutWaeSios                      = 0xb40f,
        kTikeutWaeSsangsios                 = 0xb410,
        kTikeutWaeIeung                     = 0xb411,
        kTikeutWaeCieuc                     = 0xb412,
        kTikeutWaeChieuch                   = 0xb413,
        kTikeutWaeKhieukh                   = 0xb414,
        kTikeutWaeThieuth                   = 0xb415,
        kTikeutWaePhieuph                   = 0xb416,
        kTikeutWaeHieuh                     = 0xb417,
        kTikeutOe                           = 0xb418,
        kTikeutOeKiyeok                     = 0xb419,
        kTikeutOeSsangkiyeok                = 0xb41a,
        kTikeutOeKiyeoksios                 = 0xb41b,
        kTikeutOeNieun                      = 0xb41c,
        kTikeutOeNieuncieuc                 = 0xb41d,
        kTikeutOeNieunhieuh                 = 0xb41e,
        kTikeutOeTikeut                     = 0xb41f,
        kTikeutOeRieul                      = 0xb420,
        kTikeutOeRieulkiyeok                = 0xb421,
        kTikeutOeRieulmieum                 = 0xb422,
        kTikeutOeRieulpieup                 = 0xb423,
        kTikeutOeRieulsios                  = 0xb424,
        kTikeutOeRieulthieuth               = 0xb425,
        kTikeutOeRieulphieuph               = 0xb426,
        kTikeutOeRieulhieuh                 = 0xb427,
        kTikeutOeMieum                      = 0xb428,
        kTikeutOePieup                      = 0xb429,
        kTikeutOePieupsios                  = 0xb42a,
        kTikeutOeSios                       = 0xb42b,
        kTikeutOeSsangsios                  = 0xb42c,
        kTikeutOeIeung                      = 0xb42d,
        kTikeutOeCieuc                      = 0xb42e,
        kTikeutOeChieuch                    = 0xb42f,
        kTikeutOeKhieukh                    = 0xb430,
        kTikeutOeThieuth                    = 0xb431,
        kTikeutOePhieuph                    = 0xb432,
        kTikeutOeHieuh                      = 0xb433,
        kTikeutYo                           = 0xb434,
        kTikeutYoKiyeok                     = 0xb435,
        kTikeutYoSsangkiyeok                = 0xb436,
        kTikeutYoKiyeoksios                 = 0xb437,
        kTikeutYoNieun                      = 0xb438,
        kTikeutYoNieuncieuc                 = 0xb439,
        kTikeutYoNieunhieuh                 = 0xb43a,
        kTikeutYoTikeut                     = 0xb43b,
        kTikeutYoRieul                      = 0xb43c,
        kTikeutYoRieulkiyeok                = 0xb43d,
        kTikeutYoRieulmieum                 = 0xb43e,
        kTikeutYoRieulpieup                 = 0xb43f,
        kTikeutYoRieulsios                  = 0xb440,
        kTikeutYoRieulthieuth               = 0xb441,
        kTikeutYoRieulphieuph               = 0xb442,
        kTikeutYoRieulhieuh                 = 0xb443,
        kTikeutYoMieum                      = 0xb444,
        kTikeutYoPieup                      = 0xb445,
        kTikeutYoPieupsios                  = 0xb446,
        kTikeutYoSios                       = 0xb447,
        kTikeutYoSsangsios                  = 0xb448,
        kTikeutYoIeung                      = 0xb449,
        kTikeutYoCieuc                      = 0xb44a,
        kTikeutYoChieuch                    = 0xb44b,
        kTikeutYoKhieukh                    = 0xb44c,
        kTikeutYoThieuth                    = 0xb44d,
        kTikeutYoPhieuph                    = 0xb44e,
        kTikeutYoHieuh                      = 0xb44f,
        kTikeutU                            = 0xb450,
        kTikeutUKiyeok                      = 0xb451,
        kTikeutUSsangkiyeok                 = 0xb452,
        kTikeutUKiyeoksios                  = 0xb453,
        kTikeutUNieun                       = 0xb454,
        kTikeutUNieuncieuc                  = 0xb455,
        kTikeutUNieunhieuh                  = 0xb456,
        kTikeutUTikeut                      = 0xb457,
        kTikeutURieul                       = 0xb458,
        kTikeutURieulkiyeok                 = 0xb459,
        kTikeutURieulmieum                  = 0xb45a,
        kTikeutURieulpieup                  = 0xb45b,
        kTikeutURieulsios                   = 0xb45c,
        kTikeutURieulthieuth                = 0xb45d,
        kTikeutURieulphieuph                = 0xb45e,
        kTikeutURieulhieuh                  = 0xb45f,
        kTikeutUMieum                       = 0xb460,
        kTikeutUPieup                       = 0xb461,
        kTikeutUPieupsios                   = 0xb462,
        kTikeutUSios                        = 0xb463,
        kTikeutUSsangsios                   = 0xb464,
        kTikeutUIeung                       = 0xb465,
        kTikeutUCieuc                       = 0xb466,
        kTikeutUChieuch                     = 0xb467,
        kTikeutUKhieukh                     = 0xb468,
        kTikeutUThieuth                     = 0xb469,
        kTikeutUPhieuph                     = 0xb46a,
        kTikeutUHieuh                       = 0xb46b,
        kTikeutWeo                          = 0xb46c,
        kTikeutWeoKiyeok                    = 0xb46d,
        kTikeutWeoSsangkiyeok               = 0xb46e,
        kTikeutWeoKiyeoksios                = 0xb46f,
        kTikeutWeoNieun                     = 0xb470,
        kTikeutWeoNieuncieuc                = 0xb471,
        kTikeutWeoNieunhieuh                = 0xb472,
        kTikeutWeoTikeut                    = 0xb473,
        kTikeutWeoRieul                     = 0xb474,
        kTikeutWeoRieulkiyeok               = 0xb475,
        kTikeutWeoRieulmieum                = 0xb476,
        kTikeutWeoRieulpieup                = 0xb477,
        kTikeutWeoRieulsios                 = 0xb478,
        kTikeutWeoRieulthieuth              = 0xb479,
        kTikeutWeoRieulphieuph              = 0xb47a,
        kTikeutWeoRieulhieuh                = 0xb47b,
        kTikeutWeoMieum                     = 0xb47c,
        kTikeutWeoPieup                     = 0xb47d,
        kTikeutWeoPieupsios                 = 0xb47e,
        kTikeutWeoSios                      = 0xb47f,
        kTikeutWeoSsangsios                 = 0xb480,
        kTikeutWeoIeung                     = 0xb481,
        kTikeutWeoCieuc                     = 0xb482,
        kTikeutWeoChieuch                   = 0xb483,
        kTikeutWeoKhieukh                   = 0xb484,
        kTikeutWeoThieuth                   = 0xb485,
        kTikeutWeoPhieuph                   = 0xb486,
        kTikeutWeoHieuh                     = 0xb487,
        kTikeutWe                           = 0xb488,
        kTikeutWeKiyeok                     = 0xb489,
        kTikeutWeSsangkiyeok                = 0xb48a,
        kTikeutWeKiyeoksios                 = 0xb48b,
        kTikeutWeNieun                      = 0xb48c,
        kTikeutWeNieuncieuc                 = 0xb48d,
        kTikeutWeNieunhieuh                 = 0xb48e,
        kTikeutWeTikeut                     = 0xb48f,
        kTikeutWeRieul                      = 0xb490,
        kTikeutWeRieulkiyeok                = 0xb491,
        kTikeutWeRieulmieum                 = 0xb492,
        kTikeutWeRieulpieup                 = 0xb493,
        kTikeutWeRieulsios                  = 0xb494,
        kTikeutWeRieulthieuth               = 0xb495,
        kTikeutWeRieulphieuph               = 0xb496,
        kTikeutWeRieulhieuh                 = 0xb497,
        kTikeutWeMieum                      = 0xb498,
        kTikeutWePieup                      = 0xb499,
        kTikeutWePieupsios                  = 0xb49a,
        kTikeutWeSios                       = 0xb49b,
        kTikeutWeSsangsios                  = 0xb49c,
        kTikeutWeIeung                      = 0xb49d,
        kTikeutWeCieuc                      = 0xb49e,
        kTikeutWeChieuch                    = 0xb49f,
        kTikeutWeKhieukh                    = 0xb4a0,
        kTikeutWeThieuth                    = 0xb4a1,
        kTikeutWePhieuph                    = 0xb4a2,
        kTikeutWeHieuh                      = 0xb4a3,
        kTikeutWi                           = 0xb4a4,
        kTikeutWiKiyeok                     = 0xb4a5,
        kTikeutWiSsangkiyeok                = 0xb4a7,
        kTikeutWiNieun                      = 0xb4a8,
        kTikeutWiNieuncieuc                 = 0xb4a9,
        kTikeutWiNieunhieuh                 = 0xb4aa,
        kTikeutWiTikeut                     = 0xb4ab,
        kTikeutWiRieul                      = 0xb4ac,
        kTikeutWiRieulkiyeok                = 0xb4ad,
        kTikeutWiRieulmieum                 = 0xb4ae,
        kTikeutWiRieulpieup                 = 0xb4af,
        kTikeutWiRieulsios                  = 0xb4b0,
        kTikeutWiRieulthieuth               = 0xb4b1,
        kTikeutWiRieulphieuph               = 0xb4b2,
        kTikeutWiRieulhieuh                 = 0xb4b3,
        kTikeutWiMieum                      = 0xb4b4,
        kTikeutWiPieup                      = 0xb4b5,
        kTikeutWiPieupsios                  = 0xb4b6,
        kTikeutWiSios                       = 0xb4b7,
        kTikeutWiSsangsios                  = 0xb4b8,
        kTikeutWiIeung                      = 0xb4b9,
        kTikeutWiCieuc                      = 0xb4ba,
        kTikeutWiChieuch                    = 0xb4bb,
        kTikeutWiKhieukh                    = 0xb4bc,
        kTikeutWiThieuth                    = 0xb4bd,
        kTikeutWiPhieuph                    = 0xb4be,
        kTikeutWiHieuh                      = 0xb4bf,
        kTikeutYu                           = 0xb4c0,
        kTikeutYuKiyeok                     = 0xb4c1,
        kTikeutYuSsangkiyeok                = 0xb4c2,
        kTikeutYuKiyeoksios                 = 0xb4c3,
        kTikeutYuNieun                      = 0xb4c4,
        kTikeutYuNieuncieuc                 = 0xb4c5,
        kTikeutYuNieunhieuh                 = 0xb4c6,
        kTikeutYuTikeut                     = 0xb4c7,
        kTikeutYuRieul                      = 0xb4c8,
        kTikeutYuRieulkiyeok                = 0xb4c9,
        kTikeutYuRieulmieum                 = 0xb4ca,
        kTikeutYuRieulpieup                 = 0xb4cb,
        kTikeutYuRieulsios                  = 0xb4cc,
        kTikeutYuRieulthieuth               = 0xb4cd,
        kTikeutYuRieulphieuph               = 0xb4ce,
        kTikeutYuRieulhieuh                 = 0xb4cf,
        kTikeutYuMieum                      = 0xb4d0,
        kTikeutYuPieup                      = 0xb4d1,
        kTikeutYuPieupsios                  = 0xb4d2,
        kTikeutYuSios                       = 0xb4d3,
        kTikeutYuSsangsios                  = 0xb4d4,
        kTikeutYuIeung                      = 0xb4d5,
        kTikeutYuCieuc                      = 0xb4d6,
        kTikeutYuChieuch                    = 0xb4d7,
        kTikeutYuKhieukh                    = 0xb4d8,
        kTikeutYuThieuth                    = 0xb4d9,
        kTikeutYuPhieuph                    = 0xb4da,
        kTikeutYuHieuh                      = 0xb4db,
        kTikeutEu                           = 0xb4dc,
        kTikeutEuKiyeok                     = 0xb4dd,
        kTikeutEuSsangkiyeok                = 0xb4de,
        kTikeutEuKiyeoksios                 = 0xb4df,
        kTikeutEuNieun                      = 0xb4e0,
        kTikeutEuNieuncieuc                 = 0xb4e1,
        kTikeutEuNieunhieuh                 = 0xb4e2,
        kTikeutEuTikeut                     = 0xb4e3,
        kTikeutEuRieul                      = 0xb4e4,
        kTikeutEuRieulkiyeok                = 0xb4e5,
        kTikeutEuRieulmieum                 = 0xb4e6,
        kTikeutEuRieulpieup                 = 0xb4e7,
        kTikeutEuRieulsios                  = 0xb4e8,
        kTikeutEuRieulthieuth               = 0xb4e9,
        kTikeutEuRieulphieuph               = 0xb4ea,
        kTikeutEuRieulhieuh                 = 0xb4eb,
        kTikeutEuMieum                      = 0xb4ec,
        kTikeutEuPieup                      = 0xb4ed,
        kTikeutEuPieupsios                  = 0xb4ee,
        kTikeutEuSios                       = 0xb4ef,
        kTikeutEuSsangsios                  = 0xb4f0,
        kTikeutEuIeung                      = 0xb4f1,
        kTikeutEuCieuc                      = 0xb4f2,
        kTikeutEuChieuch                    = 0xb4f3,
        kTikeutEuKhieukh                    = 0xb4f4,
        kTikeutEuThieuth                    = 0xb4f5,
        kTikeutEuPhieuph                    = 0xb4f6,
        kTikeutEuHieuh                      = 0xb4f7,
        kTikeutYi                           = 0xb4f8,
        kTikeutYiKiyeok                     = 0xb4f9,
        kTikeutYiSsangkiyeok                = 0xb4fa,
        kTikeutYiKiyeoksios                 = 0xb4fb,
        kTikeutYiNieun                      = 0xb4fc,
        kTikeutYiNieuncieuc                 = 0xb4fd,
        kTikeutYiNieunhieuh                 = 0xb4fe,
        kTikeutYiTikeut                     = 0xb4ff,
        kTikeutYiRieul                      = 0xb500,
        kTikeutYiRieulkiyeok                = 0xb501,
        kTikeutYiRieulmieum                 = 0xb502,
        kTikeutYiRieulpieup                 = 0xb503,
        kTikeutYiRieulsios                  = 0xb504,
        kTikeutYiRieulthieuth               = 0xb505,
        kTikeutYiRieulphieuph               = 0xb506,
        kTikeutYiRieulhieuh                 = 0xb507,
        kTikeutYiMieum                      = 0xb508,
        kTikeutYiPieup                      = 0xb509,
        kTikeutYiPieupsios                  = 0xb50a,
        kTikeutYiSios                       = 0xb50b,
        kTikeutYiSsangsios                  = 0xb50c,
        kTikeutYiIeung                      = 0xb50d,
        kTikeutYiCieuc                      = 0xb50e,
        kTikeutYiChieuch                    = 0xb50f,
        kTikeutYiKhieukh                    = 0xb510,
        kTikeutYiThieuth                    = 0xb511,
        kTikeutYiPhieuph                    = 0xb512,
        kTikeutYiHieuh                      = 0xb513,
        kTikeutI                            = 0xb514,
        kTikeutIKiyeok                      = 0xb515,
        kTikeutISsangkiyeok                 = 0xb516,
        kTikeutIKiyeoksios                  = 0xb517,
        kTikeutINieun                       = 0xb518,
        kTikeutINieuncieuc                  = 0xb519,
        kTikeutINieunhieuh                  = 0xb51a,
        kTikeutITikeut                      = 0xb51b,
        kTikeutIRieul                       = 0xb51c,
        kTikeutIRieulkiyeok                 = 0xb51d,
        kTikeutIRieulmieum                  = 0xb51e,
        kTikeutIRieulpieup                  = 0xb51f,
        kTikeutIRieulsios                   = 0xb520,
        kTikeutIRieulthieuth                = 0xb521,
        kTikeutIRieulphieuph                = 0xb522,
        kTikeutIRieulhieuh                  = 0xb523,
        kTikeutIMieum                       = 0xb524,
        kTikeutIPieup                       = 0xb525,
        kTikeutIPieupsios                   = 0xb526,
        kTikeutISios                        = 0xb527,
        kTikeutISsangsios                   = 0xb528,
        kTikeutIIeung                       = 0xb529,
        kTikeutICieuc                       = 0xb52a,
        kTikeutIChieuch                     = 0xb52b,
        kTikeutIKhieukh                     = 0xb52c,
        kTikeutIThieuth                     = 0xb52d,
        kTikeutIPhieuph                     = 0xb52e,
        kTikeutIHieuh                       = 0xb52f,
        kSsangtikeutA                       = 0xb530,
        kSsangtikeutAKiyeok                 = 0xb531,
        kSsangtikeutASsangkiyeok            = 0xb532,
        kSsangtikeutAKiyeoksios             = 0xb533,
        kSsangtikeutANieun                  = 0xb534,
        kSsangtikeutANieuncieuc             = 0xb535,
        kSsangtikeutANieunhieuh             = 0xb536,
        kSsangtikeutATikeut                 = 0xb537,
        kSsangtikeutARieul                  = 0xb538,
        kSsangtikeutARieulkiyeok            = 0xb539,
        kSsangtikeutARieulmieum             = 0xb53a,
        kSsangtikeutARieulpieup             = 0xb53b,
        kSsangtikeutARieulsios              = 0xb53c,
        kSsangtikeutARieulthieuth           = 0xb53d,
        kSsangtikeutARieulphieuph           = 0xb53e,
        kSsangtikeutARieulhieuh             = 0xb53f,
        kSsangtikeutAMieum                  = 0xb540,
        kSsangtikeutAPieup                  = 0xb541,
        kSsangtikeutAPieupsios              = 0xb542,
        kSsangtikeutASios                   = 0xb543,
        kSsangtikeutASsangsios              = 0xb544,
        kSsangtikeutAIeung                  = 0xb545,
        kSsangtikeutACieuc                  = 0xb546,
        kSsangtikeutAChieuch                = 0xb547,
        kSsangtikeutAKhieukh                = 0xb548,
        kSsangtikeutAThieuth                = 0xb549,
        kSsangtikeutAPhieuph                = 0xb54a,
        kSsangtikeutAHieuh                  = 0xb54b,
        kSsangtikeutAe                      = 0xb54c,
        kSsangtikeutAeKiyeok                = 0xb54d,
        kSsangtikeutAeSsangkiyeok           = 0xb54e,
        kSsangtikeutAeKiyeoksios            = 0xb54f,
        kSsangtikeutAeNieun                 = 0xb550,
        kSsangtikeutAeNieuncieuc            = 0xb551,
        kSsangtikeutAeNieunhieuh            = 0xb552,
        kSsangtikeutAeTikeut                = 0xb553,
        kSsangtikeutAeRieul                 = 0xb554,
        kSsangtikeutAeRieulkiyeok           = 0xb555,
        kSsangtikeutAeRieulmieum            = 0xb556,
        kSsangtikeutAeRieulpieup            = 0xb557,
        kSsangtikeutAeRieulsios             = 0xb558,
        kSsangtikeutAeRieulthieuth          = 0xb559,
        kSsangtikeutAeRieulphieuph          = 0xb55a,
        kSsangtikeutAeRieulhieuh            = 0xb55b,
        kSsangtikeutAeMieum                 = 0xb55c,
        kSsangtikeutAePieup                 = 0xb55d,
        kSsangtikeutAePieupsios             = 0xb55e,
        kSsangtikeutAeSios                  = 0xb55f,
        kSsangtikeutAeSsangsios             = 0xb560,
        kSsangtikeutAeIeung                 = 0xb561,
        kSsangtikeutAeCieuc                 = 0xb562,
        kSsangtikeutAeChieuch               = 0xb563,
        kSsangtikeutAeKhieukh               = 0xb564,
        kSsangtikeutAeThieuth               = 0xb565,
        kSsangtikeutAePhieuph               = 0xb566,
        kSsangtikeutAeHieuh                 = 0xb567,
        kSsangtikeutYa                      = 0xb568,
        kSsangtikeutYaKiyeok                = 0xb569,
        kSsangtikeutYaSsangkiyeok           = 0xb56a,
        kSsangtikeutYaKiyeoksios            = 0xb56b,
        kSsangtikeutYaNieun                 = 0xb56c,
        kSsangtikeutYaNieuncieuc            = 0xb56d,
        kSsangtikeutYaNieunhieuh            = 0xb56e,
        kSsangtikeutYaTikeut                = 0xb56f,
        kSsangtikeutYaRieul                 = 0xb570,
        kSsangtikeutYaRieulkiyeok           = 0xb571,
        kSsangtikeutYaRieulmieum            = 0xb572,
        kSsangtikeutYaRieulpieup            = 0xb573,
        kSsangtikeutYaRieulsios             = 0xb574,
        kSsangtikeutYaRieulthieuth          = 0xb575,
        kSsangtikeutYaRieulphieuph          = 0xb576,
        kSsangtikeutYaRieulhieuh            = 0xb577,
        kSsangtikeutYaMieum                 = 0xb578,
        kSsangtikeutYaPieup                 = 0xb579,
        kSsangtikeutYaPieupsios             = 0xb57a,
        kSsangtikeutYaSios                  = 0xb57b,
        kSsangtikeutYaSsangsios             = 0xb57c,
        kSsangtikeutYaIeung                 = 0xb57d,
        kSsangtikeutYaCieuc                 = 0xb57e,
        kSsangtikeutYaChieuch               = 0xb57f,
        kSsangtikeutYaKhieukh               = 0xb580,
        kSsangtikeutYaThieuth               = 0xb581,
        kSsangtikeutYaPhieuph               = 0xb582,
        kSsangtikeutYaHieuh                 = 0xb583,
        kSsangtikeutYae                     = 0xb584,
        kSsangtikeutYaeKiyeok               = 0xb585,
        kSsangtikeutYaeSsangkiyeok          = 0xb586,
        kSsangtikeutYaeKiyeoksios           = 0xb587,
        kSsangtikeutYaeNieun                = 0xb588,
        kSsangtikeutYaeNieuncieuc           = 0xb589,
        kSsangtikeutYaeNieunhieuh           = 0xb58a,
        kSsangtikeutYaeTikeut               = 0xb58b,
        kSsangtikeutYaeRieul                = 0xb58c,
        kSsangtikeutYaeRieulkiyeok          = 0xb58d,
        kSsangtikeutYaeRieulmieum           = 0xb58e,
        kSsangtikeutYaeRieulpieup           = 0xb58f,
        kSsangtikeutYaeRieulsios            = 0xb590,
        kSsangtikeutYaeRieulthieuth         = 0xb591,
        kSsangtikeutYaeRieulphieuph         = 0xb592,
        kSsangtikeutYaeRieulhieuh           = 0xb593,
        kSsangtikeutYaeMieum                = 0xb594,
        kSsangtikeutYaePieup                = 0xb595,
        kSsangtikeutYaePieupsios            = 0xb596,
        kSsangtikeutYaeSios                 = 0xb597,
        kSsangtikeutYaeSsangsios            = 0xb598,
        kSsangtikeutYaeIeung                = 0xb599,
        kSsangtikeutYaeCieuc                = 0xb59a,
        kSsangtikeutYaeChieuch              = 0xb59b,
        kSsangtikeutYaeKhieukh              = 0xb59c,
        kSsangtikeutYaeThieuth              = 0xb59d,
        kSsangtikeutYaePhieuph              = 0xb59e,
        kSsangtikeutYaeHieuh                = 0xb59f,
        kSsangtikeutEo                      = 0xb5a0,
        kSsangtikeutEoKiyeok                = 0xb5a1,
        kSsangtikeutEoSsangkiyeok           = 0xb5a2,
        kSsangtikeutEoKiyeoksios            = 0xb5a3,
        kSsangtikeutEoNieun                 = 0xb5a4,
        kSsangtikeutEoNieuncieuc            = 0xb5a5,
        kSsangtikeutEoNieunhieuh            = 0xb5a6,
        kSsangtikeutEoTikeut                = 0xb5a7,
        kSsangtikeutEoRieul                 = 0xb5a8,
        kSsangtikeutEoRieulkiyeok           = 0xb5a9,
        kSsangtikeutEoRieulmieum            = 0xb5aa,
        kSsangtikeutEoRieulpieup            = 0xb5ab,
        kSsangtikeutEoRieulsios             = 0xb5ac,
        kSsangtikeutEoRieulthieuth          = 0xb5ad,
        kSsangtikeutEoRieulphieuph          = 0xb5ae,
        kSsangtikeutEoRieulhieuh            = 0xb5af,
        kSsangtikeutEoMieum                 = 0xb5b0,
        kSsangtikeutEoPieup                 = 0xb5b1,
        kSsangtikeutEoPieupsios             = 0xb5b2,
        kSsangtikeutEoSios                  = 0xb5b3,
        kSsangtikeutEoSsangsios             = 0xb5b4,
        kSsangtikeutEoIeung                 = 0xb5b5,
        kSsangtikeutEoCieuc                 = 0xb5b6,
        kSsangtikeutEoChieuch               = 0xb5b7,
        kSsangtikeutEoKhieukh               = 0xb5b8,
        kSsangtikeutEoThieuth               = 0xb5b9,
        kSsangtikeutEoPhieuph               = 0xb5ba,
        kSsangtikeutEoHieuh                 = 0xb5bb,
        kSsangtikeutE                       = 0xb5bc,
        kSsangtikeutEKiyeok                 = 0xb5bd,
        kSsangtikeutESsangkiyeok            = 0xb5be,
        kSsangtikeutEKiyeoksios             = 0xb5bf,
        kSsangtikeutENieun                  = 0xb5c0,
        kSsangtikeutENieuncieuc             = 0xb5c1,
        kSsangtikeutENieunhieuh             = 0xb5c2,
        kSsangtikeutETikeut                 = 0xb5c3,
        kSsangtikeutERieul                  = 0xb5c4,
        kSsangtikeutERieulkiyeok            = 0xb5c5,
        kSsangtikeutERieulmieum             = 0xb5c6,
        kSsangtikeutERieulpieup             = 0xb5c7,
        kSsangtikeutERieulsios              = 0xb5c8,
        kSsangtikeutERieulthieuth           = 0xb5c9,
        kSsangtikeutERieulphieuph           = 0xb5ca,
        kSsangtikeutERieulhieuh             = 0xb5cb,
        kSsangtikeutEMieum                  = 0xb5cc,
        kSsangtikeutEPieup                  = 0xb5cd,
        kSsangtikeutEPieupsios              = 0xb5ce,
        kSsangtikeutESios                   = 0xb5cf,
        kSsangtikeutESsangsios              = 0xb5d0,
        kSsangtikeutEIeung                  = 0xb5d1,
        kSsangtikeutECieuc                  = 0xb5d2,
        kSsangtikeutEChieuch                = 0xb5d3,
        kSsangtikeutEKhieukh                = 0xb5d4,
        kSsangtikeutEThieuth                = 0xb5d5,
        kSsangtikeutEPhieuph                = 0xb5d6,
        kSsangtikeutEHieuh                  = 0xb5d7,
        kSsangtikeutYeo                     = 0xb5d8,
        kSsangtikeutYeoKiyeok               = 0xb5d9,
        kSsangtikeutYeoSsangkiyeok          = 0xb5da,
        kSsangtikeutYeoKiyeoksios           = 0xb5db,
        kSsangtikeutYeoNieun                = 0xb5dc,
        kSsangtikeutYeoNieuncieuc           = 0xb5dd,
        kSsangtikeutYeoNieunhieuh           = 0xb5de,
        kSsangtikeutYeoTikeut               = 0xb5df,
        kSsangtikeutYeoRieul                = 0xb5e0,
        kSsangtikeutYeoRieulkiyeok          = 0xb5e1,
        kSsangtikeutYeoRieulmieum           = 0xb5e2,
        kSsangtikeutYeoRieulpieup           = 0xb5e3,
        kSsangtikeutYeoRieulsios            = 0xb5e4,
        kSsangtikeutYeoRieulthieuth         = 0xb5e5,
        kSsangtikeutYeoRieulphieuph         = 0xb5e6,
        kSsangtikeutYeoRieulhieuh           = 0xb5e7,
        kSsangtikeutYeoMieum                = 0xb5e8,
        kSsangtikeutYeoPieup                = 0xb5e9,
        kSsangtikeutYeoPieupsios            = 0xb5ea,
        kSsangtikeutYeoSios                 = 0xb5eb,
        kSsangtikeutYeoSsangsios            = 0xb5ec,
        kSsangtikeutYeoIeung                = 0xb5ed,
        kSsangtikeutYeoCieuc                = 0xb5ee,
        kSsangtikeutYeoChieuch              = 0xb5ef,
        kSsangtikeutYeoKhieukh              = 0xb5f0,
        kSsangtikeutYeoThieuth              = 0xb5f1,
        kSsangtikeutYeoPhieuph              = 0xb5f2,
        kSsangtikeutYeoHieuh                = 0xb5f3,
        kSsangtikeutYe                      = 0xb5f4,
        kSsangtikeutYeKiyeok                = 0xb5f5,
        kSsangtikeutYeSsangkiyeok           = 0xb5f6,
        kSsangtikeutYeKiyeoksios            = 0xb5f7,
        kSsangtikeutYeNieun                 = 0xb5f8,
        kSsangtikeutYeNieuncieuc            = 0xb5f9,
        kSsangtikeutYeNieunhieuh            = 0xb5fa,
        kSsangtikeutYeTikeut                = 0xb5fb,
        kSsangtikeutYeRieul                 = 0xb5fc,
        kSsangtikeutYeRieulkiyeok           = 0xb5fd,
        kSsangtikeutYeRieulmieum            = 0xb5fe,
        kSsangtikeutYeRieulpieup            = 0xb5ff,
        kSsangtikeutYeRieulsios             = 0xb600,
        kSsangtikeutYeRieulthieuth          = 0xb601,
        kSsangtikeutYeRieulphieuph          = 0xb602,
        kSsangtikeutYeRieulhieuh            = 0xb603,
        kSsangtikeutYeMieum                 = 0xb604,
        kSsangtikeutYePieup                 = 0xb605,
        kSsangtikeutYePieupsios             = 0xb606,
        kSsangtikeutYeSios                  = 0xb607,
        kSsangtikeutYeSsangsios             = 0xb608,
        kSsangtikeutYeIeung                 = 0xb609,
        kSsangtikeutYeCieuc                 = 0xb60a,
        kSsangtikeutYeChieuch               = 0xb60b,
        kSsangtikeutYeKhieukh               = 0xb60c,
        kSsangtikeutYeThieuth               = 0xb60d,
        kSsangtikeutYePhieuph               = 0xb60e,
        kSsangtikeutYeHieuh                 = 0xb60f,
        kSsangtikeutO                       = 0xb610,
        kSsangtikeutOKiyeok                 = 0xb611,
        kSsangtikeutOSsangkiyeok            = 0xb612,
        kSsangtikeutOKiyeoksios             = 0xb613,
        kSsangtikeutONieun                  = 0xb614,
        kSsangtikeutONieuncieuc             = 0xb615,
        kSsangtikeutONieunhieuh             = 0xb616,
        kSsangtikeutOTikeut                 = 0xb617,
        kSsangtikeutORieul                  = 0xb618,
        kSsangtikeutORieulkiyeok            = 0xb619,
        kSsangtikeutORieulmieum             = 0xb61a,
        kSsangtikeutORieulpieup             = 0xb61b,
        kSsangtikeutORieulsios              = 0xb61c,
        kSsangtikeutORieulthieuth           = 0xb61d,
        kSsangtikeutORieulphieuph           = 0xb61e,
        kSsangtikeutORieulhieuh             = 0xb61f,
        kSsangtikeutOMieum                  = 0xb620,
        kSsangtikeutOPieup                  = 0xb621,
        kSsangtikeutOPieupsios              = 0xb622,
        kSsangtikeutOSios                   = 0xb623,
        kSsangtikeutOSsangsios              = 0xb624,
        kSsangtikeutOIeung                  = 0xb625,
        kSsangtikeutOCieuc                  = 0xb626,
        kSsangtikeutOChieuch                = 0xb627,
        kSsangtikeutOKhieukh                = 0xb628,
        kSsangtikeutOThieuth                = 0xb629,
        kSsangtikeutOPhieuph                = 0xb62a,
        kSsangtikeutOHieuh                  = 0xb62b,
        kSsangtikeutWa                      = 0xb62c,
        kSsangtikeutWaKiyeok                = 0xb62d,
        kSsangtikeutWaSsangkiyeok           = 0xb62e,
        kSsangtikeutWaKiyeoksios            = 0xb62f,
        kSsangtikeutWaNieun                 = 0xb630,
        kSsangtikeutWaNieuncieuc            = 0xb631,
        kSsangtikeutWaNieunhieuh            = 0xb632,
        kSsangtikeutWaTikeut                = 0xb633,
        kSsangtikeutWaRieul                 = 0xb634,
        kSsangtikeutWaRieulkiyeok           = 0xb635,
        kSsangtikeutWaRieulmieum            = 0xb636,
        kSsangtikeutWaRieulpieup            = 0xb637,
        kSsangtikeutWaRieulsios             = 0xb638,
        kSsangtikeutWaRieulthieuth          = 0xb639,
        kSsangtikeutWaRieulphieuph          = 0xb63a,
        kSsangtikeutWaRieulhieuh            = 0xb63b,
        kSsangtikeutWaMieum                 = 0xb63c,
        kSsangtikeutWaPieup                 = 0xb63d,
        kSsangtikeutWaPieupsios             = 0xb63e,
        kSsangtikeutWaSios                  = 0xb63f,
        kSsangtikeutWaSsangsios             = 0xb640,
        kSsangtikeutWaIeung                 = 0xb641,
        kSsangtikeutWaCieuc                 = 0xb642,
        kSsangtikeutWaChieuch               = 0xb643,
        kSsangtikeutWaKhieukh               = 0xb644,
        kSsangtikeutWaThieuth               = 0xb645,
        kSsangtikeutWaPhieuph               = 0xb646,
        kSsangtikeutWaHieuh                 = 0xb647,
        kSsangtikeutWae                     = 0xb648,
        kSsangtikeutWaeKiyeok               = 0xb649,
        kSsangtikeutWaeSsangkiyeok          = 0xb64a,
        kSsangtikeutWaeKiyeoksios           = 0xb64b,
        kSsangtikeutWaeNieun                = 0xb64c,
        kSsangtikeutWaeNieuncieuc           = 0xb64d,
        kSsangtikeutWaeNieunhieuh           = 0xb64e,
        kSsangtikeutWaeTikeut               = 0xb64f,
        kSsangtikeutWaeRieul                = 0xb650,
        kSsangtikeutWaeRieulkiyeok          = 0xb651,
        kSsangtikeutWaeRieulmieum           = 0xb652,
        kSsangtikeutWaeRieulpieup           = 0xb653,
        kSsangtikeutWaeRieulsios            = 0xb654,
        kSsangtikeutWaeRieulthieuth         = 0xb655,
        kSsangtikeutWaeRieulphieuph         = 0xb656,
        kSsangtikeutWaeRieulhieuh           = 0xb657,
        kSsangtikeutWaeMieum                = 0xb658,
        kSsangtikeutWaePieup                = 0xb659,
        kSsangtikeutWaePieupsios            = 0xb65a,
        kSsangtikeutWaeSios                 = 0xb65b,
        kSsangtikeutWaeSsangsios            = 0xb65c,
        kSsangtikeutWaeIeung                = 0xb65d,
        kSsangtikeutWaeCieuc                = 0xb65e,
        kSsangtikeutWaeChieuch              = 0xb65f,
        kSsangtikeutWaeKhieukh              = 0xb660,
        kSsangtikeutWaeThieuth              = 0xb661,
        kSsangtikeutWaePhieuph              = 0xb662,
        kSsangtikeutWaeHieuh                = 0xb663,
        kSsangtikeutOe                      = 0xb664,
        kSsangtikeutOeKiyeok                = 0xb665,
        kSsangtikeutOeSsangkiyeok           = 0xb666,
        kSsangtikeutOeKiyeoksios            = 0xb667,
        kSsangtikeutOeNieun                 = 0xb668,
        kSsangtikeutOeNieuncieuc            = 0xb669,
        kSsangtikeutOeNieunhieuh            = 0xb66a,
        kSsangtikeutOeTikeut                = 0xb66b,
        kSsangtikeutOeRieul                 = 0xb66c,
        kSsangtikeutOeRieulkiyeok           = 0xb66d,
        kSsangtikeutOeRieulmieum            = 0xb66e,
        kSsangtikeutOeRieulpieup            = 0xb66f,
        kSsangtikeutOeRieulsios             = 0xb670,
        kSsangtikeutOeRieulthieuth          = 0xb671,
        kSsangtikeutOeRieulphieuph          = 0xb672,
        kSsangtikeutOeRieulhieuh            = 0xb673,
        kSsangtikeutOeMieum                 = 0xb674,
        kSsangtikeutOePieup                 = 0xb675,
        kSsangtikeutOePieupsios             = 0xb676,
        kSsangtikeutOeSios                  = 0xb677,
        kSsangtikeutOeSsangsios             = 0xb678,
        kSsangtikeutOeIeung                 = 0xb679,
        kSsangtikeutOeCieuc                 = 0xb67a,
        kSsangtikeutOeChieuch               = 0xb67b,
        kSsangtikeutOeKhieukh               = 0xb67c,
        kSsangtikeutOeThieuth               = 0xb67d,
        kSsangtikeutOePhieuph               = 0xb67e,
        kSsangtikeutOeHieuh                 = 0xb67f,
        kSsangtikeutYo                      = 0xb680,
        kSsangtikeutYoKiyeok                = 0xb681,
        kSsangtikeutYoSsangkiyeok           = 0xb682,
        kSsangtikeutYoKiyeoksios            = 0xb683,
        kSsangtikeutYoNieun                 = 0xb684,
        kSsangtikeutYoNieuncieuc            = 0xb685,
        kSsangtikeutYoNieunhieuh            = 0xb686,
        kSsangtikeutYoTikeut                = 0xb687,
        kSsangtikeutYoRieul                 = 0xb688,
        kSsangtikeutYoRieulkiyeok           = 0xb689,
        kSsangtikeutYoRieulmieum            = 0xb68a,
        kSsangtikeutYoRieulpieup            = 0xb68b,
        kSsangtikeutYoRieulsios             = 0xb68c,
        kSsangtikeutYoRieulthieuth          = 0xb68d,
        kSsangtikeutYoRieulphieuph          = 0xb68e,
        kSsangtikeutYoRieulhieuh            = 0xb68f,
        kSsangtikeutYoMieum                 = 0xb690,
        kSsangtikeutYoPieup                 = 0xb691,
        kSsangtikeutYoPieupsios             = 0xb692,
        kSsangtikeutYoSios                  = 0xb693,
        kSsangtikeutYoSsangsios             = 0xb694,
        kSsangtikeutYoIeung                 = 0xb695,
        kSsangtikeutYoCieuc                 = 0xb696,
        kSsangtikeutYoChieuch               = 0xb697,
        kSsangtikeutYoKhieukh               = 0xb698,
        kSsangtikeutYoThieuth               = 0xb699,
        kSsangtikeutYoPhieuph               = 0xb69a,
        kSsangtikeutYoHieuh                 = 0xb69b,
        kSsangtikeutU                       = 0xb69c,
        kSsangtikeutUKiyeok                 = 0xb69d,
        kSsangtikeutUSsangkiyeok            = 0xb69e,
        kSsangtikeutUKiyeoksios             = 0xb69f,
        kSsangtikeutUNieun                  = 0xb6a0,
        kSsangtikeutUNieuncieuc             = 0xb6a1,
        kSsangtikeutUNieunhieuh             = 0xb6a2,
        kSsangtikeutUTikeut                 = 0xb6a3,
        kSsangtikeutURieul                  = 0xb6a4,
        kSsangtikeutURieulkiyeok            = 0xb6a5,
        kSsangtikeutURieulmieum             = 0xb6a6,
        kSsangtikeutURieulpieup             = 0xb6a7,
        kSsangtikeutURieulsios              = 0xb6a8,
        kSsangtikeutURieulthieuth           = 0xb6a9,
        kSsangtikeutURieulphieuph           = 0xb6aa,
        kSsangtikeutURieulhieuh             = 0xb6ab,
        kSsangtikeutUMieum                  = 0xb6ac,
        kSsangtikeutUPieup                  = 0xb6ad,
        kSsangtikeutUPieupsios              = 0xb6ae,
        kSsangtikeutUSios                   = 0xb6af,
        kSsangtikeutUSsangsios              = 0xb6b0,
        kSsangtikeutUIeung                  = 0xb6b1,
        kSsangtikeutUCieuc                  = 0xb6b2,
        kSsangtikeutUChieuch                = 0xb6b3,
        kSsangtikeutUKhieukh                = 0xb6b4,
        kSsangtikeutUThieuth                = 0xb6b5,
        kSsangtikeutUPhieuph                = 0xb6b6,
        kSsangtikeutUHieuh                  = 0xb6b7,
        kSsangtikeutWeo                     = 0xb6b8,
        kSsangtikeutWeoKiyeok               = 0xb6b9,
        kSsangtikeutWeoSsangkiyeok          = 0xb6ba,
        kSsangtikeutWeoKiyeoksios           = 0xb6bb,
        kSsangtikeutWeoNieun                = 0xb6bc,
        kSsangtikeutWeoNieuncieuc           = 0xb6bd,
        kSsangtikeutWeoNieunhieuh           = 0xb6be,
        kSsangtikeutWeoTikeut               = 0xb6bf,
        kSsangtikeutWeoRieul                = 0xb6c0,
        kSsangtikeutWeoRieulkiyeok          = 0xb6c1,
        kSsangtikeutWeoRieulmieum           = 0xb6c2,
        kSsangtikeutWeoRieulpieup           = 0xb6c3,
        kSsangtikeutWeoRieulsios            = 0xb6c4,
        kSsangtikeutWeoRieulthieuth         = 0xb6c5,
        kSsangtikeutWeoRieulphieuph         = 0xb6c6,
        kSsangtikeutWeoRieulhieuh           = 0xb6c7,
        kSsangtikeutWeoMieum                = 0xb6c8,
        kSsangtikeutWeoPieup                = 0xb6c9,
        kSsangtikeutWeoPieupsios            = 0xb6ca,
        kSsangtikeutWeoSios                 = 0xb6cb,
        kSsangtikeutWeoSsangsios            = 0xb6cc,
        kSsangtikeutWeoIeung                = 0xb6cd,
        kSsangtikeutWeoCieuc                = 0xb6ce,
        kSsangtikeutWeoChieuch              = 0xb6cf,
        kSsangtikeutWeoKhieukh              = 0xb6d0,
        kSsangtikeutWeoThieuth              = 0xb6d1,
        kSsangtikeutWeoPhieuph              = 0xb6d2,
        kSsangtikeutWeoHieuh                = 0xb6d3,
        kSsangtikeutWe                      = 0xb6d4,
        kSsangtikeutWeKiyeok                = 0xb6d5,
        kSsangtikeutWeSsangkiyeok           = 0xb6d6,
        kSsangtikeutWeKiyeoksios            = 0xb6d7,
        kSsangtikeutWeNieun                 = 0xb6d8,
        kSsangtikeutWeNieuncieuc            = 0xb6d9,
        kSsangtikeutWeNieunhieuh            = 0xb6da,
        kSsangtikeutWeTikeut                = 0xb6db,
        kSsangtikeutWeRieul                 = 0xb6dc,
        kSsangtikeutWeRieulkiyeok           = 0xb6dd,
        kSsangtikeutWeRieulmieum            = 0xb6de,
        kSsangtikeutWeRieulpieup            = 0xb6df,
        kSsangtikeutWeRieulsios             = 0xb6e0,
        kSsangtikeutWeRieulthieuth          = 0xb6e1,
        kSsangtikeutWeRieulphieuph          = 0xb6e2,
        kSsangtikeutWeRieulhieuh            = 0xb6e3,
        kSsangtikeutWeMieum                 = 0xb6e4,
        kSsangtikeutWePieup                 = 0xb6e5,
        kSsangtikeutWePieupsios             = 0xb6e6,
        kSsangtikeutWeSios                  = 0xb6e7,
        kSsangtikeutWeSsangsios             = 0xb6e8,
        kSsangtikeutWeIeung                 = 0xb6e9,
        kSsangtikeutWeCieuc                 = 0xb6ea,
        kSsangtikeutWeChieuch               = 0xb6eb,
        kSsangtikeutWeKhieukh               = 0xb6ec,
        kSsangtikeutWeThieuth               = 0xb6ed,
        kSsangtikeutWePhieuph               = 0xb6ee,
        kSsangtikeutWeHieuh                 = 0xb6ef,
        kSsangtikeutWi                      = 0xb6f0,
        kSsangtikeutWiKiyeok                = 0xb6f1,
        kSsangtikeutWiSsangkiyeok           = 0xb6f2,
        kSsangtikeutWiKiyeoksios            = 0xb6f3,
        kSsangtikeutWiNieun                 = 0xb6f4,
        kSsangtikeutWiNieuncieuc            = 0xb6f5,
        kSsangtikeutWiNieunhieuh            = 0xb6f6,
        kSsangtikeutWiTikeut                = 0xb6f7,
        kSsangtikeutWiRieul                 = 0xb6f8,
        kSsangtikeutWiRieulkiyeok           = 0xb6f9,
        kSsangtikeutWiRieulmieum            = 0xb6fa,
        kSsangtikeutWiRieulpieup            = 0xb6fb,
        kSsangtikeutWiRieulsios             = 0xb6fc,
        kSsangtikeutWiRieulthieut           = 0xb6fd,
        kSsangtikeutWiRieulphieup           = 0xb6fe,
        kSsangtikeutWiRieulhieuh            = 0xb6ff,
        kSsangtikeutWiMieum                 = 0xb700,
        kSsangtikeutWiPieup                 = 0xb701,
        kSsangtikeutWiPieupsios             = 0xb702,
        kSsangtikeutWiSios                  = 0xb703,
        kSsangtikeutWiSsangsios             = 0xb704,
        kSsangtikeutWiIeung                 = 0xb705,
        kSsangtikeutWiCieuc                 = 0xb706,
        kSsangtikeutWiChieuch               = 0xb707,
        kSsangtikeutWiKhieukh               = 0xb708,
        kSsangtikeutWiThieuth               = 0xb709,
        kSsangtikeutWiPhieuph               = 0xb70a,
        kSsangtikeutWiHieuh                 = 0xb70b,
        kSsangtikeutYu                      = 0xb70c,
        kSsangtikeutYuKiyeok                = 0xb70d,
        kSsangtikeutYuSsangkiyeok           = 0xb70e,
        kSsangtikeutYuKiyeoksios            = 0xb70f,
        kSsangtikeutYuNieun                 = 0xb710,
        kSsangtikeutYuNieuncieuc            = 0xb711,
        kSsangtikeutYuNieunhieuh            = 0xb712,
        kSsangtikeutYuTikeut                = 0xb713,
        kSsangtikeutYuRieul                 = 0xb714,
        kSsangtikeutYuRieulkiyeok           = 0xb715,
        kSsangtikeutYuRieulmieum            = 0xb716,
        kSsangtikeutYuRieulpieup            = 0xb717,
        kSsangtikeutYuRieulsios             = 0xb718,
        kSsangtikeutYuRieulthieuth          = 0xb719,
        kSsangtikeutYuRieulphieuph          = 0xb71a,
        kSsangtikeutYuRieulhieuh            = 0xb71b,
        kSsangtikeutYuMieum                 = 0xb71c,
        kSsangtikeutYuPieup                 = 0xb71d,
        kSsangtikeutYuPieupsios             = 0xb71e,
        kSsangtikeutYuSios                  = 0xb71f,
        kSsangtikeutYuSsangsios             = 0xb720,
        kSsangtikeutYuIeung                 = 0xb721,
        kSsangtikeutYuCieuc                 = 0xb722,
        kSsangtikeutYuChieuch               = 0xb723,
        kSsangtikeutYuKhieukh               = 0xb724,
        kSsangtikeutYuThieuth               = 0xb725,
        kSsangtikeutYuPhieuph               = 0xb726,
        kSsangtikeutYuHieuh                 = 0xb727,
        kSsangtikeutEu                      = 0xb728,
        kSsangtikeutEuKiyeok                = 0xb729,
        kSsangtikeutEuSsangkiyeok           = 0xb72a,
        kSsangtikeutEuKiyeoksios            = 0xb72b,
        kSsangtikeutEuNieun                 = 0xb72c,
        kSsangtikeutEuNieuncieuc            = 0xb72d,
        kSsangtikeutEuNieunhieuh            = 0xb72e,
        kSsangtikeutEuTikeut                = 0xb72f,
        kSsangtikeutEuRieul                         = 0xb730,
        kSsangtikeutEuRieulkiyeok                         = 0xb731,
        kSsangtikeutEuRieulmieum                         = 0xb732,
        kSsangtikeutEuRieulpieup                         = 0xb733,
        kSsangtikeutEuRieulsios                         = 0xb734,
        kSsangtikeutEuRieulthieuth                         = 0xb735,
        kSsangtikeutEuRieulphieuph                         = 0xb736,
        kSsangtikeutEuRieulhieuh                         = 0xb737,
        kSsangtikeutEuMieum                         = 0xb738,
        kSsangtikeutEuPieup                         = 0xb739,
        kSsangtikeutEuPieupsios                         = 0xb73a,
        kSsangtikeutEuSios                         = 0xb73b,
        kSsangtikeutEuSsangsios                         = 0xb73c,
        kSsangtikeutEuIeung                         = 0xb73d,
        kSsangtikeutEuCieuc                         = 0xb73e,
        kSsangtikeutEuChieuch                         = 0xb73f,
        kSsangtikeutEuKhieukh                         = 0xb740,
        kSsangtikeutEuThieuth                         = 0xb741,
        kSsangtikeutEuPhieuph                         = 0xb742,
        kSsangtikeutEuHieuh                         = 0xb743,
        kSsangtikeutYi                           = 0xb744,
        kSsangtikeutYiKiyeok                         = 0xb745,
        kSsangtikeutYiSsangkiyeok                         = 0xb746,
        kSsangtikeutYiKiyeoksios                         = 0xb747,
        kSsangtikeutYiNieun                         = 0xb748,
        kSsangtikeutYiNieuncieuc                         = 0xb749,
        kSsangtikeutYiNieunhieuh                         = 0xb74a,
        kSsangtikeutYiTikeut                         = 0xb74b,
        kSsangtikeutYiRieul                         = 0xb74c,
        kSsangtikeutYiRieulkiyeok                         = 0xb74d,
        kSsangtikeutYiRieulmieum                         = 0xb74e,
        kSsangtikeutYiRieulpieup                         = 0xb74f,
        kSsangtikeutYiRieulsios                         = 0xb750,
        kSsangtikeutYiRieulthieuth                         = 0xb751,
        kSsangtikeutYiRieulphieuph                         = 0xb752,
        kSsangtikeutYiRieulhieuh                         = 0xb753,
        kSsangtikeutYiMieum                         = 0xb754,
        kSsangtikeutYiPieup                         = 0xb755,
        kSsangtikeutYiPieupsios                         = 0xb756,
        kSsangtikeutYiSios                         = 0xb757,
        kSsangtikeutYiSsangsios                         = 0xb758,
        kSsangtikeutYiIeung                         = 0xb759,
        kSsangtikeutYiCieuc                         = 0xb75a,
        kSsangtikeutYiChieuch                         = 0xb75b,
        kSsangtikeutYiKhieukh                         = 0xb75c,
        kSsangtikeutYiThieuth                         = 0xb75d,
        kSsangtikeutYiPhieuph                         = 0xb75e,
        kSsangtikeutYiHieuh                         = 0xb75f,
        kSsangtikeutI                           = 0xb760,
        kSsangtikeutIKiyeok                         = 0xb761,
        kSsangtikeutISsangkiyeok                         = 0xb762,
        kSsangtikeutIKiyeoksios                         = 0xb763,
        kSsangtikeutINieun                         = 0xb764,
        kSsangtikeutINieuncieuc                         = 0xb765,
        kSsangtikeutINieunhieuh                         = 0xb766,
        kSsangtikeutITikeut                         = 0xb767,
        kSsangtikeutIRieul                         = 0xb768,
        kSsangtikeutIRieulkiyeok                         = 0xb769,
        kSsangtikeutIRieulmieum                         = 0xb76a,
        kSsangtikeutIRieulpieup                         = 0xb76b,
        kSsangtikeutIRieulsios                         = 0xb76c,
        kSsangtikeutIRieulthieuth                         = 0xb76d,
        kSsangtikeutIRieulphieuph                         = 0xb76e,
        kSsangtikeutIRieulhieuh                         = 0xb76f,
        kSsangtikeutIMieum                         = 0xb770,
        kSsangtikeutIPieup                         = 0xb771,
        kSsangtikeutIPieupsios                         = 0xb772,
        kSsangtikeutISios                         = 0xb773,
        kSsangtikeutISsangsios                         = 0xb774,
        kSsangtikeutIIeung                         = 0xb775,
        kSsangtikeutICieuc                         = 0xb776,
        kSsangtikeutIChieuch                         = 0xb777,
        kSsangtikeutIKhieukh                         = 0xb778,
        kSsangtikeutIThieuth                         = 0xb779,
        kSsangtikeutIPhieuph                         = 0xb77a,
        kSsangtikeutIHieuh                         = 0xb77b,
        kRieulA                           = 0xb77c,
        kRieulAKiyeok                         = 0xb77d,
        kRieulASsangkiyeok                         = 0xb77e,
        kRieulAKiyeoksios                         = 0xb77f,
        kRieulANieun                         = 0xb780,
        kRieulANieuncieuc                         = 0xb781,
        kRieulANieunhieuh                         = 0xb782,
        kRieulATikeut                         = 0xb783,
        kRieulARieul                         = 0xb784,
        kRieulARieulkiyeok                         = 0xb785,
        kRieulARieulmieum                         = 0xb786,
        kRieulARieulpieup                         = 0xb787,
        kRieulARieulsios                         = 0xb788,
        kRieulARieulthieuth                         = 0xb789,
        kRieulARieulphieuph                         = 0xb78a,
        kRieulARieulhieuh                         = 0xb78b,
        kRieulAMieum                         = 0xb78c,
        kRieulAPieup                         = 0xb78d,
        kRieulAPieupsios                         = 0xb78e,
        kRieulASios                         = 0xb78f,
        kRieulASsangsios                         = 0xb790,
        kRieulAIeung                         = 0xb791,
        kRieulACieuc                         = 0xb792,
        kRieulAChieuch                         = 0xb793,
        kRieulAKhieukh                         = 0xb794,
        kRieulAThieuth                         = 0xb795,
        kRieulAPhieuph                         = 0xb796,
        kRieulAHieuh                         = 0xb797,
        kRieulAe                           = 0xb798,
        kRieulAeKiyeok                         = 0xb799,
        kRieulAeSsangkiyeok                         = 0xb79a,
        kRieulAeKiyeoksios                         = 0xb79b,
        kRieulAeNieun                         = 0xb79c,
        kRieulAeNieuncieuc                         = 0xb79d,
        kRieulAeNieunhieuh                         = 0xb79e,
        kRieulAeTikeut                         = 0xb79f,
        kRieulAeRieul                         = 0xb7a0,
        kRieulAeRieulkiyeok                         = 0xb7a1,
        kRieulAeRieulmieum                         = 0xb7a2,
        kRieulAeRieulpieup                         = 0xb7a3,
        kRieulAeRieulsios                         = 0xb7a4,
        kRieulAeRieulthieuth                         = 0xb7a5,
        kRieulAeRieulphieuph                         = 0xb7a6,
        kRieulAeRieulhieuh                         = 0xb7a7,
        kRieulAeMieum                         = 0xb7a8,
        kRieulAePieup                         = 0xb7a9,
        kRieulAePieupsios                         = 0xb7aa,
        kRieulAeSios                         = 0xb7ab,
        kRieulAeSsangsios                         = 0xb7ac,
        kRieulAeIeung                         = 0xb7ad,
        kRieulAeCieuc                         = 0xb7ae,
        kRieulAeChieuch                         = 0xb7af,
        kRieulAeKhieukh                         = 0xb7b0,
        kRieulAeThieuth                         = 0xb7b1,
        kRieulAePhieuph                         = 0xb7b2,
        kRieulAeHieuh                         = 0xb7b3,
        kRieulYa                           = 0xb7b4,
        kRieulYaKiyeok                         = 0xb7b5,
        kRieulYaSsangkiyeok                         = 0xb7b6,
        kRieulYaKiyeoksios                         = 0xb7b7,
        kRieulYaNieun                         = 0xb7b8,
        kRieulYaNieuncieuc                         = 0xb7b9,
        kRieulYaNieunhieuh                         = 0xb7ba,
        kRieulYaTikeut                         = 0xb7bb,
        kRieulYaRieul                         = 0xb7bc,
        kRieulYaRieulkiyeok                         = 0xb7bd,
        kRieulYaRieulmieum                         = 0xb7be,
        kRieulYaRieulpieup                         = 0xb7bf,
        kRieulYaRieulsios                         = 0xb7c0,
        kRieulYaRieulthieuth                         = 0xb7c1,
        kRieulYaRieulphieuph                         = 0xb7c2,
        kRieulYaRieulhieuh                         = 0xb7c3,
        kRieulYaMieum                         = 0xb7c4,
        kRieulYaPieup                         = 0xb7c5,
        kRieulYaPieupsios                         = 0xb7c6,
        kRieulYaSios                         = 0xb7c7,
        kRieulYaSsangsios                         = 0xb7c8,
        kRieulYaIeung                         = 0xb7c9,
        kRieulYaCieuc                         = 0xb7ca,
        kRieulYaChieuch                         = 0xb7cb,
        kRieulYaKhieukh                         = 0xb7cc,
        kRieulYaThieuth                         = 0xb7cd,
        kRieulYaPhieuph                         = 0xb7ce,
        kRieulYaHieuh                         = 0xb7cf,
        kRieulYae                           = 0xb7d0,
        kRieulYaeKiyeok                         = 0xb7d1,
        kRieulYaeSsangkiyeok                         = 0xb7d2,
        kRieulYaeKiyeoksios                         = 0xb7d3,
        kRieulYaeNieun                         = 0xb7d4,
        kRieulYaeNieuncieuc                         = 0xb7d5,
        kRieulYaeNieunhieuh                         = 0xb7d6,
        kRieulYaeTikeut                         = 0xb7d7,
        kRieulYaeRieul                         = 0xb7d8,
        kRieulYaeRieulkiyeok                         = 0xb7d9,
        kRieulYaeRieulmieum                         = 0xb7da,
        kRieulYaeRieulpieup                         = 0xb7db,
        kRieulYaeRieulsios                         = 0xb7dc,
        kRieulYaeRieulthieuth                         = 0xb7dd,
        kRieulYaeRieulphieuph                         = 0xb7de,
        kRieulYaeRieulhieuh                         = 0xb7df,
        kRieulYaeMieum                         = 0xb7e0,
        kRieulYaePieup                         = 0xb7e1,
        kRieulYaePieupsios                         = 0xb7e2,
        kRieulYaeSios                         = 0xb7e3,
        kRieulYaeSsangsios                         = 0xb7e4,
        kRieulYaeIeung                         = 0xb7e5,
        kRieulYaeCieuc                         = 0xb7e6,
        kRieulYaeChieuch                         = 0xb7e7,
        kRieulYaeKhieukh                         = 0xb7e8,
        kRieulYaeThieuth                         = 0xb7e9,
        kRieulYaePhieuph                         = 0xb7ea,
        kRieulYaeHieuh                         = 0xb7eb,
        kRieulEo                           = 0xb7ec,
        kRieulEoKiyeok                         = 0xb7ed,
        kRieulEoSsangkiyeok                         = 0xb7ee,
        kRieulEoKiyeoksios                         = 0xb7ef,
        kRieulEoNieun                         = 0xb7f0,
        kRieulEoNieuncieuc                         = 0xb7f1,
        kRieulEoNieunhieuh                         = 0xb7f2,
        kRieulEoTikeut                         = 0xb7f3,
        kRieulEoRieul                         = 0xb7f4,
        kRieulEoRieulkiyeok                         = 0xb7f5,
        kRieulEoRieulmieum                         = 0xb7f6,
        kRieulEoRieulpieup                         = 0xb7f7,
        kRieulEoRieulsios                         = 0xb7f8,
        kRieulEoRieulthieuth                         = 0xb7f9,
        kRieulEoRieulphieuph                         = 0xb7fa,
        kRieulEoRieulhieuh                         = 0xb7fb,
        kRieulEoMieum                         = 0xb7fc,
        kRieulEoPieup                         = 0xb7fd,
        kRieulEoPieupsios                         = 0xb7fe,
        kRieulEoSios                         = 0xb7ff,
        kRieulEoSsangsios                         = 0xb800,
        kRieulEoIeung                         = 0xb801,
        kRieulEoCieuc                         = 0xb802,
        kRieulEoChieuch                         = 0xb803,
        kRieulEoKhieukh                         = 0xb804,
        kRieulEoThieuth                         = 0xb805,
        kRieulEoPhieuph                         = 0xb806,
        kRieulEoHieuh                         = 0xb807,
        kRieulE                           = 0xb808,
        kRieulEKiyeok                         = 0xb809,
        kRieulESsangkiyeok                         = 0xb80a,
        kRieulEKiyeoksios                         = 0xb80b,
        kRieulENieun                         = 0xb80c,
        kRieulENieuncieuc                         = 0xb80d,
        kRieulENieunhieuh                         = 0xb80e,
        kRieulETikeut                         = 0xb80f,
        kRieulERieul                         = 0xb810,
        kRieulERieulkiyeok                         = 0xb811,
        kRieulERieulmieum                         = 0xb812,
        kRieulERieulpieup                         = 0xb813,
        kRieulERieulsios                         = 0xb814,
        kRieulERieulthieuth                         = 0xb815,
        kRieulERieulphieuph                         = 0xb816,
        kRieulERieulhieuh                         = 0xb817,
        kRieulEMieum                         = 0xb818,
        kRieulEPieup                         = 0xb819,
        kRieulEPieupsios                         = 0xb81a,
        kRieulESios                         = 0xb81b,
        kRieulESsangsios                         = 0xb81c,
        kRieulEIeung                         = 0xb81d,
        kRieulECieuc                         = 0xb81e,
        kRieulEChieuch                         = 0xb81f,
        kRieulEKhieukh                         = 0xb820,
        kRieulEThieuth                         = 0xb821,
        kRieulEPhieuph                         = 0xb822,
        kRieulEHieuh                         = 0xb823,
        kRieulYeo                           = 0xb824,
        kRieulYeoKiyeok                         = 0xb825,
        kRieulYeoSsangkiyeok                         = 0xb826,
        kRieulYeoKiyeoksios                         = 0xb827,
        kRieulYeoNieun                         = 0xb828,
        kRieulYeoNieuncieuc                         = 0xb829,
        kRieulYeoNieunhieuh                         = 0xb82a,
        kRieulYeoTikeut                         = 0xb82b,
        kRieulYeoRieul                         = 0xb82c,
        kRieulYeoRieulkiyeok                         = 0xb82d,
        kRieulYeoRieulmieum                         = 0xb82e,
        kRieulYeoRieulpieup                         = 0xb82f,
        kRieulYeoRieulsios                         = 0xb830,
        kRieulYeoRieulthieuth                         = 0xb831,
        kRieulYeoRieulphieuph                         = 0xb832,
        kRieulYeoRieulhieuh                         = 0xb833,
        kRieulYeoMieum                         = 0xb834,
        kRieulYeoPieup                         = 0xb835,
        kRieulYeoPieupsios                         = 0xb836,
        kRieulYeoSios                         = 0xb837,
        kRieulYeoSsangsios                         = 0xb838,
        kRieulYeoIeung                         = 0xb839,
        kRieulYeoCieuc                         = 0xb83a,
        kRieulYeoChieuch                         = 0xb83b,
        kRieulYeoKhieukh                         = 0xb83c,
        kRieulYeoThieuth                         = 0xb83d,
        kRieulYeoPhieuph                         = 0xb83e,
        kRieulYeoHieuh                         = 0xb83f,
        kRieulYe                           = 0xb840,
        kRieulYeKiyeok                         = 0xb841,
        kRieulYeSsangkiyeok                         = 0xb842,
        kRieulYeKiyeoksios                         = 0xb843,
        kRieulYeNieun                         = 0xb844,
        kRieulYeNieuncieuc                         = 0xb845,
        kRieulYeNieunhieuh                         = 0xb846,
        kRieulYeTikeut                         = 0xb847,
        kRieulYeRieul                         = 0xb848,
        kRieulYeRieulkiyeok                         = 0xb849,
        kRieulYeRieulmieum                         = 0xb84a,
        kRieulYeRieulpieup                         = 0xb84b,
        kRieulYeRieulsios                         = 0xb84c,
        kRieulYeRieulthieuth                         = 0xb84d,
        kRieulYeRieulphieuph                         = 0xb84e,
        kRieulYeRieulhieuh                         = 0xb84f,
        kRieulYeMieum                         = 0xb850,
        kRieulYePieup                         = 0xb851,
        kRieulYePieupsios                         = 0xb852,
        kRieulYeSios                         = 0xb853,
        kRieulYeSsangsios                         = 0xb854,
        kRieulYeIeung                         = 0xb855,
        kRieulYeCieuc                         = 0xb856,
        kRieulYeChieuch                         = 0xb857,
        kRieulYeKhieukh                         = 0xb858,
        kRieulYeThieuth                         = 0xb859,
        kRieulYePhieuph                         = 0xb85a,
        kRieulYeHieuh                         = 0xb85b,
        kRieulO                           = 0xb85c,
        kRieulOKiyeok                         = 0xb85d,
        kRieulOSsangkiyeok                         = 0xb85e,
        kRieulOKiyeoksios                         = 0xb85f,
        kRieulONieun                         = 0xb860,
        kRieulONieuncieuc                         = 0xb861,
        kRieulONieunhieuh                         = 0xb862,
        kRieulOTikeut                         = 0xb863,
        kRieulORieul                         = 0xb864,
        kRieulORieulkiyeok                         = 0xb865,
        kRieulORieulmieum                         = 0xb866,
        kRieulORieulpieup                         = 0xb867,
        kRieulORieulsios                         = 0xb868,
        kRieulORieulthieuth                         = 0xb869,
        kRieulORieulphieuph                         = 0xb86a,
        kRieulORieulhieuh                         = 0xb86b,
        kRieulOMieum                         = 0xb86c,
        kRieulOPieup                         = 0xb86d,
        kRieulOPieupsios                         = 0xb86e,
        kRieulOSios                         = 0xb86f,
        kRieulOSsangsios                         = 0xb870,
        kRieulOIeung                         = 0xb871,
        kRieulOCieuc                         = 0xb872,
        kRieulOChieuch                         = 0xb873,
        kRieulOKhieukh                         = 0xb874,
        kRieulOThieuth                         = 0xb875,
        kRieulOPhieuph                         = 0xb876,
        kRieulOHieuh                         = 0xb877,
        kRieulWa                           = 0xb878,
        kRieulWaKiyeok                         = 0xb879,
        kRieulWaSsangkiyeok                         = 0xb87a,
        kRieulWaKiyeoksios                         = 0xb87b,
        kRieulWaNieun                         = 0xb87c,
        kRieulWaNieuncieuc                         = 0xb87d,
        kRieulWaNieunhieuh                         = 0xb87e,
        kRieulWaTikeut                         = 0xb87f,
        kRieulWaRieul                         = 0xb880,
        kRieulWaRieulkiyeok                         = 0xb881,
        kRieulWaRieulmieum                         = 0xb882,
        kRieulWaRieulpieup                         = 0xb883,
        kRieulWaRieulsios                         = 0xb884,
        kRieulWaRieulthieuth                         = 0xb885,
        kRieulWaRieulphieuph                         = 0xb886,
        kRieulWaRieulhieuh                         = 0xb887,
        kRieulWaMieum                         = 0xb888,
        kRieulWaPieup                         = 0xb889,
        kRieulWaPieupsios                         = 0xb88a,
        kRieulWaSios                         = 0xb88b,
        kRieulWaSsangsios                         = 0xb88c,
        kRieulWaIeung                         = 0xb88d,
        kRieulWaCieuc                         = 0xb88e,
        kRieulWaChieuch                         = 0xb88f,
        kRieulWaKhieukh                         = 0xb890,
        kRieulWaThieuth                         = 0xb891,
        kRieulWaPhieuph                         = 0xb892,
        kRieulWaHieuh                         = 0xb893,
        kRieulWae                           = 0xb894,
        kRieulWaeKiyeok                         = 0xb895,
        kRieulWaeSsangkiyeok                         = 0xb896,
        kRieulWaeKiyeoksios                         = 0xb897,
        kRieulWaeNieun                         = 0xb898,
        kRieulWaeNieuncieuc                         = 0xb899,
        kRieulWaeNieunhieuh                         = 0xb89a,
        kRieulWaeTikeut                         = 0xb89b,
        kRieulWaeRieul                         = 0xb89c,
        kRieulWaeRieulkiyeok                         = 0xb89d,
        kRieulWaeRieulmieum                         = 0xb89e,
        kRieulWaeRieulpieup                         = 0xb89f,
        kRieulWaeRieulsios                         = 0xb8a0,
        kRieulWaeRieulthieuth                         = 0xb8a1,
        kRieulWaeRieulphieuph                         = 0xb8a2,
        kRieulWaeRieulhieuh                         = 0xb8a3,
        kRieulWaeMieum                         = 0xb8a4,
        kRieulWaePieup                         = 0xb8a5,
        kRieulWaePieupsios                         = 0xb8a6,
        kRieulWaeSios                         = 0xb8a7,
        kRieulWaeSsangsios                         = 0xb8a8,
        kRieulWaeIeung                         = 0xb8a9,
        kRieulWaeCieuc                         = 0xb8aa,
        kRieulWaeChieuch                         = 0xb8ab,
        kRieulWaeKhieukh                         = 0xb8ac,
        kRieulWaeThieuth                         = 0xb8ad,
        kRieulWaePhieuph                         = 0xb8ae,
        kRieulWaeHieuh                         = 0xb8af,
        kRieulOe                           = 0xb8b0,
        kRieulOeKiyeok                         = 0xb8b1,
        kRieulOeSsangkiyeok                         = 0xb8b2,
        kRieulOeKiyeoksios                         = 0xb8b3,
        kRieulOeNieun                         = 0xb8b4,
        kRieulOeNieuncieuc                         = 0xb8b5,
        kRieulOeNieunhieuh                         = 0xb8b6,
        kRieulOeTikeut                         = 0xb8b7,
        kRieulOeRieul                         = 0xb8b8,
        kRieulOeRieulkiyeok                         = 0xb8b9,
        kRieulOeRieulmieum                         = 0xb8ba,
        kRieulOeRieulpieup                         = 0xb8bb,
        kRieulOeRieulsios                         = 0xb8bc,
        kRieulOeRieulthieuth                         = 0xb8bd,
        kRieulOeRieulphieuph                         = 0xb8be,
        kRieulOeRieulhieuh                         = 0xb8bf,
        kRieulOeMieum                         = 0xb8c0,
        kRieulOePieup                         = 0xb8c1,
        kRieulOePieupsios                         = 0xb8c2,
        kRieulOeSios                         = 0xb8c3,
        kRieulOeSsangsios                         = 0xb8c4,
        kRieulOeIeung                         = 0xb8c5,
        kRieulOeCieuc                         = 0xb8c6,
        kRieulOeChieuch                         = 0xb8c7,
        kRieulOeKhieukh                         = 0xb8c8,
        kRieulOeThieuth                         = 0xb8c9,
        kRieulOePhieuph                         = 0xb8ca,
        kRieulOeHieuh                         = 0xb8cb,
        kRieulYo                           = 0xb8cc,
        kRieulYoKiyeok                         = 0xb8cd,
        kRieulYoSsangkiyeok                         = 0xb8ce,
        kRieulYoKiyeoksios                         = 0xb8cf,
        kRieulYoNieun                         = 0xb8d0,
        kRieulYoNieuncieuc                         = 0xb8d1,
        kRieulYoNieunhieuh                         = 0xb8d2,
        kRieulYoTikeut                         = 0xb8d3,
        kRieulYoRieul                         = 0xb8d4,
        kRieulYoRieulkiyeok                         = 0xb8d5,
        kRieulYoRieulmieum                         = 0xb8d6,
        kRieulYoRieulpieup                         = 0xb8d7,
        kRieulYoRieulsios                         = 0xb8d8,
        kRieulYoRieulthieuth                         = 0xb8d9,
        kRieulYoRieulphieuph                         = 0xb8da,
        kRieulYoRieulhieuh                         = 0xb8db,
        kRieulYoMieum                         = 0xb8dc,
        kRieulYoPieup                         = 0xb8dd,
        kRieulYoPieupsios                         = 0xb8de,
        kRieulYoSios                         = 0xb8df,
        kRieulYoSsangsios                         = 0xb8e0,
        kRieulYoIeung                         = 0xb8e1,
        kRieulYoCieuc                         = 0xb8e2,
        kRieulYoChieuch                         = 0xb8e3,
        kRieulYoKhieukh                         = 0xb8e4,
        kRieulYoThieuth                         = 0xb8e5,
        kRieulYoPhieuph                         = 0xb8e6,
        kRieulYoHieuh                         = 0xb8e7,
        kRieulU                           = 0xb8e8,
        kRieulUKiyeok                         = 0xb8e9,
        kRieulUSsangkiyeok                         = 0xb8ea,
        kRieulUKiyeoksios                         = 0xb8eb,
        kRieulUNieun                         = 0xb8ec,
        kRieulUNieuncieuc                         = 0xb8ed,
        kRieulUNieunhieuh                         = 0xb8ee,
        kRieulUTikeut                         = 0xb8ef,
        kRieulURieul                         = 0xb8f0,
        kRieulURieulkiyeok                         = 0xb8f1,
        kRieulURieulmieum                         = 0xb8f2,
        kRieulURieulpieup                         = 0xb8f3,
        kRieulURieulsios                         = 0xb8f4,
        kRieulURieulthieuth                         = 0xb8f5,
        kRieulURieulphieuph                         = 0xb8f6,
        kRieulURieulhieuh                         = 0xb8f7,
        kRieulUMieum                         = 0xb8f8,
        kRieulUPieup                         = 0xb8f9,
        kRieulUPieupsios                         = 0xb8fa,
        kRieulUSios                         = 0xb8fb,
        kRieulUSsangsios                         = 0xb8fc,
        kRieulUIeung                         = 0xb8fd,
        kRieulUCieuc                         = 0xb8fe,
        kRieulUChieuch                         = 0xb8ff,
        kRieulUKhieukh                         = 0xb900,
        kRieulUThieuth                         = 0xb901,
        kRieulUPhieuph                         = 0xb902,
        kRieulUHieuh                         = 0xb903,
        kRieulWeo                           = 0xb904,
        kRieulWeoKiyeok                         = 0xb905,
        kRieulWeoSsangkiyeok                         = 0xb906,
        kRieulWeoKiyeoksios                         = 0xb907,
        kRieulWeoNieun                         = 0xb908,
        kRieulWeoNieuncieuc                         = 0xb909,
        kRieulWeoNieunhieuh                         = 0xb90a,
        kRieulWeoTikeut                         = 0xb90b,
        kRieulWeoRieul                         = 0xb90c,
        kRieulWeoRieulkiyeok                         = 0xb90d,
        kRieulWeoRieulmieum                         = 0xb90e,
        kRieulWeoRieulpieup                         = 0xb90f,
        kRieulWeoRieulsios                         = 0xb910,
        kRieulWeoRieulthieuth                         = 0xb911,
        kRieulWeoRieulphieuph                         = 0xb912,
        kRieulWeoRieulhieuh                         = 0xb913,
        kRieulWeoMieum                         = 0xb914,
        kRieulWeoPieup                         = 0xb915,
        kRieulWeoPieupsios                         = 0xb916,
        kRieulWeoSios                         = 0xb917,
        kRieulWeoSsangsios                         = 0xb918,
        kRieulWeoIeung                         = 0xb919,
        kRieulWeoCieuc                         = 0xb91a,
        kRieulWeoChieuch                         = 0xb91b,
        kRieulWeoKhieukh                         = 0xb91c,
        kRieulWeoThieuth                         = 0xb91d,
        kRieulWeoPhieuph                         = 0xb91e,
        kRieulWeoHieuh                         = 0xb91f,
        kRieulWe                           = 0xb920,
        kRieulWeKiyeok                         = 0xb921,
        kRieulWeSsangkiyeok                         = 0xb922,
        kRieulWeKiyeoksios                         = 0xb923,
        kRieulWeNieun                         = 0xb924,
        kRieulWeNieuncieuc                         = 0xb925,
        kRieulWeNieunhieuh                         = 0xb926,
        kRieulWeTikeut                         = 0xb927,
        kRieulWeRieul                         = 0xb928,
        kRieulWeRieulkiyeok                         = 0xb929,
        kRieulWeRieulmieum                         = 0xb92a,
        kRieulWeRieulpieup                         = 0xb92b,
        kRieulWeRieulsios                         = 0xb92c,
        kRieulWeRieulthieuth                         = 0xb92d,
        kRieulWeRieulphieuph                         = 0xb92e,
        kRieulWeRieulhieuh                         = 0xb92f,
        kRieulWeMieum                         = 0xb930,
        kRieulWePieup                         = 0xb931,
        kRieulWePieupsios                         = 0xb932,
        kRieulWeSios                         = 0xb933,
        kRieulWeSsangsios                         = 0xb934,
        kRieulWeIeung                         = 0xb935,
        kRieulWeCieuc                         = 0xb936,
        kRieulWeChieuch                         = 0xb937,
        kRieulWeKhieukh                         = 0xb938,
        kRieulWeThieuth                         = 0xb939,
        kRieulWePhieuph                         = 0xb93a,
        kRieulWeHieuh                         = 0xb93b,
        kRieulWi                           = 0xb93c,
        kRieulWiKiyeok                         = 0xb93d,
        kRieulWiSsangkiyeok                         = 0xb93e,
        kRieulWiKiyeoksios                         = 0xb93f,
        kRieulWiNieun                         = 0xb940,
        kRieulWiNieuncieuc                         = 0xb941,
        kRieulWiNieunhieuh                         = 0xb942,
        kRieulWiTikeut                         = 0xb943,
        kRieulWiRieul                         = 0xb944,
        kRieulWiRieulkiyeok                         = 0xb945,
        kRieulWiRieulmieum                         = 0xb946,
        kRieulWiRieulpieup                         = 0xb947,
        kRieulWiRieulsios                         = 0xb948,
        kRieulWiRieulthieuth                         = 0xb949,
        kRieulWiRieulphieuph                         = 0xb94a,
        kRieulWiRieulhieuh                         = 0xb94b,
        kRieulWiMieum                         = 0xb94c,
        kRieulWiPieup                         = 0xb94d,
        kRieulWiPieupsios                         = 0xb94e,
        kRieulWiSios                         = 0xb94f,
        kRieulWiSsangsios                         = 0xb950,
        kRieulWiIeung                         = 0xb951,
        kRieulWiCieuc                         = 0xb952,
        kRieulWiChieuch                         = 0xb953,
        kRieulWiKhieukh                         = 0xb954,
        kRieulWiThieuth                         = 0xb955,
        kRieulWiPhieuph                         = 0xb956,
        kRieulWiHieuh                         = 0xb957,
        kRieulYu                           = 0xb958,
        kRieulYuKiyeok                         = 0xb959,
        kRieulYuSsangkiyeok                         = 0xb95a,
        kRieulYuKiyeoksios                         = 0xb95b,
        kRieulYuNieun                         = 0xb95c,
        kRieulYuNieuncieuc                         = 0xb95d,
        kRieulYuNieunhieuh                         = 0xb95e,
        kRieulYuTikeut                         = 0xb95f,
        kRieulYuRieul                         = 0xb960,
        kRieulYuRieulkiyeok                         = 0xb961,
        kRieulYuRieulmieum                         = 0xb962,
        kRieulYuRieulpieup                         = 0xb963,
        kRieulYuRieulsios                         = 0xb964,
        kRieulYuRieulthieuth                         = 0xb965,
        kRieulYuRieulphieuph                         = 0xb966,
        kRieulYuRieulhieuh                         = 0xb967,
        kRieulYuMieum                         = 0xb968,
        kRieulYuPieup                         = 0xb969,
        kRieulYuPieupsios                         = 0xb96a,
        kRieulYuSios                         = 0xb96b,
        kRieulYuSsangsios                         = 0xb96c,
        kRieulYuIeung                         = 0xb96d,
        kRieulYuCieuc                         = 0xb96e,
        kRieulYuChieuch                         = 0xb96f,
        kRieulYuKhieukh                         = 0xb970,
        kRieulYuThieuth                         = 0xb971,
        kRieulYuPhieuph                         = 0xb972,
        kRieulYuHieuh                         = 0xb973,
        kRieulEu                           = 0xb974,
        kRieulEuKiyeok                         = 0xb975,
        kRieulEuSsangkiyeok                         = 0xb976,
        kRieulEuKiyeoksios                         = 0xb977,
        kRieulEuNieun                         = 0xb978,
        kRieulEuNieuncieuc                         = 0xb979,
        kRieulEuNieunhieuh                         = 0xb97a,
        kRieulEuTikeut                         = 0xb97b,
        kRieulEuRieul                         = 0xb97c,
        kRieulEuRieulkiyeok                         = 0xb97d,
        kRieulEuRieulmieum                         = 0xb97e,
        kRieulEuRieulpieup                         = 0xb97f,
        kRieulEuRieulsios                         = 0xb980,
        kRieulEuRieulthieuth                         = 0xb981,
        kRieulEuRieulphieuph                         = 0xb982,
        kRieulEuRieulhieuh                         = 0xb983,
        kRieulEuMieum                         = 0xb984,
        kRieulEuPieup                         = 0xb985,
        kRieulEuPieupsios                         = 0xb986,
        kRieulEuSios                         = 0xb987,
        kRieulEuSsangsios                         = 0xb988,
        kRieulEuIeung                         = 0xb989,
        kRieulEuCieuc                         = 0xb98a,
        kRieulEuChieuch                         = 0xb98b,
        kRieulEuKhieukh                         = 0xb98c,
        kRieulEuThieuth                         = 0xb98d,
        kRieulEuPhieuph                         = 0xb98e,
        kRieulEuHieuh                         = 0xb98f,
        kRieulYi                           = 0xb990,
        kRieulYiKiyeok                         = 0xb991,
        kRieulYiSsangkiyeok                         = 0xb992,
        kRieulYiKiyeoksios                         = 0xb993,
        kRieulYiNieun                         = 0xb994,
        kRieulYiNieuncieuc                         = 0xb995,
        kRieulYiNieunhieuh                         = 0xb996,
        kRieulYiTikeut                         = 0xb997,
        kRieulYiRieul                         = 0xb998,
        kRieulYiRieulkiyeok                         = 0xb999,
        kRieulYiRieulmieum                         = 0xb99a,
        kRieulYiRieulpieup                         = 0xb99b,
        kRieulYiRieulsios                         = 0xb99c,
        kRieulYiRieulthieuth                         = 0xb99d,
        kRieulYiRieulphieuph                         = 0xb99e,
        kRieulYiRieulhieuh                         = 0xb99f,
        kRieulYiMieum                         = 0xb9a0,
        kRieulYiPieup                         = 0xb9a1,
        kRieulYiPieupsios                         = 0xb9a2,
        kRieulYiSios                         = 0xb9a3,
        kRieulYiSsangsios                         = 0xb9a4,
        kRieulYiIeung                         = 0xb9a5,
        kRieulYiCieuc                         = 0xb9a6,
        kRieulYiChieuch                         = 0xb9a7,
        kRieulYiKhieukh                         = 0xb9a8,
        kRieulYiThieuth                         = 0xb9a9,
        kRieulYiPhieuph                         = 0xb9aa,
        kRieulYiHieuh                         = 0xb9ab,
        kRieulI                           = 0xb9ac,
        kRieulIKiyeok                         = 0xb9ad,
        kRieulISsangkiyeok                         = 0xb9ae,
        kRieulIKiyeoksios                         = 0xb9af,
        kRieulINieun                         = 0xb9b0,
        kRieulINieuncieuc                         = 0xb9b1,
        kRieulINieunhieuh                         = 0xb9b2,
        kRieulITikeut                         = 0xb9b3,
        kRieulIRieul                         = 0xb9b4,
        kRieulIRieulkiyeok                         = 0xb9b5,
        kRieulIRieulmieum                         = 0xb9b6,
        kRieulIRieulpieup                         = 0xb9b7,
        kRieulIRieulsios                         = 0xb9b8,
        kRieulIRieulthieuth                         = 0xb9b9,
        kRieulIRieulphieuph                         = 0xb9ba,
        kRieulIRieulhieuh                         = 0xb9bb,
        kRieulIMieum                         = 0xb9bc,
        kRieulIPieup                         = 0xb9bd,
        kRieulIPieupsios                         = 0xb9be,
        kRieulISios                         = 0xb9bf,
        kRieulISsangsios                         = 0xb9c0,
        kRieulIIeung                         = 0xb9c1,
        kRieulICieuc                         = 0xb9c2,
        kRieulIChieuch                         = 0xb9c3,
        kRieulIKhieukh                         = 0xb9c4,
        kRieulIThieuth                         = 0xb9c5,
        kRieulIPhieuph                         = 0xb9c6,
        kRieulIHieuh                         = 0xb9c7,
        kMieumA                           = 0xb9c8,
        kMieumAKiyeok                         = 0xb9c9,
        kMieumASsangkiyeok                         = 0xb9ca,
        kMieumAKiyeoksios                         = 0xb9cb,
        kMieumANieun                         = 0xb9cc,
        kMieumANieuncieuc                         = 0xb9cd,
        kMieumANieunhieuh                         = 0xb9ce,
        kMieumATikeut                         = 0xb9cf,
        kMieumARieul                         = 0xb9d0,
        kMieumARieulkiyeok                         = 0xb9d1,
        kMieumARieulmieum                         = 0xb9d2,
        kMieumARieulpieup                         = 0xb9d3,
        kMieumARieulsios                         = 0xb9d4,
        kMieumARieulthieuth                         = 0xb9d5,
        kMieumARieulphieuph                         = 0xb9d6,
        kMieumARieulhieuh                         = 0xb9d7,
        kMieumAMieum                         = 0xb9d8,
        kMieumAPieup                         = 0xb9d9,
        kMieumAPieupsios                         = 0xb9da,
        kMieumASios                         = 0xb9db,
        kMieumASsangsios                         = 0xb9dc,
        kMieumAIeung                         = 0xb9dd,
        kMieumACieuc                         = 0xb9de,
        kMieumAChieuch                         = 0xb9df,
        kMieumAKhieukh                         = 0xb9e0,
        kMieumAThieuth                         = 0xb9e1,
        kMieumAPhieuph                         = 0xb9e2,
        kMieumAHieuh                         = 0xb9e3,
        kMieumAe                           = 0xb9e4,
        kMieumAeKiyeok                         = 0xb9e5,
        kMieumAeSsangkiyeok                         = 0xb9e6,
        kMieumAeKiyeoksios                         = 0xb9e7,
        kMieumAeNieun                         = 0xb9e8,
        kMieumAeNieuncieuc                         = 0xb9e9,
        kMieumAeNieunhieuh                         = 0xb9ea,
        kMieumAeTikeut                         = 0xb9eb,
        kMieumAeRieul                         = 0xb9ec,
        kMieumAeRieulkiyeok                         = 0xb9ed,
        kMieumAeRieulmieum                         = 0xb9ee,
        kMieumAeRieulpieup                         = 0xb9ef,
        kMieumAeRieulsios                         = 0xb9f0,
        kMieumAeRieulthieuth                         = 0xb9f1,
        kMieumAeRieulphieuph                         = 0xb9f2,
        kMieumAeRieulhieuh                         = 0xb9f3,
        kMieumAeMieum                         = 0xb9f4,
        kMieumAePieup                         = 0xb9f5,
        kMieumAePieupsios                         = 0xb9f6,
        kMieumAeSios                         = 0xb9f7,
        kMieumAeSsangsios                         = 0xb9f8,
        kMieumAeIeung                         = 0xb9f9,
        kMieumAeCieuc                         = 0xb9fa,
        kMieumAeChieuch                         = 0xb9fb,
        kMieumAeKhieukh                         = 0xb9fc,
        kMieumAeThieuth                         = 0xb9fd,
        kMieumAePhieuph                         = 0xb9fe,
        kMieumAeHieuh                         = 0xb9ff,
        kMieumYa                           = 0xba00,
        kMieumYaKiyeok                         = 0xba01,
        kMieumYaSsangkiyeok                         = 0xba02,
        kMieumYaKiyeoksios                         = 0xba03,
        kMieumYaNieun                         = 0xba04,
        kMieumYaNieuncieuc                         = 0xba05,
        kMieumYaNieunhieuh                         = 0xba06,
        kMieumYaTikeut                         = 0xba07,
        kMieumYaRieul                         = 0xba08,
        kMieumYaRieulkiyeok                         = 0xba09,
        kMieumYaRieulmieum                         = 0xba0a,
        kMieumYaRieulpieup                         = 0xba0b,
        kMieumYaRieulsios                         = 0xba0c,
        kMieumYaRieulthieuth                         = 0xba0d,
        kMieumYaRieulphieuph                         = 0xba0e,
        kMieumYaRieulhieuh                         = 0xba0f,
        kMieumYaMieum                         = 0xba10,
        kMieumYaPieup                         = 0xba11,
        kMieumYaPieupsios                         = 0xba12,
        kMieumYaSios                         = 0xba13,
        kMieumYaSsangsios                         = 0xba14,
        kMieumYaIeung                         = 0xba15,
        kMieumYaCieuc                         = 0xba16,
        kMieumYaChieuch                         = 0xba17,
        kMieumYaKhieukh                         = 0xba18,
        kMieumYaThieuth                         = 0xba19,
        kMieumYaPhieuph                         = 0xba1a,
        kMieumYaHieuh                         = 0xba1b,
        kMieumYae                           = 0xba1c,
        kMieumYaeKiyeok                         = 0xba1d,
        kMieumYaeSsangkiyeok                         = 0xba1e,
        kMieumYaeKiyeoksios                         = 0xba1f,
        kMieumYaeNieun                         = 0xba20,
        kMieumYaeNieuncieuc                         = 0xba21,
        kMieumYaeNieunhieuh                         = 0xba22,
        kMieumYaeTikeut                         = 0xba23,
        kMieumYaeRieul                         = 0xba24,
        kMieumYaeRieulkiyeok                         = 0xba25,
        kMieumYaeRieulmieum                         = 0xba26,
        kMieumYaeRieulpieup                         = 0xba27,
        kMieumYaeRieulsios                         = 0xba28,
        kMieumYaeRieulthieuth                         = 0xba29,
        kMieumYaeRieulphieuph                         = 0xba2a,
        kMieumYaeRieulhieuh                         = 0xba2b,
        kMieumYaeMieum                         = 0xba2c,
        kMieumYaePieup                         = 0xba2d,
        kMieumYaePieupsios                         = 0xba2e,
        kMieumYaeSios                         = 0xba2f,
        kMieumYaeSsangsios                         = 0xba30,
        kMieumYaeIeung                         = 0xba31,
        kMieumYaeCieuc                         = 0xba32,
        kMieumYaeChieuch                         = 0xba33,
        kMieumYaeKhieukh                         = 0xba34,
        kMieumYaeThieuth                         = 0xba35,
        kMieumYaePhieuph                         = 0xba36,
        kMieumYaeHieuh                         = 0xba37,
        kMieumEo                           = 0xba38,
        kMieumEoKiyeok                         = 0xba39,
        kMieumEoSsangkiyeok                         = 0xba3a,
        kMieumEoKiyeoksios                         = 0xba3b,
        kMieumEoNieun                         = 0xba3c,
        kMieumEoNieuncieuc                         = 0xba3d,
        kMieumEoNieunhieuh                         = 0xba3e,
        kMieumEoTikeut                         = 0xba3f,
        kMieumEoRieul                         = 0xba40,
        kMieumEoRieulkiyeok                         = 0xba41,
        kMieumEoRieulmieum                         = 0xba42,
        kMieumEoRieulpieup                         = 0xba43,
        kMieumEoRieulsios                         = 0xba44,
        kMieumEoRieulthieuth                         = 0xba45,
        kMieumEoRieulphieuph                         = 0xba46,
        kMieumEoRieulhieuh                         = 0xba47,
        kMieumEoMieum                         = 0xba48,
        kMieumEoPieup                         = 0xba49,
        kMieumEoPieupsios                         = 0xba4a,
        kMieumEoSios                         = 0xba4b,
        kMieumEoSsangsios                         = 0xba4c,
        kMieumEoIeung                         = 0xba4d,
        kMieumEoCieuc                         = 0xba4e,
        kMieumEoChieuch                         = 0xba4f,
        kMieumEoKhieukh                         = 0xba50,
        kMieumEoThieuth                         = 0xba51,
        kMieumEoPhieuph                         = 0xba52,
        kMieumEoHieuh                         = 0xba53,
        kMieumE                           = 0xba54,
        kMieumEKiyeok                         = 0xba55,
        kMieumESsangkiyeok                         = 0xba56,
        kMieumEKiyeoksios                         = 0xba57,
        kMieumENieun                         = 0xba58,
        kMieumENieuncieuc                         = 0xba59,
        kMieumENieunhieuh                         = 0xba5a,
        kMieumETikeut                         = 0xba5b,
        kMieumERieul                         = 0xba5c,
        kMieumERieulkiyeok                         = 0xba5d,
        kMieumERieulmieum                         = 0xba5e,
        kMieumERieulpieup                         = 0xba5f,
        kMieumERieulsios                         = 0xba60,
        kMieumERieulthieuth                         = 0xba61,
        kMieumERieulphieuph                         = 0xba62,
        kMieumERieulhieuh                         = 0xba63,
        kMieumEMieum                         = 0xba64,
        kMieumEPieup                         = 0xba65,
        kMieumEPieupsios                         = 0xba66,
        kMieumESios                         = 0xba67,
        kMieumESsangsios                         = 0xba68,
        kMieumEIeung                         = 0xba69,
        kMieumECieuc                         = 0xba6a,
        kMieumEChieuch                         = 0xba6b,
        kMieumEKhieukh                         = 0xba6c,
        kMieumEThieuth                         = 0xba6d,
        kMieumEPhieuph                         = 0xba6e,
        kMieumEHieuh                         = 0xba6f,
        kMieumYeo                           = 0xba70,
        kMieumYeoKiyeok                         = 0xba71,
        kMieumYeoSsangkiyeok                         = 0xba72,
        kMieumYeoKiyeoksios                         = 0xba73,
        kMieumYeoNieun                         = 0xba74,
        kMieumYeoNieuncieuc                         = 0xba75,
        kMieumYeoNieunhieuh                         = 0xba76,
        kMieumYeoTikeut                         = 0xba77,
        kMieumYeoRieul                         = 0xba78,
        kMieumYeoRieulkiyeok                         = 0xba79,
        kMieumYeoRieulmieum                         = 0xba7a,
        kMieumYeoRieulpieup                         = 0xba7b,
        kMieumYeoRieulsios                         = 0xba7c,
        kMieumYeoRieulthieuth                         = 0xba7d,
        kMieumYeoRieulphieuph                         = 0xba7e,
        kMieumYeoRieulhieuh                         = 0xba7f,
        kMieumYeoMieum                         = 0xba80,
        kMieumYeoPieup                         = 0xba81,
        kMieumYeoPieupsios                         = 0xba82,
        kMieumYeoSios                         = 0xba83,
        kMieumYeoSsangsios                         = 0xba84,
        kMieumYeoIeung                         = 0xba85,
        kMieumYeoCieuc                         = 0xba86,
        kMieumYeoChieuch                         = 0xba87,
        kMieumYeoKhieukh                         = 0xba88,
        kMieumYeoThieuth                         = 0xba89,
        kMieumYeoPhieuph                         = 0xba8a,
        kMieumYeoHieuh                         = 0xba8b,
        kMieumYe                           = 0xba8c,
        kMieumYeKiyeok                         = 0xba8d,
        kMieumYeSsangkiyeok                         = 0xba8e,
        kMieumYeKiyeoksios                         = 0xba8f,
        kMieumYeNieun                         = 0xba90,
        kMieumYeNieuncieuc                         = 0xba91,
        kMieumYeNieunhieuh                         = 0xba92,
        kMieumYeTikeut                         = 0xba93,
        kMieumYeRieul                         = 0xba94,
        kMieumYeRieulkiyeok                         = 0xba95,
        kMieumYeRieulmieum                         = 0xba96,
        kMieumYeRieulpieup                         = 0xba97,
        kMieumYeRieulsios                         = 0xba98,
        kMieumYeRieulthieuth                         = 0xba99,
        kMieumYeRieulphieuph                         = 0xba9a,
        kMieumYeRieulhieuh                         = 0xba9b,
        kMieumYeMieum                         = 0xba9c,
        kMieumYePieup                         = 0xba9d,
        kMieumYePieupsios                         = 0xba9e,
        kMieumYeSios                         = 0xba9f,
        kMieumYeSsangsios                         = 0xbaa0,
        kMieumYeIeung                         = 0xbaa1,
        kMieumYeCieuc                         = 0xbaa2,
        kMieumYeChieuch                         = 0xbaa3,
        kMieumYeKhieukh                         = 0xbaa4,
        kMieumYeThieuth                         = 0xbaa5,
        kMieumYePhieuph                         = 0xbaa6,
        kMieumYeHieuh                         = 0xbaa7,
        kMieumO                           = 0xbaa8,
        kMieumOKiyeok                         = 0xbaa9,
        kMieumOSsangkiyeok                         = 0xbaaa,
        kMieumOKiyeoksios                         = 0xbaab,
        kMieumONieun                         = 0xbaac,
        kMieumONieuncieuc                         = 0xbaad,
        kMieumONieunhieuh                         = 0xbaae,
        kMieumOTikeut                         = 0xbaaf,
        kMieumORieul                         = 0xbab0,
        kMieumORieulkiyeok                         = 0xbab1,
        kMieumORieulmieum                         = 0xbab2,
        kMieumORieulpieup                         = 0xbab3,
        kMieumORieulsios                         = 0xbab4,
        kMieumORieulthieuth                         = 0xbab5,
        kMieumORieulphieuph                         = 0xbab6,
        kMieumORieulhieuh                         = 0xbab7,
        kMieumOMieum                         = 0xbab8,
        kMieumOPieup                         = 0xbab9,
        kMieumOPieupsios                         = 0xbaba,
        kMieumOSios                         = 0xbabb,
        kMieumOSsangsios                         = 0xbabc,
        kMieumOIeung                         = 0xbabd,
        kMieumOCieuc                         = 0xbabe,
        kMieumOChieuch                         = 0xbabf,
        kMieumOKhieukh                         = 0xbac0,
        kMieumOThieuth                         = 0xbac1,
        kMieumOPhieuph                         = 0xbac2,
        kMieumOHieuh                         = 0xbac3,
        kMieumWa                           = 0xbac4,
        kMieumWaKiyeok                         = 0xbac5,
        kMieumWaSsangkiyeok                         = 0xbac6,
        kMieumWaKiyeoksios                         = 0xbac7,
        kMieumWaNieun                         = 0xbac8,
        kMieumWaNieuncieuc                         = 0xbac9,
        kMieumWaNieunhieuh                         = 0xbaca,
        kMieumWaTikeut                         = 0xbacb,
        kMieumWaRieul                         = 0xbacc,
        kMieumWaRieulkiyeok                         = 0xbacd,
        kMieumWaRieulmieum                         = 0xbace,
        kMieumWaRieulpieup                         = 0xbacf,
        kMieumWaRieulsios                         = 0xbad0,
        kMieumWaRieulthieuth                         = 0xbad1,
        kMieumWaRieulphieuph                         = 0xbad2,
        kMieumWaRieulhieuh                         = 0xbad3,
        kMieumWaMieum                         = 0xbad4,
        kMieumWaPieup                         = 0xbad5,
        kMieumWaPieupsios                         = 0xbad6,
        kMieumWaSios                         = 0xbad7,
        kMieumWaSsangsios                         = 0xbad8,
        kMieumWaIeung                         = 0xbad9,
        kMieumWaCieuc                         = 0xbada,
        kMieumWaChieuch                         = 0xbadb,
        kMieumWaKhieukh                         = 0xbadc,
        kMieumWaThieuth                         = 0xbadd,
        kMieumWaPhieuph                         = 0xbade,
        kMieumWaHieuh                         = 0xbadf,
        kMieumWae                           = 0xbae0,
        kMieumWaeKiyeok                         = 0xbae1,
        kMieumWaeSsangkiyeok                         = 0xbae2,
        kMieumWaeKiyeoksios                         = 0xbae3,
        kMieumWaeNieun                         = 0xbae4,
        kMieumWaeNieuncieuc                         = 0xbae5,
        kMieumWaeNieunhieuh                         = 0xbae6,
        kMieumWaeTikeut                         = 0xbae7,
        kMieumWaeRieul                         = 0xbae8,
        kMieumWaeRieulkiyeok                         = 0xbae9,
        kMieumWaeRieulmieum                         = 0xbaea,
        kMieumWaeRieulpieup                         = 0xbaeb,
        kMieumWaeRieulsios                         = 0xbaec,
        kMieumWaeRieulthieuth                         = 0xbaed,
        kMieumWaeRieulphieuph                         = 0xbaee,
        kMieumWaeRieulhieuh                         = 0xbaef,
        kMieumWaeMieum                         = 0xbaf0,
        kMieumWaePieup                         = 0xbaf1,
        kMieumWaePieupsios                         = 0xbaf2,
        kMieumWaeSios                         = 0xbaf3,
        kMieumWaeSsangsios                         = 0xbaf4,
        kMieumWaeIeung                         = 0xbaf5,
        kMieumWaeCieuc                         = 0xbaf6,
        kMieumWaeChieuch                         = 0xbaf7,
        kMieumWaeKhieukh                         = 0xbaf8,
        kMieumWaeThieuth                         = 0xbaf9,
        kMieumWaePhieuph                         = 0xbafa,
        kMieumWaeHieuh                         = 0xbafb,
        kMieumOe                           = 0xbafc,
        kMieumOeKiyeok                         = 0xbafd,
        kMieumOeSsangkiyeok                         = 0xbafe,
        kMieumOeKiyeoksios                         = 0xbaff,
        kMieumOeNieun                         = 0xbb00,
        kMieumOeNieuncieuc                         = 0xbb01,
        kMieumOeNieunhieuh                         = 0xbb02,
        kMieumOeTikeut                         = 0xbb03,
        kMieumOeRieul                         = 0xbb04,
        kMieumOeRieulkiyeok                         = 0xbb05,
        kMieumOeRieulmieum                         = 0xbb06,
        kMieumOeRieulpieup                         = 0xbb07,
        kMieumOeRieulsios                         = 0xbb08,
        kMieumOeRieulthieuth                         = 0xbb09,
        kMieumOeRieulphieuph                         = 0xbb0a,
        kMieumOeRieulhieuh                         = 0xbb0b,
        kMieumOeMieum                         = 0xbb0c,
        kMieumOePieup                         = 0xbb0d,
        kMieumOePieupsios                         = 0xbb0e,
        kMieumOeSios                         = 0xbb0f,
        kMieumOeSsangsios                         = 0xbb10,
        kMieumOeIeung                         = 0xbb11,
        kMieumOeCieuc                         = 0xbb12,
        kMieumOeChieuch                         = 0xbb13,
        kMieumOeKhieukh                         = 0xbb14,
        kMieumOeThieuth                         = 0xbb15,
        kMieumOePhieuph                         = 0xbb16,
        kMieumOeHieuh                         = 0xbb17,
        kMieumYo                           = 0xbb18,
        kMieumYoKiyeok                         = 0xbb19,
        kMieumYoSsangkiyeok                         = 0xbb1a,
        kMieumYoKiyeoksios                         = 0xbb1b,
        kMieumYoNieun                         = 0xbb1c,
        kMieumYoNieuncieuc                         = 0xbb1d,
        kMieumYoNieunhieuh                         = 0xbb1e,
        kMieumYoTikeut                         = 0xbb1f,
        kMieumYoRieul                         = 0xbb20,
        kMieumYoRieulkiyeok                         = 0xbb21,
        kMieumYoRieulmieum                         = 0xbb22,
        kMieumYoRieulpieup                         = 0xbb23,
        kMieumYoRieulsios                         = 0xbb24,
        kMieumYoRieulthieuth                         = 0xbb25,
        kMieumYoRieulphieuph                         = 0xbb26,
        kMieumYoRieulhieuh                         = 0xbb27,
        kMieumYoMieum                         = 0xbb28,
        kMieumYoPieup                         = 0xbb29,
        kMieumYoPieupsios                         = 0xbb2a,
        kMieumYoSios                         = 0xbb2b,
        kMieumYoSsangsios                         = 0xbb2c,
        kMieumYoIeung                         = 0xbb2d,
        kMieumYoCieuc                         = 0xbb2e,
        kMieumYoChieuch                         = 0xbb2f,
        kMieumYoKhieukh                         = 0xbb30,
        kMieumYoThieuth                         = 0xbb31,
        kMieumYoPhieuph                         = 0xbb32,
        kMieumYoHieuh                         = 0xbb33,
        kMieumU                           = 0xbb34,
        kMieumUKiyeok                         = 0xbb35,
        kMieumUSsangkiyeok                         = 0xbb36,
        kMieumUKiyeoksios                         = 0xbb37,
        kMieumUNieun                         = 0xbb38,
        kMieumUNieuncieuc                         = 0xbb39,
        kMieumUNieunhieuh                         = 0xbb3a,
        kMieumUTikeut                         = 0xbb3b,
        kMieumURieul                         = 0xbb3c,
        kMieumURieulkiyeok                         = 0xbb3d,
        kMieumURieulmieum                         = 0xbb3e,
        kMieumURieulpieup                         = 0xbb3f,
        kMieumURieulsios                         = 0xbb40,
        kMieumURieulthieuth                         = 0xbb41,
        kMieumURieulphieuph                         = 0xbb42,
        kMieumURieulhieuh                         = 0xbb43,
        kMieumUMieum                         = 0xbb44,
        kMieumUPieup                         = 0xbb45,
        kMieumUPieupsios                         = 0xbb46,
        kMieumUSios                         = 0xbb47,
        kMieumUSsangsios                         = 0xbb48,
        kMieumUIeung                         = 0xbb49,
        kMieumUCieuc                         = 0xbb4a,
        kMieumUChieuch                         = 0xbb4b,
        kMieumUKhieukh                         = 0xbb4c,
        kMieumUThieuth                         = 0xbb4d,
        kMieumUPhieuph                         = 0xbb4e,
        kMieumUHieuh                         = 0xbb4f,
        kMieumWeo                           = 0xbb50,
        kMieumWeoKiyeok                         = 0xbb51,
        kMieumWeoSsangkiyeok                         = 0xbb52,
        kMieumWeoKiyeoksios                         = 0xbb53,
        kMieumWeoNieun                         = 0xbb54,
        kMieumWeoNieuncieuc                         = 0xbb55,
        kMieumWeoNieunhieuh                         = 0xbb56,
        kMieumWeoTikeut                         = 0xbb57,
        kMieumWeoRieul                         = 0xbb58,
        kMieumWeoRieulkiyeok                         = 0xbb59,
        kMieumWeoRieulmieum                         = 0xbb5a,
        kMieumWeoRieulpieup                         = 0xbb5b,
        kMieumWeoRieulsios                         = 0xbb5c,
        kMieumWeoRieulthieuth                         = 0xbb5d,
        kMieumWeoRieulphieuph                         = 0xbb5e,
        kMieumWeoRieulhieuh                         = 0xbb5f,
        kMieumWeoMieum                         = 0xbb60,
        kMieumWeoPieup                         = 0xbb61,
        kMieumWeoPieupsios                         = 0xbb62,
        kMieumWeoSios                         = 0xbb63,
        kMieumWeoSsangsios                         = 0xbb64,
        kMieumWeoIeung                         = 0xbb65,
        kMieumWeoCieuc                         = 0xbb66,
        kMieumWeoChieuch                         = 0xbb67,
        kMieumWeoKhieukh                         = 0xbb68,
        kMieumWeoThieuth                         = 0xbb69,
        kMieumWeoPhieuph                         = 0xbb6a,
        kMieumWeoHieuh                         = 0xbb6b,
        kMieumWe                           = 0xbb6c,
        kMieumWeKiyeok                         = 0xbb6d,
        kMieumWeSsangkiyeok                         = 0xbb6e,
        kMieumWeKiyeoksios                         = 0xbb6f,
        kMieumWeNieun                         = 0xbb70,
        kMieumWeNieuncieuc                         = 0xbb71,
        kMieumWeNieunhieuh                         = 0xbb72,
        kMieumWeTikeut                         = 0xbb73,
        kMieumWeRieul                         = 0xbb74,
        kMieumWeRieulkiyeok                         = 0xbb75,
        kMieumWeRieulmieum                         = 0xbb76,
        kMieumWeRieulpieup                         = 0xbb77,
        kMieumWeRieulsios                         = 0xbb78,
        kMieumWeRieulthieuth                         = 0xbb79,
        kMieumWeRieulphieuph                         = 0xbb7a,
        kMieumWeRieulhieuh                         = 0xbb7b,
        kMieumWeMieum                         = 0xbb7c,
        kMieumWePieup                         = 0xbb7d,
        kMieumWePieupsios                         = 0xbb7e,
        kMieumWeSios                         = 0xbb7f,
        kMieumWeSsangsios                         = 0xbb80,
        kMieumWeIeung                         = 0xbb81,
        kMieumWeCieuc                         = 0xbb82,
        kMieumWeChieuch                         = 0xbb83,
        kMieumWeKhieukh                         = 0xbb84,
        kMieumWeThieuth                         = 0xbb85,
        kMieumWePhieuph                         = 0xbb86,
        kMieumWeHieuh                         = 0xbb87,
        kMieumWi                           = 0xbb88,
        kMieumWiKiyeok                         = 0xbb89,
        kMieumWiSsangkiyeok                         = 0xbb8a,
        kMieumWiKiyeoksios                         = 0xbb8b,
        kMieumWiNieun                         = 0xbb8c,
        kMieumWiNieuncieuc                         = 0xbb8d,
        kMieumWiNieunhieuh                         = 0xbb8e,
        kMieumWiTikeut                         = 0xbb8f,
        kMieumWiRieul                         = 0xbb90,
        kMieumWiRieulkiyeok                         = 0xbb91,
        kMieumWiRieulmieum                         = 0xbb92,
        kMieumWiRieulpieup                         = 0xbb93,
        kMieumWiRieulsios                         = 0xbb94,
        kMieumWiRieulthieuth                         = 0xbb95,
        kMieumWiRieulphieuph                         = 0xbb96,
        kMieumWiRieulhieuh                         = 0xbb97,
        kMieumWiMieum                         = 0xbb98,
        kMieumWiPieup                         = 0xbb99,
        kMieumWiPieupsios                         = 0xbb9a,
        kMieumWiSios                         = 0xbb9b,
        kMieumWiSsangsios                         = 0xbb9c,
        kMieumWiIeung                         = 0xbb9d,
        kMieumWiCieuc                         = 0xbb9e,
        kMieumWiChieuch                         = 0xbb9f,
        kMieumWiKhieukh                         = 0xbba0,
        kMieumWiThieuth                         = 0xbba1,
        kMieumWiPhieuph                         = 0xbba2,
        kMieumWiHieuh                         = 0xbba3,
        kMieumYu                           = 0xbba4,
        kMieumYuKiyeok                         = 0xbba5,
        kMieumYuSsangkiyeok                         = 0xbba6,
        kMieumYuKiyeoksios                         = 0xbba7,
        kMieumYuNieun                         = 0xbba8,
        kMieumYuNieuncieuc                         = 0xbba9,
        kMieumYuNieunhieuh                         = 0xbbaa,
        kMieumYuTikeut                         = 0xbbab,
        kMieumYuRieul                         = 0xbbac,
        kMieumYuRieulkiyeok                         = 0xbbad,
        kMieumYuRieulmieum                         = 0xbbae,
        kMieumYuRieulpieup                         = 0xbbaf,
        kMieumYuRieulsios                         = 0xbbb0,
        kMieumYuRieulthieuth                         = 0xbbb1,
        kMieumYuRieulphieuph                         = 0xbbb2,
        kMieumYuRieulhieuh                         = 0xbbb3,
        kMieumYuMieum                         = 0xbbb4,
        kMieumYuPieup                         = 0xbbb5,
        kMieumYuPieupsios                         = 0xbbb6,
        kMieumYuSios                         = 0xbbb7,
        kMieumYuSsangsios                         = 0xbbb8,
        kMieumYuIeung                         = 0xbbb9,
        kMieumYuCieuc                         = 0xbbba,
        kMieumYuChieuch                         = 0xbbbb,
        kMieumYuKhieukh                         = 0xbbbc,
        kMieumYuThieuth                         = 0xbbbd,
        kMieumYuPhieuph                         = 0xbbbe,
        kMieumYuHieuh                         = 0xbbbf,
        kMieumEu                           = 0xbbc0,
        kMieumEuKiyeok                         = 0xbbc1,
        kMieumEuSsangkiyeok                         = 0xbbc2,
        kMieumEuKiyeoksios                         = 0xbbc3,
        kMieumEuNieun                         = 0xbbc4,
        kMieumEuNieuncieuc                         = 0xbbc5,
        kMieumEuNieunhieuh                         = 0xbbc6,
        kMieumEuTikeut                         = 0xbbc7,
        kMieumEuRieul                         = 0xbbc8,
        kMieumEuRieulkiyeok                         = 0xbbc9,
        kMieumEuRieulmieum                         = 0xbbca,
        kMieumEuRieulpieup                         = 0xbbcb,
        kMieumEuRieulsios                         = 0xbbcc,
        kMieumEuRieulthieuth                         = 0xbbcd,
        kMieumEuRieulphieuph                         = 0xbbce,
        kMieumEuRieulhieuh                         = 0xbbcf,
        kMieumEuMieum                         = 0xbbd0,
        kMieumEuPieup                         = 0xbbd1,
        kMieumEuPieupsios                         = 0xbbd2,
        kMieumEuSios                         = 0xbbd3,
        kMieumEuSsangsios                         = 0xbbd4,
        kMieumEuIeung                         = 0xbbd5,
        kMieumEuCieuc                         = 0xbbd6,
        kMieumEuChieuch                         = 0xbbd7,
        kMieumEuKhieukh                         = 0xbbd8,
        kMieumEuThieuth                         = 0xbbd9,
        kMieumEuPhieuph                         = 0xbbda,
        kMieumEuHieuh                         = 0xbbdb,
        kMieumYi                           = 0xbbdc,
        kMieumYiKiyeok                         = 0xbbdd,
        kMieumYiSsangkiyeok                         = 0xbbde,
        kMieumYiKiyeoksios                         = 0xbbdf,
        kMieumYiNieun                         = 0xbbe0,
        kMieumYiNieuncieuc                         = 0xbbe1,
        kMieumYiNieunhieuh                         = 0xbbe2,
        kMieumYiTikeut                         = 0xbbe3,
        kMieumYiRieul                         = 0xbbe4,
        kMieumYiRieulkiyeok                         = 0xbbe5,
        kMieumYiRieulmieum                         = 0xbbe6,
        kMieumYiRieulpieup                         = 0xbbe7,
        kMieumYiRieulsios                         = 0xbbe8,
        kMieumYiRieulthieuth                         = 0xbbe9,
        kMieumYiRieulphieuph                         = 0xbbea,
        kMieumYiRieulhieuh                         = 0xbbeb,
        kMieumYiMieum                         = 0xbbec,
        kMieumYiPieup                         = 0xbbed,
        kMieumYiPieupsios                         = 0xbbee,
        kMieumYiSios                         = 0xbbef,
        kMieumYiSsangsios                         = 0xbbf0,
        kMieumYiIeung                         = 0xbbf1,
        kMieumYiCieuc                         = 0xbbf2,
        kMieumYiChieuch                         = 0xbbf3,
        kMieumYiKhieukh                         = 0xbbf4,
        kMieumYiThieuth                         = 0xbbf5,
        kMieumYiPhieuph                         = 0xbbf6,
        kMieumYiHieuh                         = 0xbbf7,
        kMieumI                           = 0xbbf8,
        kMieumIKiyeok                         = 0xbbf9,
        kMieumISsangkiyeok                         = 0xbbfa,
        kMieumIKiyeoksios                         = 0xbbfb,
        kMieumINieun                         = 0xbbfc,
        kMieumINieuncieuc                         = 0xbbfd,
        kMieumINieunhieuh                         = 0xbbfe,
        kMieumITikeut                         = 0xbbff,
        kMieumIRieul                         = 0xbc00,
        kMieumIRieulkiyeok                         = 0xbc01,
        kMieumIRieulmieum                         = 0xbc02,
        kMieumIRieulpieup                         = 0xbc03,
        kMieumIRieulsios                         = 0xbc04,
        kMieumIRieulthieuth                         = 0xbc05,
        kMieumIRieulphieuph                         = 0xbc06,
        kMieumIRieulhieuh                         = 0xbc07,
        kMieumIMieum                         = 0xbc08,
        kMieumIPieup                         = 0xbc09,
        kMieumIPieupsios                         = 0xbc0a,
        kMieumISios                         = 0xbc0b,
        kMieumISsangsios                         = 0xbc0c,
        kMieumIIeung                         = 0xbc0d,
        kMieumICieuc                         = 0xbc0e,
        kMieumIChieuch                         = 0xbc0f,
        kMieumIKhieukh                         = 0xbc10,
        kMieumIThieuth                         = 0xbc11,
        kMieumIPhieuph                         = 0xbc12,
        kMieumIHieuh                         = 0xbc13,
        kPieupA                           = 0xbc14,
        kPieupAKiyeok                         = 0xbc15,
        kPieupASsangkiyeok                         = 0xbc16,
        kPieupAKiyeoksios                         = 0xbc17,
        kPieupANieun                         = 0xbc18,
        kPieupANieuncieuc                         = 0xbc19,
        kPieupANieunhieuh                         = 0xbc1a,
        kPieupATikeut                         = 0xbc1b,
        kPieupARieul                         = 0xbc1c,
        kPieupARieulkiyeok                         = 0xbc1d,
        kPieupARieulmieum                         = 0xbc1e,
        kPieupARieulpieup                         = 0xbc1f,
        kPieupARieulsios                         = 0xbc20,
        kPieupARieulthieuth                         = 0xbc21,
        kPieupARieulphieuph                         = 0xbc22,
        kPieupARieulhieuh                         = 0xbc23,
        kPieupAMieum                         = 0xbc24,
        kPieupAPieup                         = 0xbc25,
        kPieupAPieupsios                         = 0xbc26,
        kPieupASios                         = 0xbc27,
        kPieupASsangsios                         = 0xbc28,
        kPieupAIeung                         = 0xbc29,
        kPieupACieuc                         = 0xbc2a,
        kPieupAChieuch                         = 0xbc2b,
        kPieupAKhieukh                         = 0xbc2c,
        kPieupAThieuth                         = 0xbc2d,
        kPieupAPhieuph                         = 0xbc2e,
        kPieupAHieuh                         = 0xbc2f,
        kPieupAe                           = 0xbc30,
        kPieupAeKiyeok                         = 0xbc31,
        kPieupAeSsangkiyeok                         = 0xbc32,
        kPieupAeKiyeoksios                         = 0xbc33,
        kPieupAeNieun                         = 0xbc34,
        kPieupAeNieuncieuc                         = 0xbc35,
        kPieupAeNieunhieuh                         = 0xbc36,
        kPieupAeTikeut                         = 0xbc37,
        kPieupAeRieul                         = 0xbc38,
        kPieupAeRieulkiyeok                         = 0xbc39,
        kPieupAeRieulmieum                         = 0xbc3a,
        kPieupAeRieulpieup                         = 0xbc3b,
        kPieupAeRieulsios                         = 0xbc3c,
        kPieupAeRieulthieuth                         = 0xbc3d,
        kPieupAeRieulphieuph                         = 0xbc3e,
        kPieupAeRieulhieuh                         = 0xbc3f,
        kPieupAeMieum                         = 0xbc40,
        kPieupAePieup                         = 0xbc41,
        kPieupAePieupsios                         = 0xbc42,
        kPieupAeSios                         = 0xbc43,
        kPieupAeSsangsios                         = 0xbc44,
        kPieupAeIeung                         = 0xbc45,
        kPieupAeCieuc                         = 0xbc46,
        kPieupAeChieuch                         = 0xbc47,
        kPieupAeKhieukh                         = 0xbc48,
        kPieupAeThieuth                         = 0xbc49,
        kPieupAePhieuph                         = 0xbc4a,
        kPieupAeHieuh                         = 0xbc4b,
        kPieupYa                           = 0xbc4c,
        kPieupYaKiyeok                         = 0xbc4d,
        kPieupYaSsangkiyeok                         = 0xbc4e,
        kPieupYaKiyeoksios                         = 0xbc4f,
        kPieupYaNieun                         = 0xbc50,
        kPieupYaNieuncieuc                         = 0xbc51,
        kPieupYaNieunhieuh                         = 0xbc52,
        kPieupYaTikeut                         = 0xbc53,
        kPieupYaRieul                         = 0xbc54,
        kPieupYaRieulkiyeok                         = 0xbc55,
        kPieupYaRieulmieum                         = 0xbc56,
        kPieupYaRieulpieup                         = 0xbc57,
        kPieupYaRieulsios                         = 0xbc58,
        kPieupYaRieulthieuth                         = 0xbc59,
        kPieupYaRieulphieuph                         = 0xbc5a,
        kPieupYaRieulhieuh                         = 0xbc5b,
        kPieupYaMieum                         = 0xbc5c,
        kPieupYaPieup                         = 0xbc5d,
        kPieupYaPieupsios                         = 0xbc5e,
        kPieupYaSios                         = 0xbc5f,
        kPieupYaSsangsios                         = 0xbc60,
        kPieupYaIeung                         = 0xbc61,
        kPieupYaCieuc                         = 0xbc62,
        kPieupYaChieuch                         = 0xbc63,
        kPieupYaKhieukh                         = 0xbc64,
        kPieupYaThieuth                         = 0xbc65,
        kPieupYaPhieuph                         = 0xbc66,
        kPieupYaHieuh                         = 0xbc67,
        kPieupYae                           = 0xbc68,
        kPieupYaeKiyeok                         = 0xbc69,
        kPieupYaeSsangkiyeok                         = 0xbc6a,
        kPieupYaeKiyeoksios                         = 0xbc6b,
        kPieupYaeNieun                         = 0xbc6c,
        kPieupYaeNieuncieuc                         = 0xbc6d,
        kPieupYaeNieunhieuh                         = 0xbc6e,
        kPieupYaeTikeut                         = 0xbc6f,
        kPieupYaeRieul                         = 0xbc70,
        kPieupYaeRieulkiyeok                         = 0xbc71,
        kPieupYaeRieulmieum                         = 0xbc72,
        kPieupYaeRieulpieup                         = 0xbc73,
        kPieupYaeRieulsios                         = 0xbc74,
        kPieupYaeRieulthieuth                         = 0xbc75,
        kPieupYaeRieulphieuph                         = 0xbc76,
        kPieupYaeRieulhieuh                         = 0xbc77,
        kPieupYaeMieum                         = 0xbc78,
        kPieupYaePieup                         = 0xbc79,
        kPieupYaePieupsios                         = 0xbc7a,
        kPieupYaeSios                         = 0xbc7b,
        kPieupYaeSsangsios                         = 0xbc7c,
        kPieupYaeIeung                         = 0xbc7d,
        kPieupYaeCieuc                         = 0xbc7e,
        kPieupYaeChieuch                         = 0xbc7f,
        kPieupYaeKhieukh                         = 0xbc80,
        kPieupYaeThieuth                         = 0xbc81,
        kPieupYaePhieuph                         = 0xbc82,
        kPieupYaeHieuh                         = 0xbc83,
        kPieupEo                           = 0xbc84,
        kPieupEoKiyeok                         = 0xbc85,
        kPieupEoSsangkiyeok                         = 0xbc86,
        kPieupEoKiyeoksios                         = 0xbc87,
        kPieupEoNieun                         = 0xbc88,
        kPieupEoNieuncieuc                         = 0xbc89,
        kPieupEoNieunhieuh                         = 0xbc8a,
        kPieupEoTikeut                         = 0xbc8b,
        kPieupEoRieul                         = 0xbc8c,
        kPieupEoRieulkiyeok                         = 0xbc8d,
        kPieupEoRieulmieum                         = 0xbc8e,
        kPieupEoRieulpieup                         = 0xbc8f,
        kPieupEoRieulsios                         = 0xbc90,
        kPieupEoRieulthieuth                         = 0xbc91,
        kPieupEoRieulphieuph                         = 0xbc92,
        kPieupEoRieulhieuh                         = 0xbc93,
        kPieupEoMieum                         = 0xbc94,
        kPieupEoPieup                         = 0xbc95,
        kPieupEoPieupsios                         = 0xbc96,
        kPieupEoSios                         = 0xbc97,
        kPieupEoSsangsios                         = 0xbc98,
        kPieupEoIeung                         = 0xbc99,
        kPieupEoCieuc                         = 0xbc9a,
        kPieupEoChieuch                         = 0xbc9b,
        kPieupEoKhieukh                         = 0xbc9c,
        kPieupEoThieuth                         = 0xbc9d,
        kPieupEoPhieuph                         = 0xbc9e,
        kPieupEoHieuh                         = 0xbc9f,
        kPieupE                           = 0xbca0,
        kPieupEKiyeok                         = 0xbca1,
        kPieupESsangkiyeok                         = 0xbca2,
        kPieupEKiyeoksios                         = 0xbca3,
        kPieupENieun                         = 0xbca4,
        kPieupENieuncieuc                         = 0xbca5,
        kPieupENieunhieuh                         = 0xbca6,
        kPieupETikeut                         = 0xbca7,
        kPieupERieul                         = 0xbca8,
        kPieupERieulkiyeok                         = 0xbca9,
        kPieupERieulmieum                         = 0xbcaa,
        kPieupERieulpieup                         = 0xbcab,
        kPieupERieulsios                         = 0xbcac,
        kPieupERieulthieuth                         = 0xbcad,
        kPieupERieulphieuph                         = 0xbcae,
        kPieupERieulhieuh                         = 0xbcaf,
        kPieupEMieum                         = 0xbcb0,
        kPieupEPieup                         = 0xbcb1,
        kPieupEPieupsios                         = 0xbcb2,
        kPieupESios                         = 0xbcb3,
        kPieupESsangsios                         = 0xbcb4,
        kPieupEIeung                         = 0xbcb5,
        kPieupECieuc                         = 0xbcb6,
        kPieupEChieuch                         = 0xbcb7,
        kPieupEKhieukh                         = 0xbcb8,
        kPieupEThieuth                         = 0xbcb9,
        kPieupEPhieuph                         = 0xbcba,
        kPieupEHieuh                         = 0xbcbb,
        kPieupYeo                           = 0xbcbc,
        kPieupYeoKiyeok                         = 0xbcbd,
        kPieupYeoSsangkiyeok                         = 0xbcbe,
        kPieupYeoKiyeoksios                         = 0xbcbf,
        kPieupYeoNieun                         = 0xbcc0,
        kPieupYeoNieuncieuc                         = 0xbcc1,
        kPieupYeoNieunhieuh                         = 0xbcc2,
        kPieupYeoTikeut                         = 0xbcc3,
        kPieupYeoRieul                         = 0xbcc4,
        kPieupYeoRieulkiyeok                         = 0xbcc5,
        kPieupYeoRieulmieum                         = 0xbcc6,
        kPieupYeoRieulpieup                         = 0xbcc7,
        kPieupYeoRieulsios                         = 0xbcc8,
        kPieupYeoRieulthieuth                         = 0xbcc9,
        kPieupYeoRieulphieuph                         = 0xbcca,
        kPieupYeoRieulhieuh                         = 0xbccb,
        kPieupYeoMieum                         = 0xbccc,
        kPieupYeoPieup                         = 0xbccd,
        kPieupYeoPieupsios                         = 0xbcce,
        kPieupYeoSios                         = 0xbccf,
        kPieupYeoSsangsios                         = 0xbcd0,
        kPieupYeoIeung                         = 0xbcd1,
        kPieupYeoCieuc                         = 0xbcd2,
        kPieupYeoChieuch                         = 0xbcd3,
        kPieupYeoKhieukh                         = 0xbcd4,
        kPieupYeoThieuth                         = 0xbcd5,
        kPieupYeoPhieuph                         = 0xbcd6,
        kPieupYeoHieuh                         = 0xbcd7,
        kPieupYe                           = 0xbcd8,
        kPieupYeKiyeok                         = 0xbcd9,
        kPieupYeSsangkiyeok                         = 0xbcda,
        kPieupYeKiyeoksios                         = 0xbcdb,
        kPieupYeNieun                         = 0xbcdc,
        kPieupYeNieuncieuc                         = 0xbcdd,
        kPieupYeNieunhieuh                         = 0xbcde,
        kPieupYeTikeut                         = 0xbcdf,
        kPieupYeRieul                         = 0xbce0,
        kPieupYeRieulkiyeok                         = 0xbce1,
        kPieupYeRieulmieum                         = 0xbce2,
        kPieupYeRieulpieup                         = 0xbce3,
        kPieupYeRieulsios                         = 0xbce4,
        kPieupYeRieulthieuth                         = 0xbce5,
        kPieupYeRieulphieuph                         = 0xbce6,
        kPieupYeRieulhieuh                         = 0xbce7,
        kPieupYeMieum                         = 0xbce8,
        kPieupYePieup                         = 0xbce9,
        kPieupYePieupsios                         = 0xbcea,
        kPieupYeSios                         = 0xbceb,
        kPieupYeSsangsios                         = 0xbcec,
        kPieupYeIeung                         = 0xbced,
        kPieupYeCieuc                         = 0xbcee,
        kPieupYeChieuch                         = 0xbcef,
        kPieupYeKhieukh                         = 0xbcf0,
        kPieupYeThieuth                         = 0xbcf1,
        kPieupYePhieuph                         = 0xbcf2,
        kPieupYeHieuh                         = 0xbcf3,
        kPieupO                           = 0xbcf4,
        kPieupOKiyeok                         = 0xbcf5,
        kPieupOSsangkiyeok                         = 0xbcf6,
        kPieupOKiyeoksios                         = 0xbcf7,
        kPieupONieun                         = 0xbcf8,
        kPieupONieuncieuc                         = 0xbcf9,
        kPieupONieunhieuh                         = 0xbcfa,
        kPieupOTikeut                         = 0xbcfb,
        kPieupORieul                         = 0xbcfc,
        kPieupORieulkiyeok                         = 0xbcfd,
        kPieupORieulmieum                         = 0xbcfe,
        kPieupORieulpieup                         = 0xbcff,
        kPieupORieulsios                         = 0xbd00,
        kPieupORieulthieuth                         = 0xbd01,
        kPieupORieulphieuph                         = 0xbd02,
        kPieupORieulhieuh                         = 0xbd03,
        kPieupOMieum                         = 0xbd04,
        kPieupOPieup                         = 0xbd05,
        kPieupOPieupsios                         = 0xbd06,
        kPieupOSios                         = 0xbd07,
        kPieupOSsangsios                         = 0xbd08,
        kPieupOIeung                         = 0xbd09,
        kPieupOCieuc                         = 0xbd0a,
        kPieupOChieuch                         = 0xbd0b,
        kPieupOKhieukh                         = 0xbd0c,
        kPieupOThieuth                         = 0xbd0d,
        kPieupOPhieuph                         = 0xbd0e,
        kPieupOHieuh                         = 0xbd0f,
        kPieupWa                           = 0xbd10,
        kPieupWaKiyeok                         = 0xbd11,
        kPieupWaSsangkiyeok                         = 0xbd12,
        kPieupWaKiyeoksios                         = 0xbd13,
        kPieupWaNieun                         = 0xbd14,
        kPieupWaNieuncieuc                         = 0xbd15,
        kPieupWaNieunhieuh                         = 0xbd16,
        kPieupWaTikeut                         = 0xbd17,
        kPieupWaRieul                         = 0xbd18,
        kPieupWaRieulkiyeok                         = 0xbd19,
        kPieupWaRieulmieum                         = 0xbd1a,
        kPieupWaRieulpieup                         = 0xbd1b,
        kPieupWaRieulsios                         = 0xbd1c,
        kPieupWaRieulthieuth                         = 0xbd1d,
        kPieupWaRieulphieuph                         = 0xbd1e,
        kPieupWaRieulhieuh                         = 0xbd1f,
        kPieupWaMieum                         = 0xbd20,
        kPieupWaPieup                         = 0xbd21,
        kPieupWaPieupsios                         = 0xbd22,
        kPieupWaSios                         = 0xbd23,
        kPieupWaSsangsios                         = 0xbd24,
        kPieupWaIeung                         = 0xbd25,
        kPieupWaCieuc                         = 0xbd26,
        kPieupWaChieuch                         = 0xbd27,
        kPieupWaKhieukh                         = 0xbd28,
        kPieupWaThieuth                         = 0xbd29,
        kPieupWaPhieuph                         = 0xbd2a,
        kPieupWaHieuh                         = 0xbd2b,
        kPieupWae                           = 0xbd2c,
        kPieupWaeKiyeok                         = 0xbd2d,
        kPieupWaeSsangkiyeok                         = 0xbd2e,
        kPieupWaeKiyeoksios                         = 0xbd2f,
        kPieupWaeNieun                         = 0xbd30,
        kPieupWaeNieuncieuc                         = 0xbd31,
        kPieupWaeNieunhieuh                         = 0xbd32,
        kPieupWaeTikeut                         = 0xbd33,
        kPieupWaeRieul                         = 0xbd34,
        kPieupWaeRieulkiyeok                         = 0xbd35,
        kPieupWaeRieulmieum                         = 0xbd36,
        kPieupWaeRieulpieup                         = 0xbd37,
        kPieupWaeRieulsios                         = 0xbd38,
        kPieupWaeRieulthieuth                         = 0xbd39,
        kPieupWaeRieulphieuph                         = 0xbd3a,
        kPieupWaeRieulhieuh                         = 0xbd3b,
        kPieupWaeMieum                         = 0xbd3c,
        kPieupWaePieup                         = 0xbd3d,
        kPieupWaePieupsios                         = 0xbd3e,
        kPieupWaeSios                         = 0xbd3f,
        kPieupWaeSsangsios                         = 0xbd40,
        kPieupWaeIeung                         = 0xbd41,
        kPieupWaeCieuc                         = 0xbd42,
        kPieupWaeChieuch                         = 0xbd43,
        kPieupWaeKhieukh                         = 0xbd44,
        kPieupWaeThieuth                         = 0xbd45,
        kPieupWaePhieuph                         = 0xbd46,
        kPieupWaeHieuh                         = 0xbd47,
        kPieupOe                           = 0xbd48,
        kPieupOeKiyeok                         = 0xbd49,
        kPieupOeSsangkiyeok                         = 0xbd4a,
        kPieupOeKiyeoksios                         = 0xbd4b,
        kPieupOeNieun                         = 0xbd4c,
        kPieupOeNieuncieuc                         = 0xbd4d,
        kPieupOeNieunhieuh                         = 0xbd4e,
        kPieupOeTikeut                         = 0xbd4f,
        kPieupOeRieul                         = 0xbd50,
        kPieupOeRieulkiyeok                         = 0xbd51,
        kPieupOeRieulmieum                         = 0xbd52,
        kPieupOeRieulpieup                         = 0xbd53,
        kPieupOeRieulsios                         = 0xbd54,
        kPieupOeRieulthieuth                         = 0xbd55,
        kPieupOeRieulphieuph                         = 0xbd56,
        kPieupOeRieulhieuh                         = 0xbd57,
        kPieupOeMieum                         = 0xbd58,
        kPieupOePieup                         = 0xbd59,
        kPieupOePieupsios                         = 0xbd5a,
        kPieupOeSios                         = 0xbd5b,
        kPieupOeSsangsios                         = 0xbd5c,
        kPieupOeIeung                         = 0xbd5d,
        kPieupOeCieuc                         = 0xbd5e,
        kPieupOeChieuch                         = 0xbd5f,
        kPieupOeKhieukh                         = 0xbd60,
        kPieupOeThieuth                         = 0xbd61,
        kPieupOePhieuph                         = 0xbd62,
        kPieupOeHieuh                         = 0xbd63,
        kPieupYo                           = 0xbd64,
        kPieupYoKiyeok                         = 0xbd65,
        kPieupYoSsangkiyeok                         = 0xbd66,
        kPieupYoKiyeoksios                         = 0xbd67,
        kPieupYoNieun                         = 0xbd68,
        kPieupYoNieuncieuc                         = 0xbd69,
        kPieupYoNieunhieuh                         = 0xbd6a,
        kPieupYoTikeut                         = 0xbd6b,
        kPieupYoRieul                         = 0xbd6c,
        kPieupYoRieulkiyeok                         = 0xbd6d,
        kPieupYoRieulmieum                         = 0xbd6e,
        kPieupYoRieulpieup                         = 0xbd6f,
        kPieupYoRieulsios                         = 0xbd70,
        kPieupYoRieulthieuth                         = 0xbd71,
        kPieupYoRieulphieuph                         = 0xbd72,
        kPieupYoRieulhieuh                         = 0xbd73,
        kPieupYoMieum                         = 0xbd74,
        kPieupYoPieup                         = 0xbd75,
        kPieupYoPieupsios                         = 0xbd76,
        kPieupYoSios                         = 0xbd77,
        kPieupYoSsangsios                         = 0xbd78,
        kPieupYoIeung                         = 0xbd79,
        kPieupYoCieuc                         = 0xbd7a,
        kPieupYoChieuch                         = 0xbd7b,
        kPieupYoKhieukh                         = 0xbd7c,
        kPieupYoThieuth                         = 0xbd7d,
        kPieupYoPhieuph                         = 0xbd7e,
        kPieupYoHieuh                         = 0xbd7f,
        kPieupU                           = 0xbd80,
        kPieupUKiyeok                         = 0xbd81,
        kPieupUSsangkiyeok                         = 0xbd82,
        kPieupUKiyeoksios                         = 0xbd83,
        kPieupUNieun                         = 0xbd84,
        kPieupUNieuncieuc                         = 0xbd85,
        kPieupUNieunhieuh                         = 0xbd86,
        kPieupUTikeut                         = 0xbd87,
        kPieupURieul                         = 0xbd88,
        kPieupURieulkiyeok                         = 0xbd89,
        kPieupURieulmieum                         = 0xbd8a,
        kPieupURieulpieup                         = 0xbd8b,
        kPieupURieulsios                         = 0xbd8c,
        kPieupURieulthieuth                         = 0xbd8d,
        kPieupURieulphieuph                         = 0xbd8e,
        kPieupURieulhieuh                         = 0xbd8f,
        kPieupUMieum                         = 0xbd90,
        kPieupUPieup                         = 0xbd91,
        kPieupUPieupsios                         = 0xbd92,
        kPieupUSios                         = 0xbd93,
        kPieupUSsangsios                         = 0xbd94,
        kPieupUIeung                         = 0xbd95,
        kPieupUCieuc                         = 0xbd96,
        kPieupUChieuch                         = 0xbd97,
        kPieupUKhieukh                         = 0xbd98,
        kPieupUThieuth                         = 0xbd99,
        kPieupUPhieuph                         = 0xbd9a,
        kPieupUHieuh                         = 0xbd9b,
        kPieupWeo                           = 0xbd9c,
        kPieupWeoKiyeok                         = 0xbd9d,
        kPieupWeoSsangkiyeok                         = 0xbd9e,
        kPieupWeoKiyeoksios                         = 0xbd9f,
        kPieupWeoNieun                         = 0xbda0,
        kPieupWeoNieuncieuc                         = 0xbda1,
        kPieupWeoNieunhieuh                         = 0xbda2,
        kPieupWeoTikeut                         = 0xbda3,
        kPieupWeoRieul                         = 0xbda4,
        kPieupWeoRieulkiyeok                         = 0xbda5,
        kPieupWeoRieulmieum                         = 0xbda6,
        kPieupWeoRieulpieup                         = 0xbda7,
        kPieupWeoRieulsios                         = 0xbda8,
        kPieupWeoRieulthieuth                         = 0xbda9,
        kPieupWeoRieulphieuph                         = 0xbdaa,
        kPieupWeoRieulhieuh                         = 0xbdab,
        kPieupWeoMieum                         = 0xbdac,
        kPieupWeoPieup                         = 0xbdad,
        kPieupWeoPieupsios                         = 0xbdae,
        kPieupWeoSios                         = 0xbdaf,
        kPieupWeoSsangsios                         = 0xbdb0,
        kPieupWeoIeung                         = 0xbdb1,
        kPieupWeoCieuc                         = 0xbdb2,
        kPieupWeoChieuch                         = 0xbdb3,
        kPieupWeoKhieukh                         = 0xbdb4,
        kPieupWeoThieuth                         = 0xbdb5,
        kPieupWeoPhieuph                         = 0xbdb6,
        kPieupWeoHieuh                         = 0xbdb7,
        kPieupWe                           = 0xbdb8,
        kPieupWeKiyeok                         = 0xbdb9,
        kPieupWeSsangkiyeok                         = 0xbdba,
        kPieupWeKiyeoksios                         = 0xbdbb,
        kPieupWeNieun                         = 0xbdbc,
        kPieupWeNieuncieuc                         = 0xbdbd,
        kPieupWeNieunhieuh                         = 0xbdbe,
        kPieupWeTikeut                         = 0xbdbf,
        kPieupWeRieul                         = 0xbdc0,
        kPieupWeRieulkiyeok                         = 0xbdc1,
        kPieupWeRieulmieum                         = 0xbdc2,
        kPieupWeRieulpieup                         = 0xbdc3,
        kPieupWeRieulsios                         = 0xbdc4,
        kPieupWeRieulthieuth                         = 0xbdc5,
        kPieupWeRieulphieuph                         = 0xbdc6,
        kPieupWeRieulhieuh                         = 0xbdc7,
        kPieupWeMieum                         = 0xbdc8,
        kPieupWePieup                         = 0xbdc9,
        kPieupWePieupsios                         = 0xbdca,
        kPieupWeSios                         = 0xbdcb,
        kPieupWeSsangsios                         = 0xbdcc,
        kPieupWeIeung                         = 0xbdcd,
        kPieupWeCieuc                         = 0xbdce,
        kPieupWeChieuch                         = 0xbdcf,
        kPieupWeKhieukh                         = 0xbdd0,
        kPieupWeThieuth                         = 0xbdd1,
        kPieupWePhieuph                         = 0xbdd2,
        kPieupWeHieuh                         = 0xbdd3,
        kPieupWi                           = 0xbdd4,
        kPieupWiKiyeok                         = 0xbdd5,
        kPieupWiSsangkiyeok                         = 0xbdd6,
        kPieupWiKiyeoksios                         = 0xbdd7,
        kPieupWiNieun                         = 0xbdd8,
        kPieupWiNieuncieuc                         = 0xbdd9,
        kPieupWiNieunhieuh                         = 0xbdda,
        kPieupWiTikeut                         = 0xbddb,
        kPieupWiRieul                         = 0xbddc,
        kPieupWiRieulkiyeok                         = 0xbddd,
        kPieupWiRieulmieum                         = 0xbdde,
        kPieupWiRieulpieup                         = 0xbddf,
        kPieupWiRieulsios                         = 0xbde0,
        kPieupWiRieulthieuth                         = 0xbde1,
        kPieupWiRieulphieuph                         = 0xbde2,
        kPieupWiRieulhieuh                         = 0xbde3,
        kPieupWiMieum                         = 0xbde4,
        kPieupWiPieup                         = 0xbde5,
        kPieupWiPieupsios                         = 0xbde6,
        kPieupWiSios                         = 0xbde7,
        kPieupWiSsangsios                         = 0xbde8,
        kPieupWiIeung                         = 0xbde9,
        kPieupWiCieuc                         = 0xbdea,
        kPieupWiChieuch                         = 0xbdeb,
        kPieupWiKhieukh                         = 0xbdec,
        kPieupWiThieuth                         = 0xbded,
        kPieupWiPhieuph                         = 0xbdee,
        kPieupWiHieuh                         = 0xbdef,
        kPieupYu                           = 0xbdf0,
        kPieupYuKiyeok                         = 0xbdf1,
        kPieupYuSsangkiyeok                         = 0xbdf2,
        kPieupYuKiyeoksios                         = 0xbdf3,
        kPieupYuNieun                         = 0xbdf4,
        kPieupYuNieuncieuc                         = 0xbdf5,
        kPieupYuNieunhieuh                         = 0xbdf6,
        kPieupYuTikeut                         = 0xbdf7,
        kPieupYuRieul                         = 0xbdf8,
        kPieupYuRieulkiyeok                         = 0xbdf9,
        kPieupYuRieulmieum                         = 0xbdfa,
        kPieupYuRieulpieup                         = 0xbdfb,
        kPieupYuRieulsios                         = 0xbdfc,
        kPieupYuRieulthieuth                         = 0xbdfd,
        kPieupYuRieulphieuph                         = 0xbdfe,
        kPieupYuRieulhieuh                         = 0xbdff,
        kPieupYuMieum                         = 0xbe00,
        kPieupYuPieup                         = 0xbe01,
        kPieupYuPieupsios                         = 0xbe02,
        kPieupYuSios                         = 0xbe03,
        kPieupYuSsangsios                         = 0xbe04,
        kPieupYuIeung                         = 0xbe05,
        kPieupYuCieuc                         = 0xbe06,
        kPieupYuChieuch                         = 0xbe07,
        kPieupYuKhieukh                         = 0xbe08,
        kPieupYuThieuth                         = 0xbe09,
        kPieupYuPhieuph                         = 0xbe0a,
        kPieupYuHieuh                         = 0xbe0b,
        kPieupEu                           = 0xbe0c,
        kPieupEuKiyeok                         = 0xbe0d,
        kPieupEuSsangkiyeok                         = 0xbe0e,
        kPieupEuKiyeoksios                         = 0xbe0f,
        kPieupEuNieun                         = 0xbe10,
        kPieupEuNieuncieuc                         = 0xbe11,
        kPieupEuNieunhieuh                         = 0xbe12,
        kPieupEuTikeut                         = 0xbe13,
        kPieupEuRieul                         = 0xbe14,
        kPieupEuRieulkiyeok                         = 0xbe15,
        kPieupEuRieulmieum                         = 0xbe16,
        kPieupEuRieulpieup                         = 0xbe17,
        kPieupEuRieulsios                         = 0xbe18,
        kPieupEuRieulthieuth                         = 0xbe19,
        kPieupEuRieulphieuph                         = 0xbe1a,
        kPieupEuRieulhieuh                         = 0xbe1b,
        kPieupEuMieum                         = 0xbe1c,
        kPieupEuPieup                         = 0xbe1d,
        kPieupEuPieupsios                         = 0xbe1e,
        kPieupEuSios                         = 0xbe1f,
        kPieupEuSsangsios                         = 0xbe20,
        kPieupEuIeung                         = 0xbe21,
        kPieupEuCieuc                         = 0xbe22,
        kPieupEuChieuch                         = 0xbe23,
        kPieupEuKhieukh                         = 0xbe24,
        kPieupEuThieuth                         = 0xbe25,
        kPieupEuPhieuph                         = 0xbe26,
        kPieupEuHieuh                         = 0xbe27,
        kPieupYi                           = 0xbe28,
        kPieupYiKiyeok                         = 0xbe29,
        kPieupYiSsangkiyeok                         = 0xbe2a,
        kPieupYiKiyeoksios                         = 0xbe2b,
        kPieupYiNieun                         = 0xbe2c,
        kPieupYiNieuncieuc                         = 0xbe2d,
        kPieupYiNieunhieuh                         = 0xbe2e,
        kPieupYiTikeut                         = 0xbe2f,
        kPieupYiRieul                         = 0xbe30,
        kPieupYiRieulkiyeok                         = 0xbe31,
        kPieupYiRieulmieum                         = 0xbe32,
        kPieupYiRieulpieup                         = 0xbe33,
        kPieupYiRieulsios                         = 0xbe34,
        kPieupYiRieulthieuth                         = 0xbe35,
        kPieupYiRieulphieuph                         = 0xbe36,
        kPieupYiRieulhieuh                         = 0xbe37,
        kPieupYiMieum                         = 0xbe38,
        kPieupYiPieup                         = 0xbe39,
        kPieupYiPieupsios                         = 0xbe3a,
        kPieupYiSios                         = 0xbe3b,
        kPieupYiSsangsios                         = 0xbe3c,
        kPieupYiIeung                         = 0xbe3d,
        kPieupYiCieuc                         = 0xbe3e,
        kPieupYiChieuch                         = 0xbe3f,
        kPieupYiKhieukh                         = 0xbe40,
        kPieupYiThieuth                         = 0xbe41,
        kPieupYiPhieuph                         = 0xbe42,
        kPieupYiHieuh                         = 0xbe43,
        kPieupI                           = 0xbe44,
        kPieupIKiyeok                         = 0xbe45,
        kPieupISsangkiyeok                         = 0xbe46,
        kPieupIKiyeoksios                         = 0xbe47,
        kPieupINieun                         = 0xbe48,
        kPieupINieuncieuc                         = 0xbe49,
        kPieupINieunhieuh                         = 0xbe4a,
        kPieupITikeut                         = 0xbe4b,
        kPieupIRieul                         = 0xbe4c,
        kPieupIRieulkiyeok                         = 0xbe4d,
        kPieupIRieulmieum                         = 0xbe4e,
        kPieupIRieulpieup                         = 0xbe4f,
        kPieupIRieulsios                         = 0xbe50,
        kPieupIRieulthieuth                         = 0xbe51,
        kPieupIRieulphieuph                         = 0xbe52,
        kPieupIRieulhieuh                         = 0xbe53,
        kPieupIMieum                         = 0xbe54,
        kPieupIPieup                         = 0xbe55,
        kPieupIPieupsios                         = 0xbe56,
        kPieupISios                         = 0xbe57,
        kPieupISsangsios                         = 0xbe58,
        kPieupIIeung                         = 0xbe59,
        kPieupICieuc                         = 0xbe5a,
        kPieupIChieuch                         = 0xbe5b,
        kPieupIKhieukh                         = 0xbe5c,
        kPieupIThieuth                         = 0xbe5d,
        kPieupIPhieuph                         = 0xbe5e,
        kPieupIHieuh                         = 0xbe5f,
        kSsangpieupA                           = 0xbe60,
        kSsangpieupAKiyeok                         = 0xbe61,
        kSsangpieupASsangkiyeok                         = 0xbe62,
        kSsangpieupAKiyeoksios                         = 0xbe63,
        kSsangpieupANieun                         = 0xbe64,
        kSsangpieupANieuncieuc                         = 0xbe65,
        kSsangpieupANieunhieuh                         = 0xbe66,
        kSsangpieupATikeut                         = 0xbe67,
        kSsangpieupARieul                         = 0xbe68,
        kSsangpieupARieulkiyeok                         = 0xbe69,
        kSsangpieupARieulmieum                         = 0xbe6a,
        kSsangpieupARieulpieup                         = 0xbe6b,
        kSsangpieupARieulsios                         = 0xbe6c,
        kSsangpieupARieulthieuth                         = 0xbe6d,
        kSsangpieupARieulphieuph                         = 0xbe6e,
        kSsangpieupARieulhieuh                         = 0xbe6f,
        kSsangpieupAMieum                         = 0xbe70,
        kSsangpieupAPieup                         = 0xbe71,
        kSsangpieupAPieupsios                         = 0xbe72,
        kSsangpieupASios                         = 0xbe73,
        kSsangpieupASsangsios                         = 0xbe74,
        kSsangpieupAIeung                         = 0xbe75,
        kSsangpieupACieuc                         = 0xbe76,
        kSsangpieupAChieuch                         = 0xbe77,
        kSsangpieupAKhieukh                         = 0xbe78,
        kSsangpieupAThieuth                         = 0xbe79,
        kSsangpieupAPhieuph                         = 0xbe7a,
        kSsangpieupAHieuh                         = 0xbe7b,
        kSsangpieupAe                           = 0xbe7c,
        kSsangpieupAeKiyeok                         = 0xbe7d,
        kSsangpieupAeSsangkiyeok                         = 0xbe7e,
        kSsangpieupAeKiyeoksios                         = 0xbe7f,
        kSsangpieupAeNieun                         = 0xbe80,
        kSsangpieupAeNieuncieuc                         = 0xbe81,
        kSsangpieupAeNieunhieuh                         = 0xbe82,
        kSsangpieupAeTikeut                         = 0xbe83,
        kSsangpieupAeRieul                         = 0xbe84,
        kSsangpieupAeRieulkiyeok                         = 0xbe85,
        kSsangpieupAeRieulmieum                         = 0xbe86,
        kSsangpieupAeRieulpieup                         = 0xbe87,
        kSsangpieupAeRieulsios                         = 0xbe88,
        kSsangpieupAeRieulthieuth                         = 0xbe89,
        kSsangpieupAeRieulphieuph                         = 0xbe8a,
        kSsangpieupAeRieulhieuh                         = 0xbe8b,
        kSsangpieupAeMieum                         = 0xbe8c,
        kSsangpieupAePieup                         = 0xbe8d,
        kSsangpieupAePieupsios                         = 0xbe8e,
        kSsangpieupAeSios                         = 0xbe8f,
        kSsangpieupAeSsangsios                         = 0xbe90,
        kSsangpieupAeIeung                         = 0xbe91,
        kSsangpieupAeCieuc                         = 0xbe92,
        kSsangpieupAeChieuch                         = 0xbe93,
        kSsangpieupAeKhieukh                         = 0xbe94,
        kSsangpieupAeThieuth                         = 0xbe95,
        kSsangpieupAePhieuph                         = 0xbe96,
        kSsangpieupAeHieuh                         = 0xbe97,
        kSsangpieupYa                           = 0xbe98,
        kSsangpieupYaKiyeok                         = 0xbe99,
        kSsangpieupYaSsangkiyeok                         = 0xbe9a,
        kSsangpieupYaKiyeoksios                         = 0xbe9b,
        kSsangpieupYaNieun                         = 0xbe9c,
        kSsangpieupYaNieuncieuc                         = 0xbe9d,
        kSsangpieupYaNieunhieuh                         = 0xbe9e,
        kSsangpieupYaTikeut                         = 0xbe9f,
        kSsangpieupYaRieul                         = 0xbea0,
        kSsangpieupYaRieulkiyeok                         = 0xbea1,
        kSsangpieupYaRieulmieum                         = 0xbea2,
        kSsangpieupYaRieulpieup                         = 0xbea3,
        kSsangpieupYaRieulsios                         = 0xbea4,
        kSsangpieupYaRieulthieuth                         = 0xbea5,
        kSsangpieupYaRieulphieuph                         = 0xbea6,
        kSsangpieupYaRieulhieuh                         = 0xbea7,
        kSsangpieupYaMieum                         = 0xbea8,
        kSsangpieupYaPieup                         = 0xbea9,
        kSsangpieupYaPieupsios                         = 0xbeaa,
        kSsangpieupYaSios                         = 0xbeab,
        kSsangpieupYaSsangsios                         = 0xbeac,
        kSsangpieupYaIeung                         = 0xbead,
        kSsangpieupYaCieuc                         = 0xbeae,
        kSsangpieupYaChieuch                         = 0xbeaf,
        kSsangpieupYaKhieukh                         = 0xbeb0,
        kSsangpieupYaThieuth                         = 0xbeb1,
        kSsangpieupYaPhieuph                         = 0xbeb2,
        kSsangpieupYaHieuh                         = 0xbeb3,
        kSsangpieupYae                           = 0xbeb4,
        kSsangpieupYaeKiyeok                         = 0xbeb5,
        kSsangpieupYaeSsangkiyeok                         = 0xbeb6,
        kSsangpieupYaeKiyeoksios                         = 0xbeb7,
        kSsangpieupYaeNieun                         = 0xbeb8,
        kSsangpieupYaeNieuncieuc                         = 0xbeb9,
        kSsangpieupYaeNieunhieuh                         = 0xbeba,
        kSsangpieupYaeTikeut                         = 0xbebb,
        kSsangpieupYaeRieul                         = 0xbebc,
        kSsangpieupYaeRieulkiyeok                         = 0xbebd,
        kSsangpieupYaeRieulmieum                         = 0xbebe,
        kSsangpieupYaeRieulpieup                         = 0xbebf,
        kSsangpieupYaeRieulsios                         = 0xbec0,
        kSsangpieupYaeRieulthieuth                         = 0xbec1,
        kSsangpieupYaeRieulphieuph                         = 0xbec2,
        kSsangpieupYaeRieulhieuh                         = 0xbec3,
        kSsangpieupYaeMieum                         = 0xbec4,
        kSsangpieupYaePieup                         = 0xbec5,
        kSsangpieupYaePieupsios                         = 0xbec6,
        kSsangpieupYaeSios                         = 0xbec7,
        kSsangpieupYaeSsangsios                         = 0xbec8,
        kSsangpieupYaeIeung                         = 0xbec9,
        kSsangpieupYaeCieuc                         = 0xbeca,
        kSsangpieupYaeChieuch                         = 0xbecb,
        kSsangpieupYaeKhieukh                         = 0xbecc,
        kSsangpieupYaeThieuth                         = 0xbecd,
        kSsangpieupYaePhieuph                         = 0xbece,
        kSsangpieupYaeHieuh                         = 0xbecf,
        kSsangpieupEo                           = 0xbed0,
        kSsangpieupEoKiyeok                         = 0xbed1,
        kSsangpieupEoSsangkiyeok                         = 0xbed2,
        kSsangpieupEoKiyeoksios                         = 0xbed3,
        kSsangpieupEoNieun                         = 0xbed4,
        kSsangpieupEoNieuncieuc                         = 0xbed5,
        kSsangpieupEoNieunhieuh                         = 0xbed6,
        kSsangpieupEoTikeut                         = 0xbed7,
        kSsangpieupEoRieul                         = 0xbed8,
        kSsangpieupEoRieulkiyeok                         = 0xbed9,
        kSsangpieupEoRieulmieum                         = 0xbeda,
        kSsangpieupEoRieulpieup                         = 0xbedb,
        kSsangpieupEoRieulsios                         = 0xbedc,
        kSsangpieupEoRieulthieuth                         = 0xbedd,
        kSsangpieupEoRieulphieuph                         = 0xbede,
        kSsangpieupEoRieulhieuh                         = 0xbedf,
        kSsangpieupEoMieum                         = 0xbee0,
        kSsangpieupEoPieup                         = 0xbee1,
        kSsangpieupEoPieupsios                         = 0xbee2,
        kSsangpieupEoSios                         = 0xbee3,
        kSsangpieupEoSsangsios                         = 0xbee4,
        kSsangpieupEoIeung                         = 0xbee5,
        kSsangpieupEoCieuc                         = 0xbee6,
        kSsangpieupEoChieuch                         = 0xbee7,
        kSsangpieupEoKhieukh                         = 0xbee8,
        kSsangpieupEoThieuth                         = 0xbee9,
        kSsangpieupEoPhieuph                         = 0xbeea,
        kSsangpieupEoHieuh                         = 0xbeeb,
        kSsangpieupE                           = 0xbeec,
        kSsangpieupEKiyeok                         = 0xbeed,
        kSsangpieupESsangkiyeok                         = 0xbeee,
        kSsangpieupEKiyeoksios                         = 0xbeef,
        kSsangpieupENieun                         = 0xbef0,
        kSsangpieupENieuncieuc                         = 0xbef1,
        kSsangpieupENieunhieuh                         = 0xbef2,
        kSsangpieupETikeut                         = 0xbef3,
        kSsangpieupERieul                         = 0xbef4,
        kSsangpieupERieulkiyeok                         = 0xbef5,
        kSsangpieupERieulmieum                         = 0xbef6,
        kSsangpieupERieulpieup                         = 0xbef7,
        kSsangpieupERieulsios                         = 0xbef8,
        kSsangpieupERieulthieuth                         = 0xbef9,
        kSsangpieupERieulphieuph                         = 0xbefa,
        kSsangpieupERieulhieuh                         = 0xbefb,
        kSsangpieupEMieum                         = 0xbefc,
        kSsangpieupEPieup                         = 0xbefd,
        kSsangpieupEPieupsios                         = 0xbefe,
        kSsangpieupESios                         = 0xbeff,
        kSsangpieupESsangsios                         = 0xbf00,
        kSsangpieupEIeung                         = 0xbf01,
        kSsangpieupECieuc                         = 0xbf02,
        kSsangpieupEChieuch                         = 0xbf03,
        kSsangpieupEKhieukh                         = 0xbf04,
        kSsangpieupEThieuth                         = 0xbf05,
        kSsangpieupEPhieuph                         = 0xbf06,
        kSsangpieupEHieuh                         = 0xbf07,
        kSsangpieupYeo                           = 0xbf08,
        kSsangpieupYeoKiyeok                         = 0xbf09,
        kSsangpieupYeoSsangkiyeok                         = 0xbf0a,
        kSsangpieupYeoKiyeoksios                         = 0xbf0b,
        kSsangpieupYeoNieun                         = 0xbf0c,
        kSsangpieupYeoNieuncieuc                         = 0xbf0d,
        kSsangpieupYeoNieunhieuh                         = 0xbf0e,
        kSsangpieupYeoTikeut                         = 0xbf0f,
        kSsangpieupYeoRieul                         = 0xbf10,
        kSsangpieupYeoRieulkiyeok                         = 0xbf11,
        kSsangpieupYeoRieulmieum                         = 0xbf12,
        kSsangpieupYeoRieulpieup                         = 0xbf13,
        kSsangpieupYeoRieulsios                         = 0xbf14,
        kSsangpieupYeoRieulthieuth                         = 0xbf15,
        kSsangpieupYeoRieulphieuph                         = 0xbf16,
        kSsangpieupYeoRieulhieuh                         = 0xbf17,
        kSsangpieupYeoMieum                         = 0xbf18,
        kSsangpieupYeoPieup                         = 0xbf19,
        kSsangpieupYeoPieupsios                         = 0xbf1a,
        kSsangpieupYeoSios                         = 0xbf1b,
        kSsangpieupYeoSsangsios                         = 0xbf1c,
        kSsangpieupYeoIeung                         = 0xbf1d,
        kSsangpieupYeoCieuc                         = 0xbf1e,
        kSsangpieupYeoChieuch                         = 0xbf1f,
        kSsangpieupYeoKhieukh                         = 0xbf20,
        kSsangpieupYeoThieuth                         = 0xbf21,
        kSsangpieupYeoPhieuph                         = 0xbf22,
        kSsangpieupYeoHieuh                         = 0xbf23,
        kSsangpieupYe                           = 0xbf24,
        kSsangpieupYeKiyeok                         = 0xbf25,
        kSsangpieupYeSsangkiyeok                         = 0xbf26,
        kSsangpieupYeKiyeoksios                         = 0xbf27,
        kSsangpieupYeNieun                         = 0xbf28,
        kSsangpieupYeNieuncieuc                         = 0xbf29,
        kSsangpieupYeNieunhieuh                         = 0xbf2a,
        kSsangpieupYeTikeut                         = 0xbf2b,
        kSsangpieupYeRieul                         = 0xbf2c,
        kSsangpieupYeRieulkiyeok                         = 0xbf2d,
        kSsangpieupYeRieulmieum                         = 0xbf2e,
        kSsangpieupYeRieulpieup                         = 0xbf2f,
        kSsangpieupYeRieulsios                         = 0xbf30,
        kSsangpieupYeRieulthieuth                         = 0xbf31,
        kSsangpieupYeRieulphieuph                         = 0xbf32,
        kSsangpieupYeRieulhieuh                         = 0xbf33,
        kSsangpieupYeMieum                         = 0xbf34,
        kSsangpieupYePieup                         = 0xbf35,
        kSsangpieupYePieupsios                         = 0xbf36,
        kSsangpieupYeSios                         = 0xbf37,
        kSsangpieupYeSsangsios                         = 0xbf38,
        kSsangpieupYeIeung                         = 0xbf39,
        kSsangpieupYeCieuc                         = 0xbf3a,
        kSsangpieupYeChieuch                         = 0xbf3b,
        kSsangpieupYeKhieukh                         = 0xbf3c,
        kSsangpieupYeThieuth                         = 0xbf3d,
        kSsangpieupYePhieuph                         = 0xbf3e,
        kSsangpieupYeHieuh                         = 0xbf3f,
        kSsangpieupO                           = 0xbf40,
        kSsangpieupOKiyeok                         = 0xbf41,
        kSsangpieupOSsangkiyeok                         = 0xbf42,
        kSsangpieupOKiyeoksios                         = 0xbf43,
        kSsangpieupONieun                         = 0xbf44,
        kSsangpieupONieuncieuc                         = 0xbf45,
        kSsangpieupONieunhieuh                         = 0xbf46,
        kSsangpieupOTikeut                         = 0xbf47,
        kSsangpieupORieul                         = 0xbf48,
        kSsangpieupORieulkiyeok                         = 0xbf49,
        kSsangpieupORieulmieum                         = 0xbf4a,
        kSsangpieupORieulpieup                         = 0xbf4b,
        kSsangpieupORieulsios                         = 0xbf4c,
        kSsangpieupORieulthieuth                         = 0xbf4d,
        kSsangpieupORieulphieuph                         = 0xbf4e,
        kSsangpieupORieulhieuh                         = 0xbf4f,
        kSsangpieupOMieum                         = 0xbf50,
        kSsangpieupOPieup                         = 0xbf51,
        kSsangpieupOPieupsios                         = 0xbf52,
        kSsangpieupOSios                         = 0xbf53,
        kSsangpieupOSsangsios                         = 0xbf54,
        kSsangpieupOIeung                         = 0xbf55,
        kSsangpieupOCieuc                         = 0xbf56,
        kSsangpieupOChieuch                         = 0xbf57,
        kSsangpieupOKhieukh                         = 0xbf58,
        kSsangpieupOThieuth                         = 0xbf59,
        kSsangpieupOPhieuph                         = 0xbf5a,
        kSsangpieupOHieuh                         = 0xbf5b,
        kSsangpieupWa                           = 0xbf5c,
        kSsangpieupWaKiyeok                         = 0xbf5d,
        kSsangpieupWaSsangkiyeok                         = 0xbf5e,
        kSsangpieupWaKiyeoksios                         = 0xbf5f,
        kSsangpieupWaNieun                         = 0xbf60,
        kSsangpieupWaNieuncieuc                         = 0xbf61,
        kSsangpieupWaNieunhieuh                         = 0xbf62,
        kSsangpieupWaTikeut                         = 0xbf63,
        kSsangpieupWaRieul                         = 0xbf64,
        kSsangpieupWaRieulkiyeok                         = 0xbf65,
        kSsangpieupWaRieulmieum                         = 0xbf66,
        kSsangpieupWaRieulpieup                         = 0xbf67,
        kSsangpieupWaRieulsios                         = 0xbf68,
        kSsangpieupWaRieulthieuth                         = 0xbf69,
        kSsangpieupWaRieulphieuph                         = 0xbf6a,
        kSsangpieupWaRieulhieuh                         = 0xbf6b,
        kSsangpieupWaMieum                         = 0xbf6c,
        kSsangpieupWaPieup                         = 0xbf6d,
        kSsangpieupWaPieupsios                         = 0xbf6e,
        kSsangpieupWaSios                         = 0xbf6f,
        kSsangpieupWaSsangsios                         = 0xbf70,
        kSsangpieupWaIeung                         = 0xbf71,
        kSsangpieupWaCieuc                         = 0xbf72,
        kSsangpieupWaChieuch                         = 0xbf73,
        kSsangpieupWaKhieukh                         = 0xbf74,
        kSsangpieupWaThieuth                         = 0xbf75,
        kSsangpieupWaPhieuph                         = 0xbf76,
        kSsangpieupWaHieuh                         = 0xbf77,
        kSsangpieupWae                           = 0xbf78,
        kSsangpieupWaeKiyeok                         = 0xbf79,
        kSsangpieupWaeSsangkiyeok                         = 0xbf7a,
        kSsangpieupWaeKiyeoksios                         = 0xbf7b,
        kSsangpieupWaeNieun                         = 0xbf7c,
        kSsangpieupWaeNieuncieuc                         = 0xbf7d,
        kSsangpieupWaeNieunhieuh                         = 0xbf7e,
        kSsangpieupWaeTikeut                         = 0xbf7f,
        kSsangpieupWaeRieul                         = 0xbf80,
        kSsangpieupWaeRieulkiyeok                         = 0xbf81,
        kSsangpieupWaeRieulmieum                         = 0xbf82,
        kSsangpieupWaeRieulpieup                         = 0xbf83,
        kSsangpieupWaeRieulsios                         = 0xbf84,
        kSsangpieupWaeRieulthieuth                         = 0xbf85,
        kSsangpieupWaeRieulphieuph                         = 0xbf86,
        kSsangpieupWaeRieulhieuh                         = 0xbf87,
        kSsangpieupWaeMieum                         = 0xbf88,
        kSsangpieupWaePieup                         = 0xbf89,
        kSsangpieupWaePieupsios                         = 0xbf8a,
        kSsangpieupWaeSios                         = 0xbf8b,
        kSsangpieupWaeSsangsios                         = 0xbf8c,
        kSsangpieupWaeIeung                         = 0xbf8d,
        kSsangpieupWaeCieuc                         = 0xbf8e,
        kSsangpieupWaeChieuch                         = 0xbf8f,
        kSsangpieupWaeKhieukh                         = 0xbf90,
        kSsangpieupWaeThieuth                         = 0xbf91,
        kSsangpieupWaePhieuph                         = 0xbf92,
        kSsangpieupWaeHieuh                         = 0xbf93,
        kSsangpieupOe                           = 0xbf94,
        kSsangpieupOeKiyeok                         = 0xbf95,
        kSsangpieupOeSsangkiyeok                         = 0xbf96,
        kSsangpieupOeKiyeoksios                         = 0xbf97,
        kSsangpieupOeNieun                         = 0xbf98,
        kSsangpieupOeNieuncieuc                         = 0xbf99,
        kSsangpieupOeNieunhieuh                         = 0xbf9a,
        kSsangpieupOeTikeut                         = 0xbf9b,
        kSsangpieupOeRieul                         = 0xbf9c,
        kSsangpieupOeRieulkiyeok                         = 0xbf9d,
        kSsangpieupOeRieulmieum                         = 0xbf9e,
        kSsangpieupOeRieulpieup                         = 0xbf9f,
        kSsangpieupOeRieulsios                         = 0xbfa0,
        kSsangpieupOeRieulthieuth                         = 0xbfa1,
        kSsangpieupOeRieulphieuph                         = 0xbfa2,
        kSsangpieupOeRieulhieuh                         = 0xbfa3,
        kSsangpieupOeMieum                         = 0xbfa4,
        kSsangpieupOePieup                         = 0xbfa5,
        kSsangpieupOePieupsios                         = 0xbfa6,
        kSsangpieupOeSios                         = 0xbfa7,
        kSsangpieupOeSsangsios                         = 0xbfa8,
        kSsangpieupOeIeung                         = 0xbfa9,
        kSsangpieupOeCieuc                         = 0xbfaa,
        kSsangpieupOeChieuch                         = 0xbfab,
        kSsangpieupOeKhieukh                         = 0xbfac,
        kSsangpieupOeThieuth                         = 0xbfad,
        kSsangpieupOePhieuph                         = 0xbfae,
        kSsangpieupOeHieuh                         = 0xbfaf,
        kSsangpieupYo                           = 0xbfb0,
        kSsangpieupYoKiyeok                         = 0xbfb1,
        kSsangpieupYoSsangkiyeok                         = 0xbfb2,
        kSsangpieupYoKiyeoksios                         = 0xbfb3,
        kSsangpieupYoNieun                         = 0xbfb4,
        kSsangpieupYoNieuncieuc                         = 0xbfb5,
        kSsangpieupYoNieunhieuh                         = 0xbfb6,
        kSsangpieupYoTikeut                         = 0xbfb7,
        kSsangpieupYoRieul                         = 0xbfb8,
        kSsangpieupYoRieulkiyeok                         = 0xbfb9,
        kSsangpieupYoRieulmieum                         = 0xbfba,
        kSsangpieupYoRieulpieup                         = 0xbfbb,
        kSsangpieupYoRieulsios                         = 0xbfbc,
        kSsangpieupYoRieulthieuth                         = 0xbfbd,
        kSsangpieupYoRieulphieuph                         = 0xbfbe,
        kSsangpieupYoRieulhieuh                         = 0xbfbf,
        kSsangpieupYoMieum                         = 0xbfc0,
        kSsangpieupYoPieup                         = 0xbfc1,
        kSsangpieupYoPieupsios                         = 0xbfc2,
        kSsangpieupYoSios                         = 0xbfc3,
        kSsangpieupYoSsangsios                         = 0xbfc4,
        kSsangpieupYoIeung                         = 0xbfc5,
        kSsangpieupYoCieuc                         = 0xbfc6,
        kSsangpieupYoChieuch                         = 0xbfc7,
        kSsangpieupYoKhieukh                         = 0xbfc8,
        kSsangpieupYoThieuth                         = 0xbfc9,
        kSsangpieupYoPhieuph                         = 0xbfca,
        kSsangpieupYoHieuh                         = 0xbfcb,
        kSsangpieupU                           = 0xbfcc,
        kSsangpieupUKiyeok                         = 0xbfcd,
        kSsangpieupUSsangkiyeok                         = 0xbfce,
        kSsangpieupUKiyeoksios                         = 0xbfcf,
        kSsangpieupUNieun                         = 0xbfd0,
        kSsangpieupUNieuncieuc                         = 0xbfd1,
        kSsangpieupUNieunhieuh                         = 0xbfd2,
        kSsangpieupUTikeut                         = 0xbfd3,
        kSsangpieupURieul                         = 0xbfd4,
        kSsangpieupURieulkiyeok                         = 0xbfd5,
        kSsangpieupURieulmieum                         = 0xbfd6,
        kSsangpieupURieulpieup                         = 0xbfd7,
        kSsangpieupURieulsios                         = 0xbfd8,
        kSsangpieupURieulthieuth                         = 0xbfd9,
        kSsangpieupURieulphieuph                         = 0xbfda,
        kSsangpieupURieulhieuh                         = 0xbfdb,
        kSsangpieupUMieum                         = 0xbfdc,
        kSsangpieupUPieup                         = 0xbfdd,
        kSsangpieupUPieupsios                         = 0xbfde,
        kSsangpieupUSios                         = 0xbfdf,
        kSsangpieupUSsangsios                         = 0xbfe0,
        kSsangpieupUIeung                         = 0xbfe1,
        kSsangpieupUCieuc                         = 0xbfe2,
        kSsangpieupUChieuch                         = 0xbfe3,
        kSsangpieupUKhieukh                         = 0xbfe4,
        kSsangpieupUThieuth                         = 0xbfe5,
        kSsangpieupUPhieuph                         = 0xbfe6,
        kSsangpieupUHieuh                         = 0xbfe7,
        kSsangpieupWeo                           = 0xbfe8,
        kSsangpieupWeoKiyeok                         = 0xbfe9,
        kSsangpieupWeoSsangkiyeok                         = 0xbfea,
        kSsangpieupWeoKiyeoksios                         = 0xbfeb,
        kSsangpieupWeoNieun                         = 0xbfec,
        kSsangpieupWeoNieuncieuc                         = 0xbfed,
        kSsangpieupWeoNieunhieuh                         = 0xbfee,
        kSsangpieupWeoTikeut                         = 0xbfef,
        kSsangpieupWeoRieul                         = 0xbff0,
        kSsangpieupWeoRieulkiyeok                         = 0xbff1,
        kSsangpieupWeoRieulmieum                         = 0xbff2,
        kSsangpieupWeoRieulpieup                         = 0xbff3,
        kSsangpieupWeoRieulsios                         = 0xbff4,
        kSsangpieupWeoRieulthieuth                         = 0xbff5,
        kSsangpieupWeoRieulphieuph                         = 0xbff6,
        kSsangpieupWeoRieulhieuh                         = 0xbff7,
        kSsangpieupWeoMieum                         = 0xbff8,
        kSsangpieupWeoPieup                         = 0xbff9,
        kSsangpieupWeoPieupsios                         = 0xbffa,
        kSsangpieupWeoSios                         = 0xbffb,
        kSsangpieupWeoSsangsios                         = 0xbffc,
        kSsangpieupWeoIeung                         = 0xbffd,
        kSsangpieupWeoCieuc                         = 0xbffe,
        kSsangpieupWeoChieuch                         = 0xbfff,
        kSsangpieupWeoKhieukh                         = 0xc000,
        kSsangpieupWeoThieuth                         = 0xc001,
        kSsangpieupWeoPhieuph                         = 0xc002,
        kSsangpieupWeoHieuh                         = 0xc003,
        kSsangpieupWe                           = 0xc004,
        kSsangpieupWeKiyeok                         = 0xc005,
        kSsangpieupWeSsangkiyeok                         = 0xc006,
        kSsangpieupWeKiyeoksios                         = 0xc007,
        kSsangpieupWeNieun                         = 0xc008,
        kSsangpieupWeNieuncieuc                         = 0xc009,
        kSsangpieupWeNieunhieuh                         = 0xc00a,
        kSsangpieupWeTikeut                         = 0xc00b,
        kSsangpieupWeRieul                         = 0xc00c,
        kSsangpieupWeRieulkiyeok                         = 0xc00d,
        kSsangpieupWeRieulmieum                         = 0xc00e,
        kSsangpieupWeRieulpieup                         = 0xc00f,
        kSsangpieupWeRieulsios                         = 0xc010,
        kSsangpieupWeRieulthieuth                         = 0xc011,
        kSsangpieupWeRieulphieuph                         = 0xc012,
        kSsangpieupWeRieulhieuh                         = 0xc013,
        kSsangpieupWeMieum                         = 0xc014,
        kSsangpieupWePieup                         = 0xc015,
        kSsangpieupWePieupsios                         = 0xc016,
        kSsangpieupWeSios                         = 0xc017,
        kSsangpieupWeSsangsios                         = 0xc018,
        kSsangpieupWeIeung                         = 0xc019,
        kSsangpieupWeCieuc                         = 0xc01a,
        kSsangpieupWeChieuch                         = 0xc01b,
        kSsangpieupWeKhieukh                         = 0xc01c,
        kSsangpieupWeThieuth                         = 0xc01d,
        kSsangpieupWePhieuph                         = 0xc01e,
        kSsangpieupWeHieuh                         = 0xc01f,
        kSsangpieupWi                           = 0xc020,
        kSsangpieupWiKiyeok                         = 0xc021,
        kSsangpieupWiSsangkiyeok                         = 0xc022,
        kSsangpieupWiKiyeoksios                         = 0xc023,
        kSsangpieupWiNieun                         = 0xc024,
        kSsangpieupWiNieuncieuc                         = 0xc025,
        kSsangpieupWiNieunhieuh                         = 0xc026,
        kSsangpieupWiTikeut                         = 0xc027,
        kSsangpieupWiRieul                         = 0xc028,
        kSsangpieupWiRieulkiyeok                         = 0xc029,
        kSsangpieupWiRieulmieum                         = 0xc02a,
        kSsangpieupWiRieulpieup                         = 0xc02b,
        kSsangpieupWiRieulsios                         = 0xc02c,
        kSsangpieupWiRieulthieuth                         = 0xc02d,
        kSsangpieupWiRieulphieuph                         = 0xc02e,
        kSsangpieupWiRieulhieuh                         = 0xc02f,
        kSsangpieupWiMieum                         = 0xc030,
        kSsangpieupWiPieup                         = 0xc031,
        kSsangpieupWiPieupsios                         = 0xc032,
        kSsangpieupWiSios                         = 0xc033,
        kSsangpieupWiSsangsios                         = 0xc034,
        kSsangpieupWiIeung                         = 0xc035,
        kSsangpieupWiCieuc                         = 0xc036,
        kSsangpieupWiChieuch                         = 0xc037,
        kSsangpieupWiKhieukh                         = 0xc038,
        kSsangpieupWiThieuth                         = 0xc039,
        kSsangpieupWiPhieuph                         = 0xc03a,
        kSsangpieupWiHieuh                         = 0xc03b,
        kSsangpieupYu                           = 0xc03c,
        kSsangpieupYuKiyeok                         = 0xc03d,
        kSsangpieupYuSsangkiyeok                         = 0xc03e,
        kSsangpieupYuKiyeoksios                         = 0xc03f,
        kSsangpieupYuNieun                         = 0xc040,
        kSsangpieupYuNieuncieuc                         = 0xc041,
        kSsangpieupYuNieunhieuh                         = 0xc042,
        kSsangpieupYuTikeut                         = 0xc043,
        kSsangpieupYuRieul                         = 0xc044,
        kSsangpieupYuRieulkiyeok                         = 0xc045,
        kSsangpieupYuRieulmieum                         = 0xc046,
        kSsangpieupYuRieulpieup                         = 0xc047,
        kSsangpieupYuRieulsios                         = 0xc048,
        kSsangpieupYuRieulthieuth                         = 0xc049,
        kSsangpieupYuRieulphieuph                         = 0xc04a,
        kSsangpieupYuRieulhieuh                         = 0xc04b,
        kSsangpieupYuMieum                         = 0xc04c,
        kSsangpieupYuPieup                         = 0xc04d,
        kSsangpieupYuPieupsios                         = 0xc04e,
        kSsangpieupYuSios                         = 0xc04f,
        kSsangpieupYuSsangsios                         = 0xc050,
        kSsangpieupYuIeung                         = 0xc051,
        kSsangpieupYuCieuc                         = 0xc052,
        kSsangpieupYuChieuch                         = 0xc053,
        kSsangpieupYuKhieukh                         = 0xc054,
        kSsangpieupYuThieuth                         = 0xc055,
        kSsangpieupYuPhieuph                         = 0xc056,
        kSsangpieupYuHieuh                         = 0xc057,
        kSsangpieupEu                           = 0xc058,
        kSsangpieupEuKiyeok                         = 0xc059,
        kSsangpieupEuSsangkiyeok                         = 0xc05a,
        kSsangpieupEuKiyeoksios                         = 0xc05b,
        kSsangpieupEuNieun                         = 0xc05c,
        kSsangpieupEuNieuncieuc                         = 0xc05d,
        kSsangpieupEuNieunhieuh                         = 0xc05e,
        kSsangpieupEuTikeut                         = 0xc05f,
        kSsangpieupEuRieul                         = 0xc060,
        kSsangpieupEuRieulkiyeok                         = 0xc061,
        kSsangpieupEuRieulmieum                         = 0xc062,
        kSsangpieupEuRieulpieup                         = 0xc063,
        kSsangpieupEuRieulsios                         = 0xc064,
        kSsangpieupEuRieulthieuth                         = 0xc065,
        kSsangpieupEuRieulphieuph                         = 0xc066,
        kSsangpieupEuRieulhieuh                         = 0xc067,
        kSsangpieupEuMieum                         = 0xc068,
        kSsangpieupEuPieup                         = 0xc069,
        kSsangpieupEuPieupsios                         = 0xc06a,
        kSsangpieupEuSios                         = 0xc06b,
        kSsangpieupEuSsangsios                         = 0xc06c,
        kSsangpieupEuIeung                         = 0xc06d,
        kSsangpieupEuCieuc                         = 0xc06e,
        kSsangpieupEuChieuch                         = 0xc06f,
        kSsangpieupEuKhieukh                         = 0xc070,
        kSsangpieupEuThieuth                         = 0xc071,
        kSsangpieupEuPhieuph                         = 0xc072,
        kSsangpieupEuHieuh                         = 0xc073,
        kSsangpieupYi                           = 0xc074,
        kSsangpieupYiKiyeok                         = 0xc075,
        kSsangpieupYiSsangkiyeok                         = 0xc076,
        kSsangpieupYiKiyeoksios                         = 0xc077,
        kSsangpieupYiNieun                         = 0xc078,
        kSsangpieupYiNieuncieuc                         = 0xc079,
        kSsangpieupYiNieunhieuh                         = 0xc07a,
        kSsangpieupYiTikeut                         = 0xc07b,
        kSsangpieupYiRieul                         = 0xc07c,
        kSsangpieupYiRieulkiyeok                         = 0xc07d,
        kSsangpieupYiRieulmieum                         = 0xc07e,
        kSsangpieupYiRieulpieup                         = 0xc07f,
        kSsangpieupYiRieulsios                         = 0xc080,
        kSsangpieupYiRieulthieuth                         = 0xc081,
        kSsangpieupYiRieulphieuph                         = 0xc082,
        kSsangpieupYiRieulhieuh                         = 0xc083,
        kSsangpieupYiMieum                         = 0xc084,
        kSsangpieupYiPieup                         = 0xc085,
        kSsangpieupYiPieupsios                         = 0xc086,
        kSsangpieupYiSios                         = 0xc087,
        kSsangpieupYiSsangsios                         = 0xc088,
        kSsangpieupYiIeung                         = 0xc089,
        kSsangpieupYiCieuc                         = 0xc08a,
        kSsangpieupYiChieuch                         = 0xc08b,
        kSsangpieupYiKhieukh                         = 0xc08c,
        kSsangpieupYiThieuth                         = 0xc08d,
        kSsangpieupYiPhieuph                         = 0xc08e,
        kSsangpieupYiHieuh                         = 0xc08f,
        kSsangpieupI                           = 0xc090,
        kSsangpieupIKiyeok                         = 0xc091,
        kSsangpieupISsangkiyeok                         = 0xc092,
        kSsangpieupIKiyeoksios                         = 0xc093,
        kSsangpieupINieun                         = 0xc094,
        kSsangpieupINieuncieuc                         = 0xc095,
        kSsangpieupINieunhieuh                         = 0xc096,
        kSsangpieupITikeut                         = 0xc097,
        kSsangpieupIRieul                         = 0xc098,
        kSsangpieupIRieulkiyeok                         = 0xc099,
        kSsangpieupIRieulmieum                         = 0xc09a,
        kSsangpieupIRieulpieup                         = 0xc09b,
        kSsangpieupIRieulsios                         = 0xc09c,
        kSsangpieupIRieulthieuth                         = 0xc09d,
        kSsangpieupIRieulphieuph                         = 0xc09e,
        kSsangpieupIRieulhieuh                         = 0xc09f,
        kSsangpieupIMieum                         = 0xc0a0,
        kSsangpieupIPieup                         = 0xc0a1,
        kSsangpieupIPieupsios                         = 0xc0a2,
        kSsangpieupISios                         = 0xc0a3,
        kSsangpieupISsangsios                         = 0xc0a4,
        kSsangpieupIIeung                         = 0xc0a5,
        kSsangpieupICieuc                         = 0xc0a6,
        kSsangpieupIChieuch                         = 0xc0a7,
        kSsangpieupIKhieukh                         = 0xc0a8,
        kSsangpieupIThieuth                         = 0xc0a9,
        kSsangpieupIPhieuph                         = 0xc0aa,
        kSsangpieupIHieuh                         = 0xc0ab,
        kSiosA                           = 0xc0ac,
        kSiosAKiyeok                         = 0xc0ad,
        kSiosASsangkiyeok                         = 0xc0ae,
        kSiosAKiyeoksios                         = 0xc0af,
        kSiosANieun                         = 0xc0b0,
        kSiosANieuncieuc                         = 0xc0b1,
        kSiosANieunhieuh                         = 0xc0b2,
        kSiosATikeut                         = 0xc0b3,
        kSiosARieul                         = 0xc0b4,
        kSiosARieulkiyeok                         = 0xc0b5,
        kSiosARieulmieum                         = 0xc0b6,
        kSiosARieulpieup                         = 0xc0b7,
        kSiosARieulsios                         = 0xc0b8,
        kSiosARieulthieuth                         = 0xc0b9,
        kSiosARieulphieuph                         = 0xc0ba,
        kSiosARieulhieuh                         = 0xc0bb,
        kSiosAMieum                         = 0xc0bc,
        kSiosAPieup                         = 0xc0bd,
        kSiosAPieupsios                         = 0xc0be,
        kSiosASios                         = 0xc0bf,
        kSiosASsangsios                         = 0xc0c0,
        kSiosAIeung                         = 0xc0c1,
        kSiosACieuc                         = 0xc0c2,
        kSiosAChieuch                         = 0xc0c3,
        kSiosAKhieukh                         = 0xc0c4,
        kSiosAThieuth                         = 0xc0c5,
        kSiosAPhieuph                         = 0xc0c6,
        kSiosAHieuh                         = 0xc0c7,
        kSiosAe                           = 0xc0c8,
        kSiosAeKiyeok                         = 0xc0c9,
        kSiosAeSsangkiyeok                         = 0xc0ca,
        kSiosAeKiyeoksios                         = 0xc0cb,
        kSiosAeNieun                         = 0xc0cc,
        kSiosAeNieuncieuc                         = 0xc0cd,
        kSiosAeNieunhieuh                         = 0xc0ce,
        kSiosAeTikeut                         = 0xc0cf,
        kSiosAeRieul                         = 0xc0d0,
        kSiosAeRieulkiyeok                         = 0xc0d1,
        kSiosAeRieulmieum                         = 0xc0d2,
        kSiosAeRieulpieup                         = 0xc0d3,
        kSiosAeRieulsios                         = 0xc0d4,
        kSiosAeRieulthieuth                         = 0xc0d5,
        kSiosAeRieulphieuph                         = 0xc0d6,
        kSiosAeRieulhieuh                         = 0xc0d7,
        kSiosAeMieum                         = 0xc0d8,
        kSiosAePieup                         = 0xc0d9,
        kSiosAePieupsios                         = 0xc0da,
        kSiosAeSios                         = 0xc0db,
        kSiosAeSsangsios                         = 0xc0dc,
        kSiosAeIeung                         = 0xc0dd,
        kSiosAeCieuc                         = 0xc0de,
        kSiosAeChieuch                         = 0xc0df,
        kSiosAeKhieukh                         = 0xc0e0,
        kSiosAeThieuth                         = 0xc0e1,
        kSiosAePhieuph                         = 0xc0e2,
        kSiosAeHieuh                         = 0xc0e3,
        kSiosYa                           = 0xc0e4,
        kSiosYaKiyeok                         = 0xc0e5,
        kSiosYaSsangkiyeok                         = 0xc0e6,
        kSiosYaKiyeoksios                         = 0xc0e7,
        kSiosYaNieun                         = 0xc0e8,
        kSiosYaNieuncieuc                         = 0xc0e9,
        kSiosYaNieunhieuh                         = 0xc0ea,
        kSiosYaTikeut                         = 0xc0eb,
        kSiosYaRieul                         = 0xc0ec,
        kSiosYaRieulkiyeok                         = 0xc0ed,
        kSiosYaRieulmieum                         = 0xc0ee,
        kSiosYaRieulpieup                         = 0xc0ef,
        kSiosYaRieulsios                         = 0xc0f0,
        kSiosYaRieulthieuth                         = 0xc0f1,
        kSiosYaRieulphieuph                         = 0xc0f2,
        kSiosYaRieulhieuh                         = 0xc0f3,
        kSiosYaMieum                         = 0xc0f4,
        kSiosYaPieup                         = 0xc0f5,
        kSiosYaPieupsios                         = 0xc0f6,
        kSiosYaSios                         = 0xc0f7,
        kSiosYaSsangsios                         = 0xc0f8,
        kSiosYaIeung                         = 0xc0f9,
        kSiosYaCieuc                         = 0xc0fa,
        kSiosYaChieuch                         = 0xc0fb,
        kSiosYaKhieukh                         = 0xc0fc,
        kSiosYaThieuth                         = 0xc0fd,
        kSiosYaPhieuph                         = 0xc0fe,
        kSiosYaHieuh                         = 0xc0ff,
        kSiosYae                           = 0xc100,
        kSiosYaeKiyeok                         = 0xc101,
        kSiosYaeSsangkiyeok                         = 0xc102,
        kSiosYaeKiyeoksios                         = 0xc103,
        kSiosYaeNieun                         = 0xc104,
        kSiosYaeNieuncieuc                         = 0xc105,
        kSiosYaeNieunhieuh                         = 0xc106,
        kSiosYaeTikeut                         = 0xc107,
        kSiosYaeRieul                         = 0xc108,
        kSiosYaeRieulkiyeok                         = 0xc109,
        kSiosYaeRieulmieum                         = 0xc10a,
        kSiosYaeRieulpieup                         = 0xc10b,
        kSiosYaeRieulsios                         = 0xc10c,
        kSiosYaeRieulthieuth                         = 0xc10d,
        kSiosYaeRieulphieuph                         = 0xc10e,
        kSiosYaeRieulhieuh                         = 0xc10f,
        kSiosYaeMieum                         = 0xc110,
        kSiosYaePieup                         = 0xc111,
        kSiosYaePieupsios                         = 0xc112,
        kSiosYaeSios                         = 0xc113,
        kSiosYaeSsangsios                         = 0xc114,
        kSiosYaeIeung                         = 0xc115,
        kSiosYaeCieuc                         = 0xc116,
        kSiosYaeChieuch                         = 0xc117,
        kSiosYaeKhieukh                         = 0xc118,
        kSiosYaeThieuth                         = 0xc119,
        kSiosYaePhieuph                         = 0xc11a,
        kSiosYaeHieuh                         = 0xc11b,
        kSiosEo                           = 0xc11c,
        kSiosEoKiyeok                         = 0xc11d,
        kSiosEoSsangkiyeok                         = 0xc11e,
        kSiosEoKiyeoksios                         = 0xc11f,
        kSiosEoNieun                         = 0xc120,
        kSiosEoNieuncieuc                         = 0xc121,
        kSiosEoNieunhieuh                         = 0xc122,
        kSiosEoTikeut                         = 0xc123,
        kSiosEoRieul                         = 0xc124,
        kSiosEoRieulkiyeok                         = 0xc125,
        kSiosEoRieulmieum                         = 0xc126,
        kSiosEoRieulpieup                         = 0xc127,
        kSiosEoRieulsios                         = 0xc128,
        kSiosEoRieulthieuth                         = 0xc129,
        kSiosEoRieulphieuph                         = 0xc12a,
        kSiosEoRieulhieuh                         = 0xc12b,
        kSiosEoMieum                         = 0xc12c,
        kSiosEoPieup                         = 0xc12d,
        kSiosEoPieupsios                         = 0xc12e,
        kSiosEoSios                         = 0xc12f,
        kSiosEoSsangsios                         = 0xc130,
        kSiosEoIeung                         = 0xc131,
        kSiosEoCieuc                         = 0xc132,
        kSiosEoChieuch                         = 0xc133,
        kSiosEoKhieukh                         = 0xc134,
        kSiosEoThieuth                         = 0xc135,
        kSiosEoPhieuph                         = 0xc136,
        kSiosEoHieuh                         = 0xc137,
        kSiosE                           = 0xc138,
        kSiosEKiyeok                         = 0xc139,
        kSiosESsangkiyeok                         = 0xc13a,
        kSiosEKiyeoksios                         = 0xc13b,
        kSiosENieun                         = 0xc13c,
        kSiosENieuncieuc                         = 0xc13d,
        kSiosENieunhieuh                         = 0xc13e,
        kSiosETikeut                         = 0xc13f,
        kSiosERieul                         = 0xc140,
        kSiosERieulkiyeok                         = 0xc141,
        kSiosERieulmieum                         = 0xc142,
        kSiosERieulpieup                         = 0xc143,
        kSiosERieulsios                         = 0xc144,
        kSiosERieulthieuth                         = 0xc145,
        kSiosERieulphieuph                         = 0xc146,
        kSiosERieulhieuh                         = 0xc147,
        kSiosEMieum                         = 0xc148,
        kSiosEPieup                         = 0xc149,
        kSiosEPieupsios                         = 0xc14a,
        kSiosESios                         = 0xc14b,
        kSiosESsangsios                         = 0xc14c,
        kSiosEIeung                         = 0xc14d,
        kSiosECieuc                         = 0xc14e,
        kSiosEChieuch                         = 0xc14f,
        kSiosEKhieukh                         = 0xc150,
        kSiosEThieuth                         = 0xc151,
        kSiosEPhieuph                         = 0xc152,
        kSiosEHieuh                         = 0xc153,
        kSiosYeo                           = 0xc154,
        kSiosYeoKiyeok                         = 0xc155,
        kSiosYeoSsangkiyeok                         = 0xc156,
        kSiosYeoKiyeoksios                         = 0xc157,
        kSiosYeoNieun                         = 0xc158,
        kSiosYeoNieuncieuc                         = 0xc159,
        kSiosYeoNieunhieuh                         = 0xc15a,
        kSiosYeoTikeut                         = 0xc15b,
        kSiosYeoRieul                         = 0xc15c,
        kSiosYeoRieulkiyeok                         = 0xc15d,
        kSiosYeoRieulmieum                         = 0xc15e,
        kSiosYeoRieulpieup                         = 0xc15f,
        kSiosYeoRieulsios                         = 0xc160,
        kSiosYeoRieulthieuth                         = 0xc161,
        kSiosYeoRieulphieuph                         = 0xc162,
        kSiosYeoRieulhieuh                         = 0xc163,
        kSiosYeoMieum                         = 0xc164,
        kSiosYeoPieup                         = 0xc165,
        kSiosYeoPieupsios                         = 0xc166,
        kSiosYeoSios                         = 0xc167,
        kSiosYeoSsangsios                         = 0xc168,
        kSiosYeoIeung                         = 0xc169,
        kSiosYeoCieuc                         = 0xc16a,
        kSiosYeoChieuch                         = 0xc16b,
        kSiosYeoKhieukh                         = 0xc16c,
        kSiosYeoThieuth                         = 0xc16d,
        kSiosYeoPhieuph                         = 0xc16e,
        kSiosYeoHieuh                         = 0xc16f,
        kSiosYe                           = 0xc170,
        kSiosYeKiyeok                         = 0xc171,
        kSiosYeSsangkiyeok                         = 0xc172,
        kSiosYeKiyeoksios                         = 0xc173,
        kSiosYeNieun                         = 0xc174,
        kSiosYeNieuncieuc                         = 0xc175,
        kSiosYeNieunhieuh                         = 0xc176,
        kSiosYeTikeut                         = 0xc177,
        kSiosYeRieul                         = 0xc178,
        kSiosYeRieulkiyeok                         = 0xc179,
        kSiosYeRieulmieum                         = 0xc17a,
        kSiosYeRieulpieup                         = 0xc17b,
        kSiosYeRieulsios                         = 0xc17c,
        kSiosYeRieulthieuth                         = 0xc17d,
        kSiosYeRieulphieuph                         = 0xc17e,
        kSiosYeRieulhieuh                         = 0xc17f,
        kSiosYeMieum                         = 0xc180,
        kSiosYePieup                         = 0xc181,
        kSiosYePieupsios                         = 0xc182,
        kSiosYeSios                         = 0xc183,
        kSiosYeSsangsios                         = 0xc184,
        kSiosYeIeung                         = 0xc185,
        kSiosYeCieuc                         = 0xc186,
        kSiosYeChieuch                         = 0xc187,
        kSiosYeKhieukh                         = 0xc188,
        kSiosYeThieuth                         = 0xc189,
        kSiosYePhieuph                         = 0xc18a,
        kSiosYeHieuh                         = 0xc18b,
        kSiosO                           = 0xc18c,
        kSiosOKiyeok                         = 0xc18d,
        kSiosOSsangkiyeok                         = 0xc18e,
        kSiosOKiyeoksios                         = 0xc18f,
        kSiosONieun                         = 0xc190,
        kSiosONieuncieuc                         = 0xc191,
        kSiosONieunhieuh                         = 0xc192,
        kSiosOTikeut                         = 0xc193,
        kSiosORieul                         = 0xc194,
        kSiosORieulkiyeok                         = 0xc195,
        kSiosORieulmieum                         = 0xc196,
        kSiosORieulpieup                         = 0xc197,
        kSiosORieulsios                         = 0xc198,
        kSiosORieulthieuth                         = 0xc199,
        kSiosORieulphieuph                         = 0xc19a,
        kSiosORieulhieuh                         = 0xc19b,
        kSiosOMieum                         = 0xc19c,
        kSiosOPieup                         = 0xc19d,
        kSiosOPieupsios                         = 0xc19e,
        kSiosOSios                         = 0xc19f,
        kSiosOSsangsios                         = 0xc1a0,
        kSiosOIeung                         = 0xc1a1,
        kSiosOCieuc                         = 0xc1a2,
        kSiosOChieuch                         = 0xc1a3,
        kSiosOKhieukh                         = 0xc1a4,
        kSiosOThieuth                         = 0xc1a5,
        kSiosOPhieuph                         = 0xc1a6,
        kSiosOHieuh                         = 0xc1a7,
        kSiosWa                           = 0xc1a8,
        kSiosWaKiyeok                         = 0xc1a9,
        kSiosWaSsangkiyeok                         = 0xc1aa,
        kSiosWaKiyeoksios                         = 0xc1ab,
        kSiosWaNieun                         = 0xc1ac,
        kSiosWaNieuncieuc                         = 0xc1ad,
        kSiosWaNieunhieuh                         = 0xc1ae,
        kSiosWaTikeut                         = 0xc1af,
        kSiosWaRieul                         = 0xc1b0,
        kSiosWaRieulkiyeok                         = 0xc1b1,
        kSiosWaRieulmieum                         = 0xc1b2,
        kSiosWaRieulpieup                         = 0xc1b3,
        kSiosWaRieulsios                         = 0xc1b4,
        kSiosWaRieulthieuth                         = 0xc1b5,
        kSiosWaRieulphieuph                         = 0xc1b6,
        kSiosWaRieulhieuh                         = 0xc1b7,
        kSiosWaMieum                         = 0xc1b8,
        kSiosWaPieup                         = 0xc1b9,
        kSiosWaPieupsios                         = 0xc1ba,
        kSiosWaSios                         = 0xc1bb,
        kSiosWaSsangsios                         = 0xc1bc,
        kSiosWaIeung                         = 0xc1bd,
        kSiosWaCieuc                         = 0xc1be,
        kSiosWaChieuch                         = 0xc1bf,
        kSiosWaKhieukh                         = 0xc1c0,
        kSiosWaThieuth                         = 0xc1c1,
        kSiosWaPhieuph                         = 0xc1c2,
        kSiosWaHieuh                         = 0xc1c3,
        kSiosWae                           = 0xc1c4,
        kSiosWaeKiyeok                         = 0xc1c5,
        kSiosWaeSsangkiyeok                         = 0xc1c6,
        kSiosWaeKiyeoksios                         = 0xc1c7,
        kSiosWaeNieun                         = 0xc1c8,
        kSiosWaeNieuncieuc                         = 0xc1c9,
        kSiosWaeNieunhieuh                         = 0xc1ca,
        kSiosWaeTikeut                         = 0xc1cb,
        kSiosWaeRieul                         = 0xc1cc,
        kSiosWaeRieulkiyeok                         = 0xc1cd,
        kSiosWaeRieulmieum                         = 0xc1ce,
        kSiosWaeRieulpieup                         = 0xc1cf,
        kSiosWaeRieulsios                         = 0xc1d0,
        kSiosWaeRieulthieuth                         = 0xc1d1,
        kSiosWaeRieulphieuph                         = 0xc1d2,
        kSiosWaeRieulhieuh                         = 0xc1d3,
        kSiosWaeMieum                         = 0xc1d4,
        kSiosWaePieup                         = 0xc1d5,
        kSiosWaePieupsios                         = 0xc1d6,
        kSiosWaeSios                         = 0xc1d7,
        kSiosWaeSsangsios                         = 0xc1d8,
        kSiosWaeIeung                         = 0xc1d9,
        kSiosWaeCieuc                         = 0xc1da,
        kSiosWaeChieuch                         = 0xc1db,
        kSiosWaeKhieukh                         = 0xc1dc,
        kSiosWaeThieuth                         = 0xc1dd,
        kSiosWaePhieuph                         = 0xc1de,
        kSiosWaeHieuh                         = 0xc1df,
        kSiosOe                           = 0xc1e0,
        kSiosOeKiyeok                         = 0xc1e1,
        kSiosOeSsangkiyeok                         = 0xc1e2,
        kSiosOeKiyeoksios                         = 0xc1e3,
        kSiosOeNieun                         = 0xc1e4,
        kSiosOeNieuncieuc                         = 0xc1e5,
        kSiosOeNieunhieuh                         = 0xc1e6,
        kSiosOeTikeut                         = 0xc1e7,
        kSiosOeRieul                         = 0xc1e8,
        kSiosOeRieulkiyeok                         = 0xc1e9,
        kSiosOeRieulmieum                         = 0xc1ea,
        kSiosOeRieulpieup                         = 0xc1eb,
        kSiosOeRieulsios                         = 0xc1ec,
        kSiosOeRieulthieuth                         = 0xc1ed,
        kSiosOeRieulphieuph                         = 0xc1ee,
        kSiosOeRieulhieuh                         = 0xc1ef,
        kSiosOeMieum                         = 0xc1f0,
        kSiosOePieup                         = 0xc1f1,
        kSiosOePieupsios                         = 0xc1f2,
        kSiosOeSios                         = 0xc1f3,
        kSiosOeSsangsios                         = 0xc1f4,
        kSiosOeIeung                         = 0xc1f5,
        kSiosOeCieuc                         = 0xc1f6,
        kSiosOeChieuch                         = 0xc1f7,
        kSiosOeKhieukh                         = 0xc1f8,
        kSiosOeThieuth                         = 0xc1f9,
        kSiosOePhieuph                         = 0xc1fa,
        kSiosOeHieuh                         = 0xc1fb,
        kSiosYo                           = 0xc1fc,
        kSiosYoKiyeok                         = 0xc1fd,
        kSiosYoSsangkiyeok                         = 0xc1fe,
        kSiosYoKiyeoksios                         = 0xc1ff,
        kSiosYoNieun                         = 0xc200,
        kSiosYoNieuncieuc                         = 0xc201,
        kSiosYoNieunhieuh                         = 0xc202,
        kSiosYoTikeut                         = 0xc203,
        kSiosYoRieul                         = 0xc204,
        kSiosYoRieulkiyeok                         = 0xc205,
        kSiosYoRieulmieum                         = 0xc206,
        kSiosYoRieulpieup                         = 0xc207,
        kSiosYoRieulsios                         = 0xc208,
        kSiosYoRieulthieuth                         = 0xc209,
        kSiosYoRieulphieuph                         = 0xc20a,
        kSiosYoRieulhieuh                         = 0xc20b,
        kSiosYoMieum                         = 0xc20c,
        kSiosYoPieup                         = 0xc20d,
        kSiosYoPieupsios                         = 0xc20e,
        kSiosYoSios                         = 0xc20f,
        kSiosYoSsangsios                         = 0xc210,
        kSiosYoIeung                         = 0xc211,
        kSiosYoCieuc                         = 0xc212,
        kSiosYoChieuch                         = 0xc213,
        kSiosYoKhieukh                         = 0xc214,
        kSiosYoThieuth                         = 0xc215,
        kSiosYoPhieuph                         = 0xc216,
        kSiosYoHieuh                         = 0xc217,
        kSiosU                           = 0xc218,
        kSiosUKiyeok                         = 0xc219,
        kSiosUSsangkiyeok                         = 0xc21a,
        kSiosUKiyeoksios                         = 0xc21b,
        kSiosUNieun                         = 0xc21c,
        kSiosUNieuncieuc                         = 0xc21d,
        kSiosUNieunhieuh                         = 0xc21e,
        kSiosUTikeut                         = 0xc21f,
        kSiosURieul                         = 0xc220,
        kSiosURieulkiyeok                         = 0xc221,
        kSiosURieulmieum                         = 0xc222,
        kSiosURieulpieup                         = 0xc223,
        kSiosURieulsios                         = 0xc224,
        kSiosURieulthieuth                         = 0xc225,
        kSiosURieulphieuph                         = 0xc226,
        kSiosURieulhieuh                         = 0xc227,
        kSiosUMieum                         = 0xc228,
        kSiosUPieup                         = 0xc229,
        kSiosUPieupsios                         = 0xc22a,
        kSiosUSios                         = 0xc22b,
        kSiosUSsangsios                         = 0xc22c,
        kSiosUIeung                         = 0xc22d,
        kSiosUCieuc                         = 0xc22e,
        kSiosUChieuch                         = 0xc22f,
        kSiosUKhieukh                         = 0xc230,
        kSiosUThieuth                         = 0xc231,
        kSiosUPhieuph                         = 0xc232,
        kSiosUHieuh                         = 0xc233,
        kSiosWeo                           = 0xc234,
        kSiosWeoKiyeok                         = 0xc235,
        kSiosWeoSsangkiyeok                         = 0xc236,
        kSiosWeoKiyeoksios                         = 0xc237,
        kSiosWeoNieun                         = 0xc238,
        kSiosWeoNieuncieuc                         = 0xc239,
        kSiosWeoNieunhieuh                         = 0xc23a,
        kSiosWeoTikeut                         = 0xc23b,
        kSiosWeoRieul                         = 0xc23c,
        kSiosWeoRieulkiyeok                         = 0xc23d,
        kSiosWeoRieulmieum                         = 0xc23e,
        kSiosWeoRieulpieup                         = 0xc23f,
        kSiosWeoRieulsios                         = 0xc240,
        kSiosWeoRieulthieuth                         = 0xc241,
        kSiosWeoRieulphieuph                         = 0xc242,
        kSiosWeoRieulhieuh                         = 0xc243,
        kSiosWeoMieum                         = 0xc244,
        kSiosWeoPieup                         = 0xc245,
        kSiosWeoPieupsios                         = 0xc246,
        kSiosWeoSios                         = 0xc247,
        kSiosWeoSsangsios                         = 0xc248,
        kSiosWeoIeung                         = 0xc249,
        kSiosWeoCieuc                         = 0xc24a,
        kSiosWeoChieuch                         = 0xc24b,
        kSiosWeoKhieukh                         = 0xc24c,
        kSiosWeoThieuth                         = 0xc24d,
        kSiosWeoPhieuph                         = 0xc24e,
        kSiosWeoHieuh                         = 0xc24f,
        kSiosWe                           = 0xc250,
        kSiosWeKiyeok                         = 0xc251,
        kSiosWeSsangkiyeok                         = 0xc252,
        kSiosWeKiyeoksios                         = 0xc253,
        kSiosWeNieun                         = 0xc254,
        kSiosWeNieuncieuc                         = 0xc255,
        kSiosWeNieunhieuh                         = 0xc256,
        kSiosWeTikeut                         = 0xc257,
        kSiosWeRieul                         = 0xc258,
        kSiosWeRieulkiyeok                         = 0xc259,
        kSiosWeRieulmieum                         = 0xc25a,
        kSiosWeRieulpieup                         = 0xc25b,
        kSiosWeRieulsios                         = 0xc25c,
        kSiosWeRieulthieuth                         = 0xc25d,
        kSiosWeRieulphieuph                         = 0xc25e,
        kSiosWeRieulhieuh                         = 0xc25f,
        kSiosWeMieum                         = 0xc260,
        kSiosWePieup                         = 0xc261,
        kSiosWePieupsios                         = 0xc262,
        kSiosWeSios                         = 0xc263,
        kSiosWeSsangsios                         = 0xc264,
        kSiosWeIeung                         = 0xc265,
        kSiosWeCieuc                         = 0xc266,
        kSiosWeChieuch                         = 0xc267,
        kSiosWeKhieukh                         = 0xc268,
        kSiosWeThieuth                         = 0xc269,
        kSiosWePhieuph                         = 0xc26a,
        kSiosWeHieuh                         = 0xc26b,
        kSiosWi                           = 0xc26c,
        kSiosWiKiyeok                         = 0xc26d,
        kSiosWiSsangkiyeok                         = 0xc26e,
        kSiosWiKiyeoksios                         = 0xc26f,
        kSiosWiNieun                         = 0xc270,
        kSiosWiNieuncieuc                         = 0xc271,
        kSiosWiNieunhieuh                         = 0xc272,
        kSiosWiTikeut                         = 0xc273,
        kSiosWiRieul                         = 0xc274,
        kSiosWiRieulkiyeok                         = 0xc275,
        kSiosWiRieulmieum                         = 0xc276,
        kSiosWiRieulpieup                         = 0xc277,
        kSiosWiRieulsios                         = 0xc278,
        kSiosWiRieulthieuth                         = 0xc279,
        kSiosWiRieulphieuph                         = 0xc27a,
        kSiosWiRieulhieuh                         = 0xc27b,
        kSiosWiMieum                         = 0xc27c,
        kSiosWiPieup                         = 0xc27d,
        kSiosWiPieupsios                         = 0xc27e,
        kSiosWiSios                         = 0xc27f,
        kSiosWiSsangsios                         = 0xc280,
        kSiosWiIeung                         = 0xc281,
        kSiosWiCieuc                         = 0xc282,
        kSiosWiChieuch                         = 0xc283,
        kSiosWiKhieukh                         = 0xc284,
        kSiosWiThieuth                         = 0xc285,
        kSiosWiPhieuph                         = 0xc286,
        kSiosWiHieuh                         = 0xc287,
        kSiosYu                           = 0xc288,
        kSiosYuKiyeok                         = 0xc289,
        kSiosYuSsangkiyeok                         = 0xc28a,
        kSiosYuKiyeoksios                         = 0xc28b,
        kSiosYuNieun                         = 0xc28c,
        kSiosYuNieuncieuc                         = 0xc28d,
        kSiosYuNieunhieuh                         = 0xc28e,
        kSiosYuTikeut                         = 0xc28f,
        kSiosYuRieul                         = 0xc290,
        kSiosYuRieulkiyeok                         = 0xc291,
        kSiosYuRieulmieum                         = 0xc292,
        kSiosYuRieulpieup                         = 0xc293,
        kSiosYuRieulsios                         = 0xc294,
        kSiosYuRieulthieuth                         = 0xc295,
        kSiosYuRieulphieuph                         = 0xc296,
        kSiosYuRieulhieuh                         = 0xc297,
        kSiosYuMieum                         = 0xc298,
        kSiosYuPieup                         = 0xc299,
        kSiosYuPieupsios                         = 0xc29a,
        kSiosYuSios                         = 0xc29b,
        kSiosYuSsangsios                         = 0xc29c,
        kSiosYuIeung                         = 0xc29d,
        kSiosYuCieuc                         = 0xc29e,
        kSiosYuChieuch                         = 0xc29f,
        kSiosYuKhieukh                         = 0xc2a0,
        kSiosYuThieuth                         = 0xc2a1,
        kSiosYuPhieuph                         = 0xc2a2,
        kSiosYuHieuh                         = 0xc2a3,
        kSiosEu                           = 0xc2a4,
        kSiosEuKiyeok                         = 0xc2a5,
        kSiosEuSsangkiyeok                         = 0xc2a6,
        kSiosEuKiyeoksios                         = 0xc2a7,
        kSiosEuNieun                         = 0xc2a8,
        kSiosEuNieuncieuc                         = 0xc2a9,
        kSiosEuNieunhieuh                         = 0xc2aa,
        kSiosEuTikeut                         = 0xc2ab,
        kSiosEuRieul                         = 0xc2ac,
        kSiosEuRieulkiyeok                         = 0xc2ad,
        kSiosEuRieulmieum                         = 0xc2ae,
        kSiosEuRieulpieup                         = 0xc2af,
        kSiosEuRieulsios                         = 0xc2b0,
        kSiosEuRieulthieuth                         = 0xc2b1,
        kSiosEuRieulphieuph                         = 0xc2b2,
        kSiosEuRieulhieuh                         = 0xc2b3,
        kSiosEuMieum                         = 0xc2b4,
        kSiosEuPieup                         = 0xc2b5,
        kSiosEuPieupsios                         = 0xc2b6,
        kSiosEuSios                         = 0xc2b7,
        kSiosEuSsangsios                         = 0xc2b8,
        kSiosEuIeung                         = 0xc2b9,
        kSiosEuCieuc                         = 0xc2ba,
        kSiosEuChieuch                         = 0xc2bb,
        kSiosEuKhieukh                         = 0xc2bc,
        kSiosEuThieuth                         = 0xc2bd,
        kSiosEuPhieuph                         = 0xc2be,
        kSiosEuHieuh                         = 0xc2bf,
        kSiosYi                           = 0xc2c0,
        kSiosYiKiyeok                         = 0xc2c1,
        kSiosYiSsangkiyeok                         = 0xc2c2,
        kSiosYiKiyeoksios                         = 0xc2c3,
        kSiosYiNieun                         = 0xc2c4,
        kSiosYiNieuncieuc                         = 0xc2c5,
        kSiosYiNieunhieuh                         = 0xc2c6,
        kSiosYiTikeut                         = 0xc2c7,
        kSiosYiRieul                         = 0xc2c8,
        kSiosYiRieulkiyeok                         = 0xc2c9,
        kSiosYiRieulmieum                         = 0xc2ca,
        kSiosYiRieulpieup                         = 0xc2cb,
        kSiosYiRieulsios                         = 0xc2cc,
        kSiosYiRieulthieuth                         = 0xc2cd,
        kSiosYiRieulphieuph                         = 0xc2ce,
        kSiosYiRieulhieuh                         = 0xc2cf,
        kSiosYiMieum                         = 0xc2d0,
        kSiosYiPieup                         = 0xc2d1,
        kSiosYiPieupsios                         = 0xc2d2,
        kSiosYiSios                         = 0xc2d3,
        kSiosYiSsangsios                         = 0xc2d4,
        kSiosYiIeung                         = 0xc2d5,
        kSiosYiCieuc                         = 0xc2d6,
        kSiosYiChieuch                         = 0xc2d7,
        kSiosYiKhieukh                         = 0xc2d8,
        kSiosYiThieuth                         = 0xc2d9,
        kSiosYiPhieuph                         = 0xc2da,
        kSiosYiHieuh                         = 0xc2db,
        kSiosI                           = 0xc2dc,
        kSiosIKiyeok                         = 0xc2dd,
        kSiosISsangkiyeok                         = 0xc2de,
        kSiosIKiyeoksios                         = 0xc2df,
        kSiosINieun                         = 0xc2e0,
        kSiosINieuncieuc                         = 0xc2e1,
        kSiosINieunhieuh                         = 0xc2e2,
        kSiosITikeut                         = 0xc2e3,
        kSiosIRieul                         = 0xc2e4,
        kSiosIRieulkiyeok                         = 0xc2e5,
        kSiosIRieulmieum                         = 0xc2e6,
        kSiosIRieulpieup                         = 0xc2e7,
        kSiosIRieulsios                         = 0xc2e8,
        kSiosIRieulthieuth                         = 0xc2e9,
        kSiosIRieulphieuph                         = 0xc2ea,
        kSiosIRieulhieuh                         = 0xc2eb,
        kSiosIMieum                         = 0xc2ec,
        kSiosIPieup                         = 0xc2ed,
        kSiosIPieupsios                         = 0xc2ee,
        kSiosISios                         = 0xc2ef,
        kSiosISsangsios                         = 0xc2f0,
        kSiosIIeung                         = 0xc2f1,
        kSiosICieuc                         = 0xc2f2,
        kSiosIChieuch                         = 0xc2f3,
        kSiosIKhieukh                         = 0xc2f4,
        kSiosIThieuth                         = 0xc2f5,
        kSiosIPhieuph                         = 0xc2f6,
        kSiosIHieuh                         = 0xc2f7,
        kSsangsiosA                           = 0xc2f8,
        kSsangsiosAKiyeok                         = 0xc2f9,
        kSsangsiosASsangkiyeok                         = 0xc2fa,
        kSsangsiosAKiyeoksios                         = 0xc2fb,
        kSsangsiosANieun                         = 0xc2fc,
        kSsangsiosANieuncieuc                         = 0xc2fd,
        kSsangsiosANieunhieuh                         = 0xc2fe,
        kSsangsiosATikeut                         = 0xc2ff,
        kSsangsiosARieul                         = 0xc300,
        kSsangsiosARieulkiyeok                         = 0xc301,
        kSsangsiosARieulmieum                         = 0xc302,
        kSsangsiosARieulpieup                         = 0xc303,
        kSsangsiosARieulsios                         = 0xc304,
        kSsangsiosARieulthieuth                         = 0xc305,
        kSsangsiosARieulphieuph                         = 0xc306,
        kSsangsiosARieulhieuh                         = 0xc307,
        kSsangsiosAMieum                         = 0xc308,
        kSsangsiosAPieup                         = 0xc309,
        kSsangsiosAPieupsios                         = 0xc30a,
        kSsangsiosASios                         = 0xc30b,
        kSsangsiosASsangsios                         = 0xc30c,
        kSsangsiosAIeung                         = 0xc30d,
        kSsangsiosACieuc                         = 0xc30e,
        kSsangsiosAChieuch                         = 0xc30f,
        kSsangsiosAKhieukh                         = 0xc310,
        kSsangsiosAThieuth                         = 0xc311,
        kSsangsiosAPhieuph                         = 0xc312,
        kSsangsiosAHieuh                         = 0xc313,
        kSsangsiosAe                           = 0xc314,
        kSsangsiosAeKiyeok                         = 0xc315,
        kSsangsiosAeSsangkiyeok                         = 0xc316,
        kSsangsiosAeKiyeoksios                         = 0xc317,
        kSsangsiosAeNieun                         = 0xc318,
        kSsangsiosAeNieuncieuc                         = 0xc319,
        kSsangsiosAeNieunhieuh                         = 0xc31a,
        kSsangsiosAeTikeut                         = 0xc31b,
        kSsangsiosAeRieul                         = 0xc31c,
        kSsangsiosAeRieulkiyeok                         = 0xc31d,
        kSsangsiosAeRieulmieum                         = 0xc31e,
        kSsangsiosAeRieulpieup                         = 0xc31f,
        kSsangsiosAeRieulsios                         = 0xc320,
        kSsangsiosAeRieulthieuth                         = 0xc321,
        kSsangsiosAeRieulphieuph                         = 0xc322,
        kSsangsiosAeRieulhieuh                         = 0xc323,
        kSsangsiosAeMieum                         = 0xc324,
        kSsangsiosAePieup                         = 0xc325,
        kSsangsiosAePieupsios                         = 0xc326,
        kSsangsiosAeSios                         = 0xc327,
        kSsangsiosAeSsangsios                         = 0xc328,
        kSsangsiosAeIeung                         = 0xc329,
        kSsangsiosAeCieuc                         = 0xc32a,
        kSsangsiosAeChieuch                         = 0xc32b,
        kSsangsiosAeKhieukh                         = 0xc32c,
        kSsangsiosAeThieuth                         = 0xc32d,
        kSsangsiosAePhieuph                         = 0xc32e,
        kSsangsiosAeHieuh                         = 0xc32f,
        kSsangsiosYa                           = 0xc330,
        kSsangsiosYaKiyeok                         = 0xc331,
        kSsangsiosYaSsangkiyeok                         = 0xc332,
        kSsangsiosYaKiyeoksios                         = 0xc333,
        kSsangsiosYaNieun                         = 0xc334,
        kSsangsiosYaNieuncieuc                         = 0xc335,
        kSsangsiosYaNieunhieuh                         = 0xc336,
        kSsangsiosYaTikeut                         = 0xc337,
        kSsangsiosYaRieul                         = 0xc338,
        kSsangsiosYaRieulkiyeok                         = 0xc339,
        kSsangsiosYaRieulmieum                         = 0xc33a,
        kSsangsiosYaRieulpieup                         = 0xc33b,
        kSsangsiosYaRieulsios                         = 0xc33c,
        kSsangsiosYaRieulthieuth                         = 0xc33d,
        kSsangsiosYaRieulphieuph                         = 0xc33e,
        kSsangsiosYaRieulhieuh                         = 0xc33f,
        kSsangsiosYaMieum                         = 0xc340,
        kSsangsiosYaPieup                         = 0xc341,
        kSsangsiosYaPieupsios                         = 0xc342,
        kSsangsiosYaSios                         = 0xc343,
        kSsangsiosYaSsangsios                         = 0xc344,
        kSsangsiosYaIeung                         = 0xc345,
        kSsangsiosYaCieuc                         = 0xc346,
        kSsangsiosYaChieuch                         = 0xc347,
        kSsangsiosYaKhieukh                         = 0xc348,
        kSsangsiosYaThieuth                         = 0xc349,
        kSsangsiosYaPhieuph                         = 0xc34a,
        kSsangsiosYaHieuh                         = 0xc34b,
        kSsangsiosYae                           = 0xc34c,
        kSsangsiosYaeKiyeok                         = 0xc34d,
        kSsangsiosYaeSsangkiyeok                         = 0xc34e,
        kSsangsiosYaeKiyeoksios                         = 0xc34f,
        kSsangsiosYaeNieun                         = 0xc350,
        kSsangsiosYaeNieuncieuc                         = 0xc351,
        kSsangsiosYaeNieunhieuh                         = 0xc352,
        kSsangsiosYaeTikeut                         = 0xc353,
        kSsangsiosYaeRieul                         = 0xc354,
        kSsangsiosYaeRieulkiyeok                         = 0xc355,
        kSsangsiosYaeRieulmieum                         = 0xc356,
        kSsangsiosYaeRieulpieup                         = 0xc357,
        kSsangsiosYaeRieulsios                         = 0xc358,
        kSsangsiosYaeRieulthieuth                         = 0xc359,
        kSsangsiosYaeRieulphieuph                         = 0xc35a,
        kSsangsiosYaeRieulhieuh                         = 0xc35b,
        kSsangsiosYaeMieum                         = 0xc35c,
        kSsangsiosYaePieup                         = 0xc35d,
        kSsangsiosYaePieupsios                         = 0xc35e,
        kSsangsiosYaeSios                         = 0xc35f,
        kSsangsiosYaeSsangsios                         = 0xc360,
        kSsangsiosYaeIeung                         = 0xc361,
        kSsangsiosYaeCieuc                         = 0xc362,
        kSsangsiosYaeChieuch                         = 0xc363,
        kSsangsiosYaeKhieukh                         = 0xc364,
        kSsangsiosYaeThieuth                         = 0xc365,
        kSsangsiosYaePhieuph                         = 0xc366,
        kSsangsiosYaeHieuh                         = 0xc367,
        kSsangsiosEo                           = 0xc368,
        kSsangsiosEoKiyeok                         = 0xc369,
        kSsangsiosEoSsangkiyeok                         = 0xc36a,
        kSsangsiosEoKiyeoksios                         = 0xc36b,
        kSsangsiosEoNieun                         = 0xc36c,
        kSsangsiosEoNieuncieuc                         = 0xc36d,
        kSsangsiosEoNieunhieuh                         = 0xc36e,
        kSsangsiosEoTikeut                         = 0xc36f,
        kSsangsiosEoRieul                         = 0xc370,
        kSsangsiosEoRieulkiyeok                         = 0xc371,
        kSsangsiosEoRieulmieum                         = 0xc372,
        kSsangsiosEoRieulpieup                         = 0xc373,
        kSsangsiosEoRieulsios                         = 0xc374,
        kSsangsiosEoRieulthieuth                         = 0xc375,
        kSsangsiosEoRieulphieuph                         = 0xc376,
        kSsangsiosEoRieulhieuh                         = 0xc377,
        kSsangsiosEoMieum                         = 0xc378,
        kSsangsiosEoPieup                         = 0xc379,
        kSsangsiosEoPieupsios                         = 0xc37a,
        kSsangsiosEoSios                         = 0xc37b,
        kSsangsiosEoSsangsios                         = 0xc37c,
        kSsangsiosEoIeung                         = 0xc37d,
        kSsangsiosEoCieuc                         = 0xc37e,
        kSsangsiosEoChieuch                         = 0xc37f,
        kSsangsiosEoKhieukh                         = 0xc380,
        kSsangsiosEoThieuth                         = 0xc381,
        kSsangsiosEoPhieuph                         = 0xc382,
        kSsangsiosEoHieuh                         = 0xc383,
        kSsangsiosE                           = 0xc384,
        kSsangsiosEKiyeok                         = 0xc385,
        kSsangsiosESsangkiyeok                         = 0xc386,
        kSsangsiosEKiyeoksios                         = 0xc387,
        kSsangsiosENieun                         = 0xc388,
        kSsangsiosENieuncieuc                         = 0xc389,
        kSsangsiosENieunhieuh                         = 0xc38a,
        kSsangsiosETikeut                         = 0xc38b,
        kSsangsiosERieul                         = 0xc38c,
        kSsangsiosERieulkiyeok                         = 0xc38d,
        kSsangsiosERieulmieum                         = 0xc38e,
        kSsangsiosERieulpieup                         = 0xc38f,
        kSsangsiosERieulsios                         = 0xc390,
        kSsangsiosERieulthieuth                         = 0xc391,
        kSsangsiosERieulphieuph                         = 0xc392,
        kSsangsiosERieulhieuh                         = 0xc393,
        kSsangsiosEMieum                         = 0xc394,
        kSsangsiosEPieup                         = 0xc395,
        kSsangsiosEPieupsios                         = 0xc396,
        kSsangsiosESios                         = 0xc397,
        kSsangsiosESsangsios                         = 0xc398,
        kSsangsiosEIeung                         = 0xc399,
        kSsangsiosECieuc                         = 0xc39a,
        kSsangsiosEChieuch                         = 0xc39b,
        kSsangsiosEKhieukh                         = 0xc39c,
        kSsangsiosEThieuth                         = 0xc39d,
        kSsangsiosEPhieuph                         = 0xc39e,
        kSsangsiosEHieuh                         = 0xc39f,
        kSsangsiosYeo                           = 0xc3a0,
        kSsangsiosYeoKiyeok                         = 0xc3a1,
        kSsangsiosYeoSsangkiyeok                         = 0xc3a2,
        kSsangsiosYeoKiyeoksios                         = 0xc3a3,
        kSsangsiosYeoNieun                         = 0xc3a4,
        kSsangsiosYeoNieuncieuc                         = 0xc3a5,
        kSsangsiosYeoNieunhieuh                         = 0xc3a6,
        kSsangsiosYeoTikeut                         = 0xc3a7,
        kSsangsiosYeoRieul                         = 0xc3a8,
        kSsangsiosYeoRieulkiyeok                         = 0xc3a9,
        kSsangsiosYeoRieulmieum                         = 0xc3aa,
        kSsangsiosYeoRieulpieup                         = 0xc3ab,
        kSsangsiosYeoRieulsios                         = 0xc3ac,
        kSsangsiosYeoRieulthieuth                         = 0xc3ad,
        kSsangsiosYeoRieulphieuph                         = 0xc3ae,
        kSsangsiosYeoRieulhieuh                         = 0xc3af,
        kSsangsiosYeoMieum                         = 0xc3b0,
        kSsangsiosYeoPieup                         = 0xc3b1,
        kSsangsiosYeoPieupsios                         = 0xc3b2,
        kSsangsiosYeoSios                         = 0xc3b3,
        kSsangsiosYeoSsangsios                         = 0xc3b4,
        kSsangsiosYeoIeung                         = 0xc3b5,
        kSsangsiosYeoCieuc                         = 0xc3b6,
        kSsangsiosYeoChieuch                         = 0xc3b7,
        kSsangsiosYeoKhieukh                         = 0xc3b8,
        kSsangsiosYeoThieuth                         = 0xc3b9,
        kSsangsiosYeoPhieuph                         = 0xc3ba,
        kSsangsiosYeoHieuh                         = 0xc3bb,
        kSsangsiosYe                           = 0xc3bc,
        kSsangsiosYeKiyeok                         = 0xc3bd,
        kSsangsiosYeSsangkiyeok                         = 0xc3be,
        kSsangsiosYeKiyeoksios                         = 0xc3bf,
        kSsangsiosYeNieun                         = 0xc3c0,
        kSsangsiosYeNieuncieuc                         = 0xc3c1,
        kSsangsiosYeNieunhieuh                         = 0xc3c2,
        kSsangsiosYeTikeut                         = 0xc3c3,
        kSsangsiosYeRieul                         = 0xc3c4,
        kSsangsiosYeRieulkiyeok                         = 0xc3c5,
        kSsangsiosYeRieulmieum                         = 0xc3c6,
        kSsangsiosYeRieulpieup                         = 0xc3c7,
        kSsangsiosYeRieulsios                         = 0xc3c8,
        kSsangsiosYeRieulthieuth                         = 0xc3c9,
        kSsangsiosYeRieulphieuph                         = 0xc3ca,
        kSsangsiosYeRieulhieuh                         = 0xc3cb,
        kSsangsiosYeMieum                         = 0xc3cc,
        kSsangsiosYePieup                         = 0xc3cd,
        kSsangsiosYePieupsios                         = 0xc3ce,
        kSsangsiosYeSios                         = 0xc3cf,
        kSsangsiosYeSsangsios                         = 0xc3d0,
        kSsangsiosYeIeung                         = 0xc3d1,
        kSsangsiosYeCieuc                         = 0xc3d2,
        kSsangsiosYeChieuch                         = 0xc3d3,
        kSsangsiosYeKhieukh                         = 0xc3d4,
        kSsangsiosYeThieuth                         = 0xc3d5,
        kSsangsiosYePhieuph                         = 0xc3d6,
        kSsangsiosYeHieuh                         = 0xc3d7,
        kSsangsiosO                           = 0xc3d8,
        kSsangsiosOKiyeok                         = 0xc3d9,
        kSsangsiosOSsangkiyeok                         = 0xc3da,
        kSsangsiosOKiyeoksios                         = 0xc3db,
        kSsangsiosONieun                         = 0xc3dc,
        kSsangsiosONieuncieuc                         = 0xc3dd,
        kSsangsiosONieunhieuh                         = 0xc3de,
        kSsangsiosOTikeut                         = 0xc3df,
        kSsangsiosORieul                         = 0xc3e0,
        kSsangsiosORieulkiyeok                         = 0xc3e1,
        kSsangsiosORieulmieum                         = 0xc3e2,
        kSsangsiosORieulpieup                         = 0xc3e3,
        kSsangsiosORieulsios                         = 0xc3e4,
        kSsangsiosORieulthieuth                         = 0xc3e5,
        kSsangsiosORieulphieuph                         = 0xc3e6,
        kSsangsiosORieulhieuh                         = 0xc3e7,
        kSsangsiosOMieum                         = 0xc3e8,
        kSsangsiosOPieup                         = 0xc3e9,
        kSsangsiosOPieupsios                         = 0xc3ea,
        kSsangsiosOSios                         = 0xc3eb,
        kSsangsiosOSsangsios                         = 0xc3ec,
        kSsangsiosOIeung                         = 0xc3ed,
        kSsangsiosOCieuc                         = 0xc3ee,
        kSsangsiosOChieuch                         = 0xc3ef,
        kSsangsiosOKhieukh                         = 0xc3f0,
        kSsangsiosOThieuth                         = 0xc3f1,
        kSsangsiosOPhieuph                         = 0xc3f2,
        kSsangsiosOHieuh                         = 0xc3f3,
        kSsangsiosWa                           = 0xc3f4,
        kSsangsiosWaKiyeok                         = 0xc3f5,
        kSsangsiosWaSsangkiyeok                         = 0xc3f6,
        kSsangsiosWaKiyeoksios                         = 0xc3f7,
        kSsangsiosWaNieun                         = 0xc3f8,
        kSsangsiosWaNieuncieuc                         = 0xc3f9,
        kSsangsiosWaNieunhieuh                         = 0xc3fa,
        kSsangsiosWaTikeut                         = 0xc3fb,
        kSsangsiosWaRieul                         = 0xc3fc,
        kSsangsiosWaRieulkiyeok                         = 0xc3fd,
        kSsangsiosWaRieulmieum                         = 0xc3fe,
        kSsangsiosWaRieulpieup                         = 0xc3ff,
        kSsangsiosWaRieulsios                         = 0xc400,
        kSsangsiosWaRieulthieuth                         = 0xc401,
        kSsangsiosWaRieulphieuph                         = 0xc402,
        kSsangsiosWaRieulhieuh                         = 0xc403,
        kSsangsiosWaMieum                         = 0xc404,
        kSsangsiosWaPieup                         = 0xc405,
        kSsangsiosWaPieupsios                         = 0xc406,
        kSsangsiosWaSios                         = 0xc407,
        kSsangsiosWaSsangsios                         = 0xc408,
        kSsangsiosWaIeung                         = 0xc409,
        kSsangsiosWaCieuc                         = 0xc40a,
        kSsangsiosWaChieuch                         = 0xc40b,
        kSsangsiosWaKhieukh                         = 0xc40c,
        kSsangsiosWaThieuth                         = 0xc40d,
        kSsangsiosWaPhieuph                         = 0xc40e,
        kSsangsiosWaHieuh                         = 0xc40f,
        kSsangsiosWae                           = 0xc410,
        kSsangsiosWaeKiyeok                         = 0xc411,
        kSsangsiosWaeSsangkiyeok                         = 0xc412,
        kSsangsiosWaeKiyeoksios                         = 0xc413,
        kSsangsiosWaeNieun                         = 0xc414,
        kSsangsiosWaeNieuncieuc                         = 0xc415,
        kSsangsiosWaeNieunhieuh                         = 0xc416,
        kSsangsiosWaeTikeut                         = 0xc417,
        kSsangsiosWaeRieul                         = 0xc418,
        kSsangsiosWaeRieulkiyeok                         = 0xc419,
        kSsangsiosWaeRieulmieum                         = 0xc41a,
        kSsangsiosWaeRieulpieup                         = 0xc41b,
        kSsangsiosWaeRieulsios                         = 0xc41c,
        kSsangsiosWaeRieulthieuth                         = 0xc41d,
        kSsangsiosWaeRieulphieuph                         = 0xc41e,
        kSsangsiosWaeRieulhieuh                         = 0xc41f,
        kSsangsiosWaeMieum                         = 0xc420,
        kSsangsiosWaePieup                         = 0xc421,
        kSsangsiosWaePieupsios                         = 0xc422,
        kSsangsiosWaeSios                         = 0xc423,
        kSsangsiosWaeSsangsios                         = 0xc424,
        kSsangsiosWaeIeung                         = 0xc425,
        kSsangsiosWaeCieuc                         = 0xc426,
        kSsangsiosWaeChieuch                         = 0xc427,
        kSsangsiosWaeKhieukh                         = 0xc428,
        kSsangsiosWaeThieuth                         = 0xc429,
        kSsangsiosWaePhieuph                         = 0xc42a,
        kSsangsiosWaeHieuh                         = 0xc42b,
        kSsangsiosOe                           = 0xc42c,
        kSsangsiosOeKiyeok                         = 0xc42d,
        kSsangsiosOeSsangkiyeok                         = 0xc42e,
        kSsangsiosOeKiyeoksios                         = 0xc42f,
        kSsangsiosOeNieun                         = 0xc430,
        kSsangsiosOeNieuncieuc                         = 0xc431,
        kSsangsiosOeNieunhieuh                         = 0xc432,
        kSsangsiosOeTikeut                         = 0xc433,
        kSsangsiosOeRieul                         = 0xc434,
        kSsangsiosOeRieulkiyeok                         = 0xc435,
        kSsangsiosOeRieulmieum                         = 0xc436,
        kSsangsiosOeRieulpieup                         = 0xc437,
        kSsangsiosOeRieulsios                         = 0xc438,
        kSsangsiosOeRieulthieuth                         = 0xc439,
        kSsangsiosOeRieulphieuph                         = 0xc43a,
        kSsangsiosOeRieulhieuh                         = 0xc43b,
        kSsangsiosOeMieum                         = 0xc43c,
        kSsangsiosOePieup                         = 0xc43d,
        kSsangsiosOePieupsios                         = 0xc43e,
        kSsangsiosOeSios                         = 0xc43f,
        kSsangsiosOeSsangsios                         = 0xc440,
        kSsangsiosOeIeung                         = 0xc441,
        kSsangsiosOeCieuc                         = 0xc442,
        kSsangsiosOeChieuch                         = 0xc443,
        kSsangsiosOeKhieukh                         = 0xc444,
        kSsangsiosOeThieuth                         = 0xc445,
        kSsangsiosOePhieuph                         = 0xc446,
        kSsangsiosOeHieuh                         = 0xc447,
        kSsangsiosYo                           = 0xc448,
        kSsangsiosYoKiyeok                         = 0xc449,
        kSsangsiosYoSsangkiyeok                         = 0xc44a,
        kSsangsiosYoKiyeoksios                         = 0xc44b,
        kSsangsiosYoNieun                         = 0xc44c,
        kSsangsiosYoNieuncieuc                         = 0xc44d,
        kSsangsiosYoNieunhieuh                         = 0xc44e,
        kSsangsiosYoTikeut                         = 0xc44f,
        kSsangsiosYoRieul                         = 0xc450,
        kSsangsiosYoRieulkiyeok                         = 0xc451,
        kSsangsiosYoRieulmieum                         = 0xc452,
        kSsangsiosYoRieulpieup                         = 0xc453,
        kSsangsiosYoRieulsios                         = 0xc454,
        kSsangsiosYoRieulthieuth                         = 0xc455,
        kSsangsiosYoRieulphieuph                         = 0xc456,
        kSsangsiosYoRieulhieuh                         = 0xc457,
        kSsangsiosYoMieum                         = 0xc458,
        kSsangsiosYoPieup                         = 0xc459,
        kSsangsiosYoPieupsios                         = 0xc45a,
        kSsangsiosYoSios                         = 0xc45b,
        kSsangsiosYoSsangsios                         = 0xc45c,
        kSsangsiosYoIeung                         = 0xc45d,
        kSsangsiosYoCieuc                         = 0xc45e,
        kSsangsiosYoChieuch                         = 0xc45f,
        kSsangsiosYoKhieukh                         = 0xc460,
        kSsangsiosYoThieuth                         = 0xc461,
        kSsangsiosYoPhieuph                         = 0xc462,
        kSsangsiosYoHieuh                         = 0xc463,
        kSsangsiosU                           = 0xc464,
        kSsangsiosUKiyeok                         = 0xc465,
        kSsangsiosUSsangkiyeok                         = 0xc466,
        kSsangsiosUKiyeoksios                         = 0xc467,
        kSsangsiosUNieun                         = 0xc468,
        kSsangsiosUNieuncieuc                         = 0xc469,
        kSsangsiosUNieunhieuh                         = 0xc46a,
        kSsangsiosUTikeut                         = 0xc46b,
        kSsangsiosURieul                         = 0xc46c,
        kSsangsiosURieulkiyeok                         = 0xc46d,
        kSsangsiosURieulmieum                         = 0xc46e,
        kSsangsiosURieulpieup                         = 0xc46f,
        kSsangsiosURieulsios                         = 0xc470,
        kSsangsiosURieulthieuth                         = 0xc471,
        kSsangsiosURieulphieuph                         = 0xc472,
        kSsangsiosURieulhieuh                         = 0xc473,
        kSsangsiosUMieum                         = 0xc474,
        kSsangsiosUPieup                         = 0xc475,
        kSsangsiosUPieupsios                         = 0xc476,
        kSsangsiosUSios                         = 0xc477,
        kSsangsiosUSsangsios                         = 0xc478,
        kSsangsiosUIeung                         = 0xc479,
        kSsangsiosUCieuc                         = 0xc47a,
        kSsangsiosUChieuch                         = 0xc47b,
        kSsangsiosUKhieukh                         = 0xc47c,
        kSsangsiosUThieuth                         = 0xc47d,
        kSsangsiosUPhieuph                         = 0xc47e,
        kSsangsiosUHieuh                         = 0xc47f,
        kSsangsiosWeo                           = 0xc480,
        kSsangsiosWeoKiyeok                         = 0xc481,
        kSsangsiosWeoSsangkiyeok                         = 0xc482,
        kSsangsiosWeoKiyeoksios                         = 0xc483,
        kSsangsiosWeoNieun                         = 0xc484,
        kSsangsiosWeoNieuncieuc                         = 0xc485,
        kSsangsiosWeoNieunhieuh                         = 0xc486,
        kSsangsiosWeoTikeut                         = 0xc487,
        kSsangsiosWeoRieul                         = 0xc488,
        kSsangsiosWeoRieulkiyeok                         = 0xc489,
        kSsangsiosWeoRieulmieum                         = 0xc48a,
        kSsangsiosWeoRieulpieup                         = 0xc48b,
        kSsangsiosWeoRieulsios                         = 0xc48c,
        kSsangsiosWeoRieulthieuth                         = 0xc48d,
        kSsangsiosWeoRieulphieuph                         = 0xc48e,
        kSsangsiosWeoRieulhieuh                         = 0xc48f,
        kSsangsiosWeoMieum                         = 0xc490,
        kSsangsiosWeoPieup                         = 0xc491,
        kSsangsiosWeoPieupsios                         = 0xc492,
        kSsangsiosWeoSios                         = 0xc493,
        kSsangsiosWeoSsangsios                         = 0xc494,
        kSsangsiosWeoIeung                         = 0xc495,
        kSsangsiosWeoCieuc                         = 0xc496,
        kSsangsiosWeoChieuch                         = 0xc497,
        kSsangsiosWeoKhieukh                         = 0xc498,
        kSsangsiosWeoThieuth                         = 0xc499,
        kSsangsiosWeoPhieuph                         = 0xc49a,
        kSsangsiosWeoHieuh                         = 0xc49b,
        kSsangsiosWe                           = 0xc49c,
        kSsangsiosWeKiyeok                         = 0xc49d,
        kSsangsiosWeSsangkiyeok                         = 0xc49e,
        kSsangsiosWeKiyeoksios                         = 0xc49f,
        kSsangsiosWeNieun                         = 0xc4a0,
        kSsangsiosWeNieuncieuc                         = 0xc4a1,
        kSsangsiosWeNieunhieuh                         = 0xc4a2,
        kSsangsiosWeTikeut                         = 0xc4a3,
        kSsangsiosWeRieul                         = 0xc4a4,
        kSsangsiosWeRieulkiyeok                         = 0xc4a5,
        kSsangsiosWeRieulmieum                         = 0xc4a6,
        kSsangsiosWeRieulpieup                         = 0xc4a7,
        kSsangsiosWeRieulsios                         = 0xc4a8,
        kSsangsiosWeRieulthieuth                         = 0xc4a9,
        kSsangsiosWeRieulphieuph                         = 0xc4aa,
        kSsangsiosWeRieulhieuh                         = 0xc4ab,
        kSsangsiosWeMieum                         = 0xc4ac,
        kSsangsiosWePieup                         = 0xc4ad,
        kSsangsiosWePieupsios                         = 0xc4ae,
        kSsangsiosWeSios                         = 0xc4af,
        kSsangsiosWeSsangsios                         = 0xc4b0,
        kSsangsiosWeIeung                         = 0xc4b1,
        kSsangsiosWeCieuc                         = 0xc4b2,
        kSsangsiosWeChieuch                         = 0xc4b3,
        kSsangsiosWeKhieukh                         = 0xc4b4,
        kSsangsiosWeThieuth                         = 0xc4b5,
        kSsangsiosWePhieuph                         = 0xc4b6,
        kSsangsiosWeHieuh                         = 0xc4b7,
        kSsangsiosWi                           = 0xc4b8,
        kSsangsiosWiKiyeok                         = 0xc4b9,
        kSsangsiosWiSsangkiyeok                         = 0xc4ba,
        kSsangsiosWiKiyeoksios                         = 0xc4bb,
        kSsangsiosWiNieun                         = 0xc4bc,
        kSsangsiosWiNieuncieuc                         = 0xc4bd,
        kSsangsiosWiNieunhieuh                         = 0xc4be,
        kSsangsiosWiTikeut                         = 0xc4bf,
        kSsangsiosWiRieul                         = 0xc4c0,
        kSsangsiosWiRieulkiyeok                         = 0xc4c1,
        kSsangsiosWiRieulmieum                         = 0xc4c2,
        kSsangsiosWiRieulpieup                         = 0xc4c3,
        kSsangsiosWiRieulsios                         = 0xc4c4,
        kSsangsiosWiRieulthieuth                         = 0xc4c5,
        kSsangsiosWiRieulphieuph                         = 0xc4c6,
        kSsangsiosWiRieulhieuh                         = 0xc4c7,
        kSsangsiosWiMieum                         = 0xc4c8,
        kSsangsiosWiPieup                         = 0xc4c9,
        kSsangsiosWiPieupsios                         = 0xc4ca,
        kSsangsiosWiSios                         = 0xc4cb,
        kSsangsiosWiSsangsios                         = 0xc4cc,
        kSsangsiosWiIeung                         = 0xc4cd,
        kSsangsiosWiCieuc                         = 0xc4ce,
        kSsangsiosWiChieuch                         = 0xc4cf,
        kSsangsiosWiKhieukh                         = 0xc4d0,
        kSsangsiosWiThieuth                         = 0xc4d1,
        kSsangsiosWiPhieuph                         = 0xc4d2,
        kSsangsiosWiHieuh                         = 0xc4d3,
        kSsangsiosYu                           = 0xc4d4,
        kSsangsiosYuKiyeok                         = 0xc4d5,
        kSsangsiosYuSsangkiyeok                         = 0xc4d6,
        kSsangsiosYuKiyeoksios                         = 0xc4d7,
        kSsangsiosYuNieun                         = 0xc4d8,
        kSsangsiosYuNieuncieuc                         = 0xc4d9,
        kSsangsiosYuNieunhieuh                         = 0xc4da,
        kSsangsiosYuTikeut                         = 0xc4db,
        kSsangsiosYuRieul                         = 0xc4dc,
        kSsangsiosYuRieulkiyeok                         = 0xc4dd,
        kSsangsiosYuRieulmieum                         = 0xc4de,
        kSsangsiosYuRieulpieup                         = 0xc4df,
        kSsangsiosYuRieulsios                         = 0xc4e0,
        kSsangsiosYuRieulthieuth                         = 0xc4e1,
        kSsangsiosYuRieulphieuph                         = 0xc4e2,
        kSsangsiosYuRieulhieuh                         = 0xc4e3,
        kSsangsiosYuMieum                         = 0xc4e4,
        kSsangsiosYuPieup                         = 0xc4e5,
        kSsangsiosYuPieupsios                         = 0xc4e6,
        kSsangsiosYuSios                         = 0xc4e7,
        kSsangsiosYuSsangsios                         = 0xc4e8,
        kSsangsiosYuIeung                         = 0xc4e9,
        kSsangsiosYuCieuc                         = 0xc4ea,
        kSsangsiosYuChieuch                         = 0xc4eb,
        kSsangsiosYuKhieukh                         = 0xc4ec,
        kSsangsiosYuThieuth                         = 0xc4ed,
        kSsangsiosYuPhieuph                         = 0xc4ee,
        kSsangsiosYuHieuh                         = 0xc4ef,
        kSsangsiosEu                           = 0xc4f0,
        kSsangsiosEuKiyeok                         = 0xc4f1,
        kSsangsiosEuSsangkiyeok                         = 0xc4f2,
        kSsangsiosEuKiyeoksios                         = 0xc4f3,
        kSsangsiosEuNieun                         = 0xc4f4,
        kSsangsiosEuNieuncieuc                         = 0xc4f5,
        kSsangsiosEuNieunhieuh                         = 0xc4f6,
        kSsangsiosEuTikeut                         = 0xc4f7,
        kSsangsiosEuRieul                         = 0xc4f8,
        kSsangsiosEuRieulkiyeok                         = 0xc4f9,
        kSsangsiosEuRieulmieum                         = 0xc4fa,
        kSsangsiosEuRieulpieup                         = 0xc4fb,
        kSsangsiosEuRieulsios                         = 0xc4fc,
        kSsangsiosEuRieulthieuth                         = 0xc4fd,
        kSsangsiosEuRieulphieuph                         = 0xc4fe,
        kSsangsiosEuRieulhieuh                         = 0xc4ff,
        kSsangsiosEuMieum                         = 0xc500,
        kSsangsiosEuPieup                         = 0xc501,
        kSsangsiosEuPieupsios                         = 0xc502,
        kSsangsiosEuSios                         = 0xc503,
        kSsangsiosEuSsangsios                         = 0xc504,
        kSsangsiosEuIeung                         = 0xc505,
        kSsangsiosEuCieuc                         = 0xc506,
        kSsangsiosEuChieuch                         = 0xc507,
        kSsangsiosEuKhieukh                         = 0xc508,
        kSsangsiosEuThieuth                         = 0xc509,
        kSsangsiosEuPhieuph                         = 0xc50a,
        kSsangsiosEuHieuh                         = 0xc50b,
        kSsangsiosYi                           = 0xc50c,
        kSsangsiosYiKiyeok                         = 0xc50d,
        kSsangsiosYiSsangkiyeok                         = 0xc50e,
        kSsangsiosYiKiyeoksios                         = 0xc50f,
        kSsangsiosYiNieun                         = 0xc510,
        kSsangsiosYiNieuncieuc                         = 0xc511,
        kSsangsiosYiNieunhieuh                         = 0xc512,
        kSsangsiosYiTikeut                         = 0xc513,
        kSsangsiosYiRieul                         = 0xc514,
        kSsangsiosYiRieulkiyeok                         = 0xc515,
        kSsangsiosYiRieulmieum                         = 0xc516,
        kSsangsiosYiRieulpieup                         = 0xc517,
        kSsangsiosYiRieulsios                         = 0xc518,
        kSsangsiosYiRieulthieuth                         = 0xc519,
        kSsangsiosYiRieulphieuph                         = 0xc51a,
        kSsangsiosYiRieulhieuh                         = 0xc51b,
        kSsangsiosYiMieum                         = 0xc51c,
        kSsangsiosYiPieup                         = 0xc51d,
        kSsangsiosYiPieupsios                         = 0xc51e,
        kSsangsiosYiSios                         = 0xc51f,
        kSsangsiosYiSsangsios                         = 0xc520,
        kSsangsiosYiIeung                         = 0xc521,
        kSsangsiosYiCieuc                         = 0xc522,
        kSsangsiosYiChieuch                         = 0xc523,
        kSsangsiosYiKhieukh                         = 0xc524,
        kSsangsiosYiThieuth                         = 0xc525,
        kSsangsiosYiPhieuph                         = 0xc526,
        kSsangsiosYiHieuh                         = 0xc527,
        kSsangsiosI                           = 0xc528,
        kSsangsiosIKiyeok                         = 0xc529,
        kSsangsiosISsangkiyeok                         = 0xc52a,
        kSsangsiosIKiyeoksios                         = 0xc52b,
        kSsangsiosINieun                         = 0xc52c,
        kSsangsiosINieuncieuc                         = 0xc52d,
        kSsangsiosINieunhieuh                         = 0xc52e,
        kSsangsiosITikeut                         = 0xc52f,
        kSsangsiosIRieul                         = 0xc530,
        kSsangsiosIRieulkiyeok                         = 0xc531,
        kSsangsiosIRieulmieum                         = 0xc532,
        kSsangsiosIRieulpieup                         = 0xc533,
        kSsangsiosIRieulsios                         = 0xc534,
        kSsangsiosIRieulthieuth                         = 0xc535,
        kSsangsiosIRieulphieuph                         = 0xc536,
        kSsangsiosIRieulhieuh                         = 0xc537,
        kSsangsiosIMieum                         = 0xc538,
        kSsangsiosIPieup                         = 0xc539,
        kSsangsiosIPieupsios                         = 0xc53a,
        kSsangsiosISios                         = 0xc53b,
        kSsangsiosISsangsios                         = 0xc53c,
        kSsangsiosIIeung                         = 0xc53d,
        kSsangsiosICieuc                         = 0xc53e,
        kSsangsiosIChieuch                         = 0xc53f,
        kSsangsiosIKhieukh                         = 0xc540,
        kSsangsiosIThieuth                         = 0xc541,
        kSsangsiosIPhieuph                         = 0xc542,
        kSsangsiosIHieuh                         = 0xc543,
        kIeungA                           = 0xc544,
        kIeungAKiyeok                         = 0xc545,
        kIeungASsangkiyeok                         = 0xc546,
        kIeungAKiyeoksios                         = 0xc547,
        kIeungANieun                         = 0xc548,
        kIeungANieuncieuc                         = 0xc549,
        kIeungANieunhieuh                         = 0xc54a,
        kIeungATikeut                         = 0xc54b,
        kIeungARieul                         = 0xc54c,
        kIeungARieulkiyeok                         = 0xc54d,
        kIeungARieulmieum                         = 0xc54e,
        kIeungARieulpieup                         = 0xc54f,
        kIeungARieulsios                         = 0xc550,
        kIeungARieulthieuth                         = 0xc551,
        kIeungARieulphieuph                         = 0xc552,
        kIeungARieulhieuh                         = 0xc553,
        kIeungAMieum                         = 0xc554,
        kIeungAPieup                         = 0xc555,
        kIeungAPieupsios                         = 0xc556,
        kIeungASios                         = 0xc557,
        kIeungASsangsios                         = 0xc558,
        kIeungAIeung                         = 0xc559,
        kIeungACieuc                         = 0xc55a,
        kIeungAChieuch                         = 0xc55b,
        kIeungAKhieukh                         = 0xc55c,
        kIeungAThieuth                         = 0xc55d,
        kIeungAPhieuph                         = 0xc55e,
        kIeungAHieuh                         = 0xc55f,
        kIeungAe                           = 0xc560,
        kIeungAeKiyeok                         = 0xc561,
        kIeungAeSsangkiyeok                         = 0xc562,
        kIeungAeKiyeoksios                         = 0xc563,
        kIeungAeNieun                         = 0xc564,
        kIeungAeNieuncieuc                         = 0xc565,
        kIeungAeNieunhieuh                         = 0xc566,
        kIeungAeTikeut                         = 0xc567,
        kIeungAeRieul                         = 0xc568,
        kIeungAeRieulkiyeok                         = 0xc569,
        kIeungAeRieulmieum                         = 0xc56a,
        kIeungAeRieulpieup                         = 0xc56b,
        kIeungAeRieulsios                         = 0xc56c,
        kIeungAeRieulthieuth                         = 0xc56d,
        kIeungAeRieulphieuph                         = 0xc56e,
        kIeungAeRieulhieuh                         = 0xc56f,
        kIeungAeMieum                         = 0xc570,
        kIeungAePieup                         = 0xc571,
        kIeungAePieupsios                         = 0xc572,
        kIeungAeSios                         = 0xc573,
        kIeungAeSsangsios                         = 0xc574,
        kIeungAeIeung                         = 0xc575,
        kIeungAeCieuc                         = 0xc576,
        kIeungAeChieuch                         = 0xc577,
        kIeungAeKhieukh                         = 0xc578,
        kIeungAeThieuth                         = 0xc579,
        kIeungAePhieuph                         = 0xc57a,
        kIeungAeHieuh                         = 0xc57b,
        kIeungYa                           = 0xc57c,
        kIeungYaKiyeok                         = 0xc57d,
        kIeungYaSsangkiyeok                         = 0xc57e,
        kIeungYaKiyeoksios                         = 0xc57f,
        kIeungYaNieun                         = 0xc580,
        kIeungYaNieuncieuc                         = 0xc581,
        kIeungYaNieunhieuh                         = 0xc582,
        kIeungYaTikeut                         = 0xc583,
        kIeungYaRieul                         = 0xc584,
        kIeungYaRieulkiyeok                         = 0xc585,
        kIeungYaRieulmieum                         = 0xc586,
        kIeungYaRieulpieup                         = 0xc587,
        kIeungYaRieulsios                         = 0xc588,
        kIeungYaRieulthieuth                         = 0xc589,
        kIeungYaRieulphieuph                         = 0xc58a,
        kIeungYaRieulhieuh                         = 0xc58b,
        kIeungYaMieum                         = 0xc58c,
        kIeungYaPieup                         = 0xc58d,
        kIeungYaPieupsios                         = 0xc58e,
        kIeungYaSios                         = 0xc58f,
        kIeungYaSsangsios                         = 0xc590,
        kIeungYaIeung                         = 0xc591,
        kIeungYaCieuc                         = 0xc592,
        kIeungYaChieuch                         = 0xc593,
        kIeungYaKhieukh                         = 0xc594,
        kIeungYaThieuth                         = 0xc595,
        kIeungYaPhieuph                         = 0xc596,
        kIeungYaHieuh                         = 0xc597,
        kIeungYae                           = 0xc598,
        kIeungYaeKiyeok                         = 0xc599,
        kIeungYaeSsangkiyeok                         = 0xc59a,
        kIeungYaeKiyeoksios                         = 0xc59b,
        kIeungYaeNieun                         = 0xc59c,
        kIeungYaeNieuncieuc                         = 0xc59d,
        kIeungYaeNieunhieuh                         = 0xc59e,
        kIeungYaeTikeut                         = 0xc59f,
        kIeungYaeRieul                         = 0xc5a0,
        kIeungYaeRieulkiyeok                         = 0xc5a1,
        kIeungYaeRieulmieum                         = 0xc5a2,
        kIeungYaeRieulpieup                         = 0xc5a3,
        kIeungYaeRieulsios                         = 0xc5a4,
        kIeungYaeRieulthieuth                         = 0xc5a5,
        kIeungYaeRieulphieuph                         = 0xc5a6,
        kIeungYaeRieulhieuh                         = 0xc5a7,
        kIeungYaeMieum                         = 0xc5a8,
        kIeungYaePieup                         = 0xc5a9,
        kIeungYaePieupsios                         = 0xc5aa,
        kIeungYaeSios                         = 0xc5ab,
        kIeungYaeSsangsios                         = 0xc5ac,
        kIeungYaeIeung                         = 0xc5ad,
        kIeungYaeCieuc                         = 0xc5ae,
        kIeungYaeChieuch                         = 0xc5af,
        kIeungYaeKhieukh                         = 0xc5b0,
        kIeungYaeThieuth                         = 0xc5b1,
        kIeungYaePhieuph                         = 0xc5b2,
        kIeungYaeHieuh                         = 0xc5b3,
        kIeungEo                           = 0xc5b4,
        kIeungEoKiyeok                         = 0xc5b5,
        kIeungEoSsangkiyeok                         = 0xc5b6,
        kIeungEoKiyeoksios                         = 0xc5b7,
        kIeungEoNieun                         = 0xc5b8,
        kIeungEoNieuncieuc                         = 0xc5b9,
        kIeungEoNieunhieuh                         = 0xc5ba,
        kIeungEoTikeut                         = 0xc5bb,
        kIeungEoRieul                         = 0xc5bc,
        kIeungEoRieulkiyeok                         = 0xc5bd,
        kIeungEoRieulmieum                         = 0xc5be,
        kIeungEoRieulpieup                         = 0xc5bf,
        kIeungEoRieulsios                         = 0xc5c0,
        kIeungEoRieulthieuth                         = 0xc5c1,
        kIeungEoRieulphieuph                         = 0xc5c2,
        kIeungEoRieulhieuh                         = 0xc5c3,
        kIeungEoMieum                         = 0xc5c4,
        kIeungEoPieup                         = 0xc5c5,
        kIeungEoPieupsios                         = 0xc5c6,
        kIeungEoSios                         = 0xc5c7,
        kIeungEoSsangsios                         = 0xc5c8,
        kIeungEoIeung                         = 0xc5c9,
        kIeungEoCieuc                         = 0xc5ca,
        kIeungEoChieuch                         = 0xc5cb,
        kIeungEoKhieukh                         = 0xc5cc,
        kIeungEoThieuth                         = 0xc5cd,
        kIeungEoPhieuph                         = 0xc5ce,
        kIeungEoHieuh                         = 0xc5cf,
        kIeungE                           = 0xc5d0,
        kIeungEKiyeok                         = 0xc5d1,
        kIeungESsangkiyeok                         = 0xc5d2,
        kIeungEKiyeoksios                         = 0xc5d3,
        kIeungENieun                         = 0xc5d4,
        kIeungENieuncieuc                         = 0xc5d5,
        kIeungENieunhieuh                         = 0xc5d6,
        kIeungETikeut                         = 0xc5d7,
        kIeungERieul                         = 0xc5d8,
        kIeungERieulkiyeok                         = 0xc5d9,
        kIeungERieulmieum                         = 0xc5da,
        kIeungERieulpieup                         = 0xc5db,
        kIeungERieulsios                         = 0xc5dc,
        kIeungERieulthieuth                         = 0xc5dd,
        kIeungERieulphieuph                         = 0xc5de,
        kIeungERieulhieuh                         = 0xc5df,
        kIeungEMieum                         = 0xc5e0,
        kIeungEPieup                         = 0xc5e1,
        kIeungEPieupsios                         = 0xc5e2,
        kIeungESios                         = 0xc5e3,
        kIeungESsangsios                         = 0xc5e4,
        kIeungEIeung                         = 0xc5e5,
        kIeungECieuc                         = 0xc5e6,
        kIeungEChieuch                         = 0xc5e7,
        kIeungEKhieukh                         = 0xc5e8,
        kIeungEThieuth                         = 0xc5e9,
        kIeungEPhieuph                         = 0xc5ea,
        kIeungEHieuh                         = 0xc5eb,
        kIeungYeo                           = 0xc5ec,
        kIeungYeoKiyeok                         = 0xc5ed,
        kIeungYeoSsangkiyeok                         = 0xc5ee,
        kIeungYeoKiyeoksios                         = 0xc5ef,
        kIeungYeoNieun                         = 0xc5f0,
        kIeungYeoNieuncieuc                         = 0xc5f1,
        kIeungYeoNieunhieuh                         = 0xc5f2,
        kIeungYeoTikeut                         = 0xc5f3,
        kIeungYeoRieul                         = 0xc5f4,
        kIeungYeoRieulkiyeok                         = 0xc5f5,
        kIeungYeoRieulmieum                         = 0xc5f6,
        kIeungYeoRieulpieup                         = 0xc5f7,
        kIeungYeoRieulsios                         = 0xc5f8,
        kIeungYeoRieulthieuth                         = 0xc5f9,
        kIeungYeoRieulphieuph                         = 0xc5fa,
        kIeungYeoRieulhieuh                         = 0xc5fb,
        kIeungYeoMieum                         = 0xc5fc,
        kIeungYeoPieup                         = 0xc5fd,
        kIeungYeoPieupsios                         = 0xc5fe,
        kIeungYeoSios                         = 0xc5ff,
        kIeungYeoSsangsios                         = 0xc600,
        kIeungYeoIeung                         = 0xc601,
        kIeungYeoCieuc                         = 0xc602,
        kIeungYeoChieuch                         = 0xc603,
        kIeungYeoKhieukh                         = 0xc604,
        kIeungYeoThieuth                         = 0xc605,
        kIeungYeoPhieuph                         = 0xc606,
        kIeungYeoHieuh                         = 0xc607,
        kIeungYe                           = 0xc608,
        kIeungYeKiyeok                         = 0xc609,
        kIeungYeSsangkiyeok                         = 0xc60a,
        kIeungYeKiyeoksios                         = 0xc60b,
        kIeungYeNieun                         = 0xc60c,
        kIeungYeNieuncieuc                         = 0xc60d,
        kIeungYeNieunhieuh                         = 0xc60e,
        kIeungYeTikeut                         = 0xc60f,
        kIeungYeRieul                         = 0xc610,
        kIeungYeRieulkiyeok                         = 0xc611,
        kIeungYeRieulmieum                         = 0xc612,
        kIeungYeRieulpieup                         = 0xc613,
        kIeungYeRieulsios                         = 0xc614,
        kIeungYeRieulthieuth                         = 0xc615,
        kIeungYeRieulphieuph                         = 0xc616,
        kIeungYeRieulhieuh                         = 0xc617,
        kIeungYeMieum                         = 0xc618,
        kIeungYePieup                         = 0xc619,
        kIeungYePieupsios                         = 0xc61a,
        kIeungYeSios                         = 0xc61b,
        kIeungYeSsangsios                         = 0xc61c,
        kIeungYeIeung                         = 0xc61d,
        kIeungYeCieuc                         = 0xc61e,
        kIeungYeChieuch                         = 0xc61f,
        kIeungYeKhieukh                         = 0xc620,
        kIeungYeThieuth                         = 0xc621,
        kIeungYePhieuph                         = 0xc622,
        kIeungYeHieuh                         = 0xc623,
        kIeungO                           = 0xc624,
        kIeungOKiyeok                         = 0xc625,
        kIeungOSsangkiyeok                         = 0xc626,
        kIeungOKiyeoksios                         = 0xc627,
        kIeungONieun                         = 0xc628,
        kIeungONieuncieuc                         = 0xc629,
        kIeungONieunhieuh                         = 0xc62a,
        kIeungOTikeut                         = 0xc62b,
        kIeungORieul                         = 0xc62c,
        kIeungORieulkiyeok                         = 0xc62d,
        kIeungORieulmieum                         = 0xc62e,
        kIeungORieulpieup                         = 0xc62f,
        kIeungORieulsios                         = 0xc630,
        kIeungORieulthieuth                         = 0xc631,
        kIeungORieulphieuph                         = 0xc632,
        kIeungORieulhieuh                         = 0xc633,
        kIeungOMieum                         = 0xc634,
        kIeungOPieup                         = 0xc635,
        kIeungOPieupsios                         = 0xc636,
        kIeungOSios                         = 0xc637,
        kIeungOSsangsios                         = 0xc638,
        kIeungOIeung                         = 0xc639,
        kIeungOCieuc                         = 0xc63a,
        kIeungOChieuch                         = 0xc63b,
        kIeungOKhieukh                         = 0xc63c,
        kIeungOThieuth                         = 0xc63d,
        kIeungOPhieuph                         = 0xc63e,
        kIeungOHieuh                         = 0xc63f,
        kIeungWa                           = 0xc640,
        kIeungWaKiyeok                         = 0xc641,
        kIeungWaSsangkiyeok                         = 0xc642,
        kIeungWaKiyeoksios                         = 0xc643,
        kIeungWaNieun                         = 0xc644,
        kIeungWaNieuncieuc                         = 0xc645,
        kIeungWaNieunhieuh                         = 0xc646,
        kIeungWaTikeut                         = 0xc647,
        kIeungWaRieul                         = 0xc648,
        kIeungWaRieulkiyeok                         = 0xc649,
        kIeungWaRieulmieum                         = 0xc64a,
        kIeungWaRieulpieup                         = 0xc64b,
        kIeungWaRieulsios                         = 0xc64c,
        kIeungWaRieulthieuth                         = 0xc64d,
        kIeungWaRieulphieuph                         = 0xc64e,
        kIeungWaRieulhieuh                         = 0xc64f,
        kIeungWaMieum                         = 0xc650,
        kIeungWaPieup                         = 0xc651,
        kIeungWaPieupsios                         = 0xc652,
        kIeungWaSios                         = 0xc653,
        kIeungWaSsangsios                         = 0xc654,
        kIeungWaIeung                         = 0xc655,
        kIeungWaCieuc                         = 0xc656,
        kIeungWaChieuch                         = 0xc657,
        kIeungWaKhieukh                         = 0xc658,
        kIeungWaThieuth                         = 0xc659,
        kIeungWaPhieuph                         = 0xc65a,
        kIeungWaHieuh                         = 0xc65b,
        kIeungWae                           = 0xc65c,
        kIeungWaeKiyeok                         = 0xc65d,
        kIeungWaeSsangkiyeok                         = 0xc65e,
        kIeungWaeKiyeoksios                         = 0xc65f,
        kIeungWaeNieun                         = 0xc660,
        kIeungWaeNieuncieuc                         = 0xc661,
        kIeungWaeNieunhieuh                         = 0xc662,
        kIeungWaeTikeut                         = 0xc663,
        kIeungWaeRieul                         = 0xc664,
        kIeungWaeRieulkiyeok                         = 0xc665,
        kIeungWaeRieulmieum                         = 0xc666,
        kIeungWaeRieulpieup                         = 0xc667,
        kIeungWaeRieulsios                         = 0xc668,
        kIeungWaeRieulthieuth                         = 0xc669,
        kIeungWaeRieulphieuph                         = 0xc66a,
        kIeungWaeRieulhieuh                         = 0xc66b,
        kIeungWaeMieum                         = 0xc66c,
        kIeungWaePieup                         = 0xc66d,
        kIeungWaePieupsios                         = 0xc66e,
        kIeungWaeSios                         = 0xc66f,
        kIeungWaeSsangsios                         = 0xc670,
        kIeungWaeIeung                         = 0xc671,
        kIeungWaeCieuc                         = 0xc672,
        kIeungWaeChieuch                         = 0xc673,
        kIeungWaeKhieukh                         = 0xc674,
        kIeungWaeThieuth                         = 0xc675,
        kIeungWaePhieuph                         = 0xc676,
        kIeungWaeHieuh                         = 0xc677,
        kIeungOe                           = 0xc678,
        kIeungOeKiyeok                         = 0xc679,
        kIeungOeSsangkiyeok                         = 0xc67a,
        kIeungOeKiyeoksios                         = 0xc67b,
        kIeungOeNieun                         = 0xc67c,
        kIeungOeNieuncieuc                         = 0xc67d,
        kIeungOeNieunhieuh                         = 0xc67e,
        kIeungOeTikeut                         = 0xc67f,
        kIeungOeRieul                         = 0xc680,
        kIeungOeRieulkiyeok                         = 0xc681,
        kIeungOeRieulmieum                         = 0xc682,
        kIeungOeRieulpieup                         = 0xc683,
        kIeungOeRieulsios                         = 0xc684,
        kIeungOeRieulthieuth                         = 0xc685,
        kIeungOeRieulphieuph                         = 0xc686,
        kIeungOeRieulhieuh                         = 0xc687,
        kIeungOeMieum                         = 0xc688,
        kIeungOePieup                         = 0xc689,
        kIeungOePieupsios                         = 0xc68a,
        kIeungOeSios                         = 0xc68b,
        kIeungOeSsangsios                         = 0xc68c,
        kIeungOeIeung                         = 0xc68d,
        kIeungOeCieuc                         = 0xc68e,
        kIeungOeChieuch                         = 0xc68f,
        kIeungOeKhieukh                         = 0xc690,
        kIeungOeThieuth                         = 0xc691,
        kIeungOePhieuph                         = 0xc692,
        kIeungOeHieuh                         = 0xc693,
        kIeungYo                           = 0xc694,
        kIeungYoKiyeok                         = 0xc695,
        kIeungYoSsangkiyeok                         = 0xc696,
        kIeungYoKiyeoksios                         = 0xc697,
        kIeungYoNieun                         = 0xc698,
        kIeungYoNieuncieuc                         = 0xc699,
        kIeungYoNieunhieuh                         = 0xc69a,
        kIeungYoTikeut                         = 0xc69b,
        kIeungYoRieul                         = 0xc69c,
        kIeungYoRieulkiyeok                         = 0xc69d,
        kIeungYoRieulmieum                         = 0xc69e,
        kIeungYoRieulpieup                         = 0xc69f,
        kIeungYoRieulsios                         = 0xc6a0,
        kIeungYoRieulthieuth                         = 0xc6a1,
        kIeungYoRieulphieuph                         = 0xc6a2,
        kIeungYoRieulhieuh                         = 0xc6a3,
        kIeungYoMieum                         = 0xc6a4,
        kIeungYoPieup                         = 0xc6a5,
        kIeungYoPieupsios                         = 0xc6a6,
        kIeungYoSios                         = 0xc6a7,
        kIeungYoSsangsios                         = 0xc6a8,
        kIeungYoIeung                         = 0xc6a9,
        kIeungYoCieuc                         = 0xc6aa,
        kIeungYoChieuch                         = 0xc6ab,
        kIeungYoKhieukh                         = 0xc6ac,
        kIeungYoThieuth                         = 0xc6ad,
        kIeungYoPhieuph                         = 0xc6ae,
        kIeungYoHieuh                         = 0xc6af,
        kIeungU                           = 0xc6b0,
        kIeungUKiyeok                         = 0xc6b1,
        kIeungUSsangkiyeok                         = 0xc6b2,
        kIeungUKiyeoksios                         = 0xc6b3,
        kIeungUNieun                         = 0xc6b4,
        kIeungUNieuncieuc                         = 0xc6b5,
        kIeungUNieunhieuh                         = 0xc6b6,
        kIeungUTikeut                         = 0xc6b7,
        kIeungURieul                         = 0xc6b8,
        kIeungURieulkiyeok                         = 0xc6b9,
        kIeungURieulmieum                         = 0xc6ba,
        kIeungURieulpieup                         = 0xc6bb,
        kIeungURieulsios                         = 0xc6bc,
        kIeungURieulthieuth                         = 0xc6bd,
        kIeungURieulphieuph                         = 0xc6be,
        kIeungURieulhieuh                         = 0xc6bf,
        kIeungUMieum                         = 0xc6c0,
        kIeungUPieup                         = 0xc6c1,
        kIeungUPieupsios                         = 0xc6c2,
        kIeungUSios                         = 0xc6c3,
        kIeungUSsangsios                         = 0xc6c4,
        kIeungUIeung                         = 0xc6c5,
        kIeungUCieuc                         = 0xc6c6,
        kIeungUChieuch                         = 0xc6c7,
        kIeungUKhieukh                         = 0xc6c8,
        kIeungUThieuth                         = 0xc6c9,
        kIeungUPhieuph                         = 0xc6ca,
        kIeungUHieuh                         = 0xc6cb,
        kIeungWeo                           = 0xc6cc,
        kIeungWeoKiyeok                         = 0xc6cd,
        kIeungWeoSsangkiyeok                         = 0xc6ce,
        kIeungWeoKiyeoksios                         = 0xc6cf,
        kIeungWeoNieun                         = 0xc6d0,
        kIeungWeoNieuncieuc                         = 0xc6d1,
        kIeungWeoNieunhieuh                         = 0xc6d2,
        kIeungWeoTikeut                         = 0xc6d3,
        kIeungWeoRieul                         = 0xc6d4,
        kIeungWeoRieulkiyeok                         = 0xc6d5,
        kIeungWeoRieulmieum                         = 0xc6d6,
        kIeungWeoRieulpieup                         = 0xc6d7,
        kIeungWeoRieulsios                         = 0xc6d8,
        kIeungWeoRieulthieuth                         = 0xc6d9,
        kIeungWeoRieulphieuph                         = 0xc6da,
        kIeungWeoRieulhieuh                         = 0xc6db,
        kIeungWeoMieum                         = 0xc6dc,
        kIeungWeoPieup                         = 0xc6dd,
        kIeungWeoPieupsios                         = 0xc6de,
        kIeungWeoSios                         = 0xc6df,
        kIeungWeoSsangsios                         = 0xc6e0,
        kIeungWeoIeung                         = 0xc6e1,
        kIeungWeoCieuc                         = 0xc6e2,
        kIeungWeoChieuch                         = 0xc6e3,
        kIeungWeoKhieukh                         = 0xc6e4,
        kIeungWeoThieuth                         = 0xc6e5,
        kIeungWeoPhieuph                         = 0xc6e6,
        kIeungWeoHieuh                         = 0xc6e7,
        kIeungWe                           = 0xc6e8,
        kIeungWeKiyeok                         = 0xc6e9,
        kIeungWeSsangkiyeok                         = 0xc6ea,
        kIeungWeKiyeoksios                         = 0xc6eb,
        kIeungWeNieun                         = 0xc6ec,
        kIeungWeNieuncieuc                         = 0xc6ed,
        kIeungWeNieunhieuh                         = 0xc6ee,
        kIeungWeTikeut                         = 0xc6ef,
        kIeungWeRieul                         = 0xc6f0,
        kIeungWeRieulkiyeok                         = 0xc6f1,
        kIeungWeRieulmieum                         = 0xc6f2,
        kIeungWeRieulpieup                         = 0xc6f3,
        kIeungWeRieulsios                         = 0xc6f4,
        kIeungWeRieulthieuth                         = 0xc6f5,
        kIeungWeRieulphieuph                         = 0xc6f6,
        kIeungWeRieulhieuh                         = 0xc6f7,
        kIeungWeMieum                         = 0xc6f8,
        kIeungWePieup                         = 0xc6f9,
        kIeungWePieupsios                         = 0xc6fa,
        kIeungWeSios                         = 0xc6fb,
        kIeungWeSsangsios                         = 0xc6fc,
        kIeungWeIeung                         = 0xc6fd,
        kIeungWeCieuc                         = 0xc6fe,
        kIeungWeChieuch                         = 0xc6ff,
        kIeungWeKhieukh                         = 0xc700,
        kIeungWeThieuth                         = 0xc701,
        kIeungWePhieuph                         = 0xc702,
        kIeungWeHieuh                         = 0xc703,
        kIeungWi                           = 0xc704,
        kIeungWiKiyeok                         = 0xc705,
        kIeungWiSsangkiyeok                         = 0xc706,
        kIeungWiKiyeoksios                         = 0xc707,
        kIeungWiNieun                         = 0xc708,
        kIeungWiNieuncieuc                         = 0xc709,
        kIeungWiNieunhieuh                         = 0xc70a,
        kIeungWiTikeut                         = 0xc70b,
        kIeungWiRieul                         = 0xc70c,
        kIeungWiRieulkiyeok                         = 0xc70d,
        kIeungWiRieulmieum                         = 0xc70e,
        kIeungWiRieulpieup                         = 0xc70f,
        kIeungWiRieulsios                         = 0xc710,
        kIeungWiRieulthieuth                         = 0xc711,
        kIeungWiRieulphieuph                         = 0xc712,
        kIeungWiRieulhieuh                         = 0xc713,
        kIeungWiMieum                         = 0xc714,
        kIeungWiPieup                         = 0xc715,
        kIeungWiPieupsios                         = 0xc716,
        kIeungWiSios                         = 0xc717,
        kIeungWiSsangsios                         = 0xc718,
        kIeungWiIeung                         = 0xc719,
        kIeungWiCieuc                         = 0xc71a,
        kIeungWiChieuch                         = 0xc71b,
        kIeungWiKhieukh                         = 0xc71c,
        kIeungWiThieuth                         = 0xc71d,
        kIeungWiPhieuph                         = 0xc71e,
        kIeungWiHieuh                         = 0xc71f,
        kIeungYu                           = 0xc720,
        kIeungYuKiyeok                         = 0xc721,
        kIeungYuSsangkiyeok                         = 0xc722,
        kIeungYuKiyeoksios                         = 0xc723,
        kIeungYuNieun                         = 0xc724,
        kIeungYuNieuncieuc                         = 0xc725,
        kIeungYuNieunhieuh                         = 0xc726,
        kIeungYuTikeut                         = 0xc727,
        kIeungYuRieul                         = 0xc728,
        kIeungYuRieulkiyeok                         = 0xc729,
        kIeungYuRieulmieum                         = 0xc72a,
        kIeungYuRieulpieup                         = 0xc72b,
        kIeungYuRieulsios                         = 0xc72c,
        kIeungYuRieulthieuth                         = 0xc72d,
        kIeungYuRieulphieuph                         = 0xc72e,
        kIeungYuRieulhieuh                         = 0xc72f,
        kIeungYuMieum                         = 0xc730,
        kIeungYuPieup                         = 0xc731,
        kIeungYuPieupsios                         = 0xc732,
        kIeungYuSios                         = 0xc733,
        kIeungYuSsangsios                         = 0xc734,
        kIeungYuIeung                         = 0xc735,
        kIeungYuCieuc                         = 0xc736,
        kIeungYuChieuch                         = 0xc737,
        kIeungYuKhieukh                         = 0xc738,
        kIeungYuThieuth                         = 0xc739,
        kIeungYuPhieuph                         = 0xc73a,
        kIeungYuHieuh                         = 0xc73b,
        kIeungEu                           = 0xc73c,
        kIeungEuKiyeok                         = 0xc73d,
        kIeungEuSsangkiyeok                         = 0xc73e,
        kIeungEuKiyeoksios                         = 0xc73f,
        kIeungEuNieun                         = 0xc740,
        kIeungEuNieuncieuc                         = 0xc741,
        kIeungEuNieunhieuh                         = 0xc742,
        kIeungEuTikeut                         = 0xc743,
        kIeungEuRieul                         = 0xc744,
        kIeungEuRieulkiyeok                         = 0xc745,
        kIeungEuRieulmieum                         = 0xc746,
        kIeungEuRieulpieup                         = 0xc747,
        kIeungEuRieulsios                         = 0xc748,
        kIeungEuRieulthieuth                         = 0xc749,
        kIeungEuRieulphieuph                         = 0xc74a,
        kIeungEuRieulhieuh                         = 0xc74b,
        kIeungEuMieum                         = 0xc74c,
        kIeungEuPieup                         = 0xc74d,
        kIeungEuPieupsios                         = 0xc74e,
        kIeungEuSios                         = 0xc74f,
        kIeungEuSsangsios                         = 0xc750,
        kIeungEuIeung                         = 0xc751,
        kIeungEuCieuc                         = 0xc752,
        kIeungEuChieuch                         = 0xc753,
        kIeungEuKhieukh                         = 0xc754,
        kIeungEuThieuth                         = 0xc755,
        kIeungEuPhieuph                         = 0xc756,
        kIeungEuHieuh                         = 0xc757,
        kIeungYi                           = 0xc758,
        kIeungYiKiyeok                         = 0xc759,
        kIeungYiSsangkiyeok                         = 0xc75a,
        kIeungYiKiyeoksios                         = 0xc75b,
        kIeungYiNieun                         = 0xc75c,
        kIeungYiNieuncieuc                         = 0xc75d,
        kIeungYiNieunhieuh                         = 0xc75e,
        kIeungYiTikeut                         = 0xc75f,
        kIeungYiRieul                         = 0xc760,
        kIeungYiRieulkiyeok                         = 0xc761,
        kIeungYiRieulmieum                         = 0xc762,
        kIeungYiRieulpieup                         = 0xc763,
        kIeungYiRieulsios                         = 0xc764,
        kIeungYiRieulthieuth                         = 0xc765,
        kIeungYiRieulphieuph                         = 0xc766,
        kIeungYiRieulhieuh                         = 0xc767,
        kIeungYiMieum                         = 0xc768,
        kIeungYiPieup                         = 0xc769,
        kIeungYiPieupsios                         = 0xc76a,
        kIeungYiSios                         = 0xc76b,
        kIeungYiSsangsios                         = 0xc76c,
        kIeungYiIeung                         = 0xc76d,
        kIeungYiCieuc                         = 0xc76e,
        kIeungYiChieuch                         = 0xc76f,
        kIeungYiKhieukh                         = 0xc770,
        kIeungYiThieuth                         = 0xc771,
        kIeungYiPhieuph                         = 0xc772,
        kIeungYiHieuh                         = 0xc773,
        kIeungI                           = 0xc774,
        kIeungIKiyeok                         = 0xc775,
        kIeungISsangkiyeok                         = 0xc776,
        kIeungIKiyeoksios                         = 0xc777,
        kIeungINieun                         = 0xc778,
        kIeungINieuncieuc                         = 0xc779,
        kIeungINieunhieuh                         = 0xc77a,
        kIeungITikeut                         = 0xc77b,
        kIeungIRieul                         = 0xc77c,
        kIeungIRieulkiyeok                         = 0xc77d,
        kIeungIRieulmieum                         = 0xc77e,
        kIeungIRieulpieup                         = 0xc77f,
        kIeungIRieulsios                         = 0xc780,
        kIeungIRieulthieuth                         = 0xc781,
        kIeungIRieulphieuph                         = 0xc782,
        kIeungIRieulhieuh                         = 0xc783,
        kIeungIMieum                         = 0xc784,
        kIeungIPieup                         = 0xc785,
        kIeungIPieupsios                         = 0xc786,
        kIeungISios                         = 0xc787,
        kIeungISsangsios                         = 0xc788,
        kIeungIIeung                         = 0xc789,
        kIeungICieuc                         = 0xc78a,
        kIeungIChieuch                         = 0xc78b,
        kIeungIKhieukh                         = 0xc78c,
        kIeungIThieuth                         = 0xc78d,
        kIeungIPhieuph                         = 0xc78e,
        kIeungIHieuh                         = 0xc78f,
        kCieucA                           = 0xc790,
        kCieucAKiyeok                         = 0xc791,
        kCieucASsangkiyeok                         = 0xc792,
        kCieucAKiyeoksios                         = 0xc793,
        kCieucANieun                         = 0xc794,
        kCieucANieuncieuc                         = 0xc795,
        kCieucANieunhieuh                         = 0xc796,
        kCieucATikeut                         = 0xc797,
        kCieucARieul                         = 0xc798,
        kCieucARieulkiyeok                         = 0xc799,
        kCieucARieulmieum                         = 0xc79a,
        kCieucARieulpieup                         = 0xc79b,
        kCieucARieulsios                         = 0xc79c,
        kCieucARieulthieuth                         = 0xc79d,
        kCieucARieulphieuph                         = 0xc79e,
        kCieucARieulhieuh                         = 0xc79f,
        kCieucAMieum                         = 0xc7a0,
        kCieucAPieup                         = 0xc7a1,
        kCieucAPieupsios                         = 0xc7a2,
        kCieucASios                         = 0xc7a3,
        kCieucASsangsios                         = 0xc7a4,
        kCieucAIeung                         = 0xc7a5,
        kCieucACieuc                         = 0xc7a6,
        kCieucAChieuch                         = 0xc7a7,
        kCieucAKhieukh                         = 0xc7a8,
        kCieucAThieuth                         = 0xc7a9,
        kCieucAPhieuph                         = 0xc7aa,
        kCieucAHieuh                         = 0xc7ab,
        kCieucAe                           = 0xc7ac,
        kCieucAeKiyeok                         = 0xc7ad,
        kCieucAeSsangkiyeok                         = 0xc7ae,
        kCieucAeKiyeoksios                         = 0xc7af,
        kCieucAeNieun                         = 0xc7b0,
        kCieucAeNieuncieuc                         = 0xc7b1,
        kCieucAeNieunhieuh                         = 0xc7b2,
        kCieucAeTikeut                         = 0xc7b3,
        kCieucAeRieul                         = 0xc7b4,
        kCieucAeRieulkiyeok                         = 0xc7b5,
        kCieucAeRieulmieum                         = 0xc7b6,
        kCieucAeRieulpieup                         = 0xc7b7,
        kCieucAeRieulsios                         = 0xc7b8,
        kCieucAeRieulthieuth                         = 0xc7b9,
        kCieucAeRieulphieuph                         = 0xc7ba,
        kCieucAeRieulhieuh                         = 0xc7bb,
        kCieucAeMieum                         = 0xc7bc,
        kCieucAePieup                         = 0xc7bd,
        kCieucAePieupsios                         = 0xc7be,
        kCieucAeSios                         = 0xc7bf,
        kCieucAeSsangsios                         = 0xc7c0,
        kCieucAeIeung                         = 0xc7c1,
        kCieucAeCieuc                         = 0xc7c2,
        kCieucAeChieuch                         = 0xc7c3,
        kCieucAeKhieukh                         = 0xc7c4,
        kCieucAeThieuth                         = 0xc7c5,
        kCieucAePhieuph                         = 0xc7c6,
        kCieucAeHieuh                         = 0xc7c7,
        kCieucYa                           = 0xc7c8,
        kCieucYaKiyeok                         = 0xc7c9,
        kCieucYaSsangkiyeok                         = 0xc7ca,
        kCieucYaKiyeoksios                         = 0xc7cb,
        kCieucYaNieun                         = 0xc7cc,
        kCieucYaNieuncieuc                         = 0xc7cd,
        kCieucYaNieunhieuh                         = 0xc7ce,
        kCieucYaTikeut                         = 0xc7cf,
        kCieucYaRieul                         = 0xc7d0,
        kCieucYaRieulkiyeok                         = 0xc7d1,
        kCieucYaRieulmieum                         = 0xc7d2,
        kCieucYaRieulpieup                         = 0xc7d3,
        kCieucYaRieulsios                         = 0xc7d4,
        kCieucYaRieulthieuth                         = 0xc7d5,
        kCieucYaRieulphieuph                         = 0xc7d6,
        kCieucYaRieulhieuh                         = 0xc7d7,
        kCieucYaMieum                         = 0xc7d8,
        kCieucYaPieup                         = 0xc7d9,
        kCieucYaPieupsios                         = 0xc7da,
        kCieucYaSios                         = 0xc7db,
        kCieucYaSsangsios                         = 0xc7dc,
        kCieucYaIeung                         = 0xc7dd,
        kCieucYaCieuc                         = 0xc7de,
        kCieucYaChieuch                         = 0xc7df,
        kCieucYaKhieukh                         = 0xc7e0,
        kCieucYaThieuth                         = 0xc7e1,
        kCieucYaPhieuph                         = 0xc7e2,
        kCieucYaHieuh                         = 0xc7e3,
        kCieucYae                           = 0xc7e4,
        kCieucYaeKiyeok                         = 0xc7e5,
        kCieucYaeSsangkiyeok                         = 0xc7e6,
        kCieucYaeKiyeoksios                         = 0xc7e7,
        kCieucYaeNieun                         = 0xc7e8,
        kCieucYaeNieuncieuc                         = 0xc7e9,
        kCieucYaeNieunhieuh                         = 0xc7ea,
        kCieucYaeTikeut                         = 0xc7eb,
        kCieucYaeRieul                         = 0xc7ec,
        kCieucYaeRieulkiyeok                         = 0xc7ed,
        kCieucYaeRieulmieum                         = 0xc7ee,
        kCieucYaeRieulpieup                         = 0xc7ef,
        kCieucYaeRieulsios                         = 0xc7f0,
        kCieucYaeRieulthieuth                         = 0xc7f1,
        kCieucYaeRieulphieuph                         = 0xc7f2,
        kCieucYaeRieulhieuh                         = 0xc7f3,
        kCieucYaeMieum                         = 0xc7f4,
        kCieucYaePieup                         = 0xc7f5,
        kCieucYaePieupsios                         = 0xc7f6,
        kCieucYaeSios                         = 0xc7f7,
        kCieucYaeSsangsios                         = 0xc7f8,
        kCieucYaeIeung                         = 0xc7f9,
        kCieucYaeCieuc                         = 0xc7fa,
        kCieucYaeChieuch                         = 0xc7fb,
        kCieucYaeKhieukh                         = 0xc7fc,
        kCieucYaeThieuth                         = 0xc7fd,
        kCieucYaePhieuph                         = 0xc7fe,
        kCieucYaeHieuh                         = 0xc7ff,
        kCieucEo                           = 0xc800,
        kCieucEoKiyeok                         = 0xc801,
        kCieucEoSsangkiyeok                         = 0xc802,
        kCieucEoKiyeoksios                         = 0xc803,
        kCieucEoNieun                         = 0xc804,
        kCieucEoNieuncieuc                         = 0xc805,
        kCieucEoNieunhieuh                         = 0xc806,
        kCieucEoTikeut                         = 0xc807,
        kCieucEoRieul                         = 0xc808,
        kCieucEoRieulkiyeok                         = 0xc809,
        kCieucEoRieulmieum                         = 0xc80a,
        kCieucEoRieulpieup                         = 0xc80b,
        kCieucEoRieulsios                         = 0xc80c,
        kCieucEoRieulthieuth                         = 0xc80d,
        kCieucEoRieulphieuph                         = 0xc80e,
        kCieucEoRieulhieuh                         = 0xc80f,
        kCieucEoMieum                         = 0xc810,
        kCieucEoPieup                         = 0xc811,
        kCieucEoPieupsios                         = 0xc812,
        kCieucEoSios                         = 0xc813,
        kCieucEoSsangsios                         = 0xc814,
        kCieucEoIeung                         = 0xc815,
        kCieucEoCieuc                         = 0xc816,
        kCieucEoChieuch                         = 0xc817,
        kCieucEoKhieukh                         = 0xc818,
        kCieucEoThieuth                         = 0xc819,
        kCieucEoPhieuph                         = 0xc81a,
        kCieucEoHieuh                         = 0xc81b,
        kCieucE                           = 0xc81c,
        kCieucEKiyeok                         = 0xc81d,
        kCieucESsangkiyeok                         = 0xc81e,
        kCieucEKiyeoksios                         = 0xc81f,
        kCieucENieun                         = 0xc820,
        kCieucENieuncieuc                         = 0xc821,
        kCieucENieunhieuh                         = 0xc822,
        kCieucETikeut                         = 0xc823,
        kCieucERieul                         = 0xc824,
        kCieucERieulkiyeok                         = 0xc825,
        kCieucERieulmieum                         = 0xc826,
        kCieucERieulpieup                         = 0xc827,
        kCieucERieulsios                         = 0xc828,
        kCieucERieulthieuth                         = 0xc829,
        kCieucERieulphieuph                         = 0xc82a,
        kCieucERieulhieuh                         = 0xc82b,
        kCieucEMieum                         = 0xc82c,
        kCieucEPieup                         = 0xc82d,
        kCieucEPieupsios                         = 0xc82e,
        kCieucESios                         = 0xc82f,
        kCieucESsangsios                         = 0xc830,
        kCieucEIeung                         = 0xc831,
        kCieucECieuc                         = 0xc832,
        kCieucEChieuch                         = 0xc833,
        kCieucEKhieukh                         = 0xc834,
        kCieucEThieuth                         = 0xc835,
        kCieucEPhieuph                         = 0xc836,
        kCieucEHieuh                         = 0xc837,
        kCieucYeo                           = 0xc838,
        kCieucYeoKiyeok                         = 0xc839,
        kCieucYeoSsangkiyeok                         = 0xc83a,
        kCieucYeoKiyeoksios                         = 0xc83b,
        kCieucYeoNieun                         = 0xc83c,
        kCieucYeoNieuncieuc                         = 0xc83d,
        kCieucYeoNieunhieuh                         = 0xc83e,
        kCieucYeoTikeut                         = 0xc83f,
        kCieucYeoRieul                         = 0xc840,
        kCieucYeoRieulkiyeok                         = 0xc841,
        kCieucYeoRieulmieum                         = 0xc842,
        kCieucYeoRieulpieup                         = 0xc843,
        kCieucYeoRieulsios                         = 0xc844,
        kCieucYeoRieulthieuth                         = 0xc845,
        kCieucYeoRieulphieuph                         = 0xc846,
        kCieucYeoRieulhieuh                         = 0xc847,
        kCieucYeoMieum                         = 0xc848,
        kCieucYeoPieup                         = 0xc849,
        kCieucYeoPieupsios                         = 0xc84a,
        kCieucYeoSios                         = 0xc84b,
        kCieucYeoSsangsios                         = 0xc84c,
        kCieucYeoIeung                         = 0xc84d,
        kCieucYeoCieuc                         = 0xc84e,
        kCieucYeoChieuch                         = 0xc84f,
        kCieucYeoKhieukh                         = 0xc850,
        kCieucYeoThieuth                         = 0xc851,
        kCieucYeoPhieuph                         = 0xc852,
        kCieucYeoHieuh                         = 0xc853,
        kCieucYe                           = 0xc854,
        kCieucYeKiyeok                         = 0xc855,
        kCieucYeSsangkiyeok                         = 0xc856,
        kCieucYeKiyeoksios                         = 0xc857,
        kCieucYeNieun                         = 0xc858,
        kCieucYeNieuncieuc                         = 0xc859,
        kCieucYeNieunhieuh                         = 0xc85a,
        kCieucYeTikeut                         = 0xc85b,
        kCieucYeRieul                         = 0xc85c,
        kCieucYeRieulkiyeok                         = 0xc85d,
        kCieucYeRieulmieum                         = 0xc85e,
        kCieucYeRieulpieup                         = 0xc85f,
        kCieucYeRieulsios                         = 0xc860,
        kCieucYeRieulthieuth                         = 0xc861,
        kCieucYeRieulphieuph                         = 0xc862,
        kCieucYeRieulhieuh                         = 0xc863,
        kCieucYeMieum                         = 0xc864,
        kCieucYePieup                         = 0xc865,
        kCieucYePieupsios                         = 0xc866,
        kCieucYeSios                         = 0xc867,
        kCieucYeSsangsios                         = 0xc868,
        kCieucYeIeung                         = 0xc869,
        kCieucYeCieuc                         = 0xc86a,
        kCieucYeChieuch                         = 0xc86b,
        kCieucYeKhieukh                         = 0xc86c,
        kCieucYeThieuth                         = 0xc86d,
        kCieucYePhieuph                         = 0xc86e,
        kCieucYeHieuh                         = 0xc86f,
        kCieucO                           = 0xc870,
        kCieucOKiyeok                         = 0xc871,
        kCieucOSsangkiyeok                         = 0xc872,
        kCieucOKiyeoksios                         = 0xc873,
        kCieucONieun                         = 0xc874,
        kCieucONieuncieuc                         = 0xc875,
        kCieucONieunhieuh                         = 0xc876,
        kCieucOTikeut                         = 0xc877,
        kCieucORieul                         = 0xc878,
        kCieucORieulkiyeok                         = 0xc879,
        kCieucORieulmieum                         = 0xc87a,
        kCieucORieulpieup                         = 0xc87b,
        kCieucORieulsios                         = 0xc87c,
        kCieucORieulthieuth                         = 0xc87d,
        kCieucORieulphieuph                         = 0xc87e,
        kCieucORieulhieuh                         = 0xc87f,
        kCieucOMieum                         = 0xc880,
        kCieucOPieup                         = 0xc881,
        kCieucOPieupsios                         = 0xc882,
        kCieucOSios                         = 0xc883,
        kCieucOSsangsios                         = 0xc884,
        kCieucOIeung                         = 0xc885,
        kCieucOCieuc                         = 0xc886,
        kCieucOChieuch                         = 0xc887,
        kCieucOKhieukh                         = 0xc888,
        kCieucOThieuth                         = 0xc889,
        kCieucOPhieuph                         = 0xc88a,
        kCieucOHieuh                         = 0xc88b,
        kCieucWa                           = 0xc88c,
        kCieucWaKiyeok                         = 0xc88d,
        kCieucWaSsangkiyeok                         = 0xc88e,
        kCieucWaKiyeoksios                         = 0xc88f,
        kCieucWaNieun                         = 0xc890,
        kCieucWaNieuncieuc                         = 0xc891,
        kCieucWaNieunhieuh                         = 0xc892,
        kCieucWaTikeut                         = 0xc893,
        kCieucWaRieul                         = 0xc894,
        kCieucWaRieulkiyeok                         = 0xc895,
        kCieucWaRieulmieum                         = 0xc896,
        kCieucWaRieulpieup                         = 0xc897,
        kCieucWaRieulsios                         = 0xc898,
        kCieucWaRieulthieuth                         = 0xc899,
        kCieucWaRieulphieuph                         = 0xc89a,
        kCieucWaRieulhieuh                         = 0xc89b,
        kCieucWaMieum                         = 0xc89c,
        kCieucWaPieup                         = 0xc89d,
        kCieucWaPieupsios                         = 0xc89e,
        kCieucWaSios                         = 0xc89f,
        kCieucWaSsangsios                         = 0xc8a0,
        kCieucWaIeung                         = 0xc8a1,
        kCieucWaCieuc                         = 0xc8a2,
        kCieucWaChieuch                         = 0xc8a3,
        kCieucWaKhieukh                         = 0xc8a4,
        kCieucWaThieuth                         = 0xc8a5,
        kCieucWaPhieuph                         = 0xc8a6,
        kCieucWaHieuh                         = 0xc8a7,
        kCieucWae                           = 0xc8a8,
        kCieucWaeKiyeok                         = 0xc8a9,
        kCieucWaeSsangkiyeok                         = 0xc8aa,
        kCieucWaeKiyeoksios                         = 0xc8ab,
        kCieucWaeNieun                         = 0xc8ac,
        kCieucWaeNieuncieuc                         = 0xc8ad,
        kCieucWaeNieunhieuh                         = 0xc8ae,
        kCieucWaeTikeut                         = 0xc8af,
        kCieucWaeRieul                         = 0xc8b0,
        kCieucWaeRieulkiyeok                         = 0xc8b1,
        kCieucWaeRieulmieum                         = 0xc8b2,
        kCieucWaeRieulpieup                         = 0xc8b3,
        kCieucWaeRieulsios                         = 0xc8b4,
        kCieucWaeRieulthieuth                         = 0xc8b5,
        kCieucWaeRieulphieuph                         = 0xc8b6,
        kCieucWaeRieulhieuh                         = 0xc8b7,
        kCieucWaeMieum                         = 0xc8b8,
        kCieucWaePieup                         = 0xc8b9,
        kCieucWaePieupsios                         = 0xc8ba,
        kCieucWaeSios                         = 0xc8bb,
        kCieucWaeSsangsios                         = 0xc8bc,
        kCieucWaeIeung                         = 0xc8bd,
        kCieucWaeCieuc                         = 0xc8be,
        kCieucWaeChieuch                         = 0xc8bf,
        kCieucWaeKhieukh                         = 0xc8c0,
        kCieucWaeThieuth                         = 0xc8c1,
        kCieucWaePhieuph                         = 0xc8c2,
        kCieucWaeHieuh                         = 0xc8c3,
        kCieucOe                           = 0xc8c4,
        kCieucOeKiyeok                         = 0xc8c5,
        kCieucOeSsangkiyeok                         = 0xc8c6,
        kCieucOeKiyeoksios                         = 0xc8c7,
        kCieucOeNieun                         = 0xc8c8,
        kCieucOeNieuncieuc                         = 0xc8c9,
        kCieucOeNieunhieuh                         = 0xc8ca,
        kCieucOeTikeut                         = 0xc8cb,
        kCieucOeRieul                         = 0xc8cc,
        kCieucOeRieulkiyeok                         = 0xc8cd,
        kCieucOeRieulmieum                         = 0xc8ce,
        kCieucOeRieulpieup                         = 0xc8cf,
        kCieucOeRieulsios                         = 0xc8d0,
        kCieucOeRieulthieuth                         = 0xc8d1,
        kCieucOeRieulphieuph                         = 0xc8d2,
        kCieucOeRieulhieuh                         = 0xc8d3,
        kCieucOeMieum                         = 0xc8d4,
        kCieucOePieup                         = 0xc8d5,
        kCieucOePieupsios                         = 0xc8d6,
        kCieucOeSios                         = 0xc8d7,
        kCieucOeSsangsios                         = 0xc8d8,
        kCieucOeIeung                         = 0xc8d9,
        kCieucOeCieuc                         = 0xc8da,
        kCieucOeChieuch                         = 0xc8db,
        kCieucOeKhieukh                         = 0xc8dc,
        kCieucOeThieuth                         = 0xc8dd,
        kCieucOePhieuph                         = 0xc8de,
        kCieucOeHieuh                         = 0xc8df,
        kCieucYo                           = 0xc8e0,
        kCieucYoKiyeok                         = 0xc8e1,
        kCieucYoSsangkiyeok                         = 0xc8e2,
        kCieucYoKiyeoksios                         = 0xc8e3,
        kCieucYoNieun                         = 0xc8e4,
        kCieucYoNieuncieuc                         = 0xc8e5,
        kCieucYoNieunhieuh                         = 0xc8e6,
        kCieucYoTikeut                         = 0xc8e7,
        kCieucYoRieul                         = 0xc8e8,
        kCieucYoRieulkiyeok                         = 0xc8e9,
        kCieucYoRieulmieum                         = 0xc8ea,
        kCieucYoRieulpieup                         = 0xc8eb,
        kCieucYoRieulsios                         = 0xc8ec,
        kCieucYoRieulthieuth                         = 0xc8ed,
        kCieucYoRieulphieuph                         = 0xc8ee,
        kCieucYoRieulhieuh                         = 0xc8ef,
        kCieucYoMieum                         = 0xc8f0,
        kCieucYoPieup                         = 0xc8f1,
        kCieucYoPieupsios                         = 0xc8f2,
        kCieucYoSios                         = 0xc8f3,
        kCieucYoSsangsios                         = 0xc8f4,
        kCieucYoIeung                         = 0xc8f5,
        kCieucYoCieuc                         = 0xc8f6,
        kCieucYoChieuch                         = 0xc8f7,
        kCieucYoKhieukh                         = 0xc8f8,
        kCieucYoThieuth                         = 0xc8f9,
        kCieucYoPhieuph                         = 0xc8fa,
        kCieucYoHieuh                         = 0xc8fb,
        kCieucU                           = 0xc8fc,
        kCieucUKiyeok                         = 0xc8fd,
        kCieucUSsangkiyeok                         = 0xc8fe,
        kCieucUKiyeoksios                         = 0xc8ff,
        kCieucUNieun                         = 0xc900,
        kCieucUNieuncieuc                         = 0xc901,
        kCieucUNieunhieuh                         = 0xc902,
        kCieucUTikeut                         = 0xc903,
        kCieucURieul                         = 0xc904,
        kCieucURieulkiyeok                         = 0xc905,
        kCieucURieulmieum                         = 0xc906,
        kCieucURieulpieup                         = 0xc907,
        kCieucURieulsios                         = 0xc908,
        kCieucURieulthieuth                         = 0xc909,
        kCieucURieulphieuph                         = 0xc90a,
        kCieucURieulhieuh                         = 0xc90b,
        kCieucUMieum                         = 0xc90c,
        kCieucUPieup                         = 0xc90d,
        kCieucUPieupsios                         = 0xc90e,
        kCieucUSios                         = 0xc90f,
        kCieucUSsangsios                         = 0xc910,
        kCieucUIeung                         = 0xc911,
        kCieucUCieuc                         = 0xc912,
        kCieucUChieuch                         = 0xc913,
        kCieucUKhieukh                         = 0xc914,
        kCieucUThieuth                         = 0xc915,
        kCieucUPhieuph                         = 0xc916,
        kCieucUHieuh                         = 0xc917,
        kCieucWeo                           = 0xc918,
        kCieucWeoKiyeok                         = 0xc919,
        kCieucWeoSsangkiyeok                         = 0xc91a,
        kCieucWeoKiyeoksios                         = 0xc91b,
        kCieucWeoNieun                         = 0xc91c,
        kCieucWeoNieuncieuc                         = 0xc91d,
        kCieucWeoNieunhieuh                         = 0xc91e,
        kCieucWeoTikeut                         = 0xc91f,
        kCieucWeoRieul                         = 0xc920,
        kCieucWeoRieulkiyeok                         = 0xc921,
        kCieucWeoRieulmieum                         = 0xc922,
        kCieucWeoRieulpieup                         = 0xc923,
        kCieucWeoRieulsios                         = 0xc924,
        kCieucWeoRieulthieuth                         = 0xc925,
        kCieucWeoRieulphieuph                         = 0xc926,
        kCieucWeoRieulhieuh                         = 0xc927,
        kCieucWeoMieum                         = 0xc928,
        kCieucWeoPieup                         = 0xc929,
        kCieucWeoPieupsios                         = 0xc92a,
        kCieucWeoSios                         = 0xc92b,
        kCieucWeoSsangsios                         = 0xc92c,
        kCieucWeoIeung                         = 0xc92d,
        kCieucWeoCieuc                         = 0xc92e,
        kCieucWeoChieuch                         = 0xc92f,
        kCieucWeoKhieukh                         = 0xc930,
        kCieucWeoThieuth                         = 0xc931,
        kCieucWeoPhieuph                         = 0xc932,
        kCieucWeoHieuh                         = 0xc933,
        kCieucWe                           = 0xc934,
        kCieucWeKiyeok                         = 0xc935,
        kCieucWeSsangkiyeok                         = 0xc936,
        kCieucWeKiyeoksios                         = 0xc937,
        kCieucWeNieun                         = 0xc938,
        kCieucWeNieuncieuc                         = 0xc939,
        kCieucWeNieunhieuh                         = 0xc93a,
        kCieucWeTikeut                         = 0xc93b,
        kCieucWeRieul                         = 0xc93c,
        kCieucWeRieulkiyeok                         = 0xc93d,
        kCieucWeRieulmieum                         = 0xc93e,
        kCieucWeRieulpieup                         = 0xc93f,
        kCieucWeRieulsios                         = 0xc940,
        kCieucWeRieulthieuth                         = 0xc941,
        kCieucWeRieulphieuph                         = 0xc942,
        kCieucWeRieulhieuh                         = 0xc943,
        kCieucWeMieum                         = 0xc944,
        kCieucWePieup                         = 0xc945,
        kCieucWePieupsios                         = 0xc946,
        kCieucWeSios                         = 0xc947,
        kCieucWeSsangsios                         = 0xc948,
        kCieucWeIeung                         = 0xc949,
        kCieucWeCieuc                         = 0xc94a,
        kCieucWeChieuch                         = 0xc94b,
        kCieucWeKhieukh                         = 0xc94c,
        kCieucWeThieuth                         = 0xc94d,
        kCieucWePhieuph                         = 0xc94e,
        kCieucWeHieuh                         = 0xc94f,
        kCieucWi                           = 0xc950,
        kCieucWiKiyeok                         = 0xc951,
        kCieucWiSsangkiyeok                         = 0xc952,
        kCieucWiKiyeoksios                         = 0xc953,
        kCieucWiNieun                         = 0xc954,
        kCieucWiNieuncieuc                         = 0xc955,
        kCieucWiNieunhieuh                         = 0xc956,
        kCieucWiTikeut                         = 0xc957,
        kCieucWiRieul                         = 0xc958,
        kCieucWiRieulkiyeok                         = 0xc959,
        kCieucWiRieulmieum                         = 0xc95a,
        kCieucWiRieulpieup                         = 0xc95b,
        kCieucWiRieulsios                         = 0xc95c,
        kCieucWiRieulthieuth                         = 0xc95d,
        kCieucWiRieulphieuph                         = 0xc95e,
        kCieucWiRieulhieuh                         = 0xc95f,
        kCieucWiMieum                         = 0xc960,
        kCieucWiPieup                         = 0xc961,
        kCieucWiPieupsios                         = 0xc962,
        kCieucWiSios                         = 0xc963,
        kCieucWiSsangsios                         = 0xc964,
        kCieucWiIeung                         = 0xc965,
        kCieucWiCieuc                         = 0xc966,
        kCieucWiChieuch                         = 0xc967,
        kCieucWiKhieukh                         = 0xc968,
        kCieucWiThieuth                         = 0xc969,
        kCieucWiPhieuph                         = 0xc96a,
        kCieucWiHieuh                         = 0xc96b,
        kCieucYu                           = 0xc96c,
        kCieucYuKiyeok                         = 0xc96d,
        kCieucYuSsangkiyeok                         = 0xc96e,
        kCieucYuKiyeoksios                         = 0xc96f,
        kCieucYuNieun                         = 0xc970,
        kCieucYuNieuncieuc                         = 0xc971,
        kCieucYuNieunhieuh                         = 0xc972,
        kCieucYuTikeut                         = 0xc973,
        kCieucYuRieul                         = 0xc974,
        kCieucYuRieulkiyeok                         = 0xc975,
        kCieucYuRieulmieum                         = 0xc976,
        kCieucYuRieulpieup                         = 0xc977,
        kCieucYuRieulsios                         = 0xc978,
        kCieucYuRieulthieuth                         = 0xc979,
        kCieucYuRieulphieuph                         = 0xc97a,
        kCieucYuRieulhieuh                         = 0xc97b,
        kCieucYuMieum                         = 0xc97c,
        kCieucYuPieup                         = 0xc97d,
        kCieucYuPieupsios                         = 0xc97e,
        kCieucYuSios                         = 0xc97f,
        kCieucYuSsangsios                         = 0xc980,
        kCieucYuIeung                         = 0xc981,
        kCieucYuCieuc                         = 0xc982,
        kCieucYuChieuch                         = 0xc983,
        kCieucYuKhieukh                         = 0xc984,
        kCieucYuThieuth                         = 0xc985,
        kCieucYuPhieuph                         = 0xc986,
        kCieucYuHieuh                         = 0xc987,
        kCieucEu                           = 0xc988,
        kCieucEuKiyeok                         = 0xc989,
        kCieucEuSsangkiyeok                         = 0xc98a,
        kCieucEuKiyeoksios                         = 0xc98b,
        kCieucEuNieun                         = 0xc98c,
        kCieucEuNieuncieuc                         = 0xc98d,
        kCieucEuNieunhieuh                         = 0xc98e,
        kCieucEuTikeut                         = 0xc98f,
        kCieucEuRieul                         = 0xc990,
        kCieucEuRieulkiyeok                         = 0xc991,
        kCieucEuRieulmieum                         = 0xc992,
        kCieucEuRieulpieup                         = 0xc993,
        kCieucEuRieulsios                         = 0xc994,
        kCieucEuRieulthieuth                         = 0xc995,
        kCieucEuRieulphieuph                         = 0xc996,
        kCieucEuRieulhieuh                         = 0xc997,
        kCieucEuMieum                         = 0xc998,
        kCieucEuPieup                         = 0xc999,
        kCieucEuPieupsios                         = 0xc99a,
        kCieucEuSios                         = 0xc99b,
        kCieucEuSsangsios                         = 0xc99c,
        kCieucEuIeung                         = 0xc99d,
        kCieucEuCieuc                         = 0xc99e,
        kCieucEuChieuch                         = 0xc99f,
        kCieucEuKhieukh                         = 0xc9a0,
        kCieucEuThieuth                         = 0xc9a1,
        kCieucEuPhieuph                         = 0xc9a2,
        kCieucEuHieuh                         = 0xc9a3,
        kCieucYi                           = 0xc9a4,
        kCieucYiKiyeok                         = 0xc9a5,
        kCieucYiSsangkiyeok                         = 0xc9a6,
        kCieucYiKiyeoksios                         = 0xc9a7,
        kCieucYiNieun                         = 0xc9a8,
        kCieucYiNieuncieuc                         = 0xc9a9,
        kCieucYiNieunhieuh                         = 0xc9aa,
        kCieucYiTikeut                         = 0xc9ab,
        kCieucYiRieul                         = 0xc9ac,
        kCieucYiRieulkiyeok                         = 0xc9ad,
        kCieucYiRieulmieum                         = 0xc9ae,
        kCieucYiRieulpieup                         = 0xc9af,
        kCieucYiRieulsios                         = 0xc9b0,
        kCieucYiRieulthieuth                         = 0xc9b1,
        kCieucYiRieulphieuph                         = 0xc9b2,
        kCieucYiRieulhieuh                         = 0xc9b3,
        kCieucYiMieum                         = 0xc9b4,
        kCieucYiPieup                         = 0xc9b5,
        kCieucYiPieupsios                         = 0xc9b6,
        kCieucYiSios                         = 0xc9b7,
        kCieucYiSsangsios                         = 0xc9b8,
        kCieucYiIeung                         = 0xc9b9,
        kCieucYiCieuc                         = 0xc9ba,
        kCieucYiChieuch                         = 0xc9bb,
        kCieucYiKhieukh                         = 0xc9bc,
        kCieucYiThieuth                         = 0xc9bd,
        kCieucYiPhieuph                         = 0xc9be,
        kCieucYiHieuh                         = 0xc9bf,
        kCieucI                           = 0xc9c0,
        kCieucIKiyeok                         = 0xc9c1,
        kCieucISsangkiyeok                         = 0xc9c2,
        kCieucIKiyeoksios                         = 0xc9c3,
        kCieucINieun                         = 0xc9c4,
        kCieucINieuncieuc                         = 0xc9c5,
        kCieucINieunhieuh                         = 0xc9c6,
        kCieucITikeut                         = 0xc9c7,
        kCieucIRieul                         = 0xc9c8,
        kCieucIRieulkiyeok                         = 0xc9c9,
        kCieucIRieulmieum                         = 0xc9ca,
        kCieucIRieulpieup                         = 0xc9cb,
        kCieucIRieulsios                         = 0xc9cc,
        kCieucIRieulthieuth                         = 0xc9cd,
        kCieucIRieulphieuph                         = 0xc9ce,
        kCieucIRieulhieuh                         = 0xc9cf,
        kCieucIMieum                         = 0xc9d0,
        kCieucIPieup                         = 0xc9d1,
        kCieucIPieupsios                         = 0xc9d2,
        kCieucISios                         = 0xc9d3,
        kCieucISsangsios                         = 0xc9d4,
        kCieucIIeung                         = 0xc9d5,
        kCieucICieuc                         = 0xc9d6,
        kCieucIChieuch                         = 0xc9d7,
        kCieucIKhieukh                         = 0xc9d8,
        kCieucIThieuth                         = 0xc9d9,
        kCieucIPhieuph                         = 0xc9da,
        kCieucIHieuh                         = 0xc9db,
        kSsangcieucA                           = 0xc9dc,
        kSsangcieucAKiyeok                         = 0xc9dd,
        kSsangcieucASsangkiyeok                         = 0xc9de,
        kSsangcieucAKiyeoksios                         = 0xc9df,
        kSsangcieucANieun                         = 0xc9e0,
        kSsangcieucANieuncieuc                         = 0xc9e1,
        kSsangcieucANieunhieuh                         = 0xc9e2,
        kSsangcieucATikeut                         = 0xc9e3,
        kSsangcieucARieul                         = 0xc9e4,
        kSsangcieucARieulkiyeok                         = 0xc9e5,
        kSsangcieucARieulmieum                         = 0xc9e6,
        kSsangcieucARieulpieup                         = 0xc9e7,
        kSsangcieucARieulsios                         = 0xc9e8,
        kSsangcieucARieulthieuth                         = 0xc9e9,
        kSsangcieucARieulphieuph                         = 0xc9ea,
        kSsangcieucARieulhieuh                         = 0xc9eb,
        kSsangcieucAMieum                         = 0xc9ec,
        kSsangcieucAPieup                         = 0xc9ed,
        kSsangcieucAPieupsios                         = 0xc9ee,
        kSsangcieucASios                         = 0xc9ef,
        kSsangcieucASsangsios                         = 0xc9f0,
        kSsangcieucAIeung                         = 0xc9f1,
        kSsangcieucACieuc                         = 0xc9f2,
        kSsangcieucAChieuch                         = 0xc9f3,
        kSsangcieucAKhieukh                         = 0xc9f4,
        kSsangcieucAThieuth                         = 0xc9f5,
        kSsangcieucAPhieuph                         = 0xc9f6,
        kSsangcieucAHieuh                         = 0xc9f7,
        kSsangcieucAe                           = 0xc9f8,
        kSsangcieucAeKiyeok                         = 0xc9f9,
        kSsangcieucAeSsangkiyeok                         = 0xc9fa,
        kSsangcieucAeKiyeoksios                         = 0xc9fb,
        kSsangcieucAeNieun                         = 0xc9fc,
        kSsangcieucAeNieuncieuc                         = 0xc9fd,
        kSsangcieucAeNieunhieuh                         = 0xc9fe,
        kSsangcieucAeTikeut                         = 0xc9ff,
        kSsangcieucAeRieul                         = 0xca00,
        kSsangcieucAeRieulkiyeok                         = 0xca01,
        kSsangcieucAeRieulmieum                         = 0xca02,
        kSsangcieucAeRieulpieup                         = 0xca03,
        kSsangcieucAeRieulsios                         = 0xca04,
        kSsangcieucAeRieulthieuth                         = 0xca05,
        kSsangcieucAeRieulphieuph                         = 0xca06,
        kSsangcieucAeRieulhieuh                         = 0xca07,
        kSsangcieucAeMieum                         = 0xca08,
        kSsangcieucAePieup                         = 0xca09,
        kSsangcieucAePieupsios                         = 0xca0a,
        kSsangcieucAeSios                         = 0xca0b,
        kSsangcieucAeSsangsios                         = 0xca0c,
        kSsangcieucAeIeung                         = 0xca0d,
        kSsangcieucAeCieuc                         = 0xca0e,
        kSsangcieucAeChieuch                         = 0xca0f,
        kSsangcieucAeKhieukh                         = 0xca10,
        kSsangcieucAeThieuth                         = 0xca11,
        kSsangcieucAePhieuph                         = 0xca12,
        kSsangcieucAeHieuh                         = 0xca13,
        kSsangcieucYa                           = 0xca14,
        kSsangcieucYaKiyeok                         = 0xca15,
        kSsangcieucYaSsangkiyeok                         = 0xca16,
        kSsangcieucYaKiyeoksios                         = 0xca17,
        kSsangcieucYaNieun                         = 0xca18,
        kSsangcieucYaNieuncieuc                         = 0xca19,
        kSsangcieucYaNieunhieuh                         = 0xca1a,
        kSsangcieucYaTikeut                         = 0xca1b,
        kSsangcieucYaRieul                         = 0xca1c,
        kSsangcieucYaRieulkiyeok                         = 0xca1d,
        kSsangcieucYaRieulmieum                         = 0xca1e,
        kSsangcieucYaRieulpieup                         = 0xca1f,
        kSsangcieucYaRieulsios                         = 0xca20,
        kSsangcieucYaRieulthieuth                         = 0xca21,
        kSsangcieucYaRieulphieuph                         = 0xca22,
        kSsangcieucYaRieulhieuh                         = 0xca23,
        kSsangcieucYaMieum                         = 0xca24,
        kSsangcieucYaPieup                         = 0xca25,
        kSsangcieucYaPieupsios                         = 0xca26,
        kSsangcieucYaSios                         = 0xca27,
        kSsangcieucYaSsangsios                         = 0xca28,
        kSsangcieucYaIeung                         = 0xca29,
        kSsangcieucYaCieuc                         = 0xca2a,
        kSsangcieucYaChieuch                         = 0xca2b,
        kSsangcieucYaKhieukh                         = 0xca2c,
        kSsangcieucYaThieuth                         = 0xca2d,
        kSsangcieucYaPhieuph                         = 0xca2e,
        kSsangcieucYaHieuh                         = 0xca2f,
        kSsangcieucYae                           = 0xca30,
        kSsangcieucYaeKiyeok                         = 0xca31,
        kSsangcieucYaeSsangkiyeok                         = 0xca32,
        kSsangcieucYaeKiyeoksios                         = 0xca33,
        kSsangcieucYaeNieun                         = 0xca34,
        kSsangcieucYaeNieuncieuc                         = 0xca35,
        kSsangcieucYaeNieunhieuh                         = 0xca36,
        kSsangcieucYaeTikeut                         = 0xca37,
        kSsangcieucYaeRieul                         = 0xca38,
        kSsangcieucYaeRieulkiyeok                         = 0xca39,
        kSsangcieucYaeRieulmieum                         = 0xca3a,
        kSsangcieucYaeRieulpieup                         = 0xca3b,
        kSsangcieucYaeRieulsios                         = 0xca3c,
        kSsangcieucYaeRieulthieuth                         = 0xca3d,
        kSsangcieucYaeRieulphieuph                         = 0xca3e,
        kSsangcieucYaeRieulhieuh                         = 0xca3f,
        kSsangcieucYaeMieum                         = 0xca40,
        kSsangcieucYaePieup                         = 0xca41,
        kSsangcieucYaePieupsios                         = 0xca42,
        kSsangcieucYaeSios                         = 0xca43,
        kSsangcieucYaeSsangsios                         = 0xca44,
        kSsangcieucYaeIeung                         = 0xca45,
        kSsangcieucYaeCieuc                         = 0xca46,
        kSsangcieucYaeChieuch                         = 0xca47,
        kSsangcieucYaeKhieukh                         = 0xca48,
        kSsangcieucYaeThieuth                         = 0xca49,
        kSsangcieucYaePhieuph                         = 0xca4a,
        kSsangcieucYaeHieuh                         = 0xca4b,
        kSsangcieucEo                           = 0xca4c,
        kSsangcieucEoKiyeok                         = 0xca4d,
        kSsangcieucEoSsangkiyeok                         = 0xca4e,
        kSsangcieucEoKiyeoksios                         = 0xca4f,
        kSsangcieucEoNieun                         = 0xca50,
        kSsangcieucEoNieuncieuc                         = 0xca51,
        kSsangcieucEoNieunhieuh                         = 0xca52,
        kSsangcieucEoTikeut                         = 0xca53,
        kSsangcieucEoRieul                         = 0xca54,
        kSsangcieucEoRieulkiyeok                         = 0xca55,
        kSsangcieucEoRieulmieum                         = 0xca56,
        kSsangcieucEoRieulpieup                         = 0xca57,
        kSsangcieucEoRieulsios                         = 0xca58,
        kSsangcieucEoRieulthieuth                         = 0xca59,
        kSsangcieucEoRieulphieuph                         = 0xca5a,
        kSsangcieucEoRieulhieuh                         = 0xca5b,
        kSsangcieucEoMieum                         = 0xca5c,
        kSsangcieucEoPieup                         = 0xca5d,
        kSsangcieucEoPieupsios                         = 0xca5e,
        kSsangcieucEoSios                         = 0xca5f,
        kSsangcieucEoSsangsios                         = 0xca60,
        kSsangcieucEoIeung                         = 0xca61,
        kSsangcieucEoCieuc                         = 0xca62,
        kSsangcieucEoChieuch                         = 0xca63,
        kSsangcieucEoKhieukh                         = 0xca64,
        kSsangcieucEoThieuth                         = 0xca65,
        kSsangcieucEoPhieuph                         = 0xca66,
        kSsangcieucEoHieuh                         = 0xca67,
        kSsangcieucE                           = 0xca68,
        kSsangcieucEKiyeok                         = 0xca69,
        kSsangcieucESsangkiyeok                         = 0xca6a,
        kSsangcieucEKiyeoksios                         = 0xca6b,
        kSsangcieucENieun                         = 0xca6c,
        kSsangcieucENieuncieuc                         = 0xca6d,
        kSsangcieucENieunhieuh                         = 0xca6e,
        kSsangcieucETikeut                         = 0xca6f,
        kSsangcieucERieul                         = 0xca70,
        kSsangcieucERieulkiyeok                         = 0xca71,
        kSsangcieucERieulmieum                         = 0xca72,
        kSsangcieucERieulpieup                         = 0xca73,
        kSsangcieucERieulsios                         = 0xca74,
        kSsangcieucERieulthieuth                         = 0xca75,
        kSsangcieucERieulphieuph                         = 0xca76,
        kSsangcieucERieulhieuh                         = 0xca77,
        kSsangcieucEMieum                         = 0xca78,
        kSsangcieucEPieup                         = 0xca79,
        kSsangcieucEPieupsios                         = 0xca7a,
        kSsangcieucESios                         = 0xca7b,
        kSsangcieucESsangsios                         = 0xca7c,
        kSsangcieucEIeung                         = 0xca7d,
        kSsangcieucECieuc                         = 0xca7e,
        kSsangcieucEChieuch                         = 0xca7f,
        kSsangcieucEKhieukh                         = 0xca80,
        kSsangcieucEThieuth                         = 0xca81,
        kSsangcieucEPhieuph                         = 0xca82,
        kSsangcieucEHieuh                         = 0xca83,
        kSsangcieucYeo                           = 0xca84,
        kSsangcieucYeoKiyeok                         = 0xca85,
        kSsangcieucYeoSsangkiyeok                         = 0xca86,
        kSsangcieucYeoKiyeoksios                         = 0xca87,
        kSsangcieucYeoNieun                         = 0xca88,
        kSsangcieucYeoNieuncieuc                         = 0xca89,
        kSsangcieucYeoNieunhieuh                         = 0xca8a,
        kSsangcieucYeoTikeut                         = 0xca8b,
        kSsangcieucYeoRieul                         = 0xca8c,
        kSsangcieucYeoRieulkiyeok                         = 0xca8d,
        kSsangcieucYeoRieulmieum                         = 0xca8e,
        kSsangcieucYeoRieulpieup                         = 0xca8f,
        kSsangcieucYeoRieulsios                         = 0xca90,
        kSsangcieucYeoRieulthieuth                         = 0xca91,
        kSsangcieucYeoRieulphieuph                         = 0xca92,
        kSsangcieucYeoRieulhieuh                         = 0xca93,
        kSsangcieucYeoMieum                         = 0xca94,
        kSsangcieucYeoPieup                         = 0xca95,
        kSsangcieucYeoPieupsios                         = 0xca96,
        kSsangcieucYeoSios                         = 0xca97,
        kSsangcieucYeoSsangsios                         = 0xca98,
        kSsangcieucYeoIeung                         = 0xca99,
        kSsangcieucYeoCieuc                         = 0xca9a,
        kSsangcieucYeoChieuch                         = 0xca9b,
        kSsangcieucYeoKhieukh                         = 0xca9c,
        kSsangcieucYeoThieuth                         = 0xca9d,
        kSsangcieucYeoPhieuph                         = 0xca9e,
        kSsangcieucYeoHieuh                         = 0xca9f,
        kSsangcieucYe                           = 0xcaa0,
        kSsangcieucYeKiyeok                         = 0xcaa1,
        kSsangcieucYeSsangkiyeok                         = 0xcaa2,
        kSsangcieucYeKiyeoksios                         = 0xcaa3,
        kSsangcieucYeNieun                         = 0xcaa4,
        kSsangcieucYeNieuncieuc                         = 0xcaa5,
        kSsangcieucYeNieunhieuh                         = 0xcaa6,
        kSsangcieucYeTikeut                         = 0xcaa7,
        kSsangcieucYeRieul                         = 0xcaa8,
        kSsangcieucYeRieulkiyeok                         = 0xcaa9,
        kSsangcieucYeRieulmieum                         = 0xcaaa,
        kSsangcieucYeRieulpieup                         = 0xcaab,
        kSsangcieucYeRieulsios                         = 0xcaac,
        kSsangcieucYeRieulthieuth                         = 0xcaad,
        kSsangcieucYeRieulphieuph                         = 0xcaae,
        kSsangcieucYeRieulhieuh                         = 0xcaaf,
        kSsangcieucYeMieum                         = 0xcab0,
        kSsangcieucYePieup                         = 0xcab1,
        kSsangcieucYePieupsios                         = 0xcab2,
        kSsangcieucYeSios                         = 0xcab3,
        kSsangcieucYeSsangsios                         = 0xcab4,
        kSsangcieucYeIeung                         = 0xcab5,
        kSsangcieucYeCieuc                         = 0xcab6,
        kSsangcieucYeChieuch                         = 0xcab7,
        kSsangcieucYeKhieukh                         = 0xcab8,
        kSsangcieucYeThieuth                         = 0xcab9,
        kSsangcieucYePhieuph                         = 0xcaba,
        kSsangcieucYeHieuh                         = 0xcabb,
        kSsangcieucO                           = 0xcabc,
        kSsangcieucOKiyeok                         = 0xcabd,
        kSsangcieucOSsangkiyeok                         = 0xcabe,
        kSsangcieucOKiyeoksios                         = 0xcabf,
        kSsangcieucONieun                         = 0xcac0,
        kSsangcieucONieuncieuc                         = 0xcac1,
        kSsangcieucONieunhieuh                         = 0xcac2,
        kSsangcieucOTikeut                         = 0xcac3,
        kSsangcieucORieul                         = 0xcac4,
        kSsangcieucORieulkiyeok                         = 0xcac5,
        kSsangcieucORieulmieum                         = 0xcac6,
        kSsangcieucORieulpieup                         = 0xcac7,
        kSsangcieucORieulsios                         = 0xcac8,
        kSsangcieucORieulthieuth                         = 0xcac9,
        kSsangcieucORieulphieuph                         = 0xcaca,
        kSsangcieucORieulhieuh                         = 0xcacb,
        kSsangcieucOMieum                         = 0xcacc,
        kSsangcieucOPieup                         = 0xcacd,
        kSsangcieucOPieupsios                         = 0xcace,
        kSsangcieucOSios                         = 0xcacf,
        kSsangcieucOSsangsios                         = 0xcad0,
        kSsangcieucOIeung                         = 0xcad1,
        kSsangcieucOCieuc                         = 0xcad2,
        kSsangcieucOChieuch                         = 0xcad3,
        kSsangcieucOKhieukh                         = 0xcad4,
        kSsangcieucOThieuth                         = 0xcad5,
        kSsangcieucOPhieuph                         = 0xcad6,
        kSsangcieucOHieuh                         = 0xcad7,
        kSsangcieucWa                           = 0xcad8,
        kSsangcieucWaKiyeok                         = 0xcad9,
        kSsangcieucWaSsangkiyeok                         = 0xcada,
        kSsangcieucWaKiyeoksios                         = 0xcadb,
        kSsangcieucWaNieun                         = 0xcadc,
        kSsangcieucWaNieuncieuc                         = 0xcadd,
        kSsangcieucWaNieunhieuh                         = 0xcade,
        kSsangcieucWaTikeut                         = 0xcadf,
        kSsangcieucWaRieul                         = 0xcae0,
        kSsangcieucWaRieulkiyeok                         = 0xcae1,
        kSsangcieucWaRieulmieum                         = 0xcae2,
        kSsangcieucWaRieulpieup                         = 0xcae3,
        kSsangcieucWaRieulsios                         = 0xcae4,
        kSsangcieucWaRieulthieuth                         = 0xcae5,
        kSsangcieucWaRieulphieuph                         = 0xcae6,
        kSsangcieucWaRieulhieuh                         = 0xcae7,
        kSsangcieucWaMieum                         = 0xcae8,
        kSsangcieucWaPieup                         = 0xcae9,
        kSsangcieucWaPieupsios                         = 0xcaea,
        kSsangcieucWaSios                         = 0xcaeb,
        kSsangcieucWaSsangsios                         = 0xcaec,
        kSsangcieucWaIeung                         = 0xcaed,
        kSsangcieucWaCieuc                         = 0xcaee,
        kSsangcieucWaChieuch                         = 0xcaef,
        kSsangcieucWaKhieukh                         = 0xcaf0,
        kSsangcieucWaThieuth                         = 0xcaf1,
        kSsangcieucWaPhieuph                         = 0xcaf2,
        kSsangcieucWaHieuh                         = 0xcaf3,
        kSsangcieucWae                           = 0xcaf4,
        kSsangcieucWaeKiyeok                         = 0xcaf5,
        kSsangcieucWaeSsangkiyeok                         = 0xcaf6,
        kSsangcieucWaeKiyeoksios                         = 0xcaf7,
        kSsangcieucWaeNieun                         = 0xcaf8,
        kSsangcieucWaeNieuncieuc                         = 0xcaf9,
        kSsangcieucWaeNieunhieuh                         = 0xcafa,
        kSsangcieucWaeTikeut                         = 0xcafb,
        kSsangcieucWaeRieul                         = 0xcafc,
        kSsangcieucWaeRieulkiyeok                         = 0xcafd,
        kSsangcieucWaeRieulmieum                         = 0xcafe,
        kSsangcieucWaeRieulpieup                         = 0xcaff,
        kSsangcieucWaeRieulsios                         = 0xcb00,
        kSsangcieucWaeRieulthieuth                         = 0xcb01,
        kSsangcieucWaeRieulphieuph                         = 0xcb02,
        kSsangcieucWaeRieulhieuh                         = 0xcb03,
        kSsangcieucWaeMieum                         = 0xcb04,
        kSsangcieucWaePieup                         = 0xcb05,
        kSsangcieucWaePieupsios                         = 0xcb06,
        kSsangcieucWaeSios                         = 0xcb07,
        kSsangcieucWaeSsangsios                         = 0xcb08,
        kSsangcieucWaeIeung                         = 0xcb09,
        kSsangcieucWaeCieuc                         = 0xcb0a,
        kSsangcieucWaeChieuch                         = 0xcb0b,
        kSsangcieucWaeKhieukh                         = 0xcb0c,
        kSsangcieucWaeThieuth                         = 0xcb0d,
        kSsangcieucWaePhieuph                         = 0xcb0e,
        kSsangcieucWaeHieuh                         = 0xcb0f,
        kSsangcieucOe                           = 0xcb10,
        kSsangcieucOeKiyeok                         = 0xcb11,
        kSsangcieucOeSsangkiyeok                         = 0xcb12,
        kSsangcieucOeKiyeoksios                         = 0xcb13,
        kSsangcieucOeNieun                         = 0xcb14,
        kSsangcieucOeNieuncieuc                         = 0xcb15,
        kSsangcieucOeNieunhieuh                         = 0xcb16,
        kSsangcieucOeTikeut                         = 0xcb17,
        kSsangcieucOeRieul                         = 0xcb18,
        kSsangcieucOeRieulkiyeok                         = 0xcb19,
        kSsangcieucOeRieulmieum                         = 0xcb1a,
        kSsangcieucOeRieulpieup                         = 0xcb1b,
        kSsangcieucOeRieulsios                         = 0xcb1c,
        kSsangcieucOeRieulthieuth                         = 0xcb1d,
        kSsangcieucOeRieulphieuph                         = 0xcb1e,
        kSsangcieucOeRieulhieuh                         = 0xcb1f,
        kSsangcieucOeMieum                         = 0xcb20,
        kSsangcieucOePieup                         = 0xcb21,
        kSsangcieucOePieupsios                         = 0xcb22,
        kSsangcieucOeSios                         = 0xcb23,
        kSsangcieucOeSsangsios                         = 0xcb24,
        kSsangcieucOeIeung                         = 0xcb25,
        kSsangcieucOeCieuc                         = 0xcb26,
        kSsangcieucOeChieuch                         = 0xcb27,
        kSsangcieucOeKhieukh                         = 0xcb28,
        kSsangcieucOeThieuth                         = 0xcb29,
        kSsangcieucOePhieuph                         = 0xcb2a,
        kSsangcieucOeHieuh                         = 0xcb2b,
        kSsangcieucYo                           = 0xcb2c,
        kSsangcieucYoKiyeok                         = 0xcb2d,
        kSsangcieucYoSsangkiyeok                         = 0xcb2e,
        kSsangcieucYoKiyeoksios                         = 0xcb2f,
        kSsangcieucYoNieun                         = 0xcb30,
        kSsangcieucYoNieuncieuc                         = 0xcb31,
        kSsangcieucYoNieunhieuh                         = 0xcb32,
        kSsangcieucYoTikeut                         = 0xcb33,
        kSsangcieucYoRieul                         = 0xcb34,
        kSsangcieucYoRieulkiyeok                         = 0xcb35,
        kSsangcieucYoRieulmieum                         = 0xcb36,
        kSsangcieucYoRieulpieup                         = 0xcb37,
        kSsangcieucYoRieulsios                         = 0xcb38,
        kSsangcieucYoRieulthieuth                         = 0xcb39,
        kSsangcieucYoRieulphieuph                         = 0xcb3a,
        kSsangcieucYoRieulhieuh                         = 0xcb3b,
        kSsangcieucYoMieum                         = 0xcb3c,
        kSsangcieucYoPieup                         = 0xcb3d,
        kSsangcieucYoPieupsios                         = 0xcb3e,
        kSsangcieucYoSios                         = 0xcb3f,
        kSsangcieucYoSsangsios                         = 0xcb40,
        kSsangcieucYoIeung                         = 0xcb41,
        kSsangcieucYoCieuc                         = 0xcb42,
        kSsangcieucYoChieuch                         = 0xcb43,
        kSsangcieucYoKhieukh                         = 0xcb44,
        kSsangcieucYoThieuth                         = 0xcb45,
        kSsangcieucYoPhieuph                         = 0xcb46,
        kSsangcieucYoHieuh                         = 0xcb47,
        kSsangcieucU                           = 0xcb48,
        kSsangcieucUKiyeok                         = 0xcb49,
        kSsangcieucUSsangkiyeok                         = 0xcb4a,
        kSsangcieucUKiyeoksios                         = 0xcb4b,
        kSsangcieucUNieun                         = 0xcb4c,
        kSsangcieucUNieuncieuc                         = 0xcb4d,
        kSsangcieucUNieunhieuh                         = 0xcb4e,
        kSsangcieucUTikeut                         = 0xcb4f,
        kSsangcieucURieul                         = 0xcb50,
        kSsangcieucURieulkiyeok                         = 0xcb51,
        kSsangcieucURieulmieum                         = 0xcb52,
        kSsangcieucURieulpieup                         = 0xcb53,
        kSsangcieucURieulsios                         = 0xcb54,
        kSsangcieucURieulthieuth                         = 0xcb55,
        kSsangcieucURieulphieuph                         = 0xcb56,
        kSsangcieucURieulhieuh                         = 0xcb57,
        kSsangcieucUMieum                         = 0xcb58,
        kSsangcieucUPieup                         = 0xcb59,
        kSsangcieucUPieupsios                         = 0xcb5a,
        kSsangcieucUSios                         = 0xcb5b,
        kSsangcieucUSsangsios                         = 0xcb5c,
        kSsangcieucUIeung                         = 0xcb5d,
        kSsangcieucUCieuc                         = 0xcb5e,
        kSsangcieucUChieuch                         = 0xcb5f,
        kSsangcieucUKhieukh                         = 0xcb60,
        kSsangcieucUThieuth                         = 0xcb61,
        kSsangcieucUPhieuph                         = 0xcb62,
        kSsangcieucUHieuh                         = 0xcb63,
        kSsangcieucWeo                           = 0xcb64,
        kSsangcieucWeoKiyeok                         = 0xcb65,
        kSsangcieucWeoSsangkiyeok                         = 0xcb66,
        kSsangcieucWeoKiyeoksios                         = 0xcb67,
        kSsangcieucWeoNieun                         = 0xcb68,
        kSsangcieucWeoNieuncieuc                         = 0xcb69,
        kSsangcieucWeoNieunhieuh                         = 0xcb6a,
        kSsangcieucWeoTikeut                         = 0xcb6b,
        kSsangcieucWeoRieul                         = 0xcb6c,
        kSsangcieucWeoRieulkiyeok                         = 0xcb6d,
        kSsangcieucWeoRieulmieum                         = 0xcb6e,
        kSsangcieucWeoRieulpieup                         = 0xcb6f,
        kSsangcieucWeoRieulsios                         = 0xcb70,
        kSsangcieucWeoRieulthieuth                         = 0xcb71,
        kSsangcieucWeoRieulphieuph                         = 0xcb72,
        kSsangcieucWeoRieulhieuh                         = 0xcb73,
        kSsangcieucWeoMieum                         = 0xcb74,
        kSsangcieucWeoPieup                         = 0xcb75,
        kSsangcieucWeoPieupsios                         = 0xcb76,
        kSsangcieucWeoSios                         = 0xcb77,
        kSsangcieucWeoSsangsios                         = 0xcb78,
        kSsangcieucWeoIeung                         = 0xcb79,
        kSsangcieucWeoCieuc                         = 0xcb7a,
        kSsangcieucWeoChieuch                         = 0xcb7b,
        kSsangcieucWeoKhieukh                         = 0xcb7c,
        kSsangcieucWeoThieuth                         = 0xcb7d,
        kSsangcieucWeoPhieuph                         = 0xcb7e,
        kSsangcieucWeoHieuh                         = 0xcb7f,
        kSsangcieucWe                           = 0xcb80,
        kSsangcieucWeKiyeok                         = 0xcb81,
        kSsangcieucWeSsangkiyeok                         = 0xcb82,
        kSsangcieucWeKiyeoksios                         = 0xcb83,
        kSsangcieucWeNieun                         = 0xcb84,
        kSsangcieucWeNieuncieuc                         = 0xcb85,
        kSsangcieucWeNieunhieuh                         = 0xcb86,
        kSsangcieucWeTikeut                         = 0xcb87,
        kSsangcieucWeRieul                         = 0xcb88,
        kSsangcieucWeRieulkiyeok                         = 0xcb89,
        kSsangcieucWeRieulmieum                         = 0xcb8a,
        kSsangcieucWeRieulpieup                         = 0xcb8b,
        kSsangcieucWeRieulsios                         = 0xcb8c,
        kSsangcieucWeRieulthieuth                         = 0xcb8d,
        kSsangcieucWeRieulphieuph                         = 0xcb8e,
        kSsangcieucWeRieulhieuh                         = 0xcb8f,
        kSsangcieucWeMieum                         = 0xcb90,
        kSsangcieucWePieup                         = 0xcb91,
        kSsangcieucWePieupsios                         = 0xcb92,
        kSsangcieucWeSios                         = 0xcb93,
        kSsangcieucWeSsangsios                         = 0xcb94,
        kSsangcieucWeIeung                         = 0xcb95,
        kSsangcieucWeCieuc                         = 0xcb96,
        kSsangcieucWeChieuch                         = 0xcb97,
        kSsangcieucWeKhieukh                         = 0xcb98,
        kSsangcieucWeThieuth                         = 0xcb99,
        kSsangcieucWePhieuph                         = 0xcb9a,
        kSsangcieucWeHieuh                         = 0xcb9b,
        kSsangcieucWi                           = 0xcb9c,
        kSsangcieucWiKiyeok                         = 0xcb9d,
        kSsangcieucWiSsangkiyeok                         = 0xcb9e,
        kSsangcieucWiKiyeoksios                         = 0xcb9f,
        kSsangcieucWiNieun                         = 0xcba0,
        kSsangcieucWiNieuncieuc                         = 0xcba1,
        kSsangcieucWiNieunhieuh                         = 0xcba2,
        kSsangcieucWiTikeut                         = 0xcba3,
        kSsangcieucWiRieul                         = 0xcba4,
        kSsangcieucWiRieulkiyeok                         = 0xcba5,
        kSsangcieucWiRieulmieum                         = 0xcba6,
        kSsangcieucWiRieulpieup                         = 0xcba7,
        kSsangcieucWiRieulsios                         = 0xcba8,
        kSsangcieucWiRieulthieuth                         = 0xcba9,
        kSsangcieucWiRieulphieuph                         = 0xcbaa,
        kSsangcieucWiRieulhieuh                         = 0xcbab,
        kSsangcieucWiMieum                         = 0xcbac,
        kSsangcieucWiPieup                         = 0xcbad,
        kSsangcieucWiPieupsios                         = 0xcbae,
        kSsangcieucWiSios                         = 0xcbaf,
        kSsangcieucWiSsangsios                         = 0xcbb0,
        kSsangcieucWiIeung                         = 0xcbb1,
        kSsangcieucWiCieuc                         = 0xcbb2,
        kSsangcieucWiChieuch                         = 0xcbb3,
        kSsangcieucWiKhieukh                         = 0xcbb4,
        kSsangcieucWiThieuth                         = 0xcbb5,
        kSsangcieucWiPhieuph                         = 0xcbb6,
        kSsangcieucWiHieuh                         = 0xcbb7,
        kSsangcieucYu                           = 0xcbb8,
        kSsangcieucYuKiyeok                         = 0xcbb9,
        kSsangcieucYuSsangkiyeok                         = 0xcbba,
        kSsangcieucYuKiyeoksios                         = 0xcbbb,
        kSsangcieucYuNieun                         = 0xcbbc,
        kSsangcieucYuNieuncieuc                         = 0xcbbd,
        kSsangcieucYuNieunhieuh                         = 0xcbbe,
        kSsangcieucYuTikeut                         = 0xcbbf,
        kSsangcieucYuRieul                         = 0xcbc0,
        kSsangcieucYuRieulkiyeok                         = 0xcbc1,
        kSsangcieucYuRieulmieum                         = 0xcbc2,
        kSsangcieucYuRieulpieup                         = 0xcbc3,
        kSsangcieucYuRieulsios                         = 0xcbc4,
        kSsangcieucYuRieulthieuth                         = 0xcbc5,
        kSsangcieucYuRieulphieuph                         = 0xcbc6,
        kSsangcieucYuRieulhieuh                         = 0xcbc7,
        kSsangcieucYuMieum                         = 0xcbc8,
        kSsangcieucYuPieup                         = 0xcbc9,
        kSsangcieucYuPieupsios                         = 0xcbca,
        kSsangcieucYuSios                         = 0xcbcb,
        kSsangcieucYuSsangsios                         = 0xcbcc,
        kSsangcieucYuIeung                         = 0xcbcd,
        kSsangcieucYuCieuc                         = 0xcbce,
        kSsangcieucYuChieuch                         = 0xcbcf,
        kSsangcieucYuKhieukh                         = 0xcbd0,
        kSsangcieucYuThieuth                         = 0xcbd1,
        kSsangcieucYuPhieuph                         = 0xcbd2,
        kSsangcieucYuHieuh                         = 0xcbd3,
        kSsangcieucEu                           = 0xcbd4,
        kSsangcieucEuKiyeok                         = 0xcbd5,
        kSsangcieucEuSsangkiyeok                         = 0xcbd6,
        kSsangcieucEuKiyeoksios                         = 0xcbd7,
        kSsangcieucEuNieun                         = 0xcbd8,
        kSsangcieucEuNieuncieuc                         = 0xcbd9,
        kSsangcieucEuNieunhieuh                         = 0xcbda,
        kSsangcieucEuTikeut                         = 0xcbdb,
        kSsangcieucEuRieul                         = 0xcbdc,
        kSsangcieucEuRieulkiyeok                         = 0xcbdd,
        kSsangcieucEuRieulmieum                         = 0xcbde,
        kSsangcieucEuRieulpieup                         = 0xcbdf,
        kSsangcieucEuRieulsios                         = 0xcbe0,
        kSsangcieucEuRieulthieuth                         = 0xcbe1,
        kSsangcieucEuRieulphieuph                         = 0xcbe2,
        kSsangcieucEuRieulhieuh                         = 0xcbe3,
        kSsangcieucEuMieum                         = 0xcbe4,
        kSsangcieucEuPieup                         = 0xcbe5,
        kSsangcieucEuPieupsios                         = 0xcbe6,
        kSsangcieucEuSios                         = 0xcbe7,
        kSsangcieucEuSsangsios                         = 0xcbe8,
        kSsangcieucEuIeung                         = 0xcbe9,
        kSsangcieucEuCieuc                         = 0xcbea,
        kSsangcieucEuChieuch                         = 0xcbeb,
        kSsangcieucEuKhieukh                         = 0xcbec,
        kSsangcieucEuThieuth                         = 0xcbed,
        kSsangcieucEuPhieuph                         = 0xcbee,
        kSsangcieucEuHieuh                         = 0xcbef,
        kSsangcieucYi                           = 0xcbf0,
        kSsangcieucYiKiyeok                         = 0xcbf1,
        kSsangcieucYiSsangkiyeok                         = 0xcbf2,
        kSsangcieucYiKiyeoksios                         = 0xcbf3,
        kSsangcieucYiNieun                         = 0xcbf4,
        kSsangcieucYiNieuncieuc                         = 0xcbf5,
        kSsangcieucYiNieunhieuh                         = 0xcbf6,
        kSsangcieucYiTikeut                         = 0xcbf7,
        kSsangcieucYiRieul                         = 0xcbf8,
        kSsangcieucYiRieulkiyeok                         = 0xcbf9,
        kSsangcieucYiRieulmieum                         = 0xcbfa,
        kSsangcieucYiRieulpieup                         = 0xcbfb,
        kSsangcieucYiRieulsios                         = 0xcbfc,
        kSsangcieucYiRieulthieuth                         = 0xcbfd,
        kSsangcieucYiRieulphieuph                         = 0xcbfe,
        kSsangcieucYiRieulhieuh                         = 0xcbff,
        kSsangcieucYiMieum                         = 0xcc00,
        kSsangcieucYiPieup                         = 0xcc01,
        kSsangcieucYiPieupsios                         = 0xcc02,
        kSsangcieucYiSios                         = 0xcc03,
        kSsangcieucYiSsangsios                         = 0xcc04,
        kSsangcieucYiIeung                         = 0xcc05,
        kSsangcieucYiCieuc                         = 0xcc06,
        kSsangcieucYiChieuch                         = 0xcc07,
        kSsangcieucYiKhieukh                         = 0xcc08,
        kSsangcieucYiThieuth                         = 0xcc09,
        kSsangcieucYiPhieuph                         = 0xcc0a,
        kSsangcieucYiHieuh                         = 0xcc0b,
        kSsangcieucI                           = 0xcc0c,
        kSsangcieucIKiyeok                         = 0xcc0d,
        kSsangcieucISsangkiyeok                         = 0xcc0e,
        kSsangcieucIKiyeoksios                         = 0xcc0f,
        kSsangcieucINieun                         = 0xcc10,
        kSsangcieucINieuncieuc                         = 0xcc11,
        kSsangcieucINieunhieuh                         = 0xcc12,
        kSsangcieucITikeut                         = 0xcc13,
        kSsangcieucIRieul                         = 0xcc14,
        kSsangcieucIRieulkiyeok                         = 0xcc15,
        kSsangcieucIRieulmieum                         = 0xcc16,
        kSsangcieucIRieulpieup                         = 0xcc17,
        kSsangcieucIRieulsios                         = 0xcc18,
        kSsangcieucIRieulthieuth                         = 0xcc19,
        kSsangcieucIRieulphieuph                         = 0xcc1a,
        kSsangcieucIRieulhieuh                         = 0xcc1b,
        kSsangcieucIMieum                         = 0xcc1c,
        kSsangcieucIPieup                         = 0xcc1d,
        kSsangcieucIPieupsios                         = 0xcc1e,
        kSsangcieucISios                         = 0xcc1f,
        kSsangcieucISsangsios                         = 0xcc20,
        kSsangcieucIIeung                         = 0xcc21,
        kSsangcieucICieuc                         = 0xcc22,
        kSsangcieucIChieuch                         = 0xcc23,
        kSsangcieucIKhieukh                         = 0xcc24,
        kSsangcieucIThieuth                         = 0xcc25,
        kSsangcieucIPhieuph                         = 0xcc26,
        kSsangcieucIHieuh                         = 0xcc27,
        kChieuchA                           = 0xcc28,
        kChieuchAKiyeok                         = 0xcc29,
        kChieuchASsangkiyeok                         = 0xcc2a,
        kChieuchAKiyeoksios                         = 0xcc2b,
        kChieuchANieun                         = 0xcc2c,
        kChieuchANieuncieuc                         = 0xcc2d,
        kChieuchANieunhieuh                         = 0xcc2e,
        kChieuchATikeut                         = 0xcc2f,
        kChieuchARieul                         = 0xcc30,
        kChieuchARieulkiyeok                         = 0xcc31,
        kChieuchARieulmieum                         = 0xcc32,
        kChieuchARieulpieup                         = 0xcc33,
        kChieuchARieulsios                         = 0xcc34,
        kChieuchARieulthieuth                         = 0xcc35,
        kChieuchARieulphieuph                         = 0xcc36,
        kChieuchARieulhieuh                         = 0xcc37,
        kChieuchAMieum                         = 0xcc38,
        kChieuchAPieup                         = 0xcc39,
        kChieuchAPieupsios                         = 0xcc3a,
        kChieuchASios                         = 0xcc3b,
        kChieuchASsangsios                         = 0xcc3c,
        kChieuchAIeung                         = 0xcc3d,
        kChieuchACieuc                         = 0xcc3e,
        kChieuchAChieuch                         = 0xcc3f,
        kChieuchAKhieukh                         = 0xcc40,
        kChieuchAThieuth                         = 0xcc41,
        kChieuchAPhieuph                         = 0xcc42,
        kChieuchAHieuh                         = 0xcc43,
        kChieuchAe                           = 0xcc44,
        kChieuchAeKiyeok                         = 0xcc45,
        kChieuchAeSsangkiyeok                         = 0xcc46,
        kChieuchAeKiyeoksios                         = 0xcc47,
        kChieuchAeNieun                         = 0xcc48,
        kChieuchAeNieuncieuc                         = 0xcc49,
        kChieuchAeNieunhieuh                         = 0xcc4a,
        kChieuchAeTikeut                         = 0xcc4b,
        kChieuchAeRieul                         = 0xcc4c,
        kChieuchAeRieulkiyeok                         = 0xcc4d,
        kChieuchAeRieulmieum                         = 0xcc4e,
        kChieuchAeRieulpieup                         = 0xcc4f,
        kChieuchAeRieulsios                         = 0xcc50,
        kChieuchAeRieulthieuth                         = 0xcc51,
        kChieuchAeRieulphieuph                         = 0xcc52,
        kChieuchAeRieulhieuh                         = 0xcc53,
        kChieuchAeMieum                         = 0xcc54,
        kChieuchAePieup                         = 0xcc55,
        kChieuchAePieupsios                         = 0xcc56,
        kChieuchAeSios                         = 0xcc57,
        kChieuchAeSsangsios                         = 0xcc58,
        kChieuchAeIeung                         = 0xcc59,
        kChieuchAeCieuc                         = 0xcc5a,
        kChieuchAeChieuch                         = 0xcc5b,
        kChieuchAeKhieukh                         = 0xcc5c,
        kChieuchAeThieuth                         = 0xcc5d,
        kChieuchAePhieuph                         = 0xcc5e,
        kChieuchAeHieuh                         = 0xcc5f,
        kChieuchYa                           = 0xcc60,
        kChieuchYaKiyeok                         = 0xcc61,
        kChieuchYaSsangkiyeok                         = 0xcc62,
        kChieuchYaKiyeoksios                         = 0xcc63,
        kChieuchYaNieun                         = 0xcc64,
        kChieuchYaNieuncieuc                         = 0xcc65,
        kChieuchYaNieunhieuh                         = 0xcc66,
        kChieuchYaTikeut                         = 0xcc67,
        kChieuchYaRieul                         = 0xcc68,
        kChieuchYaRieulkiyeok                         = 0xcc69,
        kChieuchYaRieulmieum                         = 0xcc6a,
        kChieuchYaRieulpieup                         = 0xcc6b,
        kChieuchYaRieulsios                         = 0xcc6c,
        kChieuchYaRieulthieuth                         = 0xcc6d,
        kChieuchYaRieulphieuph                         = 0xcc6e,
        kChieuchYaRieulhieuh                         = 0xcc6f,
        kChieuchYaMieum                         = 0xcc70,
        kChieuchYaPieup                         = 0xcc71,
        kChieuchYaPieupsios                         = 0xcc72,
        kChieuchYaSios                         = 0xcc73,
        kChieuchYaSsangsios                         = 0xcc74,
        kChieuchYaIeung                         = 0xcc75,
        kChieuchYaCieuc                         = 0xcc76,
        kChieuchYaChieuch                         = 0xcc77,
        kChieuchYaKhieukh                         = 0xcc78,
        kChieuchYaThieuth                         = 0xcc79,
        kChieuchYaPhieuph                         = 0xcc7a,
        kChieuchYaHieuh                         = 0xcc7b,
        kChieuchYae                           = 0xcc7c,
        kChieuchYaeKiyeok                         = 0xcc7d,
        kChieuchYaeSsangkiyeok                         = 0xcc7e,
        kChieuchYaeKiyeoksios                         = 0xcc7f,
        kChieuchYaeNieun                         = 0xcc80,
        kChieuchYaeNieuncieuc                         = 0xcc81,
        kChieuchYaeNieunhieuh                         = 0xcc82,
        kChieuchYaeTikeut                         = 0xcc83,
        kChieuchYaeRieul                         = 0xcc84,
        kChieuchYaeRieulkiyeok                         = 0xcc85,
        kChieuchYaeRieulmieum                         = 0xcc86,
        kChieuchYaeRieulpieup                         = 0xcc87,
        kChieuchYaeRieulsios                         = 0xcc88,
        kChieuchYaeRieulthieuth                         = 0xcc89,
        kChieuchYaeRieulphieuph                         = 0xcc8a,
        kChieuchYaeRieulhieuh                         = 0xcc8b,
        kChieuchYaeMieum                         = 0xcc8c,
        kChieuchYaePieup                         = 0xcc8d,
        kChieuchYaePieupsios                         = 0xcc8e,
        kChieuchYaeSios                         = 0xcc8f,
        kChieuchYaeSsangsios                         = 0xcc90,
        kChieuchYaeIeung                         = 0xcc91,
        kChieuchYaeCieuc                         = 0xcc92,
        kChieuchYaeChieuch                         = 0xcc93,
        kChieuchYaeKhieukh                         = 0xcc94,
        kChieuchYaeThieuth                         = 0xcc95,
        kChieuchYaePhieuph                         = 0xcc96,
        kChieuchYaeHieuh                         = 0xcc97,
        kChieuchEo                           = 0xcc98,
        kChieuchEoKiyeok                         = 0xcc99,
        kChieuchEoSsangkiyeok                         = 0xcc9a,
        kChieuchEoKiyeoksios                         = 0xcc9b,
        kChieuchEoNieun                         = 0xcc9c,
        kChieuchEoNieuncieuc                         = 0xcc9d,
        kChieuchEoNieunhieuh                         = 0xcc9e,
        kChieuchEoTikeut                         = 0xcc9f,
        kChieuchEoRieul                         = 0xcca0,
        kChieuchEoRieulkiyeok                         = 0xcca1,
        kChieuchEoRieulmieum                         = 0xcca2,
        kChieuchEoRieulpieup                         = 0xcca3,
        kChieuchEoRieulsios                         = 0xcca4,
        kChieuchEoRieulthieuth                         = 0xcca5,
        kChieuchEoRieulphieuph                         = 0xcca6,
        kChieuchEoRieulhieuh                         = 0xcca7,
        kChieuchEoMieum                         = 0xcca8,
        kChieuchEoPieup                         = 0xcca9,
        kChieuchEoPieupsios                         = 0xccaa,
        kChieuchEoSios                         = 0xccab,
        kChieuchEoSsangsios                         = 0xccac,
        kChieuchEoIeung                         = 0xccad,
        kChieuchEoCieuc                         = 0xccae,
        kChieuchEoChieuch                         = 0xccaf,
        kChieuchEoKhieukh                         = 0xccb0,
        kChieuchEoThieuth                         = 0xccb1,
        kChieuchEoPhieuph                         = 0xccb2,
        kChieuchEoHieuh                         = 0xccb3,
        kChieuchE                           = 0xccb4,
        kChieuchEKiyeok                         = 0xccb5,
        kChieuchESsangkiyeok                         = 0xccb6,
        kChieuchEKiyeoksios                         = 0xccb7,
        kChieuchENieun                         = 0xccb8,
        kChieuchENieuncieuc                         = 0xccb9,
        kChieuchENieunhieuh                         = 0xccba,
        kChieuchETikeut                         = 0xccbb,
        kChieuchERieul                         = 0xccbc,
        kChieuchERieulkiyeok                         = 0xccbd,
        kChieuchERieulmieum                         = 0xccbe,
        kChieuchERieulpieup                         = 0xccbf,
        kChieuchERieulsios                         = 0xccc0,
        kChieuchERieulthieuth                         = 0xccc1,
        kChieuchERieulphieuph                         = 0xccc2,
        kChieuchERieulhieuh                         = 0xccc3,
        kChieuchEMieum                         = 0xccc4,
        kChieuchEPieup                         = 0xccc5,
        kChieuchEPieupsios                         = 0xccc6,
        kChieuchESios                         = 0xccc7,
        kChieuchESsangsios                         = 0xccc8,
        kChieuchEIeung                         = 0xccc9,
        kChieuchECieuc                         = 0xccca,
        kChieuchEChieuch                         = 0xcccb,
        kChieuchEKhieukh                         = 0xcccc,
        kChieuchEThieuth                         = 0xcccd,
        kChieuchEPhieuph                         = 0xccce,
        kChieuchEHieuh                         = 0xcccf,
        kChieuchYeo                           = 0xccd0,
        kChieuchYeoKiyeok                         = 0xccd1,
        kChieuchYeoSsangkiyeok                         = 0xccd2,
        kChieuchYeoKiyeoksios                         = 0xccd3,
        kChieuchYeoNieun                         = 0xccd4,
        kChieuchYeoNieuncieuc                         = 0xccd5,
        kChieuchYeoNieunhieuh                         = 0xccd6,
        kChieuchYeoTikeut                         = 0xccd7,
        kChieuchYeoRieul                         = 0xccd8,
        kChieuchYeoRieulkiyeok                         = 0xccd9,
        kChieuchYeoRieulmieum                         = 0xccda,
        kChieuchYeoRieulpieup                         = 0xccdb,
        kChieuchYeoRieulsios                         = 0xccdc,
        kChieuchYeoRieulthieuth                         = 0xccdd,
        kChieuchYeoRieulphieuph                         = 0xccde,
        kChieuchYeoRieulhieuh                         = 0xccdf,
        kChieuchYeoMieum                         = 0xcce0,
        kChieuchYeoPieup                         = 0xcce1,
        kChieuchYeoPieupsios                         = 0xcce2,
        kChieuchYeoSios                         = 0xcce3,
        kChieuchYeoSsangsios                         = 0xcce4,
        kChieuchYeoIeung                         = 0xcce5,
        kChieuchYeoCieuc                         = 0xcce6,
        kChieuchYeoChieuch                         = 0xcce7,
        kChieuchYeoKhieukh                         = 0xcce8,
        kChieuchYeoThieuth                         = 0xcce9,
        kChieuchYeoPhieuph                         = 0xccea,
        kChieuchYeoHieuh                         = 0xcceb,
        kChieuchYe                           = 0xccec,
        kChieuchYeKiyeok                         = 0xcced,
        kChieuchYeSsangkiyeok                         = 0xccee,
        kChieuchYeKiyeoksios                         = 0xccef,
        kChieuchYeNieun                         = 0xccf0,
        kChieuchYeNieuncieuc                         = 0xccf1,
        kChieuchYeNieunhieuh                         = 0xccf2,
        kChieuchYeTikeut                         = 0xccf3,
        kChieuchYeRieul                         = 0xccf4,
        kChieuchYeRieulkiyeok                         = 0xccf5,
        kChieuchYeRieulmieum                         = 0xccf6,
        kChieuchYeRieulpieup                         = 0xccf7,
        kChieuchYeRieulsios                         = 0xccf8,
        kChieuchYeRieulthieuth                         = 0xccf9,
        kChieuchYeRieulphieuph                         = 0xccfa,
        kChieuchYeRieulhieuh                         = 0xccfb,
        kChieuchYeMieum                         = 0xccfc,
        kChieuchYePieup                         = 0xccfd,
        kChieuchYePieupsios                         = 0xccfe,
        kChieuchYeSios                         = 0xccff,
        kChieuchYeSsangsios                         = 0xcd00,
        kChieuchYeIeung                         = 0xcd01,
        kChieuchYeCieuc                         = 0xcd02,
        kChieuchYeChieuch                         = 0xcd03,
        kChieuchYeKhieukh                         = 0xcd04,
        kChieuchYeThieuth                         = 0xcd05,
        kChieuchYePhieuph                         = 0xcd06,
        kChieuchYeHieuh                         = 0xcd07,
        kChieuchO                           = 0xcd08,
        kChieuchOKiyeok                         = 0xcd09,
        kChieuchOSsangkiyeok                         = 0xcd0a,
        kChieuchOKiyeoksios                         = 0xcd0b,
        kChieuchONieun                         = 0xcd0c,
        kChieuchONieuncieuc                         = 0xcd0d,
        kChieuchONieunhieuh                         = 0xcd0e,
        kChieuchOTikeut                         = 0xcd0f,
        kChieuchORieul                         = 0xcd10,
        kChieuchORieulkiyeok                         = 0xcd11,
        kChieuchORieulmieum                         = 0xcd12,
        kChieuchORieulpieup                         = 0xcd13,
        kChieuchORieulsios                         = 0xcd14,
        kChieuchORieulthieuth                         = 0xcd15,
        kChieuchORieulphieuph                         = 0xcd16,
        kChieuchORieulhieuh                         = 0xcd17,
        kChieuchOMieum                         = 0xcd18,
        kChieuchOPieup                         = 0xcd19,
        kChieuchOPieupsios                         = 0xcd1a,
        kChieuchOSios                         = 0xcd1b,
        kChieuchOSsangsios                         = 0xcd1c,
        kChieuchOIeung                         = 0xcd1d,
        kChieuchOCieuc                         = 0xcd1e,
        kChieuchOChieuch                         = 0xcd1f,
        kChieuchOKhieukh                         = 0xcd20,
        kChieuchOThieuth                         = 0xcd21,
        kChieuchOPhieuph                         = 0xcd22,
        kChieuchOHieuh                         = 0xcd23,
        kChieuchWa                           = 0xcd24,
        kChieuchWaKiyeok                         = 0xcd25,
        kChieuchWaSsangkiyeok                         = 0xcd26,
        kChieuchWaKiyeoksios                         = 0xcd27,
        kChieuchWaNieun                         = 0xcd28,
        kChieuchWaNieuncieuc                         = 0xcd29,
        kChieuchWaNieunhieuh                         = 0xcd2a,
        kChieuchWaTikeut                         = 0xcd2b,
        kChieuchWaRieul                         = 0xcd2c,
        kChieuchWaRieulkiyeok                         = 0xcd2d,
        kChieuchWaRieulmieum                         = 0xcd2e,
        kChieuchWaRieulpieup                         = 0xcd2f,
        kChieuchWaRieulsios                         = 0xcd30,
        kChieuchWaRieulthieuth                         = 0xcd31,
        kChieuchWaRieulphieuph                         = 0xcd32,
        kChieuchWaRieulhieuh                         = 0xcd33,
        kChieuchWaMieum                         = 0xcd34,
        kChieuchWaPieup                         = 0xcd35,
        kChieuchWaPieupsios                         = 0xcd36,
        kChieuchWaSios                         = 0xcd37,
        kChieuchWaSsangsios                         = 0xcd38,
        kChieuchWaIeung                         = 0xcd39,
        kChieuchWaCieuc                         = 0xcd3a,
        kChieuchWaChieuch                         = 0xcd3b,
        kChieuchWaKhieukh                         = 0xcd3c,
        kChieuchWaThieuth                         = 0xcd3d,
        kChieuchWaPhieuph                         = 0xcd3e,
        kChieuchWaHieuh                         = 0xcd3f,
        kChieuchWae                           = 0xcd40,
        kChieuchWaeKiyeok                         = 0xcd41,
        kChieuchWaeSsangkiyeok                         = 0xcd42,
        kChieuchWaeKiyeoksios                         = 0xcd43,
        kChieuchWaeNieun                         = 0xcd44,
        kChieuchWaeNieuncieuc                         = 0xcd45,
        kChieuchWaeNieunhieuh                         = 0xcd46,
        kChieuchWaeTikeut                         = 0xcd47,
        kChieuchWaeRieul                         = 0xcd48,
        kChieuchWaeRieulkiyeok                         = 0xcd49,
        kChieuchWaeRieulmieum                         = 0xcd4a,
        kChieuchWaeRieulpieup                         = 0xcd4b,
        kChieuchWaeRieulsios                         = 0xcd4c,
        kChieuchWaeRieulthieuth                         = 0xcd4d,
        kChieuchWaeRieulphieuph                         = 0xcd4e,
        kChieuchWaeRieulhieuh                         = 0xcd4f,
        kChieuchWaeMieum                         = 0xcd50,
        kChieuchWaePieup                         = 0xcd51,
        kChieuchWaePieupsios                         = 0xcd52,
        kChieuchWaeSios                         = 0xcd53,
        kChieuchWaeSsangsios                         = 0xcd54,
        kChieuchWaeIeung                         = 0xcd55,
        kChieuchWaeCieuc                         = 0xcd56,
        kChieuchWaeChieuch                         = 0xcd57,
        kChieuchWaeKhieukh                         = 0xcd58,
        kChieuchWaeThieuth                         = 0xcd59,
        kChieuchWaePhieuph                         = 0xcd5a,
        kChieuchWaeHieuh                         = 0xcd5b,
        kChieuchOe                           = 0xcd5c,
        kChieuchOeKiyeok                         = 0xcd5d,
        kChieuchOeSsangkiyeok                         = 0xcd5e,
        kChieuchOeKiyeoksios                         = 0xcd5f,
        kChieuchOeNieun                         = 0xcd60,
        kChieuchOeNieuncieuc                         = 0xcd61,
        kChieuchOeNieunhieuh                         = 0xcd62,
        kChieuchOeTikeut                         = 0xcd63,
        kChieuchOeRieul                         = 0xcd64,
        kChieuchOeRieulkiyeok                         = 0xcd65,
        kChieuchOeRieulmieum                         = 0xcd66,
        kChieuchOeRieulpieup                         = 0xcd67,
        kChieuchOeRieulsios                         = 0xcd68,
        kChieuchOeRieulthieuth                         = 0xcd69,
        kChieuchOeRieulphieuph                         = 0xcd6a,
        kChieuchOeRieulhieuh                         = 0xcd6b,
        kChieuchOeMieum                         = 0xcd6c,
        kChieuchOePieup                         = 0xcd6d,
        kChieuchOePieupsios                         = 0xcd6e,
        kChieuchOeSios                         = 0xcd6f,
        kChieuchOeSsangsios                         = 0xcd70,
        kChieuchOeIeung                         = 0xcd71,
        kChieuchOeCieuc                         = 0xcd72,
        kChieuchOeChieuch                         = 0xcd73,
        kChieuchOeKhieukh                         = 0xcd74,
        kChieuchOeThieuth                         = 0xcd75,
        kChieuchOePhieuph                         = 0xcd76,
        kChieuchOeHieuh                         = 0xcd77,
        kChieuchYo                           = 0xcd78,
        kChieuchYoKiyeok                         = 0xcd79,
        kChieuchYoSsangkiyeok                         = 0xcd7a,
        kChieuchYoKiyeoksios                         = 0xcd7b,
        kChieuchYoNieun                         = 0xcd7c,
        kChieuchYoNieuncieuc                         = 0xcd7d,
        kChieuchYoNieunhieuh                         = 0xcd7e,
        kChieuchYoTikeut                         = 0xcd7f,
        kChieuchYoRieul                         = 0xcd80,
        kChieuchYoRieulkiyeok                         = 0xcd81,
        kChieuchYoRieulmieum                         = 0xcd82,
        kChieuchYoRieulpieup                         = 0xcd83,
        kChieuchYoRieulsios                         = 0xcd84,
        kChieuchYoRieulthieuth                         = 0xcd85,
        kChieuchYoRieulphieuph                         = 0xcd86,
        kChieuchYoRieulhieuh                         = 0xcd87,
        kChieuchYoMieum                         = 0xcd88,
        kChieuchYoPieup                         = 0xcd89,
        kChieuchYoPieupsios                         = 0xcd8a,
        kChieuchYoSios                         = 0xcd8b,
        kChieuchYoSsangsios                         = 0xcd8c,
        kChieuchYoIeung                         = 0xcd8d,
        kChieuchYoCieuc                         = 0xcd8e,
        kChieuchYoChieuch                         = 0xcd8f,
        kChieuchYoKhieukh                         = 0xcd90,
        kChieuchYoThieuth                         = 0xcd91,
        kChieuchYoPhieuph                         = 0xcd92,
        kChieuchYoHieuh                         = 0xcd93,
        kChieuchU                           = 0xcd94,
        kChieuchUKiyeok                         = 0xcd95,
        kChieuchUSsangkiyeok                         = 0xcd96,
        kChieuchUKiyeoksios                         = 0xcd97,
        kChieuchUNieun                         = 0xcd98,
        kChieuchUNieuncieuc                         = 0xcd99,
        kChieuchUNieunhieuh                         = 0xcd9a,
        kChieuchUTikeut                         = 0xcd9b,
        kChieuchURieul                         = 0xcd9c,
        kChieuchURieulkiyeok                         = 0xcd9d,
        kChieuchURieulmieum                         = 0xcd9e,
        kChieuchURieulpieup                         = 0xcd9f,
        kChieuchURieulsios                         = 0xcda0,
        kChieuchURieulthieuth                         = 0xcda1,
        kChieuchURieulphieuph                         = 0xcda2,
        kChieuchURieulhieuh                         = 0xcda3,
        kChieuchUMieum                         = 0xcda4,
        kChieuchUPieup                         = 0xcda5,
        kChieuchUPieupsios                         = 0xcda6,
        kChieuchUSios                         = 0xcda7,
        kChieuchUSsangsios                         = 0xcda8,
        kChieuchUIeung                         = 0xcda9,
        kChieuchUCieuc                         = 0xcdaa,
        kChieuchUChieuch                         = 0xcdab,
        kChieuchUKhieukh                         = 0xcdac,
        kChieuchUThieuth                         = 0xcdad,
        kChieuchUPhieuph                         = 0xcdae,
        kChieuchUHieuh                         = 0xcdaf,
        kChieuchWeo                           = 0xcdb0,
        kChieuchWeoKiyeok                         = 0xcdb1,
        kChieuchWeoSsangkiyeok                         = 0xcdb2,
        kChieuchWeoKiyeoksios                         = 0xcdb3,
        kChieuchWeoNieun                         = 0xcdb4,
        kChieuchWeoNieuncieuc                         = 0xcdb5,
        kChieuchWeoNieunhieuh                         = 0xcdb6,
        kChieuchWeoTikeut                         = 0xcdb7,
        kChieuchWeoRieul                         = 0xcdb8,
        kChieuchWeoRieulkiyeok                         = 0xcdb9,
        kChieuchWeoRieulmieum                         = 0xcdba,
        kChieuchWeoRieulpieup                         = 0xcdbb,
        kChieuchWeoRieulsios                         = 0xcdbc,
        kChieuchWeoRieulthieuth                         = 0xcdbd,
        kChieuchWeoRieulphieuph                         = 0xcdbe,
        kChieuchWeoRieulhieuh                         = 0xcdbf,
        kChieuchWeoMieum                         = 0xcdc0,
        kChieuchWeoPieup                         = 0xcdc1,
        kChieuchWeoPieupsios                         = 0xcdc2,
        kChieuchWeoSios                         = 0xcdc3,
        kChieuchWeoSsangsios                         = 0xcdc4,
        kChieuchWeoIeung                         = 0xcdc5,
        kChieuchWeoCieuc                         = 0xcdc6,
        kChieuchWeoChieuch                         = 0xcdc7,
        kChieuchWeoKhieukh                         = 0xcdc8,
        kChieuchWeoThieuth                         = 0xcdc9,
        kChieuchWeoPhieuph                         = 0xcdca,
        kChieuchWeoHieuh                         = 0xcdcb,
        kChieuchWe                           = 0xcdcc,
        kChieuchWeKiyeok                         = 0xcdcd,
        kChieuchWeSsangkiyeok                         = 0xcdce,
        kChieuchWeKiyeoksios                         = 0xcdcf,
        kChieuchWeNieun                         = 0xcdd0,
        kChieuchWeNieuncieuc                         = 0xcdd1,
        kChieuchWeNieunhieuh                         = 0xcdd2,
        kChieuchWeTikeut                         = 0xcdd3,
        kChieuchWeRieul                         = 0xcdd4,
        kChieuchWeRieulkiyeok                         = 0xcdd5,
        kChieuchWeRieulmieum                         = 0xcdd6,
        kChieuchWeRieulpieup                         = 0xcdd7,
        kChieuchWeRieulsios                         = 0xcdd8,
        kChieuchWeRieulthieuth                         = 0xcdd9,
        kChieuchWeRieulphieuph                         = 0xcdda,
        kChieuchWeRieulhieuh                         = 0xcddb,
        kChieuchWeMieum                         = 0xcddc,
        kChieuchWePieup                         = 0xcddd,
        kChieuchWePieupsios                         = 0xcdde,
        kChieuchWeSios                         = 0xcddf,
        kChieuchWeSsangsios                         = 0xcde0,
        kChieuchWeIeung                         = 0xcde1,
        kChieuchWeCieuc                         = 0xcde2,
        kChieuchWeChieuch                         = 0xcde3,
        kChieuchWeKhieukh                         = 0xcde4,
        kChieuchWeThieuth                         = 0xcde5,
        kChieuchWePhieuph                         = 0xcde6,
        kChieuchWeHieuh                         = 0xcde7,
        kChieuchWi                           = 0xcde8,
        kChieuchWiKiyeok                         = 0xcde9,
        kChieuchWiSsangkiyeok                         = 0xcdea,
        kChieuchWiKiyeoksios                         = 0xcdeb,
        kChieuchWiNieun                         = 0xcdec,
        kChieuchWiNieuncieuc                         = 0xcded,
        kChieuchWiNieunhieuh                         = 0xcdee,
        kChieuchWiTikeut                         = 0xcdef,
        kChieuchWiRieul                         = 0xcdf0,
        kChieuchWiRieulkiyeok                         = 0xcdf1,
        kChieuchWiRieulmieum                         = 0xcdf2,
        kChieuchWiRieulpieup                         = 0xcdf3,
        kChieuchWiRieulsios                         = 0xcdf4,
        kChieuchWiRieulthieuth                         = 0xcdf5,
        kChieuchWiRieulphieuph                         = 0xcdf6,
        kChieuchWiRieulhieuh                         = 0xcdf7,
        kChieuchWiMieum                         = 0xcdf8,
        kChieuchWiPieup                         = 0xcdf9,
        kChieuchWiPieupsios                         = 0xcdfa,
        kChieuchWiSios                         = 0xcdfb,
        kChieuchWiSsangsios                         = 0xcdfc,
        kChieuchWiIeung                         = 0xcdfd,
        kChieuchWiCieuc                         = 0xcdfe,
        kChieuchWiChieuch                         = 0xcdff,
        kChieuchWiKhieukh                  = 0xce00,
        kChieuchWiThieuth                  = 0xce01,
        kChieuchWiPhieuph                  = 0xce02,
        kChieuchWiHieuh                    = 0xce03,
        kChieuchYu                         = 0xce04,
        kChieuchYuKiyeok                   = 0xce05,
        kChieuchYuSsangkiyeok              = 0xce06,
        kChieuchYuKiyeoksios               = 0xce07,
        kChieuchYuNieun                    = 0xce08,
        kChieuchYuNieuncieuc               = 0xce09,
        kChieuchYuNieunhieuh               = 0xce0a,
        kChieuchYuTikeut                   = 0xce0b,
        kChieuchYuRieul                    = 0xce0c,
        kChieuchYuRieulkiyeok              = 0xce0d,
        kChieuchYuRieulmieum               = 0xce0e,
        kChieuchYuRieulpieup               = 0xce0f,
        kChieuchYuRieulsios                = 0xce10,
        kChieuchYuRieulthieuth             = 0xce11,
        kChieuchYuRieulphieuph             = 0xce12,
        kChieuchYuRieulhieuh               = 0xce13,
        kChieuchYuMieum                    = 0xce14,
        kChieuchYuPieup                    = 0xce15,
        kChieuchYuPieupsios                = 0xce16,
        kChieuchYuSios                     = 0xce17,
        kChieuchYuSsangsios                = 0xce18,
        kChieuchYuIeung                    = 0xce19,
        kChieuchYuCieuc                    = 0xce1a,
        kChieuchYuChieuch                  = 0xce1b,
        kChieuchYuKhieukh                  = 0xce1c,
        kChieuchYuThieuth                  = 0xce1d,
        kChieuchYuPhieuph                  = 0xce1e,
        kChieuchYuHieuh                    = 0xce1f,
        kChieuchEu                         = 0xce20,
        kChieuchEuKiyeok                   = 0xce21,
        kChieuchEuSsangkiyeok              = 0xce22,
        kChieuchEuKiyeoksios               = 0xce23,
        kChieuchEuNieun                    = 0xce24,
        kChieuchEuNieuncieuc               = 0xce25,
        kChieuchEuNieunhieuh               = 0xce26,
        kChieuchEuTikeut                   = 0xce27,
        kChieuchEuRieul                    = 0xce28,
        kChieuchEuRieulkiyeok              = 0xce29,
        kChieuchEuRieulmieum               = 0xce2a,
        kChieuchEuRieulpieup               = 0xce2b,
        kChieuchEuRieulsios                = 0xce2c,
        kChieuchEuRieulthieuth             = 0xce2d,
        kChieuchEuRieulphieuph             = 0xce2e,
        kChieuchEuRieulhieuh               = 0xce2f,
        kChieuchEuMieum                    = 0xce30,
        kChieuchEuPieup                    = 0xce31,
        kChieuchEuPieupsios                = 0xce32,
        kChieuchEuSios                     = 0xce33,
        kChieuchEuSsangsios                = 0xce34,
        kChieuchEuIeung                    = 0xce35,
        kChieuchEuCieuc                    = 0xce36,
        kChieuchEuChieuch                  = 0xce37,
        kChieuchEuKhieukh                  = 0xce38,
        kChieuchEuThieuth                  = 0xce39,
        kChieuchEuPhieuph                  = 0xce3a,
        kChieuchEuHieuh                    = 0xce3b,
        kChieuchYi                         = 0xce3c,
        kChieuchYiKiyeok                   = 0xce3d,
        kChieuchYiSsangkiyeok              = 0xce3e,
        kChieuchYiKiyeoksios               = 0xce3f,
        kChieuchYiNieun                    = 0xce40,
        kChieuchYiNieuncieuc               = 0xce41,
        kChieuchYiNieunhieuh               = 0xce42,
        kChieuchYiTikeut                   = 0xce43,
        kChieuchYiRieul                    = 0xce44,
        kChieuchYiRieulkiyeok              = 0xce45,
        kChieuchYiRieulmieum               = 0xce46,
        kChieuchYiRieulpieup               = 0xce47,
        kChieuchYiRieulsios                = 0xce48,
        kChieuchYiRieulthieuth             = 0xce49,
        kChieuchYiRieulphieuph             = 0xce4a,
        kChieuchYiRieulhieuh               = 0xce4b,
        kChieuchYiMieum                    = 0xce4c,
        kChieuchYiPieup                    = 0xce4d,
        kChieuchYiPieupsios                = 0xce4e,
        kChieuchYiSios                     = 0xce4f,
        kChieuchYiSsangsios                = 0xce50,
        kChieuchYiIeung                    = 0xce51,
        kChieuchYiCieuc                    = 0xce52,
        kChieuchYiChieuch                  = 0xce53,
        kChieuchYiKhieukh                  = 0xce54,
        kChieuchYiThieuth                  = 0xce55,
        kChieuchYiPhieuph                  = 0xce56,
        kChieuchYiHieuh                    = 0xce57,
        kChieuchI                          = 0xce58,
        kChieuchIKiyeok                    = 0xce59,
        kChieuchISsangkiyeok               = 0xce5a,
        kChieuchIKiyeoksios                = 0xce5b,
        kChieuchINieun                     = 0xce5c,
        kChieuchINieuncieuc                = 0xce5d,
        kChieuchINieunhieuh                = 0xce5e,
        kChieuchITikeut                    = 0xce5f,
        kChieuchIRieul                     = 0xce60,
        kChieuchIRieulkiyeok               = 0xce61,
        kChieuchIRieulmieum                = 0xce62,
        kChieuchIRieulpieup                = 0xce63,
        kChieuchIRieulsios                 = 0xce64,
        kChieuchIRieulthieuth              = 0xce65,
        kChieuchIRieulphieuph              = 0xce66,
        kChieuchIRieulhieuh                = 0xce67,
        kChieuchIMieum                     = 0xce68,
        kChieuchIPieup                     = 0xce69,
        kChieuchIPieupsios                 = 0xce6a,
        kChieuchISios                      = 0xce6b,
        kChieuchISsangsios                 = 0xce6c,
        kChieuchIIeung                     = 0xce6d,
        kChieuchICieuc                     = 0xce6e,
        kChieuchIChieuch                   = 0xce6f,
        kChieuchIKhieukh                   = 0xce70,
        kChieuchIThieuth                   = 0xce71,
        kChieuchIPhieuph                   = 0xce72,
        kChieuchIHieuh                     = 0xce73,
        kKhieukhA                          = 0xce74,
        kKhieukhAKiyeok                    = 0xce75,
        kKhieukhASsangkiyeok               = 0xce76,
        kKhieukhAKiyeoksios                = 0xce77,
        kKhieukhANieun                     = 0xce78,
        kKhieukhANieuncieuc                = 0xce79,
        kKhieukhANieunhieuh                = 0xce7a,
        kKhieukhATikeut                    = 0xce7b,
        kKhieukhARieul                     = 0xce7c,
        kKhieukhARieulkiyeok               = 0xce7d,
        kKhieukhARieulmieum                = 0xce7e,
        kKhieukhARieulpieup                = 0xce7f,
        kKhieukhARieulsios                 = 0xce80,
        kKhieukhARieulthieuth              = 0xce81,
        kKhieukhARieulphieuph              = 0xce82,
        kKhieukhARieulhieuh                = 0xce83,
        kKhieukhAMieum                     = 0xce84,
        kKhieukhAPieup                     = 0xce85,
        kKhieukhAPieupsios                 = 0xce86,
        kKhieukhASios                      = 0xce87,
        kKhieukhASsangsios                 = 0xce88,
        kKhieukhAIeung                     = 0xce89,
        kKhieukhACieuc                     = 0xce8a,
        kKhieukhAChieuch                   = 0xce8b,
        kKhieukhAKhieukh                   = 0xce8c,
        kKhieukhAThieuth                   = 0xce8d,
        kKhieukhAPhieuph                   = 0xce8e,
        kKhieukhAHieuh                     = 0xce8f,
        kKhieukhAe                         = 0xce90,
        kKhieukhAeKiyeok                   = 0xce91,
        kKhieukhAeSsangkiyeok              = 0xce92,
        kKhieukhAeKiyeoksios               = 0xce93,
        kKhieukhAeNieun                    = 0xce94,
        kKhieukhAeNieuncieuc               = 0xce95,
        kKhieukhAeNieunhieuh               = 0xce96,
        kKhieukhAeTikeut                   = 0xce97,
        kKhieukhAeRieul                    = 0xce98,
        kKhieukhAeRieulkiyeok              = 0xce99,
        kKhieukhAeRieulmieum               = 0xce9a,
        kKhieukhAeRieulpieup               = 0xce9b,
        kKhieukhAeRieulsios                = 0xce9c,
        kKhieukhAeRieulthieuth             = 0xce9d,
        kKhieukhAeRieulphieuph             = 0xce9e,
        kKhieukhAeRieulhieuh               = 0xce9f,
        kKhieukhAeMieum                    = 0xcea0,
        kKhieukhAePieup                    = 0xcea1,
        kKhieukhAePieupsios                = 0xcea2,
        kKhieukhAeSios                     = 0xcea3,
        kKhieukhAeSsangsios                = 0xcea4,
        kKhieukhAeIeung                    = 0xcea5,
        kKhieukhAeCieuc                    = 0xcea6,
        kKhieukhAeChieuch                  = 0xcea7,
        kKhieukhAeKhieukh                  = 0xcea8,
        kKhieukhAeThieuth                  = 0xcea9,
        kKhieukhAePhieuph                  = 0xceaa,
        kKhieukhAeHieuh                    = 0xceab,
        kKhieukhYa                         = 0xceac,
        kKhieukhYaKiyeok                   = 0xcead,
        kKhieukhYaSsangkiyeok              = 0xceae,
        kKhieukhYaKiyeoksios               = 0xceaf,
        kKhieukhYaNieun                    = 0xceb0,
        kKhieukhYaNieuncieuc               = 0xceb1,
        kKhieukhYaNieunhieuh               = 0xceb2,
        kKhieukhYaTikeut                   = 0xceb3,
        kKhieukhYaRieul                    = 0xceb4,
        kKhieukhYaRieulkiyeok              = 0xceb5,
        kKhieukhYaRieulmieum               = 0xceb6,
        kKhieukhYaRieulpieup               = 0xceb7,
        kKhieukhYaRieulsios                = 0xceb8,
        kKhieukhYaRieulthieuth             = 0xceb9,
        kKhieukhYaRieulphieuph             = 0xceba,
        kKhieukhYaRieulhieuh               = 0xcebb,
        kKhieukhYaMieum                    = 0xcebc,
        kKhieukhYaPieup                    = 0xcebd,
        kKhieukhYaPieupsios                = 0xcebe,
        kKhieukhYaSios                     = 0xcebf,
        kKhieukhYaSsangsios                = 0xcec0,
        kKhieukhYaIeung                    = 0xcec1,
        kKhieukhYaCieuc                    = 0xcec2,
        kKhieukhYaChieuch                  = 0xcec3,
        kKhieukhYaKhieukh                  = 0xcec4,
        kKhieukhYaThieuth                  = 0xcec5,
        kKhieukhYaPhieuph                  = 0xcec6,
        kKhieukhYaHieuh                    = 0xcec7,
        kKhieukhYae                        = 0xcec8,
        kKhieukhYaeKiyeok                  = 0xcec9,
        kKhieukhYaeSsangkiyeok             = 0xceca,
        kKhieukhYaeKiyeoksios              = 0xcecb,
        kKhieukhYaeNieun                   = 0xcecc,
        kKhieukhYaeNieuncieuc              = 0xcecd,
        kKhieukhYaeNieunhieuh              = 0xcece,
        kKhieukhYaeTikeut                  = 0xcecf,
        kKhieukhYaeRieul                   = 0xced0,
        kKhieukhYaeRieulkiyeok             = 0xced1,
        kKhieukhYaeRieulmieum              = 0xced2,
        kKhieukhYaeRieulpieup              = 0xced3,
        kKhieukhYaeRieulsios               = 0xced4,
        kKhieukhYaeRieulthieuth            = 0xced5,
        kKhieukhYaeRieulphieuph            = 0xced6,
        kKhieukhYaeRieulhieuh              = 0xced7,
        kKhieukhYaeMieum                   = 0xced8,
        kKhieukhYaePieup                   = 0xced9,
        kKhieukhYaePieupsios               = 0xceda,
        kKhieukhYaeSios                    = 0xcedb,
        kKhieukhYaeSsangsios               = 0xcedc,
        kKhieukhYaeIeung                   = 0xcedd,
        kKhieukhYaeCieuc                   = 0xcede,
        kKhieukhYaeChieuch                 = 0xcedf,
        kKhieukhYaeKhieukh                 = 0xcee0,
        kKhieukhYaeThieuth                 = 0xcee1,
        kKhieukhYaePhieuph                 = 0xcee2,
        kKhieukhYaeHieuh                   = 0xcee3,
        kKhieukhEo                         = 0xcee4,
        kKhieukhEoKiyeok                   = 0xcee5,
        kKhieukhEoSsangkiyeok              = 0xcee6,
        kKhieukhEoKiyeoksios               = 0xcee7,
        kKhieukhEoNieun                    = 0xcee8,
        kKhieukhEoNieuncieuc               = 0xcee9,
        kKhieukhEoNieunhieuh               = 0xceea,
        kKhieukhEoTikeut                   = 0xceeb,
        kKhieukhEoRieul                    = 0xceec,
        kKhieukhEoRieulkiyeok              = 0xceed,
        kKhieukhEoRieulmieum               = 0xceee,
        kKhieukhEoRieulpieup               = 0xceef,
        kKhieukhEoRieulsios                = 0xcef0,
        kKhieukhEoRieulthieuth             = 0xcef1,
        kKhieukhEoRieulphieuph             = 0xcef2,
        kKhieukhEoRieulhieuh               = 0xcef3,
        kKhieukhEoMieum                    = 0xcef4,
        kKhieukhEoPieup                    = 0xcef5,
        kKhieukhEoPieupsios                = 0xcef6,
        kKhieukhEoSios                     = 0xcef7,
        kKhieukhEoSsangsios                = 0xcef8,
        kKhieukhEoIeung                    = 0xcef9,
        kKhieukhEoCieuc                    = 0xcefa,
        kKhieukhEoChieuch                  = 0xcefb,
        kKhieukhEoKhieukh                  = 0xcefc,
        kKhieukhEoThieuth                  = 0xcefd,
        kKhieukhEoPhieuph                  = 0xcefe,
        kKhieukhEoHieuh                    = 0xceff,
        kKhieukhE                          = 0xcf00,
        kKhieukhEKiyeok                    = 0xcf01,
        kKhieukhESsangkiyeok               = 0xcf02,
        kKhieukhEKiyeoksios                = 0xcf03,
        kKhieukhENieun                     = 0xcf04,
        kKhieukhENieuncieuc                = 0xcf05,
        kKhieukhENieunhieuh                = 0xcf06,
        kKhieukhETikeut                    = 0xcf07,
        kKhieukhERieul                     = 0xcf08,
        kKhieukhERieulkiyeok               = 0xcf09,
        kKhieukhERieulmieum                = 0xcf0a,
        kKhieukhERieulpieup                = 0xcf0b,
        kKhieukhERieulsios                 = 0xcf0c,
        kKhieukhERieulthieuth              = 0xcf0d,
        kKhieukhERieulphieuph              = 0xcf0e,
        kKhieukhERieulhieuh                = 0xcf0f,
        kKhieukhEMieum                     = 0xcf10,
        kKhieukhEPieup                     = 0xcf11,
        kKhieukhEPieupsios                 = 0xcf12,
        kKhieukhESios                      = 0xcf13,
        kKhieukhESsangsios                 = 0xcf14,
        kKhieukhEIeung                     = 0xcf15,
        kKhieukhECieuc                     = 0xcf16,
        kKhieukhEChieuch                   = 0xcf17,
        kKhieukhEKhieukh                   = 0xcf18,
        kKhieukhEThieuth                   = 0xcf19,
        kKhieukhEPhieuph                   = 0xcf1a,
        kKhieukhEHieuh                     = 0xcf1b,
        kKhieukhYeo                        = 0xcf1c,
        kKhieukhYeoKiyeok                  = 0xcf1d,
        kKhieukhYeoSsangkiyeok             = 0xcf1e,
        kKhieukhYeoKiyeoksios              = 0xcf1f,
        kKhieukhYeoNieun                   = 0xcf20,
        kKhieukhYeoNieuncieuc              = 0xcf21,
        kKhieukhYeoNieunhieuh              = 0xcf22,
        kKhieukhYeoTikeut                  = 0xcf23,
        kKhieukhYeoRieul                   = 0xcf24,
        kKhieukhYeoRieulkiyeok             = 0xcf25,
        kKhieukhYeoRieulmieum              = 0xcf26,
        kKhieukhYeoRieulpieup              = 0xcf27,
        kKhieukhYeoRieulsios               = 0xcf28,
        kKhieukhYeoRieulthieuth            = 0xcf29,
        kKhieukhYeoRieulphieuph            = 0xcf2a,
        kKhieukhYeoRieulhieuh              = 0xcf2b,
        kKhieukhYeoMieum                   = 0xcf2c,
        kKhieukhYeoPieup                   = 0xcf2d,
        kKhieukhYeoPieupsios               = 0xcf2e,
        kKhieukhYeoSios                    = 0xcf2f,
        kKhieukhYeoSsangsios               = 0xcf30,
        kKhieukhYeoIeung                   = 0xcf31,
        kKhieukhYeoCieuc                   = 0xcf32,
        kKhieukhYeoChieuch                 = 0xcf33,
        kKhieukhYeoKhieukh                 = 0xcf34,
        kKhieukhYeoThieuth                 = 0xcf35,
        kKhieukhYeoPhieuph                 = 0xcf36,
        kKhieukhYeoHieuh                   = 0xcf37,
        kKhieukhYe                         = 0xcf38,
        kKhieukhYeKiyeok                   = 0xcf39,
        kKhieukhYeSsangkiyeok              = 0xcf3a,
        kKhieukhYeKiyeoksios               = 0xcf3b,
        kKhieukhYeNieun                    = 0xcf3c,
        kKhieukhYeNieuncieuc               = 0xcf3d,
        kKhieukhYeNieunhieuh               = 0xcf3e,
        kKhieukhYeTikeut                   = 0xcf3f,
        kKhieukhYeRieul                    = 0xcf40,
        kKhieukhYeRieulkiyeok              = 0xcf41,
        kKhieukhYeRieulmieum               = 0xcf42,
        kKhieukhYeRieulpieup               = 0xcf43,
        kKhieukhYeRieulsios                = 0xcf44,
        kKhieukhYeRieulthieuth             = 0xcf45,
        kKhieukhYeRieulphieuph             = 0xcf46,
        kKhieukhYeRieulhieuh               = 0xcf47,
        kKhieukhYeMieum                    = 0xcf48,
        kKhieukhYePieup                    = 0xcf49,
        kKhieukhYePieupsios                = 0xcf4a,
        kKhieukhYeSios                     = 0xcf4b,
        kKhieukhYeSsangsios                = 0xcf4c,
        kKhieukhYeIeung                    = 0xcf4d,
        kKhieukhYeCieuc                    = 0xcf4e,
        kKhieukhYeChieuch                  = 0xcf4f,
        kKhieukhYeKhieukh                  = 0xcf50,
        kKhieukhYeThieuth                  = 0xcf51,
        kKhieukhYePhieuph                  = 0xcf52,
        kKhieukhYeHieuh                    = 0xcf53,
        kKhieukhO                          = 0xcf54,
        kKhieukhOKiyeok                    = 0xcf55,
        kKhieukhOSsangkiyeok               = 0xcf56,
        kKhieukhOKiyeoksios                = 0xcf57,
        kKhieukhONieun                     = 0xcf58,
        kKhieukhONieuncieuc                = 0xcf59,
        kKhieukhONieunhieuh                = 0xcf5a,
        kKhieukhOTikeut                    = 0xcf5b,
        kKhieukhORieul                     = 0xcf5c,
        kKhieukhORieulkiyeok               = 0xcf5d,
        kKhieukhORieulmieum                = 0xcf5e,
        kKhieukhORieulpieup                = 0xcf5f,
        kKhieukhORieulsios                 = 0xcf60,
        kKhieukhORieulthieuth              = 0xcf61,
        kKhieukhORieulphieuph              = 0xcf62,
        kKhieukhORieulhieuh                = 0xcf63,
        kKhieukhOMieum                     = 0xcf64,
        kKhieukhOPieup                     = 0xcf65,
        kKhieukhOPieupsios                 = 0xcf66,
        kKhieukhOSios                      = 0xcf67,
        kKhieukhOSsangsios                 = 0xcf68,
        kKhieukhOIeung                     = 0xcf69,
        kKhieukhOCieuc                     = 0xcf6a,
        kKhieukhOChieuch                   = 0xcf6b,
        kKhieukhOKhieukh                   = 0xcf6c,
        kKhieukhOThieuth                   = 0xcf6d,
        kKhieukhOPhieuph                   = 0xcf6e,
        kKhieukhOHieuh                     = 0xcf6f,
        kKhieukhWa                         = 0xcf70,
        kKhieukhWaKiyeok                   = 0xcf71,
        kKhieukhWaSsangkiyeok              = 0xcf72,
        kKhieukhWaKiyeoksios               = 0xcf73,
        kKhieukhWaNieun                    = 0xcf74,
        kKhieukhWaNieuncieuc               = 0xcf75,
        kKhieukhWaNieunhieuh               = 0xcf76,
        kKhieukhWaTikeut                   = 0xcf77,
        kKhieukhWaRieul                    = 0xcf78,
        kKhieukhWaRieulkiyeok              = 0xcf79,
        kKhieukhWaRieulmieum               = 0xcf7a,
        kKhieukhWaRieulpieup               = 0xcf7b,
        kKhieukhWaRieulsios                = 0xcf7c,
        kKhieukhWaRieulthieuth             = 0xcf7d,
        kKhieukhWaRieulphieuph             = 0xcf7e,
        kKhieukhWaRieulhieuh               = 0xcf7f,
        kKhieukhWaMieum                    = 0xcf80,
        kKhieukhWaPieup                    = 0xcf81,
        kKhieukhWaPieupsios                = 0xcf82,
        kKhieukhWaSios                     = 0xcf83,
        kKhieukhWaSsangsios                = 0xcf84,
        kKhieukhWaIeung                    = 0xcf85,
        kKhieukhWaCieuc                    = 0xcf86,
        kKhieukhWaChieuch                  = 0xcf87,
        kKhieukhWaKhieukh                  = 0xcf88,
        kKhieukhWaThieuth                  = 0xcf89,
        kKhieukhWaPhieuph                  = 0xcf8a,
        kKhieukhWaHieuh                    = 0xcf8b,
        kKhieukhWae                        = 0xcf8c,
        kKhieukhWaeKiyeok                  = 0xcf8d,
        kKhieukhWaeSsangkiyeok             = 0xcf8e,
        kKhieukhWaeKiyeoksios              = 0xcf8f,
        kKhieukhWaeNieun                   = 0xcf90,
        kKhieukhWaeNieuncieuc              = 0xcf91,
        kKhieukhWaeNieunhieuh              = 0xcf92,
        kKhieukhWaeTikeut                  = 0xcf93,
        kKhieukhWaeRieul                   = 0xcf94,
        kKhieukhWaeRieulkiyeok             = 0xcf95,
        kKhieukhWaeRieulmieum              = 0xcf96,
        kKhieukhWaeRieulpieup              = 0xcf97,
        kKhieukhWaeRieulsios               = 0xcf98,
        kKhieukhWaeRieulthieuth            = 0xcf99,
        kKhieukhWaeRieulphieuph            = 0xcf9a,
        kKhieukhWaeRieulhieuh              = 0xcf9b,
        kKhieukhWaeMieum                   = 0xcf9c,
        kKhieukhWaePieup                   = 0xcf9d,
        kKhieukhWaePieupsios               = 0xcf9e,
        kKhieukhWaeSios                    = 0xcf9f,
        kKhieukhWaeSsangsios               = 0xcfa0,
        kKhieukhWaeIeung                   = 0xcfa1,
        kKhieukhWaeCieuc                   = 0xcfa2,
        kKhieukhWaeChieuch                 = 0xcfa3,
        kKhieukhWaeKhieukh                 = 0xcfa4,
        kKhieukhWaeThieuth                 = 0xcfa5,
        kKhieukhWaePhieuph                 = 0xcfa6,
        kKhieukhWaeHieuh                   = 0xcfa7,
        kKhieukhOe                         = 0xcfa8,
        kKhieukhOeKiyeok                   = 0xcfa9,
        kKhieukhOeSsangkiyeok              = 0xcfaa,
        kKhieukhOeKiyeoksios               = 0xcfab,
        kKhieukhOeNieun                    = 0xcfac,
        kKhieukhOeNieuncieuc               = 0xcfad,
        kKhieukhOeNieunhieuh               = 0xcfae,
        kKhieukhOeTikeut                   = 0xcfaf,
        kKhieukhOeRieul                    = 0xcfb0,
        kKhieukhOeRieulkiyeok              = 0xcfb1,
        kKhieukhOeRieulmieum               = 0xcfb2,
        kKhieukhOeRieulpieup               = 0xcfb3,
        kKhieukhOeRieulsios                = 0xcfb4,
        kKhieukhOeRieulthieuth             = 0xcfb5,
        kKhieukhOeRieulphieuph             = 0xcfb6,
        kKhieukhOeRieulhieuh               = 0xcfb7,
        kKhieukhOeMieum                    = 0xcfb8,
        kKhieukhOePieup                    = 0xcfb9,
        kKhieukhOePieupsios                = 0xcfba,
        kKhieukhOeSios                     = 0xcfbb,
        kKhieukhOeSsangsios                = 0xcfbc,
        kKhieukhOeIeung                    = 0xcfbd,
        kKhieukhOeCieuc                    = 0xcfbe,
        kKhieukhOeChieuch                  = 0xcfbf,
        kKhieukhOeKhieukh                  = 0xcfc0,
        kKhieukhOeThieuth                  = 0xcfc1,
        kKhieukhOePhieuph                  = 0xcfc2,
        kKhieukhOeHieuh                    = 0xcfc3,
        kKhieukhYo                         = 0xcfc4,
        kKhieukhYoKiyeok                   = 0xcfc5,
        kKhieukhYoSsangkiyeok              = 0xcfc6,
        kKhieukhYoKiyeoksios               = 0xcfc7,
        kKhieukhYoNieun                    = 0xcfc8,
        kKhieukhYoNieuncieuc               = 0xcfc9,
        kKhieukhYoNieunhieuh               = 0xcfca,
        kKhieukhYoTikeut                   = 0xcfcb,
        kKhieukhYoRieul                    = 0xcfcc,
        kKhieukhYoRieulkiyeok              = 0xcfcd,
        kKhieukhYoRieulmieum               = 0xcfce,
        kKhieukhYoRieulpieup               = 0xcfcf,
        kKhieukhYoRieulsios                = 0xcfd0,
        kKhieukhYoRieulthieuth             = 0xcfd1,
        kKhieukhYoRieulphieuph             = 0xcfd2,
        kKhieukhYoRieulhieuh               = 0xcfd3,
        kKhieukhYoMieum                    = 0xcfd4,
        kKhieukhYoPieup                    = 0xcfd5,
        kKhieukhYoPieupsios                = 0xcfd6,
        kKhieukhYoSios                     = 0xcfd7,
        kKhieukhYoSsangsios                = 0xcfd8,
        kKhieukhYoIeung                    = 0xcfd9,
        kKhieukhYoCieuc                    = 0xcfda,
        kKhieukhYoChieuch                  = 0xcfdb,
        kKhieukhYoKhieukh                  = 0xcfdc,
        kKhieukhYoThieuth                  = 0xcfdd,
        kKhieukhYoPhieuph                  = 0xcfde,
        kKhieukhYoHieuh                    = 0xcfdf,
        kKhieukhU                          = 0xcfe0,
        kKhieukhUKiyeok                    = 0xcfe1,
        kKhieukhUSsangkiyeok               = 0xcfe2,
        kKhieukhUKiyeoksios                = 0xcfe3,
        kKhieukhUNieun                     = 0xcfe4,
        kKhieukhUNieuncieuc                = 0xcfe5,
        kKhieukhUNieunhieuh                = 0xcfe6,
        kKhieukhUTikeut                    = 0xcfe7,
        kKhieukhURieul                     = 0xcfe8,
        kKhieukhURieulkiyeok               = 0xcfe9,
        kKhieukhURieulmieum                = 0xcfea,
        kKhieukhURieulpieup                = 0xcfeb,
        kKhieukhURieulsios                 = 0xcfec,
        kKhieukhURieulthieuth              = 0xcfed,
        kKhieukhURieulphieuph              = 0xcfee,
        kKhieukhURieulhieuh                = 0xcfef,
        kKhieukhUMieum                     = 0xcff0,
        kKhieukhUPieup                     = 0xcff1,
        kKhieukhUPieupsios                 = 0xcff2,
        kKhieukhUSios                      = 0xcff3,
        kKhieukhUSsangsios                 = 0xcff4,
        kKhieukhUIeung                     = 0xcff5,
        kKhieukhUCieuc                     = 0xcff6,
        kKhieukhUChieuch                   = 0xcff7,
        kKhieukhUKhieukh                   = 0xcff8,
        kKhieukhUThieuth                   = 0xcff9,
        kKhieukhUPhieuph                   = 0xcffa,
        kKhieukhUHieuh                     = 0xcffb,
        kKhieukhWeo                        = 0xcffc,
        kKhieukhWeoKiyeok                  = 0xcffd,
        kKhieukhWeoSsangkiyeok             = 0xcffe,
        kKhieukhWeoKiyeoksios              = 0xcfff,
        kKhieukhWeoNieun                   = 0xd000,
        kKhieukhWeoNieuncieuc              = 0xd001,
        kKhieukhWeoNieunhieuh              = 0xd002,
        kKhieukhWeoTikeut                  = 0xd003,
        kKhieukhWeoRieul                   = 0xd004,
        kKhieukhWeoRieulkiyeok             = 0xd005,
        kKhieukhWeoRieulmieum              = 0xd006,
        kKhieukhWeoRieulpieup              = 0xd007,
        kKhieukhWeoRieulsios               = 0xd008,
        kKhieukhWeoRieulthieuth            = 0xd009,
        kKhieukhWeoRieulphieuph            = 0xd00a,
        kKhieukhWeoRieulhieuh              = 0xd00b,
        kKhieukhWeoMieum                   = 0xd00c,
        kKhieukhWeoPieup                   = 0xd00d,
        kKhieukhWeoPieupsios               = 0xd00e,
        kKhieukhWeoSios                    = 0xd00f,
        kKhieukhWeoSsangsios               = 0xd010,
        kKhieukhWeoIeung                   = 0xd011,
        kKhieukhWeoCieuc                   = 0xd012,
        kKhieukhWeoChieuch                 = 0xd013,
        kKhieukhWeoKhieukh                 = 0xd014,
        kKhieukhWeoThieuth                 = 0xd015,
        kKhieukhWeoPhieuph                 = 0xd016,
        kKhieukhWeoHieuh                   = 0xd017,
        kKhieukhWe                         = 0xd018,
        kKhieukhWeKiyeok                   = 0xd019,
        kKhieukhWeSsangkiyeok              = 0xd01a,
        kKhieukhWeKiyeoksios               = 0xd01b,
        kKhieukhWeNieun                    = 0xd01c,
        kKhieukhWeNieuncieuc               = 0xd01d,
        kKhieukhWeNieunhieuh               = 0xd01e,
        kKhieukhWeTikeut                   = 0xd01f,
        kKhieukhWeRieul                    = 0xd020,
        kKhieukhWeRieulkiyeok              = 0xd021,
        kKhieukhWeRieulmieum               = 0xd022,
        kKhieukhWeRieulpieup               = 0xd023,
        kKhieukhWeRieulsios                = 0xd024,
        kKhieukhWeRieulthieuth             = 0xd025,
        kKhieukhWeRieulphieuph             = 0xd026,
        kKhieukhWeRieulhieuh               = 0xd027,
        kKhieukhWeMieum                    = 0xd028,
        kKhieukhWePieup                    = 0xd029,
        kKhieukhWePieupsios                = 0xd02a,
        kKhieukhWeSios                     = 0xd02b,
        kKhieukhWeSsangsios                = 0xd02c,
        kKhieukhWeIeung                    = 0xd02d,
        kKhieukhWeCieuc                    = 0xd02e,
        kKhieukhWeChieuch                  = 0xd02f,
        kKhieukhWeKhieukh                  = 0xd030,
        kKhieukhWeThieuth                  = 0xd031,
        kKhieukhWePhieuph                  = 0xd032,
        kKhieukhWeHieuh                    = 0xd033,
        kKhieukhWi                         = 0xd034,
        kKhieukhWiKiyeok                   = 0xd035,
        kKhieukhWiSsangkiyeok              = 0xd036,
        kKhieukhWiKiyeoksios               = 0xd037,
        kKhieukhWiNieun                    = 0xd038,
        kKhieukhWiNieuncieuc               = 0xd039,
        kKhieukhWiNieunhieuh               = 0xd03a,
        kKhieukhWiTikeut                   = 0xd03b,
        kKhieukhWiRieul                    = 0xd03c,
        kKhieukhWiRieulkiyeok              = 0xd03d,
        kKhieukhWiRieulmieum               = 0xd03e,
        kKhieukhWiRieulpieup               = 0xd03f,
        kKhieukhWiRieulsios                = 0xd040,
        kKhieukhWiRieulthieuth             = 0xd041,
        kKhieukhWiRieulphieuph             = 0xd042,
        kKhieukhWiRieulhieuh               = 0xd043,
        kKhieukhWiMieum                    = 0xd044,
        kKhieukhWiPieup                    = 0xd045,
        kKhieukhWiPieupsios                = 0xd046,
        kKhieukhWiSios                     = 0xd047,
        kKhieukhWiSsangsios                = 0xd048,
        kKhieukhWiIeung                    = 0xd049,
        kKhieukhWiCieuc                    = 0xd04a,
        kKhieukhWiChieuch                  = 0xd04b,
        kKhieukhWiKhieukh                  = 0xd04c,
        kKhieukhWiThieuth                  = 0xd04d,
        kKhieukhWiPhieuph                  = 0xd04e,
        kKhieukhWiHieuh                    = 0xd04f,
        kKhieukhYu                         = 0xd050,
        kKhieukhYuKiyeok                   = 0xd051,
        kKhieukhYuSsangkiyeok              = 0xd052,
        kKhieukhYuKiyeoksios               = 0xd053,
        kKhieukhYuNieun                    = 0xd054,
        kKhieukhYuNieuncieuc               = 0xd055,
        kKhieukhYuNieunhieuh               = 0xd056,
        kKhieukhYuTikeut                   = 0xd057,
        kKhieukhYuRieul                    = 0xd058,
        kKhieukhYuRieulkiyeok              = 0xd059,
        kKhieukhYuRieulmieum               = 0xd05a,
        kKhieukhYuRieulpieup               = 0xd05b,
        kKhieukhYuRieulsios                = 0xd05c,
        kKhieukhYuRieulthieuth             = 0xd05d,
        kKhieukhYuRieulphieuph             = 0xd05e,
        kKhieukhYuRieulhieuh               = 0xd05f,
        kKhieukhYuMieum                    = 0xd060,
        kKhieukhYuPieup                    = 0xd061,
        kKhieukhYuPieupsios                = 0xd062,
        kKhieukhYuSios                     = 0xd063,
        kKhieukhYuSsangsios                = 0xd064,
        kKhieukhYuIeung                    = 0xd065,
        kKhieukhYuCieuc                    = 0xd066,
        kKhieukhYuChieuch                  = 0xd067,
        kKhieukhYuKhieukh                  = 0xd068,
        kKhieukhYuThieuth                  = 0xd069,
        kKhieukhYuPhieuph                  = 0xd06a,
        kKhieukhYuHieuh                    = 0xd06b,
        kKhieukhEu                         = 0xd06c,
        kKhieukhEuKiyeok                   = 0xd06d,
        kKhieukhEuSsangkiyeok              = 0xd06e,
        kKhieukhEuKiyeoksios               = 0xd06f,
        kKhieukhEuNieun                    = 0xd070,
        kKhieukhEuNieuncieuc               = 0xd071,
        kKhieukhEuNieunhieuh               = 0xd072,
        kKhieukhEuTikeut                   = 0xd073,
        kKhieukhEuRieul                    = 0xd074,
        kKhieukhEuRieulkiyeok              = 0xd075,
        kKhieukhEuRieulmieum               = 0xd076,
        kKhieukhEuRieulpieup               = 0xd077,
        kKhieukhEuRieulsios                = 0xd078,
        kKhieukhEuRieulthieuth             = 0xd079,
        kKhieukhEuRieulphieuph             = 0xd07a,
        kKhieukhEuRieulhieuh               = 0xd07b,
        kKhieukhEuMieum                    = 0xd07c,
        kKhieukhEuPieup                    = 0xd07d,
        kKhieukhEuPieupsios                = 0xd07e,
        kKhieukhEuSios                     = 0xd07f,
        kKhieukhEuSsangsios                = 0xd080,
        kKhieukhEuIeung                    = 0xd081,
        kKhieukhEuCieuc                    = 0xd082,
        kKhieukhEuChieuch                  = 0xd083,
        kKhieukhEuKhieukh                  = 0xd084,
        kKhieukhEuThieuth                  = 0xd085,
        kKhieukhEuPhieuph                  = 0xd086,
        kKhieukhEuHieuh                    = 0xd087,
        kKhieukhYi                         = 0xd088,
        kKhieukhYiKiyeok                   = 0xd089,
        kKhieukhYiSsangkiyeok              = 0xd08a,
        kKhieukhYiKiyeoksios               = 0xd08b,
        kKhieukhYiNieun                    = 0xd08c,
        kKhieukhYiNieuncieuc               = 0xd08d,
        kKhieukhYiNieunhieuh               = 0xd08e,
        kKhieukhYiTikeut                   = 0xd08f,
        kKhieukhYiRieul                    = 0xd090,
        kKhieukhYiRieulkiyeok              = 0xd091,
        kKhieukhYiRieulmieum               = 0xd092,
        kKhieukhYiRieulpieup               = 0xd093,
        kKhieukhYiRieulsios                = 0xd094,
        kKhieukhYiRieulthieuth             = 0xd095,
        kKhieukhYiRieulphieuph             = 0xd096,
        kKhieukhYiRieulhieuh               = 0xd097,
        kKhieukhYiMieum                    = 0xd098,
        kKhieukhYiPieup                    = 0xd099,
        kKhieukhYiPieupsios                = 0xd09a,
        kKhieukhYiSios                     = 0xd09b,
        kKhieukhYiSsangsios                = 0xd09c,
        kKhieukhYiIeung                    = 0xd09d,
        kKhieukhYiCieuc                    = 0xd09e,
        kKhieukhYiChieuch                  = 0xd09f,
        kKhieukhYiKhieukh                  = 0xd0a0,
        kKhieukhYiThieuth                  = 0xd0a1,
        kKhieukhYiPhieuph                  = 0xd0a2,
        kKhieukhYiHieuh                    = 0xd0a3,
        kKhieukhI                          = 0xd0a4,
        kKhieukhIKiyeok                    = 0xd0a5,
        kKhieukhISsangkiyeok               = 0xd0a6,
        kKhieukhIKiyeoksios                = 0xd0a7,
        kKhieukhINieun                     = 0xd0a8,
        kKhieukhINieuncieuc                = 0xd0a9,
        kKhieukhINieunhieuh                = 0xd0aa,
        kKhieukhITikeut                    = 0xd0ab,
        kKhieukhIRieul                     = 0xd0ac,
        kKhieukhIRieulkiyeok               = 0xd0ad,
        kKhieukhIRieulmieum                = 0xd0ae,
        kKhieukhIRieulpieup                = 0xd0af,
        kKhieukhIRieulsios                 = 0xd0b0,
        kKhieukhIRieulthieuth              = 0xd0b1,
        kKhieukhIRieulphieuph              = 0xd0b2,
        kKhieukhIRieulhieuh                = 0xd0b3,
        kKhieukhIMieum                     = 0xd0b4,
        kKhieukhIPieup                     = 0xd0b5,
        kKhieukhIPieupsios                 = 0xd0b6,
        kKhieukhISios                      = 0xd0b7,
        kKhieukhISsangsios                 = 0xd0b8,
        kKhieukhIIeung                     = 0xd0b9,
        kKhieukhICieuc                     = 0xd0ba,
        kKhieukhIChieuch                   = 0xd0bb,
        kKhieukhIKhieukh                   = 0xd0bc,
        kKhieukhIThieuth                   = 0xd0bd,
        kKhieukhIPhieuph                   = 0xd0be,
        kKhieukhIHieuh                     = 0xd0bf,
        kThieuthA                          = 0xd0c0,
        kThieuthAKiyeok                    = 0xd0c1,
        kThieuthASsangkiyeok               = 0xd0c2,
        kThieuthAKiyeoksios                = 0xd0c3,
        kThieuthANieun                     = 0xd0c4,
        kThieuthANieuncieuc                = 0xd0c5,
        kThieuthANieunhieuh                = 0xd0c6,
        kThieuthATikeut                    = 0xd0c7,
        kThieuthARieul                     = 0xd0c8,
        kThieuthARieulkiyeok               = 0xd0c9,
        kThieuthARieulmieum                = 0xd0ca,
        kThieuthARieulpieup                = 0xd0cb,
        kThieuthARieulsios                 = 0xd0cc,
        kThieuthARieulthieuth              = 0xd0cd,
        kThieuthARieulphieuph              = 0xd0ce,
        kThieuthARieulhieuh                = 0xd0cf,
        kThieuthAMieum                     = 0xd0d0,
        kThieuthAPieup                     = 0xd0d1,
        kThieuthAPieupsios                 = 0xd0d2,
        kThieuthASios                      = 0xd0d3,
        kThieuthASsangsios                 = 0xd0d4,
        kThieuthAIeung                     = 0xd0d5,
        kThieuthACieuc                     = 0xd0d6,
        kThieuthAChieuch                   = 0xd0d7,
        kThieuthAKhieukh                   = 0xd0d8,
        kThieuthAThieuth                   = 0xd0d9,
        kThieuthAPhieuph                   = 0xd0da,
        kThieuthAHieuh                     = 0xd0db,
        kThieuthAe                         = 0xd0dc,
        kThieuthAeKiyeok                   = 0xd0dd,
        kThieuthAeSsangkiyeok              = 0xd0de,
        kThieuthAeKiyeoksios              = 0xd0df,
        kThieuthAeNieun                   = 0xd0e0,
        kThieuthAeNieuncieuc              = 0xd0e1,
        kThieuthAeNieunhieuh              = 0xd0e2,
        kThieuthAeTikeut                  = 0xd0e3,
        kThieuthAeRieul                   = 0xd0e4,
        kThieuthAeRieulkiyeok             = 0xd0e5,
        kThieuthAeRieulmieum              = 0xd0e6,
        kThieuthAeRieulpieup              = 0xd0e7,
        kThieuthAeRieulsios               = 0xd0e8,
        kThieuthAeRieulthieuth            = 0xd0e9,
        kThieuthAeRieulphieuph            = 0xd0ea,
        kThieuthAeRieulhieuh              = 0xd0eb,
        kThieuthAeMieum                   = 0xd0ec,
        kThieuthAePieup                   = 0xd0ed,
        kThieuthAePieupsios               = 0xd0ee,
        kThieuthAeSios                    = 0xd0ef,
        kThieuthAeSsangsios               = 0xd0f0,
        kThieuthAeIeung                   = 0xd0f1,
        kThieuthAeCieuc                   = 0xd0f2,
        kThieuthAeChieuch                 = 0xd0f3,
        kThieuthAeKhieukh                 = 0xd0f4,
        kThieuthAeThieuth                 = 0xd0f5,
        kThieuthAePhieuph                 = 0xd0f6,
        kThieuthAeHieuh                   = 0xd0f7,
        kThieuthYa                        = 0xd0f8,
        kThieuthYaKiyeok                  = 0xd0f9,
        kThieuthYaSsangkiyeok             = 0xd0fa,
        kThieuthYaKiyeoksios              = 0xd0fb,
        kThieuthYaNieun                   = 0xd0fc,
        kThieuthYaNieuncieuc              = 0xd0fd,
        kThieuthYaNieunhieuh              = 0xd0fe,
        kThieuthYaTikeut                  = 0xd0ff,
        kThieuthYaRieul                   = 0xd100,
        kThieuthYaRieulkiyeok             = 0xd101,
        kThieuthYaRieulmieum              = 0xd102,
        kThieuthYaRieulpieup              = 0xd103,
        kThieuthYaRieulsios               = 0xd104,
        kThieuthYaRieulthieuth            = 0xd105,
        kThieuthYaRieulphieuph            = 0xd106,
        kThieuthYaRieulhieuh              = 0xd107,
        kThieuthYaMieum                   = 0xd108,
        kThieuthYaPieup                   = 0xd109,
        kThieuthYaPieupsios               = 0xd10a,
        kThieuthYaSios                    = 0xd10b,
        kThieuthYaSsangsios               = 0xd10c,
        kThieuthYaIeung                   = 0xd10d,
        kThieuthYaCieuc                   = 0xd10e,
        kThieuthYaChieuch                 = 0xd10f,
        kThieuthYaKhieukh                 = 0xd110,
        kThieuthYaThieuth                 = 0xd111,
        kThieuthYaPhieuph                 = 0xd112,
        kThieuthYaHieuh                   = 0xd113,
        kThieuthYae                       = 0xd114,
        kThieuthYaeKiyeok                 = 0xd115,
        kThieuthYaeSsangkiyeok            = 0xd116,
        kThieuthYaeKiyeoksios             = 0xd117,
        kThieuthYaeNieun                  = 0xd118,
        kThieuthYaeNieuncieuc             = 0xd119,
        kThieuthYaeNieunhieuh             = 0xd11a,
        kThieuthYaeTikeut                 = 0xd11b,
        kThieuthYaeRieul                  = 0xd11c,
        kThieuthYaeRieulkiyeok            = 0xd11d,
        kThieuthYaeRieulmieum             = 0xd11e,
        kThieuthYaeRieulpieup             = 0xd11f,
        kThieuthYaeRieulsios              = 0xd120,
        kThieuthYaeRieulthieuth           = 0xd121,
        kThieuthYaeRieulphieuph           = 0xd122,
        kThieuthYaeRieulhieuh             = 0xd123,
        kThieuthYaeMieum                  = 0xd124,
        kThieuthYaePieup                  = 0xd125,
        kThieuthYaePieupsios              = 0xd126,
        kThieuthYaeSios                   = 0xd127,
        kThieuthYaeSsangsios              = 0xd128,
        kThieuthYaeIeung                  = 0xd129,
        kThieuthYaeCieuc                  = 0xd12a,
        kThieuthYaeChieuch                = 0xd12b,
        kThieuthYaeKhieukh                = 0xd12c,
        kThieuthYaeThieuth                = 0xd12d,
        kThieuthYaePhieuph                = 0xd12e,
        kThieuthYaeHieuh                  = 0xd12f,
        kThieuthEo                        = 0xd130,
        kThieuthEoKiyeok                  = 0xd131,
        kThieuthEoSsangkiyeok             = 0xd132,
        kThieuthEoKiyeoksios              = 0xd133,
        kThieuthEoNieun                   = 0xd134,
        kThieuthEoNieuncieuc              = 0xd135,
        kThieuthEoNieunhieuh              = 0xd136,
        kThieuthEoTikeut                  = 0xd137,
        kThieuthEoRieul                   = 0xd138,
        kThieuthEoRieulkiyeok             = 0xd139,
        kThieuthEoRieulmieum              = 0xd13a,
        kThieuthEoRieulpieup              = 0xd13b,
        kThieuthEoRieulsios               = 0xd13c,
        kThieuthEoRieulthieuth            = 0xd13d,
        kThieuthEoRieulphieuph            = 0xd13e,
        kThieuthEoRieulhieuh              = 0xd13f,
        kThieuthEoMieum                   = 0xd140,
        kThieuthEoPieup                   = 0xd141,
        kThieuthEoPieupsios               = 0xd142,
        kThieuthEoSios                    = 0xd143,
        kThieuthEoSsangsios               = 0xd144,
        kThieuthEoIeung                   = 0xd145,
        kThieuthEoCieuc                   = 0xd146,
        kThieuthEoChieuch                 = 0xd147,
        kThieuthEoKhieukh                 = 0xd148,
        kThieuthEoThieuth                 = 0xd149,
        kThieuthEoPhieuph                 = 0xd14a,
        kThieuthEoHieuh                   = 0xd14b,
        kThieuthE                         = 0xd14c,
        kThieuthEKiyeok                   = 0xd14d,
        kThieuthESsangkiyeok              = 0xd14e,
        kThieuthEKiyeoksios               = 0xd14f,
        kThieuthENieun                    = 0xd150,
        kThieuthENieuncieuc               = 0xd151,
        kThieuthENieunhieuh               = 0xd152,
        kThieuthETikeut                   = 0xd153,
        kThieuthERieul                    = 0xd154,
        kThieuthERieulkiyeok              = 0xd155,
        kThieuthERieulmieum               = 0xd156,
        kThieuthERieulpieup               = 0xd157,
        kThieuthERieulsios                = 0xd158,
        kThieuthERieulthieuth             = 0xd159,
        kThieuthERieulphieuph             = 0xd15a,
        kThieuthERieulhieuh               = 0xd15b,
        kThieuthEMieum                    = 0xd15c,
        kThieuthEPieup                    = 0xd15d,
        kThieuthEPieupsios                = 0xd15e,
        kThieuthESios                     = 0xd15f,
        kThieuthESsangsios                = 0xd160,
        kThieuthEIeung                    = 0xd161,
        kThieuthECieuc                    = 0xd162,
        kThieuthEChieuch                  = 0xd163,
        kThieuthEKhieukh                  = 0xd164,
        kThieuthEThieuth                  = 0xd165,
        kThieuthEPhieuph                  = 0xd166,
        kThieuthEHieuh                    = 0xd167,
        kThieuthYeo                       = 0xd168,
        kThieuthYeoKiyeok                 = 0xd169,
        kThieuthYeoSsangkiyeok            = 0xd16a,
        kThieuthYeoKiyeoksios             = 0xd16b,
        kThieuthYeoNieun                  = 0xd16c,
        kThieuthYeoNieuncieuc             = 0xd16d,
        kThieuthYeoNieunhieuh             = 0xd16e,
        kThieuthYeoTikeut                 = 0xd16f,
        kThieuthYeoRieul                  = 0xd170,
        kThieuthYeoRieulkiyeok            = 0xd171,
        kThieuthYeoRieulmieum             = 0xd172,
        kThieuthYeoRieulpieup             = 0xd173,
        kThieuthYeoRieulsios              = 0xd174,
        kThieuthYeoRieulthieuth           = 0xd175,
        kThieuthYeoRieulphieuph           = 0xd176,
        kThieuthYeoRieulhieuh             = 0xd177,
        kThieuthYeoMieum                  = 0xd178,
        kThieuthYeoPieup                  = 0xd179,
        kThieuthYeoPieupsios              = 0xd17a,
        kThieuthYeoSios                   = 0xd17b,
        kThieuthYeoSsangsios              = 0xd17c,
        kThieuthYeoIeung                  = 0xd17d,
        kThieuthYeoCieuc                  = 0xd17e,
        kThieuthYeoChieuch                = 0xd17f,
        kThieuthYeoKhieukh                = 0xd180,
        kThieuthYeoThieuth                = 0xd181,
        kThieuthYeoPhieuph                = 0xd182,
        kThieuthYeoHieuh                  = 0xd183,
        kThieuthYe                        = 0xd184,
        kThieuthYeKiyeok                  = 0xd185,
        kThieuthYeSsangkiyeok             = 0xd186,
        kThieuthYeKiyeoksios              = 0xd187,
        kThieuthYeNieun                   = 0xd188,
        kThieuthYeNieuncieuc              = 0xd189,
        kThieuthYeNieunhieuh              = 0xd18a,
        kThieuthYeTikeut                  = 0xd18b,
        kThieuthYeRieul                   = 0xd18c,
        kThieuthYeRieulkiyeok             = 0xd18d,
        kThieuthYeRieulmieum              = 0xd18e,
        kThieuthYeRieulpieup              = 0xd18f,
        kThieuthYeRieulsios               = 0xd190,
        kThieuthYeRieulthieuth            = 0xd191,
        kThieuthYeRieulphieuph            = 0xd192,
        kThieuthYeRieulhieuh              = 0xd193,
        kThieuthYeMieum                   = 0xd194,
        kThieuthYePieup                   = 0xd195,
        kThieuthYePieupsios               = 0xd196,
        kThieuthYeSios                    = 0xd197,
        kThieuthYeSsangsios               = 0xd198,
        kThieuthYeIeung                   = 0xd199,
        kThieuthYeCieuc                   = 0xd19a,
        kThieuthYeChieuch                 = 0xd19b,
        kThieuthYeKhieukh                 = 0xd19c,
        kThieuthYeThieuth                 = 0xd19d,
        kThieuthYePhieuph                 = 0xd19e,
        kThieuthYeHieuh                   = 0xd19f,
        kThieuthO                         = 0xd1a0,
        kThieuthOKiyeok                   = 0xd1a1,
        kThieuthOSsangkiyeok              = 0xd1a2,
        kThieuthOKiyeoksios               = 0xd1a3,
        kThieuthONieun                    = 0xd1a4,
        kThieuthONieuncieuc               = 0xd1a5,
        kThieuthONieunhieuh               = 0xd1a6,
        kThieuthOTikeut                   = 0xd1a7,
        kThieuthORieul                    = 0xd1a8,
        kThieuthORieulkiyeok              = 0xd1a9,
        kThieuthORieulmieum               = 0xd1aa,
        kThieuthORieulpieup               = 0xd1ab,
        kThieuthORieulsios                = 0xd1ac,
        kThieuthORieulthieuth             = 0xd1ad,
        kThieuthORieulphieuph             = 0xd1ae,
        kThieuthORieulhieuh               = 0xd1af,
        kThieuthOMieum                    = 0xd1b0,
        kThieuthOPieup                    = 0xd1b1,
        kThieuthOPieupsios                = 0xd1b2,
        kThieuthOSios                     = 0xd1b3,
        kThieuthOSsangsios                = 0xd1b4,
        kThieuthOIeung                    = 0xd1b5,
        kThieuthOCieuc                    = 0xd1b6,
        kThieuthOChieuch                  = 0xd1b7,
        kThieuthOKhieukh                  = 0xd1b8,
        kThieuthOThieuth                  = 0xd1b9,
        kThieuthOPhieuph                  = 0xd1ba,
        kThieuthOHieuh                    = 0xd1bb,
        kThieuthWa                        = 0xd1bc,
        kThieuthWaKiyeok                  = 0xd1bd,
        kThieuthWaSsangkiyeok             = 0xd1be,
        kThieuthWaKiyeoksios              = 0xd1bf,
        kThieuthWaNieun                   = 0xd1c0,
        kThieuthWaNieuncieuc              = 0xd1c1,
        kThieuthWaNieunhieuh              = 0xd1c2,
        kThieuthWaTikeut                  = 0xd1c3,
        kThieuthWaRieul                   = 0xd1c4,
        kThieuthWaRieulkiyeok             = 0xd1c5,
        kThieuthWaRieulmieum              = 0xd1c6,
        kThieuthWaRieulpieup              = 0xd1c7,
        kThieuthWaRieulsios               = 0xd1c8,
        kThieuthWaRieulthieuth            = 0xd1c9,
        kThieuthWaRieulphieuph            = 0xd1ca,
        kThieuthWaRieulhieuh              = 0xd1cb,
        kThieuthWaMieum                   = 0xd1cc,
        kThieuthWaPieup                   = 0xd1cd,
        kThieuthWaPieupsios               = 0xd1ce,
        kThieuthWaSios                    = 0xd1cf,
        kThieuthWaSsangsios               = 0xd1d0,
        kThieuthWaIeung                   = 0xd1d1,
        kThieuthWaCieuc                   = 0xd1d2,
        kThieuthWaChieuch                 = 0xd1d3,
        kThieuthWaKhieukh                 = 0xd1d4,
        kThieuthWaThieuth                 = 0xd1d5,
        kThieuthWaPhieuph                 = 0xd1d6,
        kThieuthWaHieuh                   = 0xd1d7,
        kThieuthWae                       = 0xd1d8,
        kThieuthWaeKiyeok                 = 0xd1d9,
        kThieuthWaeSsangkiyeok            = 0xd1da,
        kThieuthWaeKiyeoksios             = 0xd1db,
        kThieuthWaeNieun                  = 0xd1dc,
        kThieuthWaeNieuncieuc             = 0xd1dd,
        kThieuthWaeNieunhieuh             = 0xd1de,
        kThieuthWaeTikeut                 = 0xd1df,
        kThieuthWaeRieul                  = 0xd1e0,
        kThieuthWaeRieulkiyeok            = 0xd1e1,
        kThieuthWaeRieulmieum             = 0xd1e2,
        kThieuthWaeRieulpieup             = 0xd1e3,
        kThieuthWaeRieulsios              = 0xd1e4,
        kThieuthWaeRieulthieuth           = 0xd1e5,
        kThieuthWaeRieulphieuph           = 0xd1e6,
        kThieuthWaeRieulhieuh             = 0xd1e7,
        kThieuthWaeMieum                  = 0xd1e8,
        kThieuthWaePieup                  = 0xd1e9,
        kThieuthWaePieupsios              = 0xd1ea,
        kThieuthWaeSios                   = 0xd1eb,
        kThieuthWaeSsangsios              = 0xd1ec,
        kThieuthWaeIeung                  = 0xd1ed,
        kThieuthWaeCieuc                  = 0xd1ee,
        kThieuthWaeChieuch                = 0xd1ef,
        kThieuthWaeKhieukh                = 0xd1f0,
        kThieuthWaeThieuth                = 0xd1f1,
        kThieuthWaePhieuph                = 0xd1f2,
        kThieuthWaeHieuh                  = 0xd1f3,
        kThieuthOe                        = 0xd1f4,
        kThieuthOeKiyeok                  = 0xd1f5,
        kThieuthOeSsangkiyeok             = 0xd1f6,
        kThieuthOeKiyeoksios              = 0xd1f7,
        kThieuthOeNieun                   = 0xd1f8,
        kThieuthOeNieuncieuc              = 0xd1f9,
        kThieuthOeNieunhieuh              = 0xd1fa,
        kThieuthOeTikeut                  = 0xd1fb,
        kThieuthOeRieul                   = 0xd1fc,
        kThieuthOeRieulkiyeok             = 0xd1fd,
        kThieuthOeRieulmieum              = 0xd1fe,
        kThieuthOeRieulpieup              = 0xd1ff,
        kThieuthOeRieulsios               = 0xd200,
        kThieuthOeRieulthieuth            = 0xd201,
        kThieuthOeRieulphieuph            = 0xd202,
        kThieuthOeRieulhieuh              = 0xd203,
        kThieuthOeMieum                   = 0xd204,
        kThieuthOePieup                   = 0xd205,
        kThieuthOePieupsios               = 0xd206,
        kThieuthOeSios                    = 0xd207,
        kThieuthOeSsangsios               = 0xd208,
        kThieuthOeIeung                   = 0xd209,
        kThieuthOeCieuc                   = 0xd20a,
        kThieuthOeChieuch                 = 0xd20b,
        kThieuthOeKhieukh                 = 0xd20c,
        kThieuthOeThieuth                 = 0xd20d,
        kThieuthOePhieuph                 = 0xd20e,
        kThieuthOeHieuh                   = 0xd20f,
        kThieuthYo                        = 0xd210,
        kThieuthYoKiyeok                  = 0xd211,
        kThieuthYoSsangkiyeok             = 0xd212,
        kThieuthYoKiyeoksios              = 0xd213,
        kThieuthYoNieun                   = 0xd214,
        kThieuthYoNieuncieuc              = 0xd215,
        kThieuthYoNieunhieuh              = 0xd216,
        kThieuthYoTikeut                  = 0xd217,
        kThieuthYoRieul                   = 0xd218,
        kThieuthYoRieulkiyeok             = 0xd219,
        kThieuthYoRieulmieum              = 0xd21a,
        kThieuthYoRieulpieup              = 0xd21b,
        kThieuthYoRieulsios               = 0xd21c,
        kThieuthYoRieulthieuth            = 0xd21d,
        kThieuthYoRieulphieuph            = 0xd21e,
        kThieuthYoRieulhieuh              = 0xd21f,
        kThieuthYoMieum                   = 0xd220,
        kThieuthYoPieup                   = 0xd221,
        kThieuthYoPieupsios               = 0xd222,
        kThieuthYoSios                    = 0xd223,
        kThieuthYoSsangsios               = 0xd224,
        kThieuthYoIeung                   = 0xd225,
        kThieuthYoCieuc                   = 0xd226,
        kThieuthYoChieuch                 = 0xd227,
        kThieuthYoKhieukh                 = 0xd228,
        kThieuthYoThieuth                 = 0xd229,
        kThieuthYoPhieuph                 = 0xd22a,
        kThieuthYoHieuh                   = 0xd22b,
        kThieuthU                         = 0xd22c,
        kThieuthUKiyeok                   = 0xd22d,
        kThieuthUSsangkiyeok              = 0xd22e,
        kThieuthUKiyeoksios               = 0xd22f,
        kThieuthUNieun                    = 0xd230,
        kThieuthUNieuncieuc               = 0xd231,
        kThieuthUNieunhieuh               = 0xd232,
        kThieuthUTikeut                   = 0xd233,
        kThieuthURieul                    = 0xd234,
        kThieuthURieulkiyeok              = 0xd235,
        kThieuthURieulmieum               = 0xd236,
        kThieuthURieulpieup               = 0xd237,
        kThieuthURieulsios                = 0xd238,
        kThieuthURieulthieuth             = 0xd239,
        kThieuthURieulphieuph             = 0xd23a,
        kThieuthURieulhieuh               = 0xd23b,
        kThieuthUMieum                    = 0xd23c,
        kThieuthUPieup                    = 0xd23d,
        kThieuthUPieupsios                = 0xd23e,
        kThieuthUSios                     = 0xd23f,
        kThieuthUSsangsios                = 0xd240,
        kThieuthUIeung                    = 0xd241,
        kThieuthUCieuc                    = 0xd242,
        kThieuthUChieuch                  = 0xd243,
        kThieuthUKhieukh                  = 0xd244,
        kThieuthUThieuth                  = 0xd245,
        kThieuthUPhieuph                  = 0xd246,
        kThieuthUHieuh                    = 0xd247,
        kThieuthWeo                       = 0xd248,
        kThieuthWeoKiyeok                 = 0xd249,
        kThieuthWeoSsangkiyeok            = 0xd24a,
        kThieuthWeoKiyeoksios             = 0xd24b,
        kThieuthWeoNieun                  = 0xd24c,
        kThieuthWeoNieuncieuc             = 0xd24d,
        kThieuthWeoNieunhieuh             = 0xd24e,
        kThieuthWeoTikeut                 = 0xd24f,
        kThieuthWeoRieul                  = 0xd250,
        kThieuthWeoRieulkiyeok            = 0xd251,
        kThieuthWeoRieulmieum             = 0xd252,
        kThieuthWeoRieulpieup             = 0xd253,
        kThieuthWeoRieulsios              = 0xd254,
        kThieuthWeoRieulthieuth           = 0xd255,
        kThieuthWeoRieulphieuph           = 0xd256,
        kThieuthWeoRieulhieuh             = 0xd257,
        kThieuthWeoMieum                  = 0xd258,
        kThieuthWeoPieup                  = 0xd259,
        kThieuthWeoPieupsios              = 0xd25a,
        kThieuthWeoSios                   = 0xd25b,
        kThieuthWeoSsangsios              = 0xd25c,
        kThieuthWeoIeung                  = 0xd25d,
        kThieuthWeoCieuc                  = 0xd25e,
        kThieuthWeoChieuch                = 0xd25f,
        kThieuthWeoKhieukh                = 0xd260,
        kThieuthWeoThieuth                = 0xd261,
        kThieuthWeoPhieuph                = 0xd262,
        kThieuthWeoHieuh                  = 0xd263,
        kThieuthWe                        = 0xd264,
        kThieuthWeKiyeok                  = 0xd265,
        kThieuthWeSsangkiyeok             = 0xd266,
        kThieuthWeKiyeoksios              = 0xd267,
        kThieuthWeNieun                   = 0xd268,
        kThieuthWeNieuncieuc              = 0xd269,
        kThieuthWeNieunhieuh              = 0xd26a,
        kThieuthWeTikeut                  = 0xd26b,
        kThieuthWeRieul                   = 0xd26c,
        kThieuthWeRieulkiyeok             = 0xd26d,
        kThieuthWeRieulmieum              = 0xd26e,
        kThieuthWeRieulpieup              = 0xd26f,
        kThieuthWeRieulsios               = 0xd270,
        kThieuthWeRieulthieuth            = 0xd271,
        kThieuthWeRieulphieuph            = 0xd272,
        kThieuthWeRieulhieuh              = 0xd273,
        kThieuthWeMieum                   = 0xd274,
        kThieuthWePieup                   = 0xd275,
        kThieuthWePieupsios               = 0xd276,
        kThieuthWeSios                    = 0xd277,
        kThieuthWeSsangsios               = 0xd278,
        kThieuthWeIeung                   = 0xd279,
        kThieuthWeCieuc                   = 0xd27a,
        kThieuthWeChieuch                 = 0xd27b,
        kThieuthWeKhieukh                 = 0xd27c,
        kThieuthWeThieuth                 = 0xd27d,
        kThieuthWePhieuph                 = 0xd27e,
        kThieuthWeHieuh                   = 0xd27f,
        kThieuthWi                        = 0xd280,
        kThieuthWiKiyeok                  = 0xd281,
        kThieuthWiSsangkiyeok             = 0xd282,
        kThieuthWiKiyeoksios              = 0xd283,
        kThieuthWiNieun                   = 0xd284,
        kThieuthWiNieuncieuc              = 0xd285,
        kThieuthWiNieunhieuh              = 0xd286,
        kThieuthWiTikeut                  = 0xd287,
        kThieuthWiRieul                   = 0xd288,
        kThieuthWiRieulkiyeok             = 0xd289,
        kThieuthWiRieulmieum              = 0xd28a,
        kThieuthWiRieulpieup              = 0xd28b,
        kThieuthWiRieulsios               = 0xd28c,
        kThieuthWiRieulthieuth            = 0xd28d,
        kThieuthWiRieulphie               = 0xd28e,
        kThieuthWiRieulhieu               = 0xd28f,
        kThieuthWiMieum                   = 0xd290,
        kThieuthWiPieup                   = 0xd291,
        kThieuthWiPieupsios               = 0xd292,
        kThieuthWiSios                    = 0xd293,
        kThieuthWiSsangsio                = 0xd294,
        kThieuthWiIeung                   = 0xd295,
        kThieuthWiCieuc                   = 0xd296,
        kThieuthWiChieuch                 = 0xd297,
        kThieuthWiKhieukh                 = 0xd298,
        kThieuthWiThieuth                 = 0xd299,
        kThieuthWiPhieuph                 = 0xd29a,
        kThieuthWiHieuh                   = 0xd29b,
        kThieuthYu                        = 0xd29c,
        kThieuthYuKiyeok                  = 0xd29d,
        kThieuthYuSsangkiyeok             = 0xd29e,
        kThieuthYuKiyeoksios              = 0xd29f,
        kThieuthYuNieun                   = 0xd2a0,
        kThieuthYuNieuncieuc              = 0xd2a1,
        kThieuthYuNieunhieuh              = 0xd2a2,
        kThieuthYuTikeut                  = 0xd2a3,
        kThieuthYuRieul                   = 0xd2a4,
        kThieuthYuRieulkiyeok             = 0xd2a5,
        kThieuthYuRieulmieum              = 0xd2a6,
        kThieuthYuRieulpieup              = 0xd2a7,
        kThieuthYuRieulsios               = 0xd2a8,
        kThieuthYuRieulthieuth            = 0xd2a9,
        kThieuthYuRieulphieuph            = 0xd2aa,
        kThieuthYuRieulhieuh              = 0xd2ab,
        kThieuthYuMieum                   = 0xd2ac,
        kThieuthYuPieup                   = 0xd2ad,
        kThieuthYuPieupsios               = 0xd2ae,
        kThieuthYuSios                    = 0xd2af,
        kThieuthYuSsangsios               = 0xd2b0,
        kThieuthYuIeung                   = 0xd2b1,
        kThieuthYuCieuc                   = 0xd2b2,
        kThieuthYuChieuch                 = 0xd2b3,
        kThieuthYuKhieukh                 = 0xd2b4,
        kThieuthYuThieuth                 = 0xd2b5,
        kThieuthYuPhieuph                 = 0xd2b6,
        kThieuthYuHieuh                   = 0xd2b7,
        kThieuthEu                        = 0xd2b8,
        kThieuthEuKiyeok                  = 0xd2b9,
        kThieuthEuSsangkiyeok             = 0xd2ba,
        kThieuthEuKiyeoksios              = 0xd2bb,
        kThieuthEuNieun                   = 0xd2bc,
        kThieuthEuNieuncieuc              = 0xd2bd,
        kThieuthEuNieunhieuh              = 0xd2be,
        kThieuthEuTikeut                  = 0xd2bf,
        kThieuthEuRieul                   = 0xd2c0,
        kThieuthEuRieulkiyeok             = 0xd2c1,
        kThieuthEuRieulmieum              = 0xd2c2,
        kThieuthEuRieulpieup              = 0xd2c3,
        kThieuthEuRieulsios               = 0xd2c4,
        kThieuthEuRieulthieuth            = 0xd2c5,
        kThieuthEuRieulphieuph            = 0xd2c6,
        kThieuthEuRieulhieuh              = 0xd2c7,
        kThieuthEuMieum                   = 0xd2c8,
        kThieuthEuPieup                   = 0xd2c9,
        kThieuthEuPieupsios               = 0xd2ca,
        kThieuthEuSios                    = 0xd2cb,
        kThieuthEuSsangsios               = 0xd2cc,
        kThieuthEuIeung                   = 0xd2cd,
        kThieuthEuCieuc                   = 0xd2ce,
        kThieuthEuChieuch                 = 0xd2cf,
        kThieuthEuKhieukh                 = 0xd2d0,
        kThieuthEuThieuth                 = 0xd2d1,
        kThieuthEuPhieuph                 = 0xd2d2,
        kThieuthEuHieuh                   = 0xd2d3,
        kThieuthYi                        = 0xd2d4,
        kThieuthYiKiyeok                  = 0xd2d5,
        kThieuthYiSsangkiyeok             = 0xd2d6,
        kThieuthYiKiyeoksios              = 0xd2d7,
        kThieuthYiNieun                   = 0xd2d8,
        kThieuthYiNieuncieuc              = 0xd2d9,
        kThieuthYiNieunhieuh              = 0xd2da,
        kThieuthYiTikeut                  = 0xd2db,
        kThieuthYiRieul                   = 0xd2dc,
        kThieuthYiRieulkiyeok             = 0xd2dd,
        kThieuthYiRieulmieum              = 0xd2de,
        kThieuthYiRieulpieup              = 0xd2df,
        kThieuthYiRieulsios               = 0xd2e0,
        kThieuthYiRieulthieuth            = 0xd2e1,
        kThieuthYiRieulphieuph            = 0xd2e2,
        kThieuthYiRieulhieuh              = 0xd2e3,
        kThieuthYiMieum                   = 0xd2e4,
        kThieuthYiPieup                   = 0xd2e5,
        kThieuthYiPieupsios               = 0xd2e6,
        kThieuthYiSios                    = 0xd2e7,
        kThieuthYiSsangsios               = 0xd2e8,
        kThieuthYiIeung                   = 0xd2e9,
        kThieuthYiCieuc                   = 0xd2ea,
        kThieuthYiChieuch                 = 0xd2eb,
        kThieuthYiKhieukh                 = 0xd2ec,
        kThieuthYiThieuth                 = 0xd2ed,
        kThieuthYiPhieuph                 = 0xd2ee,
        kThieuthYiHieuh                   = 0xd2ef,
        kThieuthI                         = 0xd2f0,
        kThieuthIKiyeok                   = 0xd2f1,
        kThieuthISsangkiyeok              = 0xd2f2,
        kThieuthIKiyeoksios               = 0xd2f3,
        kThieuthINieun                    = 0xd2f4,
        kThieuthINieuncieuc               = 0xd2f5,
        kThieuthINieunhieuh               = 0xd2f6,
        kThieuthITikeut                   = 0xd2f7,
        kThieuthIRieul                    = 0xd2f8,
        kThieuthIRieulkiyeok              = 0xd2f9,
        kThieuthIRieulmieum               = 0xd2fa,
        kThieuthIRieulpieup               = 0xd2fb,
        kThieuthIRieulsios                = 0xd2fc,
        kThieuthIRieulthieuth             = 0xd2fd,
        kThieuthIRieulphieuph             = 0xd2fe,
        kThieuthIRieulhieuh               = 0xd2ff,
        kThieuthIMieum                    = 0xd300,
        kThieuthIPieup                    = 0xd301,
        kThieuthIPieupsios                = 0xd302,
        kThieuthISios                     = 0xd303,
        kThieuthISsangsios                = 0xd304,
        kThieuthIIeung                    = 0xd305,
        kThieuthICieuc                    = 0xd306,
        kThieuthIChieuch                  = 0xd307,
        kThieuthIKhieukh                  = 0xd308,
        kThieuthIThieuth                  = 0xd309,
        kThieuthIPhieuph                  = 0xd30a,
        kThieuthIHieuh                    = 0xd30b,
        kPhieuphA                         = 0xd30c,
        kPhieuphAKiyeok                   = 0xd30d,
        kPhieuphASsangkiyeok              = 0xd30e,
        kPhieuphAKiyeoksios               = 0xd30f,
        kPhieuphANieun                    = 0xd310,
        kPhieuphANieuncieuc               = 0xd311,
        kPhieuphANieunhieuh               = 0xd312,
        kPhieuphATikeut                   = 0xd313,
        kPhieuphARieul                    = 0xd314,
        kPhieuphARieulkiyeok              = 0xd315,
        kPhieuphARieulmieum               = 0xd316,
        kPhieuphARieulpieup               = 0xd317,
        kPhieuphARieulsios                = 0xd318,
        kPhieuphARieulthieuth             = 0xd319,
        kPhieuphARieulphieuph             = 0xd31a,
        kPhieuphARieulhieu                = 0xd31b,
        kPhieuphAMieum                    = 0xd31c,
        kPhieuphAPieup                    = 0xd31d,
        kPhieuphAPieupsio                 = 0xd31e,
        kPhieuphASios                     = 0xd31f,
        kPhieuphASsangsio                 = 0xd320,
        kPhieuphAIeung                    = 0xd321,
        kPhieuphACieuc                    = 0xd322,
        kPhieuphAChieuch                  = 0xd323,
        kPhieuphAKhieukh                  = 0xd324,
        kPhieuphAThieuth                  = 0xd325,
        kPhieuphAPhieuph                  = 0xd326,
        kPhieuphAHieuh                    = 0xd327,
        kPhieuphAe                        = 0xd328,
        kPhieuphAeKiyeok                  = 0xd329,
        kPhieuphAeSsangkiyeok             = 0xd32a,
        kPhieuphAeKiyeoksios              = 0xd32b,
        kPhieuphAeNieun                   = 0xd32c,
        kPhieuphAeNieuncieuc              = 0xd32d,
        kPhieuphAeNieunhieuh              = 0xd32e,
        kPhieuphAeTikeut                  = 0xd32f,
        kPhieuphAeRieul                   = 0xd330,
        kPhieuphAeRieulkiyeok             = 0xd331,
        kPhieuphAeRieulmieum              = 0xd332,
        kPhieuphAeRieulpieup              = 0xd333,
        kPhieuphAeRieulsios               = 0xd334,
        kPhieuphAeRieulthieuth            = 0xd335,
        kPhieuphAeRieulphieuph            = 0xd336,
        kPhieuphAeRieulhieuh              = 0xd337,
        kPhieuphAeMieum                   = 0xd338,
        kPhieuphAePieup                   = 0xd339,
        kPhieuphAePieupsios               = 0xd33a,
        kPhieuphAeSios                    = 0xd33b,
        kPhieuphAeSsangsios               = 0xd33c,
        kPhieuphAeIeung                   = 0xd33d,
        kPhieuphAeCieuc                   = 0xd33e,
        kPhieuphAeChieuch                 = 0xd33f,
        kPhieuphAeKhieukh                 = 0xd340,
        kPhieuphAeThieuth                 = 0xd341,
        kPhieuphAePhieuph                 = 0xd342,
        kPhieuphAeHieuh                   = 0xd343,
        kPhieuphYa                        = 0xd344,
        kPhieuphYaKiyeok                  = 0xd345,
        kPhieuphYaSsangkiyeok             = 0xd346,
        kPhieuphYaKiyeoksios              = 0xd347,
        kPhieuphYaNieun                   = 0xd348,
        kPhieuphYaNieuncieuc              = 0xd349,
        kPhieuphYaNieunhieuh              = 0xd34a,
        kPhieuphYaTikeut                  = 0xd34b,
        kPhieuphYaRieul                   = 0xd34c,
        kPhieuphYaRieulkiyeok             = 0xd34d,
        kPhieuphYaRieulmieum              = 0xd34e,
        kPhieuphYaRieulpieup              = 0xd34f,
        kPhieuphYaRieulsios               = 0xd350,
        kPhieuphYaRieulthieuth            = 0xd351,
        kPhieuphYaRieulphieuph            = 0xd352,
        kPhieuphYaRieulhieuh              = 0xd353,
        kPhieuphYaMieum                   = 0xd354,
        kPhieuphYaPieup                   = 0xd355,
        kPhieuphYaPieupsios               = 0xd356,
        kPhieuphYaSios                    = 0xd357,
        kPhieuphYaSsangsios               = 0xd358,
        kPhieuphYaIeung                   = 0xd359,
        kPhieuphYaCieuc                   = 0xd35a,
        kPhieuphYaChieuch                 = 0xd35b,
        kPhieuphYaKhieukh                 = 0xd35c,
        kPhieuphYaThieuth                 = 0xd35d,
        kPhieuphYaPhieuph                 = 0xd35e,
        kPhieuphYaHieuh                   = 0xd35f,
        kPhieuphYae                       = 0xd360,
        kPhieuphYaeKiyeok                 = 0xd361,
        kPhieuphYaeSsangkiyeok            = 0xd362,
        kPhieuphYaeKiyeoksios             = 0xd363,
        kPhieuphYaeNieun                  = 0xd364,
        kPhieuphYaeNieuncieuc             = 0xd365,
        kPhieuphYaeNieunhieuh             = 0xd366,
        kPhieuphYaeTikeut                 = 0xd367,
        kPhieuphYaeRieul                  = 0xd368,
        kPhieuphYaeRieulkiyeok            = 0xd369,
        kPhieuphYaeRieulmieum             = 0xd36a,
        kPhieuphYaeRieulpieup             = 0xd36b,
        kPhieuphYaeRieulsios              = 0xd36c,
        kPhieuphYaeRieulthieuth           = 0xd36d,
        kPhieuphYaeRieulphieuph           = 0xd36e,
        kPhieuphYaeRieulhieuh             = 0xd36f,
        kPhieuphYaeMieum                  = 0xd370,
        kPhieuphYaePieup                  = 0xd371,
        kPhieuphYaePieupsios              = 0xd372,
        kPhieuphYaeSios                   = 0xd373,
        kPhieuphYaeSsangsios              = 0xd374,
        kPhieuphYaeIeung                  = 0xd375,
        kPhieuphYaeCieuc                  = 0xd376,
        kPhieuphYaeChieuch                = 0xd377,
        kPhieuphYaeKhieukh                = 0xd378,
        kPhieuphYaeThieuth                = 0xd379,
        kPhieuphYaePhieuph                = 0xd37a,
        kPhieuphYaeHieuh                  = 0xd37b,
        kPhieuphEo                        = 0xd37c,
        kPhieuphEoKiyeok                  = 0xd37d,
        kPhieuphEoSsangkiyeok             = 0xd37e,
        kPhieuphEoKiyeoksios              = 0xd37f,
        kPhieuphEoNieun                   = 0xd380,
        kPhieuphEoNieuncieuc              = 0xd381,
        kPhieuphEoNieunhieuh              = 0xd382,
        kPhieuphEoTikeut                  = 0xd383,
        kPhieuphEoRieul                   = 0xd384,
        kPhieuphEoRieulkiyeok             = 0xd385,
        kPhieuphEoRieulmieum              = 0xd386,
        kPhieuphEoRieulpieup              = 0xd387,
        kPhieuphEoRieulsios               = 0xd388,
        kPhieuphEoRieulthieuth            = 0xd389,
        kPhieuphEoRieulphieuph            = 0xd38a,
        kPhieuphEoRieulhieuh              = 0xd38b,
        kPhieuphEoMieum                   = 0xd38c,
        kPhieuphEoPieup                   = 0xd38d,
        kPhieuphEoPieupsios               = 0xd38e,
        kPhieuphEoSios                    = 0xd38f,
        kPhieuphEoSsangsios               = 0xd390,
        kPhieuphEoIeung                   = 0xd391,
        kPhieuphEoCieuc                   = 0xd392,
        kPhieuphEoChieuch                 = 0xd393,
        kPhieuphEoKhieukh                 = 0xd394,
        kPhieuphEoThieuth                 = 0xd395,
        kPhieuphEoPhieuph                 = 0xd396,
        kPhieuphEoHieuh                   = 0xd397,
        kPhieuphE                         = 0xd398,
        kPhieuphEKiyeok                   = 0xd399,
        kPhieuphESsangkiyeok              = 0xd39a,
        kPhieuphEKiyeoksios               = 0xd39b,
        kPhieuphENieun                    = 0xd39c,
        kPhieuphENieuncieuc               = 0xd39d,
        kPhieuphENieunhieuh               = 0xd39e,
        kPhieuphETikeut                   = 0xd39f,
        kPhieuphERieul                    = 0xd3a0,
        kPhieuphERieulkiyeok              = 0xd3a1,
        kPhieuphERieulmieum               = 0xd3a2,
        kPhieuphERieulpieup               = 0xd3a3,
        kPhieuphERieulsios                = 0xd3a4,
        kPhieuphERieulthieuth             = 0xd3a5,
        kPhieuphERieulphieuph             = 0xd3a6,
        kPhieuphERieulhieuh               = 0xd3a7,
        kPhieuphEMieum                    = 0xd3a8,
        kPhieuphEPieup                    = 0xd3a9,
        kPhieuphEPieupsios                = 0xd3aa,
        kPhieuphESios                     = 0xd3ab,
        kPhieuphESsangsios                = 0xd3ac,
        kPhieuphEIeung                    = 0xd3ad,
        kPhieuphECieuc                    = 0xd3ae,
        kPhieuphEChieuch                  = 0xd3af,
        kPhieuphEKhieukh                  = 0xd3b0,
        kPhieuphEThieuth                  = 0xd3b1,
        kPhieuphEPhieuph                  = 0xd3b2,
        kPhieuphEHieuh                    = 0xd3b3,
        kPhieuphYeo                       = 0xd3b4,
        kPhieuphYeoKiyeok                 = 0xd3b5,
        kPhieuphYeoSsangkiyeok            = 0xd3b6,
        kPhieuphYeoKiyeoksios             = 0xd3b7,
        kPhieuphYeoNieun                  = 0xd3b8,
        kPhieuphYeoNieuncieuc             = 0xd3b9,
        kPhieuphYeoNieunhieuh             = 0xd3ba,
        kPhieuphYeoTikeut                 = 0xd3bb,
        kPhieuphYeoRieul                  = 0xd3bc,
        kPhieuphYeoRieulkiyeok            = 0xd3bd,
        kPhieuphYeoRieulmieum             = 0xd3be,
        kPhieuphYeoRieulpieup             = 0xd3bf,
        kPhieuphYeoRieulsios              = 0xd3c0,
        kPhieuphYeoRieulthieuth           = 0xd3c1,
        kPhieuphYeoRieulphieuph           = 0xd3c2,
        kPhieuphYeoRieulhieuh             = 0xd3c3,
        kPhieuphYeoMieum                  = 0xd3c4,
        kPhieuphYeoPieup                  = 0xd3c5,
        kPhieuphYeoPieupsios              = 0xd3c6,
        kPhieuphYeoSios                   = 0xd3c7,
        kPhieuphYeoSsangsios              = 0xd3c8,
        kPhieuphYeoIeung                  = 0xd3c9,
        kPhieuphYeoCieuc                  = 0xd3ca,
        kPhieuphYeoChieuch                = 0xd3cb,
        kPhieuphYeoKhieukh                = 0xd3cc,
        kPhieuphYeoThieuth                = 0xd3cd,
        kPhieuphYeoPhieuph                = 0xd3ce,
        kPhieuphYeoHieuh                  = 0xd3cf,
        kPhieuphYe                        = 0xd3d0,
        kPhieuphYeKiyeok                  = 0xd3d1,
        kPhieuphYeSsangkiyeok             = 0xd3d2,
        kPhieuphYeKiyeoksios              = 0xd3d3,
        kPhieuphYeNieun                   = 0xd3d4,
        kPhieuphYeNieuncieuc              = 0xd3d5,
        kPhieuphYeNieunhieuh              = 0xd3d6,
        kPhieuphYeTikeut                  = 0xd3d7,
        kPhieuphYeRieul                   = 0xd3d8,
        kPhieuphYeRieulkiyeok             = 0xd3d9,
        kPhieuphYeRieulmieum              = 0xd3da,
        kPhieuphYeRieulpieup              = 0xd3db,
        kPhieuphYeRieulsios               = 0xd3dc,
        kPhieuphYeRieulthieuth            = 0xd3dd,
        kPhieuphYeRieulphieuph            = 0xd3de,
        kPhieuphYeRieulhieuh              = 0xd3df,
        kPhieuphYeMieum                   = 0xd3e0,
        kPhieuphYePieup                   = 0xd3e1,
        kPhieuphYePieupsios               = 0xd3e2,
        kPhieuphYeSios                    = 0xd3e3,
        kPhieuphYeSsangsios               = 0xd3e4,
        kPhieuphYeIeung                   = 0xd3e5,
        kPhieuphYeCieuc                   = 0xd3e6,
        kPhieuphYeChieuch                 = 0xd3e7,
        kPhieuphYeKhieukh                 = 0xd3e8,
        kPhieuphYeThieuth                 = 0xd3e9,
        kPhieuphYePhieuph                 = 0xd3ea,
        kPhieuphYeHieuh                   = 0xd3eb,
        kPhieuphO                         = 0xd3ec,
        kPhieuphOKiyeok                   = 0xd3ed,
        kPhieuphOSsangkiyeok              = 0xd3ee,
        kPhieuphOKiyeoksios               = 0xd3ef,
        kPhieuphONieun                    = 0xd3f0,
        kPhieuphONieuncieuc               = 0xd3f1,
        kPhieuphONieunhieuh               = 0xd3f2,
        kPhieuphOTikeut                   = 0xd3f3,
        kPhieuphORieul                    = 0xd3f4,
        kPhieuphORieulkiyeok              = 0xd3f5,
        kPhieuphORieulmieum               = 0xd3f6,
        kPhieuphORieulpieup               = 0xd3f7,
        kPhieuphORieulsios                = 0xd3f8,
        kPhieuphORieulthieuth             = 0xd3f9,
        kPhieuphORieulphieuph             = 0xd3fa,
        kPhieuphORieulhieuh               = 0xd3fb,
        kPhieuphOMieum                    = 0xd3fc,
        kPhieuphOPieup                    = 0xd3fd,
        kPhieuphOPieupsios                = 0xd3fe,
        kPhieuphOSios                     = 0xd3ff,
        kPhieuphOSsangsios                = 0xd400,
        kPhieuphOIeung                    = 0xd401,
        kPhieuphOCieuc                    = 0xd402,
        kPhieuphOChieuch                  = 0xd403,
        kPhieuphOKhieukh                  = 0xd404,
        kPhieuphOThieuth                  = 0xd405,
        kPhieuphOPhieuph                  = 0xd406,
        kPhieuphOHieuh                    = 0xd407,
        kPhieuphWa                        = 0xd408,
        kPhieuphWaKiyeok                  = 0xd409,
        kPhieuphWaSsangkiyeok             = 0xd40a,
        kPhieuphWaKiyeoksios              = 0xd40b,
        kPhieuphWaNieun                   = 0xd40c,
        kPhieuphWaNieuncieuc              = 0xd40d,
        kPhieuphWaNieunhieuh              = 0xd40e,
        kPhieuphWaTikeut                  = 0xd40f,
        kPhieuphWaRieul                   = 0xd410,
        kPhieuphWaRieulkiyeok             = 0xd411,
        kPhieuphWaRieulmieum              = 0xd412,
        kPhieuphWaRieulpieup              = 0xd413,
        kPhieuphWaRieulsios               = 0xd414,
        kPhieuphWaRieulthieuth            = 0xd415,
        kPhieuphWaRieulphieuph            = 0xd416,
        kPhieuphWaRieulhieuh              = 0xd417,
        kPhieuphWaMieum                   = 0xd418,
        kPhieuphWaPieup                   = 0xd419,
        kPhieuphWaPieupsios               = 0xd41a,
        kPhieuphWaSios                    = 0xd41b,
        kPhieuphWaSsangsios               = 0xd41c,
        kPhieuphWaIeung                   = 0xd41d,
        kPhieuphWaCieuc                   = 0xd41e,
        kPhieuphWaChieuch                 = 0xd41f,
        kPhieuphWaKhieukh                 = 0xd420,
        kPhieuphWaThieuth                 = 0xd421,
        kPhieuphWaPhieuph                 = 0xd422,
        kPhieuphWaHieuh                   = 0xd423,
        kPhieuphWae                       = 0xd424,
        kPhieuphWaeKiyeok                 = 0xd425,
        kPhieuphWaeSsangkiyeok            = 0xd426,
        kPhieuphWaeKiyeoksios             = 0xd427,
        kPhieuphWaeNieun                  = 0xd428,
        kPhieuphWaeNieuncieuc             = 0xd429,
        kPhieuphWaeNieunhieuh             = 0xd42a,
        kPhieuphWaeTikeut                 = 0xd42b,
        kPhieuphWaeRieul                  = 0xd42c,
        kPhieuphWaeRieulkiyeok            = 0xd42d,
        kPhieuphWaeRieulmieum             = 0xd42e,
        kPhieuphWaeRieulpieup             = 0xd42f,
        kPhieuphWaeRieulsios              = 0xd430,
        kPhieuphWaeRieulthieuth           = 0xd431,
        kPhieuphWaeRieulphieuph           = 0xd432,
        kPhieuphWaeRieulhieuh             = 0xd433,
        kPhieuphWaeMieum                  = 0xd434,
        kPhieuphWaePieup                  = 0xd435,
        kPhieuphWaePieupsios              = 0xd436,
        kPhieuphWaeSios                   = 0xd437,
        kPhieuphWaeSsangsios              = 0xd438,
        kPhieuphWaeIeung                  = 0xd439,
        kPhieuphWaeCieuc                  = 0xd43a,
        kPhieuphWaeChieuch                = 0xd43b,
        kPhieuphWaeKhieukh                = 0xd43c,
        kPhieuphWaeThieuth                = 0xd43d,
        kPhieuphWaePhieuph                = 0xd43e,
        kPhieuphWaeHieuh                  = 0xd43f,
        kPhieuphOe                        = 0xd440,
        kPhieuphOeKiyeok                  = 0xd441,
        kPhieuphOeSsangkiyeok             = 0xd442,
        kPhieuphOeKiyeoksios              = 0xd443,
        kPhieuphOeNieun                   = 0xd444,
        kPhieuphOeNieuncieuc              = 0xd445,
        kPhieuphOeNieunhieuh              = 0xd446,
        kPhieuphOeTikeut                  = 0xd447,
        kPhieuphOeRieul                   = 0xd448,
        kPhieuphOeRieulkiyeok             = 0xd449,
        kPhieuphOeRieulmieum              = 0xd44a,
        kPhieuphOeRieulpieup              = 0xd44b,
        kPhieuphOeRieulsios               = 0xd44c,
        kPhieuphOeRieulthieuth            = 0xd44d,
        kPhieuphOeRieulphieuph            = 0xd44e,
        kPhieuphOeRieulhieuh              = 0xd44f,
        kPhieuphOeMieum                   = 0xd450,
        kPhieuphOePieup                   = 0xd451,
        kPhieuphOePieupsios               = 0xd452,
        kPhieuphOeSios                    = 0xd453,
        kPhieuphOeSsangsios               = 0xd454,
        kPhieuphOeIeung                   = 0xd455,
        kPhieuphOeCieuc                   = 0xd456,
        kPhieuphOeChieuch                 = 0xd457,
        kPhieuphOeKhieukh                 = 0xd458,
        kPhieuphOeThieuth                 = 0xd459,
        kPhieuphOePhieuph                 = 0xd45a,
        kPhieuphOeHieuh                   = 0xd45b,
        kPhieuphYo                        = 0xd45c,
        kPhieuphYoKiyeok                  = 0xd45d,
        kPhieuphYoSsangkiyeok             = 0xd45e,
        kPhieuphYoKiyeoksios              = 0xd45f,
        kPhieuphYoNieun                   = 0xd460,
        kPhieuphYoNieuncieuc              = 0xd461,
        kPhieuphYoNieunhieuh              = 0xd462,
        kPhieuphYoTikeut                  = 0xd463,
        kPhieuphYoRieul                   = 0xd464,
        kPhieuphYoRieulkiyeok             = 0xd465,
        kPhieuphYoRieulmieum              = 0xd466,
        kPhieuphYoRieulpieup              = 0xd467,
        kPhieuphYoRieulsios               = 0xd468,
        kPhieuphYoRieulthieuth            = 0xd469,
        kPhieuphYoRieulphieuph            = 0xd46a,
        kPhieuphYoRieulhieuh              = 0xd46b,
        kPhieuphYoMieum                   = 0xd46c,
        kPhieuphYoPieup                   = 0xd46d,
        kPhieuphYoPieupsios               = 0xd46e,
        kPhieuphYoSios                    = 0xd46f,
        kPhieuphYoSsangsios               = 0xd470,
        kPhieuphYoIeung                   = 0xd471,
        kPhieuphYoCieuc                   = 0xd472,
        kPhieuphYoChieuch                 = 0xd473,
        kPhieuphYoKhieukh                 = 0xd474,
        kPhieuphYoThieuth                 = 0xd475,
        kPhieuphYoPhieuph                 = 0xd476,
        kPhieuphYoHieuh                   = 0xd477,
        kPhieuphU                         = 0xd478,
        kPhieuphUKiyeok                   = 0xd479,
        kPhieuphUSsangkiyeok              = 0xd47a,
        kPhieuphUKiyeoksios               = 0xd47b,
        kPhieuphUNieun                    = 0xd47c,
        kPhieuphUNieuncieuc               = 0xd47d,
        kPhieuphUNieunhieuh               = 0xd47e,
        kPhieuphUTikeut                   = 0xd47f,
        kPhieuphURieul                    = 0xd480,
        kPhieuphURieulkiyeok              = 0xd481,
        kPhieuphURieulmieum               = 0xd482,
        kPhieuphURieulpieup               = 0xd483,
        kPhieuphURieulsios                = 0xd484,
        kPhieuphURieulthieuth             = 0xd485,
        kPhieuphURieulphieuph             = 0xd486,
        kPhieuphURieulhieuh               = 0xd487,
        kPhieuphUMieum                    = 0xd488,
        kPhieuphUPieup                    = 0xd489,
        kPhieuphUPieupsios                = 0xd48a,
        kPhieuphUSios                     = 0xd48b,
        kPhieuphUSsangsios                = 0xd48c,
        kPhieuphUIeung                    = 0xd48d,
        kPhieuphUCieuc                    = 0xd48e,
        kPhieuphUChieuch                  = 0xd48f,
        kPhieuphUKhieukh                  = 0xd490,
        kPhieuphUThieuth                  = 0xd491,
        kPhieuphUPhieuph                  = 0xd492,
        kPhieuphUHieuh                    = 0xd493,
        kPhieuphWeo                       = 0xd494,
        kPhieuphWeoKiyeok                 = 0xd495,
        kPhieuphWeoSsangkiyeok            = 0xd496,
        kPhieuphWeoKiyeoksios             = 0xd497,
        kPhieuphWeoNieun                  = 0xd498,
        kPhieuphWeoNieuncieuc             = 0xd499,
        kPhieuphWeoNieunhieuh             = 0xd49a,
        kPhieuphWeoTikeut                 = 0xd49b,
        kPhieuphWeoRieul                  = 0xd49c,
        kPhieuphWeoRieulkiyeok            = 0xd49d,
        kPhieuphWeoRieulmieum             = 0xd49e,
        kPhieuphWeoRieulpieup             = 0xd49f,
        kPhieuphWeoRieulsios              = 0xd4a0,
        kPhieuphWeoRieulthieuth           = 0xd4a1,
        kPhieuphWeoRieulphieuph           = 0xd4a2,
        kPhieuphWeoRieulhieuh             = 0xd4a3,
        kPhieuphWeoMieum                  = 0xd4a4,
        kPhieuphWeoPieup                  = 0xd4a5,
        kPhieuphWeoPieupsios              = 0xd4a6,
        kPhieuphWeoSios                   = 0xd4a7,
        kPhieuphWeoSsangsios              = 0xd4a8,
        kPhieuphWeoIeung                  = 0xd4a9,
        kPhieuphWeoCieuc                  = 0xd4aa,
        kPhieuphWeoChieuch                = 0xd4ab,
        kPhieuphWeoKhieukh                = 0xd4ac,
        kPhieuphWeoThieuth                = 0xd4ad,
        kPhieuphWeoPhieuph                = 0xd4ae,
        kPhieuphWeoHieuh                  = 0xd4af,
        kPhieuphWe                        = 0xd4b0,
        kPhieuphWeKiyeok                  = 0xd4b1,
        kPhieuphWeSsangkiyeok             = 0xd4b2,
        kPhieuphWeKiyeoksios              = 0xd4b3,
        kPhieuphWeNieun                   = 0xd4b4,
        kPhieuphWeNieuncieuc              = 0xd4b5,
        kPhieuphWeNieunhieuh              = 0xd4b6,
        kPhieuphWeTikeut                  = 0xd4b7,
        kPhieuphWeRieul                   = 0xd4b8,
        kPhieuphWeRieulkiyeok             = 0xd4b9,
        kPhieuphWeRieulmieum              = 0xd4ba,
        kPhieuphWeRieulpieup              = 0xd4bb,
        kPhieuphWeRieulsios               = 0xd4bc,
        kPhieuphWeRieulthieuth            = 0xd4bd,
        kPhieuphWeRieulphieuph            = 0xd4be,
        kPhieuphWeRieulhieuh              = 0xd4bf,
        kPhieuphWeMieum                   = 0xd4c0,
        kPhieuphWePieup                   = 0xd4c1,
        kPhieuphWePieupsios               = 0xd4c2,
        kPhieuphWeSios                    = 0xd4c3,
        kPhieuphWeSsangsios               = 0xd4c4,
        kPhieuphWeIeung                   = 0xd4c5,
        kPhieuphWeCieuc                   = 0xd4c6,
        kPhieuphWeChieuch                 = 0xd4c7,
        kPhieuphWeKhieukh                 = 0xd4c8,
        kPhieuphWeThieuth                 = 0xd4c9,
        kPhieuphWePhieuph                 = 0xd4ca,
        kPhieuphWeHieuh                   = 0xd4cb,
        kPhieuphWi                        = 0xd4cc,
        kPhieuphWiKiyeok                  = 0xd4cd,
        kPhieuphWiSsangkiyeok             = 0xd4ce,
        kPhieuphWiKiyeoksios              = 0xd4cf,
        kPhieuphWiNieun                   = 0xd4d0,
        kPhieuphWiNieuncieuc              = 0xd4d1,
        kPhieuphWiNieunhieuh              = 0xd4d2,
        kPhieuphWiTikeut                  = 0xd4d3,
        kPhieuphWiRieul                   = 0xd4d4,
        kPhieuphWiRieulkiyeok             = 0xd4d5,
        kPhieuphWiRieulmieum              = 0xd4d6,
        kPhieuphWiRieulpieup              = 0xd4d7,
        kPhieuphWiRieulsios               = 0xd4d8,
        kPhieuphWiRieulthieuth            = 0xd4d9,
        kPhieuphWiRieulphieuph            = 0xd4da,
        kPhieuphWiRieulhieuh              = 0xd4db,
        kPhieuphWiMieum                   = 0xd4dc,
        kPhieuphWiPieup                   = 0xd4dd,
        kPhieuphWiPieupsios               = 0xd4de,
        kPhieuphWiSios                    = 0xd4df,
        kPhieuphWiSsangsios               = 0xd4e0,
        kPhieuphWiIeung                   = 0xd4e1,
        kPhieuphWiCieuc                   = 0xd4e2,
        kPhieuphWiChieuch                 = 0xd4e3,
        kPhieuphWiKhieukh                 = 0xd4e4,
        kPhieuphWiThieuth                 = 0xd4e5,
        kPhieuphWiPhieuph                 = 0xd4e6,
        kPhieuphWiHieuh                   = 0xd4e7,
        kPhieuphYu                        = 0xd4e8,
        kPhieuphYuKiyeok                  = 0xd4e9,
        kPhieuphYuSsangkiyeok             = 0xd4ea,
        kPhieuphYuKiyeoksios              = 0xd4eb,
        kPhieuphYuNieun                   = 0xd4ec,
        kPhieuphYuNieuncieuc              = 0xd4ed,
        kPhieuphYuNieunhieuh              = 0xd4ee,
        kPhieuphYuTikeut                  = 0xd4ef,
        kPhieuphYuRieul                   = 0xd4f0,
        kPhieuphYuRieulkiyeok             = 0xd4f1,
        kPhieuphYuRieulmieum              = 0xd4f2,
        kPhieuphYuRieulpieup              = 0xd4f3,
        kPhieuphYuRieulsios               = 0xd4f4,
        kPhieuphYuRieulthieuth            = 0xd4f5,
        kPhieuphYuRieulphieuph            = 0xd4f6,
        kPhieuphYuRieulhieuh              = 0xd4f7,
        kPhieuphYuMieum                   = 0xd4f8,
        kPhieuphYuPieup                   = 0xd4f9,
        kPhieuphYuPieupsios               = 0xd4fa,
        kPhieuphYuSios                    = 0xd4fb,
        kPhieuphYuSsangsios               = 0xd4fc,
        kPhieuphYuIeung                   = 0xd4fd,
        kPhieuphYuCieuc                   = 0xd4fe,
        kPhieuphYuChieuch                 = 0xd4ff,
        kPhieuphYuKhieukh                 = 0xd500,
        kPhieuphYuThieuth                 = 0xd501,
        kPhieuphYuPhieuph                 = 0xd502,
        kPhieuphYuHieuh                   = 0xd503,
        kPhieuphEu                        = 0xd504,
        kPhieuphEuKiyeok                  = 0xd505,
        kPhieuphEuSsangkiyeok             = 0xd506,
        kPhieuphEuKiyeoksios              = 0xd507,
        kPhieuphEuNieun                   = 0xd508,
        kPhieuphEuNieuncieuc              = 0xd509,
        kPhieuphEuNieunhieuh              = 0xd50a,
        kPhieuphEuTikeut                  = 0xd50b,
        kPhieuphEuRieul                   = 0xd50c,
        kPhieuphEuRieulkiyeok             = 0xd50d,
        kPhieuphEuRieulmieum              = 0xd50e,
        kPhieuphEuRieulpieup              = 0xd50f,
        kPhieuphEuRieulsios               = 0xd510,
        kPhieuphEuRieulthieuth            = 0xd511,
        kPhieuphEuRieulphieuph            = 0xd512,
        kPhieuphEuRieulhieuh              = 0xd513,
        kPhieuphEuMieum                   = 0xd514,
        kPhieuphEuPieup                   = 0xd515,
        kPhieuphEuPieupsios               = 0xd516,
        kPhieuphEuSios                    = 0xd517,
        kPhieuphEuSsangsios               = 0xd518,
        kPhieuphEuIeung                   = 0xd519,
        kPhieuphEuCieuc                   = 0xd51a,
        kPhieuphEuChieuch                 = 0xd51b,
        kPhieuphEuKhieukh                 = 0xd51c,
        kPhieuphEuThieuth                 = 0xd51d,
        kPhieuphEuPhieuph                 = 0xd51e,
        kPhieuphEuHieuh                   = 0xd51f,
        kPhieuphYi                        = 0xd520,
        kPhieuphYiKiyeok                  = 0xd521,
        kPhieuphYiSsangkiyeok             = 0xd522,
        kPhieuphYiKiyeoksios              = 0xd523,
        kPhieuphYiNieun                   = 0xd524,
        kPhieuphYiNieuncieuc              = 0xd525,
        kPhieuphYiNieunhieuh              = 0xd526,
        kPhieuphYiTikeut                  = 0xd527,
        kPhieuphYiRieul                   = 0xd528,
        kPhieuphYiRieulkiyeok             = 0xd529,
        kPhieuphYiRieulmieum              = 0xd52a,
        kPhieuphYiRieulpieup              = 0xd52b,
        kPhieuphYiRieulsios               = 0xd52c,
        kPhieuphYiRieulthieuth            = 0xd52d,
        kPhieuphYiRieulphieuph            = 0xd52e,
        kPhieuphYiRieulhieuh              = 0xd52f,
        kPhieuphYiMieum                   = 0xd530,
        kPhieuphYiPieup                   = 0xd531,
        kPhieuphYiPieupsios               = 0xd532,
        kPhieuphYiSios                    = 0xd533,
        kPhieuphYiSsangsios               = 0xd534,
        kPhieuphYiIeung                   = 0xd535,
        kPhieuphYiCieuc                   = 0xd536,
        kPhieuphYiChieuch                 = 0xd537,
        kPhieuphYiKhieukh                 = 0xd538,
        kPhieuphYiThieuth                 = 0xd539,
        kPhieuphYiPhieuph                 = 0xd53a,
        kPhieuphYiHieuh                   = 0xd53b,
        kPhieuphI                         = 0xd53c,
        kPhieuphIKiyeok                   = 0xd53d,
        kPhieuphISsangkiyeok              = 0xd53e,
        kPhieuphIKiyeoksios               = 0xd53f,
        kPhieuphINieun                    = 0xd540,
        kPhieuphINieuncieuc               = 0xd541,
        kPhieuphINieunhieuh               = 0xd542,
        kPhieuphITikeut                   = 0xd543,
        kPhieuphIRieul                    = 0xd544,
        kPhieuphIRieulkiyeok              = 0xd545,
        kPhieuphIRieulmieum               = 0xd546,
        kPhieuphIRieulpieup               = 0xd547,
        kPhieuphIRieulsios                = 0xd548,
        kPhieuphIRieulthieuth             = 0xd549,
        kPhieuphIRieulphieuph             = 0xd54a,
        kPhieuphIRieulhieuh               = 0xd54b,
        kPhieuphIMieum                    = 0xd54c,
        kPhieuphIPieup                    = 0xd54d,
        kPhieuphIPieupsios                = 0xd54e,
        kPhieuphISios                     = 0xd54f,
        kPhieuphISsangsios                = 0xd550,
        kPhieuphIIeung                    = 0xd551,
        kPhieuphICieuc                    = 0xd552,
        kPhieuphIChieuch                  = 0xd553,
        kPhieuphIKhieukh                  = 0xd554,
        kPhieuphIThieuth                  = 0xd555,
        kPhieuphIPhieuph                  = 0xd556,
        kPhieuphIHieuh                    = 0xd557,
        kHieuhA                           = 0xd558,
        kHieuhAKiyeok                     = 0xd559,
        kHieuhASsangkiyeok                = 0xd55a,
        kHieuhAKiyeoksios                 = 0xd55b,
        kHieuhANieun                      = 0xd55c,
        kHieuhANieuncieuc                 = 0xd55d,
        kHieuhANieunhieuh                 = 0xd55e,
        kHieuhATikeut                     = 0xd55f,
        kHieuhARieul                      = 0xd560,
        kHieuhARieulkiyeok                = 0xd561,
        kHieuhARieulmieum                 = 0xd562,
        kHieuhARieulpieup                 = 0xd563,
        kHieuhARieulsios                  = 0xd564,
        kHieuhARieulthieuth               = 0xd565,
        kHieuhARieulphieuph               = 0xd566,
        kHieuhARieulhieuh                 = 0xd567,
        kHieuhAMieum                      = 0xd568,
        kHieuhAPieup                     = 0xd569,
        kHieuhAPieupsios                 = 0xd56a,
        kHieuhASios                      = 0xd56b,
        kHieuhASsangsios                 = 0xd56c,
        kHieuhAIeung                     = 0xd56d,
        kHieuhACieuc                     = 0xd56e,
        kHieuhAChieuch                   = 0xd56f,
        kHieuhAKhieukh                   = 0xd570,
        kHieuhAThieuth                   = 0xd571,
        kHieuhAPhieuph                   = 0xd572,
        kHieuhAHieuh                     = 0xd573,
        kHieuhAe                         = 0xd574,
        kHieuhAeKiyeok                   = 0xd575,
        kHieuhAeSsangkiyeok              = 0xd576,
        kHieuhAeKiyeoksios               = 0xd577,
        kHieuhAeNieun                    = 0xd578,
        kHieuhAeNieuncieuc               = 0xd579,
        kHieuhAeNieunhieuh               = 0xd57a,
        kHieuhAeTikeut                   = 0xd57b,
        kHieuhAeRieul                    = 0xd57c,
        kHieuhAeRieulkiyeok              = 0xd57d,
        kHieuhAeRieulmieum               = 0xd57e,
        kHieuhAeRieulpieup               = 0xd57f,
        kHieuhAeRieulsios                = 0xd580,
        kHieuhAeRieulthieuth             = 0xd581,
        kHieuhAeRieulphieuph             = 0xd582,
        kHieuhAeRieulhieuh               = 0xd583,
        kHieuhAeMieum                    = 0xd584,
        kHieuhAePieup                    = 0xd585,
        kHieuhAePieupsios                = 0xd586,
        kHieuhAeSios                     = 0xd587,
        kHieuhAeSsangsios                = 0xd588,
        kHieuhAeIeung                    = 0xd589,
        kHieuhAeCieuc                    = 0xd58a,
        kHieuhAeChieuch                  = 0xd58b,
        kHieuhAeKhieukh                  = 0xd58c,
        kHieuhAeThieuth                  = 0xd58d,
        kHieuhAePhieuph                  = 0xd58e,
        kHieuhAeHieuh                    = 0xd58f,
        kHieuhYa                         = 0xd590,
        kHieuhYaKiyeok                   = 0xd591,
        kHieuhYaSsangkiyeok              = 0xd592,
        kHieuhYaKiyeoksios               = 0xd593,
        kHieuhYaNieun                    = 0xd594,
        kHieuhYaNieuncieuc               = 0xd595,
        kHieuhYaNieunhieuh               = 0xd596,
        kHieuhYaTikeut                   = 0xd597,
        kHieuhYaRieul                    = 0xd598,
        kHieuhYaRieulkiyeok              = 0xd599,
        kHieuhYaRieulmieum               = 0xd59a,
        kHieuhYaRieulpieup               = 0xd59b,
        kHieuhYaRieulsios                = 0xd59c,
        kHieuhYaRieulthieuth             = 0xd59d,
        kHieuhYaRieulphieuph             = 0xd59e,
        kHieuhYaRieulhieuh               = 0xd59f,
        kHieuhYaMieum                    = 0xd5a0,
        kHieuhYaPieup                    = 0xd5a1,
        kHieuhYaPieupsios                = 0xd5a2,
        kHieuhYaSios                     = 0xd5a3,
        kHieuhYaSsangsios                = 0xd5a4,
        kHieuhYaIeung                    = 0xd5a5,
        kHieuhYaCieuc                    = 0xd5a6,
        kHieuhYaChieuch                  = 0xd5a7,
        kHieuhYaKhieukh                  = 0xd5a8,
        kHieuhYaThieuth                  = 0xd5a9,
        kHieuhYaPhieuph                  = 0xd5aa,
        kHieuhYaHieuh                    = 0xd5ab,
        kHieuhYae                        = 0xd5ac,
        kHieuhYaeKiyeok                  = 0xd5ad,
        kHieuhYaeSsangkiyeok             = 0xd5ae,
        kHieuhYaeKiyeoksios              = 0xd5af,
        kHieuhYaeNieun                   = 0xd5b0,
        kHieuhYaeNieuncieuc              = 0xd5b1,
        kHieuhYaeNieunhieuh              = 0xd5b2,
        kHieuhYaeTikeut                  = 0xd5b3,
        kHieuhYaeRieul                   = 0xd5b4,
        kHieuhYaeRieulkiyeok             = 0xd5b5,
        kHieuhYaeRieulmieum              = 0xd5b6,
        kHieuhYaeRieulpieup              = 0xd5b7,
        kHieuhYaeRieulsios               = 0xd5b8,
        kHieuhYaeRieulthieuth            = 0xd5b9,
        kHieuhYaeRieulphieuph            = 0xd5ba,
        kHieuhYaeRieulhieuh              = 0xd5bb,
        kHieuhYaeMieum                   = 0xd5bc,
        kHieuhYaePieup                   = 0xd5bd,
        kHieuhYaePieupsios               = 0xd5be,
        kHieuhYaeSios                    = 0xd5bf,
        kHieuhYaeSsangsios               = 0xd5c0,
        kHieuhYaeIeung                   = 0xd5c1,
        kHieuhYaeCieuc                   = 0xd5c2,
        kHieuhYaeChieuch                 = 0xd5c3,
        kHieuhYaeKhieukh                 = 0xd5c4,
        kHieuhYaeThieuth                 = 0xd5c5,
        kHieuhYaePhieuph                 = 0xd5c6,
        kHieuhYaeHieuh                   = 0xd5c7,
        kHieuhEo                         = 0xd5c8,
        kHieuhEoKiyeok                   = 0xd5c9,
        kHieuhEoSsangkiyeok              = 0xd5ca,
        kHieuhEoKiyeoksios               = 0xd5cb,
        kHieuhEoNieun                    = 0xd5cc,
        kHieuhEoNieuncieuc               = 0xd5cd,
        kHieuhEoNieunhieuh               = 0xd5ce,
        kHieuhEoTikeut                   = 0xd5cf,
        kHieuhEoRieul                    = 0xd5d0,
        kHieuhEoRieulkiyeok              = 0xd5d1,
        kHieuhEoRieulmieum               = 0xd5d2,
        kHieuhEoRieulpieup               = 0xd5d3,
        kHieuhEoRieulsios                = 0xd5d4,
        kHieuhEoRieulthieuth             = 0xd5d5,
        kHieuhEoRieulphieuph             = 0xd5d6,
        kHieuhEoRieulhieuh               = 0xd5d7,
        kHieuhEoMieum                    = 0xd5d8,
        kHieuhEoPieup                    = 0xd5d9,
        kHieuhEoPieupsios                = 0xd5da,
        kHieuhEoSios                     = 0xd5db,
        kHieuhEoSsangsios                = 0xd5dc,
        kHieuhEoIeung                    = 0xd5dd,
        kHieuhEoCieuc                    = 0xd5de,
        kHieuhEoChieuch                  = 0xd5df,
        kHieuhEoKhieukh                  = 0xd5e0,
        kHieuhEoThieuth                  = 0xd5e1,
        kHieuhEoPhieuph                  = 0xd5e2,
        kHieuhEoHieuh                    = 0xd5e3,
        kHieuhE                           = 0xd5e4,
        kHieuhEKiyeok                         = 0xd5e5,
        kHieuhESsangkiyeok                = 0xd5e6,
        kHieuhEKiyeoksios                 = 0xd5e7,
        kHieuhENieun                      = 0xd5e8,
        kHieuhENieuncieuc                 = 0xd5e9,
        kHieuhENieunhieuh                 = 0xd5ea,
        kHieuhETikeut                     = 0xd5eb,
        kHieuhERieul                      = 0xd5ec,
        kHieuhERieulkiyeok                = 0xd5ed,
        kHieuhERieulmieum                 = 0xd5ee,
        kHieuhERieulpieup                 = 0xd5ef,
        kHieuhERieulsios                  = 0xd5f0,
        kHieuhERieulthieuth               = 0xd5f1,
        kHieuhERieulphieuph               = 0xd5f2,
        kHieuhERieulhieuh                 = 0xd5f3,
        kHieuhEMieum                      = 0xd5f4,
        kHieuhEPieup                      = 0xd5f5,
        kHieuhEPieupsios                  = 0xd5f6,
        kHieuhESios                       = 0xd5f7,
        kHieuhESsangsios                  = 0xd5f8,
        kHieuhEIeung                      = 0xd5f9,
        kHieuhECieuc                      = 0xd5fa,
        kHieuhEChieuch                    = 0xd5fb,
        kHieuhEKhieukh                    = 0xd5fc,
        kHieuhEThieuth                    = 0xd5fd,
        kHieuhEPhieuph                    = 0xd5fe,
        kHieuhEHieuh                      = 0xd5ff,
        kHieuhYeo                         = 0xd600,
        kHieuhYeoKiyeok                   = 0xd601,
        kHieuhYeoSsangkiyeok              = 0xd602,
        kHieuhYeoKiyeoksios               = 0xd603,
        kHieuhYeoNieun                    = 0xd604,
        kHieuhYeoNieuncieuc               = 0xd605,
        kHieuhYeoNieunhieuh               = 0xd606,
        kHieuhYeoTikeut                   = 0xd607,
        kHieuhYeoRieul                    = 0xd608,
        kHieuhYeoRieulkiyeok              = 0xd609,
        kHieuhYeoRieulmieum               = 0xd60a,
        kHieuhYeoRieulpieup               = 0xd60b,
        kHieuhYeoRieulsios                = 0xd60c,
        kHieuhYeoRieulthieuth             = 0xd60d,
        kHieuhYeoRieulphieuph             = 0xd60e,
        kHieuhYeoRieulhieuh               = 0xd60f,
        kHieuhYeoMieum                    = 0xd610,
        kHieuhYeoPieup                    = 0xd611,
        kHieuhYeoPieupsios                = 0xd612,
        kHieuhYeoSios                     = 0xd613,
        kHieuhYeoSsangsios                = 0xd614,
        kHieuhYeoIeung                    = 0xd615,
        kHieuhYeoCieuc                    = 0xd616,
        kHieuhYeoChieuch                  = 0xd617,
        kHieuhYeoKhieukh                  = 0xd618,
        kHieuhYeoThieuth                  = 0xd619,
        kHieuhYeoPhieuph                  = 0xd61a,
        kHieuhYeoHieuh                    = 0xd61b,
        kHieuhYe                          = 0xd61c,
        kHieuhYeKiyeok                    = 0xd61d,
        kHieuhYeSsangkiyeok               = 0xd61e,
        kHieuhYeKiyeoksios                = 0xd61f,
        kHieuhYeNieun                     = 0xd620,
        kHieuhYeNieuncieuc                = 0xd621,
        kHieuhYeNieunhieuh                = 0xd622,
        kHieuhYeTikeut                    = 0xd623,
        kHieuhYeRieul                     = 0xd624,
        kHieuhYeRieulkiyeok               = 0xd625,
        kHieuhYeRieulmieum                = 0xd626,
        kHieuhYeRieulpieup                = 0xd627,
        kHieuhYeRieulsios                 = 0xd628,
        kHieuhYeRieulthieuth              = 0xd629,
        kHieuhYeRieulphieuph              = 0xd62a,
        kHieuhYeRieulhieuh                = 0xd62b,
        kHieuhYeMieum                     = 0xd62c,
        kHieuhYePieup                     = 0xd62d,
        kHieuhYePieupsios                 = 0xd62e,
        kHieuhYeSios                      = 0xd62f,
        kHieuhYeSsangsios                 = 0xd630,
        kHieuhYeIeung                     = 0xd631,
        kHieuhYeCieuc                     = 0xd632,
        kHieuhYeChieuch                   = 0xd633,
        kHieuhYeKhieukh                   = 0xd634,
        kHieuhYeThieuth                   = 0xd635,
        kHieuhYePhieuph                   = 0xd636,
        kHieuhYeHieuh                     = 0xd637,
        kHieuhO                           = 0xd638,
        kHieuhOKiyeok                     = 0xd639,
        kHieuhOSsangkiyeok                = 0xd63a,
        kHieuhOKiyeoksios                 = 0xd63b,
        kHieuhONieun                      = 0xd63c,
        kHieuhONieuncieuc                 = 0xd63d,
        kHieuhONieunhieuh                 = 0xd63e,
        kHieuhOTikeut                     = 0xd63f,
        kHieuhORieul                      = 0xd640,
        kHieuhORieulkiyeok                = 0xd641,
        kHieuhORieulmieum                 = 0xd642,
        kHieuhORieulpieup                 = 0xd643,
        kHieuhORieulsios                  = 0xd644,
        kHieuhORieulthieuth               = 0xd645,
        kHieuhORieulphieuph               = 0xd646,
        kHieuhORieulhieuh                 = 0xd647,
        kHieuhOMieum                      = 0xd648,
        kHieuhOPieup                      = 0xd649,
        kHieuhOPieupsios                  = 0xd64a,
        kHieuhOSios                       = 0xd64b,
        kHieuhOSsangsios                  = 0xd64c,
        kHieuhOIeung                      = 0xd64d,
        kHieuhOCieuc                      = 0xd64e,
        kHieuhOChieuch                    = 0xd64f,
        kHieuhOKhieukh                    = 0xd650,
        kHieuhOThieuth                    = 0xd651,
        kHieuhOPhieuph                    = 0xd652,
        kHieuhOHieuh                      = 0xd653,
        kHieuhWa                          = 0xd654,
        kHieuhWaKiyeok                    = 0xd655,
        kHieuhWaSsangkiyeok               = 0xd656,
        kHieuhWaKiyeoksios                = 0xd657,
        kHieuhWaNieun                     = 0xd658,
        kHieuhWaNieuncieuc                = 0xd659,
        kHieuhWaNieunhieuh                = 0xd65a,
        kHieuhWaTikeut                    = 0xd65b,
        kHieuhWaRieul                     = 0xd65c,
        kHieuhWaRieulkiyeok               = 0xd65d,
        kHieuhWaRieulmieum                = 0xd65e,
        kHieuhWaRieulpieup                = 0xd65f,
        kHieuhWaRieulsios                 = 0xd660,
        kHieuhWaRieulthieuth              = 0xd661,
        kHieuhWaRieulphieuph              = 0xd662,
        kHieuhWaRieulhieuh                = 0xd663,
        kHieuhWaMieum                     = 0xd664,
        kHieuhWaPieup                     = 0xd665,
        kHieuhWaPieupsios                 = 0xd666,
        kHieuhWaSios                      = 0xd667,
        kHieuhWaSsangsios                 = 0xd668,
        kHieuhWaIeung                     = 0xd669,
        kHieuhWaCieuc                     = 0xd66a,
        kHieuhWaChieuch                   = 0xd66b,
        kHieuhWaKhieukh                   = 0xd66c,
        kHieuhWaThieuth                   = 0xd66d,
        kHieuhWaPhieuph                   = 0xd66e,
        kHieuhWaHieuh                     = 0xd66f,
        kHieuhWae                         = 0xd670,
        kHieuhWaeKiyeok                   = 0xd671,
        kHieuhWaeSsangkiyeok              = 0xd672,
        kHieuhWaeKiyeoksios               = 0xd673,
        kHieuhWaeNieun                    = 0xd674,
        kHieuhWaeNieuncieuc               = 0xd675,
        kHieuhWaeNieunhieuh               = 0xd676,
        kHieuhWaeTikeut                   = 0xd677,
        kHieuhWaeRieul                    = 0xd678,
        kHieuhWaeRieulkiyeok              = 0xd679,
        kHieuhWaeRieulmieum               = 0xd67a,
        kHieuhWaeRieulpieup               = 0xd67b,
        kHieuhWaeRieulsios                = 0xd67c,
        kHieuhWaeRieulthieuth             = 0xd67d,
        kHieuhWaeRieulphieuph             = 0xd67e,
        kHieuhWaeRieulhieuh               = 0xd67f,
        kHieuhWaeMieum                    = 0xd680,
        kHieuhWaePieup                    = 0xd681,
        kHieuhWaePieupsios                = 0xd682,
        kHieuhWaeSios                     = 0xd683,
        kHieuhWaeSsangsios                = 0xd684,
        kHieuhWaeIeung                    = 0xd685,
        kHieuhWaeCieuc                    = 0xd686,
        kHieuhWaeChieuch                  = 0xd687,
        kHieuhWaeKhieukh                  = 0xd688,
        kHieuhWaeThieuth                  = 0xd689,
        kHieuhWaePhieuph                  = 0xd68a,
        kHieuhWaeHieuh                    = 0xd68b,
        kHieuhOe                          = 0xd68c,
        kHieuhOeKiyeok                    = 0xd68d,
        kHieuhOeSsangkiyeok               = 0xd68e,
        kHieuhOeKiyeoksios                = 0xd68f,
        kHieuhOeNieun                     = 0xd690,
        kHieuhOeNieuncieuc                = 0xd691,
        kHieuhOeNieunhieuh                = 0xd692,
        kHieuhOeTikeut                    = 0xd693,
        kHieuhOeRieul                     = 0xd694,
        kHieuhOeRieulkiyeok               = 0xd695,
        kHieuhOeRieulmieum                = 0xd696,
        kHieuhOeRieulpieup                = 0xd697,
        kHieuhOeRieulsios                 = 0xd698,
        kHieuhOeRieulthieuth              = 0xd699,
        kHieuhOeRieulphieuph              = 0xd69a,
        kHieuhOeRieulhieuh                = 0xd69b,
        kHieuhOeMieum                     = 0xd69c,
        kHieuhOePieup                     = 0xd69d,
        kHieuhOePieupsios                 = 0xd69e,
        kHieuhOeSios                      = 0xd69f,
        kHieuhOeSsangsios                 = 0xd6a0,
        kHieuhOeIeung                     = 0xd6a1,
        kHieuhOeCieuc                     = 0xd6a2,
        kHieuhOeChieuch                   = 0xd6a3,
        kHieuhOeKhieukh                   = 0xd6a4,
        kHieuhOeThieuth                   = 0xd6a5,
        kHieuhOePhieuph                   = 0xd6a6,
        kHieuhOeHieuh                     = 0xd6a7,
        kHieuhYo                          = 0xd6a8,
        kHieuhYoKiyeok                    = 0xd6a9,
        kHieuhYoSsangkiyeok               = 0xd6aa,
        kHieuhYoKiyeoksios                = 0xd6ab,
        kHieuhYoNieun                     = 0xd6ac,
        kHieuhYoNieuncieuc                = 0xd6ad,
        kHieuhYoNieunhieuh                = 0xd6ae,
        kHieuhYoTikeut                    = 0xd6af,
        kHieuhYoRieul                     = 0xd6b0,
        kHieuhYoRieulkiyeok               = 0xd6b1,
        kHieuhYoRieulmieum                = 0xd6b2,
        kHieuhYoRieulpieup                = 0xd6b3,
        kHieuhYoRieulsios                 = 0xd6b4,
        kHieuhYoRieulthieuth              = 0xd6b5,
        kHieuhYoRieulphieuph              = 0xd6b6,
        kHieuhYoRieulhieuh                = 0xd6b7,
        kHieuhYoMieum                     = 0xd6b8,
        kHieuhYoPieup                     = 0xd6b9,
        kHieuhYoPieupsios                 = 0xd6ba,
        kHieuhYoSios                      = 0xd6bb,
        kHieuhYoSsangsios                 = 0xd6bc,
        kHieuhYoIeung                     = 0xd6bd,
        kHieuhYoCieuc                     = 0xd6be,
        kHieuhYoChieuch                   = 0xd6bf,
        kHieuhYoKhieukh                   = 0xd6c0,
        kHieuhYoThieuth                   = 0xd6c1,
        kHieuhYoPhieuph                   = 0xd6c2,
        kHieuhYoHieuh                     = 0xd6c3,
        kHieuhU                           = 0xd6c4,
        kHieuhUKiyeok                     = 0xd6c5,
        kHieuhUSsangkiyeok                = 0xd6c6,
        kHieuhUKiyeoksios                 = 0xd6c7,
        kHieuhUNieun                      = 0xd6c8,
        kHieuhUNieuncieuc                 = 0xd6c9,
        kHieuhUNieunhieuh                 = 0xd6ca,
        kHieuhUTikeut                     = 0xd6cb,
        kHieuhURieul                      = 0xd6cc,
        kHieuhURieulkiyeok                = 0xd6cd,
        kHieuhURieulmieum                 = 0xd6ce,
        kHieuhURieulpieup                 = 0xd6cf,
        kHieuhURieulsios                  = 0xd6d0,
        kHieuhURieulthieuth               = 0xd6d1,
        kHieuhURieulphieuph               = 0xd6d2,
        kHieuhURieulhieuh                 = 0xd6d3,
        kHieuhUMieum                      = 0xd6d4,
        kHieuhUPieup                      = 0xd6d5,
        kHieuhUPieupsios                  = 0xd6d6,
        kHieuhUSios                       = 0xd6d7,
        kHieuhUSsangsios                  = 0xd6d8,
        kHieuhUIeung                      = 0xd6d9,
        kHieuhUCieuc                      = 0xd6da,
        kHieuhUChieuch                    = 0xd6db,
        kHieuhUKhieukh                    = 0xd6dc,
        kHieuhUThieuth                    = 0xd6dd,
        kHieuhUPhieuph                    = 0xd6de,
        kHieuhUHieuh                      = 0xd6df,
        kHieuhWeo                          = 0xd6e0,
        kHieuhWeoKiyeok                    = 0xd6e1,
        kHieuhWeoSsangkiyeok               = 0xd6e2,
        kHieuhWeoKiyeoksios                = 0xd6e3,
        kHieuhWeoNieun                     = 0xd6e4,
        kHieuhWeoNieuncieuc                = 0xd6e5,
        kHieuhWeoNieunhieuh                = 0xd6e6,
        kHieuhWeoTikeut                    = 0xd6e7,
        kHieuhWeoRieul                     = 0xd6e8,
        kHieuhWeoRieulkiyeok               = 0xd6e9,
        kHieuhWeoRieulmieum                = 0xd6ea,
        kHieuhWeoRieulpieup                = 0xd6eb,
        kHieuhWeoRieulsios                 = 0xd6ec,
        kHieuhWeoRieulthieuth              = 0xd6ed,
        kHieuhWeoRieulphieuph              = 0xd6ee,
        kHieuhWeoRieulhieuh                = 0xd6ef,
        kHieuhWeoMieum                     = 0xd6f0,
        kHieuhWeoPieup                     = 0xd6f1,
        kHieuhWeoPieupsios                 = 0xd6f2,
        kHieuhWeoSios                      = 0xd6f3,
        kHieuhWeoSsangsios                 = 0xd6f4,
        kHieuhWeoIeung                     = 0xd6f5,
        kHieuhWeoCieuc                     = 0xd6f6,
        kHieuhWeoChieuch                   = 0xd6f7,
        kHieuhWeoKhieukh                   = 0xd6f8,
        kHieuhWeoThieuth                   = 0xd6f9,
        kHieuhWeoPhieuph                   = 0xd6fa,
        kHieuhWeoHieuh                     = 0xd6fb,
        kHieuhWe                           = 0xd6fc,
        kHieuhWeKiyeok                     = 0xd6fd,
        kHieuhWeSsangkiyeok                = 0xd6fe,
        kHieuhWeKiyeoksios                 = 0xd6ff,
        kHieuhWeNieun                      = 0xd700,
        kHieuhWeNieuncieuc                 = 0xd701,
        kHieuhWeNieunhieuh                 = 0xd702,
        kHieuhWeTikeut                     = 0xd703,
        kHieuhWeRieul                      = 0xd704,
        kHieuhWeRieulkiyeok                = 0xd705,
        kHieuhWeRieulmieum                 = 0xd706,
        kHieuhWeRieulpieup                 = 0xd707,
        kHieuhWeRieulsios                  = 0xd708,
        kHieuhWeRieulthieuth               = 0xd709,
        kHieuhWeRieulphieuph                 = 0xd70a,
        kHieuhWeRieulhieuh                   = 0xd70b,
        kHieuhWeMieum                        = 0xd70c,
        kHieuhWePieup                        = 0xd70d,
        kHieuhWePieupsios                    = 0xd70e,
        kHieuhWeSios                         = 0xd70f,
        kHieuhWeSsangsios                    = 0xd710,
        kHieuhWeIeung                        = 0xd711,
        kHieuhWeCieuc                        = 0xd712,
        kHieuhWeChieuch                      = 0xd713,
        kHieuhWeKhieukh                      = 0xd714,
        kHieuhWeThieuth                      = 0xd715,
        kHieuhWePhieuph                      = 0xd716,
        kHieuhWeHieuh                        = 0xd717,
        kHieuhWi                             = 0xd718,
        kHieuhWiKiyeok                       = 0xd719,
        kHieuhWiSsangkiyeok                  = 0xd71a,
        kHieuhWiKiyeoksios                   = 0xd71b,
        kHieuhWiNieun                        = 0xd71c,
        kHieuhWiNieuncieuc                   = 0xd71d,
        kHieuhWiNieunhieuh                   = 0xd71e,
        kHieuhWiTikeut                       = 0xd71f,
        kHieuhWiRieul                        = 0xd720,
        kHieuhWiRieulkiyeok                  = 0xd721,
        kHieuhWiRieulmieum                   = 0xd722,
        kHieuhWiRieulpieup                   = 0xd723,
        kHieuhWiRieulsios                    = 0xd724,
        kHieuhWiRieulthieuth                 = 0xd725,
        kHieuhWiRieulphieuph                 = 0xd726,
        kHieuhWiRieulhieuh                   = 0xd727,
        kHieuhWiMieum                        = 0xd728,
        kHieuhWiPieup                        = 0xd729,
        kHieuhWiPieupsios                    = 0xd72a,
        kHieuhWiSios                         = 0xd72b,
        kHieuhWiSsangsios                    = 0xd72c,
        kHieuhWiIeung                        = 0xd72d,
        kHieuhWiCieuc                        = 0xd72e,
        kHieuhWiChieuch                      = 0xd72f,
        kHieuhWiKhieukh                      = 0xd730,
        kHieuhWiThieuth                      = 0xd731,
        kHieuhWiPhieuph                      = 0xd732,
        kHieuhWiHieuh                        = 0xd733,
        kHieuhYu                             = 0xd734,
        kHieuhYuKiyeok                        = 0xd735,
        kHieuhYuSsangkiyeok                   = 0xd736,
        kHieuhYuKiyeoksios                    = 0xd737,
        kHieuhYuNieun                         = 0xd738,
        kHieuhYuNieuncieuc                    = 0xd739,
        kHieuhYuNieunhieuh                    = 0xd73a,
        kHieuhYuTikeut                        = 0xd73b,
        kHieuhYuRieul                         = 0xd73c,
        kHieuhYuRieulkiyeok                   = 0xd73d,
        kHieuhYuRieulmieum                    = 0xd73e,
        kHieuhYuRieulpieup                    = 0xd73f,
        kHieuhYuRieulsios                     = 0xd740,
        kHieuhYuRieulthieuth                  = 0xd741,
        kHieuhYuRieulphieuph                  = 0xd742,
        kHieuhYuRieulhieuh                    = 0xd743,
        kHieuhYuMieum                         = 0xd744,
        kHieuhYuPieup                         = 0xd745,
        kHieuhYuPieupsios                     = 0xd746,
        kHieuhYuSios                          = 0xd747,
        kHieuhYuSsangsios                     = 0xd748,
        kHieuhYuIeung                         = 0xd749,
        kHieuhYuCieuc                         = 0xd74a,
        kHieuhYuChieuch                       = 0xd74b,
        kHieuhYuKhieukh                       = 0xd74c,
        kHieuhYuThieuth                       = 0xd74d,
        kHieuhYuPhieuph                        = 0xd74e,
        kHieuhYuHieuh                          = 0xd74f,
        kHieuhEu                               = 0xd750,
        kHieuhEuKiyeok                         = 0xd751,
        kHieuhEuSsangkiyeok                    = 0xd752,
        kHieuhEuKiyeoksios                     = 0xd753,
        kHieuhEuNieun                          = 0xd754,
        kHieuhEuNieuncieuc                     = 0xd755,
        kHieuhEuNieunhieuh                     = 0xd756,
        kHieuhEuTikeut                         = 0xd757,
        kHieuhEuRieul                          = 0xd758,
        kHieuhEuRieulkiyeok                    = 0xd759,
        kHieuhEuRieulmieum                     = 0xd75a,
        kHieuhEuRieulpieup                     = 0xd75b,
        kHieuhEuRieulsios                      = 0xd75c,
        kHieuhEuRieulthieuth                   = 0xd75d,
        kHieuhEuRieulphieuph                   = 0xd75e,
        kHieuhEuRieulhieuh                      = 0xd75f,
        kHieuhEuMieum                           = 0xd760,
        kHieuhEuPieup                           = 0xd761,
        kHieuhEuPieupsios                       = 0xd762,
        kHieuhEuSios                            = 0xd763,
        kHieuhEuSsangsios                       = 0xd764,
        kHieuhEuIeung                           = 0xd765,
        kHieuhEuCieuc                           = 0xd766,
        kHieuhEuChieuch                         = 0xd767,
        kHieuhEuKhieukh                         = 0xd768,
        kHieuhEuThieuth                         = 0xd769,
        kHieuhEuPhieuph                         = 0xd76a,
        kHieuhEuHieuh                           = 0xd76b,
        kHieuhYi                                = 0xd76c,
        kHieuhYiKiyeok                          = 0xd76d,
        kHieuhYiSsangkiyeok                     = 0xd76e,
        kHieuhYiKiyeoksios                      = 0xd76f,
        kHieuhYiNieun                           = 0xd770,
        kHieuhYiNieuncieuc                      = 0xd771,
        kHieuhYiNieunhieuh                      = 0xd772,
        kHieuhYiTikeut                          = 0xd773,
        kHieuhYiRieul                           = 0xd774,
        kHieuhYiRieulkiyeok                     = 0xd775,
        kHieuhYiRieulmieum                      = 0xd776,
        kHieuhYiRieulpieup                      = 0xd777,
        kHieuhYiRieulsios                       = 0xd778,
        kHieuhYiRieulthieuth                    = 0xd779,
        kHieuhYiRieulphieuph                    = 0xd77a,
        kHieuhYiRieulhieuh                      = 0xd77b,
        kHieuhYiMieum                           = 0xd77c,
        kHieuhYiPieup                           = 0xd77d,
        kHieuhYiPieupsios                       = 0xd77e,
        kHieuhYiSios                            = 0xd77f,
        kHieuhYiSsangsios                       = 0xd780,
        kHieuhYiIeung                           = 0xd781,
        kHieuhYiCieuc                           = 0xd782,
        kHieuhYiChieuch                         = 0xd783,
        kHieuhYiKhieukh                         = 0xd784,
        kHieuhYiThieuth                         = 0xd785,
        kHieuhYiPhieuph                         = 0xd786,
        kHieuhYiHieuh                           = 0xd787,
        kHieuhI                                 = 0xd788,
        kHieuhIKiyeok                           = 0xd789,
        kHieuhISsangkiyeok                      = 0xd78a,
        kHieuhIKiyeoksios                       = 0xd78b,
        kHieuhINieun                            = 0xd78c,
        kHieuhINieuncieuc                       = 0xd78d,
        kHieuhINieunhieuh                       = 0xd78e,
        kHieuhITikeut                           = 0xd78f,
        kHieuhIRieul                            = 0xd790,
        kHieuhIRieulkiyeok                      = 0xd791,
        kHieuhIRieulmieum                       = 0xd792,
        kHieuhIRieulpieup                       = 0xd793,
        kHieuhIRieulsios                        = 0xd794,
        kHieuhIRieulthieuth                     = 0xd795,
        kHieuhIRieulphieuph                     = 0xd796,
        kHieuhIRieulhieuh                       = 0xd797,
        kHieuhIMieum                            = 0xd798,
        kHieuhIPieup                            = 0xd799,
        kHieuhIPieupsios                        = 0xd79a,
        kHieuhISios                             = 0xd79b,
        kHieuhISsangsios                        = 0xd79c,
        kHieuhIIeung                            = 0xd79d,
        kHieuhICieuc                            = 0xd79e,
        kHieuhIChieuch                          = 0xd79f,
        kHieuhIKhieukh                          = 0xd7a0,
        kHieuhIThieuth                          = 0xd7a1,
        kHieuhIPhieuph                          = 0xd7a2,
        kHieuhIHieuh                            = 0xd7a3
        };

private:

};





//=================================================================================
// class UHalfwidthHangulLetter
//=================================================================================

class UHalfwidthHangulLetter {

public:

        enum EHalfwidthHangulLetterNames {

                kKiyeok                                                                                          = 0xFFA1,
                kSsangkiyeok                                                                             = 0xFFA2,
                kKiyeokSios                                                                                      = 0xFFA3,
                kNieun                                                                                           = 0xFFA4,
                kNieunCieuc                                                                                      = 0xFFA5,
                kNieunHieuh                                                                                      = 0xFFA6,
                kTikeut                                                                                          = 0xFFA7,
                kSsangtikeut                                                                             = 0xFFA8,
                kRieul                                                                                           = 0xFFA9,
                kRieulKiyeok                                                                             = 0xFFAA,
                kRieulMieum                                                                                      = 0xFFAB,
                kRieulPieup                                                                                      = 0xFFAC,
                kRieulSios                                                                                       = 0xFFAD,
                kRieulThieuth                                                                            = 0xFFAE,
                kRieulPhieuph                                                                            = 0xFFAF,
                kRieulHieuh                                                                                      = 0xFFB0,
                kMieum                                                                                           = 0xFFB1,
                kPieup                                                                                           = 0xFFB2,
                kSsangpieup                                                                                      = 0xFFB3,
                kPieupSios                                                                                       = 0xFFB4,
                kSios                                                                                            = 0xFFB5,
                kSsangsios                                                                                       = 0xFFB6,
                kIeung                                                                                           = 0xFFB7,
                kCieuc                                                                                           = 0xFFB8,
                kSsangcieuc                                                                                      = 0xFFB9,
                kChieuch                                                                                         = 0xFFBA,
                kKhieukh                                                                                         = 0xFFBB,
                kThieuth                                                                                         = 0xFFBC,
                kPhieuph                                                                                         = 0xFFBD,
                kHieuh                                                                                           = 0xFFBE,
                kA                                                                                                       = 0xFFC2,
                kAe                                                                                                      = 0xFFC3,
                kYa                                                                                                      = 0xFFC4,
                kYae                                                                                             = 0xFFC5,
                kEo                                                                                                      = 0xFFC6,
                kE                                                                                                       = 0xFFC7,
                kYeo                                                                                             = 0xFFCA,
                kYe                                                                                                      = 0xFFCB,
                kO                                                                                                       = 0xFFCC,
                kWa                                                                                                      = 0xFFCD,
                kWae                                                                                             = 0xFFCE,
                kOe                                                                                                      = 0xFFCF,
                kYo                                                                                                      = 0xFFD2,
                kU                                                                                                       = 0xFFD3,
                kWeo                                                                                             = 0xFFD4,
                kWe                                                                                                      = 0xFFD5,
                kWi                                                                                                      = 0xFFD6,
                kYu                                                                                                      = 0xFFD7,
                kEu                                                                                                      = 0xFFDA,
                kYi                                                                                                      = 0xFFDB,
                kI                                                                                                       = 0xFFDC
        };

private:

};





//=================================================================================
// class UArabicLigature
//=================================================================================

class UArabicLigature {

public:

        enum EArabicLigatureNames {

                kYehWithHamzaAboveWithAlefIsolatedForm                           = 0xFBEA,
                kYehWithHamzaAboveWithAlefFinalForm                                      = 0xFBEB,
                kYehWithHamzaAboveWithAeIsolatedForm                             = 0xFBEC,
                kYehWithHamzaAboveWithAeFinalForm                                        = 0xFBED,
                kYehWithHamzaAboveWithWawIsolatedForm                            = 0xFBEE,
                kYehWithHamzaAboveWithWawFinalForm                                       = 0xFBEF,
                kYehWithHamzaAboveWithUIsolatedForm                                      = 0xFBF0,
                kYehWithHamzaAboveWithUFinalForm                                         = 0xFBF1,
                kYehWithHamzaAboveWithOeIsolatedForm                             = 0xFBF2,
                kYehWithHamzaAboveWithOeFinalForm                                        = 0xFBF3,
                kYehWithHamzaAboveWithYuIsolatedForm                             = 0xFBF4,
                kYehWithHamzaAboveWithYuFinalForm                                        = 0xFBF5,
                kYehWithHamzaAboveWithEIsolatedForm                                      = 0xFBF6,
                kYehWithHamzaAboveWithEFinalForm                                         = 0xFBF7,
                kYehWithHamzaAboveWithEInitialForm                                       = 0xFBF8,
                kUighurKirghizYehWithHamzaAboveWithAlefMaksuraIsolatedForm                         = 0xFBF9,
                kUighurKirghizYehWithHamzaAboveWithAlefMaksuraFinalForm                         = 0xFBFA,
                kUighurKirghizYehWithHamzaAboveWithAlefMaksuraInitialForm                         = 0xFBFB,
                kYehWithHamzaAboveWithJeemIsolatedForm                           = 0xFC00,
                kYehWithHamzaAboveWithHahIsolatedForm                            = 0xFC01,
                kYehWithHamzaAboveWithMeemIsolatedForm                           = 0xFC02,
                kYehWithHamzaAboveWithAlefMaksuraIsolatedForm                         = 0xFC03,
                kYehWithHamzaAboveWithYehIsolatedForm                            = 0xFC04,
                kBehWithJeemIsolatedForm                                                         = 0xFC05,
                kBehWithHahIsolatedForm                                                          = 0xFC06,
                kBehWithKhahIsolatedForm                                                         = 0xFC07,
                kBehWithMeemIsolatedForm                                                         = 0xFC08,
                kBehWithAlefMaksuraIsolatedForm                                          = 0xFC09,
                kBehWithYehIsolatedForm                                                          = 0xFC0A,
                kTehWithJeemIsolatedForm                                                         = 0xFC0B,
                kTehWithHahIsolatedForm                                                          = 0xFC0C,
                kTehWithKhahIsolatedForm                                                         = 0xFC0D,
                kTehWithMeemIsolatedForm                                                         = 0xFC0E,
                kTehWithAlefMaksuraIsolatedForm                                          = 0xFC0F,
                kTehWithYehIsolatedForm                                                          = 0xFC10,
                kThehWithJeemIsolatedForm                                                        = 0xFC11,
                kThehWithMeemIsolatedForm                                                        = 0xFC12,
                kThehWithAlefMaksuraIsolatedForm                                         = 0xFC13,
                kThehWithYehIsolatedForm                                                         = 0xFC14,
                kJeemWithHahIsolatedForm                                                         = 0xFC15,
                kJeemWithMeemIsolatedForm                                                        = 0xFC16,
                kHahWithJeemIsolatedForm                                                         = 0xFC17,
                kHahWithMeemIsolatedForm                                                         = 0xFC18,
                kKhahWithJeemIsolatedForm                                                        = 0xFC19,
                kKhahWithHahIsolatedForm                                                         = 0xFC1A,
                kKhahWithMeemIsolatedForm                                                        = 0xFC1B,
                kSeenWithJeemIsolatedForm                                                        = 0xFC1C,
                kSeenWithHahIsolatedForm                                                         = 0xFC1D,
                kSeenWithKhahIsolatedForm                                                        = 0xFC1E,
                kSeenWithMeemIsolatedForm                                                        = 0xFC1F,
                kSadWithHahIsolatedForm                                                          = 0xFC20,
                kSadWithMeemIsolatedForm                                                         = 0xFC21,
                kDadWithJeemIsolatedForm                                                         = 0xFC22,
                kDadWithHahIsolatedForm                                                          = 0xFC23,
                kDadWithKhahIsolatedForm                                                         = 0xFC24,
                kDadWithMeemIsolatedForm                                                         = 0xFC25,
                kTahWithHahIsolatedForm                                                          = 0xFC26,
                kTahWithMeemIsolatedForm                                                         = 0xFC27,
                kZahWithMeemIsolatedForm                                                         = 0xFC28,
                kAinWithJeemIsolatedForm                                                         = 0xFC29,
                kAinWithMeemIsolatedForm                                                         = 0xFC2A,
                kGhainWithJeemIsolatedForm                                                       = 0xFC2B,
                kGhainWithMeemIsolatedForm                                                       = 0xFC2C,
                kFehWithJeemIsolatedForm                                                         = 0xFC2D,
                kFehWithHahIsolatedForm                                                          = 0xFC2E,
                kFehWithKhahIsolatedForm                                                         = 0xFC2F,
                kFehWithMeemIsolatedForm                                                         = 0xFC30,
                kFehWithAlefMaksuraIsolatedForm                                          = 0xFC31,
                kFehWithYehIsolatedForm                                                          = 0xFC32,
                kQafWithHahIsolatedForm                                                          = 0xFC33,
                kQafWithMeemIsolatedForm                                                         = 0xFC34,
                kQafWithAlefMaksuraIsolatedForm                                          = 0xFC35,
                kQafWithYehIsolatedForm                                                          = 0xFC36,
                kKafWithAlefIsolatedForm                                                         = 0xFC37,
                kKafWithJeemIsolatedForm                                                         = 0xFC38,
                kKafWithHahIsolatedForm                                                          = 0xFC39,
                kKafWithKhahIsolatedForm                                                         = 0xFC3A,
                kKafWithLamIsolatedForm                                                          = 0xFC3B,
                kKafWithMeemIsolatedForm                                                         = 0xFC3C,
                kKafWithAlefMaksuraIsolatedForm                                          = 0xFC3D,
                kKafWithYehIsolatedForm                                                          = 0xFC3E,
                kLamWithJeemIsolatedForm                                                         = 0xFC3F,
                kLamWithHahIsolatedForm                                                          = 0xFC40,
                kLamWithKhahIsolatedForm                                                         = 0xFC41,
                kLamWithMeemIsolatedForm                                                         = 0xFC42,
                kLamWithAlefMaksuraIsolatedForm                                          = 0xFC43,
                kLamWithYehIsolatedForm                                                          = 0xFC44,
                kMeemWithJeemIsolatedForm                                                        = 0xFC45,
                kMeemWithHahIsolatedForm                                                         = 0xFC46,
                kMeemWithKhahIsolatedForm                                                        = 0xFC47,
                kMeemWithMeemIsolatedForm                                                        = 0xFC48,
                kMeemWithAlefMaksuraIsolatedForm                                         = 0xFC49,
                kMeemWithYehIsolatedForm                                                         = 0xFC4A,
                kNoonWithJeemIsolatedForm                                                        = 0xFC4B,
                kNoonWithHahIsolatedForm                                                         = 0xFC4C,
                kNoonWithKhahIsolatedForm                                                        = 0xFC4D,
                kNoonWithMeemIsolatedForm                                                        = 0xFC4E,
                kNoonWithAlefMaksuraIsolatedForm                                         = 0xFC4F,
                kNoonWithYehIsolatedForm                                                         = 0xFC50,
                kHehWithJeemIsolatedForm                                                         = 0xFC51,
                kHehWithMeemIsolatedForm                                                         = 0xFC52,
                kHehWithAlefMaksuraIsolatedForm                                          = 0xFC53,
                kHehWithYehIsolatedForm                                                          = 0xFC54,
                kYehWithJeemIsolatedForm                                                         = 0xFC55,
                kYehWithHahIsolatedForm                                                          = 0xFC56,
                kYehWithKhahIsolatedForm                                                         = 0xFC57,
                kYehWithMeemIsolatedForm                                                         = 0xFC58,
                kYehWithAlefMaksuraIsolatedForm                                          = 0xFC59,
                kYehWithYehIsolatedForm                                                          = 0xFC5A,
                kThalWithSuperscriptAlefIsolatedForm                             = 0xFC5B,
                kRehWithSuperscriptAlefIsolatedForm                                      = 0xFC5C,
                kAlefMaksuraWithSuperscriptAlefIsolatedForm                         = 0xFC5D,
                kShaddaWithDammatanIsolatedForm                                          = 0xFC5E,
                kShaddaWithKasratanIsolatedForm                                          = 0xFC5F,
                kShaddaWithFathaIsolatedForm                                             = 0xFC60,
                kShaddaWithDammaIsolatedForm                                             = 0xFC61,
                kShaddaWithKasraIsolatedForm                                             = 0xFC62,
                kShaddaWithSuperscriptAlefIsolatedForm                           = 0xFC63,
                kYehWithHamzaAboveWithRehFinalForm                                       = 0xFC64,
                kYehWithHamzaAboveWithZainFinalForm                                      = 0xFC65,
                kYehWithHamzaAboveWithMeemFinalForm                                      = 0xFC66,
                kYehWithHamzaAboveWithNoonFinalForm                                      = 0xFC67,
                kYehWithHamzaAboveWithAlefMaksuraFinalForm                         = 0xFC68,
                kYehWithHamzaAboveWithYehFinalForm                                       = 0xFC69,
                kBehWithRehFinalForm                                                             = 0xFC6A,
                kBehWithZainFinalForm                                                            = 0xFC6B,
                kBehWithMeemFinalForm                                                            = 0xFC6C,
                kBehWithNoonFinalForm                                                            = 0xFC6D,
                kBehWithAlefMaksuraFinalForm                                             = 0xFC6E,
                kBehWithYehFinalForm                                                             = 0xFC6F,
                kTehWithRehFinalForm                                                             = 0xFC70,
                kTehWithZainFinalForm                                                            = 0xFC71,
                kTehWithMeemFinalForm                                                            = 0xFC72,
                kTehWithNoonFinalForm                                                            = 0xFC73,
                kTehWithAlefMaksuraFinalForm                                             = 0xFC74,
                kTehWithYehFinalForm                                                             = 0xFC75,
                kThehWithRehFinalForm                                                            = 0xFC76,
                kThehWithZainFinalForm                                                           = 0xFC77,
                kThehWithMeemFinalForm                                                           = 0xFC78,
                kThehWithNoonFinalForm                                                           = 0xFC79,
                kThehWithAlefMaksuraFinalForm                                            = 0xFC7A,
                kThehWithYehFinalForm                                                            = 0xFC7B,
                kFehWithAlefMaksuraFinalForm                                             = 0xFC7C,
                kFehWithYehFinalForm                                                             = 0xFC7D,
                kQafWithAlefMaksuraFinalForm                                             = 0xFC7E,
                kQafWithYehFinalForm                                                             = 0xFC7F,
                kKafWithAlefFinalForm                                                            = 0xFC80,
                kKafWithLamFinalForm                                                             = 0xFC81,
                kKafWithMeemFinalForm                                                            = 0xFC82,
                kKafWithAlefMaksuraFinalForm                                             = 0xFC83,
                kKafWithYehFinalForm                                                             = 0xFC84,
                kLamWithMeemFinalForm                                                            = 0xFC85,
                kLamWithAlefMaksuraFinalForm                                             = 0xFC86,
                kLamWithYehFinalForm                                                             = 0xFC87,
                kMeemWithAlefFinalForm                                                           = 0xFC88,
                kMeemWithMeemFinalForm                                                           = 0xFC89,
                kNoonWithRehFinalForm                                                            = 0xFC8A,
                kNoonWithZainFinalForm                                                           = 0xFC8B,
                kNoonWithMeemFinalForm                                                           = 0xFC8C,
                kNoonWithNoonFinalForm                                                           = 0xFC8D,
                kNoonWithAlefMaksuraFinalForm                                            = 0xFC8E,
                kNoonWithYehFinalForm                                                            = 0xFC8F,
                kAlefMaksuraWithSuperscriptAlefFinalForm                         = 0xFC90,
                kYehWithRehFinalForm                                                             = 0xFC91,
                kYehWithZainFinalForm                                                            = 0xFC92,
                kYehWithMeemFinalForm                                                            = 0xFC93,
                kYehWithNoonFinalForm                                                            = 0xFC94,
                kYehWithAlefMaksuraFinalForm                                             = 0xFC95,
                kYehWithYehFinalForm                                                             = 0xFC96,
                kYehWithHamzaAboveWithJeemInitialForm                            = 0xFC97,
                kYehWithHamzaAboveWithHahInitialForm                             = 0xFC98,
                kYehWithHamzaAboveWithKhahInitialForm                            = 0xFC99,
                kYehWithHamzaAboveWithMeemInitialForm                            = 0xFC9A,
                kYehWithHamzaAboveWithHehInitialForm                             = 0xFC9B,
                kBehWithJeemInitialForm                                                          = 0xFC9C,
                kBehWithHahInitialForm                                                           = 0xFC9D,
                kBehWithKhahInitialForm                                                          = 0xFC9E,
                kBehWithMeemInitialForm                                                          = 0xFC9F,
                kBehWithHehInitialForm                                                           = 0xFCA0,
                kTehWithJeemInitialForm                                                          = 0xFCA1,
                kTehWithHahInitialForm                                                           = 0xFCA2,
                kTehWithKhahInitialForm                                                          = 0xFCA3,
                kTehWithMeemInitialForm                                                          = 0xFCA4,
                kTehWithHehInitialForm                                                           = 0xFCA5,
                kThehWithMeemInitialForm                                                         = 0xFCA6,
                kJeemWithHahInitialForm                                                          = 0xFCA7,
                kJeemWithMeemInitialForm                                                         = 0xFCA8,
                kHahWithJeemInitialForm                                                          = 0xFCA9,
                kHahWithMeemInitialForm                                                          = 0xFCAA,
                kKhahWithJeemInitialForm                                                         = 0xFCAB,
                kKhahWithMeemInitialForm                                                         = 0xFCAC,
                kSeenWithJeemInitialForm                                                         = 0xFCAD,
                kSeenWithHahInitialForm                                                          = 0xFCAE,
                kSeenWithKhahInitialForm                                                         = 0xFCAF,
                kSeenWithMeemInitialForm                                                         = 0xFCB0,
                kSadWithHahInitialForm                                                           = 0xFCB1,
                kSadWithKhahInitialForm                                                          = 0xFCB2,
                kSadWithMeemInitialForm                                                          = 0xFCB3,
                kDadWithJeemInitialForm                                                          = 0xFCB4,
                kDadWithHahInitialForm                                                           = 0xFCB5,
                kDadWithKhahInitialForm                                                          = 0xFCB6,
                kDadWithMeemInitialForm                                                          = 0xFCB7,
                kTahWithHahInitialForm                                                           = 0xFCB8,
                kZahWithMeemInitialForm                                                          = 0xFCB9,
                kAinWithJeemInitialForm                                                          = 0xFCBA,
                kAinWithMeemInitialForm                                                          = 0xFCBB,
                kGhainWithJeemInitialForm                                                        = 0xFCBC,
                kGhainWithMeemInitialForm                                                        = 0xFCBD,
                kFehWithJeemInitialForm                                                          = 0xFCBE,
                kFehWithHahInitialForm                                                           = 0xFCBF,
                kFehWithKhahInitialForm                                                          = 0xFCC0,
                kFehWithMeemInitialForm                                                          = 0xFCC1,
                kQafWithHahInitialForm                                                           = 0xFCC2,
                kQafWithMeemInitialForm                                                          = 0xFCC3,
                kKafWithJeemInitialForm                                                          = 0xFCC4,
                kKafWithHahInitialForm                                                           = 0xFCC5,
                kKafWithKhahInitialForm                                                          = 0xFCC6,
                kKafWithLamInitialForm                                                           = 0xFCC7,
                kKafWithMeemInitialForm                                                          = 0xFCC8,
                kLamWithJeemInitialForm                                                          = 0xFCC9,
                kLamWithHahInitialForm                                                           = 0xFCCA,
                kLamWithKhahInitialForm                                                          = 0xFCCB,
                kLamWithMeemInitialForm                                                          = 0xFCCC,
                kLamWithHehInitialForm                                                           = 0xFCCD,
                kMeemWithJeemInitialForm                                                         = 0xFCCE,
                kMeemWithHahInitialForm                                                          = 0xFCCF,
                kMeemWithKhahInitialForm                                                         = 0xFCD0,
                kMeemWithMeemInitialForm                                                         = 0xFCD1,
                kNoonWithJeemInitialForm                                                         = 0xFCD2,
                kNoonWithHahInitialForm                                                          = 0xFCD3,
                kNoonWithKhahInitialForm                                                         = 0xFCD4,
                kNoonWithMeemInitialForm                                                         = 0xFCD5,
                kNoonWithHehInitialForm                                                          = 0xFCD6,
                kHehWithJeemInitialForm                                                          = 0xFCD7,
                kHehWithMeemInitialForm                                                          = 0xFCD8,
                kHehWithSuperscriptAlefInitialForm                                       = 0xFCD9,
                kYehWithJeemInitialForm                                                          = 0xFCDA,
                kYehWithHahInitialForm                                                           = 0xFCDB,
                kYehWithKhahInitialForm                                                          = 0xFCDC,
                kYehWithMeemInitialForm                                                          = 0xFCDD,
                kYehWithHehInitialForm                                                           = 0xFCDE,
                kYehWithHamzaAboveWithMeemMedialForm                             = 0xFCDF,
                kYehWithHamzaAboveWithHehMedialForm                                      = 0xFCE0,
                kBehWithMeemMedialForm                                                           = 0xFCE1,
                kBehWithHehMedialForm                                                            = 0xFCE2,
                kTehWithMeemMedialForm                                                           = 0xFCE3,
                kTehWithHehMedialForm                                                            = 0xFCE4,
                kThehWithMeemMedialForm                                                          = 0xFCE5,
                kThehWithHehMedialForm                                                           = 0xFCE6,
                kSeenWithMeemMedialForm                                                          = 0xFCE7,
                kSeenWithHehMedialForm                                                           = 0xFCE8,
                kSheenWithMeemMedialForm                                                         = 0xFCE9,
                kSheenWithHehMedialForm                                                          = 0xFCEA,
                kKafWithLamMedialForm                                                            = 0xFCEB,
                kKafWithMeemMedialForm                                                           = 0xFCEC,
                kLamWithMeemMedialForm                                                           = 0xFCED,
                kNoonWithMeemMedialForm                                                          = 0xFCEE,
                kNoonWithHehMedialForm                                                           = 0xFCEF,
                kYehWithMeemMedialForm                                                           = 0xFCF0,
                kYehWithHehMedialForm                                                            = 0xFCF1,
                kShaddaWithFathaMedialForm                                                       = 0xFCF2,
                kShaddaWithDammaMedialForm                                                       = 0xFCF3,
                kShaddaWithKasraMedialForm                                                       = 0xFCF4,
                kTahWithAlefMaksuraIsolatedForm                                          = 0xFCF5,
                kTahWithYehIsolatedForm                                                          = 0xFCF6,
                kAinWithAlefMaksuraIsolatedForm                                          = 0xFCF7,
                kAinWithYehIsolatedForm                                                          = 0xFCF8,
                kGhainWithAlefMaksuraIsolatedForm                                        = 0xFCF9,
                kGhainWithYehIsolatedForm                                                        = 0xFCFA,
                kSeenWithAlefMaksuraIsolatedForm                                         = 0xFCFB,
                kSeenWithYehIsolatedForm                                                         = 0xFCFC,
                kSheenWithAlefMaksuraIsolatedForm                                        = 0xFCFD,
                kSheenWithYehIsolatedForm                                                        = 0xFCFE,
                kHahWithAlefMaksuraIsolatedForm                                          = 0xFCFF,
                kHahWithYehIsolatedForm                                                          = 0xFD00,
                kJeemWithAlefMaksuraIsolatedForm                                         = 0xFD01,
                kJeemWithYehIsolatedForm                                                         = 0xFD02,
                kKhahWithAlefMaksuraIsolatedForm                                         = 0xFD03,
                kKhahWithYehIsolatedForm                                                         = 0xFD04,
                kSadWithAlefMaksuraIsolatedForm                                          = 0xFD05,
                kSadWithYehIsolatedForm                                                          = 0xFD06,
                kDadWithAlefMaksuraIsolatedForm                                          = 0xFD07,
                kDadWithYehIsolatedForm                                                          = 0xFD08,
                kSheenWithJeemIsolatedForm                                                       = 0xFD09,
                kSheenWithHahIsolatedForm                                                        = 0xFD0A,
                kSheenWithKhahIsolatedForm                                                       = 0xFD0B,
                kSheenWithMeemIsolatedForm                                                       = 0xFD0C,
                kSheenWithRehIsolatedForm                                                        = 0xFD0D,
                kSeenWithRehIsolatedForm                                                         = 0xFD0E,
                kSadWithRehIsolatedForm                                                          = 0xFD0F,
                kDadWithRehIsolatedForm                                                          = 0xFD10,
                kTahWithAlefMaksuraFinalForm                                             = 0xFD11,
                kTahWithYehFinalForm                                                             = 0xFD12,
                kAinWithAlefMaksuraFinalForm                                             = 0xFD13,
                kAinWithYehFinalForm                                                             = 0xFD14,
                kGhainWithAlefMaksuraFinalForm                                           = 0xFD15,
                kGhainWithYehFinalForm                                                           = 0xFD16,
                kSeenWithAlefMaksuraFinalForm                                            = 0xFD17,
                kSeenWithYehFinalForm                                                            = 0xFD18,
                kSheenWithAlefMaksuraFinalForm                                           = 0xFD19,
                kSheenWithYehFinalForm                                                           = 0xFD1A,
                kHahWithAlefMaksuraFinalForm                                             = 0xFD1B,
                kHahWithYehFinalForm                                                             = 0xFD1C,
                kJeemWithAlefMaksuraFinalForm                                            = 0xFD1D,
                kJeemWithYehFinalForm                                                            = 0xFD1E,
                kKhahWithAlefMaksuraFinalForm                                            = 0xFD1F,
                kKhahWithYehFinalForm                                                            = 0xFD20,
                kSadWithAlefMaksuraFinalForm                                             = 0xFD21,
                kSadWithYehFinalForm                                                             = 0xFD22,
                kDadWithAlefMaksuraFinalForm                                             = 0xFD23,
                kDadWithYehFinalForm                                                             = 0xFD24,
                kSheenWithJeemFinalForm                                                          = 0xFD25,
                kSheenWithHahFinalForm                                                           = 0xFD26,
                kSheenWithKhahFinalForm                                                          = 0xFD27,
                kSheenWithMeemFinalForm                                                          = 0xFD28,
                kSheenWithRehFinalForm                                                           = 0xFD29,
                kSeenWithRehFinalForm                                                            = 0xFD2A,
                kSadWithRehFinalForm                                                             = 0xFD2B,
                kDadWithRehFinalForm                                                             = 0xFD2C,
                kSheenWithJeemInitialForm                                                        = 0xFD2D,
                kSheenWithHahInitialForm                                                         = 0xFD2E,
                kSheenWithKhahInitialForm                                                        = 0xFD2F,
                kSheenWithMeemInitialForm                                                        = 0xFD30,
                kSeenWithHehInitialForm                                                          = 0xFD31,
                kSheenWithHehInitialForm                                                         = 0xFD32,
                kTahWithMeemInitialForm                                                          = 0xFD33,
                kSeenWithJeemMedialForm                                                          = 0xFD34,
                kSeenWithHahMedialForm                                                           = 0xFD35,
                kSeenWithKhahMedialForm                                                          = 0xFD36,
                kSheenWithJeemMedialForm                                                         = 0xFD37,
                kSheenWithHahMedialForm                                                          = 0xFD38,
                kSheenWithKhahMedialForm                                                         = 0xFD39,
                kTahWithMeemMedialForm                                                           = 0xFD3A,
                kZahWithMeemMedialForm                                                           = 0xFD3B,
                kAlefWithFathatanFinalForm                                                       = 0xFD3C,
                kAlefWithFathatanIsolatedForm                                            = 0xFD3D,
                kOrnateLeftParenthesis                                                           = 0xFD3E,
                kOrnateRightParenthesis                                                          = 0xFD3F,
                kTehWithJeemWithMeemInitialForm                                          = 0xFD50,
                kTehWithHahWithJeemFinalForm                                             = 0xFD51,
                kTehWithHahWithJeemInitialForm                                           = 0xFD52,
                kTehWithHahWithMeemInitialForm                                           = 0xFD53,
                kTehWithKhahWithMeemInitialForm                                          = 0xFD54,
                kTehWithMeemWithJeemInitialForm                                          = 0xFD55,
                kTehWithMeemWithHahInitialForm                                           = 0xFD56,
                kTehWithMeemWithKhahInitialForm                                          = 0xFD57,
                kJeemWithMeemWithHahFinalForm                                            = 0xFD58,
                kJeemWithMeemWithHahInitialForm                                          = 0xFD59,
                kHahWithMeemWithYehFinalForm                                             = 0xFD5A,
                kHahWithMeemWithAlefMaksuraFinalForm                             = 0xFD5B,
                kSeenWithHahWithJeemInitialForm                                          = 0xFD5C,
                kSeenWithJeemWithHahInitialForm                                          = 0xFD5D,
                kSeenWithJeemWithAlefMaksuraFinalForm                            = 0xFD5E,
                kSeenWithMeemWithHahFinalForm                                            = 0xFD5F,
                kSeenWithMeemWithHahInitialForm                                          = 0xFD60,
                kSeenWithMeemWithJeemInitialForm                                         = 0xFD61,
                kSeenWithMeemWithMeemFinalForm                                           = 0xFD62,
                kSeenWithMeemWithMeemInitialForm                                         = 0xFD63,
                kSadWithHahWithHahFinalForm                                                      = 0xFD64,
                kSadWithHahWithHahInitialForm                                            = 0xFD65,
                kSadWithMeemWithMeemFinalForm                                            = 0xFD66,
                kSheenWithHahWithMeemFinalForm                                           = 0xFD67,
                kSheenWithHahWithMeemInitialForm                                         = 0xFD68,
                kSheenWithJeemWithYehFinalForm                                           = 0xFD69,
                kSheenWithMeemWithKhahFinalForm                                          = 0xFD6A,
                kSheenWithMeemWithKhahInitialForm                                        = 0xFD6B,
                kSheenWithMeemWithMeemFinalForm                                          = 0xFD6C,
                kSheenWithMeemWithMeemInitialForm                                        = 0xFD6D,
                kDadWithHahWithAlefMaksuraFinalForm                                      = 0xFD6E,
                kDadWithKhahWithMeemFinalForm                                            = 0xFD6F,
                kDadWithKhahWithMeemInitialForm                                          = 0xFD70,
                kTahWithMeemWithHahFinalForm                                             = 0xFD71,
                kTahWithMeemWithHahInitialForm                                           = 0xFD72,
                kTahWithMeemWithMeemInitialForm                                          = 0xFD73,
                kTahWithMeemWithYehFinalForm                                             = 0xFD74,
                kAinWithJeemWithMeemFinalForm                                            = 0xFD75,
                kAinWithMeemWithMeemFinalForm                                            = 0xFD76,
                kAinWithMeemWithMeemInitialForm                                          = 0xFD77,
                kAinWithMeemWithAlefMaksuraFinalForm                             = 0xFD78,
                kGhainWithMeemWithMeemFinalForm                                          = 0xFD79,
                kGhainWithMeemWithYehFinalForm                                           = 0xFD7A,
                kGhainWithMeemWithAlefMaksuraFinalForm                           = 0xFD7B,
                kFehWithKhahWithMeemFinalForm                                            = 0xFD7C,
                kFehWithKhahWithMeemInitialForm                                          = 0xFD7D,
                kQafWithMeemWithHahFinalForm                                             = 0xFD7E,
                kQafWithMeemWithMeemFinalForm                                            = 0xFD7F,
                kLamWithHahWithMeemFinalForm                                             = 0xFD80,
                kLamWithHahWithYehFinalForm                                                      = 0xFD81,
                kLamWithHahWithAlefMaksuraFinalForm                                      = 0xFD82,
                kLamWithJeemWithJeemInitialForm                                          = 0xFD83,
                kLamWithJeemWithJeemFinalForm                                            = 0xFD84,
                kLamWithKhahWithMeemFinalForm                                            = 0xFD85,
                kLamWithKhahWithMeemInitialForm                                          = 0xFD86,
                kLamWithMeemWithHahFinalForm                                             = 0xFD87,
                kLamWithMeemWithHahInitialForm                                           = 0xFD88,
                kMeemWithHahWithJeemInitialForm                                          = 0xFD89,
                kMeemWithHahWithMeemInitialForm                                          = 0xFD8A,
                kMeemWithHahWithYehFinalForm                                             = 0xFD8B,
                kMeemWithJeemWithHahInitialForm                                          = 0xFD8C,
                kMeemWithJeemWithMeemInitialForm                                         = 0xFD8D,
                kMeemWithKhahWithJeemInitialForm                                         = 0xFD8E,
                kMeemWithKhahWithMeemInitialForm                                         = 0xFD8F,
                kMeemWithJeemWithKhahInitialForm                                         = 0xFD92,
                kHehWithMeemWithJeemInitialForm                                          = 0xFD93,
                kHehWithMeemWithMeemInitialForm                                          = 0xFD94,
                kNoonWithHahWithMeemInitialForm                                          = 0xFD95,
                kNoonWithHahWithAlefMaksuraFinalForm                             = 0xFD96,
                kNoonWithJeemWithMeemFinalForm                                           = 0xFD97,
                kNoonWithJeemWithMeemInitialForm                                         = 0xFD98,
                kNoonWithJeemWithAlefMaksuraFinalForm                            = 0xFD99,
                kNoonWithMeemWithYehFinalForm                                            = 0xFD9A,
                kNoonWithMeemWithAlefMaksuraFinalForm                            = 0xFD9B,
                kYehWithMeemWithMeemFinalForm                                            = 0xFD9C,
                kYehWithMeemWithMeemInitialForm                                          = 0xFD9D,
                kBehWithKhahWithYehFinalForm                                             = 0xFD9E,
                kTehWithJeemWithYehFinalForm                                             = 0xFD9F,
                kTehWithJeemWithAlefMaksuraFinalForm                             = 0xFDA0,
                kTehWithKhahWithYehFinalForm                                             = 0xFDA1,
                kTehWithKhahWithAlefMaksuraFinalForm                             = 0xFDA2,
                kTehWithMeemWithYehFinalForm                                             = 0xFDA3,
                kTehWithMeemWithAlefMaksuraFinalForm                             = 0xFDA4,
                kJeemWithMeemWithYehFinalForm                                            = 0xFDA5,
                kJeemWithHahWithAlefMaksuraFinalForm                             = 0xFDA6,
                kJeemWithMeemWithAlefMaksuraFinalForm                            = 0xFDA7,
                kSeenWithKhahWithAlefMaksuraFinalForm                            = 0xFDA8,
                kSadWithHahWithYehFinalForm                                                      = 0xFDA9,
                kSheenWithHahWithYehFinalForm                                            = 0xFDAA,
                kDadWithHahWithYehFinalForm                                                      = 0xFDAB,
                kLamWithJeemWithYehFinalForm                                             = 0xFDAC,
                kLamWithMeemWithYehFinalForm                                             = 0xFDAD,
                kYehWithHahWithYehFinalForm                                                      = 0xFDAE,
                kYehWithJeemWithYehFinalForm                                             = 0xFDAF,
                kYehWithMeemWithYehFinalForm                                             = 0xFDB0,
                kMeemWithMeemWithYehFinalForm                                            = 0xFDB1,
                kQafWithMeemWithYehFinalForm                                             = 0xFDB2,
                kNoonWithHahWithYehFinalForm                                             = 0xFDB3,
                kQafWithMeemWithHahInitialForm                                           = 0xFDB4,
                kLamWithHahWithMeemInitialForm                                           = 0xFDB5,
                kAinWithMeemWithYehFinalForm                                             = 0xFDB6,
                kKafWithMeemWithYehFinalForm                                             = 0xFDB7,
                kNoonWithJeemWithHahInitialForm                                          = 0xFDB8,
                kMeemWithKhahWithYehFinalForm                                            = 0xFDB9,
                kLamWithJeemWithMeemInitialForm                                          = 0xFDBA,
                kKafWithMeemWithMeemFinalForm                                            = 0xFDBB,
                kLamWithJeemWithMeemFinalForm                                            = 0xFDBC,
                kNoonWithJeemWithHahFinalForm                                            = 0xFDBD,
                kJeemWithHahWithYehFinalForm                                             = 0xFDBE,
                kHahWithJeemWithYehFinalForm                                             = 0xFDBF,
                kMeemWithJeemWithYehFinalForm                                            = 0xFDC0,
                kFehWithMeemWithYehFinalForm                                             = 0xFDC1,
                kBehWithHahWithYehFinalForm                                                      = 0xFDC2,
                kKafWithMeemWithMeemInitialForm                                          = 0xFDC3,
                kAinWithJeemWithMeemInitialForm                                          = 0xFDC4,
                kSadWithMeemWithMeemInitialForm                                          = 0xFDC5,
                kSeenWithKhahWithYehFinalForm                                            = 0xFDC6,
                kNoonWithJeemWithYehFinalForm                                            = 0xFDC7,
                kSallaUsedAsKoranicStopSignIsolatedForm                          = 0xFDF0,
                kQalaUsedAsKoranicStopSignIsolatedForm                           = 0xFDF1,
                kAllahIsolatedForm                                                                       = 0xFDF2,
                kAkbarIsolatedForm                                                                       = 0xFDF3,
                kMohammadIsolatedForm                                                            = 0xFDF4,
                kSalamIsolatedForm                                                                       = 0xFDF5,
                kRasoulIsolatedForm                                                                      = 0xFDF6,
                kAlayheIsolatedForm                                                                      = 0xFDF7,
                kWasallamIsolatedForm                                                            = 0xFDF8,
                kSallaIsolatedForm                                                                       = 0xFDF9,
                kSallallahouAlayheWasallam                                                       = 0xFDFA,
                kJallajalalouhou                                                                         = 0xFDFB,
                kLamWithAlefWithMaddaAboveIsolatedForm                           = 0xFEF5,
                kLamWithAlefWithMaddaAboveFinalForm                                      = 0xFEF6,
                kLamWithAlefWithHamzaAboveIsolatedForm                           = 0xFEF7,
                kLamWithAlefWithHamzaAboveFinalForm                                      = 0xFEF8,
                kLamWithAlefWithHamzaBelowIsolatedForm                           = 0xFEF9,
                kLamWithAlefWithHamzaBelowFinalForm                                      = 0xFEFA,
                kLamWithAlefIsolatedForm                                                         = 0xFEFB,
                kLamWithAlefFinalForm                                                            = 0xFEFC
        };

private:

};





//=================================================================================
// class USuperscript
//=================================================================================

class USuperscript {

public:

        enum ESuperscriptNames {

                kTwo                                                                                             = 0x00B2,
                kThree                                                                                           = 0x00B3,
                kOne                                                                                             = 0x00B9,
                kArabicLetterAlef                                                                        = 0x0670,
                kZero                                                                                            = 0x2070,
                kFour                                                                                            = 0x2074,
                kFive                                                                                            = 0x2075,
                kSix                                                                                             = 0x2076,
                kSeven                                                                                           = 0x2077,
                kEight                                                                                           = 0x2078,
                kNine                                                                                            = 0x2079,
                kPlusSign                                                                                        = 0x207A,
                kMinus                                                                                           = 0x207B,
                kEqualsSign                                                                                      = 0x207C,
                kLeftParenthesis                                                                         = 0x207D,
                kRightParenthesis                                                                        = 0x207E,
                kLatinSmallLetterN                                                                       = 0x207F,
                kArabicLigatureThalWithAlefIsolatedForm                          = 0xFC5B,
                kArabicLigatureRehWithAlefIsolatedForm                           = 0xFC5C,
                kArabicLigatureAlefMaksuraWithAlefIsolatedForm                         = 0xFC5D,
                kArabicLigatureShaddaWithAlefIsolatedForm                         = 0xFC63,
                kArabicLigatureAlefMaksuraWithAlefFinalForm                         = 0xFC90,
                kArabicLigatureHehWithAlefInitialForm                            = 0xFCD9
        };

private:

};





//=================================================================================
// class USubscript
//=================================================================================

class USubscript {

public:

        enum ESubscriptNames {

                kZero                                                                                            = 0x2080,
                kOne                                                                                             = 0x2081,
                kTwo                                                                                             = 0x2082,
                kThree                                                                                           = 0x2083,
                kFour                                                                                            = 0x2084,
                kFive                                                                                            = 0x2085,
                kSix                                                                                             = 0x2086,
                kSeven                                                                                           = 0x2087,
                kEight                                                                                           = 0x2088,
                kNine                                                                                            = 0x2089,
                kPlusSign                                                                                        = 0x208A,
                kMinus                                                                                           = 0x208B,
                kEqualsSign                                                                                      = 0x208C,
                kLeftParenthesis                                                                         = 0x208D,
                kRightParenthesis                                                                        = 0x208E
        };

private:

};





//=================================================================================
// class UVulgarFraction
//=================================================================================
class UVulgarFraction {

public:

        enum EVulgarFractionNames {

                kOneQuarter                                                                                      = 0x00BC,
                kOneHalf                                                                                         = 0x00BD,
                kThreeQuarters                                                                           = 0x00BE,
                kOneThird                                                                                        = 0x2153,
                kTwoThirds                                                                                       = 0x2154,
                kOneFifth                                                                                        = 0x2155,
                kTwoFifths                                                                                       = 0x2156,
                kThreeFifths                                                                             = 0x2157,
                kFourFifths                                                                                      = 0x2158,
                kOneSixth                                                                                        = 0x2159,
                kFiveSixths                                                                                      = 0x215A,
                kOneEighth                                                                                       = 0x215B,
                kThreeEighths                                                                            = 0x215C,
                kFiveEighths                                                                             = 0x215D,
                kSevenEighths                                                                            = 0x215E,
                kNumeratorOne                                                                            = 0x215F
        };

private:

};





//=================================================================================
// class URomanNumeral
//=================================================================================

class URomanNumeral {

public:

        enum ERomanNumeralNames {

                kOne                                                                                             = 0x2160,
                kTwo                                                                                             = 0x2161,
                kThree                                                                                           = 0x2162,
                kFour                                                                                            = 0x2163,
                kFive                                                                                            = 0x2164,
                kSix                                                                                             = 0x2165,
                kSeven                                                                                           = 0x2166,
                kEight                                                                                           = 0x2167,
                kNine                                                                                            = 0x2168,
                kTen                                                                                             = 0x2169,
                kEleven                                                                                          = 0x216A,
                kTwelve                                                                                          = 0x216B,
                kFifty                                                                                           = 0x216C,
                kOneHundred                                                                                      = 0x216D,
                kFiveHundred                                                                             = 0x216E,
                kOneThousand                                                                             = 0x216F,
                kSmallOne                                                                                        = 0x2170,
                kSmallTwo                                                                                        = 0x2171,
                kSmallThree                                                                                      = 0x2172,
                kSmallFour                                                                                       = 0x2173,
                kSmallFive                                                                                       = 0x2174,
                kSmallSix                                                                                        = 0x2175,
                kSmallSeven                                                                                      = 0x2176,
                kSmallEight                                                                                      = 0x2177,
                kSmallNine                                                                                       = 0x2178,
                kSmallTen                                                                                        = 0x2179,
                kSmallEleven                                                                             = 0x217A,
                kSmallTwelve                                                                             = 0x217B,
                kSmallFifty                                                                                      = 0x217C,
                kSmallOneHundred                                                                         = 0x217D,
                kSmallFiveHundred                                                                        = 0x217E,
                kSmallOneThousand                                                                        = 0x217F,
                kOneThousandCD                                                                           = 0x2180,
                kFiveThousand                                                                            = 0x2181,
                kTenThousand                                                                             = 0x2182
        };

private:

};





//=================================================================================
// class UIdeographicTelegraph
//=================================================================================

class UIdeographicTelegraph {

public:

        enum EIdeographicTelegraphNames {

                kLineFeedSeparatorSymbol                                                         = 0x3037,
                kSymbolForJanuary                                                                        = 0x32C0,
                kSymbolForFebruary                                                                       = 0x32C1,
                kSymbolForMarch                                                                          = 0x32C2,
                kSymbolForApril                                                                          = 0x32C3,
                kSymbolForMay                                                                            = 0x32C4,
                kSymbolForJune                                                                           = 0x32C5,
                kSymbolForJuly                                                                           = 0x32C6,
                kSymbolForAugust                                                                         = 0x32C7,
                kSymbolForSeptember                                                                      = 0x32C8,
                kSymbolForOctober                                                                        = 0x32C9,
                kSymbolForNovember                                                                       = 0x32CA,
                kSymbolForDecember                                                                       = 0x32CB,
                kSymbolForHourZero                                                                       = 0x3358,
                kSymbolForHourOne                                                                        = 0x3359,
                kSymbolForHourTwo                                                                        = 0x335A,
                kSymbolForHourThree                                                                      = 0x335B,
                kSymbolForHourFour                                                                       = 0x335C,
                kSymbolForHourFive                                                                       = 0x335D,
                kSymbolForHourSix                                                                        = 0x335E,
                kSymbolForHourSeven                                                                      = 0x335F,
                kSymbolForHourEight                                                                      = 0x3360,
                kSymbolForHourNine                                                                       = 0x3361,
                kSymbolForHourTen                                                                        = 0x3362,
                kSymbolForHourEleven                                                             = 0x3363,
                kSymbolForHourTwelve                                                             = 0x3364,
                kSymbolForHourThirteen                                                           = 0x3365,
                kSymbolForHourFourteen                                                           = 0x3366,
                kSymbolForHourFifteen                                                            = 0x3367,
                kSymbolForHourSixteen                                                            = 0x3368,
                kSymbolForHourSeventeen                                                          = 0x3369,
                kSymbolForHourEighteen                                                           = 0x336A,
                kSymbolForHourNineteen                                                           = 0x336B,
                kSymbolForHourTwenty                                                             = 0x336C,
                kSymbolForHourTwentyOne                                                          = 0x336D,
                kSymbolForHourTwentyTwo                                                          = 0x336E,
                kSymbolForHourTwentyThree                                                        = 0x336F,
                kSymbolForHourTwentyFour                                                         = 0x3370,
                kSymbolForDayOne                                                                         = 0x33E0,
                kSymbolForDayTwo                                                                         = 0x33E1,
                kSymbolForDayThree                                                                       = 0x33E2,
                kSymbolForDayFour                                                                        = 0x33E3,
                kSymbolForDayFive                                                                        = 0x33E4,
                kSymbolForDaySix                                                                         = 0x33E5,
                kSymbolForDaySeven                                                                       = 0x33E6,
                kSymbolForDayEight                                                                       = 0x33E7,
                kSymbolForDayNine                                                                        = 0x33E8,
                kSymbolForDayTen                                                                         = 0x33E9,
                kSymbolForDayEleven                                                                      = 0x33EA,
                kSymbolForDayTwelve                                                                      = 0x33EB,
                kSymbolForDayThirteen                                                            = 0x33EC,
                kSymbolForDayFourteen                                                            = 0x33ED,
                kSymbolForDayFifteen                                                             = 0x33EE,
                kSymbolForDaySixteen                                                             = 0x33EF,
                kSymbolForDaySeventeen                                                           = 0x33F0,
                kSymbolForDayEighteen                                                            = 0x33F1,
                kSymbolForDayNineteen                                                            = 0x33F2,
                kSymbolForDayTwenty                                                                      = 0x33F3,
                kSymbolForDayTwentyOne                                                           = 0x33F4,
                kSymbolForDayTwentyTwo                                                           = 0x33F5,
                kSymbolForDayTwentyThree                                                         = 0x33F6,
                kSymbolForDayTwentyFour                                                          = 0x33F7,
                kSymbolForDayTwentyFive                                                          = 0x33F8,
                kSymbolForDayTwentySix                                                           = 0x33F9,
                kSymbolForDayTwentySeven                                                         = 0x33FA,
                kSymbolForDayTwentyEight                                                         = 0x33FB,
                kSymbolForDayTwentyNine                                                          = 0x33FC,
                kSymbolForDayThirty                                                                      = 0x33FD,
                kSymbolForDayThirtyOne                                                           = 0x33FE
        };

private:

};





//=================================================================================
// class UCircledDigit
//=================================================================================

class UCircledDigit {

public:

        enum ECircledDigitNames {

                kOne                                                                                             = 0x2460,
                kTwo                                                                                             = 0x2461,
                kThree                                                                                           = 0x2462,
                kFour                                                                                            = 0x2463,
                kFive                                                                                            = 0x2464,
                kSix                                                                                             = 0x2465,
                kSeven                                                                                           = 0x2466,
                kEight                                                                                           = 0x2467,
                kNine                                                                                            = 0x2468,
                kZero                                                                                            = 0x24EA,
                kDingbatNegativeOne                                                                      = 0x2776,
                kDingbatNegativeTwo                                                                      = 0x2777,
                kDingbatNegativeThree                                                            = 0x2778,
                kDingbatNegativeFour                                                             = 0x2779,
                kDingbatNegativeFive                                                             = 0x277A,
                kDingbatNegativeSix                                                                      = 0x277B,
                kDingbatNegativeSeven                                                            = 0x277C,
                kDingbatNegativeEight                                                            = 0x277D,
                kDingbatNegativeNine                                                             = 0x277E
        };

private:

};




//=================================================================================
// class UCircledNumber
//=================================================================================
class UCircledNumber {

public:

        enum ECircledNumberNames {

                kOne                                                                                             = 0x2460,
                kTwo                                                                                             = 0x2461,
                kThree                                                                                           = 0x2462,
                kFour                                                                                            = 0x2463,
                kFive                                                                                            = 0x2464,
                kSix                                                                                             = 0x2465,
                kSeven                                                                                           = 0x2466,
                kEight                                                                                           = 0x2467,
                kNine                                                                                            = 0x2468,
                kZero                                                                                            = 0x24EA,
                kTen                                                                                             = 0x2469,
                kEleven                                                                                          = 0x246A,
                kTwelve                                                                                          = 0x246B,
                kThirteen                                                                                        = 0x246C,
                kFourteen                                                                                        = 0x246D,
                kFifteen                                                                                         = 0x246E,
                kSixteen                                                                                         = 0x246F,
                kSeventeen                                                                                       = 0x2470,
                kEighteen                                                                                        = 0x2471,
                kNineteen                                                                                        = 0x2472,
                kTwenty                                                                                          = 0x2473,
                kDingbatNegativeOne                                                                      = 0x2776,
                kDingbatNegativeTwo                                                                      = 0x2777,
                kDingbatNegativeThree                                                            = 0x2778,
                kDingbatNegativeFour                                                             = 0x2779,
                kDingbatNegativeFive                                                             = 0x277A,
                kDingbatNegativeSix                                                                      = 0x277B,
                kDingbatNegativeSeven                                                            = 0x277C,
                kDingbatNegativeEight                                                            = 0x277D,
                kDingbatNegativeNine                                                             = 0x277E,
                kDingbatNegativeTen                                                                      = 0x277F
        };

private:

};





//=================================================================================
// class UParenthesizedDigit
//=================================================================================
class UParenthesizedDigit {

public:

        enum EParenthesizedDigitNames {

                kOne                                                                                             = 0x2474,
                kTwo                                                                                             = 0x2475,
                kThree                                                                                           = 0x2476,
                kFour                                                                                            = 0x2477,
                kFive                                                                                            = 0x2478,
                kSix                                                                                             = 0x2479,
                kSeven                                                                                           = 0x247A,
                kEight                                                                                           = 0x247B,
                kNine                                                                                            = 0x247C
        };

private:

};





//=================================================================================
// class UParenthesizedNumber
//=================================================================================

class UParenthesizedNumber {

public:

        enum EParenthesizedNumberNames {

                kOne                                                                                             = 0x2474,
                kTwo                                                                                             = 0x2475,
                kThree                                                                                           = 0x2476,
                kFour                                                                                            = 0x2477,
                kFive                                                                                            = 0x2478,
                kSix                                                                                             = 0x2479,
                kSeven                                                                                           = 0x247A,
                kEight                                                                                           = 0x247B,
                kNine                                                                                            = 0x247C,
                kTen                                                                                             = 0x247D,
                kEleven                                                                                          = 0x247E,
                kTwelve                                                                                          = 0x247F,
                kThirteen                                                                                        = 0x2480,
                kFourteen                                                                                        = 0x2481,
                kFifteen                                                                                         = 0x2482,
                kSixteen                                                                                         = 0x2483,
                kSeventeen                                                                                       = 0x2484,
                kEighteen                                                                                        = 0x2485,
                kNineteen                                                                                        = 0x2486,
                kTwenty                                                                                          = 0x2487
        };

private:

};





//=================================================================================
// class UFullStopDigit
//=================================================================================

class UFullStopDigit {

public:

        enum EFullStopDigitNames {

                kOne                                                                                     = 0x2488,
                kTwo                                                                                     = 0x2489,
                kThree                                                                                   = 0x248A,
                kFour                                                                                    = 0x248B,
                kFive                                                                                    = 0x248C,
                kSix                                                                                     = 0x248D,
                kSeven                                                                                   = 0x248E,
                kEight                                                                                   = 0x248F,
                kNine                                                                                    = 0x2490
        };

private:

};





//=================================================================================
// class UFullStopNumber
//=================================================================================

class UFullStopNumber {

public:

        enum EFullStopNumberNames {

                kOne                                                                                     = 0x2488,
                kTwo                                                                                     = 0x2489,
                kThree                                                                                   = 0x248A,
                kFour                                                                                    = 0x248B,
                kFive                                                                                    = 0x248C,
                kSix                                                                                     = 0x248D,
                kSeven                                                                                   = 0x248E,
                kEight                                                                                   = 0x248F,
                kNine                                                                                    = 0x2490,
                kTen                                                                                     = 0x2491,
                kEleven                                                                                  = 0x2492,
                kTwelve                                                                                  = 0x2493,
                kThirteen                                                                                = 0x2494,
                kFourteen                                                                                = 0x2495,
                kFifteen                                                                                 = 0x2496,
                kSixteen                                                                                 = 0x2497,
                kSeventeen                                                                               = 0x2498,
                kEighteen                                                                                = 0x2499,
                kNineteen                                                                                = 0x249A,
                kTwenty                                                                                  = 0x249B
        };

private:

};





//=================================================================================
// class UParenthesizedLatin
//=================================================================================
class UParenthesizedLatin {

public:

        enum EParenthesizedLatinNames {

                kSmallLetterA                                                                            = 0x249C,
                kSmallLetterB                                                                            = 0x249D,
                kSmallLetterC                                                                            = 0x249E,
                kSmallLetterD                                                                            = 0x249F,
                kSmallLetterE                                                                            = 0x24A0,
                kSmallLetterF                                                                            = 0x24A1,
                kSmallLetterG                                                                            = 0x24A2,
                kSmallLetterH                                                                            = 0x24A3,
                kSmallLetterI                                                                            = 0x24A4,
                kSmallLetterJ                                                                            = 0x24A5,
                kSmallLetterK                                                                            = 0x24A6,
                kSmallLetterL                                                                            = 0x24A7,
                kSmallLetterM                                                                            = 0x24A8,
                kSmallLetterN                                                                            = 0x24A9,
                kSmallLetterO                                                                            = 0x24AA,
                kSmallLetterP                                                                            = 0x24AB,
                kSmallLetterQ                                                                            = 0x24AC,
                kSmallLetterR                                                                            = 0x24AD,
                kSmallLetterS                                                                            = 0x24AE,
                kSmallLetterT                                                                            = 0x24AF,
                kSmallLetterU                                                                            = 0x24B0,
                kSmallLetterV                                                                            = 0x24B1,
                kSmallLetterW                                                                            = 0x24B2,
                kSmallLetterX                                                                            = 0x24B3,
                kSmallLetterY                                                                            = 0x24B4,
                kSmallLetterZ                                                                            = 0x24B5
        };

private:

};





//=================================================================================
// class UCircledLatin
//=================================================================================

class UCircledLatin {

public:

        enum ECircledLatinNames {

                kCapitalLetterA                                                                          = 0x24B6,
                kCapitalLetterB                                                                          = 0x24B7,
                kCapitalLetterC                                                                          = 0x24B8,
                kCapitalLetterD                                                                          = 0x24B9,
                kCapitalLetterE                                                                          = 0x24BA,
                kCapitalLetterF                                                                          = 0x24BB,
                kCapitalLetterG                                                                          = 0x24BC,
                kCapitalLetterH                                                                          = 0x24BD,
                kCapitalLetterI                                                                          = 0x24BE,
                kCapitalLetterJ                                                                          = 0x24BF,
                kCapitalLetterK                                                                          = 0x24C0,
                kCapitalLetterL                                                                          = 0x24C1,
                kCapitalLetterM                                                                          = 0x24C2,
                kCapitalLetterN                                                                          = 0x24C3,
                kCapitalLetterO                                                                          = 0x24C4,
                kCapitalLetterP                                                                          = 0x24C5,
                kCapitalLetterQ                                                                          = 0x24C6,
                kCapitalLetterR                                                                          = 0x24C7,
                kCapitalLetterS                                                                          = 0x24C8,
                kCapitalLetterT                                                                          = 0x24C9,
                kCapitalLetterU                                                                          = 0x24CA,
                kCapitalLetterV                                                                          = 0x24CB,
                kCapitalLetterW                                                                          = 0x24CC,
                kCapitalLetterX                                                                          = 0x24CD,
                kCapitalLetterY                                                                          = 0x24CE,
                kCapitalLetterZ                                                                          = 0x24CF,
                kSmallLetterA                                                                            = 0x24D0,
                kSmallLetterB                                                                            = 0x24D1,
                kSmallLetterC                                                                            = 0x24D2,
                kSmallLetterD                                                                            = 0x24D3,
                kSmallLetterE                                                                            = 0x24D4,
                kSmallLetterF                                                                            = 0x24D5,
                kSmallLetterG                                                                            = 0x24D6,
                kSmallLetterH                                                                            = 0x24D7,
                kSmallLetterI                                                                            = 0x24D8,
                kSmallLetterJ                                                                            = 0x24D9,
                kSmallLetterK                                                                            = 0x24DA,
                kSmallLetterL                                                                            = 0x24DB,
                kSmallLetterM                                                                            = 0x24DC,
                kSmallLetterN                                                                            = 0x24DD,
                kSmallLetterO                                                                            = 0x24DE,
                kSmallLetterP                                                                            = 0x24DF,
                kSmallLetterQ                                                                            = 0x24E0,
                kSmallLetterR                                                                            = 0x24E1,
                kSmallLetterS                                                                            = 0x24E2,
                kSmallLetterT                                                                            = 0x24E3,
                kSmallLetterU                                                                            = 0x24E4,
                kSmallLetterV                                                                            = 0x24E5,
                kSmallLetterW                                                                            = 0x24E6,
                kSmallLetterX                                                                            = 0x24E7,
                kSmallLetterY                                                                            = 0x24E8,
                kSmallLetterZ                                                                            = 0x24E9
        };

private:

};





//=================================================================================
// class UBoxDrawings
//=================================================================================

class UBoxDrawings {

public:

        enum EBoxDrawingsNames {

                kLightHorizontal                                                                         = 0x2500,
                kHeavyHorizontal                                                                         = 0x2501,
                kLightVertical                                                                           = 0x2502,
                kHeavyVertical                                                                           = 0x2503,
                kLightTripleDashHorizontal                                                       = 0x2504,
                kHeavyTripleDashHorizontal                                                       = 0x2505,
                kLightTripleDashVertical                                                         = 0x2506,
                kHeavyTripleDashVertical                                                         = 0x2507,
                kLightQuadrupleDashHorizontal                                            = 0x2508,
                kHeavyQuadrupleDashHorizontal                                            = 0x2509,
                kLightQuadrupleDashVertical                                                      = 0x250A,
                kHeavyQuadrupleDashVertical                                                      = 0x250B,
                kLightDownAndRight                                                                       = 0x250C,
                kDownLightAndRightHeavy                                                          = 0x250D,
                kDownHeavyAndRightLight                                                          = 0x250E,
                kHeavyDownAndRight                                                                       = 0x250F,
                kLightDownAndLeft                                                                        = 0x2510,
                kDownLightAndLeftHeavy                                                           = 0x2511,
                kDownHeavyAndLeftLight                                                           = 0x2512,
                kHeavyDownAndLeft                                                                        = 0x2513,
                kLightUpAndRight                                                                         = 0x2514,
                kUpLightAndRightHeavy                                                            = 0x2515,
                kUpHeavyAndRightLight                                                            = 0x2516,
                kHeavyUpAndRight                                                                         = 0x2517,
                kLightUpAndLeft                                                                          = 0x2518,
                kUpLightAndLeftHeavy                                                             = 0x2519,
                kUpHeavyAndLeftLight                                                             = 0x251A,
                kHeavyUpAndLeft                                                                          = 0x251B,
                kLightVerticalAndRight                                                           = 0x251C,
                kVerticalLightAndRightHeavy                                                      = 0x251D,
                kUpHeavyAndRightDownLight                                                        = 0x251E,
                kDownHeavyAndRightUpLight                                                        = 0x251F,
                kVerticalHeavyAndRightLight                                                      = 0x2520,
                kDownLightAndRightUpHeavy                                                        = 0x2521,
                kUpLightAndRightDownHeavy                                                        = 0x2522,
                kHeavyVerticalAndRight                                                           = 0x2523,
                kLightVerticalAndLeft                                                            = 0x2524,
                kVerticalLightAndLeftHeavy                                                       = 0x2525,
                kUpHeavyAndLeftDownLight                                                         = 0x2526,
                kDownHeavyAndLeftUpLight                                                         = 0x2527,
                kVerticalHeavyAndLeftLight                                                       = 0x2528,
                kDownLightAndLeftUpHeavy                                                         = 0x2529,
                kUpLightAndLeftDownHeavy                                                         = 0x252A,
                kHeavyVerticalAndLeft                                                            = 0x252B,
                kLightDownAndHorizontal                                                          = 0x252C,
                kLeftHeavyAndRightDownLight                                                      = 0x252D,
                kRightHeavyAndLeftDownLight                                                      = 0x252E,
                kDownLightAndHorizontalHeavy                                             = 0x252F,
                kDownHeavyAndHorizontalLight                                             = 0x2530,
                kRightLightAndLeftDownHeavy                                                      = 0x2531,
                kLeftLightAndRightDownHeavy                                                      = 0x2532,
                kHeavyDownAndHorizontal                                                          = 0x2533,
                kLightUpAndHorizontal                                                            = 0x2534,
                kLeftHeavyAndRightUpLight                                                        = 0x2535,
                kRightHeavyAndLeftUpLight                                                        = 0x2536,
                kUpLightAndHorizontalHeavy                                                       = 0x2537,
                kUpHeavyAndHorizontalLight                                                       = 0x2538,
                kRightLightAndLeftUpHeavy                                                        = 0x2539,
                kLeftLightAndRightUpHeavy                                                        = 0x253A,
                kHeavyUpAndHorizontal                                                            = 0x253B,
                kLightVerticalAndHorizontal                                                      = 0x253C,
                kLeftHeavyAndRightVerticalLight                                          = 0x253D,
                kRightHeavyAndLeftVerticalLight                                          = 0x253E,
                kVerticalLightAndHorizontalHeavy                                         = 0x253F,
                kUpHeavyAndDownHorizontalLight                                           = 0x2540,
                kDownHeavyAndUpHorizontalLight                                           = 0x2541,
                kVerticalHeavyAndHorizontalLight                                         = 0x2542,
                kLeftUpHeavyAndRightDownLight                                            = 0x2543,
                kRightUpHeavyAndLeftDownLight                                            = 0x2544,
                kLeftDownHeavyAndRightUpLight                                            = 0x2545,
                kRightDownHeavyAndLeftUpLight                                            = 0x2546,
                kDownLightAndUpHorizontalHeavy                                           = 0x2547,
                kUpLightAndDownHorizontalHeavy                                           = 0x2548,
                kRightLightAndLeftVerticalHeavy                                          = 0x2549,
                kLeftLightAndRightVerticalHeavy                                          = 0x254A,
                kHeavyVerticalAndHorizontal                                                      = 0x254B,
                kLightDoubleDashHorizontal                                                       = 0x254C,
                kHeavyDoubleDashHorizontal                                                       = 0x254D,
                kLightDoubleDashVertical                                                         = 0x254E,
                kHeavyDoubleDashVertical                                                         = 0x254F,
                kDoubleHorizontal                                                                        = 0x2550,
                kDoubleVertical                                                                          = 0x2551,
                kDownSingleAndRightDouble                                                        = 0x2552,
                kDownDoubleAndRightSingle                                                        = 0x2553,
                kDoubleDownAndRight                                                                      = 0x2554,
                kDownSingleAndLeftDouble                                                         = 0x2555,
                kDownDoubleAndLeftSingle                                                         = 0x2556,
                kDoubleDownAndLeft                                                                       = 0x2557,
                kUpSingleAndRightDouble                                                          = 0x2558,
                kUpDoubleAndRightSingle                                                          = 0x2559,
                kDoubleUpAndRight                                                                        = 0x255A,
                kUpSingleAndLeftDouble                                                           = 0x255B,
                kUpDoubleAndLeftSingle                                                           = 0x255C,
                kDoubleUpAndLeft                                                                         = 0x255D,
                kVerticalSingleAndRightDouble                                            = 0x255E,
                kVerticalDoubleAndRightSingle                                            = 0x255F,
                kDoubleVerticalAndRight                                                          = 0x2560,
                kVerticalSingleAndLeftDouble                                             = 0x2561,
                kVerticalDoubleAndLeftSingle                                             = 0x2562,
                kDoubleVerticalAndLeft                                                           = 0x2563,
                kDownSingleAndHorizontalDouble                                           = 0x2564,
                kDownDoubleAndHorizontalSingle                                           = 0x2565,
                kDoubleDownAndHorizontal                                                         = 0x2566,
                kUpSingleAndHorizontalDouble                                             = 0x2567,
                kUpDoubleAndHorizontalSingle                                             = 0x2568,
                kDoubleUpAndHorizontal                                                           = 0x2569,
                kVerticalSingleAndHorizontalDouble                                       = 0x256A,
                kVerticalDoubleAndHorizontalSingle                                       = 0x256B,
                kDoubleVerticalAndHorizontal                                             = 0x256C,
                kLightArcDownAndRight                                                            = 0x256D,
                kLightArcDownAndLeft                                                             = 0x256E,
                kLightArcUpAndLeft                                                                       = 0x256F,
                kLightArcUpAndRight                                                                      = 0x2570,
                kLightDiagonalUpperRightToLowerLeft                                      = 0x2571,
                kLightDiagonalUpperLeftToLowerRight                                      = 0x2572,
                kLightDiagonalCross                                                                      = 0x2573,
                kLightLeft                                                                                       = 0x2574,
                kLightUp                                                                                         = 0x2575,
                kLightRight                                                                                      = 0x2576,
                kLightDown                                                                                       = 0x2577,
                kHeavyLeft                                                                                       = 0x2578,
                kHeavyUp                                                                                         = 0x2579,
                kHeavyRight                                                                                      = 0x257A,
                kHeavyDown                                                                                       = 0x257B,
                kLightLeftAndHeavyRight                                                          = 0x257C,
                kLightUpAndHeavyDown                                                             = 0x257D,
                kHeavyLeftAndLightRight                                                          = 0x257E,
                kHeavyUpAndLightDown                                                             = 0x257F
        };

private:

};





//=================================================================================
// class UParenthesizedHangul
//=================================================================================

class UParenthesizedHangul {

public:

        enum EParenthesizedHangulNames {

                kKiyeok                                                                                          = 0x3200,
                kNieun                                                                                           = 0x3201,
                kTikeut                                                                                          = 0x3202,
                kRieul                                                                                           = 0x3203,
                kMieum                                                                                           = 0x3204,
                kPieup                                                                                           = 0x3205,
                kSios                                                                                            = 0x3206,
                kIeung                                                                                           = 0x3207,
                kCieuc                                                                                           = 0x3208,
                kChieuch                                                                                         = 0x3209,
                kKhieukh                                                                                         = 0x320A,
                kThieuth                                                                                         = 0x320B,
                kPhieuph                                                                                         = 0x320C,
                kHieuh                                                                                           = 0x320D,
                kKiyeokA                                                                                         = 0x320E,
                kNieunA                                                                                          = 0x320F,
                kTikeutA                                                                                         = 0x3210,
                kRieulA                                                                                          = 0x3211,
                kMieumA                                                                                          = 0x3212,
                kPieupA                                                                                          = 0x3213,
                kSiosA                                                                                           = 0x3214,
                kIeungA                                                                                          = 0x3215,
                kCieucA                                                                                          = 0x3216,
                kChieuchA                                                                                        = 0x3217,
                kKhieukhA                                                                                        = 0x3218,
                kThieuthA                                                                                        = 0x3219,
                kPhieuphA                                                                                        = 0x321A,
                kHieuhA                                                                                          = 0x321B,
                kCieucU                                                                                          = 0x321C
        };

private:

};





//=================================================================================
// class UParenthesizedIdeograph
//=================================================================================

class UParenthesizedIdeograph {

public:

        enum EParenthesizedIdeographNames {

                kOne                                                                                             = 0x3220,
                kTwo                                                                                             = 0x3221,
                kThree                                                                                           = 0x3222,
                kFour                                                                                            = 0x3223,
                kFive                                                                                            = 0x3224,
                kSix                                                                                             = 0x3225,
                kSeven                                                                                           = 0x3226,
                kEight                                                                                           = 0x3227,
                kNine                                                                                            = 0x3228,
                kTen                                                                                             = 0x3229,
                kMoon                                                                                            = 0x322A,
                kFire                                                                                            = 0x322B,
                kWater                                                                                           = 0x322C,
                kWood                                                                                            = 0x322D,
                kMetal                                                                                           = 0x322E,
                kEarth                                                                                           = 0x322F,
                kSun                                                                                             = 0x3230,
                kStock                                                                                           = 0x3231,
                kHave                                                                                            = 0x3232,
                kSociety                                                                                         = 0x3233,
                kName                                                                                            = 0x3234,
                kSpecial                                                                                         = 0x3235,
                kFinancial                                                                                       = 0x3236,
                kCongratulation                                                                          = 0x3237,
                kLabor                                                                                           = 0x3238,
                kRepresent                                                                                       = 0x3239,
                kCall                                                                                            = 0x323A,
                kStudy                                                                                           = 0x323B,
                kSupervise                                                                                       = 0x323C,
                kEnterprise                                                                                      = 0x323D,
                kResource                                                                                        = 0x323E,
                kAlliance                                                                                        = 0x323F,
                kFestival                                                                                        = 0x3240,
                kRest                                                                                            = 0x3241,
                kSelf                                                                                            = 0x3242,
                kReach                                                                                           = 0x3243
        };

private:

};





//=================================================================================
// class UCircledHangul
//=================================================================================

class UCircledHangul {

public:

        enum ECircledHangulNames {

                kKiyeok                                                                                          = 0x3260,
                kNieun                                                                                           = 0x3261,
                kTikeut                                                                                          = 0x3262,
                kRieul                                                                                           = 0x3263,
                kMieum                                                                                           = 0x3264,
                kPieup                                                                                           = 0x3265,
                kSios                                                                                            = 0x3266,
                kIeung                                                                                           = 0x3267,
                kCieuc                                                                                           = 0x3268,
                kChieuch                                                                                         = 0x3269,
                kKhieukh                                                                                         = 0x326A,
                kThieuth                                                                                         = 0x326B,
                kPhieuph                                                                                         = 0x326C,
                kHieuh                                                                                           = 0x326D,
                kKiyeokA                                                                                         = 0x326E,
                kNieunA                                                                                          = 0x326F,
                kTikeutA                                                                                         = 0x3270,
                kRieulA                                                                                          = 0x3271,
                kMieumA                                                                                          = 0x3272,
                kPieupA                                                                                          = 0x3273,
                kSiosA                                                                                           = 0x3274,
                kIeungA                                                                                          = 0x3275,
                kCieucA                                                                                          = 0x3276,
                kChieuchA                                                                                        = 0x3277,
                kKhieukhA                                                                                        = 0x3278,
                kThieuthA                                                                                        = 0x3279,
                kPhieuphA                                                                                        = 0x327A,
                kHieuhA                                                                                          = 0x327B,
                kKoreanStandardSymbol                                                            = 0x327F
        };

private:

};





//=================================================================================
// class UCircledIdeograph
//=================================================================================

class UCircledIdeograph {

public:

        enum ECircledIdeographNames {

                kOne                                                                                             = 0x3280,
                kTwo                                                                                             = 0x3281,
                kThree                                                                                           = 0x3282,
                kFour                                                                                            = 0x3283,
                kFive                                                                                            = 0x3284,
                kSix                                                                                             = 0x3285,
                kSeven                                                                                           = 0x3286,
                kEight                                                                                           = 0x3287,
                kNine                                                                                            = 0x3288,
                kTen                                                                                             = 0x3289,
                kMoon                                                                                            = 0x328A,
                kFire                                                                                            = 0x328B,
                kWater                                                                                           = 0x328C,
                kWood                                                                                            = 0x328D,
                kMetal                                                                                           = 0x328E,
                kEarth                                                                                           = 0x328F,
                kSun                                                                                             = 0x3290,
                kStock                                                                                           = 0x3291,
                kHave                                                                                            = 0x3292,
                kSociety                                                                                         = 0x3293,
                kName                                                                                            = 0x3294,
                kSpecial                                                                                         = 0x3295,
                kFinancial                                                                                       = 0x3296,
                kCongratulation                                                                          = 0x3297,
                kLabor                                                                                           = 0x3298,
                kSecret                                                                                          = 0x3299,
                kMale                                                                                            = 0x329A,
                kFemale                                                                                          = 0x329B,
                kSuitable                                                                                        = 0x329C,
                kExcellent                                                                                       = 0x329D,
                kPrint                                                                                           = 0x329E,
                kAttention                                                                                       = 0x329F,
                kItem                                                                                            = 0x32A0,
                kRest                                                                                            = 0x32A1,
                kCopy                                                                                            = 0x32A2,
                kCorrect                                                                                         = 0x32A3,
                kHigh                                                                                            = 0x32A4,
                kCentre                                                                                          = 0x32A5,
                kLow                                                                                             = 0x32A6,
                kLeft                                                                                            = 0x32A7,
                kRight                                                                                           = 0x32A8,
                kMedicine                                                                                        = 0x32A9,
                kReligion                                                                                        = 0x32AA,
                kStudy                                                                                           = 0x32AB,
                kSupervise                                                                                       = 0x32AC,
                kEnterprise                                                                                      = 0x32AD,
                kResource                                                                                        = 0x32AE,
                kAlliance                                                                                        = 0x32AF,
                kNight                                                                                           = 0x32B0
        };

private:

};





//=================================================================================
// class UCircledKatakana
//=================================================================================

class UCircledKatakana {

public:

        enum ECircledKatakanaNames {

                kA                                                                                                       = 0x32D0,
                kI                                                                                                       = 0x32D1,
                kU                                                                                                       = 0x32D2,
                kE                                                                                                       = 0x32D3,
                kO                                                                                                       = 0x32D4,
                kKa                                                                                                      = 0x32D5,
                kKi                                                                                                      = 0x32D6,
                kKu                                                                                                      = 0x32D7,
                kKe                                                                                                      = 0x32D8,
                kKo                                                                                                      = 0x32D9,
                kSa                                                                                                      = 0x32DA,
                kSi                                                                                                      = 0x32DB,
                kSu                                                                                                      = 0x32DC,
                kSe                                                                                                      = 0x32DD,
                kSo                                                                                                      = 0x32DE,
                kTa                                                                                                      = 0x32DF,
                kTi                                                                                                      = 0x32E0,
                kTu                                                                                                      = 0x32E1,
                kTe                                                                                                      = 0x32E2,
                kTo                                                                                                      = 0x32E3,
                kNa                                                                                                      = 0x32E4,
                kNi                                                                                                      = 0x32E5,
                kNu                                                                                                      = 0x32E6,
                kNe                                                                                                      = 0x32E7,
                kNo                                                                                                      = 0x32E8,
                kHa                                                                                                      = 0x32E9,
                kHi                                                                                                      = 0x32EA,
                kHu                                                                                                      = 0x32EB,
                kHe                                                                                                      = 0x32EC,
                kHo                                                                                                      = 0x32ED,
                kMa                                                                                                      = 0x32EE,
                kMi                                                                                                      = 0x32EF,
                kMu                                                                                                      = 0x32F0,
                kMe                                                                                                      = 0x32F1,
                kMo                                                                                                      = 0x32F2,
                kYa                                                                                                      = 0x32F3,
                kYu                                                                                                      = 0x32F4,
                kYo                                                                                                      = 0x32F5,
                kRa                                                                                                      = 0x32F6,
                kRi                                                                                                      = 0x32F7,
                kRu                                                                                                      = 0x32F8,
                kRe                                                                                                      = 0x32F9,
                kRo                                                                                                      = 0x32FA,
                kWa                                                                                                      = 0x32FB,
                kWi                                                                                                      = 0x32FC,
                kWe                                                                                                      = 0x32FD,
                kWo                                                                                                      = 0x32FE
        };

private:

};





//=================================================================================
// class UCJKSquaredWords
//=================================================================================

class UCJKSquaredWords {

public:

        enum ECJKSquaredWordsNames {

                kApaato                                                                                          = 0x3300,
                kAruhua                                                                                          = 0x3301,
                kAnpea                                                                                           = 0x3302,
                kAaru                                                                                            = 0x3303,
                kIningu                                                                                          = 0x3304,
                kInti                                                                                            = 0x3305,
                kUon                                                                                             = 0x3306,
                kEsukuudo                                                                                        = 0x3307,
                kEekaa                                                                                           = 0x3308,
                kOnsu                                                                                            = 0x3309,
                kOomu                                                                                            = 0x330A,
                kKairi                                                                                           = 0x330B,
                kKaratto                                                                                         = 0x330C,
                kKarorii                                                                                         = 0x330D,
                kGaron                                                                                           = 0x330E,
                kGanma                                                                                           = 0x330F,
                kGiga                                                                                            = 0x3310,
                kGinii                                                                                           = 0x3311,
                kKyurii                                                                                          = 0x3312,
                kGirudaa                                                                                         = 0x3313,
                kKiro                                                                                            = 0x3314,
                kKiroguramu                                                                                      = 0x3315,
                kKiromeetoru                                                                             = 0x3316,
                kKirowatto                                                                                       = 0x3317,
                kGuramu                                                                                          = 0x3318,
                kGuramuton                                                                                       = 0x3319,
                kKuruzeiro                                                                                       = 0x331A,
                kKuroone                                                                                         = 0x331B,
                kKeesu                                                                                           = 0x331C,
                kKoruna                                                                                          = 0x331D,
                kKoopo                                                                                           = 0x331E,
                kSaikuru                                                                                         = 0x331F,
                kSantiimu                                                                                        = 0x3320,
                kSiringu                                                                                         = 0x3321,
                kSenti                                                                                           = 0x3322,
                kSento                                                                                           = 0x3323,
                kDaasu                                                                                           = 0x3324,
                kDesi                                                                                            = 0x3325,
                kDoru                                                                                            = 0x3326,
                kTon                                                                                             = 0x3327,
                kNano                                                                                            = 0x3328,
                kNotto                                                                                           = 0x3329,
                kHaitu                                                                                           = 0x332A,
                kPaasento                                                                                        = 0x332B,
                kPaatu                                                                                           = 0x332C,
                kBaareru                                                                                         = 0x332D,
                kPiasutoru                                                                                       = 0x332E,
                kPikuru                                                                                          = 0x332F,
                kPiko                                                                                            = 0x3330,
                kBiru                                                                                            = 0x3331,
                kHuaraddo                                                                                        = 0x3332,
                kHuiito                                                                                          = 0x3333,
                kBussyeru                                                                                        = 0x3334,
                kHuran                                                                                           = 0x3335,
                kHekutaaru                                                                                       = 0x3336,
                kPeso                                                                                            = 0x3337,
                kPenihi                                                                                          = 0x3338,
                kHerutu                                                                                          = 0x3339,
                kPensu                                                                                           = 0x333A,
                kPeezi                                                                                           = 0x333B,
                kBeeta                                                                                           = 0x333C,
                kPointo                                                                                          = 0x333D,
                kBoruto                                                                                          = 0x333E,
                kHon                                                                                             = 0x333F,
                kPondo                                                                                           = 0x3340,
                kHooru                                                                                           = 0x3341,
                kHoon                                                                                            = 0x3342,
                kMaikuro                                                                                         = 0x3343,
                kMairu                                                                                           = 0x3344,
                kMahha                                                                                           = 0x3345,
                kMaruku                                                                                          = 0x3346,
                kMansyon                                                                                         = 0x3347,
                kMikuron                                                                                         = 0x3348,
                kMiri                                                                                            = 0x3349,
                kMiribaaru                                                                                       = 0x334A,
                kMega                                                                                            = 0x334B,
                kMegaton                                                                                         = 0x334C,
                kMeetoru                                                                                         = 0x334D,
                kYaado                                                                                           = 0x334E,
                kYaaru                                                                                           = 0x334F,
                kYuan                                                                                            = 0x3350,
                kRittoru                                                                                         = 0x3351,
                kRira                                                                                            = 0x3352,
                kRupii                                                                                           = 0x3353,
                kRuuburu                                                                                         = 0x3354,
                kRemu                                                                                            = 0x3355,
                kRentogen                                                                                        = 0x3356,
                kWatto                                                                                           = 0x3357,
                kEraNameHeisei                                                                           = 0x337B,
                kEraNameSyouwa                                                                           = 0x337C,
                kEraNameTaisyou                                                                          = 0x337D,
                kEraNameMeizi                                                                            = 0x337E,
                kCorporation                                                                             = 0x337F
        };

private:

};





//=================================================================================
// class UCJKSquaredAbbreviations
//=================================================================================

class UCJKSquaredAbbreviations {

public:

        enum ECJKSquaredAbbreviationsNames {

                kHpa                                                                                             = 0x3371,
                kDa                                                                                                      = 0x3372,
                kAu                                                                                                      = 0x3373,
                kBar                                                                                             = 0x3374,
                kOv                                                                                                      = 0x3375,
                kPc                                                                                                      = 0x3376,
                kPaAmps                                                                                          = 0x3380,
                kNa                                                                                                      = 0x3381,
                kMuA                                                                                             = 0x3382,
                kMa                                                                                                      = 0x3383,
                kKa                                                                                                      = 0x3384,
                kKb                                                                                                      = 0x3385,
                kMb                                                                                                      = 0x3386,
                kGb                                                                                                      = 0x3387,
                kCal                                                                                             = 0x3388,
                kKcal                                                                                            = 0x3389,
                kPf                                                                                                      = 0x338A,
                kNf                                                                                                      = 0x338B,
                kMuF                                                                                             = 0x338C,
                kMuG                                                                                             = 0x338D,
                kMg                                                                                                      = 0x338E,
                kKg                                                                                                      = 0x338F,
                kHz                                                                                                      = 0x3390,
                kKhz                                                                                             = 0x3391,
                kMhz                                                                                             = 0x3392,
                kGhz                                                                                             = 0x3393,
                kThz                                                                                             = 0x3394,
                kMuL                                                                                             = 0x3395,
                kMl                                                                                                      = 0x3396,
                kDl                                                                                                      = 0x3397,
                kKl                                                                                                      = 0x3398,
                kFm                                                                                                      = 0x3399,
                kNm                                                                                                      = 0x339A,
                kMuM                                                                                             = 0x339B,
                kMm                                                                                                      = 0x339C,
                kCm                                                                                                      = 0x339D,
                kKm                                                                                                      = 0x339E,
                kMmD                                                                                             = 0x339F,
                kCmD                                                                                             = 0x33A0,
                kMD                                                                                                      = 0x33A1,
                kKmD                                                                                             = 0x33A2,
                kMmCubed                                                                                         = 0x33A3,
                kCmCubed                                                                                         = 0x33A4,
                kMCubed                                                                                          = 0x33A5,
                kKmCubed                                                                                         = 0x33A6,
                kMOverS                                                                                          = 0x33A7,
                kMOverSD                                                                                         = 0x33A8,
                kPa                                                                                                      = 0x33A9,
                kKpa                                                                                             = 0x33AA,
                kMpa                                                                                             = 0x33AB,
                kGpa                                                                                             = 0x33AC,
                kRad                                                                                             = 0x33AD,
                kRadOverS                                                                                        = 0x33AE,
                kRadOverSD                                                                                       = 0x33AF,
                kPs                                                                                                      = 0x33B0,
                kNs                                                                                                      = 0x33B1,
                kMuS                                                                                             = 0x33B2,
                kMs                                                                                                      = 0x33B3,
                kPv                                                                                                      = 0x33B4,
                kNv                                                                                                      = 0x33B5,
                kMuV                                                                                             = 0x33B6,
                kMv                                                                                                      = 0x33B7,
                kKv                                                                                                      = 0x33B8,
                kMvMega                                                                                          = 0x33B9,
                kPw                                                                                                      = 0x33BA,
                kNw                                                                                                      = 0x33BB,
                kMuW                                                                                             = 0x33BC,
                kMw                                                                                                      = 0x33BD,
                kKw                                                                                                      = 0x33BE,
                kMwMega                                                                                          = 0x33BF,
                kKOhm                                                                                            = 0x33C0,
                kMOhm                                                                                            = 0x33C1,
                kAm                                                                                                      = 0x33C2,
                kBq                                                                                                      = 0x33C3,
                kCc                                                                                                      = 0x33C4,
                kCd                                                                                                      = 0x33C5,
                kCOverKg                                                                                         = 0x33C6,
                kCo                                                                                                      = 0x33C7,
                kDb                                                                                                      = 0x33C8,
                kGy                                                                                                      = 0x33C9,
                kHa                                                                                                      = 0x33CA,
                kHp                                                                                                      = 0x33CB,
                kIn                                                                                                      = 0x33CC,
                kKk                                                                                                      = 0x33CD,
                kKmCapital                                                                                       = 0x33CE,
                kKt                                                                                                      = 0x33CF,
                kLm                                                                                                      = 0x33D0,
                kLn                                                                                                      = 0x33D1,
                kLog                                                                                             = 0x33D2,
                kLx                                                                                                      = 0x33D3,
                kMbSmall                                                                                         = 0x33D4,
                kMil                                                                                             = 0x33D5,
                kMol                                                                                             = 0x33D6,
                kPh                                                                                                      = 0x33D7,
                kPm                                                                                                      = 0x33D8,
                kPpm                                                                                             = 0x33D9,
                kPr                                                                                                      = 0x33DA,
                kSr                                                                                                      = 0x33DB,
                kSv                                                                                                      = 0x33DC,
                kWb                                                                                                      = 0x33DD
        };

private:

};





//=================================================================================
// class ULatinSmallLigature
//=================================================================================

class ULatinSmallLigature {

public:

        enum ELatinSmallLigatureNames {

                kFf                                                                                                      = 0xFB00,
                kFi                                                                                                      = 0xFB01,
                kFl                                                                                                      = 0xFB02,
                kFfi                                                                                             = 0xFB03,
                kFfl                                                                                             = 0xFB04,
                kLongST                                                                                          = 0xFB05,
                kSt                                                                                                      = 0xFB06
        };

private:

};





//=================================================================================
// class UArmenianSmallLigature
//=================================================================================

class UArmenianSmallLigature {

public:

        enum EArmenianSmallLigatureNames {

                kEchYiwn                                                                                         = 0x0587,
                kMenNow                                                                                          = 0xFB13,
                kMenEch                                                                                          = 0xFB14,
                kMenIni                                                                                          = 0xFB15,
                kVewNow                                                                                          = 0xFB16,
                kMenXeh                                                                                          = 0xFB17
        };

private:

};





//=================================================================================
// class UFullwidth
//=================================================================================

class UFullwidth {

public:

        enum EFullwidthNames {

                kExclamationMark                                                                         = 0xFF01,
                kQuotationMark                                                                           = 0xFF02,
                kNumberSign                                                                                      = 0xFF03,
                kDollarSign                                                                                      = 0xFF04,
                kPercentSign                                                                             = 0xFF05,
                kAmpersand                                                                                       = 0xFF06,
                kApostrophe                                                                                      = 0xFF07,
                kLeftParenthesis                                                                         = 0xFF08,
                kRightParenthesis                                                                        = 0xFF09,
                kAsterisk                                                                                        = 0xFF0A,
                kPlusSign                                                                                        = 0xFF0B,
                kComma                                                                                           = 0xFF0C,
                kHyphenMinus                                                                             = 0xFF0D,
                kFullStop                                                                                        = 0xFF0E,
                kSolidus                                                                                         = 0xFF0F,
                kDigitZero                                                                                       = 0xFF10,
                kDigitOne                                                                                        = 0xFF11,
                kDigitTwo                                                                                        = 0xFF12,
                kDigitThree                                                                                      = 0xFF13,
                kDigitFour                                                                                       = 0xFF14,
                kDigitFive                                                                                       = 0xFF15,
                kDigitSix                                                                                        = 0xFF16,
                kDigitSeven                                                                                      = 0xFF17,
                kDigitEight                                                                                      = 0xFF18,
                kDigitNine                                                                                       = 0xFF19,
                kColon                                                                                           = 0xFF1A,
                kSemicolon                                                                                       = 0xFF1B,
                kLessThanSign                                                                            = 0xFF1C,
                kEqualsSign                                                                                      = 0xFF1D,
                kGreaterThanSign                                                                         = 0xFF1E,
                kQuestionMark                                                                            = 0xFF1F,
                kCommercialAt                                                                            = 0xFF20,
                kLatinCapitalLetterA                                                             = 0xFF21,
                kLatinCapitalLetterB                                                             = 0xFF22,
                kLatinCapitalLetterC                                                             = 0xFF23,
                kLatinCapitalLetterD                                                             = 0xFF24,
                kLatinCapitalLetterE                                                             = 0xFF25,
                kLatinCapitalLetterF                                                             = 0xFF26,
                kLatinCapitalLetterG                                                             = 0xFF27,
                kLatinCapitalLetterH                                                             = 0xFF28,
                kLatinCapitalLetterI                                                             = 0xFF29,
                kLatinCapitalLetterJ                                                             = 0xFF2A,
                kLatinCapitalLetterK                                                             = 0xFF2B,
                kLatinCapitalLetterL                                                             = 0xFF2C,
                kLatinCapitalLetterM                                                             = 0xFF2D,
                kLatinCapitalLetterN                                                             = 0xFF2E,
                kLatinCapitalLetterO                                                             = 0xFF2F,
                kLatinCapitalLetterP                                                             = 0xFF30,
                kLatinCapitalLetterQ                                                             = 0xFF31,
                kLatinCapitalLetterR                                                             = 0xFF32,
                kLatinCapitalLetterS                                                             = 0xFF33,
                kLatinCapitalLetterT                                                             = 0xFF34,
                kLatinCapitalLetterU                                                             = 0xFF35,
                kLatinCapitalLetterV                                                             = 0xFF36,
                kLatinCapitalLetterW                                                             = 0xFF37,
                kLatinCapitalLetterX                                                             = 0xFF38,
                kLatinCapitalLetterY                                                             = 0xFF39,
                kLatinCapitalLetterZ                                                             = 0xFF3A,
                kLeftSquareBracket                                                                       = 0xFF3B,
                kReverseSolidus                                                                          = 0xFF3C,
                kRightSquareBracket                                                                      = 0xFF3D,
                kCircumflexAccent                                                                        = 0xFF3E,
                kLowLine                                                                                         = 0xFF3F,
                kGraveAccent                                                                             = 0xFF40,
                kLatinSmallLetterA                                                                       = 0xFF41,
                kLatinSmallLetterB                                                                       = 0xFF42,
                kLatinSmallLetterC                                                                       = 0xFF43,
                kLatinSmallLetterD                                                                       = 0xFF44,
                kLatinSmallLetterE                                                                       = 0xFF45,
                kLatinSmallLetterF                                                                       = 0xFF46,
                kLatinSmallLetterG                                                                       = 0xFF47,
                kLatinSmallLetterH                                                                       = 0xFF48,
                kLatinSmallLetterI                                                                       = 0xFF49,
                kLatinSmallLetterJ                                                                       = 0xFF4A,
                kLatinSmallLetterK                                                                       = 0xFF4B,
                kLatinSmallLetterL                                                                       = 0xFF4C,
                kLatinSmallLetterM                                                                       = 0xFF4D,
                kLatinSmallLetterN                                                                       = 0xFF4E,
                kLatinSmallLetterO                                                                       = 0xFF4F,
                kLatinSmallLetterP                                                                       = 0xFF50,
                kLatinSmallLetterQ                                                                       = 0xFF51,
                kLatinSmallLetterR                                                                       = 0xFF52,
                kLatinSmallLetterS                                                                       = 0xFF53,
                kLatinSmallLetterT                                                                       = 0xFF54,
                kLatinSmallLetterU                                                                       = 0xFF55,
                kLatinSmallLetterV                                                                       = 0xFF56,
                kLatinSmallLetterW                                                                       = 0xFF57,
                kLatinSmallLetterX                                                                       = 0xFF58,
                kLatinSmallLetterY                                                                       = 0xFF59,
                kLatinSmallLetterZ                                                                       = 0xFF5A,
                kLeftCurlyBracket                                                                        = 0xFF5B,
                kVerticalLine                                                                            = 0xFF5C,
                kRightCurlyBracket                                                                       = 0xFF5D,
                kTilde                                                                                           = 0xFF5E,
                kCentSign                                                                                        = 0xFFE0,
                kPoundSign                                                                                       = 0xFFE1,
                kNotSign                                                                                         = 0xFFE2,
                kMacron                                                                                          = 0xFFE3,
                kBrokenBar                                                                                       = 0xFFE4,
                kYenSign                                                                                         = 0xFFE5,
                kWonSign                                                                                         = 0xFFE6
        };

private:

};





//=================================================================================
// class UHalfwidth
//=================================================================================

class UHalfwidth {

public:

        enum EHalfwidthNames {

                kIdeographicFullStop                                                             = 0xFF61,
                kLeftCornerBracket                                                                       = 0xFF62,
                kRightCornerBracket                                                                      = 0xFF63,
                kIdeographicComma                                                                        = 0xFF64,
                kKatakanaMiddleDot                                                                       = 0xFF65,
                kKatakanaLetterWo                                                                        = 0xFF66,
                kKatakanaLetterSmallA                                                            = 0xFF67,
                kKatakanaLetterSmallI                                                            = 0xFF68,
                kKatakanaLetterSmallU                                                            = 0xFF69,
                kKatakanaLetterSmallE                                                            = 0xFF6A,
                kKatakanaLetterSmallO                                                            = 0xFF6B,
                kKatakanaLetterSmallYa                                                           = 0xFF6C,
                kKatakanaLetterSmallYu                                                           = 0xFF6D,
                kKatakanaLetterSmallYo                                                           = 0xFF6E,
                kKatakanaLetterSmallTu                                                           = 0xFF6F,
                kKatakanaHiraganaProlongedSoundMark                                      = 0xFF70,
                kKatakanaLetterA                                                                         = 0xFF71,
                kKatakanaLetterI                                                                         = 0xFF72,
                kKatakanaLetterU                                                                         = 0xFF73,
                kKatakanaLetterE                                                                         = 0xFF74,
                kKatakanaLetterO                                                                         = 0xFF75,
                kKatakanaLetterKa                                                                        = 0xFF76,
                kKatakanaLetterKi                                                                        = 0xFF77,
                kKatakanaLetterKu                                                                        = 0xFF78,
                kKatakanaLetterKe                                                                        = 0xFF79,
                kKatakanaLetterKo                                                                        = 0xFF7A,
                kKatakanaLetterSa                                                                        = 0xFF7B,
                kKatakanaLetterSi                                                                        = 0xFF7C,
                kKatakanaLetterSu                                                                        = 0xFF7D,
                kKatakanaLetterSe                                                                        = 0xFF7E,
                kKatakanaLetterSo                                                                        = 0xFF7F,
                kKatakanaLetterTa                                                                        = 0xFF80,
                kKatakanaLetterTi                                                                        = 0xFF81,
                kKatakanaLetterTu                                                                        = 0xFF82,
                kKatakanaLetterTe                                                                        = 0xFF83,
                kKatakanaLetterTo                                                                        = 0xFF84,
                kKatakanaLetterNa                                                                        = 0xFF85,
                kKatakanaLetterNi                                                                        = 0xFF86,
                kKatakanaLetterNu                                                                        = 0xFF87,
                kKatakanaLetterNe                                                                        = 0xFF88,
                kKatakanaLetterNo                                                                        = 0xFF89,
                kKatakanaLetterHa                                                                        = 0xFF8A,
                kKatakanaLetterHi                                                                        = 0xFF8B,
                kKatakanaLetterHu                                                                        = 0xFF8C,
                kKatakanaLetterHe                                                                        = 0xFF8D,
                kKatakanaLetterHo                                                                        = 0xFF8E,
                kKatakanaLetterMa                                                                        = 0xFF8F,
                kKatakanaLetterMi                                                                        = 0xFF90,
                kKatakanaLetterMu                                                                        = 0xFF91,
                kKatakanaLetterMe                                                                        = 0xFF92,
                kKatakanaLetterMo                                                                        = 0xFF93,
                kKatakanaLetterYa                                                                        = 0xFF94,
                kKatakanaLetterYu                                                                        = 0xFF95,
                kKatakanaLetterYo                                                                        = 0xFF96,
                kKatakanaLetterRa                                                                        = 0xFF97,
                kKatakanaLetterRi                                                                        = 0xFF98,
                kKatakanaLetterRu                                                                        = 0xFF99,
                kKatakanaLetterRe                                                                        = 0xFF9A,
                kKatakanaLetterRo                                                                        = 0xFF9B,
                kKatakanaLetterWa                                                                        = 0xFF9C,
                kKatakanaLetterN                                                                         = 0xFF9D,
                kKatakanaVoicedSoundMark                                                         = 0xFF9E,
                kKatakanaSemiVoicedSoundMark                                             = 0xFF9F,
                kHangulFiller                                                                            = 0xFFA0,
                kHangulLetterKiyeok                                                                      = 0xFFA1,
                kHangulLetterSsangkiyeok                                                         = 0xFFA2,
                kHangulLetterKiyeokSios                                                          = 0xFFA3,
                kHangulLetterNieun                                                                       = 0xFFA4,
                kHangulLetterNieunCieuc                                                          = 0xFFA5,
                kHangulLetterNieunHieuh                                                          = 0xFFA6,
                kHangulLetterTikeut                                                                      = 0xFFA7,
                kHangulLetterSsangtikeut                                                         = 0xFFA8,
                kHangulLetterRieul                                                                       = 0xFFA9,
                kHangulLetterRieulKiyeok                                                         = 0xFFAA,
                kHangulLetterRieulMieum                                                          = 0xFFAB,
                kHangulLetterRieulPieup                                                          = 0xFFAC,
                kHangulLetterRieulSios                                                           = 0xFFAD,
                kHangulLetterRieulThieuth                                                        = 0xFFAE,
                kHangulLetterRieulPhieuph                                                        = 0xFFAF,
                kHangulLetterRieulHieuh                                                          = 0xFFB0,
                kHangulLetterMieum                                                                       = 0xFFB1,
                kHangulLetterPieup                                                                       = 0xFFB2,
                kHangulLetterSsangpieup                                                          = 0xFFB3,
                kHangulLetterPieupSios                                                           = 0xFFB4,
                kHangulLetterSios                                                                        = 0xFFB5,
                kHangulLetterSsangsios                                                           = 0xFFB6,
                kHangulLetterIeung                                                                       = 0xFFB7,
                kHangulLetterCieuc                                                                       = 0xFFB8,
                kHangulLetterSsangcieuc                                                          = 0xFFB9,
                kHangulLetterChieuch                                                             = 0xFFBA,
                kHangulLetterKhieukh                                                             = 0xFFBB,
                kHangulLetterThieuth                                                             = 0xFFBC,
                kHangulLetterPhieuph                                                             = 0xFFBD,
                kHangulLetterHieuh                                                                       = 0xFFBE,
                kHangulLetterA                                                                           = 0xFFC2,
                kHangulLetterAe                                                                          = 0xFFC3,
                kHangulLetterYa                                                                          = 0xFFC4,
                kHangulLetterYae                                                                         = 0xFFC5,
                kHangulLetterEo                                                                          = 0xFFC6,
                kHangulLetterE                                                                           = 0xFFC7,
                kHangulLetterYeo                                                                         = 0xFFCA,
                kHangulLetterYe                                                                          = 0xFFCB,
                kHangulLetterO                                                                           = 0xFFCC,
                kHangulLetterWa                                                                          = 0xFFCD,
                kHangulLetterWae                                                                         = 0xFFCE,
                kHangulLetterOe                                                                          = 0xFFCF,
                kHangulLetterYo                                                                          = 0xFFD2,
                kHangulLetterU                                                                           = 0xFFD3,
                kHangulLetterWeo                                                                         = 0xFFD4,
                kHangulLetterWe                                                                          = 0xFFD5,
                kHangulLetterWi                                                                          = 0xFFD6,
                kHangulLetterYu                                                                          = 0xFFD7,
                kHangulLetterEu                                                                          = 0xFFDA,
                kHangulLetterYi                                                                          = 0xFFDB,
                kHangulLetterI                                                                           = 0xFFDC,
                kFormsLightVertical                                                                      = 0xFFE8,
                kLeftwardsArrow                                                                          = 0xFFE9,
                kUpwardsArrow                                                                            = 0xFFEA,
                kRightwardsArrow                                                                         = 0xFFEB,
                kDownwardsArrow                                                                          = 0xFFEC,
                kBlackSquare                                                                             = 0xFFED,
                kWhiteCircle                                                                             = 0xFFEE
        };

private:

};





//=================================================================================
// class UPresentationFormForVertical
//=================================================================================

class UPresentationFormForVertical {

public:

        enum EPresentationFormForVerticalNames {

                kTwoDotLeader                                                            = 0xFE30,
                kEmDash                                                                          = 0xFE31,
                kEnDash                                                                          = 0xFE32,
                kLowLine                                                                         = 0xFE33,
                kWavyLowLine                                                             = 0xFE34,
                kLeftParenthesis                                                         = 0xFE35,
                kRightParenthesis                                                        = 0xFE36,
                kLeftCurlyBracket                                                        = 0xFE37,
                kRightCurlyBracket                                                       = 0xFE38,
                kLeftTortoiseShellBracket                                        = 0xFE39,
                kRightTortoiseShellBracket                                       = 0xFE3A,
                kLeftBlackLenticularBracket                                      = 0xFE3B,
                kRightBlackLenticularBracket                             = 0xFE3C,
                kLeftDoubleAngleBracket                                          = 0xFE3D,
                kRightDoubleAngleBracket                                         = 0xFE3E,
                kLeftAngleBracket                                                        = 0xFE3F,
                kRightAngleBracket                                                       = 0xFE40,
                kLeftCornerBracket                                                       = 0xFE41,
                kRightCornerBracket                                                      = 0xFE42,
                kLeftWhiteCornerBracket                                          = 0xFE43,
                kRightWhiteCornerBracket                                         = 0xFE44
        };

private:
};





//=================================================================================
// class USmallVariants
//=================================================================================

class USmallVariants {

public:

        enum ESmallVariantsNames {

                kComma                                                                                           = 0xFE50,
                kIdeographicComma                                                                        = 0xFE51,
                kFullStop                                                                                        = 0xFE52,
                kSemicolon                                                                                       = 0xFE54,
                kColon                                                                                           = 0xFE55,
                kQuestionMark                                                                            = 0xFE56,
                kExclamationMark                                                                         = 0xFE57,
                kEmDash                                                                                          = 0xFE58,
                kLeftParenthesis                                                                         = 0xFE59,
                kRightParenthesis                                                                        = 0xFE5A,
                kLeftCurlyBracket                                                                        = 0xFE5B,
                kRightCurlyBracket                                                                       = 0xFE5C,
                kLeftTortoiseShellBracket                                                        = 0xFE5D,
                kRightTortoiseShellBracket                                                       = 0xFE5E,
                kNumberSign                                                                                      = 0xFE5F,
                kAmpersand                                                                                       = 0xFE60,
                kAsterisk                                                                                        = 0xFE61,
                kPlusSign                                                                                        = 0xFE62,
                kHyphenMinus                                                                             = 0xFE63,
                kLessThanSign                                                                            = 0xFE64,
                kGreaterThanSign                                                                         = 0xFE65,
                kEqualsSign                                                                                      = 0xFE66,
                kReverseSolidus                                                                          = 0xFE68,
                kDollarSign                                                                                      = 0xFE69,
                kPercentSign                                                                             = 0xFE6A,
                kCommercialAt                                                                            = 0xFE6B,

                //      Values derived from Unicode 1.0 names

                kPeriod                                                                                          = kFullStop,
                kOpeningParenthesis                                                              = kLeftParenthesis,
                kClosingParenthesis                                                              = kRightParenthesis,
                kOpeningCurlyBracket                                                             = kLeftCurlyBracket,
                kClosingCurlyBracket                                                             = kRightCurlyBracket,
                kOpeningTortoiseShellBracket                                             = kLeftTortoiseShellBracket,
                kClosingTortoiseShellBracket                                             = kRightTortoiseShellBracket,
                kBackslash                                                                                       = kReverseSolidus

        };

private:

};




//=================================================================================
// class UCJKCompatibility
//=================================================================================

class UCJKCompatibility {

public:

        enum ECJKCompatibilityNames {

                kF900                                                                                            = 0xF900,
                kF901                                                                                            = 0xF901,
                kF902                                                                                            = 0xF902,
                kF903                                                                                            = 0xF903,
                kF904                                                                                            = 0xF904,
                kF905                                                                                            = 0xF905,
                kF906                                                                                            = 0xF906,
                kF907                                                                                            = 0xF907,
                kF908                                                                                            = 0xF908,
                kF909                                                                                            = 0xF909,
                kF90A                                                                                            = 0xF90A,
                kF90B                                                                                            = 0xF90B,
                kF90C                                                                                            = 0xF90C,
                kF90D                                                                                            = 0xF90D,
                kF90E                                                                                            = 0xF90E,
                kF90F                                                                                            = 0xF90F,
                kF910                                                                                            = 0xF910,
                kF911                                                                                            = 0xF911,
                kF912                                                                                            = 0xF912,
                kF913                                                                                            = 0xF913,
                kF914                                                                                            = 0xF914,
                kF915                                                                                            = 0xF915,
                kF916                                                                                            = 0xF916,
                kF917                                                                                            = 0xF917,
                kF918                                                                                            = 0xF918,
                kF919                                                                                            = 0xF919,
                kF91A                                                                                            = 0xF91A,
                kF91B                                                                                            = 0xF91B,
                kF91C                                                                                            = 0xF91C,
                kF91D                                                                                            = 0xF91D,
                kF91E                                                                                            = 0xF91E,
                kF91F                                                                                            = 0xF91F,
                kF920                                                                                            = 0xF920,
                kF921                                                                                            = 0xF921,
                kF922                                                                                            = 0xF922,
                kF923                                                                                            = 0xF923,
                kF924                                                                                            = 0xF924,
                kF925                                                                                            = 0xF925,
                kF926                                                                                            = 0xF926,
                kF927                                                                                            = 0xF927,
                kF928                                                                                            = 0xF928,
                kF929                                                                                            = 0xF929,
                kF92A                                                                                            = 0xF92A,
                kF92B                                                                                            = 0xF92B,
                kF92C                                                                                            = 0xF92C,
                kF92D                                                                                            = 0xF92D,
                kF92E                                                                                            = 0xF92E,
                kF92F                                                                                            = 0xF92F,
                kF930                                                                                            = 0xF930,
                kF931                                                                                            = 0xF931,
                kF932                                                                                            = 0xF932,
                kF933                                                                                            = 0xF933,
                kF934                                                                                            = 0xF934,
                kF935                                                                                            = 0xF935,
                kF936                                                                                            = 0xF936,
                kF937                                                                                            = 0xF937,
                kF938                                                                                            = 0xF938,
                kF939                                                                                            = 0xF939,
                kF93A                                                                                            = 0xF93A,
                kF93B                                                                                            = 0xF93B,
                kF93C                                                                                            = 0xF93C,
                kF93D                                                                                            = 0xF93D,
                kF93E                                                                                            = 0xF93E,
                kF93F                                                                                            = 0xF93F,
                kF940                                                                                            = 0xF940,
                kF941                                                                                            = 0xF941,
                kF942                                                                                            = 0xF942,
                kF943                                                                                            = 0xF943,
                kF944                                                                                            = 0xF944,
                kF945                                                                                            = 0xF945,
                kF946                                                                                            = 0xF946,
                kF947                                                                                            = 0xF947,
                kF948                                                                                            = 0xF948,
                kF949                                                                                            = 0xF949,
                kF94A                                                                                            = 0xF94A,
                kF94B                                                                                            = 0xF94B,
                kF94C                                                                                            = 0xF94C,
                kF94D                                                                                            = 0xF94D,
                kF94E                                                                                            = 0xF94E,
                kF94F                                                                                            = 0xF94F,
                kF950                                                                                            = 0xF950,
                kF951                                                                                            = 0xF951,
                kF952                                                                                            = 0xF952,
                kF953                                                                                            = 0xF953,
                kF954                                                                                            = 0xF954,
                kF955                                                                                            = 0xF955,
                kF956                                                                                            = 0xF956,
                kF957                                                                                            = 0xF957,
                kF958                                                                                            = 0xF958,
                kF959                                                                                            = 0xF959,
                kF95A                                                                                            = 0xF95A,
                kF95B                                                                                            = 0xF95B,
                kF95C                                                                                            = 0xF95C,
                kF95D                                                                                            = 0xF95D,
                kF95E                                                                                            = 0xF95E,
                kF95F                                                                                            = 0xF95F,
                kF960                                                                                            = 0xF960,
                kF961                                                                                            = 0xF961,
                kF962                                                                                            = 0xF962,
                kF963                                                                                            = 0xF963,
                kF964                                                                                            = 0xF964,
                kF965                                                                                            = 0xF965,
                kF966                                                                                            = 0xF966,
                kF967                                                                                            = 0xF967,
                kF968                                                                                            = 0xF968,
                kF969                                                                                            = 0xF969,
                kF96A                                                                                            = 0xF96A,
                kF96B                                                                                            = 0xF96B,
                kF96C                                                                                            = 0xF96C,
                kF96D                                                                                            = 0xF96D,
                kF96E                                                                                            = 0xF96E,
                kF96F                                                                                            = 0xF96F,
                kF970                                                                                            = 0xF970,
                kF971                                                                                            = 0xF971,
                kF972                                                                                            = 0xF972,
                kF973                                                                                            = 0xF973,
                kF974                                                                                            = 0xF974,
                kF975                                                                                            = 0xF975,
                kF976                                                                                            = 0xF976,
                kF977                                                                                            = 0xF977,
                kF978                                                                                            = 0xF978,
                kF979                                                                                            = 0xF979,
                kF97A                                                                                            = 0xF97A,
                kF97B                                                                                            = 0xF97B,
                kF97C                                                                                            = 0xF97C,
                kF97D                                                                                            = 0xF97D,
                kF97E                                                                                            = 0xF97E,
                kF97F                                                                                            = 0xF97F,
                kF980                                                                                            = 0xF980,
                kF981                                                                                            = 0xF981,
                kF982                                                                                            = 0xF982,
                kF983                                                                                            = 0xF983,
                kF984                                                                                            = 0xF984,
                kF985                                                                                            = 0xF985,
                kF986                                                                                            = 0xF986,
                kF987                                                                                            = 0xF987,
                kF988                                                                                            = 0xF988,
                kF989                                                                                            = 0xF989,
                kF98A                                                                                            = 0xF98A,
                kF98B                                                                                            = 0xF98B,
                kF98C                                                                                            = 0xF98C,
                kF98D                                                                                            = 0xF98D,
                kF98E                                                                                            = 0xF98E,
                kF98F                                                                                            = 0xF98F,
                kF990                                                                                            = 0xF990,
                kF991                                                                                            = 0xF991,
                kF992                                                                                            = 0xF992,
                kF993                                                                                            = 0xF993,
                kF994                                                                                            = 0xF994,
                kF995                                                                                            = 0xF995,
                kF996                                                                                            = 0xF996,
                kF997                                                                                            = 0xF997,
                kF998                                                                                            = 0xF998,
                kF999                                                                                            = 0xF999,
                kF99A                                                                                            = 0xF99A,
                kF99B                                                                                            = 0xF99B,
                kF99C                                                                                            = 0xF99C,
                kF99D                                                                                            = 0xF99D,
                kF99E                                                                                            = 0xF99E,
                kF99F                                                                                            = 0xF99F,
                kF9A0                                                                                            = 0xF9A0,
                kF9A1                                                                                            = 0xF9A1,
                kF9A2                                                                                            = 0xF9A2,
                kF9A3                                                                                            = 0xF9A3,
                kF9A4                                                                                            = 0xF9A4,
                kF9A5                                                                                            = 0xF9A5,
                kF9A6                                                                                            = 0xF9A6,
                kF9A7                                                                                            = 0xF9A7,
                kF9A8                                                                                            = 0xF9A8,
                kF9A9                                                                                            = 0xF9A9,
                kF9AA                                                                                            = 0xF9AA,
                kF9AB                                                                                            = 0xF9AB,
                kF9AC                                                                                            = 0xF9AC,
                kF9AD                                                                                            = 0xF9AD,
                kF9AE                                                                                            = 0xF9AE,
                kF9AF                                                                                            = 0xF9AF,
                kF9B0                                                                                            = 0xF9B0,
                kF9B1                                                                                            = 0xF9B1,
                kF9B2                                                                                            = 0xF9B2,
                kF9B3                                                                                            = 0xF9B3,
                kF9B4                                                                                            = 0xF9B4,
                kF9B5                                                                                            = 0xF9B5,
                kF9B6                                                                                            = 0xF9B6,
                kF9B7                                                                                            = 0xF9B7,
                kF9B8                                                                                            = 0xF9B8,
                kF9B9                                                                                            = 0xF9B9,
                kF9BA                                                                                            = 0xF9BA,
                kF9BB                                                                                            = 0xF9BB,
                kF9BC                                                                                            = 0xF9BC,
                kF9BD                                                                                            = 0xF9BD,
                kF9BE                                                                                            = 0xF9BE,
                kF9BF                                                                                            = 0xF9BF,
                kF9C0                                                                                            = 0xF9C0,
                kF9C1                                                                                            = 0xF9C1,
                kF9C2                                                                                            = 0xF9C2,
                kF9C3                                                                                            = 0xF9C3,
                kF9C4                                                                                            = 0xF9C4,
                kF9C5                                                                                            = 0xF9C5,
                kF9C6                                                                                            = 0xF9C6,
                kF9C7                                                                                            = 0xF9C7,
                kF9C8                                                                                            = 0xF9C8,
                kF9C9                                                                                            = 0xF9C9,
                kF9CA                                                                                            = 0xF9CA,
                kF9CB                                                                                            = 0xF9CB,
                kF9CC                                                                                            = 0xF9CC,
                kF9CD                                                                                            = 0xF9CD,
                kF9CE                                                                                            = 0xF9CE,
                kF9CF                                                                                            = 0xF9CF,
                kF9D0                                                                                            = 0xF9D0,
                kF9D1                                                                                            = 0xF9D1,
                kF9D2                                                                                            = 0xF9D2,
                kF9D3                                                                                            = 0xF9D3,
                kF9D4                                                                                            = 0xF9D4,
                kF9D5                                                                                            = 0xF9D5,
                kF9D6                                                                                            = 0xF9D6,
                kF9D7                                                                                            = 0xF9D7,
                kF9D8                                                                                            = 0xF9D8,
                kF9D9                                                                                            = 0xF9D9,
                kF9DA                                                                                            = 0xF9DA,
                kF9DB                                                                                            = 0xF9DB,
                kF9DC                                                                                            = 0xF9DC,
                kF9DD                                                                                            = 0xF9DD,
                kF9DE                                                                                            = 0xF9DE,
                kF9DF                                                                                            = 0xF9DF,
                kF9E0                                                                                            = 0xF9E0,
                kF9E1                                                                                            = 0xF9E1,
                kF9E2                                                                                            = 0xF9E2,
                kF9E3                                                                                            = 0xF9E3,
                kF9E4                                                                                            = 0xF9E4,
                kF9E5                                                                                            = 0xF9E5,
                kF9E6                                                                                            = 0xF9E6,
                kF9E7                                                                                            = 0xF9E7,
                kF9E8                                                                                            = 0xF9E8,
                kF9E9                                                                                            = 0xF9E9,
                kF9EA                                                                                            = 0xF9EA,
                kF9EB                                                                                            = 0xF9EB,
                kF9EC                                                                                            = 0xF9EC,
                kF9ED                                                                                            = 0xF9ED,
                kF9EE                                                                                            = 0xF9EE,
                kF9EF                                                                                            = 0xF9EF,
                kF9F0                                                                                            = 0xF9F0,
                kF9F1                                                                                            = 0xF9F1,
                kF9F2                                                                                            = 0xF9F2,
                kF9F3                                                                                            = 0xF9F3,
                kF9F4                                                                                            = 0xF9F4,
                kF9F5                                                                                            = 0xF9F5,
                kF9F6                                                                                            = 0xF9F6,
                kF9F7                                                                                            = 0xF9F7,
                kF9F8                                                                                            = 0xF9F8,
                kF9F9                                                                                            = 0xF9F9,
                kF9FA                                                                                            = 0xF9FA,
                kF9FB                                                                                            = 0xF9FB,
                kF9FC                                                                                            = 0xF9FC,
                kF9FD                                                                                            = 0xF9FD,
                kF9FE                                                                                            = 0xF9FE,
                kF9FF                                                                                            = 0xF9FF,
                kFA00                                                                                            = 0xFA00,
                kFA01                                                                                            = 0xFA01,
                kFA02                                                                                            = 0xFA02,
                kFA03                                                                                            = 0xFA03,
                kFA04                                                                                            = 0xFA04,
                kFA05                                                                                            = 0xFA05,
                kFA06                                                                                            = 0xFA06,
                kFA07                                                                                            = 0xFA07,
                kFA08                                                                                            = 0xFA08,
                kFA09                                                                                            = 0xFA09,
                kFA0A                                                                                            = 0xFA0A,
                kFA0B                                                                                            = 0xFA0B,
                kFA0C                                                                                            = 0xFA0C,
                kFA0D                                                                                            = 0xFA0D,
                kFA0E                                                                                            = 0xFA0E,
                kFA0F                                                                                            = 0xFA0F,
                kFA10                                                                                            = 0xFA10,
                kFA11                                                                                            = 0xFA11,
                kFA12                                                                                            = 0xFA12,
                kFA13                                                                                            = 0xFA13,
                kFA14                                                                                            = 0xFA14,
                kFA15                                                                                            = 0xFA15,
                kFA16                                                                                            = 0xFA16,
                kFA17                                                                                            = 0xFA17,
                kFA18                                                                                            = 0xFA18,
                kFA19                                                                                            = 0xFA19,
                kFA1A                                                                                            = 0xFA1A,
                kFA1B                                                                                            = 0xFA1B,
                kFA1C                                                                                            = 0xFA1C,
                kFA1D                                                                                            = 0xFA1D,
                kFA1E                                                                                            = 0xFA1E,
                kFA1F                                                                                            = 0xFA1F,
                kFA20                                                                                            = 0xFA20,
                kFA21                                                                                            = 0xFA21,
                kFA22                                                                                            = 0xFA22,
                kFA23                                                                                            = 0xFA23,
                kFA24                                                                                            = 0xFA24,
                kFA25                                                                                            = 0xFA25,
                kFA26                                                                                            = 0xFA26,
                kFA27                                                                                            = 0xFA27,
                kFA28                                                                                            = 0xFA28,
                kFA29                                                                                            = 0xFA29,
                kFA2A                                                                                            = 0xFA2A,
                kFA2B                                                                                            = 0xFA2B,
                kFA2C                                                                                            = 0xFA2C,
                kFA2D                                                                                            = 0xFA2D
        };

private:

};





//=================================================================================
// class UCNSCompatibility
//=================================================================================

class UCNSCompatibility {

public:

        enum ECNSCompatibilityNames {

                kPresentationFormForVerticalTwoDotLeader                         = 0xFE30,
                kPresentationFormForVerticalEmDash                                       = 0xFE31,
                kPresentationFormForVerticalEnDash                                       = 0xFE32,
                kPresentationFormForVerticalLowLine                                      = 0xFE33,
                kPresentationFormForVerticalWavyLowLine                          = 0xFE34,
                kPresentationFormForVerticalLeftParenthesis                         = 0xFE35,
                kPresentationFormForVerticalRightParenthesis                         = 0xFE36,
                kPresentationFormForVerticalLeftCurlyBracket                         = 0xFE37,
                kPresentationFormForVerticalRightCurlyBracket                         = 0xFE38,
                kPresentationFormForVerticalLeftTortoiseShellBracket                         = 0xFE39,
                kPresentationFormForVerticalRightTortoiseShellBracket                         = 0xFE3A,
                kPresentationFormForVerticalLeftBlackLenticularBracket                         = 0xFE3B,
                kPresentationFormForVerticalRightBlackLenticularBracket                         = 0xFE3C,
                kPresentationFormForVerticalLeftDoubleAngleBracket                         = 0xFE3D,
                kPresentationFormForVerticalRightDoubleAngleBracket                         = 0xFE3E,
                kPresentationFormForVerticalLeftAngleBracket                         = 0xFE3F,
                kPresentationFormForVerticalRightAngleBracket                         = 0xFE40,
                kPresentationFormForVerticalLeftCornerBracket                         = 0xFE41,
                kPresentationFormForVerticalRightCornerBracket                         = 0xFE42,
                kPresentationFormForVerticalLeftWhiteCornerBracket                         = 0xFE43,
                kPresentationFormForVerticalRightWhiteCornerBracket                         = 0xFE44,
                kDashedOverline                                                                          = 0xFE49,
                kCentrelineOverline                                                                      = 0xFE4A,
                kWavyOverline                                                                            = 0xFE4B,
                kDoubleWavyOverline                                                                      = 0xFE4C,
                kDashedLowLine                                                                           = 0xFE4D,
                kCentrelineLowLine                                                                       = 0xFE4E,
                kWavyLowLine                                                                             = 0xFE4F,

                //      Values derived from Unicode 1.0 names

                kSpacingDashedOverscore                                                          = kDashedOverline,
                kSpacingCenterlineOverscore                                              = kCentrelineOverline,
                kSpacingWavyOverscore                                                            = kWavyOverline,
                kSpacingDoubleWavyOverscore                                              = kDoubleWavyOverline,
                kSpacingDashedUnderscore                                                         = kDashedLowLine,
                kSpacingCenterlineUnderscore                                             = kCentrelineLowLine,
                kSpacingWavyUnderscore                                                           = kWavyLowLine
        };

private:

};




//=================================================================================
// class UBlocks
//=================================================================================

class UBlocks {

public:

        enum EBlocksNames {

                kUpperHalfBlock                                                                          = 0x2580,
                kLowerOneEighthBlock                                                             = 0x2581,
                kLowerOneQuarterBlock                                                            = 0x2582,
                kLowerThreeEighthsBlock                                                          = 0x2583,
                kLowerHalfBlock                                                                          = 0x2584,
                kLowerFiveEighthsBlock                                                           = 0x2585,
                kLowerThreeQuartersBlock                                                         = 0x2586,
                kLowerSevenEighthsBlock                                                          = 0x2587,
                kFullBlock                                                                                       = 0x2588,
                kLeftSevenEighthsBlock                                                           = 0x2589,
                kLeftThreeQuartersBlock                                                          = 0x258A,
                kLeftFiveEighthsBlock                                                            = 0x258B,
                kLeftHalfBlock                                                                           = 0x258C,
                kLeftThreeEighthsBlock                                                           = 0x258D,
                kLeftOneQuarterBlock                                                             = 0x258E,
                kLeftOneEighthBlock                                                                      = 0x258F,
                kRightHalfBlock                                                                          = 0x2590,
                kLightShade                                                                                      = 0x2591,
                kMediumShade                                                                             = 0x2592,
                kDarkShade                                                                                       = 0x2593,
                kUpperOneEighthBlock                                                             = 0x2594,
                kRightOneEighthBlock                                                             = 0x2595,

                //      Values derived from Unicode 1.0 names

                kLowerThreeQuarterBlock                                                          = kLowerThreeQuartersBlock,
                kLeftThreeQuarterBlock                                                           = kLeftThreeQuartersBlock
        };

private:

};


//=================================================================================
// class UArabicCompatibility
//=================================================================================
class UArabicCompatibility {

public:

        enum EArabicCompatibilityNames {

                kLetterAlefWaslaIsolatedForm                    =       0xFB50,
                kLetterAlefWaslaFinalForm                               =       0xFB51,
                kLetterBeehIsolatedForm                                 =       0xFB52,
                kLetterBeehFinalForm    =       0xFB53,
                kLetterBeehInitialForm  =       0xFB54,
                kLetterBeehMedialForm   =       0xFB55,
                kLetterPehIsolatedForm  =       0xFB56,
                kLetterPehFinalForm     =       0xFB57,
                kLetterPehInitialForm   =       0xFB58,
                kLetterPehMedialForm    =       0xFB59,
                kLetterBehehIsolatedForm        =       0xFB5A,
                kLetterBehehFinalForm   =       0xFB5B,
                kLetterBehehInitialForm =       0xFB5C,
                kLetterBehehMedialForm  =       0xFB5D,
                kLetterTtehehIsolatedForm       =       0xFB5E,
                kLetterTtehehFinalForm  =       0xFB5F,
                kLetterTtehehInitialForm        =       0xFB60,
                kLetterTtehehMedialForm =       0xFB61,
                kLetterTehehIsolatedForm        =       0xFB62,
                kLetterTehehFinalForm   =       0xFB63,
                kLetterTehehInitialForm =       0xFB64,
                kLetterTehehMedialForm  =       0xFB65,
                kLetterTtehIsolatedForm =       0xFB66,
                kLetterTtehFinalForm    =       0xFB67,
                kLetterTtehInitialForm  =       0xFB68,
                kLetterTtehMedialForm   =       0xFB69,
                kLetterVehIsolatedForm  =       0xFB6A,
                kLetterVehFinalForm     =       0xFB6B,
                kLetterVehInitialForm   =       0xFB6C,
                kLetterVehMedialForm    =       0xFB6D,
                kLetterPehehIsolatedForm        =       0xFB6E,
                kLetterPehehFinalForm   =       0xFB6F,
                kLetterPehehInitialForm =       0xFB70,
                kLetterPehehMedialForm  =       0xFB71,
                kLetterDyehIsolatedForm =       0xFB72,
                kLetterDyehFinalForm    =       0xFB73,
                kLetterDyehInitialForm  =       0xFB74,
                kLetterDyehMedialForm   =       0xFB75,
                kLetterNyehIsolatedForm =       0xFB76,
                kLetterNyehFinalForm    =       0xFB77,
                kLetterNyehInitialForm  =       0xFB78,
                kLetterNyehMedialForm   =       0xFB79,
                kLetterTchehIsolatedForm        =       0xFB7A,
                kLetterTchehFinalForm   =       0xFB7B,
                kLetterTchehInitialForm =       0xFB7C,
                kLetterTchehMedialForm  =       0xFB7D,
                kLetterTchehehIsolatedForm      =       0xFB7E,
                kLetterTchehehFinalForm =       0xFB7F,
                kLetterTchehehInitialForm       =       0xFB80,
                kLetterTchehehMedialForm        =       0xFB81,
                kLetterDdahalIsolatedForm       =       0xFB82,
                kLetterDdahalFinalForm  =       0xFB83,
                kLetterDahalIsolatedForm        =       0xFB84,
                kLetterDahalFinalForm   =       0xFB85,
                kLetterDulIsolatedForm  =       0xFB86,
                kLetterDulFinalForm     =       0xFB87,
                kLetterDdalIsolatedForm =       0xFB88,
                kLetterDdalFinalForm    =       0xFB89,
                kLetterJehIsolatedForm  =       0xFB8A,
                kLetterJehFinalForm     =       0xFB8B,
                kLetterRrehIsolatedForm =       0xFB8C,
                kLetterRrehFinalForm    =       0xFB8D,
                kLetterKehehIsolatedForm        =       0xFB8E,
                kLetterKehehFinalForm   =       0xFB8F,
                kLetterKehehInitialForm =       0xFB90,
                kLetterKehehMedialForm  =       0xFB91,
                kLetterGafIsolatedForm  =       0xFB92,
                kLetterGafFinalForm     =       0xFB93,
                kLetterGafInitialForm   =       0xFB94,
                kLetterGafMedialForm    =       0xFB95,
                kLetterGuehIsolatedForm =       0xFB96,
                kLetterGuehFinalForm    =       0xFB97,
                kLetterGuehInitialForm  =       0xFB98,
                kLetterGuehMedialForm   =       0xFB99,
                kLetterNgoehIsolatedForm        =       0xFB9A,
                kLetterNgoehFinalForm   =       0xFB9B,
                kLetterNgoehInitialForm =       0xFB9C,
                kLetterNgoehMedialForm  =       0xFB9D,
                kLetterNoonGhunnaIsolatedForm   =       0xFB9E,
                kLetterNoonGhunnaFinalForm      =       0xFB9F,
                kLetterRnoonIsolatedForm        =       0xFBA0,
                kLetterRnoonFinalForm   =       0xFBA1,
                kLetterRnoonInitialForm =       0xFBA2,
                kLetterRnoonMedialForm  =       0xFBA3,
                kLetterHehWithYehAboveIsolatedForm      =       0xFBA4,
                kLetterHehWithYehAboveFinalForm =       0xFBA5,
                kLetterHehGoalIsolatedForm      =       0xFBA6,
                kLetterHehGoalFinalForm =       0xFBA7,
                kLetterHehGoalInitialForm       =       0xFBA8,
                kLetterHehGoalMedialForm        =       0xFBA9,
                kLetterHehDoachashmeeIsolatedForm       =       0xFBAA,
                kLetterHehDoachashmeeFinalForm  =       0xFBAB,
                kLetterHehDoachashmeeInitialForm        =       0xFBAC,
                kLetterHehDoachashmeeMedialForm =       0xFBAD,
                kLetterYehBarreeIsolatedForm    =       0xFBAE,
                kLetterYehBarreeFinalForm       =       0xFBAF,
                kLetterYehBarreeWithHamzaAboveIsolatedForm      =       0xFBB0,
                kLetterYehBarreeWithHamzaAboveFinalForm =       0xFBB1,
                kLetterNgIsolatedForm   =       0xFBD3,
                kLetterNgFinalForm      =       0xFBD4,
                kLetterNgInitialForm    =       0xFBD5,
                kLetterNgMedialForm     =       0xFBD6,
                kLetterUIsolatedForm    =       0xFBD7,
                kLetterUFinalForm       =       0xFBD8,
                kLetterOeIsolatedForm   =       0xFBD9,
                kLetterOeFinalForm      =       0xFBDA,
                kLetterYuIsolatedForm   =       0xFBDB,
                kLetterYuFinalForm      =       0xFBDC,
                kLetterUWithHamzaAboveIsolatedForm      =       0xFBDD,
                kLetterVeIsolatedForm   =       0xFBDE,
                kLetterVeFinalForm      =       0xFBDF,
                kLetterKirghizOeIsolatedForm    =       0xFBE0,
                kLetterKirghizOeFinalForm       =       0xFBE1,
                kLetterKirghizYuIsolatedForm    =       0xFBE2,
                kLetterKirghizYuFinalForm       =       0xFBE3,
                kLetterEIsolatedForm    =       0xFBE4,
                kLetterEFinalForm       =       0xFBE5,
                kLetterEInitialForm     =       0xFBE6,
                kLetterEMedialForm      =       0xFBE7,
                kLetterUighurKazakhKirghizAlefMaksuraInitialForm        =       0xFBE8,
                kLetterUighurKazakhKirghizAlefMaksuraMedialForm         =       0xFBE9,
                kLetterFarsiYehIsolatedForm     =       0xFBFC,
                kLetterFarsiYehFinalForm        =       0xFBFD,
                kLetterFarsiYehInitialForm      =       0xFBFE,
                kLetterFarsiYehMedialForm       =       0xFBFF,
                kFathatanIsolatedForm           =       0xFE70,
                kTatweelWithFathatanAbove       =       0xFE71,
                kDammatanIsolatedForm           =       0xFE72,
                kKasratanIsolatedForm           =       0xFE74,
                kFathaIsolatedForm                      =       0xFE76,
                kFathaMedialForm                        =       0xFE77,
                kDammaIsolatedForm                      =       0xFE78,
                kDammaMedialForm                        =       0xFE79,
                kKasraIsolatedForm                      =       0xFE7A,
                kKasraMedialForm                        =       0xFE7B,
                kShaddaIsolatedForm                     =       0xFE7C,
                kShaddaMedialForm                       =       0xFE7D,
                kSukunIsolatedForm                      =       0xFE7E,
                kSukunMedialForm                        =       0xFE7F,
                kLetterHamzaIsolatedForm                                =       0xFE80,
                kLetterAlefWithMaddaAboveIsolatedForm   =       0xFE81,
                kLetterAlefWithMaddaAboveFinalForm              =       0xFE82,
                kLetterAlefWithHamzaAboveIsolatedForm   =       0xFE83,
                kLetterAlefWithHamzaAboveFinalForm              =       0xFE84,
                kLetterWawWithHamzaAboveIsolatedForm    =       0xFE85,
                kLetterWawWithHamzaAboveFinalForm               =       0xFE86,
                kLetterAlefWithHamzaBelowIsolatedForm   =       0xFE87,
                kLetterAlefWithHamzaBelowFinalForm              =       0xFE88,
                kLetterYehWithHamzaAboveIsolatedForm    =       0xFE89,
                kLetterYehWithHamzaAboveFinalForm               =       0xFE8A,
                kLetterYehWithHamzaAboveInitialForm             =       0xFE8B,
                kLetterYehWithHamzaAboveMedialForm              =       0xFE8C,
                kLetterAlefIsolatedForm                 =       0xFE8D,
                kLetterAlefFinalForm                    =       0xFE8E,
                kLetterBehIsolatedForm                  =       0xFE8F,
                kLetterBehFinalForm                             =       0xFE90,
                kLetterBehInitialForm                   =       0xFE91,
                kLetterBehMedialForm                    =       0xFE92,
                kLetterTehMarbutaIsolatedForm   =       0xFE93,
                kLetterTehMarbutaFinalForm              =       0xFE94,
                kLetterTehIsolatedForm                  =       0xFE95,
                kLetterTehFinalForm                             =       0xFE96,
                kLetterTehInitialForm                   =       0xFE97,
                kLetterTehMedialForm                    =       0xFE98,
                kLetterThehIsolatedForm                 =       0xFE99,
                kLetterThehFinalForm                    =       0xFE9A,
                kLetterThehInitialForm                  =       0xFE9B,
                kLetterThehMedialForm                   =       0xFE9C,
                kLetterJeemIsolatedForm                 =       0xFE9D,
                kLetterJeemFinalForm                    =       0xFE9E,
                kLetterJeemInitialForm                  =       0xFE9F,
                kLetterJeemMedialForm                   =       0xFEA0,
                kLetterHahIsolatedForm                  =       0xFEA1,
                kLetterHahFinalForm                             =       0xFEA2,
                kLetterHahInitialForm                   =       0xFEA3,
                kLetterHahMedialForm                    =       0xFEA4,
                kLetterKhahIsolatedForm                 =       0xFEA5,
                kLetterKhahFinalForm                    =       0xFEA6,
                kLetterKhahInitialForm                  =       0xFEA7,
                kLetterKhahMedialForm                   =       0xFEA8,
                kLetterDalIsolatedForm                  =       0xFEA9,
                kLetterDalFinalForm                             =       0xFEAA,
                kLetterThalIsolatedForm                 =       0xFEAB,
                kLetterThalFinalForm                    =       0xFEAC,
                kLetterRehIsolatedForm                  =       0xFEAD,
                kLetterRehFinalForm                             =       0xFEAE,
                kLetterZainIsolatedForm                 =       0xFEAF,
                kLetterZainFinalForm                    =       0xFEB0,
                kLetterSeenIsolatedForm                 =       0xFEB1,
                kLetterSeenFinalForm                    =       0xFEB2,
                kLetterSeenInitialForm                  =       0xFEB3,
                kLetterSeenMedialForm                   =       0xFEB4,
                kLetterSheenIsolatedForm                =       0xFEB5,
                kLetterSheenFinalForm                   =       0xFEB6,
                kLetterSheenInitialForm                 =       0xFEB7,
                kLetterSheenMedialForm                  =       0xFEB8,
                kLetterSadIsolatedForm                  =       0xFEB9,
                kLetterSadFinalForm                             =       0xFEBA,
                kLetterSadInitialForm                   =       0xFEBB,
                kLetterSadMedialForm                    =       0xFEBC,
                kLetterDadIsolatedForm                  =       0xFEBD,
                kLetterDadFinalForm                             =       0xFEBE,
                kLetterDadInitialForm                   =       0xFEBF,
                kLetterDadMedialForm                    =       0xFEC0,
                kLetterTahIsolatedForm                  =       0xFEC1,
                kLetterTahFinalForm                             =       0xFEC2,
                kLetterTahInitialForm                   =       0xFEC3,
                kLetterTahMedialForm                    =       0xFEC4,
                kLetterZahIsolatedForm                  =       0xFEC5,
                kLetterZahFinalForm                             =       0xFEC6,
                kLetterZahInitialForm                   =       0xFEC7,
                kLetterZahMedialForm                    =       0xFEC8,
                kLetterAinIsolatedForm                  =       0xFEC9,
                kLetterAinFinalForm                             =       0xFECA,
                kLetterAinInitialForm                   =       0xFECB,
                kLetterAinMedialForm                    =       0xFECC,
                kLetterGhainIsolatedForm                =       0xFECD,
                kLetterGhainFinalForm                   =       0xFECE,
                kLetterGhainInitialForm                 =       0xFECF,
                kLetterGhainMedialForm                  =       0xFED0,
                kLetterFehIsolatedForm                  =       0xFED1,
                kLetterFehFinalForm                             =       0xFED2,
                kLetterFehInitialForm                   =       0xFED3,
                kLetterFehMedialForm                    =       0xFED4,
                kLetterQafIsolatedForm                  =       0xFED5,
                kLetterQafFinalForm                             =       0xFED6,
                kLetterQafInitialForm                   =       0xFED7,
                kLetterQafMedialForm                    =       0xFED8,
                kLetterKafIsolatedForm                  =       0xFED9,
                kLetterKafFinalForm                             =       0xFEDA,
                kLetterKafInitialForm                   =       0xFEDB,
                kLetterKafMedialForm                    =       0xFEDC,
                kLetterLamIsolatedForm                  =       0xFEDD,
                kLetterLamFinalForm                             =       0xFEDE,
                kLetterLamInitialForm                   =       0xFEDF,
                kLetterLamMedialForm                    =       0xFEE0,
                kLetterMeemIsolatedForm                 =       0xFEE1,
                kLetterMeemFinalForm                    =       0xFEE2,
                kLetterMeemInitialForm                  =       0xFEE3,
                kLetterMeemMedialForm                   =       0xFEE4,
                kLetterNoonIsolatedForm                 =       0xFEE5,
                kLetterNoonFinalForm                    =       0xFEE6,
                kLetterNoonInitialForm                  =       0xFEE7,
                kLetterNoonMedialForm                   =       0xFEE8,
                kLetterHehIsolatedForm                  =       0xFEE9,
                kLetterHehFinalForm                             =       0xFEEA,
                kLetterHehInitialForm                   =       0xFEEB,
                kLetterHehMedialForm                    =       0xFEEC,
                kLetterWawIsolatedForm                  =       0xFEED,
                kLetterWawFinalForm                             =       0xFEEE,
                kLetterAlefMaksuraIsolatedForm  =       0xFEEF,
                kLetterAlefMaksuraFinalForm             =       0xFEF0,
                kLetterYehIsolatedForm                  =       0xFEF1,
                kLetterYehFinalForm                             =       0xFEF2,
                kLetterYehInitialForm                   =       0xFEF3,
                kLetterYehMedialForm                    =       0xFEF4

        };

private:

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IUCMPBTY_
