// ----------------------------------------------------------------------------
//  FILE: ityperep.hpp
//
//  This file defines the ITypeRepresentation class.
//
//  COPYRIGHT:
//   IBM Open Class Library                                                              *
//   (C) Copyright International Business Machines Corporation,  1997                    *
//   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
//
// Revision: 89 1.18.1.4 source/core/streams/ityperep.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _ITYPEREP_
#define _ITYPEREP_

#include <iprimtyp.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class IMStreamable;
class IStreamModule;
class IStreamableFactory;
class ITypeName;

#pragma pack(push,4)
#pragma enum(4)

class ITypeRepresentation
{
public:
    bool operator==(const ITypeRepresentation& other);
    bool operator!=(const ITypeRepresentation& other);

private:
    ITypeRepresentation();
    ITypeRepresentation(const ITypeRepresentation& other);
    ITypeRepresentation& operator=(const ITypeRepresentation& other);
    virtual ~ITypeRepresentation();

    friend class ITypeName;
    const ITypeName& typeName() const;

    friend class IStreamFinder;
    static const ITypeRepresentation* findTypeWithName(const ITypeName& typeName);

    friend class IStreamModule;
    const ITypeRepresentation*  nextTypeInModule() const;
    void setNext(const ITypeRepresentation* typeRep);
    const char* name() const;

    friend class IStreamableFactory;
    friend class IStreamableGlobalTemplateHelper;
    ITypeRepresentation(IStreamableFactory* streamableFactory);
    const IStreamableFactory& streamableFactory() const;

    //
    // this is a reserved call to force deferred allocation.
    //
    friend class IStreamTestHelper;
    void makeConst() const;

private:
    IStreamableFactory* fFactory;
    const ITypeRepresentation* fNextTypeRep;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
