// Revision: 68 1.15.1.4 source/core/text/itext/itxtstyl.hpp, text, ioc.v400, 980918 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
//      ITxtStyl.hpp    (ITextStyle.h)
//
//  Contains abstract base classes for the IText style classes.
//              ITextStyle              - Base class for all text styles
//      ICharacterStyle - Base class for all character-based text styles
//              IParagraphStyle - Base class for all paragraph-based text styles
//
//              IBM Open Class Library
//              (C) Copyright International Business Machines Corporation 1997
//              Licensed Material - Program-Property of IBM - All Rights Reserved.
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef _ITXTSTYL_
#define _ITXTSTYL_

#include <iprimtyp.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ITextStyleSet;

#pragma enum(4)
#pragma pack(push,4)

//========================================================================================
// CLASS ITextStyle
//      Class defining the protocol shared by all text-style classes.
//========================================================================================
class ITextStyle {
        public:
                enum EStylePropagation {
                        kPropagateByCharacter,
                        kPropagateByParagraph,

                        kMaximumPropagation = 127
                };

                virtual                                         ~ITextStyle();

                virtual EStylePropagation       propagates() const = 0;

        protected:
                                                                        ITextStyle();
                                                                        ITextStyle( const ITextStyle& );

                ITextStyle&                                     operator=( const ITextStyle& );

                virtual void                            addToSet(ITextStyleSet& set) const = 0;
                virtual void                            removeFromSet(ITextStyleSet&    set) const = 0;
                virtual void                            getValueFromSet(const ITextStyleSet&    set) = 0;
                virtual bool                            isContainedInSet(const ITextStyleSet&   set) const = 0;
                virtual bool                            isValueContainedInSet(const ITextStyleSet&      set) const = 0;

        private:
                friend class ITextStyleSet;
};

//========================================================================================
// CLASS ICharacterStyle
// Abstract base class for all character-based styles.
//========================================================================================
class ICharacterStyle : public ITextStyle {
        public:
                virtual                                         ~ICharacterStyle();

                virtual ITextStyle::EStylePropagation
                                                                        propagates() const;

        protected:
                                                                        ICharacterStyle();
                                                                        ICharacterStyle( const ICharacterStyle& );

                ICharacterStyle&                        operator=( const ICharacterStyle& );
};

//========================================================================================
// CLASS IParagraphStyle
// Abstract base class for all paragraph-based styles (i.e., those that can only apply to whole paragraphs).
//========================================================================================
class IParagraphStyle : public ITextStyle {
        public:
                virtual                                         ~IParagraphStyle();

                virtual ITextStyle::EStylePropagation
                                                                        propagates() const;

        protected:
                                                                        IParagraphStyle();
                                                                        IParagraphStyle( const IParagraphStyle& );

                IParagraphStyle&                        operator=( const IParagraphStyle& );
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ITXTSTYL_
