// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 18 1.9.1.3 source/core/text/itext/itxtplmt.hpp, text, ioc.v400, 980918  
#ifndef _ITXTPLMT_
#define _ITXTPLMT_

//#include "igbase2d.hpp"
//#include "itxtstyl.hpp"
#include "itxtiter.hpp"
//#include "igrtypes.hpp"
//#include "igrport.hpp"

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

//========================================================================================
// CLASS ITextPlacement
// A class representing an insertion-point position.
//========================================================================================
class ITextPlacement {
public:
	enum ECharPlacement { BEFORE_OFFSET, AFTER_OFFSET };

					ITextPlacement(const ITextIterator& pos);
					ITextPlacement(const ITextIterator& pos, ITextPlacement::ECharPlacement placement);
					ITextPlacement(const ITextPlacement& source);
					~ITextPlacement();

	ITextPlacement&	operator=(const ITextPlacement& source);

	bool			operator==(const ITextPlacement& other) const;
	bool			operator!=(const ITextPlacement& other) const;

	bool			operator<(const ITextPlacement& other) const;
	bool			operator<=(const ITextPlacement& other) const;
	bool			operator>(const ITextPlacement& other) const;
	bool			operator>=(const ITextPlacement& other) const;

	ITextPlacement&	operator++();
	ITextPlacement& operator++(int);
	ITextPlacement&	operator--();
	ITextPlacement& operator--(int);

	ITextIterator fPos;
	ECharPlacement fPlacement;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ITXTPLMT_
