//==============================================================================
// itxtbdry.hpp
//
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation 1997
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//==============================================================================

#ifndef _ITXTBDRY_
#define _ITXTBDRY_

#include <itext.hpp>
#include <ilocale.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

//==============================================================================
// CLASS ITextBoundary
// Implements methods for finding the locations of boundaries in text.
// It provides protocol for finding character boundaries, word boundaries,
// sentence boundaries, and possible line-wrapping locations.
//==============================================================================
class ITextBoundary {
public:
    virtual ~ITextBoundary();

     virtual ITextBoundary* clone() const = 0;

    typedef IText::offset_type offset_type;

    virtual IText text() const = 0;
    virtual void  setText(const IText&) = 0;

    static  offset_type _IMPORT kDone;

    virtual offset_type first() = 0;
    virtual offset_type last() = 0;
    virtual offset_type previous() = 0;
    virtual offset_type next() = 0;
    virtual offset_type current() const = 0;

    virtual offset_type nextAfter(offset_type offset) = 0;

    virtual offset_type nthFromCurrent(int n) = 0;

    virtual bool operator==(const ITextBoundary&) const = 0;
            bool operator!=(const ITextBoundary& rhs) const { return !operator==(rhs); }

    static ITextBoundary* createCharacterBreak(const ILocaleKey& locale = ILocaleKey::defaultLocale());
    static ITextBoundary* createWordBreak(const ILocaleKey& locale = ILocaleKey::defaultLocale());
    static ITextBoundary* createLineBreak(const ILocaleKey& locale = ILocaleKey::defaultLocale());
    static ITextBoundary* createSentenceBreak(const ILocaleKey& locale = ILocaleKey::defaultLocale());

    static IText getDisplayName(const ILocaleKey& objectLocale = ILocaleKey::defaultLocale(),
                                const ILocaleKey& displayLocale = ILocaleKey::defaultLocale());

protected:
    ITextBoundary() {}

private:
    ITextBoundary(const ITextBoundary&) {} // do not call
    ITextBoundary& operator=(const ITextBoundary&) { return *this; } // do not call
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ITXTBDRY_
