#ifndef _ITRNSFRM_
#define _ITRNSFRM_
/*******************************************************************************
* FILE NAME: itrnsfrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITransformMatrix                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
// Revision: 72 1.3 source/ographic/itrnsfrm.hpp, graphics, ocdev

#include <ibase.hpp>

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN

#include <ipoint.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ITransformData;
struct _MATRIXLF;
struct tagXFORM;

#pragma enum(4)
#pragma pack(push, 4)

class ITransformMatrix : public IBase {
typedef IBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  ITransformMatrix  ( );

  ITransformMatrix  ( double                  element11,
                      double                  element12,
                      double                  element21,
                      double                  element22,
                      long                    element31,
                      long                    element32       );

#ifdef IC_PM
  ITransformMatrix  ( const struct _MATRIXLF& matrixlf        );
#endif
#ifdef IC_WIN
  ITransformMatrix  ( const struct tagXFORM&  tagxform        );
#endif

  ITransformMatrix  ( const ITransformMatrix& transformMatrix );

ITransformMatrix
  &operator=        ( const ITransformMatrix& matrix          );

  ~ITransformMatrix ( );

/*----------------------------- Matrix Elements ------------------------------*/
ITransformMatrix
  &setElement11        ( double value ),
  &setElement12        ( double value ),
  &setElement21        ( double value ),
  &setElement22        ( double value ),
  &setElement31        ( long   value ),
  &setElement32        ( long   value );

double
  element11            ( ) const,
  element12            ( ) const,
  element21            ( ) const,
  element22            ( ) const;
long
  element31            ( ) const,
  element32            ( ) const;

ITransformMatrix
  &setToIdentity ( );

#ifdef IC_PM
struct _MATRIXLF
  asMATRIXLF     ( ) const;
#endif

#ifdef IC_WIN
struct tagXFORM
  asTagXFORM     ( ) const;
#endif

/*--------------------------- Scale/Rotate/Translate -------------------------*/
ITransformMatrix
  &scaleBy      ( double        xScale,
                  double        yScale,
                  const IPoint& point = IPoint(0,0) ),
  &rotateBy     ( double        angle,
                  const IPoint& point = IPoint(0,0) ),
  &translateBy  ( const IPoint& point               );

/*------------------------------ Comparison ----------------------------------*/
bool
  operator== ( const ITransformMatrix& transformMatrix ) const,
  operator!= ( const ITransformMatrix& transformMatrix ) const;

private:
/*-------------------------------- Private -----------------------------------*/
ITransformData
 *fTransformData;

}; // ITransformMatrix

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // IC_PMWIN
#endif // IC_OBSOLETE
#endif // _ITRNSFRM_
