// ----------------------------------------------------------------------------
// FILE NAME: itmstamp.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     ITimeStamp
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 03  1.7.1.5  source/core/base/itmstamp.hpp, appsupport, ioc.v400, 980918  
// ----------------------------------------------------------------------------

#ifndef _ITMSTAMP_
#define _ITMSTAMP_

#include <iostream.h>
#include <iprimtyp.hpp>
#include <ibase.hpp>
#include <idatstrm.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDate;
class ITime;

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB ITimeStamp
{
public:
    // -------------------------- Constructors --------------------------------
    ITimeStamp( double seconds = 0.0);
    ITimeStamp(const IDate& aDate, const ITime& aTime);
    ITimeStamp(const IDate& aDate);
    ITimeStamp(const ITimeStamp& aTimeStamp);

    // ------------------------- Type Conversions -----------------------------
    operator IDate() const;
    operator ITime() const;

    // ---------------------- Current Date and Time ---------------------------
    static ITimeStamp currentTimeStamp();

    // -------------------------- Diagnostics ---------------------------------
    IString asString() const;

    friend ostream& IC_EXPORTB
        operator <<(ostream& aStream, const ITimeStamp& aTimeStamp );

    // ---------------------------- Queries -----------------------------------
    double asSeconds( ) const;

    // -------------------------- Comparisons ---------------------------------
    bool operator == ( const ITimeStamp& aTimeStamp ) const;
    bool operator != ( const ITimeStamp& aTimeStamp ) const;
    bool operator <  ( const ITimeStamp& aTimeStamp ) const;
    bool operator <= ( const ITimeStamp& aTimeStamp ) const;
    bool operator >  ( const ITimeStamp& aTimeStamp ) const;
    bool operator >= ( const ITimeStamp& aTimeStamp ) const;

    // ------------------------- Manipulations --------------------------------
    ITimeStamp operator+(double seconds) const;
    ITimeStamp operator-(double seconds) const;

    ITimeStamp& operator+=(double seconds);
    ITimeStamp& operator-=(double seconds);

    double operator -(const ITimeStamp& aTimeStamp) const;

    // -------------------------- Constants -----------------------------------
    static const double secondsInDay;

    // ------------------------- Streaming ------------------------------------
    void operator>>=(IDataStream& toWhere);
    void operator<<=(IDataStream& fromWhere);

protected:
    // ------------------------- Streaming ------------------------------------
    void writeToStream( IDataStream& toWhere) const;
    void readFromStream(IDataStream& fromWhere);

private:
    // --------------------------- Private ------------------------------------
    double fTime;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <itmstamp.inl>

#endif // _ITMSTAMP_




