// Revision: 90 1.6.1.4 source/ui/basectl/ititle.hpp, staticctls, ioc.v400, 980918 
#ifndef _ITITLE_
  #define _ITITLE_
/*******************************************************************************
* FILE NAME: ititle.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*    Declaration of the class:                                                 *
*      ITitle                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <itextctl.hpp>
#include <ireslib.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IColor;
class ITitleData;

#pragma enum(4)
#pragma pack(push,4)

class ITitle : public ITextControl {
typedef  ITextControl
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  ITitle ( IWindow*           owner,
           const char*        objectName = 0,
           const char*        viewName   = 0,
           unsigned long      viewNumber = 0);

  ITitle ( IWindow*           owner,
           const IResourceId& objectName,
           const IResourceId& viewName   = 0,
           unsigned long      viewNumber = 0);

virtual
  ~ITitle ( );

#ifdef IC_MOTIFWIN
/*--------------------------- Text Processing --------------------------------*/

virtual ITitle
 &setText    ( const char* text ),
 &setText    ( const IResourceId& textResId );

virtual IString
  text       ( ) const;

virtual unsigned long
  textLength ( ) const;
#endif // IC_MOTIFWIN

/*--------------------------- Title Components -------------------------------*/
virtual IString
  objectText ( ) const,
  viewText   ( ) const;

virtual ITitle
 &setObjectText ( const char*       objectName ),
 &setObjectText ( const IResourceId& objectNameResId ),
 &setViewText   ( const char*       viewName ),
 &setViewText   ( const IResourceId& viewNameResId ),
 &setViewNumber ( unsigned long     viewNumber ),
 &setTitleText  ( const char*       objectName,
                  const char*       viewName          = 0,
                  unsigned long     viewNum           = 0 ),
 &setTitleText  ( const IResourceId& objectNameResId,
                  const IResourceId& viewNameResId    = 0,
                  unsigned long     viewNum           = 0 );

virtual unsigned long
  viewNumber() const;

/*--------------------------------- Colors -----------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IColor
  activeColor                 () const,
  inactiveColor               () const,
  activeTextForegroundColor   () const,
  activeTextBackgroundColor   () const,
  inactiveTextForegroundColor () const,
  inactiveTextBackgroundColor () const;

virtual ITitle
  &setActiveTextForegroundColor     (const IColor& color),
  &setActiveTextBackgroundColor     (const IColor& color),
  &setInactiveTextForegroundColor   (const IColor& color),
  &setInactiveTextBackgroundColor   (const IColor& color),
  &resetActiveTextForegroundColor   (),
  &resetActiveTextBackgroundColor   (),
  &resetInactiveTextForegroundColor (),
  &resetInactiveTextBackgroundColor ();
#endif // IC_MOTIFWIN_FLAGNOP

/*----------------------- Notification Event Descriptions --------------------*/
// Attribute Change Notifications
static INotificationId const
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU activeTextForegroundColorId,
  IC_IMPORTU activeTextBackgroundColorId,
  IC_IMPORTU inactiveTextForegroundColorId,
  IC_IMPORTU inactiveTextBackgroundColorId,
#endif
  IC_IMPORTU objectTextId,
  IC_IMPORTU viewTextId,
  IC_IMPORTU viewNumberId;

/*-------------------------- Observer Notification ---------------------------*/
virtual ITitle
  &enableNotification (bool enable = true);


/*-------------------------------- Attributes --------------------------------*/
#ifdef IC_MOTIFWIN
virtual IWindow
 *owner                     ( ) const;

virtual IWindowHandle
  handle                    ( ) const;

virtual bool
  isValid                   ( ) const;
#endif //IC_MOTIFWIN

#ifdef IC_WIN

virtual IRectangle
  nativeRect                ( ) const;

virtual ISize
  parentSize                ( ) const;
#endif

protected:

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITitle       (const ITitle& title );
ITitle
 &operator=    (const ITitle& title );

/*--------------------------------- Private ----------------------------------*/
IWindow
 *pwinClOwner;

ITitleData
 *fTitleData;

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
virtual IColor
  borderColor                 () const;
#endif // IC_OBSOLETE

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* ifndef _ITITLE_ */
