// Revision: 94 1.8.1.7 source/ui/baseapp/itimer.hpp, application, ioc.v400, 980918  
#ifndef _ITIMER_
#define _ITIMER_
/*******************************************************************************
* FILE NAME: itimer.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITimer                                                                   *
*     ITimer::Cursor                                                           *
*     ITimerFn                                                                 *
*     ITimerMemberFn                                                           *
*     ITimerMemberFn0                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <imrefcnt.hpp>
#include <icntptr.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class ITimerData;

#pragma enum(4)
#pragma pack(push,4)

class ITimerFn : public IMRefCounted {
typedef IMRefCounted
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ITimerFn ( );

virtual
 ~ITimerFn ( );

/*----------------------------- Timer Expiration -----------------------------*/
virtual void
  timerExpired ( unsigned long timerId ) = 0;

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITimerFn  ( const ITimerFn& function );
ITimerFn
 &operator= ( const ITimerFn& function );
}; // ITimerFn


template < class T >
class ITimerMemberFn : public ITimerFn {
typedef ITimerFn
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ITimerMemberFn ( T &object,
                   void ( T::*memberFunction )( unsigned long ) );
virtual
 ~ITimerMemberFn ( );

/*----------------------------- Timer Expiration -----------------------------*/
virtual void
  timerExpired ( unsigned long timerId )
  {
    (fObject.*fMemberFunction)( timerId );
  }

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITimerMemberFn ( const ITimerMemberFn<T>& timerFunction );
ITimerMemberFn<T>
 &operator=      ( const ITimerMemberFn<T>& timerFunction );

/*--------------------------------- Private ----------------------------------*/
T
 &fObject;
void (T::
 *fMemberFunction)( unsigned long );
}; // ITimerMemberFn


template < class T >
class ITimerMemberFn0 : public ITimerFn {
typedef ITimerFn
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ITimerMemberFn0 ( T &object,
                    void ( T::*memberFunction )( ) );
virtual
 ~ITimerMemberFn0 ( );

/*----------------------------- Timer Expiration -----------------------------*/
virtual void
  timerExpired ( unsigned long timerId )
  {
    (fObject.*fMemberFunction)();
  }

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITimerMemberFn0 ( const ITimerMemberFn0<T>& timerFunction );
ITimerMemberFn0<T>
 &operator=       ( const ITimerMemberFn0<T>& timerFunction );

/*--------------------------------- Private ----------------------------------*/
T
 &fObject;
void (T::
 *fMemberFunction)();
}; // ITimerMemberFn0


class ITimer {
public:
/*------------------------------- Constructors -------------------------------*/
  ITimer    ( );
  ITimer    ( const ICountedPointerTo< ITimerFn >& timerFunction,
              unsigned long                        timerInterval = 1000 );
  ITimer    ( unsigned long                        timerIdentifier );
  ITimer    ( const ITimer&                        timer );
ITimer
 &operator= ( const ITimer&                        timer );

virtual
 ~ITimer    ( );

/*-------------------------- Starting and Stopping ---------------------------*/
virtual ITimer
 &start     ( const ICountedPointerTo< ITimerFn >& timerFunction ),
 &start     ( const ICountedPointerTo< ITimerFn >& timerFunction,
              unsigned long                        timerInterval );

virtual ITimer
 &stop      ( );

bool
  isStarted ( ) const;

/*---------------------------- Timer Information -----------------------------*/
unsigned long
  id ( ) const;

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

/*--------------------------- Expiration Interval ----------------------------*/
unsigned long
  interval    ( ) const;

virtual ITimer
 &setInterval ( unsigned long interval = 1000 );

class Cursor {
  public:
  /*------------------------------ Constructors ------------------------------*/
    Cursor ( );
  virtual
   ~Cursor ( );

  /*---------------------------- Timer Iteration -----------------------------*/
  virtual bool
    setToFirst ( ),
    setToNext  ( ),
    isValid    ( ) const;
  
  virtual void
    invalidate ( );
  
  private:
  /*-------------------------------- Private ---------------------------------*/
  friend class ITimer;
  unsigned long
    fIndex;
  }; // ITimer::Cursor

/*---------------------------- Retrieving Objects ----------------------------*/
static ITimer
  timerAt ( const Cursor& cursor );

/*-------------------------------- Comparison --------------------------------*/
bool
  operator == ( const ITimer timer );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  fIndex;
ITimerData
 *fTimerData;
}; // ITimer

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <itimer.c>

#endif // _ITIMER_
