// Revision: 89 1.7.1.8 source/ui/baseapp/ithread.hpp, thread, ioc.v400, 980918 
#ifndef _ITHREAD_
#define _ITHREAD_
/*----------------------------------------------------------------------------*/
/* FILE NAME: ithread.hpp                                                     */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes:                                              */
/*     IThread                                                                */
/*     ICurrentThread                                                         */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   (C) Copyright IBM Corporation 1992, 1997                                 */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <ingthrd.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct tib_s;
class ICurrentThread;
class ICurrentThreadData;
class IDialogControls;

class IStartedThread;
class IWindowList;

class IThreadData;
class IThreadStaticDestructor;

#pragma enum(4)
#pragma pack(push,4)


class IThread : public INonGUIThread {
typedef INonGUIThread
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IThread ( );
  IThread ( const IThread&       thread );
  IThread ( const IThreadId&     threadID,
            const IThreadHandle& threadHandle = IThreadHandle() );
  IThread ( IThreadFn*           threadFunction,
            bool                 autoInitGUI = defaultAutoInitGUI() );
  IThread ( OptlinkFnPtr         function,
            void*                functionArgument,
            bool                 autoInitGUI = defaultAutoInitGUI() );
  IThread ( SystemFnPtr          function,
            unsigned long        functionArgument,
            bool                 autoInitGUI = defaultAutoInitGUI() );


virtual
 ~IThread ( );

/*---------------------- Starting and Stopping Threads -----------------------*/
virtual void
  start   ( IThreadFn*                   threadFunction ),
  start   ( IThreadFn*                   threadFunction,
            bool                         autoInitGUI ),
  start   ( OptlinkFnPtr                 function,
            void*                        functionArgument ),
  start   ( OptlinkFnPtr                 function,
            void*                        functionArgument,
            bool                         autoInitGUI ),
  start   ( SystemFnPtr                  function,
            unsigned long                functionArgument ),
  start   ( SystemFnPtr                  function,
            unsigned long                functionArgument,
            bool                         autoInitGUI );

virtual void
  stop    ( );

/*----------------------------- Thread Information ---------------------------*/
static ICurrentThread
 &current     ( );

/*-------------------- Graphical User Interface (GUI) Support ----------------*/
virtual bool
  autoInitGUI           ( ) const;

virtual IThread
 &setAutoInitGUI        ( bool initFlag = true );

static bool
  defaultAutoInitGUI    ( );

static void
  setDefaultAutoInitGUI ( bool initFlag = true );

virtual IThread
 &stopProcessingMsgs    ( );

bool
  isProcessingMsgs      ( ) const;

#ifdef IC_MOTIF
virtual IWindowHandle
  applicationShell      ( ) const;
#endif // IC_MOTIF

/*---------------------------- Message Queue ---------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual long
  queueSize           ( ) const;

virtual IThread
 &setQueueSize        ( long queueSize );

static long
  defaultQueueSize    ( );

static void
  setDefaultQueueSize ( long queueSize );
#endif // not IC_MOTIFWIN_FLAGNOP

IMessageQueueHandle
  messageQueue        ( ),
  messageQueue        ( ) const;

void
  postEvent  ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul ) const;
static void
  postEvent  ( const IThread&          thread,
               unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul );
static void
  postEvents ( unsigned long           eventId,
               const IEventParameter1& parm1 = 0ul,
               const IEventParameter2& parm2 = 0ul );


protected:
/*------------------------------ Implementation ------------------------------*/
virtual IStartedThread
 *startedThread    ( ) const;

static IStartedThread
 *newStartedThread ( );

/*------------------------------- Constructors -------------------------------*/
IThread
 &operator = ( const IThread& thread );

private:
/*--------------------------------- Private ----------------------------------*/
friend class ICurrentThread;
friend class IWindow;
friend class IThreadStaticDestructor;

static bool
  inGUISession   ( );

//IStartedThread
// *thread;

static bool
  dfltAutoInitGUI;

#ifdef   IC_MOTIF
static bool
  initInProgress;
#endif

static long
  dfltQueueSize;

static ICurrentThread
 *pCurrent;

IThreadData
 *fThreadData;

#ifdef IC_POSIX
static pthread_attr_t     *thread_attr_p;
#endif

}; // IThread


class ICurrentThread : public IThread {
typedef IThread
  Inherited;
public:
/*------------------ Graphical User Interface (GUI) Support ------------------*/
virtual void
  initializeGUI    ( long queueSize = 30 ),
#ifndef IC_WIN_FLAGNOP
  terminateGUI     ( ),
#endif
  processMsgs      ( );

virtual bool
  isGUIInitialized ( ) const;

#ifndef IC_WIN_FLAGNOP
virtual IAnchorBlockHandle
  anchorBlock      ( ) const;
#endif

#ifdef IC_MOTIF
void
  setAnchorBlock( const IWindowHandle& appShell,
                  const IAnchorBlockHandle& appContext );
#endif

virtual IMessageQueueHandle
  messageQueue     ( ),
  messageQueue     ( ) const;


/*-------------------------- Current Thread Support --------------------------*/
#ifdef IC_MOTIF
virtual bool
  isTopLevelShell       ( ) const;

virtual void
  setTopLevelShell      ( ) const;

virtual void
  setXerrorCode         ( int errorCode );

virtual int
  XerrorCode            ( ) const;

virtual bool
  isXerrorCodeAvailable ( ) const;
#endif   // IC_MOTIF

#ifndef IC_POSIXWIN_FLAGNOP
virtual unsigned long
  remainingStack        ( ) const;
#endif

virtual ICurrentThread
 &sleep                 ( unsigned long milliseconds );

virtual ICurrentThread
 &waitFor               ( const INonGUIThread& anotherThread,
                          long                 timeout = -1 );

virtual ICurrentThread
 &waitForAllThreads     ( long timeout = -1,
                          bool *timedOut = 0);

virtual IThreadId
  waitForAnyThread      ( long timeout = -1 );

virtual void
  exit                  ( unsigned long returnCode );

/*----------------------- Starting and Stopping Threads ----------------------*/
virtual void
  suspend ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  ICurrentThread ( );

/*------------------------------ Implementation ------------------------------*/
virtual IStartedThread
 *startedThread ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
virtual
 ~ICurrentThread ( );

/*--------------------------------- Private ----------------------------------*/
friend class IThread;
friend class IThreadStaticDestructor;

ICurrentThreadData
 *fCurrentThreadData;

/*----------------------- Obsolete Data and Functions ------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
#ifdef IC_MOTIF
virtual IContextHandle
  appContext       ( ) const;
virtual IWindowHandle
  appShell         ( ) const;
#endif
#endif // IC_OBSOLETE

}; // ICurrentThread

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ithread.inl>

#endif /* _ITHREAD_ */
