// ----------------------------------------------------------------------------
// FILE NAME: ithrdexc.hpp
//
// DESCRIPTION:
//
//  This module implements the exception classes for thread synchronization
//  classes.
//
//      IConditionInvalid
//      IWaitAbandonded
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 52 1.4.1.3 source/core/base/ithrdexc.hpp, oss, ioc.v400, 980918  
// ----------------------------------------------------------------------------

#ifndef _ITHRDEXC_
#define _ITHRDEXC_

#include <iexcbase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push, 4)
#pragma enum(4)

class IConditionInvalid : public IInvalidParameter
{
public:
                        IConditionInvalid(const char* text = 0);

                        IConditionInvalid(const IConditionInvalid& toCopy);
    virtual             ~IConditionInvalid();

    virtual const char* name() const;

private:
    IConditionInvalid& operator=(const IConditionInvalid&);
};

class IWaitAbandoned : public IException
{
public:
                        IWaitAbandoned(const char* text = 0);

                        IWaitAbandoned(const IWaitAbandoned& toCopy);
    virtual             ~IWaitAbandoned();
    
    virtual const char* name() const;

private:
    IWaitAbandoned& operator=(IWaitAbandoned&);
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ITHRDEXC_
