/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*                                                                                       *
*****************************************************************************************
*/
// itfwpl.hpp - Pragma Library definitions for test framework
/****************************************************************************************
*                                                                                       *
* FILENAME:                                                                             *
*                                                                                       *
* DESCRIPTION:                                                                          *
*                                                                                       *
****************************************************************************************/

// Revision: 78 1.8.1.6 source/core/testfw/itfwpl.hpp, testfw, ioc.v400, 980918 

#ifndef _ITFWPL_H
#define _ITFWPL_H

#ifndef _IPRAGLIB_H
#include <ipraglib.h>           // PRAGMA_LIBRARY macro
#endif

#if !defined(__NO_DEFAULT_LIBS__)
    #if !defined(__NO_TESTFW_LIB__)
        #if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
                    #pragma comment(lib, OPENCLASS_LIBRARY_NAME_2(testfw,ok))
            #else                   // VAC
                    #pragma library(OPENCLASS_LIBRARY_NAME_2(testfw,ok))
            #endif
            #if !defined(__IMPORTLIB__)
                #if defined(_MSC_VER)   // MSVC
                    #pragma comment(lib, "kernel32.lib")
                #else                   // VAC
                    #pragma library("kernel32.lib")
                #endif
                #ifndef _IBASEPL_
                    #include <ibasepl.hpp>      // need base library
                #endif //__IMPORTLIB__
            #endif
        #elif defined(__OS2__)
                // OS/2 SWORD needs to be done without the OPENCLASS_LIBRARY_NAME_2 macro because
                // the compiler doesn't support preprocessor token replacement in the pragma
            // library directives.
            #if __IBMCPP__ >= 360
                        #pragma library(OPENCLASS_LIBRARY_NAME_2(testfw,ok))
            #else // do SWORD
                #ifdef __IMPORTLIB__
                                #pragma library("cppoki36.lib")
                #else
                        #pragma library("cppoks36.lib")
                #endif
            #endif
            #if !defined(__IMPORTLIB__)
                #pragma library("os2386.lib")
                #ifndef _IBASEPL_
                    #include <ibasepl.hpp>      // need base library
                #endif //__IMPORTLIB__
            #endif
        #elif defined(_AIX)
            #if defined(__PRAGMA_LIBRARIES_VISIBLE__)
                    #pragma library(OPENCLASS_LIBRARY_NAME_2(testfw,ok))
                // If we are building static, AIX cmake needs to see these in order to
                // put library references in the makefile.
                #if !defined(__IMPORTLIB__)
                    #pragma library("libhm_r.a")
                    #pragma library("libhu_r.a")
                    #pragma library("libC_r.a")
                    #pragma library("libC.a")
                    #pragma library("libc_r.a")
                    #pragma library("libc.a")
                    #pragma library("libXt.a")
                    #ifndef _IBASEPL_
                        #include <ibasepl.hpp>      // need base library
                    #endif //__IMPORTLIB__
                #endif // __IMPORTLIB__
            #endif // __PRAGMA_LIBRARIES_VISIBLE__
        #endif // platform
    #else
        // This will be seen in the context of building the library only.
        #if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
                #pragma comment(lib, "kernel32.lib")
            #else                   // VAC
                #pragma library("kernel32.lib")
            #endif
        #elif defined(__OS2__)
            #pragma library("os2386.lib")
        #elif defined(_AIX)
            #if defined(__PRAGMA_LIBRARIES_VISIBLE__)
                // AIX doesn't support pragma library statments, but
                // include system libraries needed so cmake can find them.
                #pragma library("libhm_r.a")
                #pragma library("libhu_r.a")
                #pragma library("libC_r.a")
                #pragma library("libC.a")
                #pragma library("libc_r.a")
                #pragma library("libc.a")
                #pragma library("libXt.a")
            #endif // __PRAGMA_LIBRARIES_VISIBLE__
        #endif // _AIX
    #endif // __NO_TESTFW_LIB__
#endif  // __NO_DEFAULT_LIBS__

#endif // _ITFWPL_H


