#ifndef _ITEXTHDR_
  #define _ITEXTHDR_
/*******************************************************************************
* FILE NAME: itexthdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     ITextChangeHandler - Process an event describing a proposed change to    *
*                          the data in an editable text control.               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994, 1995                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <itextevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_MOTIFWIN

class ITextChangeHandler : public IHandler
{
typedef IHandler
  Inherited;
public:
/*-------------------------- Constructors-------------------------------------*/
virtual
 ~ITextChangeHandler ( );

protected:
/*-------------------------- Constructors-------------------------------------*/
  ITextChangeHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  textChange           ( ITextChangeEvent& event ) = 0;

private:

bool
  fResendEvent;
}; // ITextChangeHandler

#endif //IC_MOTIFWIN

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ITEXTHDR_ */
