#ifndef _ITEXTEVT_
  #define _ITEXTEVT_
/*******************************************************************************
* FILE NAME: itextevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     ITextChangeEvent - event allowing approval/modify/disapproval of a       *
*                     proposed change to the data in an editable text control. *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1994, 1995                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or               *
*   disclosure                                                                 *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ictlevt.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_MOTIFWIN

class ITextChangeEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------- Constructor --------------------------------------*/
  ITextChangeEvent ( IEvent& event );
  ITextChangeEvent ( const ITextChangeEvent& event );
virtual
 ~ITextChangeEvent ( );

/*-------------------------------- Accessors ---------------------------------*/

bool
  isChangeAllowed    ( ) const;

unsigned long
  startPosition      ( ) const,
  endPosition        ( ) const;

IString
  proposedText      ( ) const;

ITextChangeEvent
  &setProposedText   ( IString text );

IString
  resultingText     ( ) const;

ITextChangeEvent
  &allowChange        ( bool allow = true ),
  &setStartPosition   ( unsigned long startPos ),
  &setEndPosition     ( unsigned long endPos );

private:
IString*
  verifyText;

#ifdef IC_WIN
bool
  fAllowChange;
unsigned long
  startPos, endPos;
IString
  originalText;
unsigned long
  cursorLinePosition;
#endif
};

#endif //IC_MOTIFWIN

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ITEXTEVT_ */
