// Revision: 88 1.4.1.3 source/ui/basectl/itextctl.hpp, control, ioc.v400, 980918 
#ifndef _ITEXTCTL_
  #define _ITEXTCTL_
/*******************************************************************************
* FILE NAME: itextctl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITextControl                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IResourceId;
class ISize;
class IString;
class ITextControlData;

#pragma enum(4)
#pragma pack(push,4)

class ITextControl : public IControl {
typedef IControl
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~ITextControl           ( );

/*-------------------------------- Accessors ---------------------------------*/
virtual ITextControl
 &setText                ( const char* text ),
 &setText                ( const IResourceId& text );

virtual IString
  text                   ( ) const;

virtual unsigned long
  textLength             ( ) const;

/*--------------------------- Clipboard Operations ---------------------------*/
static bool
  clipboardHasTextFormat ( );

/*----------------------------- Window Painting ------------------------------*/
virtual ISize
  displaySize            ( const char* text = 0 ) const;

/*-------------------------------- Overrides ---------------------------------*/
virtual ITextControl
 &setLayoutDistorted     ( unsigned long layoutAttributeOn,
                           unsigned long layoutAttributeOff );

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU textId;

protected:
  ITextControl           ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITextControl           ( const ITextControl& textControl );
ITextControl
 &operator=              ( const ITextControl& textControl );

/*--------------------------------- Private ----------------------------------*/
friend class ITextControlNotifyHandler;

bool
  fromSetText ( ) const;

ITextControlData
 *fTextControlData;
}; // class ITextControl

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  // _ITEXTCTL_
