// Revision: 49 1.4.1.3 source/ui/extapp/itbarfrm.hpp, toolbar, ioc.v400, 980918 
#ifndef _ITBARFRM_
#define _ITBARFRM_
/*******************************************************************************
* FILE NAME: itbarfrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBarFrameWindow                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IToolBarFrameData;
class IResourceId;
class IString;

#pragma enum(4)
#pragma pack(push,4)

class IToolBarFrameWindow : public IFrameWindow {
typedef IFrameWindow
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IToolBarFrameWindow  ( unsigned long windowId,
                         IFrameWindow* owner    );
virtual
  ~IToolBarFrameWindow ( );

/*---------------------------------- Styles ----------------------------------*/
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*---------------------------- Title Text ------------------------------------*/
virtual IToolBarFrameWindow
  &setTitleText        ( const char* text        ),
  &setTitleText        ( const IResourceId& text );

IString
  titleText            ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
   IToolBarFrameWindow ( const IToolBarFrameWindow& window );
IToolBarFrameWindow
  &operator=           ( const IToolBarFrameWindow& window );

/*--------------------------------- Private ----------------------------------*/
IToolBarFrameData
 *fToolBarFrameData;
}; // IToolBarFrameWindow

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ITBARFRM_ */
