// Revision: 47 1.5.1.3 source/ui/extapp/itbarcnr.hpp, toolbar, ioc.v400, 980918 
#ifndef _ITBARCNR_
#define _ITBARCNR_
/*******************************************************************************
* FILE NAME: itbarcnr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBarContainer                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <isetcv.hpp>
#include <iframe.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IToolBar;
class IToolBarContainerData;

#pragma enum(4)
#pragma pack(push,4)

class IToolBarContainer : public ISetCanvas {
typedef ISetCanvas
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IToolBarContainer ( unsigned long          identifier,
                      IFrameWindow*          parentAndOwner,
                      IFrameWindow::Location location,
                      const Style&           style = defaultStyle() );

virtual
 ~IToolBarContainer ( );

/*---------------------------------- Styles ----------------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
INESTEDBITFLAGCLASSDEF3(Style, IToolBarContainer, ISetCanvas, ICanvas, IWindow);
#else
INESTEDBITFLAGCLASSDEF0( Style, IToolBarContainer );
#endif

static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;

/*------------------------------ Frame Location ------------------------------*/
virtual IToolBarContainer
 &setLocation           ( IFrameWindow::Location location );

IFrameWindow::Location
  location              ( ) const;

static IToolBarContainer
 *frameToolBarContainer ( IFrameWindow*          frame,
                          IFrameWindow::Location frameLocation );

/*------------------------------ Canvas Layout -------------------------------*/
virtual IToolBarContainer
 &setLayoutDistorted ( unsigned long layoutAttributeOn,
                       unsigned long layoutAttributeOff );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IToolBarContainer ( const IToolBarContainer& );
IToolBarContainer
 &operator=         ( const IToolBarContainer& );

/*--------------------------------- Private ----------------------------------*/
friend class IToolBar;

static Style
  fgCurrentDefaultStyle;

IToolBarContainerData
 *fToolBarContainerData;
}; // IToolBarContainer

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
INESTEDBITFLAGCLASSFUNCS(Style, IToolBarContainer);
#endif

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ITBARCNR_ */
