// Revision: 45 1.7.1.5 source/ui/extapp/itbarbut.hpp, toolbar, ioc.v400, 980918 
#ifndef _ITBARBUT_
#define _ITBARBUT_
/*******************************************************************************
* FILE NAME: itbarbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBarButton                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <icustbut.hpp>
#include <irect.hpp>
#include <ipoint.hpp>
#include <icolor.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBitmapHandle;
class IResourceId;
class IToolBarButtonData;

#pragma enum(4)
#pragma pack(push,4)

class IToolBarButton : public ICustomButton {
typedef ICustomButton
  Inherited;
public:
class Style;
/*----------------------------- Constructors ---------------------------------*/
  IToolBarButton  ( unsigned long     id,
                    IWindow*          parent,
                    IWindow*          owner,
                    const IRectangle& initial = IRectangle(),
                    const Style&      style = defaultStyle() );

virtual
  ~IToolBarButton ( );


/*------------------------------- Styles -------------------------------------*/
INESTEDBITFLAGCLASSDEF4(Style, IToolBarButton, IWindow,
                        IControl, IButton, ICustomButton);
                                  // style class definition
static const Style
  IC_IMPORTU bitmapVisible,
  IC_IMPORTU textVisible,
  IC_IMPORTU bitmapAndTextVisible,
  IC_IMPORTU useIdForBitmap,
  IC_IMPORTU useIdForText,
  IC_IMPORTU standardFormat,
  IC_IMPORTU transparentBitmap,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU dragDelete,
#endif
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  IC_IMPORTU noDragDelete,
#endif // IC_OBSOLETE
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------ Bitmaps -------------------------------------*/
virtual IToolBarButton
  &setBitmap        ( const IResourceId&   bitmapId ),
  &setBitmap        ( const IBitmapHandle& handle ),
  &setBitmap        ( unsigned long        id ),
  &setLatchedBitmap ( const IResourceId&   latchedBitmapId ),
  &setLatchedBitmap ( const IBitmapHandle& handle ),
  &setLatchedBitmap ( unsigned long        id );

IBitmapHandle
  bitmap            ( ) const,
  latchedBitmap     ( ) const;

virtual ISize
  bitmapSize        ( ) const;

/*-------------------------------- Views -------------------------------------*/
enum View {
  bitmapView,
  textView,
  bitmapAndTextView
};

virtual IToolBarButton
  &setView        ( View buttonView );

View
  view            ( ) const;

bool
  isBitmapVisible ( ) const,
  isTextVisible   ( ) const;

/*------------------------------ Transparency --------------------------------*/
virtual IToolBarButton
  &setTransparentColor   ( const IColor& color = IColor::kPink ),
  &resetTransparentColor ( );

virtual IColor
  transparentColor       ( ) const;

virtual bool
  hasTransparentColor    ( ) const;

static IColor
  defaultTransparentColor ( );
static void
  setDefaultTransparentColor ( const IColor& aColor = IColor(IColor::kPink) );
static void
  clearDefaultTransparentColor ( );
static bool
  isDefaultTransparentColorSet ( );

/*-------------------------- Canvas Support ----------------------------------*/
virtual IToolBarButton
  &setLayoutDistorted ( unsigned long layoutAttributeOn,
                        unsigned long layoutAttributeOff );

/*-------------------------- Standard Format ---------------------------------*/
static unsigned long
  standardTextWidth     ( ),
  standardTextLines     ( );

static ISize
  standardBitmapSize    ( );

static void
  setStandardTextWidth  ( unsigned long newWidth = 50 ),
  setStandardTextLines  ( unsigned long newLines = 1 ),
  setStandardBitmapSize ( const ISize&  newSize  = ISize(22,22) );

bool
  isStandardFormat      ( ) const;

/*------------------------------- Shredder Support ---------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IToolBarButton
 &enableDragDelete  ( bool enable = true ),
 &disableDragDelete ( );

bool
  allowsDragDelete  ( ) const;
#endif

protected:
/*----------------------------- Canvas Layout --------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
  IToolBarButton            (const IToolBarButton&);
  IToolBarButton& operator= (const IToolBarButton&);
static Style
  fCurrentDefaultStyle;
static unsigned long
  fgStandardWidth,
  fgStandardLines;
static ISize
  fgStandardSize;
IToolBarButtonData
 *fToolBarButtonData;

#ifdef IC_MOTIF
friend void _System iToolBarButtonMotifCallback ( _WidgetRec *w,
                                                  void       *client_data,
                                                  void       *call_data );
#endif //IC_MOTIF
};

INESTEDBITFLAGCLASSFUNCS(Style, IToolBarButton);

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ITBARBUT_ */
