// Revision: 87 1.4 source/ui/basectl/itabpage.hpp, notebook, ioc.v400, 980918  
#ifndef _ITABPAGE_
#define _ITABPAGE_
/*******************************************************************************
* FILE NAME: itabpage.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITabPage                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp.  1997  All Rights Reserved.                        *
*                                                                              *
*******************************************************************************/
#include <icolor.hpp>
#include <ihandle.hpp>
#include <itabctl.hpp>
#include <itext.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPushButton;
class IResourceId;
class ITabPageData;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class ITabPage {
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  ITabPage  ( const Style&               style = defaultStyle() );
  ITabPage  ( const IText&               tabText,
              const Style&               style = defaultStyle() );
  ITabPage  ( const IBitmapHandle&       tabBitmap,
              const Style&               style = defaultStyle() );
  ITabPage  ( const IText&               tabText,
              const IBitmapHandle&       tabBitmap,
              const Style&               style = defaultStyle() );

virtual
  ~ITabPage ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, ITabPage);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU autoPageSize,
  IC_IMPORTU noStyle;

static Style
  defaultStyle       ( );

static void
  setDefaultStyle    ( const Style&    style );

virtual unsigned long
  convertToGUIStyle  ( const IBitFlag& style,
                      bool  extendedOnly = false ) const;

/*------------------------- Tab Control Association --------------------------*/
virtual ITabControl
 *tabControl         ( ) const;

/*------------------------- Page Window Association --------------------------*/
virtual IWindow
 *pageWindow         ( ) const;

virtual ITabPage
 &setPageWindow      ( IWindow*     pageWindow );

/*------------------------------ Button Support ------------------------------*/
ITabPage
 &addPageButton      ( IPushButton*         button ),
 &addPageButton      ( ITabControl::EButton buttonType,
                       bool                 isDefaultButton = false ),
 &removePageButton   ( IPushButton*         button ),
 &removePageButton   ( ITabControl::EButton buttonType );

/*---------------------------- Tab Text & Bitmap -----------------------------*/
virtual ITabPage
 &setTabText         ( const IText&         tabText ),
 &setTabText         ( const IResourceId&   resourceId ),
 &setTabBitmap       ( const IBitmapHandle& bitmap ),
 &setTabBitmap       ( const IResourceId&   resourceId );

virtual IText
  tabText            ( ) const;

virtual IBitmapHandle
  tabBitmap          ( ) const;

/*------------------------------- Help Support -------------------------------*/
virtual ITabPage
 &setHelpId          ( unsigned long helpId );

virtual unsigned long
  helpId             ( ) const;

/*---------------------------------- Colors ----------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  tabBackgroundColor      ( ) const;

virtual ITabPage
 &setTabBackgroundColor   ( const IColor& color );

virtual ITabPage
 &resetTabBackgroundColor ( );
#endif

/*---------------------------- Automatic Sizing ------------------------------*/
bool
  isAutoPageSize     ( ) const;

/*-------------------------- Page Window Validation --------------------------*/
virtual bool
  validatePageWindow ( );

/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  minimumPageWindowSize ( ) const;

protected:
/*------------------------- Page Window Association --------------------------*/
virtual IWindow
  *createPageWindow  ( );

/*-------------------------- Page Window Selection ---------------------------*/
virtual void
  updatePageWindow   ( );

private:
/*----------------------------- Hidden Members -------------------------------*/
ITabPage    ( const ITabPage& tabPage );
ITabPage
 &operator= ( const ITabPage& tabPage );

ITabPageData
 *fTabPageData;

static Style
  fCurrentDefaultStyle;

friend class ITabControl;
friend class ITabControlData;
friend class ITabControlDefaultHandler;
friend class ITabPageResizeHandler;
}; // ITabPage

#endif // IC_PMWIN

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <itabpage.inl>

#endif /* _ITABPAGE_ */

