// Revision: 67 1.10 source/ui/basectl/itabctl.hpp, notebook, ioc.v400, 980918  
#ifndef _ITABCTL_
#define _ITABCTL_
/*******************************************************************************
* FILE NAME: itabctl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITabControl                                                              *
*     ITabControl::Cursor                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp.  1997  All Rights Reserved.                        *
*                                                                              *
*******************************************************************************/
#include <icconst.h>
#include <icolor.hpp>
#include <icontrol.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPushButton;
class ITabControlData;
class ITabControlCursorData;
class ITabPage;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class ITabControl : public IControl {
typedef IControl
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ITabControl ( unsigned long        windowId,
                IWindow*             parent,
                IWindow*             owner,
                const IRectangle&    initial = IRectangle(),
                const Style&         style = defaultStyle() );

  ITabControl ( unsigned long        windowId,
                IWindow*             parent );
  ITabControl ( const IWindowHandle& handle );

virtual
 ~ITabControl ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, ITabControl, IWindow);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU buttons;
#ifndef IC_PM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif
#ifndef IC_WIN_FLAGNOP
static const Style
  IC_IMPORTU tabsTop,
  IC_IMPORTU tabsBottom;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;

/*------------------------------- Tab Position -------------------------------*/
enum ETabPosition {
  kTop,
  kBottom
};

#ifndef IC_WIN_FLAGNOP
virtual ITabControl
 &setTabPosition ( ETabPosition position );
#endif

virtual ETabPosition
  tabPosition    ( ) const;

/*------------------------------ Button Support ------------------------------*/
enum EButton {
  kApply   = IC_ID_APPLY,
  kOk      = IC_ID_OK,
  kCancel  = IC_ID_CANCEL,
  kDefault = IC_ID_RESET,
  kHelp    = IC_ID_HELP
};

virtual IWindow
 *buttonParent       ( ) const;

virtual IPushButton
 *button             ( EButton      buttonType ) const;

virtual ITabControl
 &addCommonButton    ( IPushButton* button ),
 &addCommonButton    ( EButton      buttonType,
                       bool         isDefaultButton = false ),
 &removeCommonButton ( IPushButton* button ),
 &removeCommonButton ( EButton      buttonType );

/*------------------------------ Colors --------------------------------------*/
virtual IColor
  pageBackgroundColor      ( ) const;

virtual ITabControl
 &setPageBackgroundColor   ( const IColor& color );

virtual ITabControl
 &resetPageBackgroundColor ( );


class Cursor {
public :
/*------------------------------- Constructors -------------------------------*/
  Cursor  ( const ITabControl& tabControl );

virtual
  ~Cursor ( );

/*------------------------------ Page Iteration ------------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( ) const;

virtual void
  invalidate    ( );

/*------------------------------- Page Retrieval -----------------------------*/
virtual ITabPage
 *current    ( ) const;

void
  setCurrent  ( const ITabPage* current );

private:
/*----------------------------- Hidden Members -------------------------------*/
Cursor       ( const Cursor& cursor );
Cursor
 &operator=  ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
ITabControlCursorData
 *fCursorData;

ITabControl
 &fTabControl;

ITabPage
 *fCurrentTabPage;

unsigned long
  fReferences;
}; // ITabControl::Cursor

/*------------------------------ Page Addition -------------------------------*/
virtual ITabControl
 &addFirstPage      ( const ITabPage* newPage ),
 &addLastPage       ( const ITabPage* newPage ),
 &addPageBefore     ( const ITabPage* newPage,
                      const ITabPage* referencePage ),
 &addPageAfter      ( const ITabPage* newPage,
                      const ITabPage* referencePage ),
 &addPageBefore     ( const ITabPage* newPage,
                      Cursor&         cursor ),
 &addPageAfter      ( const ITabPage* newPage,
                      Cursor&         cursor );

/*------------------------------- Page Removal -------------------------------*/
virtual ITabControl
 &removePage        ( ITabPage* page ),
 &removePage        ( Cursor&         cursor ),
 &removeAllPages    ( );

/*---------------------------- Page Manipulation -----------------------------*/
virtual ITabControl
 &setTopPage        ( const ITabPage* page ),
 &setTopPage        ( const Cursor&   cursor );

/*------------------------------ Page Retrieval ------------------------------*/
virtual ITabPage
 *topPage           ( ) const,
 *firstPage         ( ) const,
 *lastPage          ( ) const,
 *nextPage          ( const ITabPage*  referencePage ) const,
 *previousPage      ( const ITabPage*  referencePage ) const;

/*---------------------------- Page Count Support ----------------------------*/
virtual unsigned long
  totalPages         ( ) const;

virtual bool
  isEmpty            ( ) const;

/*------------------------------- Page Support -------------------------------*/
virtual ISize
  pageSize           ( ) const;

/*------------------------------ Page Deletion -------------------------------*/
ITabControl
 &setAutoDeletePages ( bool autoDelete = true );

bool
  isAutoDeletePages  ( ) const;


/*------------------------------ Layout Support ------------------------------*/
#ifdef IC_PMWIN
virtual ITabControl
 &setLayoutDistorted  ( unsigned long layoutAttributesOn,
                        unsigned long layoutAttributesOff );
#endif // IC_PMWIN

/*-------------------------- Notification Members ----------------------------*/
static INotificationId const
  IC_IMPORTU pageAddId,
  IC_IMPORTU pageRemoveId,
  IC_IMPORTU buttonAddId,
  IC_IMPORTU buttonRemoveId,
  IC_IMPORTU pageSelectId,
  IC_IMPORTU pageBackgroundColorId,
  IC_IMPORTU tabBackgroundColorId;

virtual IWindow
 &enableNotification ( bool enable=true );

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
ITabControl ( const ITabControl& tabControl );
ITabControl
 &operator= ( const ITabControl& tabControl );

/*--------------------------------- Private ----------------------------------*/

ITabControlData
 *fTabControlData;

static Style
  fCurrentDefaultStyle;

friend class ITabControlData;
friend class ITabControlDefaultHandler;
friend class ITabPage;
friend class ITabPageData;
friend class ITabControl::Cursor;
friend class ITabPageResizeHandler;
}; // ITabControl

INESTEDBITFLAGCLASSFUNCS(Style, ITabControl)

#endif // IC_PMWIN

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <itabpage.hpp>
#include <itabctl.inl>

#endif /* _ITABCTL_ */
