// Revision: 87 1.4.1.4 source/ui/baseapp/isysmenu.hpp, menu, ioc.v400, 980918 
#ifndef _ISYSMENU_
#define _ISYSMENU_
/*******************************************************************************
* FILE NAME: isysmenu.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ISystemMenu                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;
class ISystemMenuData;

#pragma enum(4)
#pragma pack(push,4)

class ISystemMenu : public IMenu {
typedef IMenu
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
  ISystemMenu ( IFrameWindow* owner );
#endif
virtual
 ~ISystemMenu ( );

/*----------------------------- Item Identifiers -----------------------------*/
#ifndef IC_MOTIF_FLAGNOP
static const unsigned long
  IC_IMPORTU idPulldown,
  IC_IMPORTU idRestore,
  IC_IMPORTU idMove,
  IC_IMPORTU idSize,
  IC_IMPORTU idMinimize,
  IC_IMPORTU idMaximize,
  IC_IMPORTU idHide,
  IC_IMPORTU idWindowList;
#endif

static const unsigned long
  IC_IMPORTU idClose;

private:
/*------------------------------ Hidden Members ------------------------------*/
  ISystemMenu ( const ISystemMenu& menu );
ISystemMenu
 &operator=   ( const ISystemMenu& menu );

/*--------------------------------- Private ----------------------------------*/
ISystemMenuData
 *fSystemMenuData;
bool
  fMenuWindowNewdInCtor;
IMenu*
  fMenuFromPriorMenuAttribute;

}; // ISystemMenu

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _ISYSMENU_ */
