










#ifndef _ISYNONYM_
#define _ISYNONYM_
/*----------------------------------------------------------------------------*/
/* FILE NAME: isynonym.hpp                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file declares synonyms for the types and values nested within       */
/*   class IBase (see <ibase.hpp>).  #include-ing this file results in those  */
/*   names being placed in the global name space, permitting consistent usage */
/*   in IBase derived classes and client code.                                */
/*                                                                            */
/*   If these global names conflict with other usage of these names within    */
/*   a client application, then this file should be modified for use in such  */
/*   application.  For example, if you are using another library which        */
/*   utilizes the typedef bool, then change "bool" below to something   */
/*   like "bool." "bool" would then be used throughout your           */
/*   application.                                                             */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#include <ilanglvl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#ifndef _BooleanType
   #define _BooleanType



#if __IBMCPP__ >= 400
typedef bool Boolean;
#else
typedef int Boolean;
#endif  /* __IBMCPP__ >= 400 */



#endif  /* _BooleanType */

#if __IBMCPP__ >= 400
typedef bool IBoolean;
#else
typedef int IBoolean;
#endif  /* __IBMCPP__ >= 400 */

#ifndef _BooleanConst
   #define _BooleanConst



















#if (defined(_IBASE_) || (__IBMCPP__ >= 400))
  // false and true are already defined
  enum {
      False = 0,
      True  = 1
   };
#else
  enum {
      False = 0,
      True  = 1
   };
#endif /* defined(_IBASE_) || (__IBMCPP__ >= 400) */

#endif
#endif /* IC_OBSOLETE <= IC_OBSOLETE_2 */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ISYNONYM_
