// isynchr.hpp
//
// ISynchronized: non-blocking concurrent access to data
//
/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*                                                                                       *
*****************************************************************************************
*/

//
// Revision: 55 1.10.1.5 source/core/utils/isynchr.hpp, utilities, ioc.v400, 980918 
//

#ifndef _ISYNCHR_
#define _ISYNCHR_

#ifndef _IBASEPL_H
#include <ibasepl.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)


template <class AType> class ISynchronized
{
public:
        // Get the value atomically.
        AType   get() const;
                        operator AType() const;

        // If the value is equal to "test", atomically replace it with "newValue"
        // Returns true if the set was NOT successful, false otherwise.
        int             setConditional(AType test, AType newValue);

        // Atomically set the value.
        void    set(AType newValue);

        // This must be public to give C-style initialization
        volatile AType fAtom;
};

// This function will either assign the supplied value to the pointer variable
// represented by var, or delete it. The argument must be able
// to be deleted.
template<class AType> AType *synchronizedInit(ISynchronized<AType *> &var, AType *value);

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <isynchr.inl>

#endif // _ISYNCHR_
