// Revision: 84 1.7.1.3 source/ui/baseapp/iswp.hpp, datatype, ioc.v400, 980918 
#ifndef _ISWP_
#define _ISWP_
/*******************************************************************************
* FILE NAME: iswp.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISWP                                                                     *
*     ISWPArray                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPoint;
class ISize;

#pragma enum(4)
#pragma pack(push,4)

class ISWP  {
public:
/*------------------------------- Constructors -------------------------------*/
  ISWP      ( );
  ISWP      ( const ISWP& original );

 ~ISWP      ( );

ISWP
 &operator= ( const ISWP& original );

/*--------------------------- Window Manipulation ----------------------------*/
IWindowHandle
  windowHandle ( ) const;

IPoint
  position     ( ) const;
ISize
  size         ( ) const;

ISWP
 &setPosition  ( const IPoint& point ),
 &setSize      ( const ISize&  size );

ISWP
 &setMove      ( bool enable = true ),
 &setSizeFlag  ( bool enable = true ),
 &setShow      ( bool enable = true ),
 &setHide      ( bool enable = true ),
 &setZOrder    ( bool enable = true ),
 &setNoAdjust  ( bool enable = true );

unsigned long
 &flags        ( );

/*--------------------------------- Testing ----------------------------------*/
bool
  isMove   ( ) const,
  isSize   ( ) const,
  isShow   ( ) const,
  isHide   ( ) const,
  isZOrder ( ) const;

/*----------------------------------- Data -----------------------------------*/
#ifdef IC_MOTIFPM
unsigned long
  fl;
long
  cy,
  cx,
  y,
  x;
IWindowHandle
  behind,
  hwnd;
unsigned long
  ulReserved1,
  ulReserved2;
#endif //IC_MOTIFPM

#ifdef IC_WIN
IWindowHandle
  hwnd,
  behind;
long
  x,
  y,
  cx,
  cy;
unsigned long
  fl;
#endif //IC_WIN
};  // ISWP

class ISWPArray  {
public:
/*------------------------------- Constructors -------------------------------*/
  ISWPArray ( ISWP*    array,
              unsigned dimension );

/*------------------------------ Array Contents ------------------------------*/
unsigned
  size        ( ) const;

ISWP
 &operator [] ( unsigned index );

unsigned
  indexOf     ( unsigned long windowId ) const;

private:
/*--------------------------------- Private ----------------------------------*/
ISWP
 *p;
unsigned
  dim;
}; // ISWPArray

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iswp.inl>

#endif // _ISWP_
