// Revision: 82 1.5.1.8 source/ui/baseapp/isubmenu.hpp, menu, ioc.v400, 980918 
#ifndef _ISUBMENU_
#define _ISUBMENU_
/*******************************************************************************
* FILE NAME: isubmenu.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ISubmenu                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBitmapHandle;
class IMenuItem;
class IResourceId;
class ISubmenuCursorData;
class ISubmenuData;

#pragma enum(4)
#pragma pack(push,4)

class ISubmenu : public IMenu {
typedef IMenu
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISubmenu ( const IMenuHandle& submenuHandle );

virtual
 ~ISubmenu ( );

/*-------------------------------- Properties --------------------------------*/
virtual IMenuHandle
  handle     ( ) const;
virtual IMenuHandle
  menuHandle ( ) const;

/*------------------------------- Adding Items -------------------------------*/
virtual ISubmenu
 &addItem      ( IMenuItem&           menuItem,
                 unsigned long        intoSubmenuId = 0 ),
 &addText      ( unsigned long        newItemId,
                 const char*          itemText,
                 unsigned long        intoSubmenuId = 0 ),
 &addText      ( unsigned long        newItemId,
                 const IResourceId&   newItemTextResId ,
                 unsigned long        intoSubmenuId = 0 ),
 &addBitmap    ( unsigned long        newItemId,
                 const IBitmapHandle& itemBitmap,
                 unsigned long        intoSubmenuId = 0 ),
 &addBitmap    ( unsigned long        newItemId,
                 const IResourceId&   newItemBitmapResId,
                 unsigned long        intoSubmenuId = 0 ),
 &addBitmap    ( unsigned long        newItemId,
                 unsigned long        newItemBitmapResId,
                 unsigned long        intoSubmenuId = 0 ),
 &addSeparator ( unsigned long        newItemId,
                 unsigned long        intoSubmenuId ),
 &addSeparator ( unsigned long        newItemId = 0 );

/*----------------------------- Replacing Items ------------------------------*/
virtual ISubmenu
 &setItem   ( const IMenuItem&     menuItem ),
 &setText   ( unsigned long        menuItemId,
              const char*          newText ),
 &setText   ( unsigned long        menuItemId,
              const IResourceId&   newTextResId ),
 &setBitmap ( unsigned long        menuItemId,
              const IBitmapHandle& bitmapHandle ),
 &setBitmap ( unsigned long        menuItemId,
              const IResourceId&   newBitmapResId ),
 &setBitmap ( unsigned long        menuItemId,
              unsigned long        newBitmapResId );

/*------------------------------ Removing Items ------------------------------*/
virtual ISubmenu
 &deleteItem    ( unsigned long itemId      ),
 &removeSubmenu ( unsigned long itemWithSubmenuId );

/*-------------------------------- Selection ---------------------------------*/
virtual ISubmenu
 &checkItem    ( unsigned long  itemId,
                 bool        checked  = true ),
 &uncheckItem  ( unsigned long  itemId ),
 &enableItem   ( unsigned long  itemId,
                 bool        enabled  = true ),
 &disableItem  ( unsigned long  itemId );

/*----------------------------------- Undo -----------------------------------*/
virtual ISubmenu
 &undo ( );

class Cursor {
public :
/*---------------------------- Constructors -----------------------------*/
  Cursor ( const ISubmenu& menu);

virtual
 ~Cursor ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( );

/*-------------------------- Cursor Validation --------------------------*/
virtual bool
  isValid    ( ) const;
virtual void
  invalidate ( );

private :
/*--------------------------- Hidden Members ----------------------------*/
  Cursor ( const Cursor& cursor );
void
  skipRemoved (bool skipForward=true);     //27045
/*------------------------------- Private -------------------------------*/
friend class ISubmenu;

long
  lCurrent;
ISubmenu
 *pSubmenu;

ISubmenuCursorData
 *fCursorData;
}; // ISubmenu::Cursor

/*--------------------------- Cursored Operations ----------------------------*/
virtual IMenuItem
  elementAt        ( const Cursor& cursor ) const;

virtual ISubmenu
  &deleteAt        ( Cursor&     cursor   ),
  &removeSubmenuAt ( Cursor&     cursor   ),
  &add             ( IMenuItem&  menuItem,
                     Cursor&     cursor   ),
  &addAsNext       ( IMenuItem&  menuItem,
                     Cursor&     cursor   );
Cursor
  cursor           ( unsigned long itemId ) const;

private:
/*----------------------------- Hidden Functions -----------------------------*/
  ISubmenu         ( const ISubmenu&      submenu );
ISubmenu
 &operator=        ( const ISubmenu&      submenu );
IMenuItem
  elementAt        ( const IMenu::Cursor& cursor ) const;
ISubmenu
  &deleteAt        ( IMenu::Cursor&       cursor   ),
  &removeSubmenuAt ( IMenu::Cursor&       cursor   ),
  &add             ( IMenuItem&           menuItem,
                     IMenu::Cursor&       cursor   ),
  &addAsNext       ( IMenuItem&           menuItem,
                     IMenu::Cursor&       cursor   );

/*-------------------------------- Private -----------------------------------*/
friend class ISubmenu::Cursor;   //27045
void
  setUndoAddItem    ( unsigned long        itemId ),
  setUndoChangeItem ( const IMenuItem&     origItem );
unsigned long
  menuItemId        ( const Cursor&        cursor ) const;
#ifdef IC_MOTIF
IWindow
 *initialize        ( const IMenuHandle& submenuHandle );
#endif
IMenuHandle
  hwndHandle;
ISubmenuData
 *pItemList;

ISubmenuData
 *fSubmenuData;

bool
  fMenuWindowNewdInCtor;

IMenu*
  fMenuFromPriorMenuAttribute;

}; // ISubmenu

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ISUBMENU_ */
