










#ifndef _ISTRTEST_
#define _ISTRTEST_
/*----------------------------------------------------------------------------*/
/* FILE NAME: istrtest.hpp                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes:                                              */
/*     IStringTest                                                            */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#include <ibase.hpp>

extern "C"
  {

  typedef int _Optlink ICStrTestFn( int );




  }

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IStringTest {
public:

/*------------------------- Function Types -----------------------------------*/
typedef ICStrTestFn
  CFunction;
typedef bool
  CPPFunction( int );

/*------------------------- Constructors -------------------------------------*/
#ifdef _MSC_VER  /* David */
  IStringTest ( CFunction     cFunc );

  typedef bool _mscwcharfunc(unsigned short);
  IStringTest (_mscwcharfunc  cFunc )
  : type( c )     // MSVC can't find this if defined in istrtest.cpp!
  {
  data.cFn = (CFunction *) cFunc;
  }

#else
  IStringTest ( CFunction   &cFunc );
#endif

#ifdef IC_NOTYET
  IStringTest ( CPPFunction &cppFunc );   //Compiler doesn't support this yet.
#endif

virtual
 ~IStringTest ( );

/*------------------------- Testing ------------------------------------------*/
virtual bool
  test        ( int c ) const;

protected:
/*------------------------- Test Function Description ------------------------*/
enum FnType {
  user,
  c,
  cpp,
  memFn,
  cMemFn
  };

FnType
  type;

#ifdef IC_NOTYET
   union { CFunction *cFn; CPPFunction *cppFn; void *user; } data;
#else
   union { CFunction *cFn; void *user; } data;
#endif


/*------------------------ Protected Constructors ----------------------------*/
  IStringTest ( FnType  type,
                void   *userData );

}; // class IStringTest

template < class T >
class IC_EXPORTB IStringTestMemberFn : public IStringTest {
public:
/*------------------------- Function Types -----------------------------------*/
typedef bool
 ( T::*ConstFn )( int ) const;
typedef bool
 ( T::*NonconstFn )( int );

/*------------------------- Constructors -------------------------------------*/
  IStringTestMemberFn ( const T    &object,
                        ConstFn     constFn )
    : IStringTest ( cMemFn, (void*)&object ),
      cMF         ( constFn )
    {
    }
  IStringTestMemberFn ( T          &object,
                        NonconstFn  nonconstFn )
    : IStringTest ( user, (void*)&object ),
      ncMF        ( nonconstFn )
    {
    }

/*------------------------- Testing ------------------------------------------*/
virtual bool
  test                ( int c ) const
    {
    if ( this->type == cMemFn )
      return ((const T*)data.user->*cMF)( c );
    else
      return ((T*)data.user->*ncMF)( c );
    }

private:
/*------------------------------ Private ------------------------------------*/
union { ConstFn cMF; NonconstFn ncMF; };

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <istrtest.inl>

#endif // _ISTRTEST_






