// ----------------------------------------------------------------------------
//  FILE: istrmmod.hpp
//
//  This file defines the IStreamModule class.
//
//  COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation,  1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 85 1.18.1.4 source/core/streams/istrmmod.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _ISTRMMOD_
#define _ISTRMMOD_

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class ITypeName;
class ITypeRepresentation;
class IStreamableFactory;

#pragma pack(push,4)
#pragma enum(4)

class IStreamModule
{
public:
    IStreamModule(const char* moduleName);
    virtual ~IStreamModule();

private:
    IStreamModule();
    IStreamModule(const IStreamModule& other);

    const IStreamModule* next() const;
    const ITypeRepresentation* firstTypeRepresentation() const;

    friend class ITypeRepresentation;
    static const ITypeRepresentation* findTypeWithName(const ITypeName& typeName);

    friend class IStreamableFactory;
    void registerType(ITypeRepresentation* typeRepresentation);
    const char* name() const;

private:
    static IStreamModule* fgStreamModuleHead;
    static IStreamModule* fgStreamModuleTail;

    const char* fModuleName;
    IStreamModule* fNextStreamModule;
    ITypeRepresentation* fTypeRepHead;
    ITypeRepresentation* fTypeRepTail;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
