// ----------------------------------------------------------------------------
//  FILE: istrmexc.hpp
//
//  This file declares the exception classes thrown by streaming code.
//
//  COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation,  1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 94 1.12.1.4 source/core/streams/istrmexc.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _ISTRMEXC_
#define _ISTRMEXC_

#include <iexcbase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IInvalidDataOnStream : public IException
{
public:
    IInvalidDataOnStream(const char* text = 0, long errorID = 0, Severity severity = recoverable);
    IInvalidDataOnStream(const IInvalidDataOnStream& other);
    virtual ~IInvalidDataOnStream();

    virtual const char* name() const;

private:
    IInvalidDataOnStream& operator=(const IInvalidDataOnStream& other);
};

class IUnknownTypeOnStream : public IException
{
public:
    IUnknownTypeOnStream(const char* text = 0, long errorID = 0, Severity severity = recoverable);
    IUnknownTypeOnStream(const IUnknownTypeOnStream& other);
    virtual ~IUnknownTypeOnStream();

    virtual const char* name() const;

private:
    IUnknownTypeOnStream& operator=(const IUnknownTypeOnStream& other);
};

class IEndOfStream : public IInvalidRequest
{
public:
    IEndOfStream(const char* text = 0, long errorID = 0, Severity severity = recoverable);
    IEndOfStream(const IEndOfStream& other);
    virtual ~IEndOfStream();

    virtual const char* name() const;

private:
    IEndOfStream& operator=(const IEndOfStream& other);
};

class IAddressAlreadyInContext : public IException
{
public:
    IAddressAlreadyInContext(const char* text = 0, long errorID = 0, Severity severity = recoverable);
    IAddressAlreadyInContext(const IAddressAlreadyInContext& other);
    virtual ~IAddressAlreadyInContext();

    virtual const char* name() const;

private:
    IAddressAlreadyInContext& operator=(const IAddressAlreadyInContext& other);
};


class IInvalidContextNumber : public IException
{
public:
    IInvalidContextNumber(const char* text = 0, long errorID = 0, Severity severity = recoverable);
    IInvalidContextNumber(const IInvalidContextNumber& other);
    virtual ~IInvalidContextNumber();

    virtual const char* name() const;

private:
    IInvalidContextNumber& operator=(const IInvalidContextNumber& other);
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
