// ----------------------------------------------------------------------------
//  FILE: istrmcf.hpp
//
//  This file defines the IStreamContextFrame class.
//
//  COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation,  1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 73 1.16.1.4 source/core/streams/istrmcf.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _ISTRMCF_
#define _ISTRMCF_

#include <iprimtyp.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class IDataStream;
class IStreamIO;

#pragma pack(push,4)
#pragma enum(4)

class IStreamContextFrame
{
public:
    IStreamContextFrame(IDataStream& dataStream);
    ~IStreamContextFrame();

private:
    IStreamContextFrame();
    IStreamContextFrame(const IStreamContextFrame& other);
    IStreamContextFrame& operator=(const IStreamContextFrame& other);

private:
    IStreamIO*  fStreamIO;
    bool        fSetContext;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
