// ----------------------------------------------------------------------------
// FILE NAME: istream.hpp
//
// DESCRIPTION:
//   This file is used to conditionally compile stream support.
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 79 1.5.1.3 source/core/base/istream.hpp, appsupport, ioc.v400, 980918 
// ----------------------------------------------------------------------------
#ifndef _ISTREAM_
#define _ISTREAM_

#if (defined( _MSC_VER ))
    //Include Microsoft Stream Support.
    #include <iostream.h>

#elif (defined( __IBMR2__ ))
    // Include RS/6000 Stream support
    #include <stream.h>

#else
    // Include Default Stream support (IBM C++).
    #include <iostream.h>
#endif

#endif /* _ISTREAM_ */




