











#ifndef _ISTPARSE_
#define _ISTPARSE_
/*----------------------------------------------------------------------------*/
/* FILE NAME: istparse.hpp                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes:                                              */
/*     IStringParser                                                          */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IStringTest;
class IStringParserData;

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IStringParser {
public:

/*------------------------- Constructors -------------------------------------*/
 ~IStringParser ( );

/*------------------------- Commands -----------------------------------------*/
enum Command {
  reset,
  skipWord
};

class IC_EXPORTB SkipWords {
public:
  SkipWords     ( unsigned long numberOfWords = 1 );
unsigned long
  numberOfWords ( ) const;
private:
unsigned long
  fNumSkip;

};

IStringParser
 &operator >>   ( Command          command ),
 &operator >>   ( const SkipWords& skipObject );

/*------------------------- Initialize ---------------------------------------*/
friend IStringParser IC_EXPORTB
  operator >>   ( const IString& text,
                        IString& token );

friend IStringParser IC_EXPORTB
  operator >>   ( const IString& text,
                  const IString& pattern );
friend IStringParser IC_EXPORTB
  operator >>   ( const IString& text,
                  const char*    pattern );

friend IStringParser IC_EXPORTB
  operator >>   ( const IString& text,
                  char           pattern );

friend IStringParser IC_EXPORTB
  operator >>   ( const IString& text,
                  unsigned long  position );
friend IStringParser IC_EXPORTB
  operator >>   ( const IString& text,
                  int            position );

friend IStringParser IC_EXPORTB
  operator <<   ( const IString& text,
                  unsigned long  position );

friend IStringParser IC_EXPORTB
  operator >>   ( const IString&     text,
                  const IStringTest& test );

friend IStringParser IC_EXPORTB
  operator >>   ( const IString&         text,
                  IStringParser::Command command );

friend IStringParser IC_EXPORTB
  operator >>   ( const IString&                  text,
                  const IStringParser::SkipWords& skipObject );

/*------------------------- Tokenizing ---------------------------------------*/
IStringParser
 &operator >>   ( IString& token );

/*------------------------- Pattern Matching ---------------------------------*/
IStringParser
 &operator >>   ( const IString&     pattern ),
 &operator >>   ( const char*        pattern ),
 &operator >>   ( char               pattern ),
 &operator >>   ( const IStringTest& test );

/*----------------------- Relative Column Positioning ------------------------*/
IStringParser
 &operator >>   ( int           delta ),
 &operator >>   ( unsigned long delta );

/*----------------------- Absolute Column Positioning ------------------------*/
IStringParser
 &operator <<   ( unsigned long position );


protected:
/*------------------------- Protected Constructors ---------------------------*/
  IStringParser ( const IString&       text );
  IStringParser ( const IStringParser& parser );


/*------------------------- Private ------------------------------------------*/
private:
IStringParserData
 *fData;

}; // class IStringParser

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ISTPARSE_




