// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 76 1.5.1.4 source/core/collect/istktab.h, collection, ioc.v400, 980918 
#ifndef _ISTKTAB_
#define _ISTKTAB_

#include <ilanglvl.hpp>
#include <iastk.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGStackAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGStackAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGStackAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackAsTableCursor
                            (IGStackAsTable
                              <
                               Element, ElementOps> const&);

  IGStackAsTableCursor <Element, ElementOps>&
           operator=        (IGStackAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGStackAsTable :
  public IAStack <Element> {
protected:

  typedef  IGStackAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackAsTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGStackAsTableCursor
            <Element, ElementOps> Cursor;




           IGStackAsTable
                            (INumber = 100);

           IGStackAsTable
                            (IGStackAsTable
                              <
                               Element, ElementOps> const&);

  IGStackAsTable <Element, ElementOps>&
           operator=        (IGStackAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGStackAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStackAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class IStackAsTable :
  public IGStackAsTable
          <Element, IStdOps <Element> > {

  typedef  IGStackAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IStackAsTable <Element> Self;

#define IStackAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IStackAsTable
                            (INumber = 100);

















protected:

           IStackAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGStackAsTable :
  public IGStackAsTable
          <Element, ElementOps > {

  typedef  IVGStackAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGStackAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackAsTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGStackAsTable
                            (INumber = 100);

















protected:

           IVGStackAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVStackAsTable :
  public IVGStackAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGStackAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVStackAsTable <Element> Self;

#define IVStackAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVStackAsTable
                            (INumber = 100);

















protected:

           IVStackAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <istktab.inl>


#pragma info (restore)


#endif // _ISTKTAB_
