// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 74 1.5.1.4 source/core/collect/istklst.h, collection, ioc.v400, 980918 
#ifndef _ISTKLST_
#define _ISTKLST_

#include <ilanglvl.hpp>
#include <iastk.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGStackAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGStackAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGStackAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackAsListCursor
                            (IGStackAsList
                              <
                               Element, ElementOps> const&);

  IGStackAsListCursor <Element, ElementOps>&
           operator=        (IGStackAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGStackAsList :
  public IAStack <Element> {
protected:

  typedef  IGStackAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackAsListTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGStackAsListCursor
            <Element, ElementOps> Cursor;




           IGStackAsList
                            (INumber = 100);

           IGStackAsList
                            (IGStackAsList
                              <
                               Element, ElementOps> const&);

  IGStackAsList <Element, ElementOps>&
           operator=        (IGStackAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGStackAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStackAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackAsListCursor <Element, ElementOps>;






















};

template <class Element>
class IStackAsList :
  public IGStackAsList
          <Element, IStdOps <Element> > {

  typedef  IGStackAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IStackAsList <Element> Self;

#define IStackAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IStackAsList
                            (INumber = 100);

















protected:

           IStackAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGStackAsList :
  public IGStackAsList
          <Element, ElementOps > {

  typedef  IVGStackAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGStackAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackAsListTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGStackAsList
                            (INumber = 100);

















protected:

           IVGStackAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVStackAsList :
  public IVGStackAsList
          <Element, IStdOps <Element> > {

  typedef  IVGStackAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVStackAsList <Element> Self;

#define IVStackAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVStackAsList
                            (INumber = 100);

















protected:

           IVStackAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <istklst.inl>


#pragma info (restore)


#endif // _ISTKLST_
