// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 71 1.5.1.4 source/core/collect/istkdil.h, collection, ioc.v400, 980918 
#ifndef _ISTKDIL_
#define _ISTKDIL_

#include <ilanglvl.hpp>
#include <iastk.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGStackAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGStackAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGStackAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackAsDilTableCursor
                            (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);

  IGStackAsDilTableCursor <Element, ElementOps>&
           operator=        (IGStackAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGStackAsDilTable :
  public IAStack <Element> {
protected:

  typedef  IGStackAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackAsDilTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGStackAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGStackAsDilTable
                            (INumber = 100);

           IGStackAsDilTable
                            (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);

  IGStackAsDilTable <Element, ElementOps>&
           operator=        (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGStackAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class IStackAsDilTable :
  public IGStackAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGStackAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IStackAsDilTable <Element> Self;

#define IStackAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IStackAsDilTable
                            (INumber = 100);

















protected:

           IStackAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGStackAsDilTable :
  public IGStackAsDilTable
          <Element, ElementOps > {

  typedef  IVGStackAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGStackAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackAsDilTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGStackAsDilTable
                            (INumber = 100);

















protected:

           IVGStackAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVStackAsDilTable :
  public IVGStackAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGStackAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVStackAsDilTable <Element> Self;

#define IVStackAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVStackAsDilTable
                            (INumber = 100);

















protected:

           IVStackAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <istkdil.inl>


#pragma info (restore)


#endif // _ISTKDIL_
