// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 69 1.5.1.4 source/core/collect/istk.h, collection, ioc.v400, 980918 
#ifndef _ISTK_
#define _ISTK_

#include <ilanglvl.hpp>
#include <iastk.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGStack;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGStackCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGStack
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackCursor
                            (IGStack
                              <
                               Element, ElementOps> const&);

  IGStackCursor <Element, ElementOps>&
           operator=        (IGStackCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGStack :
  public IAStack <Element> {
protected:

  typedef  IGStack <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGStackCursor
            <Element, ElementOps> Cursor;




           IGStack
                            (INumber = 100);

           IGStack
                            (IGStack
                              <
                               Element, ElementOps> const&);

  IGStack <Element, ElementOps>&
           operator=        (IGStack
                              <
                               Element, ElementOps> const&);



















protected:

           IGStack
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStack
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackCursor <Element, ElementOps>;






















};

template <class Element>
class IStack :
  public IGStack
          <Element, IStdOps <Element> > {

  typedef  IGStack
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IStack <Element> Self;

#define IStackTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IStack
                            (INumber = 100);

















protected:

           IStack
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGStack :
  public IGStack
          <Element, ElementOps > {

  typedef  IVGStack
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGStack
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGStack
                            (INumber = 100);

















protected:

           IVGStack
                              (PureImplementation&);

private:












};

template <class Element>
class IVStack :
  public IVGStack
          <Element, IStdOps <Element> > {

  typedef  IVGStack
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVStack <Element> Self;

#define IVStackTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVStack
                            (INumber = 100);

















protected:

           IVStack
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <istk.inl>


#pragma info (restore)


#endif // _ISTK_
