// ----------------------------------------------------------------------------
// FILE NAME: istdntfy.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IStandardNotifier
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.
//
// Revision: 74 1.7.1.4 source/core/base/istdntfy.hpp, notification, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _ISTDNTFY_
#define _ISTDNTFY_

#include <inotify.hpp>
#include <iobslist.hpp>
#include <ievtdata.hpp>
#include <iintrst.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IObserverList;
class IObserver;
class INotificationEvent;
class INotifierImplementation;

#pragma pack(push,4)
#pragma enum(4)

class IStandardNotifier : public INotifier
{
    typedef INotifier Inherited;

public:
    // ---------------------------- Constructors ------------------------------
                            IStandardNotifier();
                            IStandardNotifier(const IStandardNotifier& copy);
    IStandardNotifier&      operator=(const IStandardNotifier& aStandardNotifier);

    virtual                 ~IStandardNotifier();

    // ---------------------- Notification Members ----------------------------
    virtual IStandardNotifier& enableNotification(bool enable = true);
    virtual IStandardNotifier& disableNotification();

    virtual bool            isEnabledForNotification() const;

    virtual INotifierAddress notifierAddress() const;

    // ---------------------------- Observer Notification ---------------------
    virtual IStandardNotifier& notifyObservers(const INotificationEvent& anEvent);
    virtual IStandardNotifier& notifyObserversAsync(const INotificationEvent& anEvent);

protected:
    // -------------------------- Observer Addition and Removal ---------------
    virtual IStandardNotifier& addObserver(IObserver& observer, const IInterest& interest);
    virtual IStandardNotifier& removeObserver(IObserver& observer);
    virtual IStandardNotifier& removeObserver(IObserver& observer, const IInterest& interest);
    virtual IStandardNotifier& removeAllObservers();

    virtual IObserverList&  observerList(const IInterest* anInterest = 0) const;

    // ---------------------------- Observer Notification ---------------------
    virtual IStandardNotifier& notifyObservers(const INotificationId& nId);

private:
    // --------------------------------- Private ------------------------------
    INotifierImplementation*    notifierImp(bool create = true);
    INotifierImplementation*    notifierImp(bool create = true) const;

    bool    enabled;

    INotifierImplementation*    fNotifierImp;

    // ----------------------- Obsolete Data and Functions --------------------
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
    virtual IStandardNotifier&  addObserver(IObserver& observer,
                                            const IEventData& userData = IEventData(0));
#endif // IC_OBSOLETE
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
