// Revision: 81 1.8.1.6 source/ui/basectl/istattxt.hpp, staticctls, ioc.v400, 980918 
#ifndef _ISTATTXT_
  #define _ISTATTXT_
/*******************************************************************************
* FILE NAME: istattxt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStaticText                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <icolor.hpp>
#include <irect.hpp>
#ifdef IC_WIN
#include <ihandler.hpp>
#endif //IC_WIN

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class IStaticTextHandler;
class IStaticTextData;
class IStaticHandler;

#pragma enum(4)
#pragma pack(push,4)

class IStaticText : public ITextControl {
typedef ITextControl
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IStaticText ( unsigned long        id,
                IWindow*             parent,
                IWindow*             owner,
                const IRectangle&    initial = IRectangle(),
                const Style&         style   = defaultStyle() );

  IStaticText ( unsigned long        id,
                IWindow*             parent );

  IStaticText ( const IWindowHandle& handle );

virtual
 ~IStaticText ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2 ( Style,
                          IStaticText,
                          IWindow,
                          IControl );
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU left,
  IC_IMPORTU center,
  IC_IMPORTU right,
  IC_IMPORTU wordBreak,
  IC_IMPORTU mnemonic,
  IC_IMPORTU top,
  IC_IMPORTU vertCenter,
  IC_IMPORTU bottom,
  IC_IMPORTU halftone,
  IC_IMPORTU underscore,
  IC_IMPORTU strikeout,
  IC_IMPORTU fillBackground,
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

#ifdef IC_PMWIN
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;
#endif

/*------------------------------- Alignment ----------------------------------*/
enum Alignment {
  topLeft,
  topLeftWrapped,
  topCenter,
  topRight,
  centerLeft,
  centerCenter,
  centerRight,
  bottomLeft,
  bottomCenter,
  bottomRight
};

virtual IStaticText
 &setAlignment ( Alignment alignment = IStaticText::topLeft );

Alignment
  alignment    ( ) const;

#ifndef IC_MOTIF_FLAGNOP
/*------------------------- Style Functions ----------------------------------*/
virtual IStaticText
 &enableStrikeout       ( bool enable = true ),
 &disableStrikeout      ( ),
 &enableUnderscore      ( bool enable = true ),
 &disableUnderscore     ( ),
 &enableHalftone        ( bool enable = true ),
 &disableHalftone       ( ),
 &enableFillBackground  ( bool enable = true ),
 &disableFillBackground ( );

bool
  isStrikeout           ( ) const,
  isUnderscore          ( ) const,
  isHalftone            ( ) const,
  hasFillBackground     ( ) const;
#endif //IC_MOTIF_FLAGNOP

/*---------------------------------- Colors ----------------------------------*/
#ifdef IC_PMWIN
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;
#endif //IC_PMWIN

virtual IColor
  fillColor       ( ) const;

virtual IStaticText
 &setFillColor    ( const IColor& color ),
 &resetFillColor  ( );

/*-------------------------- Minimum Size Adjustment -------------------------*/
virtual IStaticText
 &setLimit ( unsigned long limit = 0 );

unsigned long
  limit    ( ) const;

/*------------------------------ Text Processing -----------------------------*/
virtual IStaticText
 &setText ( const char*        text ),
 &setText ( const IResourceId& text );

#ifdef IC_MOTIF
virtual IString
  text                   ( ) const;
#endif //IC_MOTIF

#ifndef IC_MOTIF_FLAGNOP
/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU strikeoutId,
  IC_IMPORTU underscoreId,
  IC_IMPORTU halftoneId,
  IC_IMPORTU fillColorId,
  IC_IMPORTU fillBackgroundId,
  IC_IMPORTU limitId;
#endif //IC_MOTIF_FLAGNOP

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const,
  calcLimitSize   ( ) const;

#ifdef IC_WIN
/*---------------------- Bidirectional Language Support ----------------------*/
virtual IStaticText
 &setBidiSettings ( const IBidiSettings& bidiSettings,
                    bool                 childInherit,
                    bool                 refresh );
#endif

/*---------------------- Event-Handling Implementation -----------------------*/
#ifdef IC_MOTIF
virtual bool
  passEventToOwner( IEvent& event );
#endif

#ifdef IC_PMWIN
IStaticText
 &addDrawingHandler( );
#endif

private:
/*------------------------------ Hidden Members ------------------------------*/
  IStaticText ( const IStaticText& );
IStaticText
 &operator=   ( const IStaticText& );

void
  notify      ( INotificationId nId,
                bool enabled );

/*--------------------------------- Private ----------------------------------*/
friend class IStaticTextHandler;
#ifdef IC_WIN
friend class IStaticHandler;
#endif //IC_WIN

static Style
  currentDefaultStyle;

unsigned long
  ulClLimit;

IStaticTextData
 *fStaticTextData;

}; // class IStaticText

INESTEDBITFLAGCLASSFUNCS(Style, IStaticText)
                                  // global style functions

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

/*--------------------------------- Inlines ----------------------------------*/
#include <istattxt.inl>

#endif  // _ISTATTXT_
