// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 64 1.5.1.4 source/core/collect/isstab.h, collection, ioc.v400, 980918 
#ifndef _ISSTAB_
#define _ISSTAB_

#include <ilanglvl.hpp>
#include <iass.h>
#include <iicss.h>

#include <iivss.h>

#include <iisstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedSetAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedSetAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedSetAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsTableCursor
                            (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsTableCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedSetAsTable :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsTable <Element, ElementOps> Self;

  typedef  ISortedSetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedSetAsTableCursor
            <Element, ElementOps> Cursor;




           IGSortedSetAsTable
                            (INumber = 100);

           IGSortedSetAsTable
                            (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsTable <Element, ElementOps>&
           operator=        (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedSetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedSetAsTable :
  public IGSortedSetAsTable
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedSetAsTable <Element> Self;

#define ISortedSetAsTableTypedef(Element)\
  typedef  ISortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedSetAsTable
                            (INumber = 100);

















protected:

           ISortedSetAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedSetAsTable :
  public IGSortedSetAsTable
          <Element, ElementOps > {

  typedef  IVGSortedSetAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedSetAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedSetAsTable
                            (INumber = 100);

















protected:

           IVGSortedSetAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedSetAsTable :
  public IVGSortedSetAsTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedSetAsTable <Element> Self;

#define IVSortedSetAsTableTypedef(Element)\
  typedef  IVSortedSetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedSetAsTable
                            (INumber = 100);

















protected:

           IVSortedSetAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isstab.inl>


#pragma info (restore)


#endif // _ISSTAB_
