// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 59 1.5.1.4 source/core/collect/isslst.h, collection, ioc.v400, 980918 
#ifndef _ISSLST_
#define _ISSLST_

#include <ilanglvl.hpp>
#include <iass.h>
#include <iicss.h>

#include <iivss.h>

#include <iisslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedSetAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedSetAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedSetAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsListCursor
                            (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsListCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedSetAsList :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsList <Element, ElementOps> Self;

  typedef  ISortedSetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsListTypedef(Element, ElementOps)\
  typedef  ISortedSetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedSetAsListCursor
            <Element, ElementOps> Cursor;




           IGSortedSetAsList
                            (INumber = 100);

           IGSortedSetAsList
                            (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsList <Element, ElementOps>&
           operator=        (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedSetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsListCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedSetAsList :
  public IGSortedSetAsList
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedSetAsList <Element> Self;

#define ISortedSetAsListTypedef(Element)\
  typedef  ISortedSetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedSetAsList
                            (INumber = 100);

















protected:

           ISortedSetAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedSetAsList :
  public IGSortedSetAsList
          <Element, ElementOps > {

  typedef  IVGSortedSetAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedSetAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsListTypedef(Element, ElementOps)\
  typedef  ISortedSetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedSetAsList
                            (INumber = 100);

















protected:

           IVGSortedSetAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedSetAsList :
  public IVGSortedSetAsList
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedSetAsList <Element> Self;

#define IVSortedSetAsListTypedef(Element)\
  typedef  IVSortedSetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedSetAsList
                            (INumber = 100);

















protected:

           IVSortedSetAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <isslst.inl>


#pragma info (restore)


#endif // _ISSLST_
