// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 57 1.5.1.4 source/core/collect/issdil.h, collection, ioc.v400, 980918 
#ifndef _ISSDIL_
#define _ISSDIL_

#include <ilanglvl.hpp>
#include <iass.h>
#include <iicss.h>

#include <iivss.h>

#include <iissdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGSortedSetAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGSortedSetAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGSortedSetAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsDilTableCursor
                            (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGSortedSetAsDilTable :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsDilTable <Element, ElementOps> Self;

  typedef  ISortedSetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGSortedSetAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGSortedSetAsDilTable
                            (INumber = 100);

           IGSortedSetAsDilTable
                            (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsDilTable <Element, ElementOps>&
           operator=        (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGSortedSetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class ISortedSetAsDilTable :
  public IGSortedSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  ISortedSetAsDilTable <Element> Self;

#define ISortedSetAsDilTableTypedef(Element)\
  typedef  ISortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           ISortedSetAsDilTable
                            (INumber = 100);

















protected:

           ISortedSetAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGSortedSetAsDilTable :
  public IGSortedSetAsDilTable
          <Element, ElementOps > {

  typedef  IVGSortedSetAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGSortedSetAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGSortedSetAsDilTable
                            (INumber = 100);

















protected:

           IVGSortedSetAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVSortedSetAsDilTable :
  public IVGSortedSetAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVSortedSetAsDilTable <Element> Self;

#define IVSortedSetAsDilTableTypedef(Element)\
  typedef  IVSortedSetAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVSortedSetAsDilTable
                            (INumber = 100);

















protected:

           IVSortedSetAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <issdil.inl>


#pragma info (restore)


#endif // _ISSDIL_
